# Код статусу відповіді { #response-status-code }

Так само, як ви можете вказати модель відповіді, ви також можете оголосити HTTP код статусу, що використовується для відповіді, за допомогою параметра `status_code` в будь-якій з *операцій шляху*:

* `@app.get()`
* `@app.post()`
* `@app.put()`
* `@app.delete()`
* тощо.

{* ../../docs_src/response_status_code/tutorial001_py310.py hl[6] *}

/// note | Примітка

Зверніть увагу, що `status_code` є параметром методу «декоратора» (`get`, `post`, тощо). Не вашої *функції операції шляху*, як усі параметри та тіло.

///

Параметр `status_code` приймає число з HTTP кодом статусу.

/// info | Інформація

`status_code` також може, як альтернативу, приймати `IntEnum`, наприклад, Python <a href="https://docs.python.org/3/library/http.html#http.HTTPStatus" class="external-link" target="_blank">`http.HTTPStatus`</a>.

///

Він буде:

* Повертати цей код статусу у відповіді.
* Документувати його як такий у схемі OpenAPI (і, таким чином, в інтерфейсах користувача):

<img src="/img/tutorial/response-status-code/image01.png">

/// note | Примітка

Деякі коди відповіді (див. наступний розділ) вказують, що відповідь не має тіла.

FastAPI знає про це і створить документацію OpenAPI, яка вказує, що тіла відповіді немає.

///

## Про HTTP коди статусу { #about-http-status-codes }

/// note | Примітка

Якщо ви вже знаєте, що таке HTTP коди статусу, перейдіть до наступного розділу.

///

В HTTP ви надсилаєте числовий код статусу з 3 цифр як частину відповіді.

Ці коди статусу мають пов’язану назву для їх розпізнавання, але важливою частиною є число.

Коротко:

* `100 - 199` — для «Information». Ви рідко використовуєте їх напряму. Відповіді з такими кодами статусу не можуть мати тіла.
* **`200 - 299`** — для «Successful» відповідей. Це ті, які ви використовуватимете найчастіше.
    * `200` — код статусу за замовчуванням, який означає, що все було «OK».
    * Інший приклад — `201`, «Created». Його зазвичай використовують після створення нового запису в базі даних.
    * Особливий випадок — `204`, «No Content». Цю відповідь використовують, коли немає вмісту для повернення клієнту, і тому відповідь не повинна мати тіла.
* **`300 - 399`** — для «Redirection». Відповіді з цими кодами статусу можуть мати або не мати тіла, за винятком `304`, «Not Modified», яка не повинна мати тіла.
* **`400 - 499`** — для відповідей «Client error». Це другий тип, який ви, ймовірно, будете використовувати найчастіше.
    * Приклад — `404`, для відповіді «Not Found».
    * Для загальних помилок з боку клієнта ви можете просто використовувати `400`.
* `500 - 599` — для помилок сервера. Ви майже ніколи не використовуєте їх напряму. Коли щось піде не так у якійсь частині коду вашого застосунку або на сервері, автоматично буде повернено один із цих кодів статусу.

/// tip | Порада

Щоб дізнатися більше про кожен код статусу і для чого призначений кожен із них, перегляньте документацію <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Status" class="external-link" target="_blank"><abbr title="Mozilla Developer Network - Мережа Розробників Mozilla">MDN</abbr> про HTTP коди статусу</a>.

///

## Скорочення, щоб запам’ятати назви { #shortcut-to-remember-the-names }

Розглянемо попередній приклад ще раз:

{* ../../docs_src/response_status_code/tutorial001_py310.py hl[6] *}

`201` — це код статусу для «Created».

Але вам не потрібно запам'ятовувати, що означає кожен із цих кодів.

Ви можете використовувати зручні змінні з `fastapi.status`.

{* ../../docs_src/response_status_code/tutorial002_py310.py hl[1,6] *}

Вони — просто для зручності, містять те саме число, але так ви можете скористатися автозаповненням редактора, щоб знайти їх:

<img src="/img/tutorial/response-status-code/image02.png">

/// note | Технічні деталі

Ви також можете використати `from starlette import status`.

**FastAPI** надає той самий `starlette.status` як `fastapi.status` просто як зручність для вас, розробника. Але він походить безпосередньо зі Starlette.

///

## Зміна значення за замовчуванням { #changing-the-default }

Пізніше, у [Посібнику для досвідчених користувачів](../advanced/response-change-status-code.md){.internal-link target=_blank}, ви побачите, як повертати інший код статусу, ніж значення за замовчуванням, яке ви оголошуєте тут.
