# Декларування прикладів вхідних даних { #declare-request-example-data }

Ви можете задати приклади даних, які Ваш застосунок може отримувати.

Ось кілька способів, як це зробити.

## Додаткові дані JSON-схеми в моделях Pydantic { #extra-json-schema-data-in-pydantic-models }

Ви можете задати `examples` для моделі Pydantic, які буде додано до згенерованої JSON-схеми.

{* ../../docs_src/schema_extra_example/tutorial001_py310.py hl[13:24] *}

Ця додаткова інформація буде додана як є до **JSON-схеми** для цієї моделі, і вона буде використана в документації до API.

Ви можете використати атрибут `model_config`, який приймає `dict`, як описано в <a href="https://docs.pydantic.dev/latest/api/config/" class="external-link" target="_blank">документації Pydantic: Configuration</a>.

Ви можете встановити `"json_schema_extra"` як `dict`, що містить будь-які додаткові дані, які Ви хочете відобразити у згенерованій JSON-схемі, включаючи `examples`.

/// tip | Порада

Ви можете використати ту ж техніку, щоб розширити JSON-схему і додати власну додаткову інформацію.

Наприклад, Ви можете використати її для додавання метаданих для інтерфейсу користувача на фронтенді тощо.

///

/// info | Інформація

OpenAPI 3.1.0 (який використовується починаючи з FastAPI 0.99.0) додав підтримку `examples`, що є частиною стандарту **JSON-схеми**.

До цього підтримувався лише ключ `example` з одним прикладом. Він все ще підтримується в OpenAPI 3.1.0, але є застарілим і не входить до стандарту JSON Schema. Тому рекомендується перейти з `example` на `examples`. 🤓

Більше про це можна прочитати в кінці цієї сторінки.

///

## Додаткові аргументи `Field` { #field-additional-arguments }

Коли ви використовуєте `Field()` у моделях Pydantic, Ви також можете вказати додаткові `examples`:

{* ../../docs_src/schema_extra_example/tutorial002_py310.py hl[2,8:11] *}

## `examples` у JSON-схемі - OpenAPI { #examples-in-json-schema-openapi }

При використанні будь-кого з наступного:

* `Path()`
* `Query()`
* `Header()`
* `Cookie()`
* `Body()`
* `Form()`
* `File()`

Ви також можете задати набір `examples` з додатковою інформацією, яка буде додана до їхніх **JSON-схем** у **OpenAPI**.

### `Body` з `examples` { #body-with-examples }

Тут ми передаємо `examples`, які містять один приклад очікуваних даних у `Body()`:

{* ../../docs_src/schema_extra_example/tutorial003_an_py310.py hl[22:29] *}

### Приклад у UI документації { #example-in-the-docs-ui }

За допомогою будь-якого з наведених вище методів це виглядатиме так у `/docs`:

<img src="/img/tutorial/body-fields/image01.png">

### `Body` з кількома `examples` { #body-with-multiple-examples }

Звичайно, Ви також можете передати кілька `examples`:

{* ../../docs_src/schema_extra_example/tutorial004_an_py310.py hl[23:38] *}

Коли Ви це робите, приклади будуть частиною внутрішньої **JSON-схеми** для цих даних тіла.

Втім, на <dfn title="2023-08-26">час написання цього</dfn>, Swagger UI — інструмент, який відповідає за відображення UI документації — не підтримує показ кількох прикладів для даних у **JSON-схемі**. Але нижче можна прочитати про обхідний шлях.

### Специфічні для OpenAPI `examples` { #openapi-specific-examples }

Ще до того, як **JSON-схема** почала підтримувати `examples`, OpenAPI вже мала підтримку іншого поля, яке також називається `examples`.

Це **специфічне для OpenAPI** поле `examples` розміщується в іншому розділі специфікації OpenAPI. Воно розміщується в **деталях кожної *операції шляху***, а не всередині кожної JSON-схеми.

І Swagger UI вже давно підтримує це поле `examples`. Тому Ви можете використовувати його, щоб **відображати** різні **приклади в UI документації**.

Форма цього специфічного для OpenAPI поля `examples` — це `dict` з **кількома прикладами** (а не `list`), кожен із яких має додаткову інформацію, яка також буде додана до **OpenAPI**.

Воно не включається всередину кожної JSON-схеми, що міститься в OpenAPI, воно розміщується зовні, безпосередньо в *операції шляху*.

### Використання параметра `openapi_examples` { #using-the-openapi-examples-parameter }

Ви можете оголосити специфічні для OpenAPI `examples` у FastAPI за допомогою параметра `openapi_examples` для:

* `Path()`
* `Query()`
* `Header()`
* `Cookie()`
* `Body()`
* `Form()`
* `File()`

Ключі `dict` ідентифікують кожен приклад, а кожне значення — це інший `dict`.

Кожен специфічний `dict` прикладу в `examples` може містити:

* `summary`: короткий опис прикладу.
* `description`: розгорнутий опис, який може містити Markdown.
* `value`: це сам приклад, який буде показано, наприклад `dict`.
* `externalValue`: альтернатива `value`, URL-адреса, що вказує на приклад. Проте це може не підтримуватися такою кількістю інструментів, як `value`.

Використання виглядає так:

{* ../../docs_src/schema_extra_example/tutorial005_an_py310.py hl[23:49] *}

### Приклади OpenAPI в UI документації { #openapi-examples-in-the-docs-ui }

З `openapi_examples`, доданим до `Body()`, `/docs` виглядатиме так:

<img src="/img/tutorial/body-fields/image02.png">

## Технічні деталі { #technical-details }

/// tip | Порада

Якщо Ви вже використовуєте **FastAPI** версії **0.99.0 або вище**, Ви, ймовірно, можете **пропустити** ці технічні деталі.

Вони більш актуальні для старих версій, до появи OpenAPI 3.1.0.

Можна вважати це коротким **історичним екскурсом** у OpenAPI та JSON Schema. 🤓

///

/// warning | Попередження

Це дуже технічна інформація про стандарти **JSON Schema** і **OpenAPI**.

Якщо вищезгадані ідеї вже працюють у Вас, цього може бути достатньо, і Вам, ймовірно, не потрібні ці деталі — можете пропустити.

///

До OpenAPI 3.1.0 OpenAPI використовував стару та модифіковану версію **JSON Schema**.

JSON Schema не мала `examples`, тож OpenAPI додала власне поле `example` до своєї модифікованої версії.

OpenAPI також додала поля `example` і `examples` до інших частин специфікації:

* <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.0.md#parameter-object" class="external-link" target="_blank">`Parameter Object` (в специфікації)</a>, який використовувався утилітами FastAPI:
    * `Path()`
    * `Query()`
    * `Header()`
    * `Cookie()`
* <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.0.md#media-type-object" class="external-link" target="_blank">`Request Body Object`, у полі `content`, у `Media Type Object` (в специфікації)</a>, який використовувався утилітами FastAPI:
    * `Body()`
    * `File()`
    * `Form()`

/// info | Інформація

Цей старий специфічний для OpenAPI параметр `examples` тепер називається `openapi_examples`, починаючи з FastAPI `0.103.0`.

///

### Поле `examples` у JSON Schema { #json-schemas-examples-field }

Пізніше JSON Schema додала поле <a href="https://json-schema.org/draft/2019-09/json-schema-validation.html#rfc.section.9.5" class="external-link" target="_blank">`examples`</a> у нову версію специфікації.

А потім новий OpenAPI 3.1.0 базувався на найновішій версії (JSON Schema 2020-12), яка включала це нове поле `examples`.

І тепер це нове поле `examples` має вищий пріоритет за старе одиночне (і кастомне) поле `example`, яке тепер є застарілим.

Це нове поле `examples` у JSON Schema — це **просто `list`** прикладів, а не `dict` з додатковими метаданими, як в інших місцях OpenAPI (описаних вище).

/// info | Інформація

Навіть після релізу OpenAPI 3.1.0 з цією новою простішою інтеграцією з JSON Schema, протягом певного часу Swagger UI, інструмент, який надає автоматичну документацію, не підтримував OpenAPI 3.1.0 (тепер підтримує, починаючи з версії 5.0.0 🎉).

Через це версії FastAPI до 0.99.0 все ще використовували версії OpenAPI нижчі за 3.1.0.

///

### `examples` у Pydantic і FastAPI { #pydantic-and-fastapi-examples }

Коли Ви додаєте `examples` у модель Pydantic через `schema_extra` або `Field(examples=["something"])`, цей приклад додається до **JSON Schema** для цієї моделі Pydantic.

І ця **JSON Schema** Pydantic-моделі включається до **OpenAPI** Вашого API, а потім використовується в UI документації.

У версіях FastAPI до 0.99.0 (0.99.0 і вище використовують новіший OpenAPI 3.1.0), коли Ви використовували `example` або `examples` з будь-якими іншими утилітами (`Query()`, `Body()` тощо), ці приклади не додавалися до JSON Schema, що описує ці дані (навіть не до власної версії JSON Schema в OpenAPI), натомість вони додавалися безпосередньо до декларації *операції шляху* в OpenAPI (поза межами частин OpenAPI, які використовують JSON Schema).

Але тепер, коли FastAPI 0.99.0 і вище використовує OpenAPI 3.1.0, який використовує JSON Schema 2020-12, і Swagger UI 5.0.0 і вище, все стало більш узгодженим, і приклади включаються до JSON Schema.

### Swagger UI та специфічні для OpenAPI `examples` { #swagger-ui-and-openapi-specific-examples }

Оскільки Swagger UI не підтримував кілька прикладів JSON Schema (станом на 2023-08-26), користувачі не мали можливості показати кілька прикладів у документації.

Щоб вирішити це, FastAPI `0.103.0` **додав підтримку** оголошення того самого старого **OpenAPI-специфічного** поля `examples` через новий параметр `openapi_examples`. 🤓

### Підсумок { #summary }

Раніше я казав, що не дуже люблю історію... а тепер подивіться на мене — читаю «технічні історичні» лекції. 😅

Коротко: **оновіться до FastAPI 0.99.0 або вище** — і все стане значно **простішим, узгодженим та інтуїтивно зрозумілим**, і Вам не доведеться знати всі ці історичні деталі. 😎
