# Данные формы { #form-data }

Когда вам нужно получить поля формы вместо JSON, вы можете использовать `Form`.

/// info | Дополнительная информация

Чтобы использовать формы, сначала установите <a href="https://github.com/Kludex/python-multipart" class="external-link" target="_blank">`python-multipart`</a>.

Убедитесь, что вы создали [виртуальное окружение](../virtual-environments.md){.internal-link target=_blank}, активировали его, а затем установили пакет, например:

```console
$ pip install python-multipart
```

///

## Импорт `Form` { #import-form }

Импортируйте `Form` из `fastapi`:

{* ../../docs_src/request_forms/tutorial001_an_py310.py hl[3] *}

## Определение параметров `Form` { #define-form-parameters }

Создайте параметры формы так же, как это делается для `Body` или `Query`:

{* ../../docs_src/request_forms/tutorial001_an_py310.py hl[9] *}

Например, в одном из способов использования спецификации OAuth2 (называемом «password flow» - аутентификация по паролю) требуется отправить `username` и `password` в виде полей формы.

<dfn title="спецификация">спецификация</dfn> требует, чтобы поля были строго названы `username` и `password` и отправлялись как поля формы, а не JSON.

С помощью `Form` вы можете объявить те же настройки, что и с `Body` (и `Query`, `Path`, `Cookie`), включая валидацию, примеры, псевдоним (например, `user-name` вместо `username`) и т.д.

/// info | Дополнительная информация

`Form` — это класс, который наследуется непосредственно от `Body`.

///

/// tip | Подсказка

Чтобы объявлять данные формы, вам нужно явно использовать `Form`, иначе параметры будут интерпретированы как параметры запроса или параметры тела (JSON).

///

## О «полях формы» { #about-form-fields }

Обычно способ, которым HTML-формы (`<form></form>`) отправляют данные на сервер, использует «специальное» кодирование для этих данных, отличное от JSON.

**FastAPI** гарантирует, что эти данные будут прочитаны из нужного места, а не из JSON.

/// note | Технические детали

Данные из форм обычно кодируются с использованием «типа содержимого» `application/x-www-form-urlencoded`.

Но когда форма содержит файлы, она кодируется как `multipart/form-data`. О работе с файлами вы прочтёте в следующей главе.

Если вы хотите узнать больше про эти кодировки и поля формы, обратитесь к <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/POST" class="external-link" target="_blank"><abbr title="Mozilla Developer Network - Сеть разработчиков Mozilla">MDN</abbr> веб-документации для `POST`</a>.

///

/// warning | Предупреждение

Вы можете объявлять несколько параметров `Form` в *операции пути*, но вы не можете одновременно объявлять поля `Body`, которые вы ожидаете получить в виде JSON, так как запрос будет иметь тело, закодированное с использованием `application/x-www-form-urlencoded`, а не `application/json`.

Это не ограничение **FastAPI**, это часть протокола HTTP.

///

## Резюме { #recap }

Используйте `Form` для объявления входных параметров данных формы.
