# Повернення Response безпосередньо { #return-a-response-directly }

Коли ви створюєте операцію шляху FastAPI, зазвичай ви можете повертати з неї будь-які дані: `dict`, `list`, модель Pydantic, модель бази даних тощо.

Типово FastAPI автоматично перетворить це значення повернення на JSON, використовуючи `jsonable_encoder`, описаний у [Сумісному з JSON кодері](../tutorial/encoder.md){.internal-link target=_blank}.

Потім, за лаштунками, він помістить ці дані, сумісні з JSON (наприклад, `dict`), у `JSONResponse`, який буде використано для надсилання відповіді клієнту.

Але ви можете повертати `JSONResponse` безпосередньо з ваших операцій шляху.

Це може бути корисним, наприклад, щоб повертати власні заголовки або кукі.

## Повернення `Response` { #return-a-response }

Насправді ви можете повертати будь-який `Response` або будь-який його підклас.

/// tip | Порада

`JSONResponse` сам є підкласом `Response`.

///

І коли ви повертаєте `Response`, FastAPI передасть його безпосередньо.

Він не виконуватиме жодних перетворень даних за допомогою моделей Pydantic, не перетворюватиме вміст на будь-який тип тощо.

Це дає вам багато гнучкості. Ви можете повертати будь-які типи даних, переписувати будь-які оголошення або перевірки даних тощо.

## Використання `jsonable_encoder` у `Response` { #using-the-jsonable-encoder-in-a-response }

Оскільки FastAPI не вносить змін у `Response`, який ви повертаєте, вам потрібно впевнитися, що його вміст готовий.

Наприклад, ви не можете покласти модель Pydantic у `JSONResponse`, не перетворивши її спочатку на `dict` з усіма типами даних (як-от `datetime`, `UUID` тощо), перетвореними на типи, сумісні з JSON.

Для таких випадків ви можете використати `jsonable_encoder`, щоб перетворити ваші дані перед тим, як передати їх у відповідь:

{* ../../docs_src/response_directly/tutorial001_py310.py hl[5:6,20:21] *}

/// note | Технічні деталі

Ви також можете використати `from starlette.responses import JSONResponse`.

FastAPI надає ті самі `starlette.responses` як `fastapi.responses` просто як зручність для вас, розробника. Але більшість доступних `Response` походять безпосередньо зі Starlette.

///

## Повернення власного `Response` { #returning-a-custom-response }

Наведений вище приклад показує всі необхідні частини, але він ще не дуже корисний, адже ви могли просто повернути `item` безпосередньо, і FastAPI помістив би його у `JSONResponse`, перетворивши на `dict` тощо. Усе це відбувається за замовчуванням.

Тепер подивімося, як це використати, щоб повернути власну відповідь.

Припустімо, ви хочете повернути відповідь <a href="https://en.wikipedia.org/wiki/XML" class="external-link" target="_blank">XML</a>.

Ви можете помістити свій вміст XML у строку, помістити це в `Response` і повернути:

{* ../../docs_src/response_directly/tutorial002_py310.py hl[1,18] *}

## Примітки { #notes }

Коли ви повертаєте `Response` безпосередньо, його дані не перевіряються, не перетворюються (серіалізуються) і не документуються автоматично.

Але ви все ще можете задокументувати це, як описано в [Додаткових відповідях в OpenAPI](additional-responses.md){.internal-link target=_blank}.

У подальших розділах ви побачите, як використовувати/оголошувати ці власні `Response`, водночас зберігаючи автоматичне перетворення даних, документацію тощо.
