# FastAPIを応援 - ヘルプの入手 { #help-fastapi-get-help }

**FastAPI** は気に入りましたか？

FastAPIや他のユーザー、作者を応援したいですか？

それとも **FastAPI** についてヘルプが必要ですか？

とても簡単に応援できる方法があります（1、2回クリックするだけのものもあります）。

ヘルプを得る方法もいくつかあります。

## ニュースレターを購読 { #subscribe-to-the-newsletter }

[**FastAPI and friends** ニュースレター](newsletter.md){.internal-link target=_blank}（配信はまれです）を購読すると、次の情報をキャッチアップできます:

* FastAPI と関連プロジェクトのニュース 🚀
* ガイド 📝
* 機能 ✨
* 互換性に影響する変更 🚨
* ヒントやコツ ✅

## X (Twitter) で FastAPI をフォロー { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">**X (Twitter)** で @fastapi をフォロー</a>して、**FastAPI** の最新情報を受け取りましょう。🐦

## GitHubで **FastAPI** にStar { #star-fastapi-in-github }

GitHubでFastAPIに「Star」をつけることができます（右上部のStarボタンをクリック）: <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>。⭐️

スターを増やすことで、他のユーザーの目につきやすくなり、すでに多くの人の役に立っていることが伝わります。

## GitHubレポジトリのリリースをWatch { #watch-the-github-repository-for-releases }

GitHubでFastAPIを「Watch」できます（右上部の「Watch」ボタンをクリック）: <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>。👀

そこで「Releases only」を選択できます。

これを行うと、バグ修正や新機能を含む **FastAPI** の新しいリリース（新バージョン）があるたびに、（メールで）通知を受け取れます。

## 開発者とつながる { #connect-with-the-author }

作者である<a href="https://tiangolo.com" class="external-link" target="_blank">私（Sebastián Ramírez / `tiangolo`）</a>とつながれます。

できること:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">**GitHub** でフォロー</a>。
    * 役に立つかもしれない、私が作成した他のオープンソースプロジェクトを見られます。
    * 新しいオープンソースプロジェクトを作成したときにわかります。
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">**X (Twitter)** でフォロー</a> または <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>。
    * あなたがどのようにFastAPIを使っているか教えてください（聞けると嬉しいです）。
    * 新しいツールの告知やリリースを聞けます。
    * さらに、<a href="https://x.com/fastapi" class="external-link" target="_blank">X (Twitter) の @fastapi</a>（別アカウント）もフォローできます。
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">**LinkedIn** でフォロー</a>。
    * 新しいツールの告知やリリースを聞けます（ただしX (Twitter) の方をよく使っています 🤷‍♂）。
* <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> や <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a> で執筆内容を読む（またはフォロー）。
    * 私のアイデアや、作成したツールに関する記事を読めます。
    * 新しい記事を公開したときに読めます。

## **FastAPI** についてツイート { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">**FastAPI** についてツイート</a>して、なぜ気に入っているのかを私や他の人に教えてください。🎉

**FastAPI** がどのように使われているか、どこを気に入っているか、どのプロジェクト/会社で使っているか等、聞けると嬉しいです。

## FastAPIに投票 { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Slantで **FastAPI** に投票</a>。
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">AlternativeToで **FastAPI** に投票</a>。
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">StackShare で **FastAPI** を使っていると宣言</a>。

## GitHubで質問に困っている人を助ける { #help-others-with-questions-in-github }

次の場所で、他の人の質問を手助けできます:

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

多くの場合、その質問の答えをすでに知っているかもしれません。🤓

もし多くの人の質問に答えて助けてくれたなら、あなたは公式の[FastAPI Expert](fastapi-people.md#fastapi-experts){.internal-link target=_blank}になります。🎉

最も大事なポイントは「親切であること」を心がけることです。人はフラストレーションを抱えてやって来るので、必ずしも最良の聞き方をしているとは限りませんが、できる限り親切に対応しましょう。🤗

**FastAPI** コミュニティは親切で歓迎的であることを目指しています。同時に、いじめや他者への無礼な振る舞いは受け入れないでください。お互いを大事にしましょう。

---

以下は（Discussions や Issues で）他の人の質問を手助けする方法です:

### 質問を理解する { #understand-the-question }

* 質問者の「目的」やユースケースを理解できるか確認します。

* 次に、質問（大半は質問です）が「明確」か確認します。

* 多くの場合、ユーザーが想像した解決策についての質問になっていますが、もっと「良い」方法があるかもしれません。問題やユースケースをよりよく理解できれば、より良い「代替解決策」を提案できるかもしれません。

* 質問が理解できない場合は、さらに「詳細」を尋ねます。

### 問題を再現する { #reproduce-the-problem }

多くのケースや質問は、その人の「元のコード」に関係しています。

しばしばコードの断片だけが共有されますが、それでは問題を「再現」するには不十分です。

* ローカルで同じエラーや挙動を確認できるように、またはユースケースをよりよく理解できるように、**コピー&ペースト**して実行できる<a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">最小の再現可能な例</a>の提供を依頼できます。

* とても寛大な気分なら、問題の説明だけをもとに、あなた自身でそのような**例を作成**してみることもできます。ただし時間がかかる可能性が高いので、まずは問題の明確化を依頼した方が良い場合もあります。

### 解決策を提案する { #suggest-solutions }

* 質問を理解できたら、可能な**回答**を提示できます。

* 多くの場合、相手の「根本的な問題やユースケース」を理解することが重要です。相手が試している方法より良い解決方法があるかもしれないからです。

### クローズを依頼する { #ask-to-close }

もし相手が返信してきて、あなたが問題を解決できたなら、おめでとう、**あなたはヒーロー**です！🦸

* その場合、次のように依頼できます:

    * GitHub Discussions: コメントを**回答**としてマークしてもらう。
    * GitHub Issues: issue を**クローズ**してもらう。

## GitHubレポジトリをWatch { #watch-the-github-repository }

GitHubでFastAPIを「Watch」できます（右上部の「Watch」ボタンをクリック）: <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>。👀

「Releases only」ではなく「Watching」を選択すると、新しい issue や質問が作成されたときに通知を受け取れます。新しい issue のみ、Discussions のみ、PR のみ、など通知対象を絞ることもできます。

その上で、そうした質問の解決を手助けできます。

## 質問する { #ask-questions }

GitHubレポジトリで<a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">新しい質問</a>を作成できます。例えば:

* **質問**をする、または**問題**について尋ねる。
* 新しい**機能**を提案する。

**Note**: もしそうするなら、他の人の手助けもお願いします。😉

## プルリクエストをレビュー { #review-pull-requests }

他の人からのプルリクエストのレビューを手伝ってもらえます。

ここでも、できる限り親切であるようにしてください。🤗

---

プルリクエストをレビューするときのポイントです:

### 問題を理解する { #understand-the-problem }

* まず、そのプルリクエストが解決しようとしている**問題を理解**してください。長めの議論が GitHub Discussion や issue にあるかもしれません。

* その問題は実は**別の方法**で解決でき、プルリクエスト自体が不要な場合もあります。その場合は、その提案や質問をしても良いでしょう。

### スタイルは気にしすぎない { #dont-worry-about-style }

* コミットメッセージのスタイルなどはあまり気にしなくて大丈夫です。私は squash and merge を使い、コミットを手動で調整します。

* スタイルルールについても心配無用です。自動化ツールがすでにチェックしています。

ほかにスタイルや一貫性の要件があれば、私から直接依頼しますし、必要な変更を上に積む形でコミットを追加します。

### コードを確認 { #check-the-code }

* コードを確認して読み、妥当かどうかを見て、**ローカルで実行**し、本当に問題を解決しているか確かめてください。

* そのうえで、それを行ったことを**コメント**で伝えてください。そうすれば、実際に確認してくれたとわかります。

/// info | 情報

残念ながら、承認が複数ついただけのPRを、そのまま信頼することはできません。

説明が魅力的なためか、3件、5件以上の承認がついていても、実際にPRを確認すると壊れていたり、バグがあったり、主張する問題を解決していなかったりすることが何度もありました。😅

ですので、実際にコードを読み、実行して確認し、それをコメントで知らせてもらえることが本当に重要です。🤓

///

* もしPRを簡素化できそうなら、その依頼をしても構いませんが、細かい点にこだわり過ぎる必要はありません。主観的な見方が多く（私にもあります 🙈）、基本的な点に集中できるとより良いでしょう。

### テスト { #tests }

* PRに**テスト**があるか確認を手伝ってください。

* PR前はテストが**失敗**することを確認します。🚨

* そしてPR後にテストが**成功**することを確認します。✅

* 多くのPRにはテストがありません。テストの追加を**リマインド**したり、テストを**提案**したりできます。これは最も時間を消費する部分の一つで、大いに助けになります。

* 何を試したかもコメントしてください。そうすれば、確認してくれたことがわかります。🤓

## プルリクエストを作成 { #create-a-pull-request }

[貢献](contributing.md){.internal-link target=_blank}として、次のようにプルリクエストでソースコードに貢献できます:

* ドキュメントで見つけたタイポの修正。
* 自分が作成/発見した FastAPI に関する記事・動画・ポッドキャストを、<a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">このファイルを編集</a>して共有。
    * 該当セクションの先頭にリンクを追加してください。
* 自分の言語への[ドキュメント翻訳を手伝う](contributing.md#translations){.internal-link target=_blank}。
    * 他の人が作成した翻訳のレビューも手伝えます。
* 新しいドキュメントセクションの提案。
* 既存のissue/バグの修正。
    * テストを追加してください。
* 新機能の追加。
    * テストを追加してください。
    * 関連があればドキュメントも追加してください。

## FastAPIのメンテナンスを手伝う { #help-maintain-fastapi }

**FastAPI** のメンテナンスを手伝ってください！🤓

やることはたくさんあり、その多くは**あなた**にもできます。

今すぐできる主なタスクは次のとおりです:

* [GitHubで質問に困っている人を助ける](#help-others-with-questions-in-github){.internal-link target=_blank}（上のセクションを参照）。
* [プルリクエストをレビュー](#review-pull-requests){.internal-link target=_blank}（上のセクションを参照）。

この2つが**最も時間を消費**します。FastAPI のメンテナンス作業の中心です。

これを手伝ってもらえると、**FastAPIのメンテナンスに貢献**し、**より速く・より良く前進**できるようになります。🚀

## チャットに参加 { #join-the-chat }

👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">Discord チャットサーバー</a> 👥 に参加し、FastAPI コミュニティのみんなと交流しましょう。

/// tip | 豆知識

質問は <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a> に投稿してください。そこなら[FastAPI Experts](fastapi-people.md#fastapi-experts){.internal-link target=_blank}から助けてもらえる可能性がずっと高いです。

チャットは一般的な会話のみに使いましょう。

///

### 質問でチャットを使わない { #dont-use-the-chat-for-questions }

チャットは「自由な会話」がしやすいため、一般的すぎて答えにくい質問になりがちです。そのため、回答が得られない可能性があります。

GitHub では、テンプレートが正しい形で質問を書くのを助けてくれるため、良い回答を得やすくなりますし、質問する前に自分で問題を解決できることもあります。さらにGitHubなら、時間がかかっても私が必ずすべてに回答できるようにできます。チャットでは私個人にはそれができません。😅

チャットでの会話はGitHubほど検索しやすくないため、質問と回答が会話に埋もれがちです。そして、[FastAPI Expert](fastapi-people.md#fastapi-experts){.internal-link target=_blank}になるためにカウントされるのはGitHub上の活動だけです。ですから、GitHubの方が注目を集めやすいでしょう。

一方で、チャットには数千人のユーザーがいるため、ほぼ常に誰かと会話できる可能性が高いです。😄

## 作者をスポンサー { #sponsor-the-author }

あなたの**製品/会社**が **FastAPI** に依存している、または関連しており、そのユーザーにリーチしたい場合は、<a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a> を通じて作者（私）を支援できます。プランに応じて、ドキュメントにバッジが表示されるなどの特典がある場合があります。🎁

---

Thanks! 🚀
