#include "asm/riscv/init.hpp"

#include "LIEF/asm/riscv/opcodes.hpp"

namespace LIEF::assembly::riscv::py {
template<>
void create<LIEF::assembly::riscv::OPCODE>(nb::module_& m) {
  nb::enum_<LIEF::assembly::riscv::OPCODE> opcodes(m, "OPCODE");
  opcodes.value("PHI", LIEF::assembly::riscv::OPCODE::PHI)
  .value("INLINEASM", LIEF::assembly::riscv::OPCODE::INLINEASM)
  .value("INLINEASM_BR", LIEF::assembly::riscv::OPCODE::INLINEASM_BR)
  .value("CFI_INSTRUCTION", LIEF::assembly::riscv::OPCODE::CFI_INSTRUCTION)
  .value("EH_LABEL", LIEF::assembly::riscv::OPCODE::EH_LABEL)
  .value("GC_LABEL", LIEF::assembly::riscv::OPCODE::GC_LABEL)
  .value("ANNOTATION_LABEL", LIEF::assembly::riscv::OPCODE::ANNOTATION_LABEL)
  .value("KILL", LIEF::assembly::riscv::OPCODE::KILL)
  .value("EXTRACT_SUBREG", LIEF::assembly::riscv::OPCODE::EXTRACT_SUBREG)
  .value("INSERT_SUBREG", LIEF::assembly::riscv::OPCODE::INSERT_SUBREG)
  .value("IMPLICIT_DEF", LIEF::assembly::riscv::OPCODE::IMPLICIT_DEF)
  .value("INIT_UNDEF", LIEF::assembly::riscv::OPCODE::INIT_UNDEF)
  .value("SUBREG_TO_REG", LIEF::assembly::riscv::OPCODE::SUBREG_TO_REG)
  .value("COPY_TO_REGCLASS", LIEF::assembly::riscv::OPCODE::COPY_TO_REGCLASS)
  .value("DBG_VALUE", LIEF::assembly::riscv::OPCODE::DBG_VALUE)
  .value("DBG_VALUE_LIST", LIEF::assembly::riscv::OPCODE::DBG_VALUE_LIST)
  .value("DBG_INSTR_REF", LIEF::assembly::riscv::OPCODE::DBG_INSTR_REF)
  .value("DBG_PHI", LIEF::assembly::riscv::OPCODE::DBG_PHI)
  .value("DBG_LABEL", LIEF::assembly::riscv::OPCODE::DBG_LABEL)
  .value("REG_SEQUENCE", LIEF::assembly::riscv::OPCODE::REG_SEQUENCE)
  .value("COPY", LIEF::assembly::riscv::OPCODE::COPY)
  .value("BUNDLE", LIEF::assembly::riscv::OPCODE::BUNDLE)
  .value("LIFETIME_START", LIEF::assembly::riscv::OPCODE::LIFETIME_START)
  .value("LIFETIME_END", LIEF::assembly::riscv::OPCODE::LIFETIME_END)
  .value("PSEUDO_PROBE", LIEF::assembly::riscv::OPCODE::PSEUDO_PROBE)
  .value("ARITH_FENCE", LIEF::assembly::riscv::OPCODE::ARITH_FENCE)
  .value("STACKMAP", LIEF::assembly::riscv::OPCODE::STACKMAP)
  .value("FENTRY_CALL", LIEF::assembly::riscv::OPCODE::FENTRY_CALL)
  .value("PATCHPOINT", LIEF::assembly::riscv::OPCODE::PATCHPOINT)
  .value("LOAD_STACK_GUARD", LIEF::assembly::riscv::OPCODE::LOAD_STACK_GUARD)
  .value("PREALLOCATED_SETUP", LIEF::assembly::riscv::OPCODE::PREALLOCATED_SETUP)
  .value("PREALLOCATED_ARG", LIEF::assembly::riscv::OPCODE::PREALLOCATED_ARG)
  .value("STATEPOINT", LIEF::assembly::riscv::OPCODE::STATEPOINT)
  .value("LOCAL_ESCAPE", LIEF::assembly::riscv::OPCODE::LOCAL_ESCAPE)
  .value("FAULTING_OP", LIEF::assembly::riscv::OPCODE::FAULTING_OP)
  .value("PATCHABLE_OP", LIEF::assembly::riscv::OPCODE::PATCHABLE_OP)
  .value("PATCHABLE_FUNCTION_ENTER", LIEF::assembly::riscv::OPCODE::PATCHABLE_FUNCTION_ENTER)
  .value("PATCHABLE_RET", LIEF::assembly::riscv::OPCODE::PATCHABLE_RET)
  .value("PATCHABLE_FUNCTION_EXIT", LIEF::assembly::riscv::OPCODE::PATCHABLE_FUNCTION_EXIT)
  .value("PATCHABLE_TAIL_CALL", LIEF::assembly::riscv::OPCODE::PATCHABLE_TAIL_CALL)
  .value("PATCHABLE_EVENT_CALL", LIEF::assembly::riscv::OPCODE::PATCHABLE_EVENT_CALL)
  .value("PATCHABLE_TYPED_EVENT_CALL", LIEF::assembly::riscv::OPCODE::PATCHABLE_TYPED_EVENT_CALL)
  .value("ICALL_BRANCH_FUNNEL", LIEF::assembly::riscv::OPCODE::ICALL_BRANCH_FUNNEL)
  .value("FAKE_USE", LIEF::assembly::riscv::OPCODE::FAKE_USE)
  .value("MEMBARRIER", LIEF::assembly::riscv::OPCODE::MEMBARRIER)
  .value("JUMP_TABLE_DEBUG_INFO", LIEF::assembly::riscv::OPCODE::JUMP_TABLE_DEBUG_INFO)
  .value("CONVERGENCECTRL_ENTRY", LIEF::assembly::riscv::OPCODE::CONVERGENCECTRL_ENTRY)
  .value("CONVERGENCECTRL_ANCHOR", LIEF::assembly::riscv::OPCODE::CONVERGENCECTRL_ANCHOR)
  .value("CONVERGENCECTRL_LOOP", LIEF::assembly::riscv::OPCODE::CONVERGENCECTRL_LOOP)
  .value("CONVERGENCECTRL_GLUE", LIEF::assembly::riscv::OPCODE::CONVERGENCECTRL_GLUE)
  .value("G_ASSERT_SEXT", LIEF::assembly::riscv::OPCODE::G_ASSERT_SEXT)
  .value("G_ASSERT_ZEXT", LIEF::assembly::riscv::OPCODE::G_ASSERT_ZEXT)
  .value("G_ASSERT_ALIGN", LIEF::assembly::riscv::OPCODE::G_ASSERT_ALIGN)
  .value("G_ADD", LIEF::assembly::riscv::OPCODE::G_ADD)
  .value("G_SUB", LIEF::assembly::riscv::OPCODE::G_SUB)
  .value("G_MUL", LIEF::assembly::riscv::OPCODE::G_MUL)
  .value("G_SDIV", LIEF::assembly::riscv::OPCODE::G_SDIV)
  .value("G_UDIV", LIEF::assembly::riscv::OPCODE::G_UDIV)
  .value("G_SREM", LIEF::assembly::riscv::OPCODE::G_SREM)
  .value("G_UREM", LIEF::assembly::riscv::OPCODE::G_UREM)
  .value("G_SDIVREM", LIEF::assembly::riscv::OPCODE::G_SDIVREM)
  .value("G_UDIVREM", LIEF::assembly::riscv::OPCODE::G_UDIVREM)
  .value("G_AND", LIEF::assembly::riscv::OPCODE::G_AND)
  .value("G_OR", LIEF::assembly::riscv::OPCODE::G_OR)
  .value("G_XOR", LIEF::assembly::riscv::OPCODE::G_XOR)
  .value("G_ABDS", LIEF::assembly::riscv::OPCODE::G_ABDS)
  .value("G_ABDU", LIEF::assembly::riscv::OPCODE::G_ABDU)
  .value("G_IMPLICIT_DEF", LIEF::assembly::riscv::OPCODE::G_IMPLICIT_DEF)
  .value("G_PHI", LIEF::assembly::riscv::OPCODE::G_PHI)
  .value("G_FRAME_INDEX", LIEF::assembly::riscv::OPCODE::G_FRAME_INDEX)
  .value("G_GLOBAL_VALUE", LIEF::assembly::riscv::OPCODE::G_GLOBAL_VALUE)
  .value("G_PTRAUTH_GLOBAL_VALUE", LIEF::assembly::riscv::OPCODE::G_PTRAUTH_GLOBAL_VALUE)
  .value("G_CONSTANT_POOL", LIEF::assembly::riscv::OPCODE::G_CONSTANT_POOL)
  .value("G_EXTRACT", LIEF::assembly::riscv::OPCODE::G_EXTRACT)
  .value("G_UNMERGE_VALUES", LIEF::assembly::riscv::OPCODE::G_UNMERGE_VALUES)
  .value("G_INSERT", LIEF::assembly::riscv::OPCODE::G_INSERT)
  .value("G_MERGE_VALUES", LIEF::assembly::riscv::OPCODE::G_MERGE_VALUES)
  .value("G_BUILD_VECTOR", LIEF::assembly::riscv::OPCODE::G_BUILD_VECTOR)
  .value("G_BUILD_VECTOR_TRUNC", LIEF::assembly::riscv::OPCODE::G_BUILD_VECTOR_TRUNC)
  .value("G_CONCAT_VECTORS", LIEF::assembly::riscv::OPCODE::G_CONCAT_VECTORS)
  .value("G_PTRTOINT", LIEF::assembly::riscv::OPCODE::G_PTRTOINT)
  .value("G_INTTOPTR", LIEF::assembly::riscv::OPCODE::G_INTTOPTR)
  .value("G_BITCAST", LIEF::assembly::riscv::OPCODE::G_BITCAST)
  .value("G_FREEZE", LIEF::assembly::riscv::OPCODE::G_FREEZE)
  .value("G_CONSTANT_FOLD_BARRIER", LIEF::assembly::riscv::OPCODE::G_CONSTANT_FOLD_BARRIER)
  .value("G_INTRINSIC_FPTRUNC_ROUND", LIEF::assembly::riscv::OPCODE::G_INTRINSIC_FPTRUNC_ROUND)
  .value("G_INTRINSIC_TRUNC", LIEF::assembly::riscv::OPCODE::G_INTRINSIC_TRUNC)
  .value("G_INTRINSIC_ROUND", LIEF::assembly::riscv::OPCODE::G_INTRINSIC_ROUND)
  .value("G_INTRINSIC_LRINT", LIEF::assembly::riscv::OPCODE::G_INTRINSIC_LRINT)
  .value("G_INTRINSIC_LLRINT", LIEF::assembly::riscv::OPCODE::G_INTRINSIC_LLRINT)
  .value("G_INTRINSIC_ROUNDEVEN", LIEF::assembly::riscv::OPCODE::G_INTRINSIC_ROUNDEVEN)
  .value("G_READCYCLECOUNTER", LIEF::assembly::riscv::OPCODE::G_READCYCLECOUNTER)
  .value("G_READSTEADYCOUNTER", LIEF::assembly::riscv::OPCODE::G_READSTEADYCOUNTER)
  .value("G_LOAD", LIEF::assembly::riscv::OPCODE::G_LOAD)
  .value("G_SEXTLOAD", LIEF::assembly::riscv::OPCODE::G_SEXTLOAD)
  .value("G_ZEXTLOAD", LIEF::assembly::riscv::OPCODE::G_ZEXTLOAD)
  .value("G_INDEXED_LOAD", LIEF::assembly::riscv::OPCODE::G_INDEXED_LOAD)
  .value("G_INDEXED_SEXTLOAD", LIEF::assembly::riscv::OPCODE::G_INDEXED_SEXTLOAD)
  .value("G_INDEXED_ZEXTLOAD", LIEF::assembly::riscv::OPCODE::G_INDEXED_ZEXTLOAD)
  .value("G_STORE", LIEF::assembly::riscv::OPCODE::G_STORE)
  .value("G_INDEXED_STORE", LIEF::assembly::riscv::OPCODE::G_INDEXED_STORE)
  .value("G_ATOMIC_CMPXCHG_WITH_SUCCESS", LIEF::assembly::riscv::OPCODE::G_ATOMIC_CMPXCHG_WITH_SUCCESS)
  .value("G_ATOMIC_CMPXCHG", LIEF::assembly::riscv::OPCODE::G_ATOMIC_CMPXCHG)
  .value("G_ATOMICRMW_XCHG", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_XCHG)
  .value("G_ATOMICRMW_ADD", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_ADD)
  .value("G_ATOMICRMW_SUB", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_SUB)
  .value("G_ATOMICRMW_AND", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_AND)
  .value("G_ATOMICRMW_NAND", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_NAND)
  .value("G_ATOMICRMW_OR", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_OR)
  .value("G_ATOMICRMW_XOR", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_XOR)
  .value("G_ATOMICRMW_MAX", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_MAX)
  .value("G_ATOMICRMW_MIN", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_MIN)
  .value("G_ATOMICRMW_UMAX", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_UMAX)
  .value("G_ATOMICRMW_UMIN", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_UMIN)
  .value("G_ATOMICRMW_FADD", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_FADD)
  .value("G_ATOMICRMW_FSUB", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_FSUB)
  .value("G_ATOMICRMW_FMAX", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_FMAX)
  .value("G_ATOMICRMW_FMIN", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_FMIN)
  .value("G_ATOMICRMW_FMAXIMUM", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_FMAXIMUM)
  .value("G_ATOMICRMW_FMINIMUM", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_FMINIMUM)
  .value("G_ATOMICRMW_UINC_WRAP", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_UINC_WRAP)
  .value("G_ATOMICRMW_UDEC_WRAP", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_UDEC_WRAP)
  .value("G_ATOMICRMW_USUB_COND", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_USUB_COND)
  .value("G_ATOMICRMW_USUB_SAT", LIEF::assembly::riscv::OPCODE::G_ATOMICRMW_USUB_SAT)
  .value("G_FENCE", LIEF::assembly::riscv::OPCODE::G_FENCE)
  .value("G_PREFETCH", LIEF::assembly::riscv::OPCODE::G_PREFETCH)
  .value("G_BRCOND", LIEF::assembly::riscv::OPCODE::G_BRCOND)
  .value("G_BRINDIRECT", LIEF::assembly::riscv::OPCODE::G_BRINDIRECT)
  .value("G_INVOKE_REGION_START", LIEF::assembly::riscv::OPCODE::G_INVOKE_REGION_START)
  .value("G_INTRINSIC", LIEF::assembly::riscv::OPCODE::G_INTRINSIC)
  .value("G_INTRINSIC_W_SIDE_EFFECTS", LIEF::assembly::riscv::OPCODE::G_INTRINSIC_W_SIDE_EFFECTS)
  .value("G_INTRINSIC_CONVERGENT", LIEF::assembly::riscv::OPCODE::G_INTRINSIC_CONVERGENT)
  .value("G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS", LIEF::assembly::riscv::OPCODE::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS)
  .value("G_ANYEXT", LIEF::assembly::riscv::OPCODE::G_ANYEXT)
  .value("G_TRUNC", LIEF::assembly::riscv::OPCODE::G_TRUNC)
  .value("G_TRUNC_SSAT_S", LIEF::assembly::riscv::OPCODE::G_TRUNC_SSAT_S)
  .value("G_TRUNC_SSAT_U", LIEF::assembly::riscv::OPCODE::G_TRUNC_SSAT_U)
  .value("G_TRUNC_USAT_U", LIEF::assembly::riscv::OPCODE::G_TRUNC_USAT_U)
  .value("G_CONSTANT", LIEF::assembly::riscv::OPCODE::G_CONSTANT)
  .value("G_FCONSTANT", LIEF::assembly::riscv::OPCODE::G_FCONSTANT)
  .value("G_VASTART", LIEF::assembly::riscv::OPCODE::G_VASTART)
  .value("G_VAARG", LIEF::assembly::riscv::OPCODE::G_VAARG)
  .value("G_SEXT", LIEF::assembly::riscv::OPCODE::G_SEXT)
  .value("G_SEXT_INREG", LIEF::assembly::riscv::OPCODE::G_SEXT_INREG)
  .value("G_ZEXT", LIEF::assembly::riscv::OPCODE::G_ZEXT)
  .value("G_SHL", LIEF::assembly::riscv::OPCODE::G_SHL)
  .value("G_LSHR", LIEF::assembly::riscv::OPCODE::G_LSHR)
  .value("G_ASHR", LIEF::assembly::riscv::OPCODE::G_ASHR)
  .value("G_FSHL", LIEF::assembly::riscv::OPCODE::G_FSHL)
  .value("G_FSHR", LIEF::assembly::riscv::OPCODE::G_FSHR)
  .value("G_ROTR", LIEF::assembly::riscv::OPCODE::G_ROTR)
  .value("G_ROTL", LIEF::assembly::riscv::OPCODE::G_ROTL)
  .value("G_ICMP", LIEF::assembly::riscv::OPCODE::G_ICMP)
  .value("G_FCMP", LIEF::assembly::riscv::OPCODE::G_FCMP)
  .value("G_SCMP", LIEF::assembly::riscv::OPCODE::G_SCMP)
  .value("G_UCMP", LIEF::assembly::riscv::OPCODE::G_UCMP)
  .value("G_SELECT", LIEF::assembly::riscv::OPCODE::G_SELECT)
  .value("G_UADDO", LIEF::assembly::riscv::OPCODE::G_UADDO)
  .value("G_UADDE", LIEF::assembly::riscv::OPCODE::G_UADDE)
  .value("G_USUBO", LIEF::assembly::riscv::OPCODE::G_USUBO)
  .value("G_USUBE", LIEF::assembly::riscv::OPCODE::G_USUBE)
  .value("G_SADDO", LIEF::assembly::riscv::OPCODE::G_SADDO)
  .value("G_SADDE", LIEF::assembly::riscv::OPCODE::G_SADDE)
  .value("G_SSUBO", LIEF::assembly::riscv::OPCODE::G_SSUBO)
  .value("G_SSUBE", LIEF::assembly::riscv::OPCODE::G_SSUBE)
  .value("G_UMULO", LIEF::assembly::riscv::OPCODE::G_UMULO)
  .value("G_SMULO", LIEF::assembly::riscv::OPCODE::G_SMULO)
  .value("G_UMULH", LIEF::assembly::riscv::OPCODE::G_UMULH)
  .value("G_SMULH", LIEF::assembly::riscv::OPCODE::G_SMULH)
  .value("G_UADDSAT", LIEF::assembly::riscv::OPCODE::G_UADDSAT)
  .value("G_SADDSAT", LIEF::assembly::riscv::OPCODE::G_SADDSAT)
  .value("G_USUBSAT", LIEF::assembly::riscv::OPCODE::G_USUBSAT)
  .value("G_SSUBSAT", LIEF::assembly::riscv::OPCODE::G_SSUBSAT)
  .value("G_USHLSAT", LIEF::assembly::riscv::OPCODE::G_USHLSAT)
  .value("G_SSHLSAT", LIEF::assembly::riscv::OPCODE::G_SSHLSAT)
  .value("G_SMULFIX", LIEF::assembly::riscv::OPCODE::G_SMULFIX)
  .value("G_UMULFIX", LIEF::assembly::riscv::OPCODE::G_UMULFIX)
  .value("G_SMULFIXSAT", LIEF::assembly::riscv::OPCODE::G_SMULFIXSAT)
  .value("G_UMULFIXSAT", LIEF::assembly::riscv::OPCODE::G_UMULFIXSAT)
  .value("G_SDIVFIX", LIEF::assembly::riscv::OPCODE::G_SDIVFIX)
  .value("G_UDIVFIX", LIEF::assembly::riscv::OPCODE::G_UDIVFIX)
  .value("G_SDIVFIXSAT", LIEF::assembly::riscv::OPCODE::G_SDIVFIXSAT)
  .value("G_UDIVFIXSAT", LIEF::assembly::riscv::OPCODE::G_UDIVFIXSAT)
  .value("G_FADD", LIEF::assembly::riscv::OPCODE::G_FADD)
  .value("G_FSUB", LIEF::assembly::riscv::OPCODE::G_FSUB)
  .value("G_FMUL", LIEF::assembly::riscv::OPCODE::G_FMUL)
  .value("G_FMA", LIEF::assembly::riscv::OPCODE::G_FMA)
  .value("G_FMAD", LIEF::assembly::riscv::OPCODE::G_FMAD)
  .value("G_FDIV", LIEF::assembly::riscv::OPCODE::G_FDIV)
  .value("G_FREM", LIEF::assembly::riscv::OPCODE::G_FREM)
  .value("G_FPOW", LIEF::assembly::riscv::OPCODE::G_FPOW)
  .value("G_FPOWI", LIEF::assembly::riscv::OPCODE::G_FPOWI)
  .value("G_FEXP", LIEF::assembly::riscv::OPCODE::G_FEXP)
  .value("G_FEXP2", LIEF::assembly::riscv::OPCODE::G_FEXP2)
  .value("G_FEXP10", LIEF::assembly::riscv::OPCODE::G_FEXP10)
  .value("G_FLOG", LIEF::assembly::riscv::OPCODE::G_FLOG)
  .value("G_FLOG2", LIEF::assembly::riscv::OPCODE::G_FLOG2)
  .value("G_FLOG10", LIEF::assembly::riscv::OPCODE::G_FLOG10)
  .value("G_FLDEXP", LIEF::assembly::riscv::OPCODE::G_FLDEXP)
  .value("G_FFREXP", LIEF::assembly::riscv::OPCODE::G_FFREXP)
  .value("G_FNEG", LIEF::assembly::riscv::OPCODE::G_FNEG)
  .value("G_FPEXT", LIEF::assembly::riscv::OPCODE::G_FPEXT)
  .value("G_FPTRUNC", LIEF::assembly::riscv::OPCODE::G_FPTRUNC)
  .value("G_FPTOSI", LIEF::assembly::riscv::OPCODE::G_FPTOSI)
  .value("G_FPTOUI", LIEF::assembly::riscv::OPCODE::G_FPTOUI)
  .value("G_SITOFP", LIEF::assembly::riscv::OPCODE::G_SITOFP)
  .value("G_UITOFP", LIEF::assembly::riscv::OPCODE::G_UITOFP)
  .value("G_FPTOSI_SAT", LIEF::assembly::riscv::OPCODE::G_FPTOSI_SAT)
  .value("G_FPTOUI_SAT", LIEF::assembly::riscv::OPCODE::G_FPTOUI_SAT)
  .value("G_FABS", LIEF::assembly::riscv::OPCODE::G_FABS)
  .value("G_FCOPYSIGN", LIEF::assembly::riscv::OPCODE::G_FCOPYSIGN)
  .value("G_IS_FPCLASS", LIEF::assembly::riscv::OPCODE::G_IS_FPCLASS)
  .value("G_FCANONICALIZE", LIEF::assembly::riscv::OPCODE::G_FCANONICALIZE)
  .value("G_FMINNUM", LIEF::assembly::riscv::OPCODE::G_FMINNUM)
  .value("G_FMAXNUM", LIEF::assembly::riscv::OPCODE::G_FMAXNUM)
  .value("G_FMINNUM_IEEE", LIEF::assembly::riscv::OPCODE::G_FMINNUM_IEEE)
  .value("G_FMAXNUM_IEEE", LIEF::assembly::riscv::OPCODE::G_FMAXNUM_IEEE)
  .value("G_FMINIMUM", LIEF::assembly::riscv::OPCODE::G_FMINIMUM)
  .value("G_FMAXIMUM", LIEF::assembly::riscv::OPCODE::G_FMAXIMUM)
  .value("G_FMINIMUMNUM", LIEF::assembly::riscv::OPCODE::G_FMINIMUMNUM)
  .value("G_FMAXIMUMNUM", LIEF::assembly::riscv::OPCODE::G_FMAXIMUMNUM)
  .value("G_GET_FPENV", LIEF::assembly::riscv::OPCODE::G_GET_FPENV)
  .value("G_SET_FPENV", LIEF::assembly::riscv::OPCODE::G_SET_FPENV)
  .value("G_RESET_FPENV", LIEF::assembly::riscv::OPCODE::G_RESET_FPENV)
  .value("G_GET_FPMODE", LIEF::assembly::riscv::OPCODE::G_GET_FPMODE)
  .value("G_SET_FPMODE", LIEF::assembly::riscv::OPCODE::G_SET_FPMODE)
  .value("G_RESET_FPMODE", LIEF::assembly::riscv::OPCODE::G_RESET_FPMODE)
  .value("G_GET_ROUNDING", LIEF::assembly::riscv::OPCODE::G_GET_ROUNDING)
  .value("G_PTR_ADD", LIEF::assembly::riscv::OPCODE::G_PTR_ADD)
  .value("G_PTRMASK", LIEF::assembly::riscv::OPCODE::G_PTRMASK)
  .value("G_SMIN", LIEF::assembly::riscv::OPCODE::G_SMIN)
  .value("G_SMAX", LIEF::assembly::riscv::OPCODE::G_SMAX)
  .value("G_UMIN", LIEF::assembly::riscv::OPCODE::G_UMIN)
  .value("G_UMAX", LIEF::assembly::riscv::OPCODE::G_UMAX)
  .value("G_ABS", LIEF::assembly::riscv::OPCODE::G_ABS)
  .value("G_LROUND", LIEF::assembly::riscv::OPCODE::G_LROUND)
  .value("G_LLROUND", LIEF::assembly::riscv::OPCODE::G_LLROUND)
  .value("G_BR", LIEF::assembly::riscv::OPCODE::G_BR)
  .value("G_BRJT", LIEF::assembly::riscv::OPCODE::G_BRJT)
  .value("G_VSCALE", LIEF::assembly::riscv::OPCODE::G_VSCALE)
  .value("G_INSERT_SUBVECTOR", LIEF::assembly::riscv::OPCODE::G_INSERT_SUBVECTOR)
  .value("G_EXTRACT_SUBVECTOR", LIEF::assembly::riscv::OPCODE::G_EXTRACT_SUBVECTOR)
  .value("G_INSERT_VECTOR_ELT", LIEF::assembly::riscv::OPCODE::G_INSERT_VECTOR_ELT)
  .value("G_EXTRACT_VECTOR_ELT", LIEF::assembly::riscv::OPCODE::G_EXTRACT_VECTOR_ELT)
  .value("G_SHUFFLE_VECTOR", LIEF::assembly::riscv::OPCODE::G_SHUFFLE_VECTOR)
  .value("G_SPLAT_VECTOR", LIEF::assembly::riscv::OPCODE::G_SPLAT_VECTOR)
  .value("G_STEP_VECTOR", LIEF::assembly::riscv::OPCODE::G_STEP_VECTOR)
  .value("G_VECTOR_COMPRESS", LIEF::assembly::riscv::OPCODE::G_VECTOR_COMPRESS)
  .value("G_CTTZ", LIEF::assembly::riscv::OPCODE::G_CTTZ)
  .value("G_CTTZ_ZERO_UNDEF", LIEF::assembly::riscv::OPCODE::G_CTTZ_ZERO_UNDEF)
  .value("G_CTLZ", LIEF::assembly::riscv::OPCODE::G_CTLZ)
  .value("G_CTLZ_ZERO_UNDEF", LIEF::assembly::riscv::OPCODE::G_CTLZ_ZERO_UNDEF)
  .value("G_CTPOP", LIEF::assembly::riscv::OPCODE::G_CTPOP)
  .value("G_BSWAP", LIEF::assembly::riscv::OPCODE::G_BSWAP)
  .value("G_BITREVERSE", LIEF::assembly::riscv::OPCODE::G_BITREVERSE)
  .value("G_FCEIL", LIEF::assembly::riscv::OPCODE::G_FCEIL)
  .value("G_FCOS", LIEF::assembly::riscv::OPCODE::G_FCOS)
  .value("G_FSIN", LIEF::assembly::riscv::OPCODE::G_FSIN)
  .value("G_FSINCOS", LIEF::assembly::riscv::OPCODE::G_FSINCOS)
  .value("G_FTAN", LIEF::assembly::riscv::OPCODE::G_FTAN)
  .value("G_FACOS", LIEF::assembly::riscv::OPCODE::G_FACOS)
  .value("G_FASIN", LIEF::assembly::riscv::OPCODE::G_FASIN)
  .value("G_FATAN", LIEF::assembly::riscv::OPCODE::G_FATAN)
  .value("G_FATAN2", LIEF::assembly::riscv::OPCODE::G_FATAN2)
  .value("G_FCOSH", LIEF::assembly::riscv::OPCODE::G_FCOSH)
  .value("G_FSINH", LIEF::assembly::riscv::OPCODE::G_FSINH)
  .value("G_FTANH", LIEF::assembly::riscv::OPCODE::G_FTANH)
  .value("G_FSQRT", LIEF::assembly::riscv::OPCODE::G_FSQRT)
  .value("G_FFLOOR", LIEF::assembly::riscv::OPCODE::G_FFLOOR)
  .value("G_FRINT", LIEF::assembly::riscv::OPCODE::G_FRINT)
  .value("G_FNEARBYINT", LIEF::assembly::riscv::OPCODE::G_FNEARBYINT)
  .value("G_ADDRSPACE_CAST", LIEF::assembly::riscv::OPCODE::G_ADDRSPACE_CAST)
  .value("G_BLOCK_ADDR", LIEF::assembly::riscv::OPCODE::G_BLOCK_ADDR)
  .value("G_JUMP_TABLE", LIEF::assembly::riscv::OPCODE::G_JUMP_TABLE)
  .value("G_DYN_STACKALLOC", LIEF::assembly::riscv::OPCODE::G_DYN_STACKALLOC)
  .value("G_STACKSAVE", LIEF::assembly::riscv::OPCODE::G_STACKSAVE)
  .value("G_STACKRESTORE", LIEF::assembly::riscv::OPCODE::G_STACKRESTORE)
  .value("G_STRICT_FADD", LIEF::assembly::riscv::OPCODE::G_STRICT_FADD)
  .value("G_STRICT_FSUB", LIEF::assembly::riscv::OPCODE::G_STRICT_FSUB)
  .value("G_STRICT_FMUL", LIEF::assembly::riscv::OPCODE::G_STRICT_FMUL)
  .value("G_STRICT_FDIV", LIEF::assembly::riscv::OPCODE::G_STRICT_FDIV)
  .value("G_STRICT_FREM", LIEF::assembly::riscv::OPCODE::G_STRICT_FREM)
  .value("G_STRICT_FMA", LIEF::assembly::riscv::OPCODE::G_STRICT_FMA)
  .value("G_STRICT_FSQRT", LIEF::assembly::riscv::OPCODE::G_STRICT_FSQRT)
  .value("G_STRICT_FLDEXP", LIEF::assembly::riscv::OPCODE::G_STRICT_FLDEXP)
  .value("G_READ_REGISTER", LIEF::assembly::riscv::OPCODE::G_READ_REGISTER)
  .value("G_WRITE_REGISTER", LIEF::assembly::riscv::OPCODE::G_WRITE_REGISTER)
  .value("G_MEMCPY", LIEF::assembly::riscv::OPCODE::G_MEMCPY)
  .value("G_MEMCPY_INLINE", LIEF::assembly::riscv::OPCODE::G_MEMCPY_INLINE)
  .value("G_MEMMOVE", LIEF::assembly::riscv::OPCODE::G_MEMMOVE)
  .value("G_MEMSET", LIEF::assembly::riscv::OPCODE::G_MEMSET)
  .value("G_BZERO", LIEF::assembly::riscv::OPCODE::G_BZERO)
  .value("G_TRAP", LIEF::assembly::riscv::OPCODE::G_TRAP)
  .value("G_DEBUGTRAP", LIEF::assembly::riscv::OPCODE::G_DEBUGTRAP)
  .value("G_UBSANTRAP", LIEF::assembly::riscv::OPCODE::G_UBSANTRAP)
  .value("G_VECREDUCE_SEQ_FADD", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_SEQ_FADD)
  .value("G_VECREDUCE_SEQ_FMUL", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_SEQ_FMUL)
  .value("G_VECREDUCE_FADD", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_FADD)
  .value("G_VECREDUCE_FMUL", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_FMUL)
  .value("G_VECREDUCE_FMAX", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_FMAX);
  opcodes.value("G_VECREDUCE_FMIN", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_FMIN)
  .value("G_VECREDUCE_FMAXIMUM", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_FMAXIMUM)
  .value("G_VECREDUCE_FMINIMUM", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_FMINIMUM)
  .value("G_VECREDUCE_ADD", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_ADD)
  .value("G_VECREDUCE_MUL", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_MUL)
  .value("G_VECREDUCE_AND", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_AND)
  .value("G_VECREDUCE_OR", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_OR)
  .value("G_VECREDUCE_XOR", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_XOR)
  .value("G_VECREDUCE_SMAX", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_SMAX)
  .value("G_VECREDUCE_SMIN", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_SMIN)
  .value("G_VECREDUCE_UMAX", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_UMAX)
  .value("G_VECREDUCE_UMIN", LIEF::assembly::riscv::OPCODE::G_VECREDUCE_UMIN)
  .value("G_SBFX", LIEF::assembly::riscv::OPCODE::G_SBFX)
  .value("G_UBFX", LIEF::assembly::riscv::OPCODE::G_UBFX)
  .value("ADJCALLSTACKDOWN", LIEF::assembly::riscv::OPCODE::ADJCALLSTACKDOWN)
  .value("ADJCALLSTACKUP", LIEF::assembly::riscv::OPCODE::ADJCALLSTACKUP)
  .value("BuildPairF64Pseudo", LIEF::assembly::riscv::OPCODE::BuildPairF64Pseudo)
  .value("G_CLZW", LIEF::assembly::riscv::OPCODE::G_CLZW)
  .value("G_CTZW", LIEF::assembly::riscv::OPCODE::G_CTZW)
  .value("G_DIVUW", LIEF::assembly::riscv::OPCODE::G_DIVUW)
  .value("G_DIVW", LIEF::assembly::riscv::OPCODE::G_DIVW)
  .value("G_FCLASS", LIEF::assembly::riscv::OPCODE::G_FCLASS)
  .value("G_FCVT_WU_RV64", LIEF::assembly::riscv::OPCODE::G_FCVT_WU_RV64)
  .value("G_FCVT_W_RV64", LIEF::assembly::riscv::OPCODE::G_FCVT_W_RV64)
  .value("G_READ_VLENB", LIEF::assembly::riscv::OPCODE::G_READ_VLENB)
  .value("G_REMUW", LIEF::assembly::riscv::OPCODE::G_REMUW)
  .value("G_ROLW", LIEF::assembly::riscv::OPCODE::G_ROLW)
  .value("G_RORW", LIEF::assembly::riscv::OPCODE::G_RORW)
  .value("G_SLLW", LIEF::assembly::riscv::OPCODE::G_SLLW)
  .value("G_SPLAT_VECTOR_SPLIT_I64_VL", LIEF::assembly::riscv::OPCODE::G_SPLAT_VECTOR_SPLIT_I64_VL)
  .value("G_SRAW", LIEF::assembly::riscv::OPCODE::G_SRAW)
  .value("G_SRLW", LIEF::assembly::riscv::OPCODE::G_SRLW)
  .value("G_VMCLR_VL", LIEF::assembly::riscv::OPCODE::G_VMCLR_VL)
  .value("G_VMSET_VL", LIEF::assembly::riscv::OPCODE::G_VMSET_VL)
  .value("G_VMV_V_V_VL", LIEF::assembly::riscv::OPCODE::G_VMV_V_V_VL)
  .value("G_VSLIDEDOWN_VL", LIEF::assembly::riscv::OPCODE::G_VSLIDEDOWN_VL)
  .value("G_VSLIDEUP_VL", LIEF::assembly::riscv::OPCODE::G_VSLIDEUP_VL)
  .value("HWASAN_CHECK_MEMACCESS_SHORTGRANULES", LIEF::assembly::riscv::OPCODE::HWASAN_CHECK_MEMACCESS_SHORTGRANULES)
  .value("KCFI_CHECK", LIEF::assembly::riscv::OPCODE::KCFI_CHECK)
  .value("PROBED_STACKALLOC", LIEF::assembly::riscv::OPCODE::PROBED_STACKALLOC)
  .value("PROBED_STACKALLOC_DYN", LIEF::assembly::riscv::OPCODE::PROBED_STACKALLOC_DYN)
  .value("PROBED_STACKALLOC_RVV", LIEF::assembly::riscv::OPCODE::PROBED_STACKALLOC_RVV)
  .value("PseudoAddTPRel", LIEF::assembly::riscv::OPCODE::PseudoAddTPRel)
  .value("PseudoAtomicLoadNand32", LIEF::assembly::riscv::OPCODE::PseudoAtomicLoadNand32)
  .value("PseudoAtomicLoadNand64", LIEF::assembly::riscv::OPCODE::PseudoAtomicLoadNand64)
  .value("PseudoBR", LIEF::assembly::riscv::OPCODE::PseudoBR)
  .value("PseudoBRIND", LIEF::assembly::riscv::OPCODE::PseudoBRIND)
  .value("PseudoBRINDNonX7", LIEF::assembly::riscv::OPCODE::PseudoBRINDNonX7)
  .value("PseudoBRINDX7", LIEF::assembly::riscv::OPCODE::PseudoBRINDX7)
  .value("PseudoCALL", LIEF::assembly::riscv::OPCODE::PseudoCALL)
  .value("PseudoCALLIndirect", LIEF::assembly::riscv::OPCODE::PseudoCALLIndirect)
  .value("PseudoCALLIndirectNonX7", LIEF::assembly::riscv::OPCODE::PseudoCALLIndirectNonX7)
  .value("PseudoCALLIndirectX7", LIEF::assembly::riscv::OPCODE::PseudoCALLIndirectX7)
  .value("PseudoCALLReg", LIEF::assembly::riscv::OPCODE::PseudoCALLReg)
  .value("PseudoCCADD", LIEF::assembly::riscv::OPCODE::PseudoCCADD)
  .value("PseudoCCADDI", LIEF::assembly::riscv::OPCODE::PseudoCCADDI)
  .value("PseudoCCADDIW", LIEF::assembly::riscv::OPCODE::PseudoCCADDIW)
  .value("PseudoCCADDW", LIEF::assembly::riscv::OPCODE::PseudoCCADDW)
  .value("PseudoCCAND", LIEF::assembly::riscv::OPCODE::PseudoCCAND)
  .value("PseudoCCANDI", LIEF::assembly::riscv::OPCODE::PseudoCCANDI)
  .value("PseudoCCANDN", LIEF::assembly::riscv::OPCODE::PseudoCCANDN)
  .value("PseudoCCMOVGPR", LIEF::assembly::riscv::OPCODE::PseudoCCMOVGPR)
  .value("PseudoCCMOVGPRNoX0", LIEF::assembly::riscv::OPCODE::PseudoCCMOVGPRNoX0)
  .value("PseudoCCNDS_BFOS", LIEF::assembly::riscv::OPCODE::PseudoCCNDS_BFOS)
  .value("PseudoCCNDS_BFOZ", LIEF::assembly::riscv::OPCODE::PseudoCCNDS_BFOZ)
  .value("PseudoCCOR", LIEF::assembly::riscv::OPCODE::PseudoCCOR)
  .value("PseudoCCORI", LIEF::assembly::riscv::OPCODE::PseudoCCORI)
  .value("PseudoCCORN", LIEF::assembly::riscv::OPCODE::PseudoCCORN)
  .value("PseudoCCSLL", LIEF::assembly::riscv::OPCODE::PseudoCCSLL)
  .value("PseudoCCSLLI", LIEF::assembly::riscv::OPCODE::PseudoCCSLLI)
  .value("PseudoCCSLLIW", LIEF::assembly::riscv::OPCODE::PseudoCCSLLIW)
  .value("PseudoCCSLLW", LIEF::assembly::riscv::OPCODE::PseudoCCSLLW)
  .value("PseudoCCSRA", LIEF::assembly::riscv::OPCODE::PseudoCCSRA)
  .value("PseudoCCSRAI", LIEF::assembly::riscv::OPCODE::PseudoCCSRAI)
  .value("PseudoCCSRAIW", LIEF::assembly::riscv::OPCODE::PseudoCCSRAIW)
  .value("PseudoCCSRAW", LIEF::assembly::riscv::OPCODE::PseudoCCSRAW)
  .value("PseudoCCSRL", LIEF::assembly::riscv::OPCODE::PseudoCCSRL)
  .value("PseudoCCSRLI", LIEF::assembly::riscv::OPCODE::PseudoCCSRLI)
  .value("PseudoCCSRLIW", LIEF::assembly::riscv::OPCODE::PseudoCCSRLIW)
  .value("PseudoCCSRLW", LIEF::assembly::riscv::OPCODE::PseudoCCSRLW)
  .value("PseudoCCSUB", LIEF::assembly::riscv::OPCODE::PseudoCCSUB)
  .value("PseudoCCSUBW", LIEF::assembly::riscv::OPCODE::PseudoCCSUBW)
  .value("PseudoCCXNOR", LIEF::assembly::riscv::OPCODE::PseudoCCXNOR)
  .value("PseudoCCXOR", LIEF::assembly::riscv::OPCODE::PseudoCCXOR)
  .value("PseudoCCXORI", LIEF::assembly::riscv::OPCODE::PseudoCCXORI)
  .value("PseudoC_ADDI_NOP", LIEF::assembly::riscv::OPCODE::PseudoC_ADDI_NOP)
  .value("PseudoCmpXchg32", LIEF::assembly::riscv::OPCODE::PseudoCmpXchg32)
  .value("PseudoCmpXchg64", LIEF::assembly::riscv::OPCODE::PseudoCmpXchg64)
  .value("PseudoFLD", LIEF::assembly::riscv::OPCODE::PseudoFLD)
  .value("PseudoFLH", LIEF::assembly::riscv::OPCODE::PseudoFLH)
  .value("PseudoFLQ", LIEF::assembly::riscv::OPCODE::PseudoFLQ)
  .value("PseudoFLW", LIEF::assembly::riscv::OPCODE::PseudoFLW)
  .value("PseudoFROUND_D", LIEF::assembly::riscv::OPCODE::PseudoFROUND_D)
  .value("PseudoFROUND_D_IN32X", LIEF::assembly::riscv::OPCODE::PseudoFROUND_D_IN32X)
  .value("PseudoFROUND_D_INX", LIEF::assembly::riscv::OPCODE::PseudoFROUND_D_INX)
  .value("PseudoFROUND_H", LIEF::assembly::riscv::OPCODE::PseudoFROUND_H)
  .value("PseudoFROUND_H_INX", LIEF::assembly::riscv::OPCODE::PseudoFROUND_H_INX)
  .value("PseudoFROUND_S", LIEF::assembly::riscv::OPCODE::PseudoFROUND_S)
  .value("PseudoFROUND_S_INX", LIEF::assembly::riscv::OPCODE::PseudoFROUND_S_INX)
  .value("PseudoFSD", LIEF::assembly::riscv::OPCODE::PseudoFSD)
  .value("PseudoFSH", LIEF::assembly::riscv::OPCODE::PseudoFSH)
  .value("PseudoFSQ", LIEF::assembly::riscv::OPCODE::PseudoFSQ)
  .value("PseudoFSW", LIEF::assembly::riscv::OPCODE::PseudoFSW)
  .value("PseudoJump", LIEF::assembly::riscv::OPCODE::PseudoJump)
  .value("PseudoLA", LIEF::assembly::riscv::OPCODE::PseudoLA)
  .value("PseudoLAImm", LIEF::assembly::riscv::OPCODE::PseudoLAImm)
  .value("PseudoLA_TLSDESC", LIEF::assembly::riscv::OPCODE::PseudoLA_TLSDESC)
  .value("PseudoLA_TLS_GD", LIEF::assembly::riscv::OPCODE::PseudoLA_TLS_GD)
  .value("PseudoLA_TLS_IE", LIEF::assembly::riscv::OPCODE::PseudoLA_TLS_IE)
  .value("PseudoLB", LIEF::assembly::riscv::OPCODE::PseudoLB)
  .value("PseudoLBU", LIEF::assembly::riscv::OPCODE::PseudoLBU)
  .value("PseudoLD", LIEF::assembly::riscv::OPCODE::PseudoLD)
  .value("PseudoLD_RV32", LIEF::assembly::riscv::OPCODE::PseudoLD_RV32)
  .value("PseudoLGA", LIEF::assembly::riscv::OPCODE::PseudoLGA)
  .value("PseudoLH", LIEF::assembly::riscv::OPCODE::PseudoLH)
  .value("PseudoLHU", LIEF::assembly::riscv::OPCODE::PseudoLHU)
  .value("PseudoLI", LIEF::assembly::riscv::OPCODE::PseudoLI)
  .value("PseudoLLA", LIEF::assembly::riscv::OPCODE::PseudoLLA)
  .value("PseudoLLAImm", LIEF::assembly::riscv::OPCODE::PseudoLLAImm)
  .value("PseudoLW", LIEF::assembly::riscv::OPCODE::PseudoLW)
  .value("PseudoLWU", LIEF::assembly::riscv::OPCODE::PseudoLWU)
  .value("PseudoLongBEQ", LIEF::assembly::riscv::OPCODE::PseudoLongBEQ)
  .value("PseudoLongBGE", LIEF::assembly::riscv::OPCODE::PseudoLongBGE)
  .value("PseudoLongBGEU", LIEF::assembly::riscv::OPCODE::PseudoLongBGEU)
  .value("PseudoLongBLT", LIEF::assembly::riscv::OPCODE::PseudoLongBLT)
  .value("PseudoLongBLTU", LIEF::assembly::riscv::OPCODE::PseudoLongBLTU)
  .value("PseudoLongBNE", LIEF::assembly::riscv::OPCODE::PseudoLongBNE)
  .value("PseudoLongQC_BEQI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_BEQI)
  .value("PseudoLongQC_BGEI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_BGEI)
  .value("PseudoLongQC_BGEUI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_BGEUI)
  .value("PseudoLongQC_BLTI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_BLTI)
  .value("PseudoLongQC_BLTUI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_BLTUI)
  .value("PseudoLongQC_BNEI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_BNEI)
  .value("PseudoLongQC_E_BEQI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_E_BEQI)
  .value("PseudoLongQC_E_BGEI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_E_BGEI)
  .value("PseudoLongQC_E_BGEUI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_E_BGEUI)
  .value("PseudoLongQC_E_BLTI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_E_BLTI)
  .value("PseudoLongQC_E_BLTUI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_E_BLTUI)
  .value("PseudoLongQC_E_BNEI", LIEF::assembly::riscv::OPCODE::PseudoLongQC_E_BNEI)
  .value("PseudoMV_FPR16INX", LIEF::assembly::riscv::OPCODE::PseudoMV_FPR16INX)
  .value("PseudoMV_FPR32INX", LIEF::assembly::riscv::OPCODE::PseudoMV_FPR32INX)
  .value("PseudoMaskedAtomicLoadAdd32", LIEF::assembly::riscv::OPCODE::PseudoMaskedAtomicLoadAdd32)
  .value("PseudoMaskedAtomicLoadMax32", LIEF::assembly::riscv::OPCODE::PseudoMaskedAtomicLoadMax32)
  .value("PseudoMaskedAtomicLoadMin32", LIEF::assembly::riscv::OPCODE::PseudoMaskedAtomicLoadMin32)
  .value("PseudoMaskedAtomicLoadNand32", LIEF::assembly::riscv::OPCODE::PseudoMaskedAtomicLoadNand32)
  .value("PseudoMaskedAtomicLoadSub32", LIEF::assembly::riscv::OPCODE::PseudoMaskedAtomicLoadSub32)
  .value("PseudoMaskedAtomicLoadUMax32", LIEF::assembly::riscv::OPCODE::PseudoMaskedAtomicLoadUMax32)
  .value("PseudoMaskedAtomicLoadUMin32", LIEF::assembly::riscv::OPCODE::PseudoMaskedAtomicLoadUMin32)
  .value("PseudoMaskedAtomicSwap32", LIEF::assembly::riscv::OPCODE::PseudoMaskedAtomicSwap32)
  .value("PseudoMaskedCmpXchg32", LIEF::assembly::riscv::OPCODE::PseudoMaskedCmpXchg32)
  .value("PseudoMovAddr", LIEF::assembly::riscv::OPCODE::PseudoMovAddr)
  .value("PseudoMovImm", LIEF::assembly::riscv::OPCODE::PseudoMovImm)
  .value("PseudoNDS_VD4DOTSU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTSU_VV_M1)
  .value("PseudoNDS_VD4DOTSU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTSU_VV_M1_MASK)
  .value("PseudoNDS_VD4DOTSU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTSU_VV_M2)
  .value("PseudoNDS_VD4DOTSU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTSU_VV_M2_MASK)
  .value("PseudoNDS_VD4DOTSU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTSU_VV_M4)
  .value("PseudoNDS_VD4DOTSU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTSU_VV_M4_MASK)
  .value("PseudoNDS_VD4DOTSU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTSU_VV_M8)
  .value("PseudoNDS_VD4DOTSU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTSU_VV_M8_MASK)
  .value("PseudoNDS_VD4DOTSU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTSU_VV_MF2)
  .value("PseudoNDS_VD4DOTSU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTSU_VV_MF2_MASK)
  .value("PseudoNDS_VD4DOTS_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTS_VV_M1)
  .value("PseudoNDS_VD4DOTS_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTS_VV_M1_MASK)
  .value("PseudoNDS_VD4DOTS_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTS_VV_M2)
  .value("PseudoNDS_VD4DOTS_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTS_VV_M2_MASK)
  .value("PseudoNDS_VD4DOTS_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTS_VV_M4)
  .value("PseudoNDS_VD4DOTS_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTS_VV_M4_MASK)
  .value("PseudoNDS_VD4DOTS_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTS_VV_M8)
  .value("PseudoNDS_VD4DOTS_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTS_VV_M8_MASK)
  .value("PseudoNDS_VD4DOTS_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTS_VV_MF2)
  .value("PseudoNDS_VD4DOTS_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTS_VV_MF2_MASK)
  .value("PseudoNDS_VD4DOTU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTU_VV_M1)
  .value("PseudoNDS_VD4DOTU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTU_VV_M1_MASK)
  .value("PseudoNDS_VD4DOTU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTU_VV_M2)
  .value("PseudoNDS_VD4DOTU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTU_VV_M2_MASK)
  .value("PseudoNDS_VD4DOTU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTU_VV_M4)
  .value("PseudoNDS_VD4DOTU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTU_VV_M4_MASK)
  .value("PseudoNDS_VD4DOTU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTU_VV_M8)
  .value("PseudoNDS_VD4DOTU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTU_VV_M8_MASK)
  .value("PseudoNDS_VD4DOTU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTU_VV_MF2)
  .value("PseudoNDS_VD4DOTU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VD4DOTU_VV_MF2_MASK)
  .value("PseudoNDS_VFNCVT_BF16_S_M1", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFNCVT_BF16_S_M1)
  .value("PseudoNDS_VFNCVT_BF16_S_M2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFNCVT_BF16_S_M2)
  .value("PseudoNDS_VFNCVT_BF16_S_M4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFNCVT_BF16_S_M4)
  .value("PseudoNDS_VFNCVT_BF16_S_MF2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFNCVT_BF16_S_MF2)
  .value("PseudoNDS_VFNCVT_BF16_S_MF4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFNCVT_BF16_S_MF4)
  .value("PseudoNDS_VFPMADB_VFPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_M1)
  .value("PseudoNDS_VFPMADB_VFPR16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_M1_MASK)
  .value("PseudoNDS_VFPMADB_VFPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_M2)
  .value("PseudoNDS_VFPMADB_VFPR16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_M2_MASK)
  .value("PseudoNDS_VFPMADB_VFPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_M4)
  .value("PseudoNDS_VFPMADB_VFPR16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_M4_MASK)
  .value("PseudoNDS_VFPMADB_VFPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_M8)
  .value("PseudoNDS_VFPMADB_VFPR16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_M8_MASK)
  .value("PseudoNDS_VFPMADB_VFPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_MF2)
  .value("PseudoNDS_VFPMADB_VFPR16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_MF2_MASK)
  .value("PseudoNDS_VFPMADB_VFPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_MF4)
  .value("PseudoNDS_VFPMADB_VFPR16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADB_VFPR16_MF4_MASK)
  .value("PseudoNDS_VFPMADT_VFPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_M1)
  .value("PseudoNDS_VFPMADT_VFPR16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_M1_MASK)
  .value("PseudoNDS_VFPMADT_VFPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_M2)
  .value("PseudoNDS_VFPMADT_VFPR16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_M2_MASK)
  .value("PseudoNDS_VFPMADT_VFPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_M4)
  .value("PseudoNDS_VFPMADT_VFPR16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_M4_MASK)
  .value("PseudoNDS_VFPMADT_VFPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_M8)
  .value("PseudoNDS_VFPMADT_VFPR16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_M8_MASK)
  .value("PseudoNDS_VFPMADT_VFPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_MF2)
  .value("PseudoNDS_VFPMADT_VFPR16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_MF2_MASK)
  .value("PseudoNDS_VFPMADT_VFPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_MF4)
  .value("PseudoNDS_VFPMADT_VFPR16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFPMADT_VFPR16_MF4_MASK)
  .value("PseudoNDS_VFWCVT_S_BF16_M1", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFWCVT_S_BF16_M1)
  .value("PseudoNDS_VFWCVT_S_BF16_M2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFWCVT_S_BF16_M2)
  .value("PseudoNDS_VFWCVT_S_BF16_M4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFWCVT_S_BF16_M4)
  .value("PseudoNDS_VFWCVT_S_BF16_MF2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFWCVT_S_BF16_MF2)
  .value("PseudoNDS_VFWCVT_S_BF16_MF4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VFWCVT_S_BF16_MF4)
  .value("PseudoNDS_VLN8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_M1)
  .value("PseudoNDS_VLN8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_M1_MASK)
  .value("PseudoNDS_VLN8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_M2)
  .value("PseudoNDS_VLN8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_M2_MASK)
  .value("PseudoNDS_VLN8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_M4)
  .value("PseudoNDS_VLN8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_M4_MASK)
  .value("PseudoNDS_VLN8_V_M8", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_M8)
  .value("PseudoNDS_VLN8_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_M8_MASK)
  .value("PseudoNDS_VLN8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_MF2)
  .value("PseudoNDS_VLN8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_MF2_MASK)
  .value("PseudoNDS_VLN8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_MF4)
  .value("PseudoNDS_VLN8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_MF4_MASK)
  .value("PseudoNDS_VLN8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_MF8)
  .value("PseudoNDS_VLN8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLN8_V_MF8_MASK)
  .value("PseudoNDS_VLNU8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_M1)
  .value("PseudoNDS_VLNU8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_M1_MASK)
  .value("PseudoNDS_VLNU8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_M2)
  .value("PseudoNDS_VLNU8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_M2_MASK)
  .value("PseudoNDS_VLNU8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_M4)
  .value("PseudoNDS_VLNU8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_M4_MASK)
  .value("PseudoNDS_VLNU8_V_M8", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_M8)
  .value("PseudoNDS_VLNU8_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_M8_MASK)
  .value("PseudoNDS_VLNU8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_MF2)
  .value("PseudoNDS_VLNU8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_MF2_MASK)
  .value("PseudoNDS_VLNU8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_MF4)
  .value("PseudoNDS_VLNU8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_MF4_MASK)
  .value("PseudoNDS_VLNU8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_MF8)
  .value("PseudoNDS_VLNU8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoNDS_VLNU8_V_MF8_MASK)
  .value("PseudoQC_E_LB", LIEF::assembly::riscv::OPCODE::PseudoQC_E_LB)
  .value("PseudoQC_E_LBU", LIEF::assembly::riscv::OPCODE::PseudoQC_E_LBU)
  .value("PseudoQC_E_LH", LIEF::assembly::riscv::OPCODE::PseudoQC_E_LH)
  .value("PseudoQC_E_LHU", LIEF::assembly::riscv::OPCODE::PseudoQC_E_LHU)
  .value("PseudoQC_E_LW", LIEF::assembly::riscv::OPCODE::PseudoQC_E_LW)
  .value("PseudoQC_E_SB", LIEF::assembly::riscv::OPCODE::PseudoQC_E_SB)
  .value("PseudoQC_E_SH", LIEF::assembly::riscv::OPCODE::PseudoQC_E_SH)
  .value("PseudoQC_E_SW", LIEF::assembly::riscv::OPCODE::PseudoQC_E_SW)
  .value("PseudoQuietFLE_D", LIEF::assembly::riscv::OPCODE::PseudoQuietFLE_D)
  .value("PseudoQuietFLE_D_IN32X", LIEF::assembly::riscv::OPCODE::PseudoQuietFLE_D_IN32X)
  .value("PseudoQuietFLE_D_INX", LIEF::assembly::riscv::OPCODE::PseudoQuietFLE_D_INX)
  .value("PseudoQuietFLE_H", LIEF::assembly::riscv::OPCODE::PseudoQuietFLE_H)
  .value("PseudoQuietFLE_H_INX", LIEF::assembly::riscv::OPCODE::PseudoQuietFLE_H_INX)
  .value("PseudoQuietFLE_S", LIEF::assembly::riscv::OPCODE::PseudoQuietFLE_S)
  .value("PseudoQuietFLE_S_INX", LIEF::assembly::riscv::OPCODE::PseudoQuietFLE_S_INX)
  .value("PseudoQuietFLT_D", LIEF::assembly::riscv::OPCODE::PseudoQuietFLT_D)
  .value("PseudoQuietFLT_D_IN32X", LIEF::assembly::riscv::OPCODE::PseudoQuietFLT_D_IN32X)
  .value("PseudoQuietFLT_D_INX", LIEF::assembly::riscv::OPCODE::PseudoQuietFLT_D_INX)
  .value("PseudoQuietFLT_H", LIEF::assembly::riscv::OPCODE::PseudoQuietFLT_H)
  .value("PseudoQuietFLT_H_INX", LIEF::assembly::riscv::OPCODE::PseudoQuietFLT_H_INX)
  .value("PseudoQuietFLT_S", LIEF::assembly::riscv::OPCODE::PseudoQuietFLT_S)
  .value("PseudoQuietFLT_S_INX", LIEF::assembly::riscv::OPCODE::PseudoQuietFLT_S_INX)
  .value("PseudoRET", LIEF::assembly::riscv::OPCODE::PseudoRET)
  .value("PseudoRI_VEXTRACT_M1", LIEF::assembly::riscv::OPCODE::PseudoRI_VEXTRACT_M1)
  .value("PseudoRI_VEXTRACT_M2", LIEF::assembly::riscv::OPCODE::PseudoRI_VEXTRACT_M2)
  .value("PseudoRI_VEXTRACT_M4", LIEF::assembly::riscv::OPCODE::PseudoRI_VEXTRACT_M4)
  .value("PseudoRI_VEXTRACT_M8", LIEF::assembly::riscv::OPCODE::PseudoRI_VEXTRACT_M8)
  .value("PseudoRI_VEXTRACT_MF2", LIEF::assembly::riscv::OPCODE::PseudoRI_VEXTRACT_MF2)
  .value("PseudoRI_VEXTRACT_MF4", LIEF::assembly::riscv::OPCODE::PseudoRI_VEXTRACT_MF4)
  .value("PseudoRI_VEXTRACT_MF8", LIEF::assembly::riscv::OPCODE::PseudoRI_VEXTRACT_MF8)
  .value("PseudoRI_VINSERT_M1", LIEF::assembly::riscv::OPCODE::PseudoRI_VINSERT_M1)
  .value("PseudoRI_VINSERT_M2", LIEF::assembly::riscv::OPCODE::PseudoRI_VINSERT_M2)
  .value("PseudoRI_VINSERT_M4", LIEF::assembly::riscv::OPCODE::PseudoRI_VINSERT_M4)
  .value("PseudoRI_VINSERT_M8", LIEF::assembly::riscv::OPCODE::PseudoRI_VINSERT_M8)
  .value("PseudoRI_VINSERT_MF2", LIEF::assembly::riscv::OPCODE::PseudoRI_VINSERT_MF2)
  .value("PseudoRI_VINSERT_MF4", LIEF::assembly::riscv::OPCODE::PseudoRI_VINSERT_MF4)
  .value("PseudoRI_VINSERT_MF8", LIEF::assembly::riscv::OPCODE::PseudoRI_VINSERT_MF8)
  .value("PseudoRI_VUNZIP2A_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_M1)
  .value("PseudoRI_VUNZIP2A_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_M1_MASK)
  .value("PseudoRI_VUNZIP2A_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_M2)
  .value("PseudoRI_VUNZIP2A_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_M2_MASK)
  .value("PseudoRI_VUNZIP2A_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_M4)
  .value("PseudoRI_VUNZIP2A_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_M4_MASK)
  .value("PseudoRI_VUNZIP2A_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_M8)
  .value("PseudoRI_VUNZIP2A_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_M8_MASK)
  .value("PseudoRI_VUNZIP2A_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_MF2)
  .value("PseudoRI_VUNZIP2A_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_MF2_MASK)
  .value("PseudoRI_VUNZIP2A_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_MF4)
  .value("PseudoRI_VUNZIP2A_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_MF4_MASK)
  .value("PseudoRI_VUNZIP2A_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_MF8)
  .value("PseudoRI_VUNZIP2A_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2A_VV_MF8_MASK)
  .value("PseudoRI_VUNZIP2B_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_M1)
  .value("PseudoRI_VUNZIP2B_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_M1_MASK)
  .value("PseudoRI_VUNZIP2B_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_M2)
  .value("PseudoRI_VUNZIP2B_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_M2_MASK)
  .value("PseudoRI_VUNZIP2B_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_M4);
  opcodes.value("PseudoRI_VUNZIP2B_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_M4_MASK)
  .value("PseudoRI_VUNZIP2B_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_M8)
  .value("PseudoRI_VUNZIP2B_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_M8_MASK)
  .value("PseudoRI_VUNZIP2B_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_MF2)
  .value("PseudoRI_VUNZIP2B_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_MF2_MASK)
  .value("PseudoRI_VUNZIP2B_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_MF4)
  .value("PseudoRI_VUNZIP2B_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_MF4_MASK)
  .value("PseudoRI_VUNZIP2B_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_MF8)
  .value("PseudoRI_VUNZIP2B_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VUNZIP2B_VV_MF8_MASK)
  .value("PseudoRI_VZIP2A_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_M1)
  .value("PseudoRI_VZIP2A_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_M1_MASK)
  .value("PseudoRI_VZIP2A_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_M2)
  .value("PseudoRI_VZIP2A_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_M2_MASK)
  .value("PseudoRI_VZIP2A_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_M4)
  .value("PseudoRI_VZIP2A_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_M4_MASK)
  .value("PseudoRI_VZIP2A_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_M8)
  .value("PseudoRI_VZIP2A_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_M8_MASK)
  .value("PseudoRI_VZIP2A_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_MF2)
  .value("PseudoRI_VZIP2A_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_MF2_MASK)
  .value("PseudoRI_VZIP2A_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_MF4)
  .value("PseudoRI_VZIP2A_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_MF4_MASK)
  .value("PseudoRI_VZIP2A_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_MF8)
  .value("PseudoRI_VZIP2A_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2A_VV_MF8_MASK)
  .value("PseudoRI_VZIP2B_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_M1)
  .value("PseudoRI_VZIP2B_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_M1_MASK)
  .value("PseudoRI_VZIP2B_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_M2)
  .value("PseudoRI_VZIP2B_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_M2_MASK)
  .value("PseudoRI_VZIP2B_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_M4)
  .value("PseudoRI_VZIP2B_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_M4_MASK)
  .value("PseudoRI_VZIP2B_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_M8)
  .value("PseudoRI_VZIP2B_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_M8_MASK)
  .value("PseudoRI_VZIP2B_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_MF2)
  .value("PseudoRI_VZIP2B_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_MF2_MASK)
  .value("PseudoRI_VZIP2B_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_MF4)
  .value("PseudoRI_VZIP2B_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_MF4_MASK)
  .value("PseudoRI_VZIP2B_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_MF8)
  .value("PseudoRI_VZIP2B_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIP2B_VV_MF8_MASK)
  .value("PseudoRI_VZIPEVEN_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_M1)
  .value("PseudoRI_VZIPEVEN_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_M1_MASK)
  .value("PseudoRI_VZIPEVEN_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_M2)
  .value("PseudoRI_VZIPEVEN_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_M2_MASK)
  .value("PseudoRI_VZIPEVEN_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_M4)
  .value("PseudoRI_VZIPEVEN_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_M4_MASK)
  .value("PseudoRI_VZIPEVEN_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_M8)
  .value("PseudoRI_VZIPEVEN_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_M8_MASK)
  .value("PseudoRI_VZIPEVEN_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_MF2)
  .value("PseudoRI_VZIPEVEN_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_MF2_MASK)
  .value("PseudoRI_VZIPEVEN_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_MF4)
  .value("PseudoRI_VZIPEVEN_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_MF4_MASK)
  .value("PseudoRI_VZIPEVEN_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_MF8)
  .value("PseudoRI_VZIPEVEN_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPEVEN_VV_MF8_MASK)
  .value("PseudoRI_VZIPODD_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_M1)
  .value("PseudoRI_VZIPODD_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_M1_MASK)
  .value("PseudoRI_VZIPODD_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_M2)
  .value("PseudoRI_VZIPODD_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_M2_MASK)
  .value("PseudoRI_VZIPODD_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_M4)
  .value("PseudoRI_VZIPODD_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_M4_MASK)
  .value("PseudoRI_VZIPODD_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_M8)
  .value("PseudoRI_VZIPODD_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_M8_MASK)
  .value("PseudoRI_VZIPODD_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_MF2)
  .value("PseudoRI_VZIPODD_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_MF2_MASK)
  .value("PseudoRI_VZIPODD_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_MF4)
  .value("PseudoRI_VZIPODD_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_MF4_MASK)
  .value("PseudoRI_VZIPODD_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_MF8)
  .value("PseudoRI_VZIPODD_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoRI_VZIPODD_VV_MF8_MASK)
  .value("PseudoRV32ZdinxLD", LIEF::assembly::riscv::OPCODE::PseudoRV32ZdinxLD)
  .value("PseudoRV32ZdinxSD", LIEF::assembly::riscv::OPCODE::PseudoRV32ZdinxSD)
  .value("PseudoReadVL", LIEF::assembly::riscv::OPCODE::PseudoReadVL)
  .value("PseudoReadVLENB", LIEF::assembly::riscv::OPCODE::PseudoReadVLENB)
  .value("PseudoReadVLENBViaVSETVLIX0", LIEF::assembly::riscv::OPCODE::PseudoReadVLENBViaVSETVLIX0)
  .value("PseudoSB", LIEF::assembly::riscv::OPCODE::PseudoSB)
  .value("PseudoSD", LIEF::assembly::riscv::OPCODE::PseudoSD)
  .value("PseudoSD_RV32", LIEF::assembly::riscv::OPCODE::PseudoSD_RV32)
  .value("PseudoSEXT_B", LIEF::assembly::riscv::OPCODE::PseudoSEXT_B)
  .value("PseudoSEXT_H", LIEF::assembly::riscv::OPCODE::PseudoSEXT_H)
  .value("PseudoSF_VC_FPR16VV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VV_SE_M1)
  .value("PseudoSF_VC_FPR16VV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VV_SE_M2)
  .value("PseudoSF_VC_FPR16VV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VV_SE_M4)
  .value("PseudoSF_VC_FPR16VV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VV_SE_M8)
  .value("PseudoSF_VC_FPR16VV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VV_SE_MF2)
  .value("PseudoSF_VC_FPR16VV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VV_SE_MF4)
  .value("PseudoSF_VC_FPR16VW_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VW_SE_M1)
  .value("PseudoSF_VC_FPR16VW_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VW_SE_M2)
  .value("PseudoSF_VC_FPR16VW_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VW_SE_M4)
  .value("PseudoSF_VC_FPR16VW_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VW_SE_M8)
  .value("PseudoSF_VC_FPR16VW_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VW_SE_MF2)
  .value("PseudoSF_VC_FPR16VW_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16VW_SE_MF4)
  .value("PseudoSF_VC_FPR16V_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16V_SE_M1)
  .value("PseudoSF_VC_FPR16V_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16V_SE_M2)
  .value("PseudoSF_VC_FPR16V_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16V_SE_M4)
  .value("PseudoSF_VC_FPR16V_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16V_SE_M8)
  .value("PseudoSF_VC_FPR16V_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16V_SE_MF2)
  .value("PseudoSF_VC_FPR16V_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR16V_SE_MF4)
  .value("PseudoSF_VC_FPR32VV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32VV_SE_M1)
  .value("PseudoSF_VC_FPR32VV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32VV_SE_M2)
  .value("PseudoSF_VC_FPR32VV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32VV_SE_M4)
  .value("PseudoSF_VC_FPR32VV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32VV_SE_M8)
  .value("PseudoSF_VC_FPR32VV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32VV_SE_MF2)
  .value("PseudoSF_VC_FPR32VW_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32VW_SE_M1)
  .value("PseudoSF_VC_FPR32VW_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32VW_SE_M2)
  .value("PseudoSF_VC_FPR32VW_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32VW_SE_M4)
  .value("PseudoSF_VC_FPR32VW_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32VW_SE_M8)
  .value("PseudoSF_VC_FPR32VW_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32VW_SE_MF2)
  .value("PseudoSF_VC_FPR32V_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32V_SE_M1)
  .value("PseudoSF_VC_FPR32V_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32V_SE_M2)
  .value("PseudoSF_VC_FPR32V_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32V_SE_M4)
  .value("PseudoSF_VC_FPR32V_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32V_SE_M8)
  .value("PseudoSF_VC_FPR32V_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR32V_SE_MF2)
  .value("PseudoSF_VC_FPR64VV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR64VV_SE_M1)
  .value("PseudoSF_VC_FPR64VV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR64VV_SE_M2)
  .value("PseudoSF_VC_FPR64VV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR64VV_SE_M4)
  .value("PseudoSF_VC_FPR64VV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR64VV_SE_M8)
  .value("PseudoSF_VC_FPR64V_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR64V_SE_M1)
  .value("PseudoSF_VC_FPR64V_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR64V_SE_M2)
  .value("PseudoSF_VC_FPR64V_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR64V_SE_M4)
  .value("PseudoSF_VC_FPR64V_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_FPR64V_SE_M8)
  .value("PseudoSF_VC_IVV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVV_SE_M1)
  .value("PseudoSF_VC_IVV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVV_SE_M2)
  .value("PseudoSF_VC_IVV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVV_SE_M4)
  .value("PseudoSF_VC_IVV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVV_SE_M8)
  .value("PseudoSF_VC_IVV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVV_SE_MF2)
  .value("PseudoSF_VC_IVV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVV_SE_MF4)
  .value("PseudoSF_VC_IVV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVV_SE_MF8)
  .value("PseudoSF_VC_IVW_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVW_SE_M1)
  .value("PseudoSF_VC_IVW_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVW_SE_M2)
  .value("PseudoSF_VC_IVW_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVW_SE_M4)
  .value("PseudoSF_VC_IVW_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVW_SE_MF2)
  .value("PseudoSF_VC_IVW_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVW_SE_MF4)
  .value("PseudoSF_VC_IVW_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IVW_SE_MF8)
  .value("PseudoSF_VC_IV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IV_SE_M1)
  .value("PseudoSF_VC_IV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IV_SE_M2)
  .value("PseudoSF_VC_IV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IV_SE_M4)
  .value("PseudoSF_VC_IV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IV_SE_M8)
  .value("PseudoSF_VC_IV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IV_SE_MF2)
  .value("PseudoSF_VC_IV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IV_SE_MF4)
  .value("PseudoSF_VC_IV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_IV_SE_MF8)
  .value("PseudoSF_VC_I_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_I_SE_M1)
  .value("PseudoSF_VC_I_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_I_SE_M2)
  .value("PseudoSF_VC_I_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_I_SE_M4)
  .value("PseudoSF_VC_I_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_I_SE_M8)
  .value("PseudoSF_VC_I_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_I_SE_MF2)
  .value("PseudoSF_VC_I_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_I_SE_MF4)
  .value("PseudoSF_VC_I_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_I_SE_MF8)
  .value("PseudoSF_VC_VVV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVV_SE_M1)
  .value("PseudoSF_VC_VVV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVV_SE_M2)
  .value("PseudoSF_VC_VVV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVV_SE_M4)
  .value("PseudoSF_VC_VVV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVV_SE_M8)
  .value("PseudoSF_VC_VVV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVV_SE_MF2)
  .value("PseudoSF_VC_VVV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVV_SE_MF4)
  .value("PseudoSF_VC_VVV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVV_SE_MF8)
  .value("PseudoSF_VC_VVW_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVW_SE_M1)
  .value("PseudoSF_VC_VVW_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVW_SE_M2)
  .value("PseudoSF_VC_VVW_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVW_SE_M4)
  .value("PseudoSF_VC_VVW_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVW_SE_MF2)
  .value("PseudoSF_VC_VVW_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVW_SE_MF4)
  .value("PseudoSF_VC_VVW_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VVW_SE_MF8)
  .value("PseudoSF_VC_VV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VV_SE_M1)
  .value("PseudoSF_VC_VV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VV_SE_M2)
  .value("PseudoSF_VC_VV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VV_SE_M4)
  .value("PseudoSF_VC_VV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VV_SE_M8)
  .value("PseudoSF_VC_VV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VV_SE_MF2)
  .value("PseudoSF_VC_VV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VV_SE_MF4)
  .value("PseudoSF_VC_VV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_VV_SE_MF8)
  .value("PseudoSF_VC_V_FPR16VV_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_M1)
  .value("PseudoSF_VC_V_FPR16VV_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_M2)
  .value("PseudoSF_VC_V_FPR16VV_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_M4)
  .value("PseudoSF_VC_V_FPR16VV_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_M8)
  .value("PseudoSF_VC_V_FPR16VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_MF2)
  .value("PseudoSF_VC_V_FPR16VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_MF4)
  .value("PseudoSF_VC_V_FPR16VV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_SE_M1)
  .value("PseudoSF_VC_V_FPR16VV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_SE_M2)
  .value("PseudoSF_VC_V_FPR16VV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_SE_M4)
  .value("PseudoSF_VC_V_FPR16VV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_SE_M8)
  .value("PseudoSF_VC_V_FPR16VV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_SE_MF2)
  .value("PseudoSF_VC_V_FPR16VV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VV_SE_MF4)
  .value("PseudoSF_VC_V_FPR16VW_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_M1)
  .value("PseudoSF_VC_V_FPR16VW_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_M2)
  .value("PseudoSF_VC_V_FPR16VW_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_M4)
  .value("PseudoSF_VC_V_FPR16VW_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_M8)
  .value("PseudoSF_VC_V_FPR16VW_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_MF2)
  .value("PseudoSF_VC_V_FPR16VW_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_MF4)
  .value("PseudoSF_VC_V_FPR16VW_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_SE_M1)
  .value("PseudoSF_VC_V_FPR16VW_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_SE_M2)
  .value("PseudoSF_VC_V_FPR16VW_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_SE_M4)
  .value("PseudoSF_VC_V_FPR16VW_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_SE_M8)
  .value("PseudoSF_VC_V_FPR16VW_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_SE_MF2)
  .value("PseudoSF_VC_V_FPR16VW_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16VW_SE_MF4)
  .value("PseudoSF_VC_V_FPR16V_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_M1)
  .value("PseudoSF_VC_V_FPR16V_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_M2)
  .value("PseudoSF_VC_V_FPR16V_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_M4)
  .value("PseudoSF_VC_V_FPR16V_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_M8)
  .value("PseudoSF_VC_V_FPR16V_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_MF2)
  .value("PseudoSF_VC_V_FPR16V_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_MF4)
  .value("PseudoSF_VC_V_FPR16V_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_SE_M1)
  .value("PseudoSF_VC_V_FPR16V_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_SE_M2)
  .value("PseudoSF_VC_V_FPR16V_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_SE_M4)
  .value("PseudoSF_VC_V_FPR16V_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_SE_M8)
  .value("PseudoSF_VC_V_FPR16V_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_SE_MF2)
  .value("PseudoSF_VC_V_FPR16V_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR16V_SE_MF4)
  .value("PseudoSF_VC_V_FPR32VV_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VV_M1)
  .value("PseudoSF_VC_V_FPR32VV_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VV_M2)
  .value("PseudoSF_VC_V_FPR32VV_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VV_M4)
  .value("PseudoSF_VC_V_FPR32VV_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VV_M8)
  .value("PseudoSF_VC_V_FPR32VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VV_MF2)
  .value("PseudoSF_VC_V_FPR32VV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VV_SE_M1)
  .value("PseudoSF_VC_V_FPR32VV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VV_SE_M2)
  .value("PseudoSF_VC_V_FPR32VV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VV_SE_M4)
  .value("PseudoSF_VC_V_FPR32VV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VV_SE_M8)
  .value("PseudoSF_VC_V_FPR32VV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VV_SE_MF2)
  .value("PseudoSF_VC_V_FPR32VW_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VW_M1)
  .value("PseudoSF_VC_V_FPR32VW_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VW_M2)
  .value("PseudoSF_VC_V_FPR32VW_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VW_M4)
  .value("PseudoSF_VC_V_FPR32VW_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VW_M8)
  .value("PseudoSF_VC_V_FPR32VW_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VW_MF2)
  .value("PseudoSF_VC_V_FPR32VW_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VW_SE_M1)
  .value("PseudoSF_VC_V_FPR32VW_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VW_SE_M2)
  .value("PseudoSF_VC_V_FPR32VW_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VW_SE_M4)
  .value("PseudoSF_VC_V_FPR32VW_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VW_SE_M8)
  .value("PseudoSF_VC_V_FPR32VW_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32VW_SE_MF2)
  .value("PseudoSF_VC_V_FPR32V_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32V_M1)
  .value("PseudoSF_VC_V_FPR32V_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32V_M2)
  .value("PseudoSF_VC_V_FPR32V_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32V_M4)
  .value("PseudoSF_VC_V_FPR32V_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32V_M8)
  .value("PseudoSF_VC_V_FPR32V_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32V_MF2)
  .value("PseudoSF_VC_V_FPR32V_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32V_SE_M1)
  .value("PseudoSF_VC_V_FPR32V_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32V_SE_M2)
  .value("PseudoSF_VC_V_FPR32V_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32V_SE_M4)
  .value("PseudoSF_VC_V_FPR32V_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32V_SE_M8)
  .value("PseudoSF_VC_V_FPR32V_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR32V_SE_MF2)
  .value("PseudoSF_VC_V_FPR64VV_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64VV_M1)
  .value("PseudoSF_VC_V_FPR64VV_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64VV_M2)
  .value("PseudoSF_VC_V_FPR64VV_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64VV_M4)
  .value("PseudoSF_VC_V_FPR64VV_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64VV_M8)
  .value("PseudoSF_VC_V_FPR64VV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64VV_SE_M1)
  .value("PseudoSF_VC_V_FPR64VV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64VV_SE_M2)
  .value("PseudoSF_VC_V_FPR64VV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64VV_SE_M4)
  .value("PseudoSF_VC_V_FPR64VV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64VV_SE_M8)
  .value("PseudoSF_VC_V_FPR64V_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64V_M1)
  .value("PseudoSF_VC_V_FPR64V_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64V_M2)
  .value("PseudoSF_VC_V_FPR64V_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64V_M4)
  .value("PseudoSF_VC_V_FPR64V_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64V_M8)
  .value("PseudoSF_VC_V_FPR64V_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64V_SE_M1)
  .value("PseudoSF_VC_V_FPR64V_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64V_SE_M2)
  .value("PseudoSF_VC_V_FPR64V_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64V_SE_M4)
  .value("PseudoSF_VC_V_FPR64V_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_FPR64V_SE_M8)
  .value("PseudoSF_VC_V_IVV_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_M1)
  .value("PseudoSF_VC_V_IVV_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_M2)
  .value("PseudoSF_VC_V_IVV_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_M4)
  .value("PseudoSF_VC_V_IVV_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_M8)
  .value("PseudoSF_VC_V_IVV_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_MF2)
  .value("PseudoSF_VC_V_IVV_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_MF4)
  .value("PseudoSF_VC_V_IVV_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_MF8)
  .value("PseudoSF_VC_V_IVV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_SE_M1)
  .value("PseudoSF_VC_V_IVV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_SE_M2)
  .value("PseudoSF_VC_V_IVV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_SE_M4)
  .value("PseudoSF_VC_V_IVV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_SE_M8)
  .value("PseudoSF_VC_V_IVV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_SE_MF2)
  .value("PseudoSF_VC_V_IVV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_SE_MF4)
  .value("PseudoSF_VC_V_IVV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVV_SE_MF8)
  .value("PseudoSF_VC_V_IVW_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_M1)
  .value("PseudoSF_VC_V_IVW_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_M2)
  .value("PseudoSF_VC_V_IVW_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_M4)
  .value("PseudoSF_VC_V_IVW_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_MF2)
  .value("PseudoSF_VC_V_IVW_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_MF4)
  .value("PseudoSF_VC_V_IVW_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_MF8)
  .value("PseudoSF_VC_V_IVW_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_SE_M1)
  .value("PseudoSF_VC_V_IVW_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_SE_M2)
  .value("PseudoSF_VC_V_IVW_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_SE_M4)
  .value("PseudoSF_VC_V_IVW_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_SE_MF2)
  .value("PseudoSF_VC_V_IVW_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_SE_MF4)
  .value("PseudoSF_VC_V_IVW_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IVW_SE_MF8)
  .value("PseudoSF_VC_V_IV_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_M1)
  .value("PseudoSF_VC_V_IV_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_M2)
  .value("PseudoSF_VC_V_IV_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_M4)
  .value("PseudoSF_VC_V_IV_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_M8)
  .value("PseudoSF_VC_V_IV_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_MF2)
  .value("PseudoSF_VC_V_IV_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_MF4)
  .value("PseudoSF_VC_V_IV_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_MF8)
  .value("PseudoSF_VC_V_IV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_SE_M1)
  .value("PseudoSF_VC_V_IV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_SE_M2)
  .value("PseudoSF_VC_V_IV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_SE_M4)
  .value("PseudoSF_VC_V_IV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_SE_M8)
  .value("PseudoSF_VC_V_IV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_SE_MF2)
  .value("PseudoSF_VC_V_IV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_SE_MF4)
  .value("PseudoSF_VC_V_IV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_IV_SE_MF8)
  .value("PseudoSF_VC_V_I_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_M1)
  .value("PseudoSF_VC_V_I_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_M2)
  .value("PseudoSF_VC_V_I_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_M4)
  .value("PseudoSF_VC_V_I_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_M8)
  .value("PseudoSF_VC_V_I_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_MF2)
  .value("PseudoSF_VC_V_I_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_MF4)
  .value("PseudoSF_VC_V_I_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_MF8)
  .value("PseudoSF_VC_V_I_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_SE_M1)
  .value("PseudoSF_VC_V_I_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_SE_M2)
  .value("PseudoSF_VC_V_I_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_SE_M4)
  .value("PseudoSF_VC_V_I_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_SE_M8)
  .value("PseudoSF_VC_V_I_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_SE_MF2)
  .value("PseudoSF_VC_V_I_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_SE_MF4)
  .value("PseudoSF_VC_V_I_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_I_SE_MF8)
  .value("PseudoSF_VC_V_VVV_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_M1);
  opcodes.value("PseudoSF_VC_V_VVV_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_M2)
  .value("PseudoSF_VC_V_VVV_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_M4)
  .value("PseudoSF_VC_V_VVV_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_M8)
  .value("PseudoSF_VC_V_VVV_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_MF2)
  .value("PseudoSF_VC_V_VVV_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_MF4)
  .value("PseudoSF_VC_V_VVV_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_MF8)
  .value("PseudoSF_VC_V_VVV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_SE_M1)
  .value("PseudoSF_VC_V_VVV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_SE_M2)
  .value("PseudoSF_VC_V_VVV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_SE_M4)
  .value("PseudoSF_VC_V_VVV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_SE_M8)
  .value("PseudoSF_VC_V_VVV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_SE_MF2)
  .value("PseudoSF_VC_V_VVV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_SE_MF4)
  .value("PseudoSF_VC_V_VVV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVV_SE_MF8)
  .value("PseudoSF_VC_V_VVW_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_M1)
  .value("PseudoSF_VC_V_VVW_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_M2)
  .value("PseudoSF_VC_V_VVW_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_M4)
  .value("PseudoSF_VC_V_VVW_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_MF2)
  .value("PseudoSF_VC_V_VVW_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_MF4)
  .value("PseudoSF_VC_V_VVW_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_MF8)
  .value("PseudoSF_VC_V_VVW_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_SE_M1)
  .value("PseudoSF_VC_V_VVW_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_SE_M2)
  .value("PseudoSF_VC_V_VVW_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_SE_M4)
  .value("PseudoSF_VC_V_VVW_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_SE_MF2)
  .value("PseudoSF_VC_V_VVW_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_SE_MF4)
  .value("PseudoSF_VC_V_VVW_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VVW_SE_MF8)
  .value("PseudoSF_VC_V_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_M1)
  .value("PseudoSF_VC_V_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_M2)
  .value("PseudoSF_VC_V_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_M4)
  .value("PseudoSF_VC_V_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_M8)
  .value("PseudoSF_VC_V_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_MF2)
  .value("PseudoSF_VC_V_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_MF4)
  .value("PseudoSF_VC_V_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_MF8)
  .value("PseudoSF_VC_V_VV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_SE_M1)
  .value("PseudoSF_VC_V_VV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_SE_M2)
  .value("PseudoSF_VC_V_VV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_SE_M4)
  .value("PseudoSF_VC_V_VV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_SE_M8)
  .value("PseudoSF_VC_V_VV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_SE_MF2)
  .value("PseudoSF_VC_V_VV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_SE_MF4)
  .value("PseudoSF_VC_V_VV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_VV_SE_MF8)
  .value("PseudoSF_VC_V_XVV_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_M1)
  .value("PseudoSF_VC_V_XVV_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_M2)
  .value("PseudoSF_VC_V_XVV_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_M4)
  .value("PseudoSF_VC_V_XVV_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_M8)
  .value("PseudoSF_VC_V_XVV_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_MF2)
  .value("PseudoSF_VC_V_XVV_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_MF4)
  .value("PseudoSF_VC_V_XVV_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_MF8)
  .value("PseudoSF_VC_V_XVV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_SE_M1)
  .value("PseudoSF_VC_V_XVV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_SE_M2)
  .value("PseudoSF_VC_V_XVV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_SE_M4)
  .value("PseudoSF_VC_V_XVV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_SE_M8)
  .value("PseudoSF_VC_V_XVV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_SE_MF2)
  .value("PseudoSF_VC_V_XVV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_SE_MF4)
  .value("PseudoSF_VC_V_XVV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVV_SE_MF8)
  .value("PseudoSF_VC_V_XVW_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_M1)
  .value("PseudoSF_VC_V_XVW_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_M2)
  .value("PseudoSF_VC_V_XVW_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_M4)
  .value("PseudoSF_VC_V_XVW_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_MF2)
  .value("PseudoSF_VC_V_XVW_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_MF4)
  .value("PseudoSF_VC_V_XVW_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_MF8)
  .value("PseudoSF_VC_V_XVW_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_SE_M1)
  .value("PseudoSF_VC_V_XVW_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_SE_M2)
  .value("PseudoSF_VC_V_XVW_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_SE_M4)
  .value("PseudoSF_VC_V_XVW_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_SE_MF2)
  .value("PseudoSF_VC_V_XVW_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_SE_MF4)
  .value("PseudoSF_VC_V_XVW_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XVW_SE_MF8)
  .value("PseudoSF_VC_V_XV_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_M1)
  .value("PseudoSF_VC_V_XV_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_M2)
  .value("PseudoSF_VC_V_XV_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_M4)
  .value("PseudoSF_VC_V_XV_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_M8)
  .value("PseudoSF_VC_V_XV_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_MF2)
  .value("PseudoSF_VC_V_XV_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_MF4)
  .value("PseudoSF_VC_V_XV_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_MF8)
  .value("PseudoSF_VC_V_XV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_SE_M1)
  .value("PseudoSF_VC_V_XV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_SE_M2)
  .value("PseudoSF_VC_V_XV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_SE_M4)
  .value("PseudoSF_VC_V_XV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_SE_M8)
  .value("PseudoSF_VC_V_XV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_SE_MF2)
  .value("PseudoSF_VC_V_XV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_SE_MF4)
  .value("PseudoSF_VC_V_XV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_XV_SE_MF8)
  .value("PseudoSF_VC_V_X_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_M1)
  .value("PseudoSF_VC_V_X_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_M2)
  .value("PseudoSF_VC_V_X_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_M4)
  .value("PseudoSF_VC_V_X_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_M8)
  .value("PseudoSF_VC_V_X_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_MF2)
  .value("PseudoSF_VC_V_X_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_MF4)
  .value("PseudoSF_VC_V_X_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_MF8)
  .value("PseudoSF_VC_V_X_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_SE_M1)
  .value("PseudoSF_VC_V_X_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_SE_M2)
  .value("PseudoSF_VC_V_X_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_SE_M4)
  .value("PseudoSF_VC_V_X_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_SE_M8)
  .value("PseudoSF_VC_V_X_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_SE_MF2)
  .value("PseudoSF_VC_V_X_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_SE_MF4)
  .value("PseudoSF_VC_V_X_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_V_X_SE_MF8)
  .value("PseudoSF_VC_XVV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVV_SE_M1)
  .value("PseudoSF_VC_XVV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVV_SE_M2)
  .value("PseudoSF_VC_XVV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVV_SE_M4)
  .value("PseudoSF_VC_XVV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVV_SE_M8)
  .value("PseudoSF_VC_XVV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVV_SE_MF2)
  .value("PseudoSF_VC_XVV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVV_SE_MF4)
  .value("PseudoSF_VC_XVV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVV_SE_MF8)
  .value("PseudoSF_VC_XVW_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVW_SE_M1)
  .value("PseudoSF_VC_XVW_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVW_SE_M2)
  .value("PseudoSF_VC_XVW_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVW_SE_M4)
  .value("PseudoSF_VC_XVW_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVW_SE_MF2)
  .value("PseudoSF_VC_XVW_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVW_SE_MF4)
  .value("PseudoSF_VC_XVW_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XVW_SE_MF8)
  .value("PseudoSF_VC_XV_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XV_SE_M1)
  .value("PseudoSF_VC_XV_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XV_SE_M2)
  .value("PseudoSF_VC_XV_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XV_SE_M4)
  .value("PseudoSF_VC_XV_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XV_SE_M8)
  .value("PseudoSF_VC_XV_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XV_SE_MF2)
  .value("PseudoSF_VC_XV_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XV_SE_MF4)
  .value("PseudoSF_VC_XV_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_XV_SE_MF8)
  .value("PseudoSF_VC_X_SE_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_X_SE_M1)
  .value("PseudoSF_VC_X_SE_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_X_SE_M2)
  .value("PseudoSF_VC_X_SE_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_X_SE_M4)
  .value("PseudoSF_VC_X_SE_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_X_SE_M8)
  .value("PseudoSF_VC_X_SE_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_X_SE_MF2)
  .value("PseudoSF_VC_X_SE_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_X_SE_MF4)
  .value("PseudoSF_VC_X_SE_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VC_X_SE_MF8)
  .value("PseudoSF_VFNRCLIP_XU_F_QF_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_XU_F_QF_M1)
  .value("PseudoSF_VFNRCLIP_XU_F_QF_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_XU_F_QF_M1_MASK)
  .value("PseudoSF_VFNRCLIP_XU_F_QF_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_XU_F_QF_M2)
  .value("PseudoSF_VFNRCLIP_XU_F_QF_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_XU_F_QF_M2_MASK)
  .value("PseudoSF_VFNRCLIP_XU_F_QF_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_XU_F_QF_MF2)
  .value("PseudoSF_VFNRCLIP_XU_F_QF_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_XU_F_QF_MF2_MASK)
  .value("PseudoSF_VFNRCLIP_XU_F_QF_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_XU_F_QF_MF4)
  .value("PseudoSF_VFNRCLIP_XU_F_QF_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_XU_F_QF_MF4_MASK)
  .value("PseudoSF_VFNRCLIP_XU_F_QF_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_XU_F_QF_MF8)
  .value("PseudoSF_VFNRCLIP_XU_F_QF_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_XU_F_QF_MF8_MASK)
  .value("PseudoSF_VFNRCLIP_X_F_QF_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_X_F_QF_M1)
  .value("PseudoSF_VFNRCLIP_X_F_QF_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_X_F_QF_M1_MASK)
  .value("PseudoSF_VFNRCLIP_X_F_QF_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_X_F_QF_M2)
  .value("PseudoSF_VFNRCLIP_X_F_QF_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_X_F_QF_M2_MASK)
  .value("PseudoSF_VFNRCLIP_X_F_QF_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_X_F_QF_MF2)
  .value("PseudoSF_VFNRCLIP_X_F_QF_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_X_F_QF_MF2_MASK)
  .value("PseudoSF_VFNRCLIP_X_F_QF_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_X_F_QF_MF4)
  .value("PseudoSF_VFNRCLIP_X_F_QF_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_X_F_QF_MF4_MASK)
  .value("PseudoSF_VFNRCLIP_X_F_QF_MF8", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_X_F_QF_MF8)
  .value("PseudoSF_VFNRCLIP_X_F_QF_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoSF_VFNRCLIP_X_F_QF_MF8_MASK)
  .value("PseudoSF_VFWMACC_4x4x4_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VFWMACC_4x4x4_M1)
  .value("PseudoSF_VFWMACC_4x4x4_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VFWMACC_4x4x4_M2)
  .value("PseudoSF_VFWMACC_4x4x4_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VFWMACC_4x4x4_M4)
  .value("PseudoSF_VFWMACC_4x4x4_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VFWMACC_4x4x4_MF2)
  .value("PseudoSF_VFWMACC_4x4x4_MF4", LIEF::assembly::riscv::OPCODE::PseudoSF_VFWMACC_4x4x4_MF4)
  .value("PseudoSF_VQMACCSU_2x8x2_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCSU_2x8x2_M1)
  .value("PseudoSF_VQMACCSU_2x8x2_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCSU_2x8x2_M2)
  .value("PseudoSF_VQMACCSU_2x8x2_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCSU_2x8x2_M4)
  .value("PseudoSF_VQMACCSU_2x8x2_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCSU_2x8x2_M8)
  .value("PseudoSF_VQMACCSU_4x8x4_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCSU_4x8x4_M1)
  .value("PseudoSF_VQMACCSU_4x8x4_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCSU_4x8x4_M2)
  .value("PseudoSF_VQMACCSU_4x8x4_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCSU_4x8x4_M4)
  .value("PseudoSF_VQMACCSU_4x8x4_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCSU_4x8x4_MF2)
  .value("PseudoSF_VQMACCUS_2x8x2_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCUS_2x8x2_M1)
  .value("PseudoSF_VQMACCUS_2x8x2_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCUS_2x8x2_M2)
  .value("PseudoSF_VQMACCUS_2x8x2_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCUS_2x8x2_M4)
  .value("PseudoSF_VQMACCUS_2x8x2_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCUS_2x8x2_M8)
  .value("PseudoSF_VQMACCUS_4x8x4_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCUS_4x8x4_M1)
  .value("PseudoSF_VQMACCUS_4x8x4_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCUS_4x8x4_M2)
  .value("PseudoSF_VQMACCUS_4x8x4_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCUS_4x8x4_M4)
  .value("PseudoSF_VQMACCUS_4x8x4_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCUS_4x8x4_MF2)
  .value("PseudoSF_VQMACCU_2x8x2_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCU_2x8x2_M1)
  .value("PseudoSF_VQMACCU_2x8x2_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCU_2x8x2_M2)
  .value("PseudoSF_VQMACCU_2x8x2_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCU_2x8x2_M4)
  .value("PseudoSF_VQMACCU_2x8x2_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCU_2x8x2_M8)
  .value("PseudoSF_VQMACCU_4x8x4_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCU_4x8x4_M1)
  .value("PseudoSF_VQMACCU_4x8x4_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCU_4x8x4_M2)
  .value("PseudoSF_VQMACCU_4x8x4_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCU_4x8x4_M4)
  .value("PseudoSF_VQMACCU_4x8x4_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACCU_4x8x4_MF2)
  .value("PseudoSF_VQMACC_2x8x2_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACC_2x8x2_M1)
  .value("PseudoSF_VQMACC_2x8x2_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACC_2x8x2_M2)
  .value("PseudoSF_VQMACC_2x8x2_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACC_2x8x2_M4)
  .value("PseudoSF_VQMACC_2x8x2_M8", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACC_2x8x2_M8)
  .value("PseudoSF_VQMACC_4x8x4_M1", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACC_4x8x4_M1)
  .value("PseudoSF_VQMACC_4x8x4_M2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACC_4x8x4_M2)
  .value("PseudoSF_VQMACC_4x8x4_M4", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACC_4x8x4_M4)
  .value("PseudoSF_VQMACC_4x8x4_MF2", LIEF::assembly::riscv::OPCODE::PseudoSF_VQMACC_4x8x4_MF2)
  .value("PseudoSH", LIEF::assembly::riscv::OPCODE::PseudoSH)
  .value("PseudoSW", LIEF::assembly::riscv::OPCODE::PseudoSW)
  .value("PseudoTAIL", LIEF::assembly::riscv::OPCODE::PseudoTAIL)
  .value("PseudoTAILIndirect", LIEF::assembly::riscv::OPCODE::PseudoTAILIndirect)
  .value("PseudoTAILIndirectNonX7", LIEF::assembly::riscv::OPCODE::PseudoTAILIndirectNonX7)
  .value("PseudoTAILIndirectX7", LIEF::assembly::riscv::OPCODE::PseudoTAILIndirectX7)
  .value("PseudoTH_VMAQASU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VV_M1)
  .value("PseudoTH_VMAQASU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VV_M1_MASK)
  .value("PseudoTH_VMAQASU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VV_M2)
  .value("PseudoTH_VMAQASU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VV_M2_MASK)
  .value("PseudoTH_VMAQASU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VV_M4)
  .value("PseudoTH_VMAQASU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VV_M4_MASK)
  .value("PseudoTH_VMAQASU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VV_M8)
  .value("PseudoTH_VMAQASU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VV_M8_MASK)
  .value("PseudoTH_VMAQASU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VV_MF2)
  .value("PseudoTH_VMAQASU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VV_MF2_MASK)
  .value("PseudoTH_VMAQASU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VX_M1)
  .value("PseudoTH_VMAQASU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VX_M1_MASK)
  .value("PseudoTH_VMAQASU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VX_M2)
  .value("PseudoTH_VMAQASU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VX_M2_MASK)
  .value("PseudoTH_VMAQASU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VX_M4)
  .value("PseudoTH_VMAQASU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VX_M4_MASK)
  .value("PseudoTH_VMAQASU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VX_M8)
  .value("PseudoTH_VMAQASU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VX_M8_MASK)
  .value("PseudoTH_VMAQASU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VX_MF2)
  .value("PseudoTH_VMAQASU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQASU_VX_MF2_MASK)
  .value("PseudoTH_VMAQAUS_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAUS_VX_M1)
  .value("PseudoTH_VMAQAUS_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAUS_VX_M1_MASK)
  .value("PseudoTH_VMAQAUS_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAUS_VX_M2)
  .value("PseudoTH_VMAQAUS_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAUS_VX_M2_MASK)
  .value("PseudoTH_VMAQAUS_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAUS_VX_M4)
  .value("PseudoTH_VMAQAUS_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAUS_VX_M4_MASK)
  .value("PseudoTH_VMAQAUS_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAUS_VX_M8)
  .value("PseudoTH_VMAQAUS_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAUS_VX_M8_MASK)
  .value("PseudoTH_VMAQAUS_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAUS_VX_MF2)
  .value("PseudoTH_VMAQAUS_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAUS_VX_MF2_MASK)
  .value("PseudoTH_VMAQAU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VV_M1)
  .value("PseudoTH_VMAQAU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VV_M1_MASK)
  .value("PseudoTH_VMAQAU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VV_M2)
  .value("PseudoTH_VMAQAU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VV_M2_MASK)
  .value("PseudoTH_VMAQAU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VV_M4)
  .value("PseudoTH_VMAQAU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VV_M4_MASK)
  .value("PseudoTH_VMAQAU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VV_M8)
  .value("PseudoTH_VMAQAU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VV_M8_MASK)
  .value("PseudoTH_VMAQAU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VV_MF2)
  .value("PseudoTH_VMAQAU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VV_MF2_MASK)
  .value("PseudoTH_VMAQAU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VX_M1)
  .value("PseudoTH_VMAQAU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VX_M1_MASK)
  .value("PseudoTH_VMAQAU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VX_M2)
  .value("PseudoTH_VMAQAU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VX_M2_MASK)
  .value("PseudoTH_VMAQAU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VX_M4)
  .value("PseudoTH_VMAQAU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VX_M4_MASK)
  .value("PseudoTH_VMAQAU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VX_M8)
  .value("PseudoTH_VMAQAU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VX_M8_MASK)
  .value("PseudoTH_VMAQAU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VX_MF2)
  .value("PseudoTH_VMAQAU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQAU_VX_MF2_MASK)
  .value("PseudoTH_VMAQA_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VV_M1)
  .value("PseudoTH_VMAQA_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VV_M1_MASK)
  .value("PseudoTH_VMAQA_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VV_M2)
  .value("PseudoTH_VMAQA_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VV_M2_MASK)
  .value("PseudoTH_VMAQA_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VV_M4)
  .value("PseudoTH_VMAQA_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VV_M4_MASK)
  .value("PseudoTH_VMAQA_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VV_M8)
  .value("PseudoTH_VMAQA_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VV_M8_MASK)
  .value("PseudoTH_VMAQA_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VV_MF2)
  .value("PseudoTH_VMAQA_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VV_MF2_MASK)
  .value("PseudoTH_VMAQA_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VX_M1)
  .value("PseudoTH_VMAQA_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VX_M1_MASK)
  .value("PseudoTH_VMAQA_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VX_M2)
  .value("PseudoTH_VMAQA_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VX_M2_MASK)
  .value("PseudoTH_VMAQA_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VX_M4)
  .value("PseudoTH_VMAQA_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VX_M4_MASK)
  .value("PseudoTH_VMAQA_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VX_M8)
  .value("PseudoTH_VMAQA_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VX_M8_MASK)
  .value("PseudoTH_VMAQA_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VX_MF2)
  .value("PseudoTH_VMAQA_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoTH_VMAQA_VX_MF2_MASK)
  .value("PseudoTLSDESCCall", LIEF::assembly::riscv::OPCODE::PseudoTLSDESCCall)
  .value("PseudoVAADDU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_M1)
  .value("PseudoVAADDU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_M1_MASK)
  .value("PseudoVAADDU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_M2)
  .value("PseudoVAADDU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_M2_MASK)
  .value("PseudoVAADDU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_M4)
  .value("PseudoVAADDU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_M4_MASK)
  .value("PseudoVAADDU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_M8)
  .value("PseudoVAADDU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_M8_MASK)
  .value("PseudoVAADDU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_MF2)
  .value("PseudoVAADDU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_MF2_MASK)
  .value("PseudoVAADDU_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_MF4)
  .value("PseudoVAADDU_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_MF4_MASK)
  .value("PseudoVAADDU_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_MF8)
  .value("PseudoVAADDU_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VV_MF8_MASK)
  .value("PseudoVAADDU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_M1)
  .value("PseudoVAADDU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_M1_MASK)
  .value("PseudoVAADDU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_M2)
  .value("PseudoVAADDU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_M2_MASK)
  .value("PseudoVAADDU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_M4)
  .value("PseudoVAADDU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_M4_MASK)
  .value("PseudoVAADDU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_M8)
  .value("PseudoVAADDU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_M8_MASK)
  .value("PseudoVAADDU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_MF2)
  .value("PseudoVAADDU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_MF2_MASK)
  .value("PseudoVAADDU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_MF4)
  .value("PseudoVAADDU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_MF4_MASK)
  .value("PseudoVAADDU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_MF8)
  .value("PseudoVAADDU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADDU_VX_MF8_MASK)
  .value("PseudoVAADD_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_M1)
  .value("PseudoVAADD_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_M1_MASK)
  .value("PseudoVAADD_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_M2)
  .value("PseudoVAADD_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_M2_MASK)
  .value("PseudoVAADD_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_M4)
  .value("PseudoVAADD_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_M4_MASK)
  .value("PseudoVAADD_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_M8)
  .value("PseudoVAADD_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_M8_MASK)
  .value("PseudoVAADD_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_MF2)
  .value("PseudoVAADD_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_MF2_MASK)
  .value("PseudoVAADD_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_MF4)
  .value("PseudoVAADD_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_MF4_MASK)
  .value("PseudoVAADD_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_MF8)
  .value("PseudoVAADD_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VV_MF8_MASK)
  .value("PseudoVAADD_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_M1)
  .value("PseudoVAADD_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_M1_MASK)
  .value("PseudoVAADD_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_M2)
  .value("PseudoVAADD_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_M2_MASK);
  opcodes.value("PseudoVAADD_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_M4)
  .value("PseudoVAADD_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_M4_MASK)
  .value("PseudoVAADD_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_M8)
  .value("PseudoVAADD_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_M8_MASK)
  .value("PseudoVAADD_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_MF2)
  .value("PseudoVAADD_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_MF2_MASK)
  .value("PseudoVAADD_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_MF4)
  .value("PseudoVAADD_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_MF4_MASK)
  .value("PseudoVAADD_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_MF8)
  .value("PseudoVAADD_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAADD_VX_MF8_MASK)
  .value("PseudoVADC_VIM_M1", LIEF::assembly::riscv::OPCODE::PseudoVADC_VIM_M1)
  .value("PseudoVADC_VIM_M2", LIEF::assembly::riscv::OPCODE::PseudoVADC_VIM_M2)
  .value("PseudoVADC_VIM_M4", LIEF::assembly::riscv::OPCODE::PseudoVADC_VIM_M4)
  .value("PseudoVADC_VIM_M8", LIEF::assembly::riscv::OPCODE::PseudoVADC_VIM_M8)
  .value("PseudoVADC_VIM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVADC_VIM_MF2)
  .value("PseudoVADC_VIM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVADC_VIM_MF4)
  .value("PseudoVADC_VIM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVADC_VIM_MF8)
  .value("PseudoVADC_VVM_M1", LIEF::assembly::riscv::OPCODE::PseudoVADC_VVM_M1)
  .value("PseudoVADC_VVM_M2", LIEF::assembly::riscv::OPCODE::PseudoVADC_VVM_M2)
  .value("PseudoVADC_VVM_M4", LIEF::assembly::riscv::OPCODE::PseudoVADC_VVM_M4)
  .value("PseudoVADC_VVM_M8", LIEF::assembly::riscv::OPCODE::PseudoVADC_VVM_M8)
  .value("PseudoVADC_VVM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVADC_VVM_MF2)
  .value("PseudoVADC_VVM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVADC_VVM_MF4)
  .value("PseudoVADC_VVM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVADC_VVM_MF8)
  .value("PseudoVADC_VXM_M1", LIEF::assembly::riscv::OPCODE::PseudoVADC_VXM_M1)
  .value("PseudoVADC_VXM_M2", LIEF::assembly::riscv::OPCODE::PseudoVADC_VXM_M2)
  .value("PseudoVADC_VXM_M4", LIEF::assembly::riscv::OPCODE::PseudoVADC_VXM_M4)
  .value("PseudoVADC_VXM_M8", LIEF::assembly::riscv::OPCODE::PseudoVADC_VXM_M8)
  .value("PseudoVADC_VXM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVADC_VXM_MF2)
  .value("PseudoVADC_VXM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVADC_VXM_MF4)
  .value("PseudoVADC_VXM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVADC_VXM_MF8)
  .value("PseudoVADD_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_M1)
  .value("PseudoVADD_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_M1_MASK)
  .value("PseudoVADD_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_M2)
  .value("PseudoVADD_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_M2_MASK)
  .value("PseudoVADD_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_M4)
  .value("PseudoVADD_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_M4_MASK)
  .value("PseudoVADD_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_M8)
  .value("PseudoVADD_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_M8_MASK)
  .value("PseudoVADD_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_MF2)
  .value("PseudoVADD_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_MF2_MASK)
  .value("PseudoVADD_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_MF4)
  .value("PseudoVADD_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_MF4_MASK)
  .value("PseudoVADD_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_MF8)
  .value("PseudoVADD_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VI_MF8_MASK)
  .value("PseudoVADD_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_M1)
  .value("PseudoVADD_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_M1_MASK)
  .value("PseudoVADD_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_M2)
  .value("PseudoVADD_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_M2_MASK)
  .value("PseudoVADD_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_M4)
  .value("PseudoVADD_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_M4_MASK)
  .value("PseudoVADD_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_M8)
  .value("PseudoVADD_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_M8_MASK)
  .value("PseudoVADD_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_MF2)
  .value("PseudoVADD_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_MF2_MASK)
  .value("PseudoVADD_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_MF4)
  .value("PseudoVADD_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_MF4_MASK)
  .value("PseudoVADD_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_MF8)
  .value("PseudoVADD_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VV_MF8_MASK)
  .value("PseudoVADD_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_M1)
  .value("PseudoVADD_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_M1_MASK)
  .value("PseudoVADD_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_M2)
  .value("PseudoVADD_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_M2_MASK)
  .value("PseudoVADD_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_M4)
  .value("PseudoVADD_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_M4_MASK)
  .value("PseudoVADD_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_M8)
  .value("PseudoVADD_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_M8_MASK)
  .value("PseudoVADD_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_MF2)
  .value("PseudoVADD_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_MF2_MASK)
  .value("PseudoVADD_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_MF4)
  .value("PseudoVADD_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_MF4_MASK)
  .value("PseudoVADD_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_MF8)
  .value("PseudoVADD_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVADD_VX_MF8_MASK)
  .value("PseudoVAESDF_VS_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M1_M1)
  .value("PseudoVAESDF_VS_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M1_MF2)
  .value("PseudoVAESDF_VS_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M1_MF4)
  .value("PseudoVAESDF_VS_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M1_MF8)
  .value("PseudoVAESDF_VS_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M2_M1)
  .value("PseudoVAESDF_VS_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M2_M2)
  .value("PseudoVAESDF_VS_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M2_MF2)
  .value("PseudoVAESDF_VS_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M2_MF4)
  .value("PseudoVAESDF_VS_M2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M2_MF8)
  .value("PseudoVAESDF_VS_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M4_M1)
  .value("PseudoVAESDF_VS_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M4_M2)
  .value("PseudoVAESDF_VS_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M4_M4)
  .value("PseudoVAESDF_VS_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M4_MF2)
  .value("PseudoVAESDF_VS_M4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M4_MF4)
  .value("PseudoVAESDF_VS_M4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M4_MF8)
  .value("PseudoVAESDF_VS_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M8_M1)
  .value("PseudoVAESDF_VS_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M8_M2)
  .value("PseudoVAESDF_VS_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M8_M4)
  .value("PseudoVAESDF_VS_M8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M8_MF2)
  .value("PseudoVAESDF_VS_M8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M8_MF4)
  .value("PseudoVAESDF_VS_M8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_M8_MF8)
  .value("PseudoVAESDF_VS_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_MF2_MF2)
  .value("PseudoVAESDF_VS_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_MF2_MF4)
  .value("PseudoVAESDF_VS_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VS_MF2_MF8)
  .value("PseudoVAESDF_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VV_M1)
  .value("PseudoVAESDF_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VV_M2)
  .value("PseudoVAESDF_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VV_M4)
  .value("PseudoVAESDF_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VV_M8)
  .value("PseudoVAESDF_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDF_VV_MF2)
  .value("PseudoVAESDM_VS_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M1_M1)
  .value("PseudoVAESDM_VS_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M1_MF2)
  .value("PseudoVAESDM_VS_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M1_MF4)
  .value("PseudoVAESDM_VS_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M1_MF8)
  .value("PseudoVAESDM_VS_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M2_M1)
  .value("PseudoVAESDM_VS_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M2_M2)
  .value("PseudoVAESDM_VS_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M2_MF2)
  .value("PseudoVAESDM_VS_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M2_MF4)
  .value("PseudoVAESDM_VS_M2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M2_MF8)
  .value("PseudoVAESDM_VS_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M4_M1)
  .value("PseudoVAESDM_VS_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M4_M2)
  .value("PseudoVAESDM_VS_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M4_M4)
  .value("PseudoVAESDM_VS_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M4_MF2)
  .value("PseudoVAESDM_VS_M4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M4_MF4)
  .value("PseudoVAESDM_VS_M4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M4_MF8)
  .value("PseudoVAESDM_VS_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M8_M1)
  .value("PseudoVAESDM_VS_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M8_M2)
  .value("PseudoVAESDM_VS_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M8_M4)
  .value("PseudoVAESDM_VS_M8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M8_MF2)
  .value("PseudoVAESDM_VS_M8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M8_MF4)
  .value("PseudoVAESDM_VS_M8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_M8_MF8)
  .value("PseudoVAESDM_VS_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_MF2_MF2)
  .value("PseudoVAESDM_VS_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_MF2_MF4)
  .value("PseudoVAESDM_VS_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VS_MF2_MF8)
  .value("PseudoVAESDM_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VV_M1)
  .value("PseudoVAESDM_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VV_M2)
  .value("PseudoVAESDM_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VV_M4)
  .value("PseudoVAESDM_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VV_M8)
  .value("PseudoVAESDM_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESDM_VV_MF2)
  .value("PseudoVAESEF_VS_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M1_M1)
  .value("PseudoVAESEF_VS_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M1_MF2)
  .value("PseudoVAESEF_VS_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M1_MF4)
  .value("PseudoVAESEF_VS_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M1_MF8)
  .value("PseudoVAESEF_VS_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M2_M1)
  .value("PseudoVAESEF_VS_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M2_M2)
  .value("PseudoVAESEF_VS_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M2_MF2)
  .value("PseudoVAESEF_VS_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M2_MF4)
  .value("PseudoVAESEF_VS_M2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M2_MF8)
  .value("PseudoVAESEF_VS_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M4_M1)
  .value("PseudoVAESEF_VS_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M4_M2)
  .value("PseudoVAESEF_VS_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M4_M4)
  .value("PseudoVAESEF_VS_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M4_MF2)
  .value("PseudoVAESEF_VS_M4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M4_MF4)
  .value("PseudoVAESEF_VS_M4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M4_MF8)
  .value("PseudoVAESEF_VS_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M8_M1)
  .value("PseudoVAESEF_VS_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M8_M2)
  .value("PseudoVAESEF_VS_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M8_M4)
  .value("PseudoVAESEF_VS_M8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M8_MF2)
  .value("PseudoVAESEF_VS_M8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M8_MF4)
  .value("PseudoVAESEF_VS_M8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_M8_MF8)
  .value("PseudoVAESEF_VS_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_MF2_MF2)
  .value("PseudoVAESEF_VS_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_MF2_MF4)
  .value("PseudoVAESEF_VS_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VS_MF2_MF8)
  .value("PseudoVAESEF_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VV_M1)
  .value("PseudoVAESEF_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VV_M2)
  .value("PseudoVAESEF_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VV_M4)
  .value("PseudoVAESEF_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VV_M8)
  .value("PseudoVAESEF_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEF_VV_MF2)
  .value("PseudoVAESEM_VS_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M1_M1)
  .value("PseudoVAESEM_VS_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M1_MF2)
  .value("PseudoVAESEM_VS_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M1_MF4)
  .value("PseudoVAESEM_VS_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M1_MF8)
  .value("PseudoVAESEM_VS_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M2_M1)
  .value("PseudoVAESEM_VS_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M2_M2)
  .value("PseudoVAESEM_VS_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M2_MF2)
  .value("PseudoVAESEM_VS_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M2_MF4)
  .value("PseudoVAESEM_VS_M2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M2_MF8)
  .value("PseudoVAESEM_VS_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M4_M1)
  .value("PseudoVAESEM_VS_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M4_M2)
  .value("PseudoVAESEM_VS_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M4_M4)
  .value("PseudoVAESEM_VS_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M4_MF2)
  .value("PseudoVAESEM_VS_M4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M4_MF4)
  .value("PseudoVAESEM_VS_M4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M4_MF8)
  .value("PseudoVAESEM_VS_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M8_M1)
  .value("PseudoVAESEM_VS_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M8_M2)
  .value("PseudoVAESEM_VS_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M8_M4)
  .value("PseudoVAESEM_VS_M8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M8_MF2)
  .value("PseudoVAESEM_VS_M8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M8_MF4)
  .value("PseudoVAESEM_VS_M8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_M8_MF8)
  .value("PseudoVAESEM_VS_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_MF2_MF2)
  .value("PseudoVAESEM_VS_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_MF2_MF4)
  .value("PseudoVAESEM_VS_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VS_MF2_MF8)
  .value("PseudoVAESEM_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VV_M1)
  .value("PseudoVAESEM_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VV_M2)
  .value("PseudoVAESEM_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VV_M4)
  .value("PseudoVAESEM_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VV_M8)
  .value("PseudoVAESEM_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESEM_VV_MF2)
  .value("PseudoVAESKF1_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESKF1_VI_M1)
  .value("PseudoVAESKF1_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESKF1_VI_M2)
  .value("PseudoVAESKF1_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESKF1_VI_M4)
  .value("PseudoVAESKF1_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVAESKF1_VI_M8)
  .value("PseudoVAESKF1_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESKF1_VI_MF2)
  .value("PseudoVAESKF2_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESKF2_VI_M1)
  .value("PseudoVAESKF2_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESKF2_VI_M2)
  .value("PseudoVAESKF2_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESKF2_VI_M4)
  .value("PseudoVAESKF2_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVAESKF2_VI_M8)
  .value("PseudoVAESKF2_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESKF2_VI_MF2)
  .value("PseudoVAESZ_VS_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M1_M1)
  .value("PseudoVAESZ_VS_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M1_MF2)
  .value("PseudoVAESZ_VS_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M1_MF4)
  .value("PseudoVAESZ_VS_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M1_MF8)
  .value("PseudoVAESZ_VS_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M2_M1)
  .value("PseudoVAESZ_VS_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M2_M2)
  .value("PseudoVAESZ_VS_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M2_MF2)
  .value("PseudoVAESZ_VS_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M2_MF4)
  .value("PseudoVAESZ_VS_M2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M2_MF8)
  .value("PseudoVAESZ_VS_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M4_M1)
  .value("PseudoVAESZ_VS_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M4_M2)
  .value("PseudoVAESZ_VS_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M4_M4)
  .value("PseudoVAESZ_VS_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M4_MF2)
  .value("PseudoVAESZ_VS_M4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M4_MF4)
  .value("PseudoVAESZ_VS_M4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M4_MF8)
  .value("PseudoVAESZ_VS_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M8_M1)
  .value("PseudoVAESZ_VS_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M8_M2)
  .value("PseudoVAESZ_VS_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M8_M4)
  .value("PseudoVAESZ_VS_M8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M8_MF2)
  .value("PseudoVAESZ_VS_M8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M8_MF4)
  .value("PseudoVAESZ_VS_M8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_M8_MF8)
  .value("PseudoVAESZ_VS_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_MF2_MF2)
  .value("PseudoVAESZ_VS_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_MF2_MF4)
  .value("PseudoVAESZ_VS_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAESZ_VS_MF2_MF8)
  .value("PseudoVANDN_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_M1)
  .value("PseudoVANDN_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_M1_MASK)
  .value("PseudoVANDN_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_M2)
  .value("PseudoVANDN_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_M2_MASK)
  .value("PseudoVANDN_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_M4)
  .value("PseudoVANDN_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_M4_MASK)
  .value("PseudoVANDN_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_M8)
  .value("PseudoVANDN_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_M8_MASK)
  .value("PseudoVANDN_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_MF2)
  .value("PseudoVANDN_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_MF2_MASK)
  .value("PseudoVANDN_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_MF4)
  .value("PseudoVANDN_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_MF4_MASK)
  .value("PseudoVANDN_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_MF8)
  .value("PseudoVANDN_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VV_MF8_MASK)
  .value("PseudoVANDN_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_M1)
  .value("PseudoVANDN_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_M1_MASK)
  .value("PseudoVANDN_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_M2)
  .value("PseudoVANDN_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_M2_MASK)
  .value("PseudoVANDN_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_M4)
  .value("PseudoVANDN_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_M4_MASK)
  .value("PseudoVANDN_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_M8)
  .value("PseudoVANDN_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_M8_MASK)
  .value("PseudoVANDN_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_MF2)
  .value("PseudoVANDN_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_MF2_MASK)
  .value("PseudoVANDN_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_MF4)
  .value("PseudoVANDN_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_MF4_MASK)
  .value("PseudoVANDN_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_MF8)
  .value("PseudoVANDN_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVANDN_VX_MF8_MASK)
  .value("PseudoVAND_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_M1)
  .value("PseudoVAND_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_M1_MASK)
  .value("PseudoVAND_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_M2)
  .value("PseudoVAND_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_M2_MASK)
  .value("PseudoVAND_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_M4)
  .value("PseudoVAND_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_M4_MASK)
  .value("PseudoVAND_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_M8)
  .value("PseudoVAND_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_M8_MASK)
  .value("PseudoVAND_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_MF2)
  .value("PseudoVAND_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_MF2_MASK)
  .value("PseudoVAND_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_MF4)
  .value("PseudoVAND_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_MF4_MASK)
  .value("PseudoVAND_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_MF8)
  .value("PseudoVAND_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VI_MF8_MASK)
  .value("PseudoVAND_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_M1)
  .value("PseudoVAND_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_M1_MASK)
  .value("PseudoVAND_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_M2)
  .value("PseudoVAND_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_M2_MASK)
  .value("PseudoVAND_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_M4)
  .value("PseudoVAND_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_M4_MASK)
  .value("PseudoVAND_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_M8)
  .value("PseudoVAND_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_M8_MASK)
  .value("PseudoVAND_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_MF2)
  .value("PseudoVAND_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_MF2_MASK)
  .value("PseudoVAND_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_MF4)
  .value("PseudoVAND_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_MF4_MASK)
  .value("PseudoVAND_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_MF8)
  .value("PseudoVAND_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VV_MF8_MASK)
  .value("PseudoVAND_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_M1)
  .value("PseudoVAND_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_M1_MASK)
  .value("PseudoVAND_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_M2)
  .value("PseudoVAND_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_M2_MASK)
  .value("PseudoVAND_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_M4)
  .value("PseudoVAND_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_M4_MASK)
  .value("PseudoVAND_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_M8)
  .value("PseudoVAND_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_M8_MASK)
  .value("PseudoVAND_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_MF2)
  .value("PseudoVAND_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_MF2_MASK)
  .value("PseudoVAND_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_MF4)
  .value("PseudoVAND_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_MF4_MASK)
  .value("PseudoVAND_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_MF8)
  .value("PseudoVAND_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVAND_VX_MF8_MASK)
  .value("PseudoVASUBU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_M1)
  .value("PseudoVASUBU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_M1_MASK)
  .value("PseudoVASUBU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_M2)
  .value("PseudoVASUBU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_M2_MASK)
  .value("PseudoVASUBU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_M4)
  .value("PseudoVASUBU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_M4_MASK)
  .value("PseudoVASUBU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_M8);
  opcodes.value("PseudoVASUBU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_M8_MASK)
  .value("PseudoVASUBU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_MF2)
  .value("PseudoVASUBU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_MF2_MASK)
  .value("PseudoVASUBU_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_MF4)
  .value("PseudoVASUBU_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_MF4_MASK)
  .value("PseudoVASUBU_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_MF8)
  .value("PseudoVASUBU_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VV_MF8_MASK)
  .value("PseudoVASUBU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_M1)
  .value("PseudoVASUBU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_M1_MASK)
  .value("PseudoVASUBU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_M2)
  .value("PseudoVASUBU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_M2_MASK)
  .value("PseudoVASUBU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_M4)
  .value("PseudoVASUBU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_M4_MASK)
  .value("PseudoVASUBU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_M8)
  .value("PseudoVASUBU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_M8_MASK)
  .value("PseudoVASUBU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_MF2)
  .value("PseudoVASUBU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_MF2_MASK)
  .value("PseudoVASUBU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_MF4)
  .value("PseudoVASUBU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_MF4_MASK)
  .value("PseudoVASUBU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_MF8)
  .value("PseudoVASUBU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUBU_VX_MF8_MASK)
  .value("PseudoVASUB_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_M1)
  .value("PseudoVASUB_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_M1_MASK)
  .value("PseudoVASUB_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_M2)
  .value("PseudoVASUB_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_M2_MASK)
  .value("PseudoVASUB_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_M4)
  .value("PseudoVASUB_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_M4_MASK)
  .value("PseudoVASUB_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_M8)
  .value("PseudoVASUB_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_M8_MASK)
  .value("PseudoVASUB_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_MF2)
  .value("PseudoVASUB_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_MF2_MASK)
  .value("PseudoVASUB_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_MF4)
  .value("PseudoVASUB_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_MF4_MASK)
  .value("PseudoVASUB_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_MF8)
  .value("PseudoVASUB_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VV_MF8_MASK)
  .value("PseudoVASUB_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_M1)
  .value("PseudoVASUB_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_M1_MASK)
  .value("PseudoVASUB_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_M2)
  .value("PseudoVASUB_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_M2_MASK)
  .value("PseudoVASUB_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_M4)
  .value("PseudoVASUB_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_M4_MASK)
  .value("PseudoVASUB_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_M8)
  .value("PseudoVASUB_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_M8_MASK)
  .value("PseudoVASUB_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_MF2)
  .value("PseudoVASUB_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_MF2_MASK)
  .value("PseudoVASUB_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_MF4)
  .value("PseudoVASUB_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_MF4_MASK)
  .value("PseudoVASUB_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_MF8)
  .value("PseudoVASUB_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVASUB_VX_MF8_MASK)
  .value("PseudoVBREV8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_M1)
  .value("PseudoVBREV8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_M1_MASK)
  .value("PseudoVBREV8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_M2)
  .value("PseudoVBREV8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_M2_MASK)
  .value("PseudoVBREV8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_M4)
  .value("PseudoVBREV8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_M4_MASK)
  .value("PseudoVBREV8_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_M8)
  .value("PseudoVBREV8_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_M8_MASK)
  .value("PseudoVBREV8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_MF2)
  .value("PseudoVBREV8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_MF2_MASK)
  .value("PseudoVBREV8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_MF4)
  .value("PseudoVBREV8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_MF4_MASK)
  .value("PseudoVBREV8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_MF8)
  .value("PseudoVBREV8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV8_V_MF8_MASK)
  .value("PseudoVBREV_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_M1)
  .value("PseudoVBREV_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_M1_MASK)
  .value("PseudoVBREV_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_M2)
  .value("PseudoVBREV_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_M2_MASK)
  .value("PseudoVBREV_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_M4)
  .value("PseudoVBREV_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_M4_MASK)
  .value("PseudoVBREV_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_M8)
  .value("PseudoVBREV_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_M8_MASK)
  .value("PseudoVBREV_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_MF2)
  .value("PseudoVBREV_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_MF2_MASK)
  .value("PseudoVBREV_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_MF4)
  .value("PseudoVBREV_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_MF4_MASK)
  .value("PseudoVBREV_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_MF8)
  .value("PseudoVBREV_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVBREV_V_MF8_MASK)
  .value("PseudoVCLMULH_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_M1)
  .value("PseudoVCLMULH_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_M1_MASK)
  .value("PseudoVCLMULH_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_M2)
  .value("PseudoVCLMULH_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_M2_MASK)
  .value("PseudoVCLMULH_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_M4)
  .value("PseudoVCLMULH_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_M4_MASK)
  .value("PseudoVCLMULH_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_M8)
  .value("PseudoVCLMULH_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_M8_MASK)
  .value("PseudoVCLMULH_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_MF2)
  .value("PseudoVCLMULH_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_MF2_MASK)
  .value("PseudoVCLMULH_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_MF4)
  .value("PseudoVCLMULH_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_MF4_MASK)
  .value("PseudoVCLMULH_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_MF8)
  .value("PseudoVCLMULH_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VV_MF8_MASK)
  .value("PseudoVCLMULH_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_M1)
  .value("PseudoVCLMULH_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_M1_MASK)
  .value("PseudoVCLMULH_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_M2)
  .value("PseudoVCLMULH_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_M2_MASK)
  .value("PseudoVCLMULH_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_M4)
  .value("PseudoVCLMULH_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_M4_MASK)
  .value("PseudoVCLMULH_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_M8)
  .value("PseudoVCLMULH_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_M8_MASK)
  .value("PseudoVCLMULH_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_MF2)
  .value("PseudoVCLMULH_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_MF2_MASK)
  .value("PseudoVCLMULH_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_MF4)
  .value("PseudoVCLMULH_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_MF4_MASK)
  .value("PseudoVCLMULH_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_MF8)
  .value("PseudoVCLMULH_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMULH_VX_MF8_MASK)
  .value("PseudoVCLMUL_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_M1)
  .value("PseudoVCLMUL_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_M1_MASK)
  .value("PseudoVCLMUL_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_M2)
  .value("PseudoVCLMUL_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_M2_MASK)
  .value("PseudoVCLMUL_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_M4)
  .value("PseudoVCLMUL_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_M4_MASK)
  .value("PseudoVCLMUL_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_M8)
  .value("PseudoVCLMUL_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_M8_MASK)
  .value("PseudoVCLMUL_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_MF2)
  .value("PseudoVCLMUL_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_MF2_MASK)
  .value("PseudoVCLMUL_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_MF4)
  .value("PseudoVCLMUL_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_MF4_MASK)
  .value("PseudoVCLMUL_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_MF8)
  .value("PseudoVCLMUL_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VV_MF8_MASK)
  .value("PseudoVCLMUL_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_M1)
  .value("PseudoVCLMUL_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_M1_MASK)
  .value("PseudoVCLMUL_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_M2)
  .value("PseudoVCLMUL_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_M2_MASK)
  .value("PseudoVCLMUL_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_M4)
  .value("PseudoVCLMUL_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_M4_MASK)
  .value("PseudoVCLMUL_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_M8)
  .value("PseudoVCLMUL_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_M8_MASK)
  .value("PseudoVCLMUL_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_MF2)
  .value("PseudoVCLMUL_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_MF2_MASK)
  .value("PseudoVCLMUL_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_MF4)
  .value("PseudoVCLMUL_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_MF4_MASK)
  .value("PseudoVCLMUL_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_MF8)
  .value("PseudoVCLMUL_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLMUL_VX_MF8_MASK)
  .value("PseudoVCLZ_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_M1)
  .value("PseudoVCLZ_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_M1_MASK)
  .value("PseudoVCLZ_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_M2)
  .value("PseudoVCLZ_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_M2_MASK)
  .value("PseudoVCLZ_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_M4)
  .value("PseudoVCLZ_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_M4_MASK)
  .value("PseudoVCLZ_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_M8)
  .value("PseudoVCLZ_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_M8_MASK)
  .value("PseudoVCLZ_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_MF2)
  .value("PseudoVCLZ_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_MF2_MASK)
  .value("PseudoVCLZ_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_MF4)
  .value("PseudoVCLZ_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_MF4_MASK)
  .value("PseudoVCLZ_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_MF8)
  .value("PseudoVCLZ_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCLZ_V_MF8_MASK)
  .value("PseudoVCOMPRESS_VM_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M1_E16)
  .value("PseudoVCOMPRESS_VM_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M1_E32)
  .value("PseudoVCOMPRESS_VM_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M1_E64)
  .value("PseudoVCOMPRESS_VM_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M1_E8)
  .value("PseudoVCOMPRESS_VM_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M2_E16)
  .value("PseudoVCOMPRESS_VM_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M2_E32)
  .value("PseudoVCOMPRESS_VM_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M2_E64)
  .value("PseudoVCOMPRESS_VM_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M2_E8)
  .value("PseudoVCOMPRESS_VM_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M4_E16)
  .value("PseudoVCOMPRESS_VM_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M4_E32)
  .value("PseudoVCOMPRESS_VM_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M4_E64)
  .value("PseudoVCOMPRESS_VM_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M4_E8)
  .value("PseudoVCOMPRESS_VM_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M8_E16)
  .value("PseudoVCOMPRESS_VM_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M8_E32)
  .value("PseudoVCOMPRESS_VM_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M8_E64)
  .value("PseudoVCOMPRESS_VM_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_M8_E8)
  .value("PseudoVCOMPRESS_VM_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_MF2_E16)
  .value("PseudoVCOMPRESS_VM_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_MF2_E32)
  .value("PseudoVCOMPRESS_VM_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_MF2_E8)
  .value("PseudoVCOMPRESS_VM_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_MF4_E16)
  .value("PseudoVCOMPRESS_VM_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_MF4_E8)
  .value("PseudoVCOMPRESS_VM_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVCOMPRESS_VM_MF8_E8)
  .value("PseudoVCPOP_M_B1", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B1)
  .value("PseudoVCPOP_M_B16", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B16)
  .value("PseudoVCPOP_M_B16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B16_MASK)
  .value("PseudoVCPOP_M_B1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B1_MASK)
  .value("PseudoVCPOP_M_B2", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B2)
  .value("PseudoVCPOP_M_B2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B2_MASK)
  .value("PseudoVCPOP_M_B32", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B32)
  .value("PseudoVCPOP_M_B32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B32_MASK)
  .value("PseudoVCPOP_M_B4", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B4)
  .value("PseudoVCPOP_M_B4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B4_MASK)
  .value("PseudoVCPOP_M_B64", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B64)
  .value("PseudoVCPOP_M_B64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B64_MASK)
  .value("PseudoVCPOP_M_B8", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B8)
  .value("PseudoVCPOP_M_B8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_M_B8_MASK)
  .value("PseudoVCPOP_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_M1)
  .value("PseudoVCPOP_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_M1_MASK)
  .value("PseudoVCPOP_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_M2)
  .value("PseudoVCPOP_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_M2_MASK)
  .value("PseudoVCPOP_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_M4)
  .value("PseudoVCPOP_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_M4_MASK)
  .value("PseudoVCPOP_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_M8)
  .value("PseudoVCPOP_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_M8_MASK)
  .value("PseudoVCPOP_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_MF2)
  .value("PseudoVCPOP_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_MF2_MASK)
  .value("PseudoVCPOP_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_MF4)
  .value("PseudoVCPOP_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_MF4_MASK)
  .value("PseudoVCPOP_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_MF8)
  .value("PseudoVCPOP_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCPOP_V_MF8_MASK)
  .value("PseudoVCTZ_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_M1)
  .value("PseudoVCTZ_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_M1_MASK)
  .value("PseudoVCTZ_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_M2)
  .value("PseudoVCTZ_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_M2_MASK)
  .value("PseudoVCTZ_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_M4)
  .value("PseudoVCTZ_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_M4_MASK)
  .value("PseudoVCTZ_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_M8)
  .value("PseudoVCTZ_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_M8_MASK)
  .value("PseudoVCTZ_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_MF2)
  .value("PseudoVCTZ_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_MF2_MASK)
  .value("PseudoVCTZ_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_MF4)
  .value("PseudoVCTZ_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_MF4_MASK)
  .value("PseudoVCTZ_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_MF8)
  .value("PseudoVCTZ_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVCTZ_V_MF8_MASK)
  .value("PseudoVDIVU_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M1_E16)
  .value("PseudoVDIVU_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M1_E16_MASK)
  .value("PseudoVDIVU_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M1_E32)
  .value("PseudoVDIVU_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M1_E32_MASK)
  .value("PseudoVDIVU_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M1_E64)
  .value("PseudoVDIVU_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M1_E64_MASK)
  .value("PseudoVDIVU_VV_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M1_E8)
  .value("PseudoVDIVU_VV_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M1_E8_MASK)
  .value("PseudoVDIVU_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M2_E16)
  .value("PseudoVDIVU_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M2_E16_MASK)
  .value("PseudoVDIVU_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M2_E32)
  .value("PseudoVDIVU_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M2_E32_MASK)
  .value("PseudoVDIVU_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M2_E64)
  .value("PseudoVDIVU_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M2_E64_MASK)
  .value("PseudoVDIVU_VV_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M2_E8)
  .value("PseudoVDIVU_VV_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M2_E8_MASK)
  .value("PseudoVDIVU_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M4_E16)
  .value("PseudoVDIVU_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M4_E16_MASK)
  .value("PseudoVDIVU_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M4_E32)
  .value("PseudoVDIVU_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M4_E32_MASK)
  .value("PseudoVDIVU_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M4_E64)
  .value("PseudoVDIVU_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M4_E64_MASK)
  .value("PseudoVDIVU_VV_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M4_E8)
  .value("PseudoVDIVU_VV_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M4_E8_MASK)
  .value("PseudoVDIVU_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M8_E16)
  .value("PseudoVDIVU_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M8_E16_MASK)
  .value("PseudoVDIVU_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M8_E32)
  .value("PseudoVDIVU_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M8_E32_MASK)
  .value("PseudoVDIVU_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M8_E64)
  .value("PseudoVDIVU_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M8_E64_MASK)
  .value("PseudoVDIVU_VV_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M8_E8)
  .value("PseudoVDIVU_VV_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_M8_E8_MASK)
  .value("PseudoVDIVU_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF2_E16)
  .value("PseudoVDIVU_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF2_E16_MASK)
  .value("PseudoVDIVU_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF2_E32)
  .value("PseudoVDIVU_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF2_E32_MASK)
  .value("PseudoVDIVU_VV_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF2_E8)
  .value("PseudoVDIVU_VV_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF2_E8_MASK)
  .value("PseudoVDIVU_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF4_E16)
  .value("PseudoVDIVU_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF4_E16_MASK)
  .value("PseudoVDIVU_VV_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF4_E8)
  .value("PseudoVDIVU_VV_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF4_E8_MASK)
  .value("PseudoVDIVU_VV_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF8_E8)
  .value("PseudoVDIVU_VV_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VV_MF8_E8_MASK)
  .value("PseudoVDIVU_VX_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M1_E16)
  .value("PseudoVDIVU_VX_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M1_E16_MASK)
  .value("PseudoVDIVU_VX_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M1_E32)
  .value("PseudoVDIVU_VX_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M1_E32_MASK)
  .value("PseudoVDIVU_VX_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M1_E64)
  .value("PseudoVDIVU_VX_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M1_E64_MASK)
  .value("PseudoVDIVU_VX_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M1_E8)
  .value("PseudoVDIVU_VX_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M1_E8_MASK)
  .value("PseudoVDIVU_VX_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M2_E16)
  .value("PseudoVDIVU_VX_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M2_E16_MASK)
  .value("PseudoVDIVU_VX_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M2_E32)
  .value("PseudoVDIVU_VX_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M2_E32_MASK)
  .value("PseudoVDIVU_VX_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M2_E64)
  .value("PseudoVDIVU_VX_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M2_E64_MASK)
  .value("PseudoVDIVU_VX_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M2_E8)
  .value("PseudoVDIVU_VX_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M2_E8_MASK)
  .value("PseudoVDIVU_VX_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M4_E16)
  .value("PseudoVDIVU_VX_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M4_E16_MASK)
  .value("PseudoVDIVU_VX_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M4_E32)
  .value("PseudoVDIVU_VX_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M4_E32_MASK)
  .value("PseudoVDIVU_VX_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M4_E64)
  .value("PseudoVDIVU_VX_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M4_E64_MASK)
  .value("PseudoVDIVU_VX_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M4_E8)
  .value("PseudoVDIVU_VX_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M4_E8_MASK)
  .value("PseudoVDIVU_VX_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M8_E16)
  .value("PseudoVDIVU_VX_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M8_E16_MASK)
  .value("PseudoVDIVU_VX_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M8_E32)
  .value("PseudoVDIVU_VX_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M8_E32_MASK)
  .value("PseudoVDIVU_VX_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M8_E64)
  .value("PseudoVDIVU_VX_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M8_E64_MASK)
  .value("PseudoVDIVU_VX_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M8_E8)
  .value("PseudoVDIVU_VX_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_M8_E8_MASK)
  .value("PseudoVDIVU_VX_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF2_E16)
  .value("PseudoVDIVU_VX_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF2_E16_MASK)
  .value("PseudoVDIVU_VX_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF2_E32)
  .value("PseudoVDIVU_VX_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF2_E32_MASK)
  .value("PseudoVDIVU_VX_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF2_E8)
  .value("PseudoVDIVU_VX_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF2_E8_MASK)
  .value("PseudoVDIVU_VX_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF4_E16)
  .value("PseudoVDIVU_VX_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF4_E16_MASK)
  .value("PseudoVDIVU_VX_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF4_E8)
  .value("PseudoVDIVU_VX_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF4_E8_MASK)
  .value("PseudoVDIVU_VX_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF8_E8)
  .value("PseudoVDIVU_VX_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIVU_VX_MF8_E8_MASK)
  .value("PseudoVDIV_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M1_E16);
  opcodes.value("PseudoVDIV_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M1_E16_MASK)
  .value("PseudoVDIV_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M1_E32)
  .value("PseudoVDIV_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M1_E32_MASK)
  .value("PseudoVDIV_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M1_E64)
  .value("PseudoVDIV_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M1_E64_MASK)
  .value("PseudoVDIV_VV_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M1_E8)
  .value("PseudoVDIV_VV_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M1_E8_MASK)
  .value("PseudoVDIV_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M2_E16)
  .value("PseudoVDIV_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M2_E16_MASK)
  .value("PseudoVDIV_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M2_E32)
  .value("PseudoVDIV_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M2_E32_MASK)
  .value("PseudoVDIV_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M2_E64)
  .value("PseudoVDIV_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M2_E64_MASK)
  .value("PseudoVDIV_VV_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M2_E8)
  .value("PseudoVDIV_VV_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M2_E8_MASK)
  .value("PseudoVDIV_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M4_E16)
  .value("PseudoVDIV_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M4_E16_MASK)
  .value("PseudoVDIV_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M4_E32)
  .value("PseudoVDIV_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M4_E32_MASK)
  .value("PseudoVDIV_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M4_E64)
  .value("PseudoVDIV_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M4_E64_MASK)
  .value("PseudoVDIV_VV_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M4_E8)
  .value("PseudoVDIV_VV_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M4_E8_MASK)
  .value("PseudoVDIV_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M8_E16)
  .value("PseudoVDIV_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M8_E16_MASK)
  .value("PseudoVDIV_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M8_E32)
  .value("PseudoVDIV_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M8_E32_MASK)
  .value("PseudoVDIV_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M8_E64)
  .value("PseudoVDIV_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M8_E64_MASK)
  .value("PseudoVDIV_VV_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M8_E8)
  .value("PseudoVDIV_VV_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_M8_E8_MASK)
  .value("PseudoVDIV_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF2_E16)
  .value("PseudoVDIV_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF2_E16_MASK)
  .value("PseudoVDIV_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF2_E32)
  .value("PseudoVDIV_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF2_E32_MASK)
  .value("PseudoVDIV_VV_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF2_E8)
  .value("PseudoVDIV_VV_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF2_E8_MASK)
  .value("PseudoVDIV_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF4_E16)
  .value("PseudoVDIV_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF4_E16_MASK)
  .value("PseudoVDIV_VV_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF4_E8)
  .value("PseudoVDIV_VV_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF4_E8_MASK)
  .value("PseudoVDIV_VV_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF8_E8)
  .value("PseudoVDIV_VV_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VV_MF8_E8_MASK)
  .value("PseudoVDIV_VX_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M1_E16)
  .value("PseudoVDIV_VX_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M1_E16_MASK)
  .value("PseudoVDIV_VX_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M1_E32)
  .value("PseudoVDIV_VX_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M1_E32_MASK)
  .value("PseudoVDIV_VX_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M1_E64)
  .value("PseudoVDIV_VX_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M1_E64_MASK)
  .value("PseudoVDIV_VX_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M1_E8)
  .value("PseudoVDIV_VX_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M1_E8_MASK)
  .value("PseudoVDIV_VX_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M2_E16)
  .value("PseudoVDIV_VX_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M2_E16_MASK)
  .value("PseudoVDIV_VX_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M2_E32)
  .value("PseudoVDIV_VX_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M2_E32_MASK)
  .value("PseudoVDIV_VX_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M2_E64)
  .value("PseudoVDIV_VX_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M2_E64_MASK)
  .value("PseudoVDIV_VX_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M2_E8)
  .value("PseudoVDIV_VX_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M2_E8_MASK)
  .value("PseudoVDIV_VX_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M4_E16)
  .value("PseudoVDIV_VX_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M4_E16_MASK)
  .value("PseudoVDIV_VX_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M4_E32)
  .value("PseudoVDIV_VX_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M4_E32_MASK)
  .value("PseudoVDIV_VX_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M4_E64)
  .value("PseudoVDIV_VX_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M4_E64_MASK)
  .value("PseudoVDIV_VX_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M4_E8)
  .value("PseudoVDIV_VX_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M4_E8_MASK)
  .value("PseudoVDIV_VX_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M8_E16)
  .value("PseudoVDIV_VX_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M8_E16_MASK)
  .value("PseudoVDIV_VX_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M8_E32)
  .value("PseudoVDIV_VX_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M8_E32_MASK)
  .value("PseudoVDIV_VX_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M8_E64)
  .value("PseudoVDIV_VX_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M8_E64_MASK)
  .value("PseudoVDIV_VX_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M8_E8)
  .value("PseudoVDIV_VX_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_M8_E8_MASK)
  .value("PseudoVDIV_VX_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF2_E16)
  .value("PseudoVDIV_VX_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF2_E16_MASK)
  .value("PseudoVDIV_VX_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF2_E32)
  .value("PseudoVDIV_VX_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF2_E32_MASK)
  .value("PseudoVDIV_VX_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF2_E8)
  .value("PseudoVDIV_VX_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF2_E8_MASK)
  .value("PseudoVDIV_VX_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF4_E16)
  .value("PseudoVDIV_VX_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF4_E16_MASK)
  .value("PseudoVDIV_VX_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF4_E8)
  .value("PseudoVDIV_VX_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF4_E8_MASK)
  .value("PseudoVDIV_VX_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF8_E8)
  .value("PseudoVDIV_VX_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVDIV_VX_MF8_E8_MASK)
  .value("PseudoVFADD_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_M1_E16)
  .value("PseudoVFADD_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_M1_E16_MASK)
  .value("PseudoVFADD_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_M2_E16)
  .value("PseudoVFADD_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_M2_E16_MASK)
  .value("PseudoVFADD_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_M4_E16)
  .value("PseudoVFADD_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_M4_E16_MASK)
  .value("PseudoVFADD_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_M8_E16)
  .value("PseudoVFADD_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_M8_E16_MASK)
  .value("PseudoVFADD_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_MF2_E16)
  .value("PseudoVFADD_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_MF2_E16_MASK)
  .value("PseudoVFADD_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_MF4_E16)
  .value("PseudoVFADD_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR16_MF4_E16_MASK)
  .value("PseudoVFADD_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR32_M1_E32)
  .value("PseudoVFADD_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR32_M1_E32_MASK)
  .value("PseudoVFADD_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR32_M2_E32)
  .value("PseudoVFADD_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR32_M2_E32_MASK)
  .value("PseudoVFADD_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR32_M4_E32)
  .value("PseudoVFADD_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR32_M4_E32_MASK)
  .value("PseudoVFADD_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR32_M8_E32)
  .value("PseudoVFADD_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR32_M8_E32_MASK)
  .value("PseudoVFADD_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR32_MF2_E32)
  .value("PseudoVFADD_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR32_MF2_E32_MASK)
  .value("PseudoVFADD_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR64_M1_E64)
  .value("PseudoVFADD_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR64_M1_E64_MASK)
  .value("PseudoVFADD_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR64_M2_E64)
  .value("PseudoVFADD_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR64_M2_E64_MASK)
  .value("PseudoVFADD_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR64_M4_E64)
  .value("PseudoVFADD_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR64_M4_E64_MASK)
  .value("PseudoVFADD_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR64_M8_E64)
  .value("PseudoVFADD_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VFPR64_M8_E64_MASK)
  .value("PseudoVFADD_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M1_E16)
  .value("PseudoVFADD_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M1_E16_MASK)
  .value("PseudoVFADD_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M1_E32)
  .value("PseudoVFADD_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M1_E32_MASK)
  .value("PseudoVFADD_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M1_E64)
  .value("PseudoVFADD_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M1_E64_MASK)
  .value("PseudoVFADD_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M2_E16)
  .value("PseudoVFADD_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M2_E16_MASK)
  .value("PseudoVFADD_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M2_E32)
  .value("PseudoVFADD_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M2_E32_MASK)
  .value("PseudoVFADD_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M2_E64)
  .value("PseudoVFADD_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M2_E64_MASK)
  .value("PseudoVFADD_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M4_E16)
  .value("PseudoVFADD_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M4_E16_MASK)
  .value("PseudoVFADD_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M4_E32)
  .value("PseudoVFADD_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M4_E32_MASK)
  .value("PseudoVFADD_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M4_E64)
  .value("PseudoVFADD_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M4_E64_MASK)
  .value("PseudoVFADD_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M8_E16)
  .value("PseudoVFADD_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M8_E16_MASK)
  .value("PseudoVFADD_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M8_E32)
  .value("PseudoVFADD_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M8_E32_MASK)
  .value("PseudoVFADD_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M8_E64)
  .value("PseudoVFADD_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_M8_E64_MASK)
  .value("PseudoVFADD_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_MF2_E16)
  .value("PseudoVFADD_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_MF2_E16_MASK)
  .value("PseudoVFADD_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_MF2_E32)
  .value("PseudoVFADD_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_MF2_E32_MASK)
  .value("PseudoVFADD_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_MF4_E16)
  .value("PseudoVFADD_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFADD_VV_MF4_E16_MASK)
  .value("PseudoVFCLASS_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_M1)
  .value("PseudoVFCLASS_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_M1_MASK)
  .value("PseudoVFCLASS_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_M2)
  .value("PseudoVFCLASS_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_M2_MASK)
  .value("PseudoVFCLASS_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_M4)
  .value("PseudoVFCLASS_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_M4_MASK)
  .value("PseudoVFCLASS_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_M8)
  .value("PseudoVFCLASS_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_M8_MASK)
  .value("PseudoVFCLASS_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_MF2)
  .value("PseudoVFCLASS_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_MF2_MASK)
  .value("PseudoVFCLASS_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_MF4)
  .value("PseudoVFCLASS_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCLASS_V_MF4_MASK)
  .value("PseudoVFCVT_F_XU_V_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M1_E16)
  .value("PseudoVFCVT_F_XU_V_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M1_E16_MASK)
  .value("PseudoVFCVT_F_XU_V_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M1_E32)
  .value("PseudoVFCVT_F_XU_V_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M1_E32_MASK)
  .value("PseudoVFCVT_F_XU_V_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M1_E64)
  .value("PseudoVFCVT_F_XU_V_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M1_E64_MASK)
  .value("PseudoVFCVT_F_XU_V_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M2_E16)
  .value("PseudoVFCVT_F_XU_V_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M2_E16_MASK)
  .value("PseudoVFCVT_F_XU_V_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M2_E32)
  .value("PseudoVFCVT_F_XU_V_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M2_E32_MASK)
  .value("PseudoVFCVT_F_XU_V_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M2_E64)
  .value("PseudoVFCVT_F_XU_V_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M2_E64_MASK)
  .value("PseudoVFCVT_F_XU_V_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M4_E16)
  .value("PseudoVFCVT_F_XU_V_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M4_E16_MASK)
  .value("PseudoVFCVT_F_XU_V_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M4_E32)
  .value("PseudoVFCVT_F_XU_V_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M4_E32_MASK)
  .value("PseudoVFCVT_F_XU_V_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M4_E64)
  .value("PseudoVFCVT_F_XU_V_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M4_E64_MASK)
  .value("PseudoVFCVT_F_XU_V_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M8_E16)
  .value("PseudoVFCVT_F_XU_V_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M8_E16_MASK)
  .value("PseudoVFCVT_F_XU_V_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M8_E32)
  .value("PseudoVFCVT_F_XU_V_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M8_E32_MASK)
  .value("PseudoVFCVT_F_XU_V_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M8_E64)
  .value("PseudoVFCVT_F_XU_V_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_M8_E64_MASK)
  .value("PseudoVFCVT_F_XU_V_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_MF2_E16)
  .value("PseudoVFCVT_F_XU_V_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_MF2_E16_MASK)
  .value("PseudoVFCVT_F_XU_V_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_MF2_E32)
  .value("PseudoVFCVT_F_XU_V_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_MF2_E32_MASK)
  .value("PseudoVFCVT_F_XU_V_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_MF4_E16)
  .value("PseudoVFCVT_F_XU_V_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_XU_V_MF4_E16_MASK)
  .value("PseudoVFCVT_F_X_V_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M1_E16)
  .value("PseudoVFCVT_F_X_V_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M1_E16_MASK)
  .value("PseudoVFCVT_F_X_V_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M1_E32)
  .value("PseudoVFCVT_F_X_V_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M1_E32_MASK)
  .value("PseudoVFCVT_F_X_V_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M1_E64)
  .value("PseudoVFCVT_F_X_V_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M1_E64_MASK)
  .value("PseudoVFCVT_F_X_V_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M2_E16)
  .value("PseudoVFCVT_F_X_V_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M2_E16_MASK)
  .value("PseudoVFCVT_F_X_V_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M2_E32)
  .value("PseudoVFCVT_F_X_V_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M2_E32_MASK)
  .value("PseudoVFCVT_F_X_V_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M2_E64)
  .value("PseudoVFCVT_F_X_V_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M2_E64_MASK)
  .value("PseudoVFCVT_F_X_V_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M4_E16)
  .value("PseudoVFCVT_F_X_V_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M4_E16_MASK)
  .value("PseudoVFCVT_F_X_V_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M4_E32)
  .value("PseudoVFCVT_F_X_V_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M4_E32_MASK)
  .value("PseudoVFCVT_F_X_V_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M4_E64)
  .value("PseudoVFCVT_F_X_V_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M4_E64_MASK)
  .value("PseudoVFCVT_F_X_V_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M8_E16)
  .value("PseudoVFCVT_F_X_V_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M8_E16_MASK)
  .value("PseudoVFCVT_F_X_V_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M8_E32)
  .value("PseudoVFCVT_F_X_V_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M8_E32_MASK)
  .value("PseudoVFCVT_F_X_V_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M8_E64)
  .value("PseudoVFCVT_F_X_V_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_M8_E64_MASK)
  .value("PseudoVFCVT_F_X_V_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_MF2_E16)
  .value("PseudoVFCVT_F_X_V_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_MF2_E16_MASK)
  .value("PseudoVFCVT_F_X_V_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_MF2_E32)
  .value("PseudoVFCVT_F_X_V_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_MF2_E32_MASK)
  .value("PseudoVFCVT_F_X_V_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_MF4_E16)
  .value("PseudoVFCVT_F_X_V_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_F_X_V_MF4_E16_MASK)
  .value("PseudoVFCVT_RTZ_XU_F_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_M1)
  .value("PseudoVFCVT_RTZ_XU_F_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_M1_MASK)
  .value("PseudoVFCVT_RTZ_XU_F_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_M2)
  .value("PseudoVFCVT_RTZ_XU_F_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_M2_MASK)
  .value("PseudoVFCVT_RTZ_XU_F_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_M4)
  .value("PseudoVFCVT_RTZ_XU_F_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_M4_MASK)
  .value("PseudoVFCVT_RTZ_XU_F_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_M8)
  .value("PseudoVFCVT_RTZ_XU_F_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_M8_MASK)
  .value("PseudoVFCVT_RTZ_XU_F_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_MF2)
  .value("PseudoVFCVT_RTZ_XU_F_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_MF2_MASK)
  .value("PseudoVFCVT_RTZ_XU_F_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_MF4)
  .value("PseudoVFCVT_RTZ_XU_F_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_XU_F_V_MF4_MASK)
  .value("PseudoVFCVT_RTZ_X_F_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_M1)
  .value("PseudoVFCVT_RTZ_X_F_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_M1_MASK)
  .value("PseudoVFCVT_RTZ_X_F_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_M2)
  .value("PseudoVFCVT_RTZ_X_F_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_M2_MASK)
  .value("PseudoVFCVT_RTZ_X_F_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_M4)
  .value("PseudoVFCVT_RTZ_X_F_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_M4_MASK)
  .value("PseudoVFCVT_RTZ_X_F_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_M8)
  .value("PseudoVFCVT_RTZ_X_F_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_M8_MASK)
  .value("PseudoVFCVT_RTZ_X_F_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_MF2)
  .value("PseudoVFCVT_RTZ_X_F_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_MF2_MASK)
  .value("PseudoVFCVT_RTZ_X_F_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_MF4)
  .value("PseudoVFCVT_RTZ_X_F_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_RTZ_X_F_V_MF4_MASK)
  .value("PseudoVFCVT_XU_F_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_M1)
  .value("PseudoVFCVT_XU_F_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_M1_MASK)
  .value("PseudoVFCVT_XU_F_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_M2)
  .value("PseudoVFCVT_XU_F_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_M2_MASK)
  .value("PseudoVFCVT_XU_F_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_M4)
  .value("PseudoVFCVT_XU_F_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_M4_MASK)
  .value("PseudoVFCVT_XU_F_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_M8)
  .value("PseudoVFCVT_XU_F_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_M8_MASK)
  .value("PseudoVFCVT_XU_F_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_MF2)
  .value("PseudoVFCVT_XU_F_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_MF2_MASK)
  .value("PseudoVFCVT_XU_F_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_MF4)
  .value("PseudoVFCVT_XU_F_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_XU_F_V_MF4_MASK)
  .value("PseudoVFCVT_X_F_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_M1)
  .value("PseudoVFCVT_X_F_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_M1_MASK)
  .value("PseudoVFCVT_X_F_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_M2)
  .value("PseudoVFCVT_X_F_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_M2_MASK)
  .value("PseudoVFCVT_X_F_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_M4)
  .value("PseudoVFCVT_X_F_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_M4_MASK)
  .value("PseudoVFCVT_X_F_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_M8)
  .value("PseudoVFCVT_X_F_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_M8_MASK)
  .value("PseudoVFCVT_X_F_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_MF2)
  .value("PseudoVFCVT_X_F_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_MF2_MASK)
  .value("PseudoVFCVT_X_F_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_MF4)
  .value("PseudoVFCVT_X_F_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFCVT_X_F_V_MF4_MASK)
  .value("PseudoVFDIV_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_M1_E16)
  .value("PseudoVFDIV_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_M1_E16_MASK)
  .value("PseudoVFDIV_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_M2_E16)
  .value("PseudoVFDIV_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_M2_E16_MASK)
  .value("PseudoVFDIV_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_M4_E16)
  .value("PseudoVFDIV_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_M4_E16_MASK)
  .value("PseudoVFDIV_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_M8_E16)
  .value("PseudoVFDIV_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_M8_E16_MASK)
  .value("PseudoVFDIV_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_MF2_E16)
  .value("PseudoVFDIV_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_MF2_E16_MASK)
  .value("PseudoVFDIV_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_MF4_E16)
  .value("PseudoVFDIV_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR16_MF4_E16_MASK)
  .value("PseudoVFDIV_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR32_M1_E32)
  .value("PseudoVFDIV_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR32_M1_E32_MASK)
  .value("PseudoVFDIV_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR32_M2_E32)
  .value("PseudoVFDIV_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR32_M2_E32_MASK)
  .value("PseudoVFDIV_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR32_M4_E32)
  .value("PseudoVFDIV_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR32_M4_E32_MASK)
  .value("PseudoVFDIV_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR32_M8_E32)
  .value("PseudoVFDIV_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR32_M8_E32_MASK)
  .value("PseudoVFDIV_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR32_MF2_E32)
  .value("PseudoVFDIV_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR32_MF2_E32_MASK)
  .value("PseudoVFDIV_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR64_M1_E64)
  .value("PseudoVFDIV_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR64_M1_E64_MASK)
  .value("PseudoVFDIV_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR64_M2_E64)
  .value("PseudoVFDIV_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR64_M2_E64_MASK)
  .value("PseudoVFDIV_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR64_M4_E64)
  .value("PseudoVFDIV_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR64_M4_E64_MASK)
  .value("PseudoVFDIV_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR64_M8_E64)
  .value("PseudoVFDIV_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VFPR64_M8_E64_MASK)
  .value("PseudoVFDIV_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M1_E16)
  .value("PseudoVFDIV_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M1_E16_MASK)
  .value("PseudoVFDIV_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M1_E32);
  opcodes.value("PseudoVFDIV_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M1_E32_MASK)
  .value("PseudoVFDIV_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M1_E64)
  .value("PseudoVFDIV_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M1_E64_MASK)
  .value("PseudoVFDIV_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M2_E16)
  .value("PseudoVFDIV_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M2_E16_MASK)
  .value("PseudoVFDIV_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M2_E32)
  .value("PseudoVFDIV_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M2_E32_MASK)
  .value("PseudoVFDIV_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M2_E64)
  .value("PseudoVFDIV_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M2_E64_MASK)
  .value("PseudoVFDIV_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M4_E16)
  .value("PseudoVFDIV_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M4_E16_MASK)
  .value("PseudoVFDIV_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M4_E32)
  .value("PseudoVFDIV_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M4_E32_MASK)
  .value("PseudoVFDIV_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M4_E64)
  .value("PseudoVFDIV_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M4_E64_MASK)
  .value("PseudoVFDIV_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M8_E16)
  .value("PseudoVFDIV_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M8_E16_MASK)
  .value("PseudoVFDIV_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M8_E32)
  .value("PseudoVFDIV_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M8_E32_MASK)
  .value("PseudoVFDIV_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M8_E64)
  .value("PseudoVFDIV_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_M8_E64_MASK)
  .value("PseudoVFDIV_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_MF2_E16)
  .value("PseudoVFDIV_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_MF2_E16_MASK)
  .value("PseudoVFDIV_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_MF2_E32)
  .value("PseudoVFDIV_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_MF2_E32_MASK)
  .value("PseudoVFDIV_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_MF4_E16)
  .value("PseudoVFDIV_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFDIV_VV_MF4_E16_MASK)
  .value("PseudoVFIRST_M_B1", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B1)
  .value("PseudoVFIRST_M_B16", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B16)
  .value("PseudoVFIRST_M_B16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B16_MASK)
  .value("PseudoVFIRST_M_B1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B1_MASK)
  .value("PseudoVFIRST_M_B2", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B2)
  .value("PseudoVFIRST_M_B2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B2_MASK)
  .value("PseudoVFIRST_M_B32", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B32)
  .value("PseudoVFIRST_M_B32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B32_MASK)
  .value("PseudoVFIRST_M_B4", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B4)
  .value("PseudoVFIRST_M_B4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B4_MASK)
  .value("PseudoVFIRST_M_B64", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B64)
  .value("PseudoVFIRST_M_B64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B64_MASK)
  .value("PseudoVFIRST_M_B8", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B8)
  .value("PseudoVFIRST_M_B8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFIRST_M_B8_MASK)
  .value("PseudoVFMACC_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_M1_E16)
  .value("PseudoVFMACC_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_M1_E16_MASK)
  .value("PseudoVFMACC_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_M2_E16)
  .value("PseudoVFMACC_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_M2_E16_MASK)
  .value("PseudoVFMACC_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_M4_E16)
  .value("PseudoVFMACC_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_M4_E16_MASK)
  .value("PseudoVFMACC_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_M8_E16)
  .value("PseudoVFMACC_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_M8_E16_MASK)
  .value("PseudoVFMACC_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_MF2_E16)
  .value("PseudoVFMACC_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_MF2_E16_MASK)
  .value("PseudoVFMACC_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_MF4_E16)
  .value("PseudoVFMACC_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR16_MF4_E16_MASK)
  .value("PseudoVFMACC_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR32_M1_E32)
  .value("PseudoVFMACC_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR32_M1_E32_MASK)
  .value("PseudoVFMACC_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR32_M2_E32)
  .value("PseudoVFMACC_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR32_M2_E32_MASK)
  .value("PseudoVFMACC_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR32_M4_E32)
  .value("PseudoVFMACC_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR32_M4_E32_MASK)
  .value("PseudoVFMACC_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR32_M8_E32)
  .value("PseudoVFMACC_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR32_M8_E32_MASK)
  .value("PseudoVFMACC_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR32_MF2_E32)
  .value("PseudoVFMACC_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR32_MF2_E32_MASK)
  .value("PseudoVFMACC_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR64_M1_E64)
  .value("PseudoVFMACC_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR64_M1_E64_MASK)
  .value("PseudoVFMACC_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR64_M2_E64)
  .value("PseudoVFMACC_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR64_M2_E64_MASK)
  .value("PseudoVFMACC_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR64_M4_E64)
  .value("PseudoVFMACC_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR64_M4_E64_MASK)
  .value("PseudoVFMACC_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR64_M8_E64)
  .value("PseudoVFMACC_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VFPR64_M8_E64_MASK)
  .value("PseudoVFMACC_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M1_E16)
  .value("PseudoVFMACC_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M1_E16_MASK)
  .value("PseudoVFMACC_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M1_E32)
  .value("PseudoVFMACC_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M1_E32_MASK)
  .value("PseudoVFMACC_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M1_E64)
  .value("PseudoVFMACC_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M1_E64_MASK)
  .value("PseudoVFMACC_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M2_E16)
  .value("PseudoVFMACC_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M2_E16_MASK)
  .value("PseudoVFMACC_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M2_E32)
  .value("PseudoVFMACC_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M2_E32_MASK)
  .value("PseudoVFMACC_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M2_E64)
  .value("PseudoVFMACC_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M2_E64_MASK)
  .value("PseudoVFMACC_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M4_E16)
  .value("PseudoVFMACC_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M4_E16_MASK)
  .value("PseudoVFMACC_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M4_E32)
  .value("PseudoVFMACC_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M4_E32_MASK)
  .value("PseudoVFMACC_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M4_E64)
  .value("PseudoVFMACC_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M4_E64_MASK)
  .value("PseudoVFMACC_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M8_E16)
  .value("PseudoVFMACC_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M8_E16_MASK)
  .value("PseudoVFMACC_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M8_E32)
  .value("PseudoVFMACC_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M8_E32_MASK)
  .value("PseudoVFMACC_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M8_E64)
  .value("PseudoVFMACC_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_M8_E64_MASK)
  .value("PseudoVFMACC_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_MF2_E16)
  .value("PseudoVFMACC_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_MF2_E16_MASK)
  .value("PseudoVFMACC_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_MF2_E32)
  .value("PseudoVFMACC_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_MF2_E32_MASK)
  .value("PseudoVFMACC_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_MF4_E16)
  .value("PseudoVFMACC_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMACC_VV_MF4_E16_MASK)
  .value("PseudoVFMADD_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_M1_E16)
  .value("PseudoVFMADD_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_M1_E16_MASK)
  .value("PseudoVFMADD_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_M2_E16)
  .value("PseudoVFMADD_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_M2_E16_MASK)
  .value("PseudoVFMADD_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_M4_E16)
  .value("PseudoVFMADD_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_M4_E16_MASK)
  .value("PseudoVFMADD_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_M8_E16)
  .value("PseudoVFMADD_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_M8_E16_MASK)
  .value("PseudoVFMADD_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_MF2_E16)
  .value("PseudoVFMADD_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_MF2_E16_MASK)
  .value("PseudoVFMADD_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_MF4_E16)
  .value("PseudoVFMADD_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR16_MF4_E16_MASK)
  .value("PseudoVFMADD_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR32_M1_E32)
  .value("PseudoVFMADD_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR32_M1_E32_MASK)
  .value("PseudoVFMADD_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR32_M2_E32)
  .value("PseudoVFMADD_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR32_M2_E32_MASK)
  .value("PseudoVFMADD_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR32_M4_E32)
  .value("PseudoVFMADD_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR32_M4_E32_MASK)
  .value("PseudoVFMADD_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR32_M8_E32)
  .value("PseudoVFMADD_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR32_M8_E32_MASK)
  .value("PseudoVFMADD_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR32_MF2_E32)
  .value("PseudoVFMADD_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR32_MF2_E32_MASK)
  .value("PseudoVFMADD_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR64_M1_E64)
  .value("PseudoVFMADD_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR64_M1_E64_MASK)
  .value("PseudoVFMADD_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR64_M2_E64)
  .value("PseudoVFMADD_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR64_M2_E64_MASK)
  .value("PseudoVFMADD_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR64_M4_E64)
  .value("PseudoVFMADD_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR64_M4_E64_MASK)
  .value("PseudoVFMADD_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR64_M8_E64)
  .value("PseudoVFMADD_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VFPR64_M8_E64_MASK)
  .value("PseudoVFMADD_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M1_E16)
  .value("PseudoVFMADD_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M1_E16_MASK)
  .value("PseudoVFMADD_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M1_E32)
  .value("PseudoVFMADD_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M1_E32_MASK)
  .value("PseudoVFMADD_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M1_E64)
  .value("PseudoVFMADD_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M1_E64_MASK)
  .value("PseudoVFMADD_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M2_E16)
  .value("PseudoVFMADD_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M2_E16_MASK)
  .value("PseudoVFMADD_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M2_E32)
  .value("PseudoVFMADD_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M2_E32_MASK)
  .value("PseudoVFMADD_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M2_E64)
  .value("PseudoVFMADD_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M2_E64_MASK)
  .value("PseudoVFMADD_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M4_E16)
  .value("PseudoVFMADD_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M4_E16_MASK)
  .value("PseudoVFMADD_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M4_E32)
  .value("PseudoVFMADD_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M4_E32_MASK)
  .value("PseudoVFMADD_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M4_E64)
  .value("PseudoVFMADD_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M4_E64_MASK)
  .value("PseudoVFMADD_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M8_E16)
  .value("PseudoVFMADD_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M8_E16_MASK)
  .value("PseudoVFMADD_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M8_E32)
  .value("PseudoVFMADD_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M8_E32_MASK)
  .value("PseudoVFMADD_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M8_E64)
  .value("PseudoVFMADD_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_M8_E64_MASK)
  .value("PseudoVFMADD_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_MF2_E16)
  .value("PseudoVFMADD_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_MF2_E16_MASK)
  .value("PseudoVFMADD_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_MF2_E32)
  .value("PseudoVFMADD_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_MF2_E32_MASK)
  .value("PseudoVFMADD_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_MF4_E16)
  .value("PseudoVFMADD_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMADD_VV_MF4_E16_MASK)
  .value("PseudoVFMAX_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_M1_E16)
  .value("PseudoVFMAX_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_M1_E16_MASK)
  .value("PseudoVFMAX_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_M2_E16)
  .value("PseudoVFMAX_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_M2_E16_MASK)
  .value("PseudoVFMAX_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_M4_E16)
  .value("PseudoVFMAX_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_M4_E16_MASK)
  .value("PseudoVFMAX_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_M8_E16)
  .value("PseudoVFMAX_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_M8_E16_MASK)
  .value("PseudoVFMAX_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_MF2_E16)
  .value("PseudoVFMAX_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_MF2_E16_MASK)
  .value("PseudoVFMAX_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_MF4_E16)
  .value("PseudoVFMAX_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR16_MF4_E16_MASK)
  .value("PseudoVFMAX_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR32_M1_E32)
  .value("PseudoVFMAX_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR32_M1_E32_MASK)
  .value("PseudoVFMAX_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR32_M2_E32)
  .value("PseudoVFMAX_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR32_M2_E32_MASK)
  .value("PseudoVFMAX_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR32_M4_E32)
  .value("PseudoVFMAX_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR32_M4_E32_MASK)
  .value("PseudoVFMAX_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR32_M8_E32)
  .value("PseudoVFMAX_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR32_M8_E32_MASK)
  .value("PseudoVFMAX_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR32_MF2_E32)
  .value("PseudoVFMAX_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR32_MF2_E32_MASK)
  .value("PseudoVFMAX_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR64_M1_E64)
  .value("PseudoVFMAX_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR64_M1_E64_MASK)
  .value("PseudoVFMAX_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR64_M2_E64)
  .value("PseudoVFMAX_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR64_M2_E64_MASK)
  .value("PseudoVFMAX_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR64_M4_E64)
  .value("PseudoVFMAX_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR64_M4_E64_MASK)
  .value("PseudoVFMAX_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR64_M8_E64)
  .value("PseudoVFMAX_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VFPR64_M8_E64_MASK)
  .value("PseudoVFMAX_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M1_E16)
  .value("PseudoVFMAX_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M1_E16_MASK)
  .value("PseudoVFMAX_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M1_E32)
  .value("PseudoVFMAX_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M1_E32_MASK)
  .value("PseudoVFMAX_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M1_E64)
  .value("PseudoVFMAX_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M1_E64_MASK)
  .value("PseudoVFMAX_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M2_E16)
  .value("PseudoVFMAX_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M2_E16_MASK)
  .value("PseudoVFMAX_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M2_E32)
  .value("PseudoVFMAX_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M2_E32_MASK)
  .value("PseudoVFMAX_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M2_E64)
  .value("PseudoVFMAX_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M2_E64_MASK)
  .value("PseudoVFMAX_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M4_E16)
  .value("PseudoVFMAX_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M4_E16_MASK)
  .value("PseudoVFMAX_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M4_E32)
  .value("PseudoVFMAX_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M4_E32_MASK)
  .value("PseudoVFMAX_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M4_E64)
  .value("PseudoVFMAX_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M4_E64_MASK)
  .value("PseudoVFMAX_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M8_E16)
  .value("PseudoVFMAX_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M8_E16_MASK)
  .value("PseudoVFMAX_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M8_E32)
  .value("PseudoVFMAX_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M8_E32_MASK)
  .value("PseudoVFMAX_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M8_E64)
  .value("PseudoVFMAX_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_M8_E64_MASK)
  .value("PseudoVFMAX_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_MF2_E16)
  .value("PseudoVFMAX_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_MF2_E16_MASK)
  .value("PseudoVFMAX_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_MF2_E32)
  .value("PseudoVFMAX_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_MF2_E32_MASK)
  .value("PseudoVFMAX_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_MF4_E16)
  .value("PseudoVFMAX_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMAX_VV_MF4_E16_MASK)
  .value("PseudoVFMERGE_VFPR16M_M1", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR16M_M1)
  .value("PseudoVFMERGE_VFPR16M_M2", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR16M_M2)
  .value("PseudoVFMERGE_VFPR16M_M4", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR16M_M4)
  .value("PseudoVFMERGE_VFPR16M_M8", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR16M_M8)
  .value("PseudoVFMERGE_VFPR16M_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR16M_MF2)
  .value("PseudoVFMERGE_VFPR16M_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR16M_MF4)
  .value("PseudoVFMERGE_VFPR32M_M1", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR32M_M1)
  .value("PseudoVFMERGE_VFPR32M_M2", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR32M_M2)
  .value("PseudoVFMERGE_VFPR32M_M4", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR32M_M4)
  .value("PseudoVFMERGE_VFPR32M_M8", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR32M_M8)
  .value("PseudoVFMERGE_VFPR32M_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR32M_MF2)
  .value("PseudoVFMERGE_VFPR64M_M1", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR64M_M1)
  .value("PseudoVFMERGE_VFPR64M_M2", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR64M_M2)
  .value("PseudoVFMERGE_VFPR64M_M4", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR64M_M4)
  .value("PseudoVFMERGE_VFPR64M_M8", LIEF::assembly::riscv::OPCODE::PseudoVFMERGE_VFPR64M_M8)
  .value("PseudoVFMIN_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_M1_E16)
  .value("PseudoVFMIN_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_M1_E16_MASK)
  .value("PseudoVFMIN_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_M2_E16)
  .value("PseudoVFMIN_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_M2_E16_MASK)
  .value("PseudoVFMIN_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_M4_E16)
  .value("PseudoVFMIN_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_M4_E16_MASK)
  .value("PseudoVFMIN_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_M8_E16)
  .value("PseudoVFMIN_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_M8_E16_MASK)
  .value("PseudoVFMIN_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_MF2_E16)
  .value("PseudoVFMIN_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_MF2_E16_MASK)
  .value("PseudoVFMIN_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_MF4_E16)
  .value("PseudoVFMIN_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR16_MF4_E16_MASK)
  .value("PseudoVFMIN_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR32_M1_E32)
  .value("PseudoVFMIN_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR32_M1_E32_MASK)
  .value("PseudoVFMIN_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR32_M2_E32)
  .value("PseudoVFMIN_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR32_M2_E32_MASK)
  .value("PseudoVFMIN_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR32_M4_E32)
  .value("PseudoVFMIN_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR32_M4_E32_MASK)
  .value("PseudoVFMIN_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR32_M8_E32)
  .value("PseudoVFMIN_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR32_M8_E32_MASK)
  .value("PseudoVFMIN_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR32_MF2_E32)
  .value("PseudoVFMIN_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR32_MF2_E32_MASK)
  .value("PseudoVFMIN_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR64_M1_E64)
  .value("PseudoVFMIN_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR64_M1_E64_MASK)
  .value("PseudoVFMIN_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR64_M2_E64)
  .value("PseudoVFMIN_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR64_M2_E64_MASK)
  .value("PseudoVFMIN_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR64_M4_E64)
  .value("PseudoVFMIN_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR64_M4_E64_MASK)
  .value("PseudoVFMIN_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR64_M8_E64)
  .value("PseudoVFMIN_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VFPR64_M8_E64_MASK)
  .value("PseudoVFMIN_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M1_E16)
  .value("PseudoVFMIN_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M1_E16_MASK)
  .value("PseudoVFMIN_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M1_E32)
  .value("PseudoVFMIN_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M1_E32_MASK)
  .value("PseudoVFMIN_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M1_E64)
  .value("PseudoVFMIN_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M1_E64_MASK)
  .value("PseudoVFMIN_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M2_E16)
  .value("PseudoVFMIN_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M2_E16_MASK)
  .value("PseudoVFMIN_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M2_E32)
  .value("PseudoVFMIN_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M2_E32_MASK)
  .value("PseudoVFMIN_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M2_E64)
  .value("PseudoVFMIN_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M2_E64_MASK)
  .value("PseudoVFMIN_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M4_E16)
  .value("PseudoVFMIN_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M4_E16_MASK)
  .value("PseudoVFMIN_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M4_E32)
  .value("PseudoVFMIN_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M4_E32_MASK)
  .value("PseudoVFMIN_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M4_E64)
  .value("PseudoVFMIN_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M4_E64_MASK)
  .value("PseudoVFMIN_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M8_E16)
  .value("PseudoVFMIN_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M8_E16_MASK)
  .value("PseudoVFMIN_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M8_E32)
  .value("PseudoVFMIN_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M8_E32_MASK)
  .value("PseudoVFMIN_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M8_E64)
  .value("PseudoVFMIN_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_M8_E64_MASK)
  .value("PseudoVFMIN_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_MF2_E16)
  .value("PseudoVFMIN_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_MF2_E16_MASK)
  .value("PseudoVFMIN_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_MF2_E32)
  .value("PseudoVFMIN_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_MF2_E32_MASK)
  .value("PseudoVFMIN_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_MF4_E16)
  .value("PseudoVFMIN_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMIN_VV_MF4_E16_MASK)
  .value("PseudoVFMSAC_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_M1_E16)
  .value("PseudoVFMSAC_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_M1_E16_MASK)
  .value("PseudoVFMSAC_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_M2_E16)
  .value("PseudoVFMSAC_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_M2_E16_MASK);
  opcodes.value("PseudoVFMSAC_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_M4_E16)
  .value("PseudoVFMSAC_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_M4_E16_MASK)
  .value("PseudoVFMSAC_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_M8_E16)
  .value("PseudoVFMSAC_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_M8_E16_MASK)
  .value("PseudoVFMSAC_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_MF2_E16)
  .value("PseudoVFMSAC_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_MF2_E16_MASK)
  .value("PseudoVFMSAC_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_MF4_E16)
  .value("PseudoVFMSAC_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR16_MF4_E16_MASK)
  .value("PseudoVFMSAC_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR32_M1_E32)
  .value("PseudoVFMSAC_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR32_M1_E32_MASK)
  .value("PseudoVFMSAC_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR32_M2_E32)
  .value("PseudoVFMSAC_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR32_M2_E32_MASK)
  .value("PseudoVFMSAC_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR32_M4_E32)
  .value("PseudoVFMSAC_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR32_M4_E32_MASK)
  .value("PseudoVFMSAC_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR32_M8_E32)
  .value("PseudoVFMSAC_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR32_M8_E32_MASK)
  .value("PseudoVFMSAC_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR32_MF2_E32)
  .value("PseudoVFMSAC_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR32_MF2_E32_MASK)
  .value("PseudoVFMSAC_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR64_M1_E64)
  .value("PseudoVFMSAC_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR64_M1_E64_MASK)
  .value("PseudoVFMSAC_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR64_M2_E64)
  .value("PseudoVFMSAC_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR64_M2_E64_MASK)
  .value("PseudoVFMSAC_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR64_M4_E64)
  .value("PseudoVFMSAC_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR64_M4_E64_MASK)
  .value("PseudoVFMSAC_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR64_M8_E64)
  .value("PseudoVFMSAC_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VFPR64_M8_E64_MASK)
  .value("PseudoVFMSAC_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M1_E16)
  .value("PseudoVFMSAC_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M1_E16_MASK)
  .value("PseudoVFMSAC_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M1_E32)
  .value("PseudoVFMSAC_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M1_E32_MASK)
  .value("PseudoVFMSAC_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M1_E64)
  .value("PseudoVFMSAC_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M1_E64_MASK)
  .value("PseudoVFMSAC_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M2_E16)
  .value("PseudoVFMSAC_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M2_E16_MASK)
  .value("PseudoVFMSAC_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M2_E32)
  .value("PseudoVFMSAC_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M2_E32_MASK)
  .value("PseudoVFMSAC_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M2_E64)
  .value("PseudoVFMSAC_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M2_E64_MASK)
  .value("PseudoVFMSAC_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M4_E16)
  .value("PseudoVFMSAC_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M4_E16_MASK)
  .value("PseudoVFMSAC_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M4_E32)
  .value("PseudoVFMSAC_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M4_E32_MASK)
  .value("PseudoVFMSAC_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M4_E64)
  .value("PseudoVFMSAC_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M4_E64_MASK)
  .value("PseudoVFMSAC_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M8_E16)
  .value("PseudoVFMSAC_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M8_E16_MASK)
  .value("PseudoVFMSAC_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M8_E32)
  .value("PseudoVFMSAC_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M8_E32_MASK)
  .value("PseudoVFMSAC_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M8_E64)
  .value("PseudoVFMSAC_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_M8_E64_MASK)
  .value("PseudoVFMSAC_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_MF2_E16)
  .value("PseudoVFMSAC_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_MF2_E16_MASK)
  .value("PseudoVFMSAC_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_MF2_E32)
  .value("PseudoVFMSAC_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_MF2_E32_MASK)
  .value("PseudoVFMSAC_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_MF4_E16)
  .value("PseudoVFMSAC_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSAC_VV_MF4_E16_MASK)
  .value("PseudoVFMSUB_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_M1_E16)
  .value("PseudoVFMSUB_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_M1_E16_MASK)
  .value("PseudoVFMSUB_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_M2_E16)
  .value("PseudoVFMSUB_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_M2_E16_MASK)
  .value("PseudoVFMSUB_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_M4_E16)
  .value("PseudoVFMSUB_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_M4_E16_MASK)
  .value("PseudoVFMSUB_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_M8_E16)
  .value("PseudoVFMSUB_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_M8_E16_MASK)
  .value("PseudoVFMSUB_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_MF2_E16)
  .value("PseudoVFMSUB_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_MF2_E16_MASK)
  .value("PseudoVFMSUB_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_MF4_E16)
  .value("PseudoVFMSUB_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR16_MF4_E16_MASK)
  .value("PseudoVFMSUB_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR32_M1_E32)
  .value("PseudoVFMSUB_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR32_M1_E32_MASK)
  .value("PseudoVFMSUB_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR32_M2_E32)
  .value("PseudoVFMSUB_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR32_M2_E32_MASK)
  .value("PseudoVFMSUB_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR32_M4_E32)
  .value("PseudoVFMSUB_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR32_M4_E32_MASK)
  .value("PseudoVFMSUB_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR32_M8_E32)
  .value("PseudoVFMSUB_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR32_M8_E32_MASK)
  .value("PseudoVFMSUB_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR32_MF2_E32)
  .value("PseudoVFMSUB_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR32_MF2_E32_MASK)
  .value("PseudoVFMSUB_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR64_M1_E64)
  .value("PseudoVFMSUB_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR64_M1_E64_MASK)
  .value("PseudoVFMSUB_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR64_M2_E64)
  .value("PseudoVFMSUB_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR64_M2_E64_MASK)
  .value("PseudoVFMSUB_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR64_M4_E64)
  .value("PseudoVFMSUB_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR64_M4_E64_MASK)
  .value("PseudoVFMSUB_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR64_M8_E64)
  .value("PseudoVFMSUB_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VFPR64_M8_E64_MASK)
  .value("PseudoVFMSUB_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M1_E16)
  .value("PseudoVFMSUB_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M1_E16_MASK)
  .value("PseudoVFMSUB_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M1_E32)
  .value("PseudoVFMSUB_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M1_E32_MASK)
  .value("PseudoVFMSUB_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M1_E64)
  .value("PseudoVFMSUB_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M1_E64_MASK)
  .value("PseudoVFMSUB_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M2_E16)
  .value("PseudoVFMSUB_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M2_E16_MASK)
  .value("PseudoVFMSUB_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M2_E32)
  .value("PseudoVFMSUB_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M2_E32_MASK)
  .value("PseudoVFMSUB_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M2_E64)
  .value("PseudoVFMSUB_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M2_E64_MASK)
  .value("PseudoVFMSUB_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M4_E16)
  .value("PseudoVFMSUB_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M4_E16_MASK)
  .value("PseudoVFMSUB_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M4_E32)
  .value("PseudoVFMSUB_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M4_E32_MASK)
  .value("PseudoVFMSUB_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M4_E64)
  .value("PseudoVFMSUB_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M4_E64_MASK)
  .value("PseudoVFMSUB_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M8_E16)
  .value("PseudoVFMSUB_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M8_E16_MASK)
  .value("PseudoVFMSUB_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M8_E32)
  .value("PseudoVFMSUB_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M8_E32_MASK)
  .value("PseudoVFMSUB_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M8_E64)
  .value("PseudoVFMSUB_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_M8_E64_MASK)
  .value("PseudoVFMSUB_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_MF2_E16)
  .value("PseudoVFMSUB_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_MF2_E16_MASK)
  .value("PseudoVFMSUB_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_MF2_E32)
  .value("PseudoVFMSUB_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_MF2_E32_MASK)
  .value("PseudoVFMSUB_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_MF4_E16)
  .value("PseudoVFMSUB_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMSUB_VV_MF4_E16_MASK)
  .value("PseudoVFMUL_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_M1_E16)
  .value("PseudoVFMUL_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_M1_E16_MASK)
  .value("PseudoVFMUL_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_M2_E16)
  .value("PseudoVFMUL_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_M2_E16_MASK)
  .value("PseudoVFMUL_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_M4_E16)
  .value("PseudoVFMUL_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_M4_E16_MASK)
  .value("PseudoVFMUL_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_M8_E16)
  .value("PseudoVFMUL_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_M8_E16_MASK)
  .value("PseudoVFMUL_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_MF2_E16)
  .value("PseudoVFMUL_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_MF2_E16_MASK)
  .value("PseudoVFMUL_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_MF4_E16)
  .value("PseudoVFMUL_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR16_MF4_E16_MASK)
  .value("PseudoVFMUL_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR32_M1_E32)
  .value("PseudoVFMUL_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR32_M1_E32_MASK)
  .value("PseudoVFMUL_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR32_M2_E32)
  .value("PseudoVFMUL_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR32_M2_E32_MASK)
  .value("PseudoVFMUL_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR32_M4_E32)
  .value("PseudoVFMUL_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR32_M4_E32_MASK)
  .value("PseudoVFMUL_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR32_M8_E32)
  .value("PseudoVFMUL_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR32_M8_E32_MASK)
  .value("PseudoVFMUL_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR32_MF2_E32)
  .value("PseudoVFMUL_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR32_MF2_E32_MASK)
  .value("PseudoVFMUL_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR64_M1_E64)
  .value("PseudoVFMUL_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR64_M1_E64_MASK)
  .value("PseudoVFMUL_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR64_M2_E64)
  .value("PseudoVFMUL_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR64_M2_E64_MASK)
  .value("PseudoVFMUL_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR64_M4_E64)
  .value("PseudoVFMUL_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR64_M4_E64_MASK)
  .value("PseudoVFMUL_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR64_M8_E64)
  .value("PseudoVFMUL_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VFPR64_M8_E64_MASK)
  .value("PseudoVFMUL_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M1_E16)
  .value("PseudoVFMUL_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M1_E16_MASK)
  .value("PseudoVFMUL_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M1_E32)
  .value("PseudoVFMUL_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M1_E32_MASK)
  .value("PseudoVFMUL_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M1_E64)
  .value("PseudoVFMUL_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M1_E64_MASK)
  .value("PseudoVFMUL_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M2_E16)
  .value("PseudoVFMUL_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M2_E16_MASK)
  .value("PseudoVFMUL_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M2_E32)
  .value("PseudoVFMUL_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M2_E32_MASK)
  .value("PseudoVFMUL_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M2_E64)
  .value("PseudoVFMUL_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M2_E64_MASK)
  .value("PseudoVFMUL_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M4_E16)
  .value("PseudoVFMUL_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M4_E16_MASK)
  .value("PseudoVFMUL_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M4_E32)
  .value("PseudoVFMUL_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M4_E32_MASK)
  .value("PseudoVFMUL_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M4_E64)
  .value("PseudoVFMUL_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M4_E64_MASK)
  .value("PseudoVFMUL_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M8_E16)
  .value("PseudoVFMUL_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M8_E16_MASK)
  .value("PseudoVFMUL_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M8_E32)
  .value("PseudoVFMUL_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M8_E32_MASK)
  .value("PseudoVFMUL_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M8_E64)
  .value("PseudoVFMUL_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_M8_E64_MASK)
  .value("PseudoVFMUL_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_MF2_E16)
  .value("PseudoVFMUL_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_MF2_E16_MASK)
  .value("PseudoVFMUL_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_MF2_E32)
  .value("PseudoVFMUL_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_MF2_E32_MASK)
  .value("PseudoVFMUL_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_MF4_E16)
  .value("PseudoVFMUL_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFMUL_VV_MF4_E16_MASK)
  .value("PseudoVFMV_FPR16_S", LIEF::assembly::riscv::OPCODE::PseudoVFMV_FPR16_S)
  .value("PseudoVFMV_FPR32_S", LIEF::assembly::riscv::OPCODE::PseudoVFMV_FPR32_S)
  .value("PseudoVFMV_FPR64_S", LIEF::assembly::riscv::OPCODE::PseudoVFMV_FPR64_S)
  .value("PseudoVFMV_S_FPR16", LIEF::assembly::riscv::OPCODE::PseudoVFMV_S_FPR16)
  .value("PseudoVFMV_S_FPR32", LIEF::assembly::riscv::OPCODE::PseudoVFMV_S_FPR32)
  .value("PseudoVFMV_S_FPR64", LIEF::assembly::riscv::OPCODE::PseudoVFMV_S_FPR64)
  .value("PseudoVFMV_V_FPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR16_M1)
  .value("PseudoVFMV_V_FPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR16_M2)
  .value("PseudoVFMV_V_FPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR16_M4)
  .value("PseudoVFMV_V_FPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR16_M8)
  .value("PseudoVFMV_V_FPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR16_MF2)
  .value("PseudoVFMV_V_FPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR16_MF4)
  .value("PseudoVFMV_V_FPR32_M1", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR32_M1)
  .value("PseudoVFMV_V_FPR32_M2", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR32_M2)
  .value("PseudoVFMV_V_FPR32_M4", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR32_M4)
  .value("PseudoVFMV_V_FPR32_M8", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR32_M8)
  .value("PseudoVFMV_V_FPR32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR32_MF2)
  .value("PseudoVFMV_V_FPR64_M1", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR64_M1)
  .value("PseudoVFMV_V_FPR64_M2", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR64_M2)
  .value("PseudoVFMV_V_FPR64_M4", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR64_M4)
  .value("PseudoVFMV_V_FPR64_M8", LIEF::assembly::riscv::OPCODE::PseudoVFMV_V_FPR64_M8)
  .value("PseudoVFNCVTBF16_F_F_W_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M1_E16)
  .value("PseudoVFNCVTBF16_F_F_W_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M1_E16_MASK)
  .value("PseudoVFNCVTBF16_F_F_W_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M1_E32)
  .value("PseudoVFNCVTBF16_F_F_W_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M1_E32_MASK)
  .value("PseudoVFNCVTBF16_F_F_W_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M2_E16)
  .value("PseudoVFNCVTBF16_F_F_W_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M2_E16_MASK)
  .value("PseudoVFNCVTBF16_F_F_W_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M2_E32)
  .value("PseudoVFNCVTBF16_F_F_W_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M2_E32_MASK)
  .value("PseudoVFNCVTBF16_F_F_W_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M4_E16)
  .value("PseudoVFNCVTBF16_F_F_W_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M4_E16_MASK)
  .value("PseudoVFNCVTBF16_F_F_W_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M4_E32)
  .value("PseudoVFNCVTBF16_F_F_W_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_M4_E32_MASK)
  .value("PseudoVFNCVTBF16_F_F_W_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_MF2_E16)
  .value("PseudoVFNCVTBF16_F_F_W_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_MF2_E16_MASK)
  .value("PseudoVFNCVTBF16_F_F_W_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_MF2_E32)
  .value("PseudoVFNCVTBF16_F_F_W_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_MF2_E32_MASK)
  .value("PseudoVFNCVTBF16_F_F_W_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_MF4_E16)
  .value("PseudoVFNCVTBF16_F_F_W_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVTBF16_F_F_W_MF4_E16_MASK)
  .value("PseudoVFNCVT_F_F_W_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M1_E16)
  .value("PseudoVFNCVT_F_F_W_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M1_E16_MASK)
  .value("PseudoVFNCVT_F_F_W_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M1_E32)
  .value("PseudoVFNCVT_F_F_W_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M1_E32_MASK)
  .value("PseudoVFNCVT_F_F_W_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M2_E16)
  .value("PseudoVFNCVT_F_F_W_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M2_E16_MASK)
  .value("PseudoVFNCVT_F_F_W_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M2_E32)
  .value("PseudoVFNCVT_F_F_W_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M2_E32_MASK)
  .value("PseudoVFNCVT_F_F_W_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M4_E16)
  .value("PseudoVFNCVT_F_F_W_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M4_E16_MASK)
  .value("PseudoVFNCVT_F_F_W_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M4_E32)
  .value("PseudoVFNCVT_F_F_W_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_M4_E32_MASK)
  .value("PseudoVFNCVT_F_F_W_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_MF2_E16)
  .value("PseudoVFNCVT_F_F_W_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_MF2_E16_MASK)
  .value("PseudoVFNCVT_F_F_W_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_MF2_E32)
  .value("PseudoVFNCVT_F_F_W_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_MF2_E32_MASK)
  .value("PseudoVFNCVT_F_F_W_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_MF4_E16)
  .value("PseudoVFNCVT_F_F_W_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_F_W_MF4_E16_MASK)
  .value("PseudoVFNCVT_F_XU_W_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M1_E16)
  .value("PseudoVFNCVT_F_XU_W_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M1_E16_MASK)
  .value("PseudoVFNCVT_F_XU_W_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M1_E32)
  .value("PseudoVFNCVT_F_XU_W_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M1_E32_MASK)
  .value("PseudoVFNCVT_F_XU_W_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M2_E16)
  .value("PseudoVFNCVT_F_XU_W_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M2_E16_MASK)
  .value("PseudoVFNCVT_F_XU_W_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M2_E32)
  .value("PseudoVFNCVT_F_XU_W_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M2_E32_MASK)
  .value("PseudoVFNCVT_F_XU_W_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M4_E16)
  .value("PseudoVFNCVT_F_XU_W_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M4_E16_MASK)
  .value("PseudoVFNCVT_F_XU_W_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M4_E32)
  .value("PseudoVFNCVT_F_XU_W_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_M4_E32_MASK)
  .value("PseudoVFNCVT_F_XU_W_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_MF2_E16)
  .value("PseudoVFNCVT_F_XU_W_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_MF2_E16_MASK)
  .value("PseudoVFNCVT_F_XU_W_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_MF2_E32)
  .value("PseudoVFNCVT_F_XU_W_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_MF2_E32_MASK)
  .value("PseudoVFNCVT_F_XU_W_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_MF4_E16)
  .value("PseudoVFNCVT_F_XU_W_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_XU_W_MF4_E16_MASK)
  .value("PseudoVFNCVT_F_X_W_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M1_E16)
  .value("PseudoVFNCVT_F_X_W_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M1_E16_MASK)
  .value("PseudoVFNCVT_F_X_W_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M1_E32)
  .value("PseudoVFNCVT_F_X_W_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M1_E32_MASK)
  .value("PseudoVFNCVT_F_X_W_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M2_E16)
  .value("PseudoVFNCVT_F_X_W_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M2_E16_MASK)
  .value("PseudoVFNCVT_F_X_W_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M2_E32)
  .value("PseudoVFNCVT_F_X_W_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M2_E32_MASK)
  .value("PseudoVFNCVT_F_X_W_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M4_E16)
  .value("PseudoVFNCVT_F_X_W_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M4_E16_MASK)
  .value("PseudoVFNCVT_F_X_W_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M4_E32)
  .value("PseudoVFNCVT_F_X_W_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_M4_E32_MASK)
  .value("PseudoVFNCVT_F_X_W_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_MF2_E16)
  .value("PseudoVFNCVT_F_X_W_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_MF2_E16_MASK)
  .value("PseudoVFNCVT_F_X_W_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_MF2_E32)
  .value("PseudoVFNCVT_F_X_W_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_MF2_E32_MASK)
  .value("PseudoVFNCVT_F_X_W_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_MF4_E16)
  .value("PseudoVFNCVT_F_X_W_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_F_X_W_MF4_E16_MASK)
  .value("PseudoVFNCVT_ROD_F_F_W_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M1_E16)
  .value("PseudoVFNCVT_ROD_F_F_W_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M1_E16_MASK)
  .value("PseudoVFNCVT_ROD_F_F_W_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M1_E32)
  .value("PseudoVFNCVT_ROD_F_F_W_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M1_E32_MASK)
  .value("PseudoVFNCVT_ROD_F_F_W_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M2_E16)
  .value("PseudoVFNCVT_ROD_F_F_W_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M2_E16_MASK)
  .value("PseudoVFNCVT_ROD_F_F_W_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M2_E32)
  .value("PseudoVFNCVT_ROD_F_F_W_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M2_E32_MASK)
  .value("PseudoVFNCVT_ROD_F_F_W_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M4_E16)
  .value("PseudoVFNCVT_ROD_F_F_W_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M4_E16_MASK)
  .value("PseudoVFNCVT_ROD_F_F_W_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M4_E32)
  .value("PseudoVFNCVT_ROD_F_F_W_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_M4_E32_MASK)
  .value("PseudoVFNCVT_ROD_F_F_W_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_MF2_E16)
  .value("PseudoVFNCVT_ROD_F_F_W_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_MF2_E16_MASK)
  .value("PseudoVFNCVT_ROD_F_F_W_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_MF2_E32)
  .value("PseudoVFNCVT_ROD_F_F_W_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_MF2_E32_MASK)
  .value("PseudoVFNCVT_ROD_F_F_W_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_MF4_E16)
  .value("PseudoVFNCVT_ROD_F_F_W_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_ROD_F_F_W_MF4_E16_MASK)
  .value("PseudoVFNCVT_RTZ_XU_F_W_M1", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_M1)
  .value("PseudoVFNCVT_RTZ_XU_F_W_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_M1_MASK)
  .value("PseudoVFNCVT_RTZ_XU_F_W_M2", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_M2)
  .value("PseudoVFNCVT_RTZ_XU_F_W_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_M2_MASK)
  .value("PseudoVFNCVT_RTZ_XU_F_W_M4", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_M4)
  .value("PseudoVFNCVT_RTZ_XU_F_W_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_M4_MASK)
  .value("PseudoVFNCVT_RTZ_XU_F_W_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_MF2)
  .value("PseudoVFNCVT_RTZ_XU_F_W_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_MF2_MASK)
  .value("PseudoVFNCVT_RTZ_XU_F_W_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_MF4)
  .value("PseudoVFNCVT_RTZ_XU_F_W_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_MF4_MASK)
  .value("PseudoVFNCVT_RTZ_XU_F_W_MF8", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_MF8)
  .value("PseudoVFNCVT_RTZ_XU_F_W_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_XU_F_W_MF8_MASK)
  .value("PseudoVFNCVT_RTZ_X_F_W_M1", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_M1);
  opcodes.value("PseudoVFNCVT_RTZ_X_F_W_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_M1_MASK)
  .value("PseudoVFNCVT_RTZ_X_F_W_M2", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_M2)
  .value("PseudoVFNCVT_RTZ_X_F_W_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_M2_MASK)
  .value("PseudoVFNCVT_RTZ_X_F_W_M4", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_M4)
  .value("PseudoVFNCVT_RTZ_X_F_W_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_M4_MASK)
  .value("PseudoVFNCVT_RTZ_X_F_W_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_MF2)
  .value("PseudoVFNCVT_RTZ_X_F_W_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_MF2_MASK)
  .value("PseudoVFNCVT_RTZ_X_F_W_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_MF4)
  .value("PseudoVFNCVT_RTZ_X_F_W_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_MF4_MASK)
  .value("PseudoVFNCVT_RTZ_X_F_W_MF8", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_MF8)
  .value("PseudoVFNCVT_RTZ_X_F_W_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_RTZ_X_F_W_MF8_MASK)
  .value("PseudoVFNCVT_XU_F_W_M1", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_M1)
  .value("PseudoVFNCVT_XU_F_W_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_M1_MASK)
  .value("PseudoVFNCVT_XU_F_W_M2", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_M2)
  .value("PseudoVFNCVT_XU_F_W_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_M2_MASK)
  .value("PseudoVFNCVT_XU_F_W_M4", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_M4)
  .value("PseudoVFNCVT_XU_F_W_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_M4_MASK)
  .value("PseudoVFNCVT_XU_F_W_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_MF2)
  .value("PseudoVFNCVT_XU_F_W_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_MF2_MASK)
  .value("PseudoVFNCVT_XU_F_W_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_MF4)
  .value("PseudoVFNCVT_XU_F_W_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_MF4_MASK)
  .value("PseudoVFNCVT_XU_F_W_MF8", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_MF8)
  .value("PseudoVFNCVT_XU_F_W_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_XU_F_W_MF8_MASK)
  .value("PseudoVFNCVT_X_F_W_M1", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_M1)
  .value("PseudoVFNCVT_X_F_W_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_M1_MASK)
  .value("PseudoVFNCVT_X_F_W_M2", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_M2)
  .value("PseudoVFNCVT_X_F_W_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_M2_MASK)
  .value("PseudoVFNCVT_X_F_W_M4", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_M4)
  .value("PseudoVFNCVT_X_F_W_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_M4_MASK)
  .value("PseudoVFNCVT_X_F_W_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_MF2)
  .value("PseudoVFNCVT_X_F_W_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_MF2_MASK)
  .value("PseudoVFNCVT_X_F_W_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_MF4)
  .value("PseudoVFNCVT_X_F_W_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_MF4_MASK)
  .value("PseudoVFNCVT_X_F_W_MF8", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_MF8)
  .value("PseudoVFNCVT_X_F_W_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNCVT_X_F_W_MF8_MASK)
  .value("PseudoVFNMACC_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_M1_E16)
  .value("PseudoVFNMACC_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_M1_E16_MASK)
  .value("PseudoVFNMACC_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_M2_E16)
  .value("PseudoVFNMACC_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_M2_E16_MASK)
  .value("PseudoVFNMACC_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_M4_E16)
  .value("PseudoVFNMACC_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_M4_E16_MASK)
  .value("PseudoVFNMACC_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_M8_E16)
  .value("PseudoVFNMACC_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_M8_E16_MASK)
  .value("PseudoVFNMACC_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_MF2_E16)
  .value("PseudoVFNMACC_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_MF2_E16_MASK)
  .value("PseudoVFNMACC_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_MF4_E16)
  .value("PseudoVFNMACC_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR16_MF4_E16_MASK)
  .value("PseudoVFNMACC_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR32_M1_E32)
  .value("PseudoVFNMACC_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR32_M1_E32_MASK)
  .value("PseudoVFNMACC_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR32_M2_E32)
  .value("PseudoVFNMACC_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR32_M2_E32_MASK)
  .value("PseudoVFNMACC_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR32_M4_E32)
  .value("PseudoVFNMACC_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR32_M4_E32_MASK)
  .value("PseudoVFNMACC_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR32_M8_E32)
  .value("PseudoVFNMACC_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR32_M8_E32_MASK)
  .value("PseudoVFNMACC_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR32_MF2_E32)
  .value("PseudoVFNMACC_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR32_MF2_E32_MASK)
  .value("PseudoVFNMACC_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR64_M1_E64)
  .value("PseudoVFNMACC_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR64_M1_E64_MASK)
  .value("PseudoVFNMACC_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR64_M2_E64)
  .value("PseudoVFNMACC_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR64_M2_E64_MASK)
  .value("PseudoVFNMACC_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR64_M4_E64)
  .value("PseudoVFNMACC_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR64_M4_E64_MASK)
  .value("PseudoVFNMACC_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR64_M8_E64)
  .value("PseudoVFNMACC_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VFPR64_M8_E64_MASK)
  .value("PseudoVFNMACC_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M1_E16)
  .value("PseudoVFNMACC_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M1_E16_MASK)
  .value("PseudoVFNMACC_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M1_E32)
  .value("PseudoVFNMACC_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M1_E32_MASK)
  .value("PseudoVFNMACC_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M1_E64)
  .value("PseudoVFNMACC_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M1_E64_MASK)
  .value("PseudoVFNMACC_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M2_E16)
  .value("PseudoVFNMACC_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M2_E16_MASK)
  .value("PseudoVFNMACC_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M2_E32)
  .value("PseudoVFNMACC_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M2_E32_MASK)
  .value("PseudoVFNMACC_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M2_E64)
  .value("PseudoVFNMACC_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M2_E64_MASK)
  .value("PseudoVFNMACC_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M4_E16)
  .value("PseudoVFNMACC_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M4_E16_MASK)
  .value("PseudoVFNMACC_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M4_E32)
  .value("PseudoVFNMACC_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M4_E32_MASK)
  .value("PseudoVFNMACC_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M4_E64)
  .value("PseudoVFNMACC_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M4_E64_MASK)
  .value("PseudoVFNMACC_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M8_E16)
  .value("PseudoVFNMACC_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M8_E16_MASK)
  .value("PseudoVFNMACC_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M8_E32)
  .value("PseudoVFNMACC_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M8_E32_MASK)
  .value("PseudoVFNMACC_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M8_E64)
  .value("PseudoVFNMACC_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_M8_E64_MASK)
  .value("PseudoVFNMACC_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_MF2_E16)
  .value("PseudoVFNMACC_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_MF2_E16_MASK)
  .value("PseudoVFNMACC_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_MF2_E32)
  .value("PseudoVFNMACC_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_MF2_E32_MASK)
  .value("PseudoVFNMACC_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_MF4_E16)
  .value("PseudoVFNMACC_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMACC_VV_MF4_E16_MASK)
  .value("PseudoVFNMADD_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_M1_E16)
  .value("PseudoVFNMADD_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_M1_E16_MASK)
  .value("PseudoVFNMADD_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_M2_E16)
  .value("PseudoVFNMADD_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_M2_E16_MASK)
  .value("PseudoVFNMADD_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_M4_E16)
  .value("PseudoVFNMADD_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_M4_E16_MASK)
  .value("PseudoVFNMADD_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_M8_E16)
  .value("PseudoVFNMADD_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_M8_E16_MASK)
  .value("PseudoVFNMADD_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_MF2_E16)
  .value("PseudoVFNMADD_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_MF2_E16_MASK)
  .value("PseudoVFNMADD_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_MF4_E16)
  .value("PseudoVFNMADD_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR16_MF4_E16_MASK)
  .value("PseudoVFNMADD_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR32_M1_E32)
  .value("PseudoVFNMADD_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR32_M1_E32_MASK)
  .value("PseudoVFNMADD_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR32_M2_E32)
  .value("PseudoVFNMADD_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR32_M2_E32_MASK)
  .value("PseudoVFNMADD_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR32_M4_E32)
  .value("PseudoVFNMADD_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR32_M4_E32_MASK)
  .value("PseudoVFNMADD_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR32_M8_E32)
  .value("PseudoVFNMADD_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR32_M8_E32_MASK)
  .value("PseudoVFNMADD_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR32_MF2_E32)
  .value("PseudoVFNMADD_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR32_MF2_E32_MASK)
  .value("PseudoVFNMADD_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR64_M1_E64)
  .value("PseudoVFNMADD_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR64_M1_E64_MASK)
  .value("PseudoVFNMADD_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR64_M2_E64)
  .value("PseudoVFNMADD_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR64_M2_E64_MASK)
  .value("PseudoVFNMADD_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR64_M4_E64)
  .value("PseudoVFNMADD_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR64_M4_E64_MASK)
  .value("PseudoVFNMADD_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR64_M8_E64)
  .value("PseudoVFNMADD_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VFPR64_M8_E64_MASK)
  .value("PseudoVFNMADD_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M1_E16)
  .value("PseudoVFNMADD_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M1_E16_MASK)
  .value("PseudoVFNMADD_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M1_E32)
  .value("PseudoVFNMADD_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M1_E32_MASK)
  .value("PseudoVFNMADD_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M1_E64)
  .value("PseudoVFNMADD_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M1_E64_MASK)
  .value("PseudoVFNMADD_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M2_E16)
  .value("PseudoVFNMADD_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M2_E16_MASK)
  .value("PseudoVFNMADD_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M2_E32)
  .value("PseudoVFNMADD_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M2_E32_MASK)
  .value("PseudoVFNMADD_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M2_E64)
  .value("PseudoVFNMADD_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M2_E64_MASK)
  .value("PseudoVFNMADD_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M4_E16)
  .value("PseudoVFNMADD_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M4_E16_MASK)
  .value("PseudoVFNMADD_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M4_E32)
  .value("PseudoVFNMADD_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M4_E32_MASK)
  .value("PseudoVFNMADD_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M4_E64)
  .value("PseudoVFNMADD_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M4_E64_MASK)
  .value("PseudoVFNMADD_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M8_E16)
  .value("PseudoVFNMADD_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M8_E16_MASK)
  .value("PseudoVFNMADD_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M8_E32)
  .value("PseudoVFNMADD_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M8_E32_MASK)
  .value("PseudoVFNMADD_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M8_E64)
  .value("PseudoVFNMADD_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_M8_E64_MASK)
  .value("PseudoVFNMADD_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_MF2_E16)
  .value("PseudoVFNMADD_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_MF2_E16_MASK)
  .value("PseudoVFNMADD_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_MF2_E32)
  .value("PseudoVFNMADD_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_MF2_E32_MASK)
  .value("PseudoVFNMADD_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_MF4_E16)
  .value("PseudoVFNMADD_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMADD_VV_MF4_E16_MASK)
  .value("PseudoVFNMSAC_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_M1_E16)
  .value("PseudoVFNMSAC_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_M1_E16_MASK)
  .value("PseudoVFNMSAC_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_M2_E16)
  .value("PseudoVFNMSAC_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_M2_E16_MASK)
  .value("PseudoVFNMSAC_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_M4_E16)
  .value("PseudoVFNMSAC_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_M4_E16_MASK)
  .value("PseudoVFNMSAC_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_M8_E16)
  .value("PseudoVFNMSAC_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_M8_E16_MASK)
  .value("PseudoVFNMSAC_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_MF2_E16)
  .value("PseudoVFNMSAC_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_MF2_E16_MASK)
  .value("PseudoVFNMSAC_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_MF4_E16)
  .value("PseudoVFNMSAC_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR16_MF4_E16_MASK)
  .value("PseudoVFNMSAC_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR32_M1_E32)
  .value("PseudoVFNMSAC_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR32_M1_E32_MASK)
  .value("PseudoVFNMSAC_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR32_M2_E32)
  .value("PseudoVFNMSAC_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR32_M2_E32_MASK)
  .value("PseudoVFNMSAC_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR32_M4_E32)
  .value("PseudoVFNMSAC_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR32_M4_E32_MASK)
  .value("PseudoVFNMSAC_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR32_M8_E32)
  .value("PseudoVFNMSAC_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR32_M8_E32_MASK)
  .value("PseudoVFNMSAC_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR32_MF2_E32)
  .value("PseudoVFNMSAC_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR32_MF2_E32_MASK)
  .value("PseudoVFNMSAC_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR64_M1_E64)
  .value("PseudoVFNMSAC_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR64_M1_E64_MASK)
  .value("PseudoVFNMSAC_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR64_M2_E64)
  .value("PseudoVFNMSAC_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR64_M2_E64_MASK)
  .value("PseudoVFNMSAC_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR64_M4_E64)
  .value("PseudoVFNMSAC_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR64_M4_E64_MASK)
  .value("PseudoVFNMSAC_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR64_M8_E64)
  .value("PseudoVFNMSAC_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VFPR64_M8_E64_MASK)
  .value("PseudoVFNMSAC_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M1_E16)
  .value("PseudoVFNMSAC_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M1_E16_MASK)
  .value("PseudoVFNMSAC_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M1_E32)
  .value("PseudoVFNMSAC_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M1_E32_MASK)
  .value("PseudoVFNMSAC_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M1_E64)
  .value("PseudoVFNMSAC_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M1_E64_MASK)
  .value("PseudoVFNMSAC_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M2_E16)
  .value("PseudoVFNMSAC_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M2_E16_MASK)
  .value("PseudoVFNMSAC_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M2_E32)
  .value("PseudoVFNMSAC_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M2_E32_MASK)
  .value("PseudoVFNMSAC_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M2_E64)
  .value("PseudoVFNMSAC_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M2_E64_MASK)
  .value("PseudoVFNMSAC_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M4_E16)
  .value("PseudoVFNMSAC_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M4_E16_MASK)
  .value("PseudoVFNMSAC_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M4_E32)
  .value("PseudoVFNMSAC_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M4_E32_MASK)
  .value("PseudoVFNMSAC_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M4_E64)
  .value("PseudoVFNMSAC_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M4_E64_MASK)
  .value("PseudoVFNMSAC_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M8_E16)
  .value("PseudoVFNMSAC_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M8_E16_MASK)
  .value("PseudoVFNMSAC_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M8_E32)
  .value("PseudoVFNMSAC_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M8_E32_MASK)
  .value("PseudoVFNMSAC_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M8_E64)
  .value("PseudoVFNMSAC_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_M8_E64_MASK)
  .value("PseudoVFNMSAC_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_MF2_E16)
  .value("PseudoVFNMSAC_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_MF2_E16_MASK)
  .value("PseudoVFNMSAC_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_MF2_E32)
  .value("PseudoVFNMSAC_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_MF2_E32_MASK)
  .value("PseudoVFNMSAC_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_MF4_E16)
  .value("PseudoVFNMSAC_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSAC_VV_MF4_E16_MASK)
  .value("PseudoVFNMSUB_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_M1_E16)
  .value("PseudoVFNMSUB_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_M1_E16_MASK)
  .value("PseudoVFNMSUB_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_M2_E16)
  .value("PseudoVFNMSUB_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_M2_E16_MASK)
  .value("PseudoVFNMSUB_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_M4_E16)
  .value("PseudoVFNMSUB_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_M4_E16_MASK)
  .value("PseudoVFNMSUB_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_M8_E16)
  .value("PseudoVFNMSUB_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_M8_E16_MASK)
  .value("PseudoVFNMSUB_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_MF2_E16)
  .value("PseudoVFNMSUB_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_MF2_E16_MASK)
  .value("PseudoVFNMSUB_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_MF4_E16)
  .value("PseudoVFNMSUB_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR16_MF4_E16_MASK)
  .value("PseudoVFNMSUB_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR32_M1_E32)
  .value("PseudoVFNMSUB_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR32_M1_E32_MASK)
  .value("PseudoVFNMSUB_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR32_M2_E32)
  .value("PseudoVFNMSUB_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR32_M2_E32_MASK)
  .value("PseudoVFNMSUB_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR32_M4_E32)
  .value("PseudoVFNMSUB_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR32_M4_E32_MASK)
  .value("PseudoVFNMSUB_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR32_M8_E32)
  .value("PseudoVFNMSUB_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR32_M8_E32_MASK)
  .value("PseudoVFNMSUB_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR32_MF2_E32)
  .value("PseudoVFNMSUB_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR32_MF2_E32_MASK)
  .value("PseudoVFNMSUB_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR64_M1_E64)
  .value("PseudoVFNMSUB_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR64_M1_E64_MASK)
  .value("PseudoVFNMSUB_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR64_M2_E64)
  .value("PseudoVFNMSUB_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR64_M2_E64_MASK)
  .value("PseudoVFNMSUB_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR64_M4_E64)
  .value("PseudoVFNMSUB_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR64_M4_E64_MASK)
  .value("PseudoVFNMSUB_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR64_M8_E64)
  .value("PseudoVFNMSUB_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VFPR64_M8_E64_MASK)
  .value("PseudoVFNMSUB_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M1_E16)
  .value("PseudoVFNMSUB_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M1_E16_MASK)
  .value("PseudoVFNMSUB_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M1_E32)
  .value("PseudoVFNMSUB_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M1_E32_MASK)
  .value("PseudoVFNMSUB_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M1_E64)
  .value("PseudoVFNMSUB_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M1_E64_MASK)
  .value("PseudoVFNMSUB_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M2_E16)
  .value("PseudoVFNMSUB_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M2_E16_MASK)
  .value("PseudoVFNMSUB_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M2_E32)
  .value("PseudoVFNMSUB_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M2_E32_MASK)
  .value("PseudoVFNMSUB_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M2_E64)
  .value("PseudoVFNMSUB_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M2_E64_MASK)
  .value("PseudoVFNMSUB_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M4_E16)
  .value("PseudoVFNMSUB_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M4_E16_MASK)
  .value("PseudoVFNMSUB_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M4_E32)
  .value("PseudoVFNMSUB_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M4_E32_MASK)
  .value("PseudoVFNMSUB_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M4_E64)
  .value("PseudoVFNMSUB_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M4_E64_MASK)
  .value("PseudoVFNMSUB_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M8_E16)
  .value("PseudoVFNMSUB_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M8_E16_MASK)
  .value("PseudoVFNMSUB_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M8_E32)
  .value("PseudoVFNMSUB_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M8_E32_MASK)
  .value("PseudoVFNMSUB_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M8_E64)
  .value("PseudoVFNMSUB_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_M8_E64_MASK)
  .value("PseudoVFNMSUB_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_MF2_E16)
  .value("PseudoVFNMSUB_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_MF2_E16_MASK)
  .value("PseudoVFNMSUB_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_MF2_E32)
  .value("PseudoVFNMSUB_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_MF2_E32_MASK)
  .value("PseudoVFNMSUB_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_MF4_E16)
  .value("PseudoVFNMSUB_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFNMSUB_VV_MF4_E16_MASK)
  .value("PseudoVFRDIV_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_M1_E16)
  .value("PseudoVFRDIV_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_M1_E16_MASK)
  .value("PseudoVFRDIV_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_M2_E16)
  .value("PseudoVFRDIV_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_M2_E16_MASK)
  .value("PseudoVFRDIV_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_M4_E16)
  .value("PseudoVFRDIV_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_M4_E16_MASK)
  .value("PseudoVFRDIV_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_M8_E16)
  .value("PseudoVFRDIV_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_M8_E16_MASK)
  .value("PseudoVFRDIV_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_MF2_E16)
  .value("PseudoVFRDIV_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_MF2_E16_MASK)
  .value("PseudoVFRDIV_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_MF4_E16)
  .value("PseudoVFRDIV_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR16_MF4_E16_MASK)
  .value("PseudoVFRDIV_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR32_M1_E32)
  .value("PseudoVFRDIV_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR32_M1_E32_MASK)
  .value("PseudoVFRDIV_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR32_M2_E32)
  .value("PseudoVFRDIV_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR32_M2_E32_MASK)
  .value("PseudoVFRDIV_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR32_M4_E32)
  .value("PseudoVFRDIV_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR32_M4_E32_MASK)
  .value("PseudoVFRDIV_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR32_M8_E32)
  .value("PseudoVFRDIV_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR32_M8_E32_MASK)
  .value("PseudoVFRDIV_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR32_MF2_E32)
  .value("PseudoVFRDIV_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR32_MF2_E32_MASK)
  .value("PseudoVFRDIV_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR64_M1_E64)
  .value("PseudoVFRDIV_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR64_M1_E64_MASK)
  .value("PseudoVFRDIV_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR64_M2_E64);
  opcodes.value("PseudoVFRDIV_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR64_M2_E64_MASK)
  .value("PseudoVFRDIV_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR64_M4_E64)
  .value("PseudoVFRDIV_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR64_M4_E64_MASK)
  .value("PseudoVFRDIV_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR64_M8_E64)
  .value("PseudoVFRDIV_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRDIV_VFPR64_M8_E64_MASK)
  .value("PseudoVFREC7_V_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M1_E16)
  .value("PseudoVFREC7_V_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M1_E16_MASK)
  .value("PseudoVFREC7_V_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M1_E32)
  .value("PseudoVFREC7_V_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M1_E32_MASK)
  .value("PseudoVFREC7_V_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M1_E64)
  .value("PseudoVFREC7_V_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M1_E64_MASK)
  .value("PseudoVFREC7_V_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M2_E16)
  .value("PseudoVFREC7_V_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M2_E16_MASK)
  .value("PseudoVFREC7_V_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M2_E32)
  .value("PseudoVFREC7_V_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M2_E32_MASK)
  .value("PseudoVFREC7_V_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M2_E64)
  .value("PseudoVFREC7_V_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M2_E64_MASK)
  .value("PseudoVFREC7_V_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M4_E16)
  .value("PseudoVFREC7_V_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M4_E16_MASK)
  .value("PseudoVFREC7_V_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M4_E32)
  .value("PseudoVFREC7_V_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M4_E32_MASK)
  .value("PseudoVFREC7_V_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M4_E64)
  .value("PseudoVFREC7_V_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M4_E64_MASK)
  .value("PseudoVFREC7_V_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M8_E16)
  .value("PseudoVFREC7_V_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M8_E16_MASK)
  .value("PseudoVFREC7_V_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M8_E32)
  .value("PseudoVFREC7_V_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M8_E32_MASK)
  .value("PseudoVFREC7_V_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M8_E64)
  .value("PseudoVFREC7_V_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_M8_E64_MASK)
  .value("PseudoVFREC7_V_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_MF2_E16)
  .value("PseudoVFREC7_V_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_MF2_E16_MASK)
  .value("PseudoVFREC7_V_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_MF2_E32)
  .value("PseudoVFREC7_V_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_MF2_E32_MASK)
  .value("PseudoVFREC7_V_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_MF4_E16)
  .value("PseudoVFREC7_V_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREC7_V_MF4_E16_MASK)
  .value("PseudoVFREDMAX_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M1_E16)
  .value("PseudoVFREDMAX_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M1_E16_MASK)
  .value("PseudoVFREDMAX_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M1_E32)
  .value("PseudoVFREDMAX_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M1_E32_MASK)
  .value("PseudoVFREDMAX_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M1_E64)
  .value("PseudoVFREDMAX_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M1_E64_MASK)
  .value("PseudoVFREDMAX_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M2_E16)
  .value("PseudoVFREDMAX_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M2_E16_MASK)
  .value("PseudoVFREDMAX_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M2_E32)
  .value("PseudoVFREDMAX_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M2_E32_MASK)
  .value("PseudoVFREDMAX_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M2_E64)
  .value("PseudoVFREDMAX_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M2_E64_MASK)
  .value("PseudoVFREDMAX_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M4_E16)
  .value("PseudoVFREDMAX_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M4_E16_MASK)
  .value("PseudoVFREDMAX_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M4_E32)
  .value("PseudoVFREDMAX_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M4_E32_MASK)
  .value("PseudoVFREDMAX_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M4_E64)
  .value("PseudoVFREDMAX_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M4_E64_MASK)
  .value("PseudoVFREDMAX_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M8_E16)
  .value("PseudoVFREDMAX_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M8_E16_MASK)
  .value("PseudoVFREDMAX_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M8_E32)
  .value("PseudoVFREDMAX_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M8_E32_MASK)
  .value("PseudoVFREDMAX_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M8_E64)
  .value("PseudoVFREDMAX_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_M8_E64_MASK)
  .value("PseudoVFREDMAX_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_MF2_E16)
  .value("PseudoVFREDMAX_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_MF2_E16_MASK)
  .value("PseudoVFREDMAX_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_MF2_E32)
  .value("PseudoVFREDMAX_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_MF2_E32_MASK)
  .value("PseudoVFREDMAX_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_MF4_E16)
  .value("PseudoVFREDMAX_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMAX_VS_MF4_E16_MASK)
  .value("PseudoVFREDMIN_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M1_E16)
  .value("PseudoVFREDMIN_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M1_E16_MASK)
  .value("PseudoVFREDMIN_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M1_E32)
  .value("PseudoVFREDMIN_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M1_E32_MASK)
  .value("PseudoVFREDMIN_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M1_E64)
  .value("PseudoVFREDMIN_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M1_E64_MASK)
  .value("PseudoVFREDMIN_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M2_E16)
  .value("PseudoVFREDMIN_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M2_E16_MASK)
  .value("PseudoVFREDMIN_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M2_E32)
  .value("PseudoVFREDMIN_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M2_E32_MASK)
  .value("PseudoVFREDMIN_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M2_E64)
  .value("PseudoVFREDMIN_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M2_E64_MASK)
  .value("PseudoVFREDMIN_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M4_E16)
  .value("PseudoVFREDMIN_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M4_E16_MASK)
  .value("PseudoVFREDMIN_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M4_E32)
  .value("PseudoVFREDMIN_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M4_E32_MASK)
  .value("PseudoVFREDMIN_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M4_E64)
  .value("PseudoVFREDMIN_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M4_E64_MASK)
  .value("PseudoVFREDMIN_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M8_E16)
  .value("PseudoVFREDMIN_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M8_E16_MASK)
  .value("PseudoVFREDMIN_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M8_E32)
  .value("PseudoVFREDMIN_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M8_E32_MASK)
  .value("PseudoVFREDMIN_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M8_E64)
  .value("PseudoVFREDMIN_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_M8_E64_MASK)
  .value("PseudoVFREDMIN_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_MF2_E16)
  .value("PseudoVFREDMIN_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_MF2_E16_MASK)
  .value("PseudoVFREDMIN_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_MF2_E32)
  .value("PseudoVFREDMIN_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_MF2_E32_MASK)
  .value("PseudoVFREDMIN_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_MF4_E16)
  .value("PseudoVFREDMIN_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDMIN_VS_MF4_E16_MASK)
  .value("PseudoVFREDOSUM_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M1_E16)
  .value("PseudoVFREDOSUM_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M1_E16_MASK)
  .value("PseudoVFREDOSUM_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M1_E32)
  .value("PseudoVFREDOSUM_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M1_E32_MASK)
  .value("PseudoVFREDOSUM_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M1_E64)
  .value("PseudoVFREDOSUM_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M1_E64_MASK)
  .value("PseudoVFREDOSUM_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M2_E16)
  .value("PseudoVFREDOSUM_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M2_E16_MASK)
  .value("PseudoVFREDOSUM_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M2_E32)
  .value("PseudoVFREDOSUM_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M2_E32_MASK)
  .value("PseudoVFREDOSUM_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M2_E64)
  .value("PseudoVFREDOSUM_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M2_E64_MASK)
  .value("PseudoVFREDOSUM_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M4_E16)
  .value("PseudoVFREDOSUM_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M4_E16_MASK)
  .value("PseudoVFREDOSUM_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M4_E32)
  .value("PseudoVFREDOSUM_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M4_E32_MASK)
  .value("PseudoVFREDOSUM_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M4_E64)
  .value("PseudoVFREDOSUM_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M4_E64_MASK)
  .value("PseudoVFREDOSUM_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M8_E16)
  .value("PseudoVFREDOSUM_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M8_E16_MASK)
  .value("PseudoVFREDOSUM_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M8_E32)
  .value("PseudoVFREDOSUM_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M8_E32_MASK)
  .value("PseudoVFREDOSUM_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M8_E64)
  .value("PseudoVFREDOSUM_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_M8_E64_MASK)
  .value("PseudoVFREDOSUM_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_MF2_E16)
  .value("PseudoVFREDOSUM_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_MF2_E16_MASK)
  .value("PseudoVFREDOSUM_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_MF2_E32)
  .value("PseudoVFREDOSUM_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_MF2_E32_MASK)
  .value("PseudoVFREDOSUM_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_MF4_E16)
  .value("PseudoVFREDOSUM_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDOSUM_VS_MF4_E16_MASK)
  .value("PseudoVFREDUSUM_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M1_E16)
  .value("PseudoVFREDUSUM_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M1_E16_MASK)
  .value("PseudoVFREDUSUM_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M1_E32)
  .value("PseudoVFREDUSUM_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M1_E32_MASK)
  .value("PseudoVFREDUSUM_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M1_E64)
  .value("PseudoVFREDUSUM_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M1_E64_MASK)
  .value("PseudoVFREDUSUM_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M2_E16)
  .value("PseudoVFREDUSUM_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M2_E16_MASK)
  .value("PseudoVFREDUSUM_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M2_E32)
  .value("PseudoVFREDUSUM_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M2_E32_MASK)
  .value("PseudoVFREDUSUM_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M2_E64)
  .value("PseudoVFREDUSUM_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M2_E64_MASK)
  .value("PseudoVFREDUSUM_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M4_E16)
  .value("PseudoVFREDUSUM_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M4_E16_MASK)
  .value("PseudoVFREDUSUM_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M4_E32)
  .value("PseudoVFREDUSUM_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M4_E32_MASK)
  .value("PseudoVFREDUSUM_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M4_E64)
  .value("PseudoVFREDUSUM_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M4_E64_MASK)
  .value("PseudoVFREDUSUM_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M8_E16)
  .value("PseudoVFREDUSUM_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M8_E16_MASK)
  .value("PseudoVFREDUSUM_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M8_E32)
  .value("PseudoVFREDUSUM_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M8_E32_MASK)
  .value("PseudoVFREDUSUM_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M8_E64)
  .value("PseudoVFREDUSUM_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_M8_E64_MASK)
  .value("PseudoVFREDUSUM_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_MF2_E16)
  .value("PseudoVFREDUSUM_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_MF2_E16_MASK)
  .value("PseudoVFREDUSUM_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_MF2_E32)
  .value("PseudoVFREDUSUM_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_MF2_E32_MASK)
  .value("PseudoVFREDUSUM_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_MF4_E16)
  .value("PseudoVFREDUSUM_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFREDUSUM_VS_MF4_E16_MASK)
  .value("PseudoVFROUND_NOEXCEPT_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFROUND_NOEXCEPT_V_M1_MASK)
  .value("PseudoVFROUND_NOEXCEPT_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFROUND_NOEXCEPT_V_M2_MASK)
  .value("PseudoVFROUND_NOEXCEPT_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFROUND_NOEXCEPT_V_M4_MASK)
  .value("PseudoVFROUND_NOEXCEPT_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFROUND_NOEXCEPT_V_M8_MASK)
  .value("PseudoVFROUND_NOEXCEPT_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFROUND_NOEXCEPT_V_MF2_MASK)
  .value("PseudoVFROUND_NOEXCEPT_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFROUND_NOEXCEPT_V_MF4_MASK)
  .value("PseudoVFRSQRT7_V_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M1_E16)
  .value("PseudoVFRSQRT7_V_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M1_E16_MASK)
  .value("PseudoVFRSQRT7_V_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M1_E32)
  .value("PseudoVFRSQRT7_V_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M1_E32_MASK)
  .value("PseudoVFRSQRT7_V_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M1_E64)
  .value("PseudoVFRSQRT7_V_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M1_E64_MASK)
  .value("PseudoVFRSQRT7_V_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M2_E16)
  .value("PseudoVFRSQRT7_V_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M2_E16_MASK)
  .value("PseudoVFRSQRT7_V_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M2_E32)
  .value("PseudoVFRSQRT7_V_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M2_E32_MASK)
  .value("PseudoVFRSQRT7_V_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M2_E64)
  .value("PseudoVFRSQRT7_V_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M2_E64_MASK)
  .value("PseudoVFRSQRT7_V_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M4_E16)
  .value("PseudoVFRSQRT7_V_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M4_E16_MASK)
  .value("PseudoVFRSQRT7_V_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M4_E32)
  .value("PseudoVFRSQRT7_V_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M4_E32_MASK)
  .value("PseudoVFRSQRT7_V_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M4_E64)
  .value("PseudoVFRSQRT7_V_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M4_E64_MASK)
  .value("PseudoVFRSQRT7_V_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M8_E16)
  .value("PseudoVFRSQRT7_V_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M8_E16_MASK)
  .value("PseudoVFRSQRT7_V_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M8_E32)
  .value("PseudoVFRSQRT7_V_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M8_E32_MASK)
  .value("PseudoVFRSQRT7_V_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M8_E64)
  .value("PseudoVFRSQRT7_V_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_M8_E64_MASK)
  .value("PseudoVFRSQRT7_V_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_MF2_E16)
  .value("PseudoVFRSQRT7_V_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_MF2_E16_MASK)
  .value("PseudoVFRSQRT7_V_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_MF2_E32)
  .value("PseudoVFRSQRT7_V_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_MF2_E32_MASK)
  .value("PseudoVFRSQRT7_V_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_MF4_E16)
  .value("PseudoVFRSQRT7_V_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSQRT7_V_MF4_E16_MASK)
  .value("PseudoVFRSUB_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_M1_E16)
  .value("PseudoVFRSUB_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_M1_E16_MASK)
  .value("PseudoVFRSUB_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_M2_E16)
  .value("PseudoVFRSUB_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_M2_E16_MASK)
  .value("PseudoVFRSUB_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_M4_E16)
  .value("PseudoVFRSUB_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_M4_E16_MASK)
  .value("PseudoVFRSUB_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_M8_E16)
  .value("PseudoVFRSUB_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_M8_E16_MASK)
  .value("PseudoVFRSUB_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_MF2_E16)
  .value("PseudoVFRSUB_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_MF2_E16_MASK)
  .value("PseudoVFRSUB_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_MF4_E16)
  .value("PseudoVFRSUB_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR16_MF4_E16_MASK)
  .value("PseudoVFRSUB_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR32_M1_E32)
  .value("PseudoVFRSUB_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR32_M1_E32_MASK)
  .value("PseudoVFRSUB_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR32_M2_E32)
  .value("PseudoVFRSUB_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR32_M2_E32_MASK)
  .value("PseudoVFRSUB_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR32_M4_E32)
  .value("PseudoVFRSUB_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR32_M4_E32_MASK)
  .value("PseudoVFRSUB_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR32_M8_E32)
  .value("PseudoVFRSUB_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR32_M8_E32_MASK)
  .value("PseudoVFRSUB_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR32_MF2_E32)
  .value("PseudoVFRSUB_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR32_MF2_E32_MASK)
  .value("PseudoVFRSUB_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR64_M1_E64)
  .value("PseudoVFRSUB_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR64_M1_E64_MASK)
  .value("PseudoVFRSUB_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR64_M2_E64)
  .value("PseudoVFRSUB_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR64_M2_E64_MASK)
  .value("PseudoVFRSUB_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR64_M4_E64)
  .value("PseudoVFRSUB_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR64_M4_E64_MASK)
  .value("PseudoVFRSUB_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR64_M8_E64)
  .value("PseudoVFRSUB_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFRSUB_VFPR64_M8_E64_MASK)
  .value("PseudoVFSGNJN_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_M1_E16)
  .value("PseudoVFSGNJN_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_M1_E16_MASK)
  .value("PseudoVFSGNJN_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_M2_E16)
  .value("PseudoVFSGNJN_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_M2_E16_MASK)
  .value("PseudoVFSGNJN_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_M4_E16)
  .value("PseudoVFSGNJN_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_M4_E16_MASK)
  .value("PseudoVFSGNJN_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_M8_E16)
  .value("PseudoVFSGNJN_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_M8_E16_MASK)
  .value("PseudoVFSGNJN_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_MF2_E16)
  .value("PseudoVFSGNJN_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_MF2_E16_MASK)
  .value("PseudoVFSGNJN_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_MF4_E16)
  .value("PseudoVFSGNJN_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR16_MF4_E16_MASK)
  .value("PseudoVFSGNJN_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR32_M1_E32)
  .value("PseudoVFSGNJN_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR32_M1_E32_MASK)
  .value("PseudoVFSGNJN_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR32_M2_E32)
  .value("PseudoVFSGNJN_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR32_M2_E32_MASK)
  .value("PseudoVFSGNJN_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR32_M4_E32)
  .value("PseudoVFSGNJN_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR32_M4_E32_MASK)
  .value("PseudoVFSGNJN_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR32_M8_E32)
  .value("PseudoVFSGNJN_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR32_M8_E32_MASK)
  .value("PseudoVFSGNJN_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR32_MF2_E32)
  .value("PseudoVFSGNJN_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR32_MF2_E32_MASK)
  .value("PseudoVFSGNJN_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR64_M1_E64)
  .value("PseudoVFSGNJN_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR64_M1_E64_MASK)
  .value("PseudoVFSGNJN_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR64_M2_E64)
  .value("PseudoVFSGNJN_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR64_M2_E64_MASK)
  .value("PseudoVFSGNJN_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR64_M4_E64)
  .value("PseudoVFSGNJN_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR64_M4_E64_MASK)
  .value("PseudoVFSGNJN_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR64_M8_E64)
  .value("PseudoVFSGNJN_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VFPR64_M8_E64_MASK)
  .value("PseudoVFSGNJN_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M1_E16)
  .value("PseudoVFSGNJN_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M1_E16_MASK)
  .value("PseudoVFSGNJN_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M1_E32)
  .value("PseudoVFSGNJN_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M1_E32_MASK)
  .value("PseudoVFSGNJN_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M1_E64)
  .value("PseudoVFSGNJN_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M1_E64_MASK)
  .value("PseudoVFSGNJN_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M2_E16)
  .value("PseudoVFSGNJN_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M2_E16_MASK)
  .value("PseudoVFSGNJN_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M2_E32)
  .value("PseudoVFSGNJN_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M2_E32_MASK)
  .value("PseudoVFSGNJN_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M2_E64)
  .value("PseudoVFSGNJN_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M2_E64_MASK)
  .value("PseudoVFSGNJN_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M4_E16)
  .value("PseudoVFSGNJN_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M4_E16_MASK)
  .value("PseudoVFSGNJN_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M4_E32)
  .value("PseudoVFSGNJN_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M4_E32_MASK)
  .value("PseudoVFSGNJN_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M4_E64)
  .value("PseudoVFSGNJN_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M4_E64_MASK)
  .value("PseudoVFSGNJN_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M8_E16)
  .value("PseudoVFSGNJN_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M8_E16_MASK)
  .value("PseudoVFSGNJN_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M8_E32)
  .value("PseudoVFSGNJN_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M8_E32_MASK)
  .value("PseudoVFSGNJN_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M8_E64)
  .value("PseudoVFSGNJN_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_M8_E64_MASK)
  .value("PseudoVFSGNJN_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_MF2_E16)
  .value("PseudoVFSGNJN_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_MF2_E16_MASK)
  .value("PseudoVFSGNJN_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_MF2_E32)
  .value("PseudoVFSGNJN_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_MF2_E32_MASK)
  .value("PseudoVFSGNJN_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_MF4_E16)
  .value("PseudoVFSGNJN_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJN_VV_MF4_E16_MASK)
  .value("PseudoVFSGNJX_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_M1_E16)
  .value("PseudoVFSGNJX_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_M1_E16_MASK)
  .value("PseudoVFSGNJX_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_M2_E16)
  .value("PseudoVFSGNJX_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_M2_E16_MASK)
  .value("PseudoVFSGNJX_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_M4_E16)
  .value("PseudoVFSGNJX_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_M4_E16_MASK)
  .value("PseudoVFSGNJX_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_M8_E16)
  .value("PseudoVFSGNJX_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_M8_E16_MASK)
  .value("PseudoVFSGNJX_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_MF2_E16)
  .value("PseudoVFSGNJX_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_MF2_E16_MASK)
  .value("PseudoVFSGNJX_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_MF4_E16)
  .value("PseudoVFSGNJX_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR16_MF4_E16_MASK)
  .value("PseudoVFSGNJX_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR32_M1_E32)
  .value("PseudoVFSGNJX_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR32_M1_E32_MASK)
  .value("PseudoVFSGNJX_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR32_M2_E32)
  .value("PseudoVFSGNJX_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR32_M2_E32_MASK)
  .value("PseudoVFSGNJX_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR32_M4_E32)
  .value("PseudoVFSGNJX_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR32_M4_E32_MASK)
  .value("PseudoVFSGNJX_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR32_M8_E32);
  opcodes.value("PseudoVFSGNJX_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR32_M8_E32_MASK)
  .value("PseudoVFSGNJX_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR32_MF2_E32)
  .value("PseudoVFSGNJX_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR32_MF2_E32_MASK)
  .value("PseudoVFSGNJX_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR64_M1_E64)
  .value("PseudoVFSGNJX_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR64_M1_E64_MASK)
  .value("PseudoVFSGNJX_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR64_M2_E64)
  .value("PseudoVFSGNJX_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR64_M2_E64_MASK)
  .value("PseudoVFSGNJX_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR64_M4_E64)
  .value("PseudoVFSGNJX_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR64_M4_E64_MASK)
  .value("PseudoVFSGNJX_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR64_M8_E64)
  .value("PseudoVFSGNJX_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VFPR64_M8_E64_MASK)
  .value("PseudoVFSGNJX_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M1_E16)
  .value("PseudoVFSGNJX_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M1_E16_MASK)
  .value("PseudoVFSGNJX_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M1_E32)
  .value("PseudoVFSGNJX_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M1_E32_MASK)
  .value("PseudoVFSGNJX_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M1_E64)
  .value("PseudoVFSGNJX_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M1_E64_MASK)
  .value("PseudoVFSGNJX_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M2_E16)
  .value("PseudoVFSGNJX_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M2_E16_MASK)
  .value("PseudoVFSGNJX_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M2_E32)
  .value("PseudoVFSGNJX_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M2_E32_MASK)
  .value("PseudoVFSGNJX_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M2_E64)
  .value("PseudoVFSGNJX_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M2_E64_MASK)
  .value("PseudoVFSGNJX_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M4_E16)
  .value("PseudoVFSGNJX_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M4_E16_MASK)
  .value("PseudoVFSGNJX_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M4_E32)
  .value("PseudoVFSGNJX_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M4_E32_MASK)
  .value("PseudoVFSGNJX_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M4_E64)
  .value("PseudoVFSGNJX_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M4_E64_MASK)
  .value("PseudoVFSGNJX_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M8_E16)
  .value("PseudoVFSGNJX_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M8_E16_MASK)
  .value("PseudoVFSGNJX_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M8_E32)
  .value("PseudoVFSGNJX_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M8_E32_MASK)
  .value("PseudoVFSGNJX_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M8_E64)
  .value("PseudoVFSGNJX_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_M8_E64_MASK)
  .value("PseudoVFSGNJX_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_MF2_E16)
  .value("PseudoVFSGNJX_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_MF2_E16_MASK)
  .value("PseudoVFSGNJX_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_MF2_E32)
  .value("PseudoVFSGNJX_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_MF2_E32_MASK)
  .value("PseudoVFSGNJX_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_MF4_E16)
  .value("PseudoVFSGNJX_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJX_VV_MF4_E16_MASK)
  .value("PseudoVFSGNJ_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_M1_E16)
  .value("PseudoVFSGNJ_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_M1_E16_MASK)
  .value("PseudoVFSGNJ_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_M2_E16)
  .value("PseudoVFSGNJ_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_M2_E16_MASK)
  .value("PseudoVFSGNJ_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_M4_E16)
  .value("PseudoVFSGNJ_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_M4_E16_MASK)
  .value("PseudoVFSGNJ_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_M8_E16)
  .value("PseudoVFSGNJ_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_M8_E16_MASK)
  .value("PseudoVFSGNJ_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_MF2_E16)
  .value("PseudoVFSGNJ_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_MF2_E16_MASK)
  .value("PseudoVFSGNJ_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_MF4_E16)
  .value("PseudoVFSGNJ_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR16_MF4_E16_MASK)
  .value("PseudoVFSGNJ_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR32_M1_E32)
  .value("PseudoVFSGNJ_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR32_M1_E32_MASK)
  .value("PseudoVFSGNJ_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR32_M2_E32)
  .value("PseudoVFSGNJ_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR32_M2_E32_MASK)
  .value("PseudoVFSGNJ_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR32_M4_E32)
  .value("PseudoVFSGNJ_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR32_M4_E32_MASK)
  .value("PseudoVFSGNJ_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR32_M8_E32)
  .value("PseudoVFSGNJ_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR32_M8_E32_MASK)
  .value("PseudoVFSGNJ_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR32_MF2_E32)
  .value("PseudoVFSGNJ_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR32_MF2_E32_MASK)
  .value("PseudoVFSGNJ_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR64_M1_E64)
  .value("PseudoVFSGNJ_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR64_M1_E64_MASK)
  .value("PseudoVFSGNJ_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR64_M2_E64)
  .value("PseudoVFSGNJ_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR64_M2_E64_MASK)
  .value("PseudoVFSGNJ_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR64_M4_E64)
  .value("PseudoVFSGNJ_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR64_M4_E64_MASK)
  .value("PseudoVFSGNJ_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR64_M8_E64)
  .value("PseudoVFSGNJ_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VFPR64_M8_E64_MASK)
  .value("PseudoVFSGNJ_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M1_E16)
  .value("PseudoVFSGNJ_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M1_E16_MASK)
  .value("PseudoVFSGNJ_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M1_E32)
  .value("PseudoVFSGNJ_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M1_E32_MASK)
  .value("PseudoVFSGNJ_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M1_E64)
  .value("PseudoVFSGNJ_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M1_E64_MASK)
  .value("PseudoVFSGNJ_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M2_E16)
  .value("PseudoVFSGNJ_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M2_E16_MASK)
  .value("PseudoVFSGNJ_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M2_E32)
  .value("PseudoVFSGNJ_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M2_E32_MASK)
  .value("PseudoVFSGNJ_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M2_E64)
  .value("PseudoVFSGNJ_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M2_E64_MASK)
  .value("PseudoVFSGNJ_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M4_E16)
  .value("PseudoVFSGNJ_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M4_E16_MASK)
  .value("PseudoVFSGNJ_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M4_E32)
  .value("PseudoVFSGNJ_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M4_E32_MASK)
  .value("PseudoVFSGNJ_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M4_E64)
  .value("PseudoVFSGNJ_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M4_E64_MASK)
  .value("PseudoVFSGNJ_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M8_E16)
  .value("PseudoVFSGNJ_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M8_E16_MASK)
  .value("PseudoVFSGNJ_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M8_E32)
  .value("PseudoVFSGNJ_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M8_E32_MASK)
  .value("PseudoVFSGNJ_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M8_E64)
  .value("PseudoVFSGNJ_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_M8_E64_MASK)
  .value("PseudoVFSGNJ_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_MF2_E16)
  .value("PseudoVFSGNJ_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_MF2_E16_MASK)
  .value("PseudoVFSGNJ_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_MF2_E32)
  .value("PseudoVFSGNJ_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_MF2_E32_MASK)
  .value("PseudoVFSGNJ_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_MF4_E16)
  .value("PseudoVFSGNJ_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSGNJ_VV_MF4_E16_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_M1)
  .value("PseudoVFSLIDE1DOWN_VFPR16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_M1_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_M2)
  .value("PseudoVFSLIDE1DOWN_VFPR16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_M2_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_M4)
  .value("PseudoVFSLIDE1DOWN_VFPR16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_M4_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_M8)
  .value("PseudoVFSLIDE1DOWN_VFPR16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_M8_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_MF2)
  .value("PseudoVFSLIDE1DOWN_VFPR16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_MF2_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_MF4)
  .value("PseudoVFSLIDE1DOWN_VFPR16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR16_MF4_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR32_M1", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR32_M1)
  .value("PseudoVFSLIDE1DOWN_VFPR32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR32_M1_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR32_M2", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR32_M2)
  .value("PseudoVFSLIDE1DOWN_VFPR32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR32_M2_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR32_M4", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR32_M4)
  .value("PseudoVFSLIDE1DOWN_VFPR32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR32_M4_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR32_M8", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR32_M8)
  .value("PseudoVFSLIDE1DOWN_VFPR32_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR32_M8_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR32_MF2)
  .value("PseudoVFSLIDE1DOWN_VFPR32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR32_MF2_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR64_M1", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR64_M1)
  .value("PseudoVFSLIDE1DOWN_VFPR64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR64_M1_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR64_M2", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR64_M2)
  .value("PseudoVFSLIDE1DOWN_VFPR64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR64_M2_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR64_M4", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR64_M4)
  .value("PseudoVFSLIDE1DOWN_VFPR64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR64_M4_MASK)
  .value("PseudoVFSLIDE1DOWN_VFPR64_M8", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR64_M8)
  .value("PseudoVFSLIDE1DOWN_VFPR64_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1DOWN_VFPR64_M8_MASK)
  .value("PseudoVFSLIDE1UP_VFPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_M1)
  .value("PseudoVFSLIDE1UP_VFPR16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_M1_MASK)
  .value("PseudoVFSLIDE1UP_VFPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_M2)
  .value("PseudoVFSLIDE1UP_VFPR16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_M2_MASK)
  .value("PseudoVFSLIDE1UP_VFPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_M4)
  .value("PseudoVFSLIDE1UP_VFPR16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_M4_MASK)
  .value("PseudoVFSLIDE1UP_VFPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_M8)
  .value("PseudoVFSLIDE1UP_VFPR16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_M8_MASK)
  .value("PseudoVFSLIDE1UP_VFPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_MF2)
  .value("PseudoVFSLIDE1UP_VFPR16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_MF2_MASK)
  .value("PseudoVFSLIDE1UP_VFPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_MF4)
  .value("PseudoVFSLIDE1UP_VFPR16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR16_MF4_MASK)
  .value("PseudoVFSLIDE1UP_VFPR32_M1", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR32_M1)
  .value("PseudoVFSLIDE1UP_VFPR32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR32_M1_MASK)
  .value("PseudoVFSLIDE1UP_VFPR32_M2", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR32_M2)
  .value("PseudoVFSLIDE1UP_VFPR32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR32_M2_MASK)
  .value("PseudoVFSLIDE1UP_VFPR32_M4", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR32_M4)
  .value("PseudoVFSLIDE1UP_VFPR32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR32_M4_MASK)
  .value("PseudoVFSLIDE1UP_VFPR32_M8", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR32_M8)
  .value("PseudoVFSLIDE1UP_VFPR32_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR32_M8_MASK)
  .value("PseudoVFSLIDE1UP_VFPR32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR32_MF2)
  .value("PseudoVFSLIDE1UP_VFPR32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR32_MF2_MASK)
  .value("PseudoVFSLIDE1UP_VFPR64_M1", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR64_M1)
  .value("PseudoVFSLIDE1UP_VFPR64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR64_M1_MASK)
  .value("PseudoVFSLIDE1UP_VFPR64_M2", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR64_M2)
  .value("PseudoVFSLIDE1UP_VFPR64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR64_M2_MASK)
  .value("PseudoVFSLIDE1UP_VFPR64_M4", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR64_M4)
  .value("PseudoVFSLIDE1UP_VFPR64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR64_M4_MASK)
  .value("PseudoVFSLIDE1UP_VFPR64_M8", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR64_M8)
  .value("PseudoVFSLIDE1UP_VFPR64_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSLIDE1UP_VFPR64_M8_MASK)
  .value("PseudoVFSQRT_V_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M1_E16)
  .value("PseudoVFSQRT_V_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M1_E16_MASK)
  .value("PseudoVFSQRT_V_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M1_E32)
  .value("PseudoVFSQRT_V_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M1_E32_MASK)
  .value("PseudoVFSQRT_V_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M1_E64)
  .value("PseudoVFSQRT_V_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M1_E64_MASK)
  .value("PseudoVFSQRT_V_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M2_E16)
  .value("PseudoVFSQRT_V_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M2_E16_MASK)
  .value("PseudoVFSQRT_V_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M2_E32)
  .value("PseudoVFSQRT_V_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M2_E32_MASK)
  .value("PseudoVFSQRT_V_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M2_E64)
  .value("PseudoVFSQRT_V_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M2_E64_MASK)
  .value("PseudoVFSQRT_V_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M4_E16)
  .value("PseudoVFSQRT_V_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M4_E16_MASK)
  .value("PseudoVFSQRT_V_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M4_E32)
  .value("PseudoVFSQRT_V_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M4_E32_MASK)
  .value("PseudoVFSQRT_V_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M4_E64)
  .value("PseudoVFSQRT_V_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M4_E64_MASK)
  .value("PseudoVFSQRT_V_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M8_E16)
  .value("PseudoVFSQRT_V_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M8_E16_MASK)
  .value("PseudoVFSQRT_V_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M8_E32)
  .value("PseudoVFSQRT_V_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M8_E32_MASK)
  .value("PseudoVFSQRT_V_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M8_E64)
  .value("PseudoVFSQRT_V_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_M8_E64_MASK)
  .value("PseudoVFSQRT_V_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_MF2_E16)
  .value("PseudoVFSQRT_V_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_MF2_E16_MASK)
  .value("PseudoVFSQRT_V_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_MF2_E32)
  .value("PseudoVFSQRT_V_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_MF2_E32_MASK)
  .value("PseudoVFSQRT_V_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_MF4_E16)
  .value("PseudoVFSQRT_V_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSQRT_V_MF4_E16_MASK)
  .value("PseudoVFSUB_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_M1_E16)
  .value("PseudoVFSUB_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_M1_E16_MASK)
  .value("PseudoVFSUB_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_M2_E16)
  .value("PseudoVFSUB_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_M2_E16_MASK)
  .value("PseudoVFSUB_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_M4_E16)
  .value("PseudoVFSUB_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_M4_E16_MASK)
  .value("PseudoVFSUB_VFPR16_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_M8_E16)
  .value("PseudoVFSUB_VFPR16_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_M8_E16_MASK)
  .value("PseudoVFSUB_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_MF2_E16)
  .value("PseudoVFSUB_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_MF2_E16_MASK)
  .value("PseudoVFSUB_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_MF4_E16)
  .value("PseudoVFSUB_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR16_MF4_E16_MASK)
  .value("PseudoVFSUB_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR32_M1_E32)
  .value("PseudoVFSUB_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR32_M1_E32_MASK)
  .value("PseudoVFSUB_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR32_M2_E32)
  .value("PseudoVFSUB_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR32_M2_E32_MASK)
  .value("PseudoVFSUB_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR32_M4_E32)
  .value("PseudoVFSUB_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR32_M4_E32_MASK)
  .value("PseudoVFSUB_VFPR32_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR32_M8_E32)
  .value("PseudoVFSUB_VFPR32_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR32_M8_E32_MASK)
  .value("PseudoVFSUB_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR32_MF2_E32)
  .value("PseudoVFSUB_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR32_MF2_E32_MASK)
  .value("PseudoVFSUB_VFPR64_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR64_M1_E64)
  .value("PseudoVFSUB_VFPR64_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR64_M1_E64_MASK)
  .value("PseudoVFSUB_VFPR64_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR64_M2_E64)
  .value("PseudoVFSUB_VFPR64_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR64_M2_E64_MASK)
  .value("PseudoVFSUB_VFPR64_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR64_M4_E64)
  .value("PseudoVFSUB_VFPR64_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR64_M4_E64_MASK)
  .value("PseudoVFSUB_VFPR64_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR64_M8_E64)
  .value("PseudoVFSUB_VFPR64_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VFPR64_M8_E64_MASK)
  .value("PseudoVFSUB_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M1_E16)
  .value("PseudoVFSUB_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M1_E16_MASK)
  .value("PseudoVFSUB_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M1_E32)
  .value("PseudoVFSUB_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M1_E32_MASK)
  .value("PseudoVFSUB_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M1_E64)
  .value("PseudoVFSUB_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M1_E64_MASK)
  .value("PseudoVFSUB_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M2_E16)
  .value("PseudoVFSUB_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M2_E16_MASK)
  .value("PseudoVFSUB_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M2_E32)
  .value("PseudoVFSUB_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M2_E32_MASK)
  .value("PseudoVFSUB_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M2_E64)
  .value("PseudoVFSUB_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M2_E64_MASK)
  .value("PseudoVFSUB_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M4_E16)
  .value("PseudoVFSUB_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M4_E16_MASK)
  .value("PseudoVFSUB_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M4_E32)
  .value("PseudoVFSUB_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M4_E32_MASK)
  .value("PseudoVFSUB_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M4_E64)
  .value("PseudoVFSUB_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M4_E64_MASK)
  .value("PseudoVFSUB_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M8_E16)
  .value("PseudoVFSUB_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M8_E16_MASK)
  .value("PseudoVFSUB_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M8_E32)
  .value("PseudoVFSUB_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M8_E32_MASK)
  .value("PseudoVFSUB_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M8_E64)
  .value("PseudoVFSUB_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_M8_E64_MASK)
  .value("PseudoVFSUB_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_MF2_E16)
  .value("PseudoVFSUB_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_MF2_E16_MASK)
  .value("PseudoVFSUB_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_MF2_E32)
  .value("PseudoVFSUB_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_MF2_E32_MASK)
  .value("PseudoVFSUB_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_MF4_E16)
  .value("PseudoVFSUB_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFSUB_VV_MF4_E16_MASK)
  .value("PseudoVFWADD_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR16_M1_E16)
  .value("PseudoVFWADD_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR16_M1_E16_MASK)
  .value("PseudoVFWADD_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR16_M2_E16)
  .value("PseudoVFWADD_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR16_M2_E16_MASK)
  .value("PseudoVFWADD_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR16_M4_E16)
  .value("PseudoVFWADD_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR16_M4_E16_MASK)
  .value("PseudoVFWADD_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR16_MF2_E16)
  .value("PseudoVFWADD_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR16_MF2_E16_MASK)
  .value("PseudoVFWADD_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR16_MF4_E16)
  .value("PseudoVFWADD_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR16_MF4_E16_MASK)
  .value("PseudoVFWADD_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR32_M1_E32)
  .value("PseudoVFWADD_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR32_M1_E32_MASK)
  .value("PseudoVFWADD_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR32_M2_E32)
  .value("PseudoVFWADD_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR32_M2_E32_MASK)
  .value("PseudoVFWADD_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR32_M4_E32)
  .value("PseudoVFWADD_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR32_M4_E32_MASK)
  .value("PseudoVFWADD_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR32_MF2_E32)
  .value("PseudoVFWADD_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VFPR32_MF2_E32_MASK)
  .value("PseudoVFWADD_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M1_E16)
  .value("PseudoVFWADD_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M1_E16_MASK)
  .value("PseudoVFWADD_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M1_E32)
  .value("PseudoVFWADD_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M1_E32_MASK)
  .value("PseudoVFWADD_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M2_E16)
  .value("PseudoVFWADD_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M2_E16_MASK)
  .value("PseudoVFWADD_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M2_E32)
  .value("PseudoVFWADD_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M2_E32_MASK)
  .value("PseudoVFWADD_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M4_E16)
  .value("PseudoVFWADD_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M4_E16_MASK)
  .value("PseudoVFWADD_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M4_E32)
  .value("PseudoVFWADD_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_M4_E32_MASK)
  .value("PseudoVFWADD_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_MF2_E16)
  .value("PseudoVFWADD_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_MF2_E16_MASK)
  .value("PseudoVFWADD_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_MF2_E32)
  .value("PseudoVFWADD_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_MF2_E32_MASK)
  .value("PseudoVFWADD_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_MF4_E16)
  .value("PseudoVFWADD_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_VV_MF4_E16_MASK)
  .value("PseudoVFWADD_WFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR16_M1_E16)
  .value("PseudoVFWADD_WFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR16_M1_E16_MASK)
  .value("PseudoVFWADD_WFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR16_M2_E16)
  .value("PseudoVFWADD_WFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR16_M2_E16_MASK)
  .value("PseudoVFWADD_WFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR16_M4_E16)
  .value("PseudoVFWADD_WFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR16_M4_E16_MASK)
  .value("PseudoVFWADD_WFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR16_MF2_E16)
  .value("PseudoVFWADD_WFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR16_MF2_E16_MASK)
  .value("PseudoVFWADD_WFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR16_MF4_E16)
  .value("PseudoVFWADD_WFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR16_MF4_E16_MASK)
  .value("PseudoVFWADD_WFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR32_M1_E32)
  .value("PseudoVFWADD_WFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR32_M1_E32_MASK)
  .value("PseudoVFWADD_WFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR32_M2_E32);
  opcodes.value("PseudoVFWADD_WFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR32_M2_E32_MASK)
  .value("PseudoVFWADD_WFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR32_M4_E32)
  .value("PseudoVFWADD_WFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR32_M4_E32_MASK)
  .value("PseudoVFWADD_WFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR32_MF2_E32)
  .value("PseudoVFWADD_WFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WFPR32_MF2_E32_MASK)
  .value("PseudoVFWADD_WV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M1_E16)
  .value("PseudoVFWADD_WV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M1_E16_MASK)
  .value("PseudoVFWADD_WV_M1_E16_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M1_E16_MASK_TIED)
  .value("PseudoVFWADD_WV_M1_E16_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M1_E16_TIED)
  .value("PseudoVFWADD_WV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M1_E32)
  .value("PseudoVFWADD_WV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M1_E32_MASK)
  .value("PseudoVFWADD_WV_M1_E32_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M1_E32_MASK_TIED)
  .value("PseudoVFWADD_WV_M1_E32_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M1_E32_TIED)
  .value("PseudoVFWADD_WV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M2_E16)
  .value("PseudoVFWADD_WV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M2_E16_MASK)
  .value("PseudoVFWADD_WV_M2_E16_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M2_E16_MASK_TIED)
  .value("PseudoVFWADD_WV_M2_E16_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M2_E16_TIED)
  .value("PseudoVFWADD_WV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M2_E32)
  .value("PseudoVFWADD_WV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M2_E32_MASK)
  .value("PseudoVFWADD_WV_M2_E32_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M2_E32_MASK_TIED)
  .value("PseudoVFWADD_WV_M2_E32_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M2_E32_TIED)
  .value("PseudoVFWADD_WV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M4_E16)
  .value("PseudoVFWADD_WV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M4_E16_MASK)
  .value("PseudoVFWADD_WV_M4_E16_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M4_E16_MASK_TIED)
  .value("PseudoVFWADD_WV_M4_E16_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M4_E16_TIED)
  .value("PseudoVFWADD_WV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M4_E32)
  .value("PseudoVFWADD_WV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M4_E32_MASK)
  .value("PseudoVFWADD_WV_M4_E32_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M4_E32_MASK_TIED)
  .value("PseudoVFWADD_WV_M4_E32_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_M4_E32_TIED)
  .value("PseudoVFWADD_WV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF2_E16)
  .value("PseudoVFWADD_WV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF2_E16_MASK)
  .value("PseudoVFWADD_WV_MF2_E16_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF2_E16_MASK_TIED)
  .value("PseudoVFWADD_WV_MF2_E16_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF2_E16_TIED)
  .value("PseudoVFWADD_WV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF2_E32)
  .value("PseudoVFWADD_WV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF2_E32_MASK)
  .value("PseudoVFWADD_WV_MF2_E32_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF2_E32_MASK_TIED)
  .value("PseudoVFWADD_WV_MF2_E32_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF2_E32_TIED)
  .value("PseudoVFWADD_WV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF4_E16)
  .value("PseudoVFWADD_WV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF4_E16_MASK)
  .value("PseudoVFWADD_WV_MF4_E16_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF4_E16_MASK_TIED)
  .value("PseudoVFWADD_WV_MF4_E16_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWADD_WV_MF4_E16_TIED)
  .value("PseudoVFWCVTBF16_F_F_V_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M1_E16)
  .value("PseudoVFWCVTBF16_F_F_V_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M1_E16_MASK)
  .value("PseudoVFWCVTBF16_F_F_V_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M1_E32)
  .value("PseudoVFWCVTBF16_F_F_V_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M1_E32_MASK)
  .value("PseudoVFWCVTBF16_F_F_V_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M2_E16)
  .value("PseudoVFWCVTBF16_F_F_V_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M2_E16_MASK)
  .value("PseudoVFWCVTBF16_F_F_V_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M2_E32)
  .value("PseudoVFWCVTBF16_F_F_V_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M2_E32_MASK)
  .value("PseudoVFWCVTBF16_F_F_V_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M4_E16)
  .value("PseudoVFWCVTBF16_F_F_V_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M4_E16_MASK)
  .value("PseudoVFWCVTBF16_F_F_V_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M4_E32)
  .value("PseudoVFWCVTBF16_F_F_V_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_M4_E32_MASK)
  .value("PseudoVFWCVTBF16_F_F_V_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_MF2_E16)
  .value("PseudoVFWCVTBF16_F_F_V_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_MF2_E16_MASK)
  .value("PseudoVFWCVTBF16_F_F_V_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_MF2_E32)
  .value("PseudoVFWCVTBF16_F_F_V_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_MF2_E32_MASK)
  .value("PseudoVFWCVTBF16_F_F_V_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_MF4_E16)
  .value("PseudoVFWCVTBF16_F_F_V_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVTBF16_F_F_V_MF4_E16_MASK)
  .value("PseudoVFWCVT_F_F_V_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M1_E16)
  .value("PseudoVFWCVT_F_F_V_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M1_E16_MASK)
  .value("PseudoVFWCVT_F_F_V_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M1_E32)
  .value("PseudoVFWCVT_F_F_V_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M1_E32_MASK)
  .value("PseudoVFWCVT_F_F_V_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M2_E16)
  .value("PseudoVFWCVT_F_F_V_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M2_E16_MASK)
  .value("PseudoVFWCVT_F_F_V_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M2_E32)
  .value("PseudoVFWCVT_F_F_V_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M2_E32_MASK)
  .value("PseudoVFWCVT_F_F_V_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M4_E16)
  .value("PseudoVFWCVT_F_F_V_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M4_E16_MASK)
  .value("PseudoVFWCVT_F_F_V_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M4_E32)
  .value("PseudoVFWCVT_F_F_V_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_M4_E32_MASK)
  .value("PseudoVFWCVT_F_F_V_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_MF2_E16)
  .value("PseudoVFWCVT_F_F_V_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_MF2_E16_MASK)
  .value("PseudoVFWCVT_F_F_V_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_MF2_E32)
  .value("PseudoVFWCVT_F_F_V_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_MF2_E32_MASK)
  .value("PseudoVFWCVT_F_F_V_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_MF4_E16)
  .value("PseudoVFWCVT_F_F_V_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_F_V_MF4_E16_MASK)
  .value("PseudoVFWCVT_F_XU_V_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M1_E16)
  .value("PseudoVFWCVT_F_XU_V_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M1_E16_MASK)
  .value("PseudoVFWCVT_F_XU_V_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M1_E32)
  .value("PseudoVFWCVT_F_XU_V_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M1_E32_MASK)
  .value("PseudoVFWCVT_F_XU_V_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M1_E8)
  .value("PseudoVFWCVT_F_XU_V_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M1_E8_MASK)
  .value("PseudoVFWCVT_F_XU_V_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M2_E16)
  .value("PseudoVFWCVT_F_XU_V_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M2_E16_MASK)
  .value("PseudoVFWCVT_F_XU_V_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M2_E32)
  .value("PseudoVFWCVT_F_XU_V_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M2_E32_MASK)
  .value("PseudoVFWCVT_F_XU_V_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M2_E8)
  .value("PseudoVFWCVT_F_XU_V_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M2_E8_MASK)
  .value("PseudoVFWCVT_F_XU_V_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M4_E16)
  .value("PseudoVFWCVT_F_XU_V_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M4_E16_MASK)
  .value("PseudoVFWCVT_F_XU_V_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M4_E32)
  .value("PseudoVFWCVT_F_XU_V_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M4_E32_MASK)
  .value("PseudoVFWCVT_F_XU_V_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M4_E8)
  .value("PseudoVFWCVT_F_XU_V_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_M4_E8_MASK)
  .value("PseudoVFWCVT_F_XU_V_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF2_E16)
  .value("PseudoVFWCVT_F_XU_V_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF2_E16_MASK)
  .value("PseudoVFWCVT_F_XU_V_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF2_E32)
  .value("PseudoVFWCVT_F_XU_V_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF2_E32_MASK)
  .value("PseudoVFWCVT_F_XU_V_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF2_E8)
  .value("PseudoVFWCVT_F_XU_V_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF2_E8_MASK)
  .value("PseudoVFWCVT_F_XU_V_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF4_E16)
  .value("PseudoVFWCVT_F_XU_V_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF4_E16_MASK)
  .value("PseudoVFWCVT_F_XU_V_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF4_E8)
  .value("PseudoVFWCVT_F_XU_V_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF4_E8_MASK)
  .value("PseudoVFWCVT_F_XU_V_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF8_E8)
  .value("PseudoVFWCVT_F_XU_V_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_XU_V_MF8_E8_MASK)
  .value("PseudoVFWCVT_F_X_V_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M1_E16)
  .value("PseudoVFWCVT_F_X_V_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M1_E16_MASK)
  .value("PseudoVFWCVT_F_X_V_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M1_E32)
  .value("PseudoVFWCVT_F_X_V_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M1_E32_MASK)
  .value("PseudoVFWCVT_F_X_V_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M1_E8)
  .value("PseudoVFWCVT_F_X_V_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M1_E8_MASK)
  .value("PseudoVFWCVT_F_X_V_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M2_E16)
  .value("PseudoVFWCVT_F_X_V_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M2_E16_MASK)
  .value("PseudoVFWCVT_F_X_V_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M2_E32)
  .value("PseudoVFWCVT_F_X_V_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M2_E32_MASK)
  .value("PseudoVFWCVT_F_X_V_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M2_E8)
  .value("PseudoVFWCVT_F_X_V_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M2_E8_MASK)
  .value("PseudoVFWCVT_F_X_V_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M4_E16)
  .value("PseudoVFWCVT_F_X_V_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M4_E16_MASK)
  .value("PseudoVFWCVT_F_X_V_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M4_E32)
  .value("PseudoVFWCVT_F_X_V_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M4_E32_MASK)
  .value("PseudoVFWCVT_F_X_V_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M4_E8)
  .value("PseudoVFWCVT_F_X_V_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_M4_E8_MASK)
  .value("PseudoVFWCVT_F_X_V_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF2_E16)
  .value("PseudoVFWCVT_F_X_V_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF2_E16_MASK)
  .value("PseudoVFWCVT_F_X_V_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF2_E32)
  .value("PseudoVFWCVT_F_X_V_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF2_E32_MASK)
  .value("PseudoVFWCVT_F_X_V_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF2_E8)
  .value("PseudoVFWCVT_F_X_V_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF2_E8_MASK)
  .value("PseudoVFWCVT_F_X_V_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF4_E16)
  .value("PseudoVFWCVT_F_X_V_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF4_E16_MASK)
  .value("PseudoVFWCVT_F_X_V_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF4_E8)
  .value("PseudoVFWCVT_F_X_V_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF4_E8_MASK)
  .value("PseudoVFWCVT_F_X_V_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF8_E8)
  .value("PseudoVFWCVT_F_X_V_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_F_X_V_MF8_E8_MASK)
  .value("PseudoVFWCVT_RTZ_XU_F_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_XU_F_V_M1)
  .value("PseudoVFWCVT_RTZ_XU_F_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_XU_F_V_M1_MASK)
  .value("PseudoVFWCVT_RTZ_XU_F_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_XU_F_V_M2)
  .value("PseudoVFWCVT_RTZ_XU_F_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_XU_F_V_M2_MASK)
  .value("PseudoVFWCVT_RTZ_XU_F_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_XU_F_V_M4)
  .value("PseudoVFWCVT_RTZ_XU_F_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_XU_F_V_M4_MASK)
  .value("PseudoVFWCVT_RTZ_XU_F_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_XU_F_V_MF2)
  .value("PseudoVFWCVT_RTZ_XU_F_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_XU_F_V_MF2_MASK)
  .value("PseudoVFWCVT_RTZ_XU_F_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_XU_F_V_MF4)
  .value("PseudoVFWCVT_RTZ_XU_F_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_XU_F_V_MF4_MASK)
  .value("PseudoVFWCVT_RTZ_X_F_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_X_F_V_M1)
  .value("PseudoVFWCVT_RTZ_X_F_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_X_F_V_M1_MASK)
  .value("PseudoVFWCVT_RTZ_X_F_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_X_F_V_M2)
  .value("PseudoVFWCVT_RTZ_X_F_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_X_F_V_M2_MASK)
  .value("PseudoVFWCVT_RTZ_X_F_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_X_F_V_M4)
  .value("PseudoVFWCVT_RTZ_X_F_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_X_F_V_M4_MASK)
  .value("PseudoVFWCVT_RTZ_X_F_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_X_F_V_MF2)
  .value("PseudoVFWCVT_RTZ_X_F_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_X_F_V_MF2_MASK)
  .value("PseudoVFWCVT_RTZ_X_F_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_X_F_V_MF4)
  .value("PseudoVFWCVT_RTZ_X_F_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_RTZ_X_F_V_MF4_MASK)
  .value("PseudoVFWCVT_XU_F_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_XU_F_V_M1)
  .value("PseudoVFWCVT_XU_F_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_XU_F_V_M1_MASK)
  .value("PseudoVFWCVT_XU_F_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_XU_F_V_M2)
  .value("PseudoVFWCVT_XU_F_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_XU_F_V_M2_MASK)
  .value("PseudoVFWCVT_XU_F_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_XU_F_V_M4)
  .value("PseudoVFWCVT_XU_F_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_XU_F_V_M4_MASK)
  .value("PseudoVFWCVT_XU_F_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_XU_F_V_MF2)
  .value("PseudoVFWCVT_XU_F_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_XU_F_V_MF2_MASK)
  .value("PseudoVFWCVT_XU_F_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_XU_F_V_MF4)
  .value("PseudoVFWCVT_XU_F_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_XU_F_V_MF4_MASK)
  .value("PseudoVFWCVT_X_F_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_X_F_V_M1)
  .value("PseudoVFWCVT_X_F_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_X_F_V_M1_MASK)
  .value("PseudoVFWCVT_X_F_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_X_F_V_M2)
  .value("PseudoVFWCVT_X_F_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_X_F_V_M2_MASK)
  .value("PseudoVFWCVT_X_F_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_X_F_V_M4)
  .value("PseudoVFWCVT_X_F_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_X_F_V_M4_MASK)
  .value("PseudoVFWCVT_X_F_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_X_F_V_MF2)
  .value("PseudoVFWCVT_X_F_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_X_F_V_MF2_MASK)
  .value("PseudoVFWCVT_X_F_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_X_F_V_MF4)
  .value("PseudoVFWCVT_X_F_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWCVT_X_F_V_MF4_MASK)
  .value("PseudoVFWMACCBF16_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VFPR16_M1_E16)
  .value("PseudoVFWMACCBF16_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VFPR16_M1_E16_MASK)
  .value("PseudoVFWMACCBF16_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VFPR16_M2_E16)
  .value("PseudoVFWMACCBF16_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VFPR16_M2_E16_MASK)
  .value("PseudoVFWMACCBF16_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VFPR16_M4_E16)
  .value("PseudoVFWMACCBF16_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VFPR16_M4_E16_MASK)
  .value("PseudoVFWMACCBF16_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VFPR16_MF2_E16)
  .value("PseudoVFWMACCBF16_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VFPR16_MF2_E16_MASK)
  .value("PseudoVFWMACCBF16_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VFPR16_MF4_E16)
  .value("PseudoVFWMACCBF16_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VFPR16_MF4_E16_MASK)
  .value("PseudoVFWMACCBF16_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M1_E16)
  .value("PseudoVFWMACCBF16_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M1_E16_MASK)
  .value("PseudoVFWMACCBF16_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M1_E32)
  .value("PseudoVFWMACCBF16_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M1_E32_MASK)
  .value("PseudoVFWMACCBF16_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M2_E16)
  .value("PseudoVFWMACCBF16_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M2_E16_MASK)
  .value("PseudoVFWMACCBF16_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M2_E32)
  .value("PseudoVFWMACCBF16_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M2_E32_MASK)
  .value("PseudoVFWMACCBF16_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M4_E16)
  .value("PseudoVFWMACCBF16_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M4_E16_MASK)
  .value("PseudoVFWMACCBF16_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M4_E32)
  .value("PseudoVFWMACCBF16_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_M4_E32_MASK)
  .value("PseudoVFWMACCBF16_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_MF2_E16)
  .value("PseudoVFWMACCBF16_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_MF2_E16_MASK)
  .value("PseudoVFWMACCBF16_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_MF2_E32)
  .value("PseudoVFWMACCBF16_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_MF2_E32_MASK)
  .value("PseudoVFWMACCBF16_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_MF4_E16)
  .value("PseudoVFWMACCBF16_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACCBF16_VV_MF4_E16_MASK)
  .value("PseudoVFWMACC_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR16_M1_E16)
  .value("PseudoVFWMACC_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR16_M1_E16_MASK)
  .value("PseudoVFWMACC_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR16_M2_E16)
  .value("PseudoVFWMACC_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR16_M2_E16_MASK)
  .value("PseudoVFWMACC_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR16_M4_E16)
  .value("PseudoVFWMACC_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR16_M4_E16_MASK)
  .value("PseudoVFWMACC_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR16_MF2_E16)
  .value("PseudoVFWMACC_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR16_MF2_E16_MASK)
  .value("PseudoVFWMACC_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR16_MF4_E16)
  .value("PseudoVFWMACC_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR16_MF4_E16_MASK)
  .value("PseudoVFWMACC_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR32_M1_E32)
  .value("PseudoVFWMACC_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR32_M1_E32_MASK)
  .value("PseudoVFWMACC_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR32_M2_E32)
  .value("PseudoVFWMACC_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR32_M2_E32_MASK)
  .value("PseudoVFWMACC_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR32_M4_E32)
  .value("PseudoVFWMACC_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR32_M4_E32_MASK)
  .value("PseudoVFWMACC_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR32_MF2_E32)
  .value("PseudoVFWMACC_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VFPR32_MF2_E32_MASK)
  .value("PseudoVFWMACC_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M1_E16)
  .value("PseudoVFWMACC_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M1_E16_MASK)
  .value("PseudoVFWMACC_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M1_E32)
  .value("PseudoVFWMACC_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M1_E32_MASK)
  .value("PseudoVFWMACC_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M2_E16)
  .value("PseudoVFWMACC_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M2_E16_MASK)
  .value("PseudoVFWMACC_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M2_E32)
  .value("PseudoVFWMACC_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M2_E32_MASK)
  .value("PseudoVFWMACC_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M4_E16)
  .value("PseudoVFWMACC_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M4_E16_MASK)
  .value("PseudoVFWMACC_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M4_E32)
  .value("PseudoVFWMACC_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_M4_E32_MASK)
  .value("PseudoVFWMACC_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_MF2_E16)
  .value("PseudoVFWMACC_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_MF2_E16_MASK)
  .value("PseudoVFWMACC_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_MF2_E32)
  .value("PseudoVFWMACC_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_MF2_E32_MASK)
  .value("PseudoVFWMACC_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_MF4_E16)
  .value("PseudoVFWMACC_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMACC_VV_MF4_E16_MASK)
  .value("PseudoVFWMSAC_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR16_M1_E16)
  .value("PseudoVFWMSAC_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR16_M1_E16_MASK)
  .value("PseudoVFWMSAC_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR16_M2_E16)
  .value("PseudoVFWMSAC_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR16_M2_E16_MASK)
  .value("PseudoVFWMSAC_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR16_M4_E16)
  .value("PseudoVFWMSAC_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR16_M4_E16_MASK)
  .value("PseudoVFWMSAC_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR16_MF2_E16)
  .value("PseudoVFWMSAC_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR16_MF2_E16_MASK)
  .value("PseudoVFWMSAC_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR16_MF4_E16)
  .value("PseudoVFWMSAC_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR16_MF4_E16_MASK)
  .value("PseudoVFWMSAC_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR32_M1_E32)
  .value("PseudoVFWMSAC_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR32_M1_E32_MASK)
  .value("PseudoVFWMSAC_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR32_M2_E32)
  .value("PseudoVFWMSAC_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR32_M2_E32_MASK)
  .value("PseudoVFWMSAC_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR32_M4_E32)
  .value("PseudoVFWMSAC_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR32_M4_E32_MASK)
  .value("PseudoVFWMSAC_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR32_MF2_E32)
  .value("PseudoVFWMSAC_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VFPR32_MF2_E32_MASK)
  .value("PseudoVFWMSAC_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M1_E16)
  .value("PseudoVFWMSAC_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M1_E16_MASK)
  .value("PseudoVFWMSAC_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M1_E32)
  .value("PseudoVFWMSAC_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M1_E32_MASK)
  .value("PseudoVFWMSAC_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M2_E16)
  .value("PseudoVFWMSAC_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M2_E16_MASK)
  .value("PseudoVFWMSAC_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M2_E32)
  .value("PseudoVFWMSAC_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M2_E32_MASK)
  .value("PseudoVFWMSAC_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M4_E16)
  .value("PseudoVFWMSAC_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M4_E16_MASK)
  .value("PseudoVFWMSAC_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M4_E32)
  .value("PseudoVFWMSAC_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_M4_E32_MASK)
  .value("PseudoVFWMSAC_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_MF2_E16)
  .value("PseudoVFWMSAC_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_MF2_E16_MASK)
  .value("PseudoVFWMSAC_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_MF2_E32)
  .value("PseudoVFWMSAC_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_MF2_E32_MASK)
  .value("PseudoVFWMSAC_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_MF4_E16)
  .value("PseudoVFWMSAC_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMSAC_VV_MF4_E16_MASK)
  .value("PseudoVFWMUL_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR16_M1_E16)
  .value("PseudoVFWMUL_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR16_M1_E16_MASK)
  .value("PseudoVFWMUL_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR16_M2_E16)
  .value("PseudoVFWMUL_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR16_M2_E16_MASK)
  .value("PseudoVFWMUL_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR16_M4_E16)
  .value("PseudoVFWMUL_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR16_M4_E16_MASK)
  .value("PseudoVFWMUL_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR16_MF2_E16)
  .value("PseudoVFWMUL_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR16_MF2_E16_MASK)
  .value("PseudoVFWMUL_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR16_MF4_E16)
  .value("PseudoVFWMUL_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR16_MF4_E16_MASK)
  .value("PseudoVFWMUL_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR32_M1_E32)
  .value("PseudoVFWMUL_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR32_M1_E32_MASK)
  .value("PseudoVFWMUL_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR32_M2_E32)
  .value("PseudoVFWMUL_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR32_M2_E32_MASK)
  .value("PseudoVFWMUL_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR32_M4_E32)
  .value("PseudoVFWMUL_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR32_M4_E32_MASK)
  .value("PseudoVFWMUL_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR32_MF2_E32)
  .value("PseudoVFWMUL_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VFPR32_MF2_E32_MASK)
  .value("PseudoVFWMUL_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M1_E16)
  .value("PseudoVFWMUL_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M1_E16_MASK)
  .value("PseudoVFWMUL_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M1_E32)
  .value("PseudoVFWMUL_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M1_E32_MASK)
  .value("PseudoVFWMUL_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M2_E16);
  opcodes.value("PseudoVFWMUL_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M2_E16_MASK)
  .value("PseudoVFWMUL_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M2_E32)
  .value("PseudoVFWMUL_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M2_E32_MASK)
  .value("PseudoVFWMUL_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M4_E16)
  .value("PseudoVFWMUL_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M4_E16_MASK)
  .value("PseudoVFWMUL_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M4_E32)
  .value("PseudoVFWMUL_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_M4_E32_MASK)
  .value("PseudoVFWMUL_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_MF2_E16)
  .value("PseudoVFWMUL_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_MF2_E16_MASK)
  .value("PseudoVFWMUL_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_MF2_E32)
  .value("PseudoVFWMUL_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_MF2_E32_MASK)
  .value("PseudoVFWMUL_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_MF4_E16)
  .value("PseudoVFWMUL_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWMUL_VV_MF4_E16_MASK)
  .value("PseudoVFWNMACC_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR16_M1_E16)
  .value("PseudoVFWNMACC_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR16_M1_E16_MASK)
  .value("PseudoVFWNMACC_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR16_M2_E16)
  .value("PseudoVFWNMACC_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR16_M2_E16_MASK)
  .value("PseudoVFWNMACC_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR16_M4_E16)
  .value("PseudoVFWNMACC_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR16_M4_E16_MASK)
  .value("PseudoVFWNMACC_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR16_MF2_E16)
  .value("PseudoVFWNMACC_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR16_MF2_E16_MASK)
  .value("PseudoVFWNMACC_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR16_MF4_E16)
  .value("PseudoVFWNMACC_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR16_MF4_E16_MASK)
  .value("PseudoVFWNMACC_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR32_M1_E32)
  .value("PseudoVFWNMACC_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR32_M1_E32_MASK)
  .value("PseudoVFWNMACC_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR32_M2_E32)
  .value("PseudoVFWNMACC_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR32_M2_E32_MASK)
  .value("PseudoVFWNMACC_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR32_M4_E32)
  .value("PseudoVFWNMACC_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR32_M4_E32_MASK)
  .value("PseudoVFWNMACC_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR32_MF2_E32)
  .value("PseudoVFWNMACC_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VFPR32_MF2_E32_MASK)
  .value("PseudoVFWNMACC_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M1_E16)
  .value("PseudoVFWNMACC_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M1_E16_MASK)
  .value("PseudoVFWNMACC_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M1_E32)
  .value("PseudoVFWNMACC_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M1_E32_MASK)
  .value("PseudoVFWNMACC_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M2_E16)
  .value("PseudoVFWNMACC_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M2_E16_MASK)
  .value("PseudoVFWNMACC_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M2_E32)
  .value("PseudoVFWNMACC_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M2_E32_MASK)
  .value("PseudoVFWNMACC_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M4_E16)
  .value("PseudoVFWNMACC_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M4_E16_MASK)
  .value("PseudoVFWNMACC_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M4_E32)
  .value("PseudoVFWNMACC_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_M4_E32_MASK)
  .value("PseudoVFWNMACC_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_MF2_E16)
  .value("PseudoVFWNMACC_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_MF2_E16_MASK)
  .value("PseudoVFWNMACC_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_MF2_E32)
  .value("PseudoVFWNMACC_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_MF2_E32_MASK)
  .value("PseudoVFWNMACC_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_MF4_E16)
  .value("PseudoVFWNMACC_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMACC_VV_MF4_E16_MASK)
  .value("PseudoVFWNMSAC_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR16_M1_E16)
  .value("PseudoVFWNMSAC_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR16_M1_E16_MASK)
  .value("PseudoVFWNMSAC_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR16_M2_E16)
  .value("PseudoVFWNMSAC_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR16_M2_E16_MASK)
  .value("PseudoVFWNMSAC_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR16_M4_E16)
  .value("PseudoVFWNMSAC_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR16_M4_E16_MASK)
  .value("PseudoVFWNMSAC_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR16_MF2_E16)
  .value("PseudoVFWNMSAC_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR16_MF2_E16_MASK)
  .value("PseudoVFWNMSAC_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR16_MF4_E16)
  .value("PseudoVFWNMSAC_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR16_MF4_E16_MASK)
  .value("PseudoVFWNMSAC_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR32_M1_E32)
  .value("PseudoVFWNMSAC_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR32_M1_E32_MASK)
  .value("PseudoVFWNMSAC_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR32_M2_E32)
  .value("PseudoVFWNMSAC_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR32_M2_E32_MASK)
  .value("PseudoVFWNMSAC_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR32_M4_E32)
  .value("PseudoVFWNMSAC_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR32_M4_E32_MASK)
  .value("PseudoVFWNMSAC_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR32_MF2_E32)
  .value("PseudoVFWNMSAC_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VFPR32_MF2_E32_MASK)
  .value("PseudoVFWNMSAC_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M1_E16)
  .value("PseudoVFWNMSAC_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M1_E16_MASK)
  .value("PseudoVFWNMSAC_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M1_E32)
  .value("PseudoVFWNMSAC_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M1_E32_MASK)
  .value("PseudoVFWNMSAC_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M2_E16)
  .value("PseudoVFWNMSAC_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M2_E16_MASK)
  .value("PseudoVFWNMSAC_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M2_E32)
  .value("PseudoVFWNMSAC_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M2_E32_MASK)
  .value("PseudoVFWNMSAC_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M4_E16)
  .value("PseudoVFWNMSAC_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M4_E16_MASK)
  .value("PseudoVFWNMSAC_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M4_E32)
  .value("PseudoVFWNMSAC_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_M4_E32_MASK)
  .value("PseudoVFWNMSAC_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_MF2_E16)
  .value("PseudoVFWNMSAC_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_MF2_E16_MASK)
  .value("PseudoVFWNMSAC_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_MF2_E32)
  .value("PseudoVFWNMSAC_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_MF2_E32_MASK)
  .value("PseudoVFWNMSAC_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_MF4_E16)
  .value("PseudoVFWNMSAC_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWNMSAC_VV_MF4_E16_MASK)
  .value("PseudoVFWREDOSUM_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M1_E16)
  .value("PseudoVFWREDOSUM_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M1_E16_MASK)
  .value("PseudoVFWREDOSUM_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M1_E32)
  .value("PseudoVFWREDOSUM_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M1_E32_MASK)
  .value("PseudoVFWREDOSUM_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M2_E16)
  .value("PseudoVFWREDOSUM_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M2_E16_MASK)
  .value("PseudoVFWREDOSUM_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M2_E32)
  .value("PseudoVFWREDOSUM_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M2_E32_MASK)
  .value("PseudoVFWREDOSUM_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M4_E16)
  .value("PseudoVFWREDOSUM_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M4_E16_MASK)
  .value("PseudoVFWREDOSUM_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M4_E32)
  .value("PseudoVFWREDOSUM_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M4_E32_MASK)
  .value("PseudoVFWREDOSUM_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M8_E16)
  .value("PseudoVFWREDOSUM_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M8_E16_MASK)
  .value("PseudoVFWREDOSUM_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M8_E32)
  .value("PseudoVFWREDOSUM_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_M8_E32_MASK)
  .value("PseudoVFWREDOSUM_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_MF2_E16)
  .value("PseudoVFWREDOSUM_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_MF2_E16_MASK)
  .value("PseudoVFWREDOSUM_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_MF2_E32)
  .value("PseudoVFWREDOSUM_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_MF2_E32_MASK)
  .value("PseudoVFWREDOSUM_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_MF4_E16)
  .value("PseudoVFWREDOSUM_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDOSUM_VS_MF4_E16_MASK)
  .value("PseudoVFWREDUSUM_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M1_E16)
  .value("PseudoVFWREDUSUM_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M1_E16_MASK)
  .value("PseudoVFWREDUSUM_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M1_E32)
  .value("PseudoVFWREDUSUM_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M1_E32_MASK)
  .value("PseudoVFWREDUSUM_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M2_E16)
  .value("PseudoVFWREDUSUM_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M2_E16_MASK)
  .value("PseudoVFWREDUSUM_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M2_E32)
  .value("PseudoVFWREDUSUM_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M2_E32_MASK)
  .value("PseudoVFWREDUSUM_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M4_E16)
  .value("PseudoVFWREDUSUM_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M4_E16_MASK)
  .value("PseudoVFWREDUSUM_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M4_E32)
  .value("PseudoVFWREDUSUM_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M4_E32_MASK)
  .value("PseudoVFWREDUSUM_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M8_E16)
  .value("PseudoVFWREDUSUM_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M8_E16_MASK)
  .value("PseudoVFWREDUSUM_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M8_E32)
  .value("PseudoVFWREDUSUM_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_M8_E32_MASK)
  .value("PseudoVFWREDUSUM_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_MF2_E16)
  .value("PseudoVFWREDUSUM_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_MF2_E16_MASK)
  .value("PseudoVFWREDUSUM_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_MF2_E32)
  .value("PseudoVFWREDUSUM_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_MF2_E32_MASK)
  .value("PseudoVFWREDUSUM_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_MF4_E16)
  .value("PseudoVFWREDUSUM_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWREDUSUM_VS_MF4_E16_MASK)
  .value("PseudoVFWSUB_VFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR16_M1_E16)
  .value("PseudoVFWSUB_VFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR16_M1_E16_MASK)
  .value("PseudoVFWSUB_VFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR16_M2_E16)
  .value("PseudoVFWSUB_VFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR16_M2_E16_MASK)
  .value("PseudoVFWSUB_VFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR16_M4_E16)
  .value("PseudoVFWSUB_VFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR16_M4_E16_MASK)
  .value("PseudoVFWSUB_VFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR16_MF2_E16)
  .value("PseudoVFWSUB_VFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR16_MF2_E16_MASK)
  .value("PseudoVFWSUB_VFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR16_MF4_E16)
  .value("PseudoVFWSUB_VFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR16_MF4_E16_MASK)
  .value("PseudoVFWSUB_VFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR32_M1_E32)
  .value("PseudoVFWSUB_VFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR32_M1_E32_MASK)
  .value("PseudoVFWSUB_VFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR32_M2_E32)
  .value("PseudoVFWSUB_VFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR32_M2_E32_MASK)
  .value("PseudoVFWSUB_VFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR32_M4_E32)
  .value("PseudoVFWSUB_VFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR32_M4_E32_MASK)
  .value("PseudoVFWSUB_VFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR32_MF2_E32)
  .value("PseudoVFWSUB_VFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VFPR32_MF2_E32_MASK)
  .value("PseudoVFWSUB_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M1_E16)
  .value("PseudoVFWSUB_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M1_E16_MASK)
  .value("PseudoVFWSUB_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M1_E32)
  .value("PseudoVFWSUB_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M1_E32_MASK)
  .value("PseudoVFWSUB_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M2_E16)
  .value("PseudoVFWSUB_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M2_E16_MASK)
  .value("PseudoVFWSUB_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M2_E32)
  .value("PseudoVFWSUB_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M2_E32_MASK)
  .value("PseudoVFWSUB_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M4_E16)
  .value("PseudoVFWSUB_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M4_E16_MASK)
  .value("PseudoVFWSUB_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M4_E32)
  .value("PseudoVFWSUB_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_M4_E32_MASK)
  .value("PseudoVFWSUB_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_MF2_E16)
  .value("PseudoVFWSUB_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_MF2_E16_MASK)
  .value("PseudoVFWSUB_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_MF2_E32)
  .value("PseudoVFWSUB_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_MF2_E32_MASK)
  .value("PseudoVFWSUB_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_MF4_E16)
  .value("PseudoVFWSUB_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_VV_MF4_E16_MASK)
  .value("PseudoVFWSUB_WFPR16_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR16_M1_E16)
  .value("PseudoVFWSUB_WFPR16_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR16_M1_E16_MASK)
  .value("PseudoVFWSUB_WFPR16_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR16_M2_E16)
  .value("PseudoVFWSUB_WFPR16_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR16_M2_E16_MASK)
  .value("PseudoVFWSUB_WFPR16_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR16_M4_E16)
  .value("PseudoVFWSUB_WFPR16_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR16_M4_E16_MASK)
  .value("PseudoVFWSUB_WFPR16_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR16_MF2_E16)
  .value("PseudoVFWSUB_WFPR16_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR16_MF2_E16_MASK)
  .value("PseudoVFWSUB_WFPR16_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR16_MF4_E16)
  .value("PseudoVFWSUB_WFPR16_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR16_MF4_E16_MASK)
  .value("PseudoVFWSUB_WFPR32_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR32_M1_E32)
  .value("PseudoVFWSUB_WFPR32_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR32_M1_E32_MASK)
  .value("PseudoVFWSUB_WFPR32_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR32_M2_E32)
  .value("PseudoVFWSUB_WFPR32_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR32_M2_E32_MASK)
  .value("PseudoVFWSUB_WFPR32_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR32_M4_E32)
  .value("PseudoVFWSUB_WFPR32_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR32_M4_E32_MASK)
  .value("PseudoVFWSUB_WFPR32_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR32_MF2_E32)
  .value("PseudoVFWSUB_WFPR32_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WFPR32_MF2_E32_MASK)
  .value("PseudoVFWSUB_WV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M1_E16)
  .value("PseudoVFWSUB_WV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M1_E16_MASK)
  .value("PseudoVFWSUB_WV_M1_E16_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M1_E16_MASK_TIED)
  .value("PseudoVFWSUB_WV_M1_E16_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M1_E16_TIED)
  .value("PseudoVFWSUB_WV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M1_E32)
  .value("PseudoVFWSUB_WV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M1_E32_MASK)
  .value("PseudoVFWSUB_WV_M1_E32_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M1_E32_MASK_TIED)
  .value("PseudoVFWSUB_WV_M1_E32_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M1_E32_TIED)
  .value("PseudoVFWSUB_WV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M2_E16)
  .value("PseudoVFWSUB_WV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M2_E16_MASK)
  .value("PseudoVFWSUB_WV_M2_E16_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M2_E16_MASK_TIED)
  .value("PseudoVFWSUB_WV_M2_E16_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M2_E16_TIED)
  .value("PseudoVFWSUB_WV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M2_E32)
  .value("PseudoVFWSUB_WV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M2_E32_MASK)
  .value("PseudoVFWSUB_WV_M2_E32_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M2_E32_MASK_TIED)
  .value("PseudoVFWSUB_WV_M2_E32_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M2_E32_TIED)
  .value("PseudoVFWSUB_WV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M4_E16)
  .value("PseudoVFWSUB_WV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M4_E16_MASK)
  .value("PseudoVFWSUB_WV_M4_E16_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M4_E16_MASK_TIED)
  .value("PseudoVFWSUB_WV_M4_E16_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M4_E16_TIED)
  .value("PseudoVFWSUB_WV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M4_E32)
  .value("PseudoVFWSUB_WV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M4_E32_MASK)
  .value("PseudoVFWSUB_WV_M4_E32_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M4_E32_MASK_TIED)
  .value("PseudoVFWSUB_WV_M4_E32_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_M4_E32_TIED)
  .value("PseudoVFWSUB_WV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF2_E16)
  .value("PseudoVFWSUB_WV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF2_E16_MASK)
  .value("PseudoVFWSUB_WV_MF2_E16_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF2_E16_MASK_TIED)
  .value("PseudoVFWSUB_WV_MF2_E16_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF2_E16_TIED)
  .value("PseudoVFWSUB_WV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF2_E32)
  .value("PseudoVFWSUB_WV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF2_E32_MASK)
  .value("PseudoVFWSUB_WV_MF2_E32_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF2_E32_MASK_TIED)
  .value("PseudoVFWSUB_WV_MF2_E32_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF2_E32_TIED)
  .value("PseudoVFWSUB_WV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF4_E16)
  .value("PseudoVFWSUB_WV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF4_E16_MASK)
  .value("PseudoVFWSUB_WV_MF4_E16_MASK_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF4_E16_MASK_TIED)
  .value("PseudoVFWSUB_WV_MF4_E16_TIED", LIEF::assembly::riscv::OPCODE::PseudoVFWSUB_WV_MF4_E16_TIED)
  .value("PseudoVGHSH_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVGHSH_VV_M1)
  .value("PseudoVGHSH_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVGHSH_VV_M2)
  .value("PseudoVGHSH_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVGHSH_VV_M4)
  .value("PseudoVGHSH_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVGHSH_VV_M8)
  .value("PseudoVGHSH_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVGHSH_VV_MF2)
  .value("PseudoVGMUL_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVGMUL_VV_M1)
  .value("PseudoVGMUL_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVGMUL_VV_M2)
  .value("PseudoVGMUL_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVGMUL_VV_M4)
  .value("PseudoVGMUL_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVGMUL_VV_M8)
  .value("PseudoVGMUL_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVGMUL_VV_MF2)
  .value("PseudoVID_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVID_V_M1)
  .value("PseudoVID_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVID_V_M1_MASK)
  .value("PseudoVID_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVID_V_M2)
  .value("PseudoVID_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVID_V_M2_MASK)
  .value("PseudoVID_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVID_V_M4)
  .value("PseudoVID_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVID_V_M4_MASK)
  .value("PseudoVID_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVID_V_M8)
  .value("PseudoVID_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVID_V_M8_MASK)
  .value("PseudoVID_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVID_V_MF2)
  .value("PseudoVID_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVID_V_MF2_MASK)
  .value("PseudoVID_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVID_V_MF4)
  .value("PseudoVID_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVID_V_MF4_MASK)
  .value("PseudoVID_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVID_V_MF8)
  .value("PseudoVID_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVID_V_MF8_MASK)
  .value("PseudoVIOTA_M_M1", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_M1)
  .value("PseudoVIOTA_M_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_M1_MASK)
  .value("PseudoVIOTA_M_M2", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_M2)
  .value("PseudoVIOTA_M_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_M2_MASK)
  .value("PseudoVIOTA_M_M4", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_M4)
  .value("PseudoVIOTA_M_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_M4_MASK)
  .value("PseudoVIOTA_M_M8", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_M8)
  .value("PseudoVIOTA_M_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_M8_MASK)
  .value("PseudoVIOTA_M_MF2", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_MF2)
  .value("PseudoVIOTA_M_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_MF2_MASK)
  .value("PseudoVIOTA_M_MF4", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_MF4)
  .value("PseudoVIOTA_M_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_MF4_MASK)
  .value("PseudoVIOTA_M_MF8", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_MF8)
  .value("PseudoVIOTA_M_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVIOTA_M_MF8_MASK)
  .value("PseudoVLE16FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_M1)
  .value("PseudoVLE16FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_M1_MASK)
  .value("PseudoVLE16FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_M2)
  .value("PseudoVLE16FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_M2_MASK)
  .value("PseudoVLE16FF_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_M4)
  .value("PseudoVLE16FF_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_M4_MASK)
  .value("PseudoVLE16FF_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_M8)
  .value("PseudoVLE16FF_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_M8_MASK)
  .value("PseudoVLE16FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_MF2)
  .value("PseudoVLE16FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_MF2_MASK)
  .value("PseudoVLE16FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_MF4)
  .value("PseudoVLE16FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16FF_V_MF4_MASK)
  .value("PseudoVLE16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_M1)
  .value("PseudoVLE16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_M1_MASK)
  .value("PseudoVLE16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_M2)
  .value("PseudoVLE16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_M2_MASK)
  .value("PseudoVLE16_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_M4)
  .value("PseudoVLE16_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_M4_MASK)
  .value("PseudoVLE16_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_M8)
  .value("PseudoVLE16_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_M8_MASK)
  .value("PseudoVLE16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_MF2)
  .value("PseudoVLE16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_MF2_MASK)
  .value("PseudoVLE16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_MF4)
  .value("PseudoVLE16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE16_V_MF4_MASK)
  .value("PseudoVLE32FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLE32FF_V_M1)
  .value("PseudoVLE32FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE32FF_V_M1_MASK)
  .value("PseudoVLE32FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLE32FF_V_M2)
  .value("PseudoVLE32FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE32FF_V_M2_MASK)
  .value("PseudoVLE32FF_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLE32FF_V_M4)
  .value("PseudoVLE32FF_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE32FF_V_M4_MASK)
  .value("PseudoVLE32FF_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLE32FF_V_M8)
  .value("PseudoVLE32FF_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE32FF_V_M8_MASK)
  .value("PseudoVLE32FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLE32FF_V_MF2)
  .value("PseudoVLE32FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE32FF_V_MF2_MASK)
  .value("PseudoVLE32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLE32_V_M1)
  .value("PseudoVLE32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE32_V_M1_MASK)
  .value("PseudoVLE32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLE32_V_M2)
  .value("PseudoVLE32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE32_V_M2_MASK)
  .value("PseudoVLE32_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLE32_V_M4)
  .value("PseudoVLE32_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE32_V_M4_MASK)
  .value("PseudoVLE32_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLE32_V_M8)
  .value("PseudoVLE32_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE32_V_M8_MASK)
  .value("PseudoVLE32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLE32_V_MF2);
  opcodes.value("PseudoVLE32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE32_V_MF2_MASK)
  .value("PseudoVLE64FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLE64FF_V_M1)
  .value("PseudoVLE64FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE64FF_V_M1_MASK)
  .value("PseudoVLE64FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLE64FF_V_M2)
  .value("PseudoVLE64FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE64FF_V_M2_MASK)
  .value("PseudoVLE64FF_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLE64FF_V_M4)
  .value("PseudoVLE64FF_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE64FF_V_M4_MASK)
  .value("PseudoVLE64FF_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLE64FF_V_M8)
  .value("PseudoVLE64FF_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE64FF_V_M8_MASK)
  .value("PseudoVLE64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLE64_V_M1)
  .value("PseudoVLE64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE64_V_M1_MASK)
  .value("PseudoVLE64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLE64_V_M2)
  .value("PseudoVLE64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE64_V_M2_MASK)
  .value("PseudoVLE64_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLE64_V_M4)
  .value("PseudoVLE64_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE64_V_M4_MASK)
  .value("PseudoVLE64_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLE64_V_M8)
  .value("PseudoVLE64_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE64_V_M8_MASK)
  .value("PseudoVLE8FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_M1)
  .value("PseudoVLE8FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_M1_MASK)
  .value("PseudoVLE8FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_M2)
  .value("PseudoVLE8FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_M2_MASK)
  .value("PseudoVLE8FF_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_M4)
  .value("PseudoVLE8FF_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_M4_MASK)
  .value("PseudoVLE8FF_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_M8)
  .value("PseudoVLE8FF_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_M8_MASK)
  .value("PseudoVLE8FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_MF2)
  .value("PseudoVLE8FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_MF2_MASK)
  .value("PseudoVLE8FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_MF4)
  .value("PseudoVLE8FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_MF4_MASK)
  .value("PseudoVLE8FF_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_MF8)
  .value("PseudoVLE8FF_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8FF_V_MF8_MASK)
  .value("PseudoVLE8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_M1)
  .value("PseudoVLE8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_M1_MASK)
  .value("PseudoVLE8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_M2)
  .value("PseudoVLE8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_M2_MASK)
  .value("PseudoVLE8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_M4)
  .value("PseudoVLE8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_M4_MASK)
  .value("PseudoVLE8_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_M8)
  .value("PseudoVLE8_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_M8_MASK)
  .value("PseudoVLE8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_MF2)
  .value("PseudoVLE8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_MF2_MASK)
  .value("PseudoVLE8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_MF4)
  .value("PseudoVLE8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_MF4_MASK)
  .value("PseudoVLE8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_MF8)
  .value("PseudoVLE8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLE8_V_MF8_MASK)
  .value("PseudoVLM_V_B1", LIEF::assembly::riscv::OPCODE::PseudoVLM_V_B1)
  .value("PseudoVLM_V_B16", LIEF::assembly::riscv::OPCODE::PseudoVLM_V_B16)
  .value("PseudoVLM_V_B2", LIEF::assembly::riscv::OPCODE::PseudoVLM_V_B2)
  .value("PseudoVLM_V_B32", LIEF::assembly::riscv::OPCODE::PseudoVLM_V_B32)
  .value("PseudoVLM_V_B4", LIEF::assembly::riscv::OPCODE::PseudoVLM_V_B4)
  .value("PseudoVLM_V_B64", LIEF::assembly::riscv::OPCODE::PseudoVLM_V_B64)
  .value("PseudoVLM_V_B8", LIEF::assembly::riscv::OPCODE::PseudoVLM_V_B8)
  .value("PseudoVLOXEI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M1_M1)
  .value("PseudoVLOXEI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M1_M1_MASK)
  .value("PseudoVLOXEI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M1_M2)
  .value("PseudoVLOXEI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M1_M2_MASK)
  .value("PseudoVLOXEI16_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M1_M4)
  .value("PseudoVLOXEI16_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M1_M4_MASK)
  .value("PseudoVLOXEI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M1_MF2)
  .value("PseudoVLOXEI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M1_MF2_MASK)
  .value("PseudoVLOXEI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M2_M1)
  .value("PseudoVLOXEI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M2_M1_MASK)
  .value("PseudoVLOXEI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M2_M2)
  .value("PseudoVLOXEI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M2_M2_MASK)
  .value("PseudoVLOXEI16_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M2_M4)
  .value("PseudoVLOXEI16_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M2_M4_MASK)
  .value("PseudoVLOXEI16_V_M2_M8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M2_M8)
  .value("PseudoVLOXEI16_V_M2_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M2_M8_MASK)
  .value("PseudoVLOXEI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M4_M2)
  .value("PseudoVLOXEI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M4_M2_MASK)
  .value("PseudoVLOXEI16_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M4_M4)
  .value("PseudoVLOXEI16_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M4_M4_MASK)
  .value("PseudoVLOXEI16_V_M4_M8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M4_M8)
  .value("PseudoVLOXEI16_V_M4_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M4_M8_MASK)
  .value("PseudoVLOXEI16_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M8_M4)
  .value("PseudoVLOXEI16_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M8_M4_MASK)
  .value("PseudoVLOXEI16_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M8_M8)
  .value("PseudoVLOXEI16_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_M8_M8_MASK)
  .value("PseudoVLOXEI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF2_M1)
  .value("PseudoVLOXEI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF2_M1_MASK)
  .value("PseudoVLOXEI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF2_M2)
  .value("PseudoVLOXEI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF2_M2_MASK)
  .value("PseudoVLOXEI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF2_MF2)
  .value("PseudoVLOXEI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF2_MF2_MASK)
  .value("PseudoVLOXEI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF2_MF4)
  .value("PseudoVLOXEI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF2_MF4_MASK)
  .value("PseudoVLOXEI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF4_M1)
  .value("PseudoVLOXEI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF4_M1_MASK)
  .value("PseudoVLOXEI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF4_MF2)
  .value("PseudoVLOXEI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF4_MF2_MASK)
  .value("PseudoVLOXEI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF4_MF4)
  .value("PseudoVLOXEI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF4_MF4_MASK)
  .value("PseudoVLOXEI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF4_MF8)
  .value("PseudoVLOXEI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI16_V_MF4_MF8_MASK)
  .value("PseudoVLOXEI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M1_M1)
  .value("PseudoVLOXEI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M1_M1_MASK)
  .value("PseudoVLOXEI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M1_M2)
  .value("PseudoVLOXEI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M1_M2_MASK)
  .value("PseudoVLOXEI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M1_MF2)
  .value("PseudoVLOXEI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M1_MF2_MASK)
  .value("PseudoVLOXEI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M1_MF4)
  .value("PseudoVLOXEI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M1_MF4_MASK)
  .value("PseudoVLOXEI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M2_M1)
  .value("PseudoVLOXEI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M2_M1_MASK)
  .value("PseudoVLOXEI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M2_M2)
  .value("PseudoVLOXEI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M2_M2_MASK)
  .value("PseudoVLOXEI32_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M2_M4)
  .value("PseudoVLOXEI32_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M2_M4_MASK)
  .value("PseudoVLOXEI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M2_MF2)
  .value("PseudoVLOXEI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M2_MF2_MASK)
  .value("PseudoVLOXEI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M4_M1)
  .value("PseudoVLOXEI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M4_M1_MASK)
  .value("PseudoVLOXEI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M4_M2)
  .value("PseudoVLOXEI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M4_M2_MASK)
  .value("PseudoVLOXEI32_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M4_M4)
  .value("PseudoVLOXEI32_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M4_M4_MASK)
  .value("PseudoVLOXEI32_V_M4_M8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M4_M8)
  .value("PseudoVLOXEI32_V_M4_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M4_M8_MASK)
  .value("PseudoVLOXEI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M8_M2)
  .value("PseudoVLOXEI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M8_M2_MASK)
  .value("PseudoVLOXEI32_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M8_M4)
  .value("PseudoVLOXEI32_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M8_M4_MASK)
  .value("PseudoVLOXEI32_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M8_M8)
  .value("PseudoVLOXEI32_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_M8_M8_MASK)
  .value("PseudoVLOXEI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_MF2_M1)
  .value("PseudoVLOXEI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_MF2_M1_MASK)
  .value("PseudoVLOXEI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_MF2_MF2)
  .value("PseudoVLOXEI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_MF2_MF2_MASK)
  .value("PseudoVLOXEI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_MF2_MF4)
  .value("PseudoVLOXEI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_MF2_MF4_MASK)
  .value("PseudoVLOXEI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_MF2_MF8)
  .value("PseudoVLOXEI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI32_V_MF2_MF8_MASK)
  .value("PseudoVLOXEI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M1_M1)
  .value("PseudoVLOXEI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M1_M1_MASK)
  .value("PseudoVLOXEI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M1_MF2)
  .value("PseudoVLOXEI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M1_MF2_MASK)
  .value("PseudoVLOXEI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M1_MF4)
  .value("PseudoVLOXEI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M1_MF4_MASK)
  .value("PseudoVLOXEI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M1_MF8)
  .value("PseudoVLOXEI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M1_MF8_MASK)
  .value("PseudoVLOXEI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M2_M1)
  .value("PseudoVLOXEI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M2_M1_MASK)
  .value("PseudoVLOXEI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M2_M2)
  .value("PseudoVLOXEI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M2_M2_MASK)
  .value("PseudoVLOXEI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M2_MF2)
  .value("PseudoVLOXEI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M2_MF2_MASK)
  .value("PseudoVLOXEI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M2_MF4)
  .value("PseudoVLOXEI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M2_MF4_MASK)
  .value("PseudoVLOXEI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M4_M1)
  .value("PseudoVLOXEI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M4_M1_MASK)
  .value("PseudoVLOXEI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M4_M2)
  .value("PseudoVLOXEI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M4_M2_MASK)
  .value("PseudoVLOXEI64_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M4_M4)
  .value("PseudoVLOXEI64_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M4_M4_MASK)
  .value("PseudoVLOXEI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M4_MF2)
  .value("PseudoVLOXEI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M4_MF2_MASK)
  .value("PseudoVLOXEI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M8_M1)
  .value("PseudoVLOXEI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M8_M1_MASK)
  .value("PseudoVLOXEI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M8_M2)
  .value("PseudoVLOXEI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M8_M2_MASK)
  .value("PseudoVLOXEI64_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M8_M4)
  .value("PseudoVLOXEI64_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M8_M4_MASK)
  .value("PseudoVLOXEI64_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M8_M8)
  .value("PseudoVLOXEI64_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI64_V_M8_M8_MASK)
  .value("PseudoVLOXEI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M1_M1)
  .value("PseudoVLOXEI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M1_M1_MASK)
  .value("PseudoVLOXEI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M1_M2)
  .value("PseudoVLOXEI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M1_M2_MASK)
  .value("PseudoVLOXEI8_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M1_M4)
  .value("PseudoVLOXEI8_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M1_M4_MASK)
  .value("PseudoVLOXEI8_V_M1_M8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M1_M8)
  .value("PseudoVLOXEI8_V_M1_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M1_M8_MASK)
  .value("PseudoVLOXEI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M2_M2)
  .value("PseudoVLOXEI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M2_M2_MASK)
  .value("PseudoVLOXEI8_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M2_M4)
  .value("PseudoVLOXEI8_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M2_M4_MASK)
  .value("PseudoVLOXEI8_V_M2_M8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M2_M8)
  .value("PseudoVLOXEI8_V_M2_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M2_M8_MASK)
  .value("PseudoVLOXEI8_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M4_M4)
  .value("PseudoVLOXEI8_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M4_M4_MASK)
  .value("PseudoVLOXEI8_V_M4_M8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M4_M8)
  .value("PseudoVLOXEI8_V_M4_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M4_M8_MASK)
  .value("PseudoVLOXEI8_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M8_M8)
  .value("PseudoVLOXEI8_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_M8_M8_MASK)
  .value("PseudoVLOXEI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF2_M1)
  .value("PseudoVLOXEI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF2_M1_MASK)
  .value("PseudoVLOXEI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF2_M2)
  .value("PseudoVLOXEI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF2_M2_MASK)
  .value("PseudoVLOXEI8_V_MF2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF2_M4)
  .value("PseudoVLOXEI8_V_MF2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF2_M4_MASK)
  .value("PseudoVLOXEI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF2_MF2)
  .value("PseudoVLOXEI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF2_MF2_MASK)
  .value("PseudoVLOXEI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF4_M1)
  .value("PseudoVLOXEI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF4_M1_MASK)
  .value("PseudoVLOXEI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF4_M2)
  .value("PseudoVLOXEI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF4_M2_MASK)
  .value("PseudoVLOXEI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF4_MF2)
  .value("PseudoVLOXEI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF4_MF2_MASK)
  .value("PseudoVLOXEI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF4_MF4)
  .value("PseudoVLOXEI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF4_MF4_MASK)
  .value("PseudoVLOXEI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF8_M1)
  .value("PseudoVLOXEI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF8_M1_MASK)
  .value("PseudoVLOXEI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF8_MF2)
  .value("PseudoVLOXEI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF8_MF2_MASK)
  .value("PseudoVLOXEI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF8_MF4)
  .value("PseudoVLOXEI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF8_MF4_MASK)
  .value("PseudoVLOXEI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF8_MF8)
  .value("PseudoVLOXEI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXEI8_V_MF8_MF8_MASK)
  .value("PseudoVLOXSEG2EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M1_M1)
  .value("PseudoVLOXSEG2EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M1_M1_MASK)
  .value("PseudoVLOXSEG2EI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M1_M2)
  .value("PseudoVLOXSEG2EI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M1_M2_MASK)
  .value("PseudoVLOXSEG2EI16_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M1_M4)
  .value("PseudoVLOXSEG2EI16_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M1_M4_MASK)
  .value("PseudoVLOXSEG2EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M1_MF2)
  .value("PseudoVLOXSEG2EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG2EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M2_M1)
  .value("PseudoVLOXSEG2EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M2_M1_MASK)
  .value("PseudoVLOXSEG2EI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M2_M2)
  .value("PseudoVLOXSEG2EI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M2_M2_MASK)
  .value("PseudoVLOXSEG2EI16_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M2_M4)
  .value("PseudoVLOXSEG2EI16_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M2_M4_MASK)
  .value("PseudoVLOXSEG2EI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M4_M2)
  .value("PseudoVLOXSEG2EI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M4_M2_MASK)
  .value("PseudoVLOXSEG2EI16_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M4_M4)
  .value("PseudoVLOXSEG2EI16_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M4_M4_MASK)
  .value("PseudoVLOXSEG2EI16_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M8_M4)
  .value("PseudoVLOXSEG2EI16_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_M8_M4_MASK)
  .value("PseudoVLOXSEG2EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF2_M1)
  .value("PseudoVLOXSEG2EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG2EI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF2_M2)
  .value("PseudoVLOXSEG2EI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF2_M2_MASK)
  .value("PseudoVLOXSEG2EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF2_MF2)
  .value("PseudoVLOXSEG2EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG2EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF2_MF4)
  .value("PseudoVLOXSEG2EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG2EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF4_M1)
  .value("PseudoVLOXSEG2EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG2EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF4_MF2)
  .value("PseudoVLOXSEG2EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG2EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF4_MF4)
  .value("PseudoVLOXSEG2EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG2EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF4_MF8)
  .value("PseudoVLOXSEG2EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI16_V_MF4_MF8_MASK)
  .value("PseudoVLOXSEG2EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M1_M1)
  .value("PseudoVLOXSEG2EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M1_M1_MASK)
  .value("PseudoVLOXSEG2EI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M1_M2)
  .value("PseudoVLOXSEG2EI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M1_M2_MASK)
  .value("PseudoVLOXSEG2EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M1_MF2)
  .value("PseudoVLOXSEG2EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG2EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M1_MF4)
  .value("PseudoVLOXSEG2EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG2EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M2_M1)
  .value("PseudoVLOXSEG2EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M2_M1_MASK)
  .value("PseudoVLOXSEG2EI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M2_M2)
  .value("PseudoVLOXSEG2EI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M2_M2_MASK)
  .value("PseudoVLOXSEG2EI32_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M2_M4)
  .value("PseudoVLOXSEG2EI32_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M2_M4_MASK)
  .value("PseudoVLOXSEG2EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M2_MF2)
  .value("PseudoVLOXSEG2EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG2EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M4_M1)
  .value("PseudoVLOXSEG2EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M4_M1_MASK)
  .value("PseudoVLOXSEG2EI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M4_M2)
  .value("PseudoVLOXSEG2EI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M4_M2_MASK)
  .value("PseudoVLOXSEG2EI32_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M4_M4)
  .value("PseudoVLOXSEG2EI32_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M4_M4_MASK)
  .value("PseudoVLOXSEG2EI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M8_M2)
  .value("PseudoVLOXSEG2EI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M8_M2_MASK)
  .value("PseudoVLOXSEG2EI32_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M8_M4)
  .value("PseudoVLOXSEG2EI32_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_M8_M4_MASK)
  .value("PseudoVLOXSEG2EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_MF2_M1)
  .value("PseudoVLOXSEG2EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG2EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_MF2_MF2)
  .value("PseudoVLOXSEG2EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG2EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_MF2_MF4)
  .value("PseudoVLOXSEG2EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG2EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_MF2_MF8)
  .value("PseudoVLOXSEG2EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI32_V_MF2_MF8_MASK)
  .value("PseudoVLOXSEG2EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M1_M1)
  .value("PseudoVLOXSEG2EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M1_M1_MASK)
  .value("PseudoVLOXSEG2EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M1_MF2)
  .value("PseudoVLOXSEG2EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG2EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M1_MF4)
  .value("PseudoVLOXSEG2EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG2EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M1_MF8)
  .value("PseudoVLOXSEG2EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M1_MF8_MASK)
  .value("PseudoVLOXSEG2EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M2_M1)
  .value("PseudoVLOXSEG2EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M2_M1_MASK)
  .value("PseudoVLOXSEG2EI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M2_M2)
  .value("PseudoVLOXSEG2EI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M2_M2_MASK)
  .value("PseudoVLOXSEG2EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M2_MF2)
  .value("PseudoVLOXSEG2EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG2EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M2_MF4)
  .value("PseudoVLOXSEG2EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M2_MF4_MASK)
  .value("PseudoVLOXSEG2EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M4_M1)
  .value("PseudoVLOXSEG2EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M4_M1_MASK)
  .value("PseudoVLOXSEG2EI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M4_M2)
  .value("PseudoVLOXSEG2EI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M4_M2_MASK)
  .value("PseudoVLOXSEG2EI64_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M4_M4)
  .value("PseudoVLOXSEG2EI64_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M4_M4_MASK);
  opcodes.value("PseudoVLOXSEG2EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M4_MF2)
  .value("PseudoVLOXSEG2EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M4_MF2_MASK)
  .value("PseudoVLOXSEG2EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M8_M1)
  .value("PseudoVLOXSEG2EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M8_M1_MASK)
  .value("PseudoVLOXSEG2EI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M8_M2)
  .value("PseudoVLOXSEG2EI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M8_M2_MASK)
  .value("PseudoVLOXSEG2EI64_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M8_M4)
  .value("PseudoVLOXSEG2EI64_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI64_V_M8_M4_MASK)
  .value("PseudoVLOXSEG2EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M1_M1)
  .value("PseudoVLOXSEG2EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M1_M1_MASK)
  .value("PseudoVLOXSEG2EI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M1_M2)
  .value("PseudoVLOXSEG2EI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M1_M2_MASK)
  .value("PseudoVLOXSEG2EI8_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M1_M4)
  .value("PseudoVLOXSEG2EI8_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M1_M4_MASK)
  .value("PseudoVLOXSEG2EI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M2_M2)
  .value("PseudoVLOXSEG2EI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M2_M2_MASK)
  .value("PseudoVLOXSEG2EI8_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M2_M4)
  .value("PseudoVLOXSEG2EI8_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M2_M4_MASK)
  .value("PseudoVLOXSEG2EI8_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M4_M4)
  .value("PseudoVLOXSEG2EI8_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_M4_M4_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF2_M1)
  .value("PseudoVLOXSEG2EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF2_M2)
  .value("PseudoVLOXSEG2EI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF2_M2_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF2_M4)
  .value("PseudoVLOXSEG2EI8_V_MF2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF2_M4_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF2_MF2)
  .value("PseudoVLOXSEG2EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF4_M1)
  .value("PseudoVLOXSEG2EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF4_M2)
  .value("PseudoVLOXSEG2EI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF4_M2_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF4_MF2)
  .value("PseudoVLOXSEG2EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF4_MF4)
  .value("PseudoVLOXSEG2EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF8_M1)
  .value("PseudoVLOXSEG2EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF8_M1_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF8_MF2)
  .value("PseudoVLOXSEG2EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF8_MF2_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF8_MF4)
  .value("PseudoVLOXSEG2EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF8_MF4_MASK)
  .value("PseudoVLOXSEG2EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF8_MF8)
  .value("PseudoVLOXSEG2EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG2EI8_V_MF8_MF8_MASK)
  .value("PseudoVLOXSEG3EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M1_M1)
  .value("PseudoVLOXSEG3EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M1_M1_MASK)
  .value("PseudoVLOXSEG3EI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M1_M2)
  .value("PseudoVLOXSEG3EI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M1_M2_MASK)
  .value("PseudoVLOXSEG3EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M1_MF2)
  .value("PseudoVLOXSEG3EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG3EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M2_M1)
  .value("PseudoVLOXSEG3EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M2_M1_MASK)
  .value("PseudoVLOXSEG3EI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M2_M2)
  .value("PseudoVLOXSEG3EI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M2_M2_MASK)
  .value("PseudoVLOXSEG3EI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M4_M2)
  .value("PseudoVLOXSEG3EI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_M4_M2_MASK)
  .value("PseudoVLOXSEG3EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF2_M1)
  .value("PseudoVLOXSEG3EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG3EI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF2_M2)
  .value("PseudoVLOXSEG3EI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF2_M2_MASK)
  .value("PseudoVLOXSEG3EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF2_MF2)
  .value("PseudoVLOXSEG3EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG3EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF2_MF4)
  .value("PseudoVLOXSEG3EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG3EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF4_M1)
  .value("PseudoVLOXSEG3EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG3EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF4_MF2)
  .value("PseudoVLOXSEG3EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG3EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF4_MF4)
  .value("PseudoVLOXSEG3EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG3EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF4_MF8)
  .value("PseudoVLOXSEG3EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI16_V_MF4_MF8_MASK)
  .value("PseudoVLOXSEG3EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M1_M1)
  .value("PseudoVLOXSEG3EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M1_M1_MASK)
  .value("PseudoVLOXSEG3EI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M1_M2)
  .value("PseudoVLOXSEG3EI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M1_M2_MASK)
  .value("PseudoVLOXSEG3EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M1_MF2)
  .value("PseudoVLOXSEG3EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG3EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M1_MF4)
  .value("PseudoVLOXSEG3EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG3EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M2_M1)
  .value("PseudoVLOXSEG3EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M2_M1_MASK)
  .value("PseudoVLOXSEG3EI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M2_M2)
  .value("PseudoVLOXSEG3EI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M2_M2_MASK)
  .value("PseudoVLOXSEG3EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M2_MF2)
  .value("PseudoVLOXSEG3EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG3EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M4_M1)
  .value("PseudoVLOXSEG3EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M4_M1_MASK)
  .value("PseudoVLOXSEG3EI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M4_M2)
  .value("PseudoVLOXSEG3EI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M4_M2_MASK)
  .value("PseudoVLOXSEG3EI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M8_M2)
  .value("PseudoVLOXSEG3EI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_M8_M2_MASK)
  .value("PseudoVLOXSEG3EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_MF2_M1)
  .value("PseudoVLOXSEG3EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG3EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_MF2_MF2)
  .value("PseudoVLOXSEG3EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG3EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_MF2_MF4)
  .value("PseudoVLOXSEG3EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG3EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_MF2_MF8)
  .value("PseudoVLOXSEG3EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI32_V_MF2_MF8_MASK)
  .value("PseudoVLOXSEG3EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M1_M1)
  .value("PseudoVLOXSEG3EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M1_M1_MASK)
  .value("PseudoVLOXSEG3EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M1_MF2)
  .value("PseudoVLOXSEG3EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG3EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M1_MF4)
  .value("PseudoVLOXSEG3EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG3EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M1_MF8)
  .value("PseudoVLOXSEG3EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M1_MF8_MASK)
  .value("PseudoVLOXSEG3EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M2_M1)
  .value("PseudoVLOXSEG3EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M2_M1_MASK)
  .value("PseudoVLOXSEG3EI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M2_M2)
  .value("PseudoVLOXSEG3EI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M2_M2_MASK)
  .value("PseudoVLOXSEG3EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M2_MF2)
  .value("PseudoVLOXSEG3EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG3EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M2_MF4)
  .value("PseudoVLOXSEG3EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M2_MF4_MASK)
  .value("PseudoVLOXSEG3EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M4_M1)
  .value("PseudoVLOXSEG3EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M4_M1_MASK)
  .value("PseudoVLOXSEG3EI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M4_M2)
  .value("PseudoVLOXSEG3EI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M4_M2_MASK)
  .value("PseudoVLOXSEG3EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M4_MF2)
  .value("PseudoVLOXSEG3EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M4_MF2_MASK)
  .value("PseudoVLOXSEG3EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M8_M1)
  .value("PseudoVLOXSEG3EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M8_M1_MASK)
  .value("PseudoVLOXSEG3EI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M8_M2)
  .value("PseudoVLOXSEG3EI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI64_V_M8_M2_MASK)
  .value("PseudoVLOXSEG3EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_M1_M1)
  .value("PseudoVLOXSEG3EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_M1_M1_MASK)
  .value("PseudoVLOXSEG3EI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_M1_M2)
  .value("PseudoVLOXSEG3EI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_M1_M2_MASK)
  .value("PseudoVLOXSEG3EI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_M2_M2)
  .value("PseudoVLOXSEG3EI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_M2_M2_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF2_M1)
  .value("PseudoVLOXSEG3EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF2_M2)
  .value("PseudoVLOXSEG3EI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF2_M2_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF2_MF2)
  .value("PseudoVLOXSEG3EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF4_M1)
  .value("PseudoVLOXSEG3EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF4_M2)
  .value("PseudoVLOXSEG3EI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF4_M2_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF4_MF2)
  .value("PseudoVLOXSEG3EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF4_MF4)
  .value("PseudoVLOXSEG3EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF8_M1)
  .value("PseudoVLOXSEG3EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF8_M1_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF8_MF2)
  .value("PseudoVLOXSEG3EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF8_MF2_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF8_MF4)
  .value("PseudoVLOXSEG3EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF8_MF4_MASK)
  .value("PseudoVLOXSEG3EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF8_MF8)
  .value("PseudoVLOXSEG3EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG3EI8_V_MF8_MF8_MASK)
  .value("PseudoVLOXSEG4EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M1_M1)
  .value("PseudoVLOXSEG4EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M1_M1_MASK)
  .value("PseudoVLOXSEG4EI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M1_M2)
  .value("PseudoVLOXSEG4EI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M1_M2_MASK)
  .value("PseudoVLOXSEG4EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M1_MF2)
  .value("PseudoVLOXSEG4EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG4EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M2_M1)
  .value("PseudoVLOXSEG4EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M2_M1_MASK)
  .value("PseudoVLOXSEG4EI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M2_M2)
  .value("PseudoVLOXSEG4EI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M2_M2_MASK)
  .value("PseudoVLOXSEG4EI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M4_M2)
  .value("PseudoVLOXSEG4EI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_M4_M2_MASK)
  .value("PseudoVLOXSEG4EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF2_M1)
  .value("PseudoVLOXSEG4EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG4EI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF2_M2)
  .value("PseudoVLOXSEG4EI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF2_M2_MASK)
  .value("PseudoVLOXSEG4EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF2_MF2)
  .value("PseudoVLOXSEG4EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG4EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF2_MF4)
  .value("PseudoVLOXSEG4EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG4EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF4_M1)
  .value("PseudoVLOXSEG4EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG4EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF4_MF2)
  .value("PseudoVLOXSEG4EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG4EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF4_MF4)
  .value("PseudoVLOXSEG4EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG4EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF4_MF8)
  .value("PseudoVLOXSEG4EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI16_V_MF4_MF8_MASK)
  .value("PseudoVLOXSEG4EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M1_M1)
  .value("PseudoVLOXSEG4EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M1_M1_MASK)
  .value("PseudoVLOXSEG4EI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M1_M2)
  .value("PseudoVLOXSEG4EI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M1_M2_MASK)
  .value("PseudoVLOXSEG4EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M1_MF2)
  .value("PseudoVLOXSEG4EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG4EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M1_MF4)
  .value("PseudoVLOXSEG4EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG4EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M2_M1)
  .value("PseudoVLOXSEG4EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M2_M1_MASK)
  .value("PseudoVLOXSEG4EI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M2_M2)
  .value("PseudoVLOXSEG4EI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M2_M2_MASK)
  .value("PseudoVLOXSEG4EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M2_MF2)
  .value("PseudoVLOXSEG4EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG4EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M4_M1)
  .value("PseudoVLOXSEG4EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M4_M1_MASK)
  .value("PseudoVLOXSEG4EI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M4_M2)
  .value("PseudoVLOXSEG4EI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M4_M2_MASK)
  .value("PseudoVLOXSEG4EI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M8_M2)
  .value("PseudoVLOXSEG4EI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_M8_M2_MASK)
  .value("PseudoVLOXSEG4EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_MF2_M1)
  .value("PseudoVLOXSEG4EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG4EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_MF2_MF2)
  .value("PseudoVLOXSEG4EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG4EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_MF2_MF4)
  .value("PseudoVLOXSEG4EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG4EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_MF2_MF8)
  .value("PseudoVLOXSEG4EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI32_V_MF2_MF8_MASK)
  .value("PseudoVLOXSEG4EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M1_M1)
  .value("PseudoVLOXSEG4EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M1_M1_MASK)
  .value("PseudoVLOXSEG4EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M1_MF2)
  .value("PseudoVLOXSEG4EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG4EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M1_MF4)
  .value("PseudoVLOXSEG4EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG4EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M1_MF8)
  .value("PseudoVLOXSEG4EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M1_MF8_MASK)
  .value("PseudoVLOXSEG4EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M2_M1)
  .value("PseudoVLOXSEG4EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M2_M1_MASK)
  .value("PseudoVLOXSEG4EI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M2_M2)
  .value("PseudoVLOXSEG4EI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M2_M2_MASK)
  .value("PseudoVLOXSEG4EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M2_MF2)
  .value("PseudoVLOXSEG4EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG4EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M2_MF4)
  .value("PseudoVLOXSEG4EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M2_MF4_MASK)
  .value("PseudoVLOXSEG4EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M4_M1)
  .value("PseudoVLOXSEG4EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M4_M1_MASK)
  .value("PseudoVLOXSEG4EI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M4_M2)
  .value("PseudoVLOXSEG4EI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M4_M2_MASK)
  .value("PseudoVLOXSEG4EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M4_MF2)
  .value("PseudoVLOXSEG4EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M4_MF2_MASK)
  .value("PseudoVLOXSEG4EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M8_M1)
  .value("PseudoVLOXSEG4EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M8_M1_MASK)
  .value("PseudoVLOXSEG4EI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M8_M2)
  .value("PseudoVLOXSEG4EI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI64_V_M8_M2_MASK)
  .value("PseudoVLOXSEG4EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_M1_M1)
  .value("PseudoVLOXSEG4EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_M1_M1_MASK)
  .value("PseudoVLOXSEG4EI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_M1_M2)
  .value("PseudoVLOXSEG4EI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_M1_M2_MASK)
  .value("PseudoVLOXSEG4EI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_M2_M2)
  .value("PseudoVLOXSEG4EI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_M2_M2_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF2_M1)
  .value("PseudoVLOXSEG4EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF2_M2)
  .value("PseudoVLOXSEG4EI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF2_M2_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF2_MF2)
  .value("PseudoVLOXSEG4EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF4_M1)
  .value("PseudoVLOXSEG4EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF4_M2)
  .value("PseudoVLOXSEG4EI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF4_M2_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF4_MF2)
  .value("PseudoVLOXSEG4EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF4_MF4)
  .value("PseudoVLOXSEG4EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF8_M1)
  .value("PseudoVLOXSEG4EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF8_M1_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF8_MF2)
  .value("PseudoVLOXSEG4EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF8_MF2_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF8_MF4)
  .value("PseudoVLOXSEG4EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF8_MF4_MASK)
  .value("PseudoVLOXSEG4EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF8_MF8)
  .value("PseudoVLOXSEG4EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG4EI8_V_MF8_MF8_MASK)
  .value("PseudoVLOXSEG5EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_M1_M1)
  .value("PseudoVLOXSEG5EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_M1_M1_MASK)
  .value("PseudoVLOXSEG5EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_M1_MF2)
  .value("PseudoVLOXSEG5EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG5EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_M2_M1)
  .value("PseudoVLOXSEG5EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_M2_M1_MASK)
  .value("PseudoVLOXSEG5EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF2_M1)
  .value("PseudoVLOXSEG5EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG5EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF2_MF2)
  .value("PseudoVLOXSEG5EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG5EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF2_MF4)
  .value("PseudoVLOXSEG5EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG5EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF4_M1)
  .value("PseudoVLOXSEG5EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG5EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF4_MF2)
  .value("PseudoVLOXSEG5EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG5EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF4_MF4)
  .value("PseudoVLOXSEG5EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG5EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF4_MF8)
  .value("PseudoVLOXSEG5EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI16_V_MF4_MF8_MASK)
  .value("PseudoVLOXSEG5EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M1_M1)
  .value("PseudoVLOXSEG5EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M1_M1_MASK)
  .value("PseudoVLOXSEG5EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M1_MF2)
  .value("PseudoVLOXSEG5EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG5EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M1_MF4)
  .value("PseudoVLOXSEG5EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG5EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M2_M1)
  .value("PseudoVLOXSEG5EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M2_M1_MASK)
  .value("PseudoVLOXSEG5EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M2_MF2)
  .value("PseudoVLOXSEG5EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG5EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M4_M1)
  .value("PseudoVLOXSEG5EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_M4_M1_MASK)
  .value("PseudoVLOXSEG5EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_MF2_M1)
  .value("PseudoVLOXSEG5EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG5EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_MF2_MF2)
  .value("PseudoVLOXSEG5EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_MF2_MF2_MASK);
  opcodes.value("PseudoVLOXSEG5EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_MF2_MF4)
  .value("PseudoVLOXSEG5EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG5EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_MF2_MF8)
  .value("PseudoVLOXSEG5EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI32_V_MF2_MF8_MASK)
  .value("PseudoVLOXSEG5EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M1_M1)
  .value("PseudoVLOXSEG5EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M1_M1_MASK)
  .value("PseudoVLOXSEG5EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M1_MF2)
  .value("PseudoVLOXSEG5EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG5EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M1_MF4)
  .value("PseudoVLOXSEG5EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG5EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M1_MF8)
  .value("PseudoVLOXSEG5EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M1_MF8_MASK)
  .value("PseudoVLOXSEG5EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M2_M1)
  .value("PseudoVLOXSEG5EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M2_M1_MASK)
  .value("PseudoVLOXSEG5EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M2_MF2)
  .value("PseudoVLOXSEG5EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG5EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M2_MF4)
  .value("PseudoVLOXSEG5EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M2_MF4_MASK)
  .value("PseudoVLOXSEG5EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M4_M1)
  .value("PseudoVLOXSEG5EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M4_M1_MASK)
  .value("PseudoVLOXSEG5EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M4_MF2)
  .value("PseudoVLOXSEG5EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M4_MF2_MASK)
  .value("PseudoVLOXSEG5EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M8_M1)
  .value("PseudoVLOXSEG5EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI64_V_M8_M1_MASK)
  .value("PseudoVLOXSEG5EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_M1_M1)
  .value("PseudoVLOXSEG5EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_M1_M1_MASK)
  .value("PseudoVLOXSEG5EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF2_M1)
  .value("PseudoVLOXSEG5EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG5EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF2_MF2)
  .value("PseudoVLOXSEG5EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG5EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF4_M1)
  .value("PseudoVLOXSEG5EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG5EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF4_MF2)
  .value("PseudoVLOXSEG5EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG5EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF4_MF4)
  .value("PseudoVLOXSEG5EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG5EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF8_M1)
  .value("PseudoVLOXSEG5EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF8_M1_MASK)
  .value("PseudoVLOXSEG5EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF8_MF2)
  .value("PseudoVLOXSEG5EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF8_MF2_MASK)
  .value("PseudoVLOXSEG5EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF8_MF4)
  .value("PseudoVLOXSEG5EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF8_MF4_MASK)
  .value("PseudoVLOXSEG5EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF8_MF8)
  .value("PseudoVLOXSEG5EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG5EI8_V_MF8_MF8_MASK)
  .value("PseudoVLOXSEG6EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_M1_M1)
  .value("PseudoVLOXSEG6EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_M1_M1_MASK)
  .value("PseudoVLOXSEG6EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_M1_MF2)
  .value("PseudoVLOXSEG6EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG6EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_M2_M1)
  .value("PseudoVLOXSEG6EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_M2_M1_MASK)
  .value("PseudoVLOXSEG6EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF2_M1)
  .value("PseudoVLOXSEG6EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG6EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF2_MF2)
  .value("PseudoVLOXSEG6EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG6EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF2_MF4)
  .value("PseudoVLOXSEG6EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG6EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF4_M1)
  .value("PseudoVLOXSEG6EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG6EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF4_MF2)
  .value("PseudoVLOXSEG6EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG6EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF4_MF4)
  .value("PseudoVLOXSEG6EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG6EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF4_MF8)
  .value("PseudoVLOXSEG6EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI16_V_MF4_MF8_MASK)
  .value("PseudoVLOXSEG6EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M1_M1)
  .value("PseudoVLOXSEG6EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M1_M1_MASK)
  .value("PseudoVLOXSEG6EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M1_MF2)
  .value("PseudoVLOXSEG6EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG6EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M1_MF4)
  .value("PseudoVLOXSEG6EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG6EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M2_M1)
  .value("PseudoVLOXSEG6EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M2_M1_MASK)
  .value("PseudoVLOXSEG6EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M2_MF2)
  .value("PseudoVLOXSEG6EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG6EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M4_M1)
  .value("PseudoVLOXSEG6EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_M4_M1_MASK)
  .value("PseudoVLOXSEG6EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_MF2_M1)
  .value("PseudoVLOXSEG6EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG6EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_MF2_MF2)
  .value("PseudoVLOXSEG6EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG6EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_MF2_MF4)
  .value("PseudoVLOXSEG6EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG6EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_MF2_MF8)
  .value("PseudoVLOXSEG6EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI32_V_MF2_MF8_MASK)
  .value("PseudoVLOXSEG6EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M1_M1)
  .value("PseudoVLOXSEG6EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M1_M1_MASK)
  .value("PseudoVLOXSEG6EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M1_MF2)
  .value("PseudoVLOXSEG6EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG6EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M1_MF4)
  .value("PseudoVLOXSEG6EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG6EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M1_MF8)
  .value("PseudoVLOXSEG6EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M1_MF8_MASK)
  .value("PseudoVLOXSEG6EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M2_M1)
  .value("PseudoVLOXSEG6EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M2_M1_MASK)
  .value("PseudoVLOXSEG6EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M2_MF2)
  .value("PseudoVLOXSEG6EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG6EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M2_MF4)
  .value("PseudoVLOXSEG6EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M2_MF4_MASK)
  .value("PseudoVLOXSEG6EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M4_M1)
  .value("PseudoVLOXSEG6EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M4_M1_MASK)
  .value("PseudoVLOXSEG6EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M4_MF2)
  .value("PseudoVLOXSEG6EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M4_MF2_MASK)
  .value("PseudoVLOXSEG6EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M8_M1)
  .value("PseudoVLOXSEG6EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI64_V_M8_M1_MASK)
  .value("PseudoVLOXSEG6EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_M1_M1)
  .value("PseudoVLOXSEG6EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_M1_M1_MASK)
  .value("PseudoVLOXSEG6EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF2_M1)
  .value("PseudoVLOXSEG6EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG6EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF2_MF2)
  .value("PseudoVLOXSEG6EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG6EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF4_M1)
  .value("PseudoVLOXSEG6EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG6EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF4_MF2)
  .value("PseudoVLOXSEG6EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG6EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF4_MF4)
  .value("PseudoVLOXSEG6EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG6EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF8_M1)
  .value("PseudoVLOXSEG6EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF8_M1_MASK)
  .value("PseudoVLOXSEG6EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF8_MF2)
  .value("PseudoVLOXSEG6EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF8_MF2_MASK)
  .value("PseudoVLOXSEG6EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF8_MF4)
  .value("PseudoVLOXSEG6EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF8_MF4_MASK)
  .value("PseudoVLOXSEG6EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF8_MF8)
  .value("PseudoVLOXSEG6EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG6EI8_V_MF8_MF8_MASK)
  .value("PseudoVLOXSEG7EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_M1_M1)
  .value("PseudoVLOXSEG7EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_M1_M1_MASK)
  .value("PseudoVLOXSEG7EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_M1_MF2)
  .value("PseudoVLOXSEG7EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG7EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_M2_M1)
  .value("PseudoVLOXSEG7EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_M2_M1_MASK)
  .value("PseudoVLOXSEG7EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF2_M1)
  .value("PseudoVLOXSEG7EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG7EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF2_MF2)
  .value("PseudoVLOXSEG7EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG7EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF2_MF4)
  .value("PseudoVLOXSEG7EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG7EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF4_M1)
  .value("PseudoVLOXSEG7EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG7EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF4_MF2)
  .value("PseudoVLOXSEG7EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG7EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF4_MF4)
  .value("PseudoVLOXSEG7EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG7EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF4_MF8)
  .value("PseudoVLOXSEG7EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI16_V_MF4_MF8_MASK)
  .value("PseudoVLOXSEG7EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M1_M1)
  .value("PseudoVLOXSEG7EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M1_M1_MASK)
  .value("PseudoVLOXSEG7EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M1_MF2)
  .value("PseudoVLOXSEG7EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG7EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M1_MF4)
  .value("PseudoVLOXSEG7EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG7EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M2_M1)
  .value("PseudoVLOXSEG7EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M2_M1_MASK)
  .value("PseudoVLOXSEG7EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M2_MF2)
  .value("PseudoVLOXSEG7EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG7EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M4_M1)
  .value("PseudoVLOXSEG7EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_M4_M1_MASK)
  .value("PseudoVLOXSEG7EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_MF2_M1)
  .value("PseudoVLOXSEG7EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG7EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_MF2_MF2)
  .value("PseudoVLOXSEG7EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG7EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_MF2_MF4)
  .value("PseudoVLOXSEG7EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG7EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_MF2_MF8)
  .value("PseudoVLOXSEG7EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI32_V_MF2_MF8_MASK)
  .value("PseudoVLOXSEG7EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M1_M1)
  .value("PseudoVLOXSEG7EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M1_M1_MASK)
  .value("PseudoVLOXSEG7EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M1_MF2)
  .value("PseudoVLOXSEG7EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG7EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M1_MF4)
  .value("PseudoVLOXSEG7EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG7EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M1_MF8)
  .value("PseudoVLOXSEG7EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M1_MF8_MASK)
  .value("PseudoVLOXSEG7EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M2_M1)
  .value("PseudoVLOXSEG7EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M2_M1_MASK)
  .value("PseudoVLOXSEG7EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M2_MF2)
  .value("PseudoVLOXSEG7EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG7EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M2_MF4)
  .value("PseudoVLOXSEG7EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M2_MF4_MASK)
  .value("PseudoVLOXSEG7EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M4_M1)
  .value("PseudoVLOXSEG7EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M4_M1_MASK)
  .value("PseudoVLOXSEG7EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M4_MF2)
  .value("PseudoVLOXSEG7EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M4_MF2_MASK)
  .value("PseudoVLOXSEG7EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M8_M1)
  .value("PseudoVLOXSEG7EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI64_V_M8_M1_MASK)
  .value("PseudoVLOXSEG7EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_M1_M1)
  .value("PseudoVLOXSEG7EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_M1_M1_MASK)
  .value("PseudoVLOXSEG7EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF2_M1)
  .value("PseudoVLOXSEG7EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG7EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF2_MF2)
  .value("PseudoVLOXSEG7EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG7EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF4_M1)
  .value("PseudoVLOXSEG7EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG7EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF4_MF2)
  .value("PseudoVLOXSEG7EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG7EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF4_MF4)
  .value("PseudoVLOXSEG7EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG7EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF8_M1)
  .value("PseudoVLOXSEG7EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF8_M1_MASK)
  .value("PseudoVLOXSEG7EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF8_MF2)
  .value("PseudoVLOXSEG7EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF8_MF2_MASK)
  .value("PseudoVLOXSEG7EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF8_MF4)
  .value("PseudoVLOXSEG7EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF8_MF4_MASK)
  .value("PseudoVLOXSEG7EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF8_MF8)
  .value("PseudoVLOXSEG7EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG7EI8_V_MF8_MF8_MASK)
  .value("PseudoVLOXSEG8EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_M1_M1)
  .value("PseudoVLOXSEG8EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_M1_M1_MASK)
  .value("PseudoVLOXSEG8EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_M1_MF2)
  .value("PseudoVLOXSEG8EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG8EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_M2_M1)
  .value("PseudoVLOXSEG8EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_M2_M1_MASK)
  .value("PseudoVLOXSEG8EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF2_M1)
  .value("PseudoVLOXSEG8EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG8EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF2_MF2)
  .value("PseudoVLOXSEG8EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG8EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF2_MF4)
  .value("PseudoVLOXSEG8EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG8EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF4_M1)
  .value("PseudoVLOXSEG8EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG8EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF4_MF2)
  .value("PseudoVLOXSEG8EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG8EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF4_MF4)
  .value("PseudoVLOXSEG8EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG8EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF4_MF8)
  .value("PseudoVLOXSEG8EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI16_V_MF4_MF8_MASK)
  .value("PseudoVLOXSEG8EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M1_M1)
  .value("PseudoVLOXSEG8EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M1_M1_MASK)
  .value("PseudoVLOXSEG8EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M1_MF2)
  .value("PseudoVLOXSEG8EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG8EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M1_MF4)
  .value("PseudoVLOXSEG8EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG8EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M2_M1)
  .value("PseudoVLOXSEG8EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M2_M1_MASK)
  .value("PseudoVLOXSEG8EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M2_MF2)
  .value("PseudoVLOXSEG8EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG8EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M4_M1)
  .value("PseudoVLOXSEG8EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_M4_M1_MASK)
  .value("PseudoVLOXSEG8EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_MF2_M1)
  .value("PseudoVLOXSEG8EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG8EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_MF2_MF2)
  .value("PseudoVLOXSEG8EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG8EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_MF2_MF4)
  .value("PseudoVLOXSEG8EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_MF2_MF4_MASK)
  .value("PseudoVLOXSEG8EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_MF2_MF8)
  .value("PseudoVLOXSEG8EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI32_V_MF2_MF8_MASK)
  .value("PseudoVLOXSEG8EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M1_M1)
  .value("PseudoVLOXSEG8EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M1_M1_MASK)
  .value("PseudoVLOXSEG8EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M1_MF2)
  .value("PseudoVLOXSEG8EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M1_MF2_MASK)
  .value("PseudoVLOXSEG8EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M1_MF4)
  .value("PseudoVLOXSEG8EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M1_MF4_MASK)
  .value("PseudoVLOXSEG8EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M1_MF8)
  .value("PseudoVLOXSEG8EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M1_MF8_MASK)
  .value("PseudoVLOXSEG8EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M2_M1)
  .value("PseudoVLOXSEG8EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M2_M1_MASK)
  .value("PseudoVLOXSEG8EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M2_MF2)
  .value("PseudoVLOXSEG8EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M2_MF2_MASK)
  .value("PseudoVLOXSEG8EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M2_MF4)
  .value("PseudoVLOXSEG8EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M2_MF4_MASK)
  .value("PseudoVLOXSEG8EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M4_M1)
  .value("PseudoVLOXSEG8EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M4_M1_MASK)
  .value("PseudoVLOXSEG8EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M4_MF2)
  .value("PseudoVLOXSEG8EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M4_MF2_MASK)
  .value("PseudoVLOXSEG8EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M8_M1)
  .value("PseudoVLOXSEG8EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI64_V_M8_M1_MASK)
  .value("PseudoVLOXSEG8EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_M1_M1)
  .value("PseudoVLOXSEG8EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_M1_M1_MASK)
  .value("PseudoVLOXSEG8EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF2_M1)
  .value("PseudoVLOXSEG8EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF2_M1_MASK)
  .value("PseudoVLOXSEG8EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF2_MF2)
  .value("PseudoVLOXSEG8EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF2_MF2_MASK)
  .value("PseudoVLOXSEG8EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF4_M1)
  .value("PseudoVLOXSEG8EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF4_M1_MASK)
  .value("PseudoVLOXSEG8EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF4_MF2)
  .value("PseudoVLOXSEG8EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF4_MF2_MASK)
  .value("PseudoVLOXSEG8EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF4_MF4)
  .value("PseudoVLOXSEG8EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF4_MF4_MASK)
  .value("PseudoVLOXSEG8EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF8_M1)
  .value("PseudoVLOXSEG8EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF8_M1_MASK)
  .value("PseudoVLOXSEG8EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF8_MF2)
  .value("PseudoVLOXSEG8EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF8_MF2_MASK)
  .value("PseudoVLOXSEG8EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF8_MF4)
  .value("PseudoVLOXSEG8EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF8_MF4_MASK)
  .value("PseudoVLOXSEG8EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF8_MF8)
  .value("PseudoVLOXSEG8EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLOXSEG8EI8_V_MF8_MF8_MASK)
  .value("PseudoVLSE16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_M1)
  .value("PseudoVLSE16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_M1_MASK)
  .value("PseudoVLSE16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_M2)
  .value("PseudoVLSE16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_M2_MASK)
  .value("PseudoVLSE16_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_M4)
  .value("PseudoVLSE16_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_M4_MASK)
  .value("PseudoVLSE16_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_M8)
  .value("PseudoVLSE16_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_M8_MASK)
  .value("PseudoVLSE16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_MF2)
  .value("PseudoVLSE16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_MF2_MASK)
  .value("PseudoVLSE16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_MF4)
  .value("PseudoVLSE16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE16_V_MF4_MASK)
  .value("PseudoVLSE32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSE32_V_M1)
  .value("PseudoVLSE32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE32_V_M1_MASK)
  .value("PseudoVLSE32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSE32_V_M2)
  .value("PseudoVLSE32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE32_V_M2_MASK);
  opcodes.value("PseudoVLSE32_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSE32_V_M4)
  .value("PseudoVLSE32_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE32_V_M4_MASK)
  .value("PseudoVLSE32_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLSE32_V_M8)
  .value("PseudoVLSE32_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE32_V_M8_MASK)
  .value("PseudoVLSE32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSE32_V_MF2)
  .value("PseudoVLSE32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE32_V_MF2_MASK)
  .value("PseudoVLSE64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSE64_V_M1)
  .value("PseudoVLSE64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE64_V_M1_MASK)
  .value("PseudoVLSE64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSE64_V_M2)
  .value("PseudoVLSE64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE64_V_M2_MASK)
  .value("PseudoVLSE64_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSE64_V_M4)
  .value("PseudoVLSE64_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE64_V_M4_MASK)
  .value("PseudoVLSE64_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLSE64_V_M8)
  .value("PseudoVLSE64_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE64_V_M8_MASK)
  .value("PseudoVLSE8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_M1)
  .value("PseudoVLSE8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_M1_MASK)
  .value("PseudoVLSE8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_M2)
  .value("PseudoVLSE8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_M2_MASK)
  .value("PseudoVLSE8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_M4)
  .value("PseudoVLSE8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_M4_MASK)
  .value("PseudoVLSE8_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_M8)
  .value("PseudoVLSE8_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_M8_MASK)
  .value("PseudoVLSE8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_MF2)
  .value("PseudoVLSE8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_MF2_MASK)
  .value("PseudoVLSE8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_MF4)
  .value("PseudoVLSE8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_MF4_MASK)
  .value("PseudoVLSE8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_MF8)
  .value("PseudoVLSE8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSE8_V_MF8_MASK)
  .value("PseudoVLSEG2E16FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16FF_V_M1)
  .value("PseudoVLSEG2E16FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16FF_V_M1_MASK)
  .value("PseudoVLSEG2E16FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16FF_V_M2)
  .value("PseudoVLSEG2E16FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16FF_V_M2_MASK)
  .value("PseudoVLSEG2E16FF_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16FF_V_M4)
  .value("PseudoVLSEG2E16FF_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16FF_V_M4_MASK)
  .value("PseudoVLSEG2E16FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16FF_V_MF2)
  .value("PseudoVLSEG2E16FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16FF_V_MF2_MASK)
  .value("PseudoVLSEG2E16FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16FF_V_MF4)
  .value("PseudoVLSEG2E16FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16FF_V_MF4_MASK)
  .value("PseudoVLSEG2E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16_V_M1)
  .value("PseudoVLSEG2E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16_V_M1_MASK)
  .value("PseudoVLSEG2E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16_V_M2)
  .value("PseudoVLSEG2E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16_V_M2_MASK)
  .value("PseudoVLSEG2E16_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16_V_M4)
  .value("PseudoVLSEG2E16_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16_V_M4_MASK)
  .value("PseudoVLSEG2E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16_V_MF2)
  .value("PseudoVLSEG2E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16_V_MF2_MASK)
  .value("PseudoVLSEG2E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16_V_MF4)
  .value("PseudoVLSEG2E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E16_V_MF4_MASK)
  .value("PseudoVLSEG2E32FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32FF_V_M1)
  .value("PseudoVLSEG2E32FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32FF_V_M1_MASK)
  .value("PseudoVLSEG2E32FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32FF_V_M2)
  .value("PseudoVLSEG2E32FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32FF_V_M2_MASK)
  .value("PseudoVLSEG2E32FF_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32FF_V_M4)
  .value("PseudoVLSEG2E32FF_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32FF_V_M4_MASK)
  .value("PseudoVLSEG2E32FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32FF_V_MF2)
  .value("PseudoVLSEG2E32FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32FF_V_MF2_MASK)
  .value("PseudoVLSEG2E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32_V_M1)
  .value("PseudoVLSEG2E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32_V_M1_MASK)
  .value("PseudoVLSEG2E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32_V_M2)
  .value("PseudoVLSEG2E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32_V_M2_MASK)
  .value("PseudoVLSEG2E32_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32_V_M4)
  .value("PseudoVLSEG2E32_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32_V_M4_MASK)
  .value("PseudoVLSEG2E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32_V_MF2)
  .value("PseudoVLSEG2E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E32_V_MF2_MASK)
  .value("PseudoVLSEG2E64FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64FF_V_M1)
  .value("PseudoVLSEG2E64FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64FF_V_M1_MASK)
  .value("PseudoVLSEG2E64FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64FF_V_M2)
  .value("PseudoVLSEG2E64FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64FF_V_M2_MASK)
  .value("PseudoVLSEG2E64FF_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64FF_V_M4)
  .value("PseudoVLSEG2E64FF_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64FF_V_M4_MASK)
  .value("PseudoVLSEG2E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64_V_M1)
  .value("PseudoVLSEG2E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64_V_M1_MASK)
  .value("PseudoVLSEG2E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64_V_M2)
  .value("PseudoVLSEG2E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64_V_M2_MASK)
  .value("PseudoVLSEG2E64_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64_V_M4)
  .value("PseudoVLSEG2E64_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E64_V_M4_MASK)
  .value("PseudoVLSEG2E8FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_M1)
  .value("PseudoVLSEG2E8FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_M1_MASK)
  .value("PseudoVLSEG2E8FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_M2)
  .value("PseudoVLSEG2E8FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_M2_MASK)
  .value("PseudoVLSEG2E8FF_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_M4)
  .value("PseudoVLSEG2E8FF_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_M4_MASK)
  .value("PseudoVLSEG2E8FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_MF2)
  .value("PseudoVLSEG2E8FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_MF2_MASK)
  .value("PseudoVLSEG2E8FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_MF4)
  .value("PseudoVLSEG2E8FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_MF4_MASK)
  .value("PseudoVLSEG2E8FF_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_MF8)
  .value("PseudoVLSEG2E8FF_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8FF_V_MF8_MASK)
  .value("PseudoVLSEG2E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_M1)
  .value("PseudoVLSEG2E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_M1_MASK)
  .value("PseudoVLSEG2E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_M2)
  .value("PseudoVLSEG2E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_M2_MASK)
  .value("PseudoVLSEG2E8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_M4)
  .value("PseudoVLSEG2E8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_M4_MASK)
  .value("PseudoVLSEG2E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_MF2)
  .value("PseudoVLSEG2E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_MF2_MASK)
  .value("PseudoVLSEG2E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_MF4)
  .value("PseudoVLSEG2E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_MF4_MASK)
  .value("PseudoVLSEG2E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_MF8)
  .value("PseudoVLSEG2E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG2E8_V_MF8_MASK)
  .value("PseudoVLSEG3E16FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16FF_V_M1)
  .value("PseudoVLSEG3E16FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16FF_V_M1_MASK)
  .value("PseudoVLSEG3E16FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16FF_V_M2)
  .value("PseudoVLSEG3E16FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16FF_V_M2_MASK)
  .value("PseudoVLSEG3E16FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16FF_V_MF2)
  .value("PseudoVLSEG3E16FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16FF_V_MF2_MASK)
  .value("PseudoVLSEG3E16FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16FF_V_MF4)
  .value("PseudoVLSEG3E16FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16FF_V_MF4_MASK)
  .value("PseudoVLSEG3E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16_V_M1)
  .value("PseudoVLSEG3E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16_V_M1_MASK)
  .value("PseudoVLSEG3E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16_V_M2)
  .value("PseudoVLSEG3E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16_V_M2_MASK)
  .value("PseudoVLSEG3E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16_V_MF2)
  .value("PseudoVLSEG3E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16_V_MF2_MASK)
  .value("PseudoVLSEG3E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16_V_MF4)
  .value("PseudoVLSEG3E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E16_V_MF4_MASK)
  .value("PseudoVLSEG3E32FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32FF_V_M1)
  .value("PseudoVLSEG3E32FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32FF_V_M1_MASK)
  .value("PseudoVLSEG3E32FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32FF_V_M2)
  .value("PseudoVLSEG3E32FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32FF_V_M2_MASK)
  .value("PseudoVLSEG3E32FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32FF_V_MF2)
  .value("PseudoVLSEG3E32FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32FF_V_MF2_MASK)
  .value("PseudoVLSEG3E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32_V_M1)
  .value("PseudoVLSEG3E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32_V_M1_MASK)
  .value("PseudoVLSEG3E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32_V_M2)
  .value("PseudoVLSEG3E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32_V_M2_MASK)
  .value("PseudoVLSEG3E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32_V_MF2)
  .value("PseudoVLSEG3E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E32_V_MF2_MASK)
  .value("PseudoVLSEG3E64FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E64FF_V_M1)
  .value("PseudoVLSEG3E64FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E64FF_V_M1_MASK)
  .value("PseudoVLSEG3E64FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E64FF_V_M2)
  .value("PseudoVLSEG3E64FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E64FF_V_M2_MASK)
  .value("PseudoVLSEG3E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E64_V_M1)
  .value("PseudoVLSEG3E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E64_V_M1_MASK)
  .value("PseudoVLSEG3E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E64_V_M2)
  .value("PseudoVLSEG3E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E64_V_M2_MASK)
  .value("PseudoVLSEG3E8FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8FF_V_M1)
  .value("PseudoVLSEG3E8FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8FF_V_M1_MASK)
  .value("PseudoVLSEG3E8FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8FF_V_M2)
  .value("PseudoVLSEG3E8FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8FF_V_M2_MASK)
  .value("PseudoVLSEG3E8FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8FF_V_MF2)
  .value("PseudoVLSEG3E8FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8FF_V_MF2_MASK)
  .value("PseudoVLSEG3E8FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8FF_V_MF4)
  .value("PseudoVLSEG3E8FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8FF_V_MF4_MASK)
  .value("PseudoVLSEG3E8FF_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8FF_V_MF8)
  .value("PseudoVLSEG3E8FF_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8FF_V_MF8_MASK)
  .value("PseudoVLSEG3E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8_V_M1)
  .value("PseudoVLSEG3E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8_V_M1_MASK)
  .value("PseudoVLSEG3E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8_V_M2)
  .value("PseudoVLSEG3E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8_V_M2_MASK)
  .value("PseudoVLSEG3E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8_V_MF2)
  .value("PseudoVLSEG3E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8_V_MF2_MASK)
  .value("PseudoVLSEG3E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8_V_MF4)
  .value("PseudoVLSEG3E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8_V_MF4_MASK)
  .value("PseudoVLSEG3E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8_V_MF8)
  .value("PseudoVLSEG3E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG3E8_V_MF8_MASK)
  .value("PseudoVLSEG4E16FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16FF_V_M1)
  .value("PseudoVLSEG4E16FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16FF_V_M1_MASK)
  .value("PseudoVLSEG4E16FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16FF_V_M2)
  .value("PseudoVLSEG4E16FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16FF_V_M2_MASK)
  .value("PseudoVLSEG4E16FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16FF_V_MF2)
  .value("PseudoVLSEG4E16FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16FF_V_MF2_MASK)
  .value("PseudoVLSEG4E16FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16FF_V_MF4)
  .value("PseudoVLSEG4E16FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16FF_V_MF4_MASK)
  .value("PseudoVLSEG4E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16_V_M1)
  .value("PseudoVLSEG4E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16_V_M1_MASK)
  .value("PseudoVLSEG4E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16_V_M2)
  .value("PseudoVLSEG4E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16_V_M2_MASK)
  .value("PseudoVLSEG4E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16_V_MF2)
  .value("PseudoVLSEG4E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16_V_MF2_MASK)
  .value("PseudoVLSEG4E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16_V_MF4)
  .value("PseudoVLSEG4E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E16_V_MF4_MASK)
  .value("PseudoVLSEG4E32FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32FF_V_M1)
  .value("PseudoVLSEG4E32FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32FF_V_M1_MASK)
  .value("PseudoVLSEG4E32FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32FF_V_M2)
  .value("PseudoVLSEG4E32FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32FF_V_M2_MASK)
  .value("PseudoVLSEG4E32FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32FF_V_MF2)
  .value("PseudoVLSEG4E32FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32FF_V_MF2_MASK)
  .value("PseudoVLSEG4E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32_V_M1)
  .value("PseudoVLSEG4E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32_V_M1_MASK)
  .value("PseudoVLSEG4E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32_V_M2)
  .value("PseudoVLSEG4E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32_V_M2_MASK)
  .value("PseudoVLSEG4E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32_V_MF2)
  .value("PseudoVLSEG4E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E32_V_MF2_MASK)
  .value("PseudoVLSEG4E64FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E64FF_V_M1)
  .value("PseudoVLSEG4E64FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E64FF_V_M1_MASK)
  .value("PseudoVLSEG4E64FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E64FF_V_M2)
  .value("PseudoVLSEG4E64FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E64FF_V_M2_MASK)
  .value("PseudoVLSEG4E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E64_V_M1)
  .value("PseudoVLSEG4E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E64_V_M1_MASK)
  .value("PseudoVLSEG4E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E64_V_M2)
  .value("PseudoVLSEG4E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E64_V_M2_MASK)
  .value("PseudoVLSEG4E8FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8FF_V_M1)
  .value("PseudoVLSEG4E8FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8FF_V_M1_MASK)
  .value("PseudoVLSEG4E8FF_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8FF_V_M2)
  .value("PseudoVLSEG4E8FF_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8FF_V_M2_MASK)
  .value("PseudoVLSEG4E8FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8FF_V_MF2)
  .value("PseudoVLSEG4E8FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8FF_V_MF2_MASK)
  .value("PseudoVLSEG4E8FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8FF_V_MF4)
  .value("PseudoVLSEG4E8FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8FF_V_MF4_MASK)
  .value("PseudoVLSEG4E8FF_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8FF_V_MF8)
  .value("PseudoVLSEG4E8FF_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8FF_V_MF8_MASK)
  .value("PseudoVLSEG4E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8_V_M1)
  .value("PseudoVLSEG4E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8_V_M1_MASK)
  .value("PseudoVLSEG4E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8_V_M2)
  .value("PseudoVLSEG4E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8_V_M2_MASK)
  .value("PseudoVLSEG4E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8_V_MF2)
  .value("PseudoVLSEG4E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8_V_MF2_MASK)
  .value("PseudoVLSEG4E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8_V_MF4)
  .value("PseudoVLSEG4E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8_V_MF4_MASK)
  .value("PseudoVLSEG4E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8_V_MF8)
  .value("PseudoVLSEG4E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG4E8_V_MF8_MASK)
  .value("PseudoVLSEG5E16FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16FF_V_M1)
  .value("PseudoVLSEG5E16FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16FF_V_M1_MASK)
  .value("PseudoVLSEG5E16FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16FF_V_MF2)
  .value("PseudoVLSEG5E16FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16FF_V_MF2_MASK)
  .value("PseudoVLSEG5E16FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16FF_V_MF4)
  .value("PseudoVLSEG5E16FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16FF_V_MF4_MASK)
  .value("PseudoVLSEG5E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16_V_M1)
  .value("PseudoVLSEG5E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16_V_M1_MASK)
  .value("PseudoVLSEG5E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16_V_MF2)
  .value("PseudoVLSEG5E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16_V_MF2_MASK)
  .value("PseudoVLSEG5E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16_V_MF4)
  .value("PseudoVLSEG5E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E16_V_MF4_MASK)
  .value("PseudoVLSEG5E32FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E32FF_V_M1)
  .value("PseudoVLSEG5E32FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E32FF_V_M1_MASK)
  .value("PseudoVLSEG5E32FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E32FF_V_MF2)
  .value("PseudoVLSEG5E32FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E32FF_V_MF2_MASK)
  .value("PseudoVLSEG5E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E32_V_M1)
  .value("PseudoVLSEG5E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E32_V_M1_MASK)
  .value("PseudoVLSEG5E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E32_V_MF2)
  .value("PseudoVLSEG5E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E32_V_MF2_MASK)
  .value("PseudoVLSEG5E64FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E64FF_V_M1)
  .value("PseudoVLSEG5E64FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E64FF_V_M1_MASK)
  .value("PseudoVLSEG5E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E64_V_M1)
  .value("PseudoVLSEG5E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E64_V_M1_MASK)
  .value("PseudoVLSEG5E8FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8FF_V_M1)
  .value("PseudoVLSEG5E8FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8FF_V_M1_MASK)
  .value("PseudoVLSEG5E8FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8FF_V_MF2)
  .value("PseudoVLSEG5E8FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8FF_V_MF2_MASK)
  .value("PseudoVLSEG5E8FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8FF_V_MF4)
  .value("PseudoVLSEG5E8FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8FF_V_MF4_MASK)
  .value("PseudoVLSEG5E8FF_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8FF_V_MF8)
  .value("PseudoVLSEG5E8FF_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8FF_V_MF8_MASK)
  .value("PseudoVLSEG5E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8_V_M1)
  .value("PseudoVLSEG5E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8_V_M1_MASK)
  .value("PseudoVLSEG5E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8_V_MF2)
  .value("PseudoVLSEG5E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8_V_MF2_MASK)
  .value("PseudoVLSEG5E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8_V_MF4)
  .value("PseudoVLSEG5E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8_V_MF4_MASK)
  .value("PseudoVLSEG5E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8_V_MF8)
  .value("PseudoVLSEG5E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG5E8_V_MF8_MASK)
  .value("PseudoVLSEG6E16FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16FF_V_M1)
  .value("PseudoVLSEG6E16FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16FF_V_M1_MASK)
  .value("PseudoVLSEG6E16FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16FF_V_MF2)
  .value("PseudoVLSEG6E16FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16FF_V_MF2_MASK)
  .value("PseudoVLSEG6E16FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16FF_V_MF4)
  .value("PseudoVLSEG6E16FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16FF_V_MF4_MASK)
  .value("PseudoVLSEG6E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16_V_M1)
  .value("PseudoVLSEG6E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16_V_M1_MASK)
  .value("PseudoVLSEG6E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16_V_MF2)
  .value("PseudoVLSEG6E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16_V_MF2_MASK)
  .value("PseudoVLSEG6E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16_V_MF4)
  .value("PseudoVLSEG6E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E16_V_MF4_MASK)
  .value("PseudoVLSEG6E32FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E32FF_V_M1)
  .value("PseudoVLSEG6E32FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E32FF_V_M1_MASK)
  .value("PseudoVLSEG6E32FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E32FF_V_MF2)
  .value("PseudoVLSEG6E32FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E32FF_V_MF2_MASK)
  .value("PseudoVLSEG6E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E32_V_M1)
  .value("PseudoVLSEG6E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E32_V_M1_MASK)
  .value("PseudoVLSEG6E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E32_V_MF2)
  .value("PseudoVLSEG6E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E32_V_MF2_MASK)
  .value("PseudoVLSEG6E64FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E64FF_V_M1)
  .value("PseudoVLSEG6E64FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E64FF_V_M1_MASK)
  .value("PseudoVLSEG6E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E64_V_M1)
  .value("PseudoVLSEG6E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E64_V_M1_MASK)
  .value("PseudoVLSEG6E8FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8FF_V_M1)
  .value("PseudoVLSEG6E8FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8FF_V_M1_MASK)
  .value("PseudoVLSEG6E8FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8FF_V_MF2)
  .value("PseudoVLSEG6E8FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8FF_V_MF2_MASK)
  .value("PseudoVLSEG6E8FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8FF_V_MF4)
  .value("PseudoVLSEG6E8FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8FF_V_MF4_MASK)
  .value("PseudoVLSEG6E8FF_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8FF_V_MF8)
  .value("PseudoVLSEG6E8FF_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8FF_V_MF8_MASK)
  .value("PseudoVLSEG6E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8_V_M1)
  .value("PseudoVLSEG6E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8_V_M1_MASK)
  .value("PseudoVLSEG6E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8_V_MF2)
  .value("PseudoVLSEG6E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8_V_MF2_MASK)
  .value("PseudoVLSEG6E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8_V_MF4)
  .value("PseudoVLSEG6E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8_V_MF4_MASK)
  .value("PseudoVLSEG6E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8_V_MF8)
  .value("PseudoVLSEG6E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG6E8_V_MF8_MASK)
  .value("PseudoVLSEG7E16FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16FF_V_M1)
  .value("PseudoVLSEG7E16FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16FF_V_M1_MASK)
  .value("PseudoVLSEG7E16FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16FF_V_MF2)
  .value("PseudoVLSEG7E16FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16FF_V_MF2_MASK)
  .value("PseudoVLSEG7E16FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16FF_V_MF4)
  .value("PseudoVLSEG7E16FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16FF_V_MF4_MASK)
  .value("PseudoVLSEG7E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16_V_M1)
  .value("PseudoVLSEG7E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16_V_M1_MASK);
  opcodes.value("PseudoVLSEG7E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16_V_MF2)
  .value("PseudoVLSEG7E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16_V_MF2_MASK)
  .value("PseudoVLSEG7E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16_V_MF4)
  .value("PseudoVLSEG7E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E16_V_MF4_MASK)
  .value("PseudoVLSEG7E32FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E32FF_V_M1)
  .value("PseudoVLSEG7E32FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E32FF_V_M1_MASK)
  .value("PseudoVLSEG7E32FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E32FF_V_MF2)
  .value("PseudoVLSEG7E32FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E32FF_V_MF2_MASK)
  .value("PseudoVLSEG7E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E32_V_M1)
  .value("PseudoVLSEG7E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E32_V_M1_MASK)
  .value("PseudoVLSEG7E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E32_V_MF2)
  .value("PseudoVLSEG7E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E32_V_MF2_MASK)
  .value("PseudoVLSEG7E64FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E64FF_V_M1)
  .value("PseudoVLSEG7E64FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E64FF_V_M1_MASK)
  .value("PseudoVLSEG7E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E64_V_M1)
  .value("PseudoVLSEG7E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E64_V_M1_MASK)
  .value("PseudoVLSEG7E8FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8FF_V_M1)
  .value("PseudoVLSEG7E8FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8FF_V_M1_MASK)
  .value("PseudoVLSEG7E8FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8FF_V_MF2)
  .value("PseudoVLSEG7E8FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8FF_V_MF2_MASK)
  .value("PseudoVLSEG7E8FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8FF_V_MF4)
  .value("PseudoVLSEG7E8FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8FF_V_MF4_MASK)
  .value("PseudoVLSEG7E8FF_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8FF_V_MF8)
  .value("PseudoVLSEG7E8FF_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8FF_V_MF8_MASK)
  .value("PseudoVLSEG7E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8_V_M1)
  .value("PseudoVLSEG7E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8_V_M1_MASK)
  .value("PseudoVLSEG7E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8_V_MF2)
  .value("PseudoVLSEG7E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8_V_MF2_MASK)
  .value("PseudoVLSEG7E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8_V_MF4)
  .value("PseudoVLSEG7E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8_V_MF4_MASK)
  .value("PseudoVLSEG7E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8_V_MF8)
  .value("PseudoVLSEG7E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG7E8_V_MF8_MASK)
  .value("PseudoVLSEG8E16FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16FF_V_M1)
  .value("PseudoVLSEG8E16FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16FF_V_M1_MASK)
  .value("PseudoVLSEG8E16FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16FF_V_MF2)
  .value("PseudoVLSEG8E16FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16FF_V_MF2_MASK)
  .value("PseudoVLSEG8E16FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16FF_V_MF4)
  .value("PseudoVLSEG8E16FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16FF_V_MF4_MASK)
  .value("PseudoVLSEG8E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16_V_M1)
  .value("PseudoVLSEG8E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16_V_M1_MASK)
  .value("PseudoVLSEG8E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16_V_MF2)
  .value("PseudoVLSEG8E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16_V_MF2_MASK)
  .value("PseudoVLSEG8E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16_V_MF4)
  .value("PseudoVLSEG8E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E16_V_MF4_MASK)
  .value("PseudoVLSEG8E32FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E32FF_V_M1)
  .value("PseudoVLSEG8E32FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E32FF_V_M1_MASK)
  .value("PseudoVLSEG8E32FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E32FF_V_MF2)
  .value("PseudoVLSEG8E32FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E32FF_V_MF2_MASK)
  .value("PseudoVLSEG8E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E32_V_M1)
  .value("PseudoVLSEG8E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E32_V_M1_MASK)
  .value("PseudoVLSEG8E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E32_V_MF2)
  .value("PseudoVLSEG8E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E32_V_MF2_MASK)
  .value("PseudoVLSEG8E64FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E64FF_V_M1)
  .value("PseudoVLSEG8E64FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E64FF_V_M1_MASK)
  .value("PseudoVLSEG8E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E64_V_M1)
  .value("PseudoVLSEG8E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E64_V_M1_MASK)
  .value("PseudoVLSEG8E8FF_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8FF_V_M1)
  .value("PseudoVLSEG8E8FF_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8FF_V_M1_MASK)
  .value("PseudoVLSEG8E8FF_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8FF_V_MF2)
  .value("PseudoVLSEG8E8FF_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8FF_V_MF2_MASK)
  .value("PseudoVLSEG8E8FF_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8FF_V_MF4)
  .value("PseudoVLSEG8E8FF_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8FF_V_MF4_MASK)
  .value("PseudoVLSEG8E8FF_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8FF_V_MF8)
  .value("PseudoVLSEG8E8FF_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8FF_V_MF8_MASK)
  .value("PseudoVLSEG8E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8_V_M1)
  .value("PseudoVLSEG8E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8_V_M1_MASK)
  .value("PseudoVLSEG8E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8_V_MF2)
  .value("PseudoVLSEG8E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8_V_MF2_MASK)
  .value("PseudoVLSEG8E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8_V_MF4)
  .value("PseudoVLSEG8E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8_V_MF4_MASK)
  .value("PseudoVLSEG8E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8_V_MF8)
  .value("PseudoVLSEG8E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSEG8E8_V_MF8_MASK)
  .value("PseudoVLSSEG2E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E16_V_M1)
  .value("PseudoVLSSEG2E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E16_V_M1_MASK)
  .value("PseudoVLSSEG2E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E16_V_M2)
  .value("PseudoVLSSEG2E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E16_V_M2_MASK)
  .value("PseudoVLSSEG2E16_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E16_V_M4)
  .value("PseudoVLSSEG2E16_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E16_V_M4_MASK)
  .value("PseudoVLSSEG2E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E16_V_MF2)
  .value("PseudoVLSSEG2E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E16_V_MF2_MASK)
  .value("PseudoVLSSEG2E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E16_V_MF4)
  .value("PseudoVLSSEG2E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E16_V_MF4_MASK)
  .value("PseudoVLSSEG2E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E32_V_M1)
  .value("PseudoVLSSEG2E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E32_V_M1_MASK)
  .value("PseudoVLSSEG2E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E32_V_M2)
  .value("PseudoVLSSEG2E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E32_V_M2_MASK)
  .value("PseudoVLSSEG2E32_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E32_V_M4)
  .value("PseudoVLSSEG2E32_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E32_V_M4_MASK)
  .value("PseudoVLSSEG2E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E32_V_MF2)
  .value("PseudoVLSSEG2E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E32_V_MF2_MASK)
  .value("PseudoVLSSEG2E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E64_V_M1)
  .value("PseudoVLSSEG2E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E64_V_M1_MASK)
  .value("PseudoVLSSEG2E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E64_V_M2)
  .value("PseudoVLSSEG2E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E64_V_M2_MASK)
  .value("PseudoVLSSEG2E64_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E64_V_M4)
  .value("PseudoVLSSEG2E64_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E64_V_M4_MASK)
  .value("PseudoVLSSEG2E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_M1)
  .value("PseudoVLSSEG2E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_M1_MASK)
  .value("PseudoVLSSEG2E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_M2)
  .value("PseudoVLSSEG2E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_M2_MASK)
  .value("PseudoVLSSEG2E8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_M4)
  .value("PseudoVLSSEG2E8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_M4_MASK)
  .value("PseudoVLSSEG2E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_MF2)
  .value("PseudoVLSSEG2E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_MF2_MASK)
  .value("PseudoVLSSEG2E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_MF4)
  .value("PseudoVLSSEG2E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_MF4_MASK)
  .value("PseudoVLSSEG2E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_MF8)
  .value("PseudoVLSSEG2E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG2E8_V_MF8_MASK)
  .value("PseudoVLSSEG3E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E16_V_M1)
  .value("PseudoVLSSEG3E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E16_V_M1_MASK)
  .value("PseudoVLSSEG3E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E16_V_M2)
  .value("PseudoVLSSEG3E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E16_V_M2_MASK)
  .value("PseudoVLSSEG3E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E16_V_MF2)
  .value("PseudoVLSSEG3E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E16_V_MF2_MASK)
  .value("PseudoVLSSEG3E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E16_V_MF4)
  .value("PseudoVLSSEG3E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E16_V_MF4_MASK)
  .value("PseudoVLSSEG3E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E32_V_M1)
  .value("PseudoVLSSEG3E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E32_V_M1_MASK)
  .value("PseudoVLSSEG3E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E32_V_M2)
  .value("PseudoVLSSEG3E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E32_V_M2_MASK)
  .value("PseudoVLSSEG3E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E32_V_MF2)
  .value("PseudoVLSSEG3E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E32_V_MF2_MASK)
  .value("PseudoVLSSEG3E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E64_V_M1)
  .value("PseudoVLSSEG3E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E64_V_M1_MASK)
  .value("PseudoVLSSEG3E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E64_V_M2)
  .value("PseudoVLSSEG3E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E64_V_M2_MASK)
  .value("PseudoVLSSEG3E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E8_V_M1)
  .value("PseudoVLSSEG3E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E8_V_M1_MASK)
  .value("PseudoVLSSEG3E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E8_V_M2)
  .value("PseudoVLSSEG3E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E8_V_M2_MASK)
  .value("PseudoVLSSEG3E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E8_V_MF2)
  .value("PseudoVLSSEG3E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E8_V_MF2_MASK)
  .value("PseudoVLSSEG3E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E8_V_MF4)
  .value("PseudoVLSSEG3E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E8_V_MF4_MASK)
  .value("PseudoVLSSEG3E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E8_V_MF8)
  .value("PseudoVLSSEG3E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG3E8_V_MF8_MASK)
  .value("PseudoVLSSEG4E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E16_V_M1)
  .value("PseudoVLSSEG4E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E16_V_M1_MASK)
  .value("PseudoVLSSEG4E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E16_V_M2)
  .value("PseudoVLSSEG4E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E16_V_M2_MASK)
  .value("PseudoVLSSEG4E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E16_V_MF2)
  .value("PseudoVLSSEG4E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E16_V_MF2_MASK)
  .value("PseudoVLSSEG4E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E16_V_MF4)
  .value("PseudoVLSSEG4E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E16_V_MF4_MASK)
  .value("PseudoVLSSEG4E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E32_V_M1)
  .value("PseudoVLSSEG4E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E32_V_M1_MASK)
  .value("PseudoVLSSEG4E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E32_V_M2)
  .value("PseudoVLSSEG4E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E32_V_M2_MASK)
  .value("PseudoVLSSEG4E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E32_V_MF2)
  .value("PseudoVLSSEG4E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E32_V_MF2_MASK)
  .value("PseudoVLSSEG4E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E64_V_M1)
  .value("PseudoVLSSEG4E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E64_V_M1_MASK)
  .value("PseudoVLSSEG4E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E64_V_M2)
  .value("PseudoVLSSEG4E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E64_V_M2_MASK)
  .value("PseudoVLSSEG4E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E8_V_M1)
  .value("PseudoVLSSEG4E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E8_V_M1_MASK)
  .value("PseudoVLSSEG4E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E8_V_M2)
  .value("PseudoVLSSEG4E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E8_V_M2_MASK)
  .value("PseudoVLSSEG4E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E8_V_MF2)
  .value("PseudoVLSSEG4E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E8_V_MF2_MASK)
  .value("PseudoVLSSEG4E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E8_V_MF4)
  .value("PseudoVLSSEG4E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E8_V_MF4_MASK)
  .value("PseudoVLSSEG4E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E8_V_MF8)
  .value("PseudoVLSSEG4E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG4E8_V_MF8_MASK)
  .value("PseudoVLSSEG5E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E16_V_M1)
  .value("PseudoVLSSEG5E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E16_V_M1_MASK)
  .value("PseudoVLSSEG5E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E16_V_MF2)
  .value("PseudoVLSSEG5E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E16_V_MF2_MASK)
  .value("PseudoVLSSEG5E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E16_V_MF4)
  .value("PseudoVLSSEG5E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E16_V_MF4_MASK)
  .value("PseudoVLSSEG5E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E32_V_M1)
  .value("PseudoVLSSEG5E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E32_V_M1_MASK)
  .value("PseudoVLSSEG5E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E32_V_MF2)
  .value("PseudoVLSSEG5E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E32_V_MF2_MASK)
  .value("PseudoVLSSEG5E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E64_V_M1)
  .value("PseudoVLSSEG5E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E64_V_M1_MASK)
  .value("PseudoVLSSEG5E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E8_V_M1)
  .value("PseudoVLSSEG5E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E8_V_M1_MASK)
  .value("PseudoVLSSEG5E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E8_V_MF2)
  .value("PseudoVLSSEG5E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E8_V_MF2_MASK)
  .value("PseudoVLSSEG5E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E8_V_MF4)
  .value("PseudoVLSSEG5E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E8_V_MF4_MASK)
  .value("PseudoVLSSEG5E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E8_V_MF8)
  .value("PseudoVLSSEG5E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG5E8_V_MF8_MASK)
  .value("PseudoVLSSEG6E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E16_V_M1)
  .value("PseudoVLSSEG6E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E16_V_M1_MASK)
  .value("PseudoVLSSEG6E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E16_V_MF2)
  .value("PseudoVLSSEG6E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E16_V_MF2_MASK)
  .value("PseudoVLSSEG6E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E16_V_MF4)
  .value("PseudoVLSSEG6E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E16_V_MF4_MASK)
  .value("PseudoVLSSEG6E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E32_V_M1)
  .value("PseudoVLSSEG6E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E32_V_M1_MASK)
  .value("PseudoVLSSEG6E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E32_V_MF2)
  .value("PseudoVLSSEG6E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E32_V_MF2_MASK)
  .value("PseudoVLSSEG6E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E64_V_M1)
  .value("PseudoVLSSEG6E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E64_V_M1_MASK)
  .value("PseudoVLSSEG6E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E8_V_M1)
  .value("PseudoVLSSEG6E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E8_V_M1_MASK)
  .value("PseudoVLSSEG6E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E8_V_MF2)
  .value("PseudoVLSSEG6E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E8_V_MF2_MASK)
  .value("PseudoVLSSEG6E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E8_V_MF4)
  .value("PseudoVLSSEG6E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E8_V_MF4_MASK)
  .value("PseudoVLSSEG6E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E8_V_MF8)
  .value("PseudoVLSSEG6E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG6E8_V_MF8_MASK)
  .value("PseudoVLSSEG7E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E16_V_M1)
  .value("PseudoVLSSEG7E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E16_V_M1_MASK)
  .value("PseudoVLSSEG7E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E16_V_MF2)
  .value("PseudoVLSSEG7E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E16_V_MF2_MASK)
  .value("PseudoVLSSEG7E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E16_V_MF4)
  .value("PseudoVLSSEG7E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E16_V_MF4_MASK)
  .value("PseudoVLSSEG7E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E32_V_M1)
  .value("PseudoVLSSEG7E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E32_V_M1_MASK)
  .value("PseudoVLSSEG7E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E32_V_MF2)
  .value("PseudoVLSSEG7E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E32_V_MF2_MASK)
  .value("PseudoVLSSEG7E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E64_V_M1)
  .value("PseudoVLSSEG7E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E64_V_M1_MASK)
  .value("PseudoVLSSEG7E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E8_V_M1)
  .value("PseudoVLSSEG7E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E8_V_M1_MASK)
  .value("PseudoVLSSEG7E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E8_V_MF2)
  .value("PseudoVLSSEG7E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E8_V_MF2_MASK)
  .value("PseudoVLSSEG7E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E8_V_MF4)
  .value("PseudoVLSSEG7E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E8_V_MF4_MASK)
  .value("PseudoVLSSEG7E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E8_V_MF8)
  .value("PseudoVLSSEG7E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG7E8_V_MF8_MASK)
  .value("PseudoVLSSEG8E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E16_V_M1)
  .value("PseudoVLSSEG8E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E16_V_M1_MASK)
  .value("PseudoVLSSEG8E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E16_V_MF2)
  .value("PseudoVLSSEG8E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E16_V_MF2_MASK)
  .value("PseudoVLSSEG8E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E16_V_MF4)
  .value("PseudoVLSSEG8E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E16_V_MF4_MASK)
  .value("PseudoVLSSEG8E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E32_V_M1)
  .value("PseudoVLSSEG8E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E32_V_M1_MASK)
  .value("PseudoVLSSEG8E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E32_V_MF2)
  .value("PseudoVLSSEG8E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E32_V_MF2_MASK)
  .value("PseudoVLSSEG8E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E64_V_M1)
  .value("PseudoVLSSEG8E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E64_V_M1_MASK)
  .value("PseudoVLSSEG8E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E8_V_M1)
  .value("PseudoVLSSEG8E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E8_V_M1_MASK)
  .value("PseudoVLSSEG8E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E8_V_MF2)
  .value("PseudoVLSSEG8E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E8_V_MF2_MASK)
  .value("PseudoVLSSEG8E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E8_V_MF4)
  .value("PseudoVLSSEG8E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E8_V_MF4_MASK)
  .value("PseudoVLSSEG8E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E8_V_MF8)
  .value("PseudoVLSSEG8E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLSSEG8E8_V_MF8_MASK)
  .value("PseudoVLUXEI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M1_M1)
  .value("PseudoVLUXEI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M1_M1_MASK)
  .value("PseudoVLUXEI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M1_M2)
  .value("PseudoVLUXEI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M1_M2_MASK)
  .value("PseudoVLUXEI16_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M1_M4)
  .value("PseudoVLUXEI16_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M1_M4_MASK)
  .value("PseudoVLUXEI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M1_MF2)
  .value("PseudoVLUXEI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M1_MF2_MASK)
  .value("PseudoVLUXEI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M2_M1)
  .value("PseudoVLUXEI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M2_M1_MASK)
  .value("PseudoVLUXEI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M2_M2)
  .value("PseudoVLUXEI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M2_M2_MASK)
  .value("PseudoVLUXEI16_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M2_M4)
  .value("PseudoVLUXEI16_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M2_M4_MASK)
  .value("PseudoVLUXEI16_V_M2_M8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M2_M8)
  .value("PseudoVLUXEI16_V_M2_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M2_M8_MASK)
  .value("PseudoVLUXEI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M4_M2)
  .value("PseudoVLUXEI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M4_M2_MASK)
  .value("PseudoVLUXEI16_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M4_M4)
  .value("PseudoVLUXEI16_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M4_M4_MASK)
  .value("PseudoVLUXEI16_V_M4_M8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M4_M8)
  .value("PseudoVLUXEI16_V_M4_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M4_M8_MASK)
  .value("PseudoVLUXEI16_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M8_M4)
  .value("PseudoVLUXEI16_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M8_M4_MASK)
  .value("PseudoVLUXEI16_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M8_M8)
  .value("PseudoVLUXEI16_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_M8_M8_MASK)
  .value("PseudoVLUXEI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF2_M1)
  .value("PseudoVLUXEI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF2_M1_MASK)
  .value("PseudoVLUXEI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF2_M2)
  .value("PseudoVLUXEI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF2_M2_MASK)
  .value("PseudoVLUXEI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF2_MF2)
  .value("PseudoVLUXEI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF2_MF2_MASK)
  .value("PseudoVLUXEI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF2_MF4)
  .value("PseudoVLUXEI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF2_MF4_MASK)
  .value("PseudoVLUXEI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF4_M1)
  .value("PseudoVLUXEI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF4_M1_MASK)
  .value("PseudoVLUXEI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF4_MF2)
  .value("PseudoVLUXEI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF4_MF2_MASK)
  .value("PseudoVLUXEI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF4_MF4)
  .value("PseudoVLUXEI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF4_MF4_MASK)
  .value("PseudoVLUXEI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF4_MF8)
  .value("PseudoVLUXEI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI16_V_MF4_MF8_MASK)
  .value("PseudoVLUXEI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M1_M1)
  .value("PseudoVLUXEI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M1_M1_MASK)
  .value("PseudoVLUXEI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M1_M2)
  .value("PseudoVLUXEI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M1_M2_MASK)
  .value("PseudoVLUXEI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M1_MF2)
  .value("PseudoVLUXEI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M1_MF2_MASK)
  .value("PseudoVLUXEI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M1_MF4)
  .value("PseudoVLUXEI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M1_MF4_MASK)
  .value("PseudoVLUXEI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M2_M1)
  .value("PseudoVLUXEI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M2_M1_MASK)
  .value("PseudoVLUXEI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M2_M2)
  .value("PseudoVLUXEI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M2_M2_MASK)
  .value("PseudoVLUXEI32_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M2_M4)
  .value("PseudoVLUXEI32_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M2_M4_MASK);
  opcodes.value("PseudoVLUXEI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M2_MF2)
  .value("PseudoVLUXEI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M2_MF2_MASK)
  .value("PseudoVLUXEI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M4_M1)
  .value("PseudoVLUXEI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M4_M1_MASK)
  .value("PseudoVLUXEI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M4_M2)
  .value("PseudoVLUXEI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M4_M2_MASK)
  .value("PseudoVLUXEI32_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M4_M4)
  .value("PseudoVLUXEI32_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M4_M4_MASK)
  .value("PseudoVLUXEI32_V_M4_M8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M4_M8)
  .value("PseudoVLUXEI32_V_M4_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M4_M8_MASK)
  .value("PseudoVLUXEI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M8_M2)
  .value("PseudoVLUXEI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M8_M2_MASK)
  .value("PseudoVLUXEI32_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M8_M4)
  .value("PseudoVLUXEI32_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M8_M4_MASK)
  .value("PseudoVLUXEI32_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M8_M8)
  .value("PseudoVLUXEI32_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_M8_M8_MASK)
  .value("PseudoVLUXEI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_MF2_M1)
  .value("PseudoVLUXEI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_MF2_M1_MASK)
  .value("PseudoVLUXEI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_MF2_MF2)
  .value("PseudoVLUXEI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_MF2_MF2_MASK)
  .value("PseudoVLUXEI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_MF2_MF4)
  .value("PseudoVLUXEI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_MF2_MF4_MASK)
  .value("PseudoVLUXEI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_MF2_MF8)
  .value("PseudoVLUXEI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI32_V_MF2_MF8_MASK)
  .value("PseudoVLUXEI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M1_M1)
  .value("PseudoVLUXEI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M1_M1_MASK)
  .value("PseudoVLUXEI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M1_MF2)
  .value("PseudoVLUXEI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M1_MF2_MASK)
  .value("PseudoVLUXEI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M1_MF4)
  .value("PseudoVLUXEI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M1_MF4_MASK)
  .value("PseudoVLUXEI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M1_MF8)
  .value("PseudoVLUXEI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M1_MF8_MASK)
  .value("PseudoVLUXEI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M2_M1)
  .value("PseudoVLUXEI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M2_M1_MASK)
  .value("PseudoVLUXEI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M2_M2)
  .value("PseudoVLUXEI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M2_M2_MASK)
  .value("PseudoVLUXEI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M2_MF2)
  .value("PseudoVLUXEI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M2_MF2_MASK)
  .value("PseudoVLUXEI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M2_MF4)
  .value("PseudoVLUXEI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M2_MF4_MASK)
  .value("PseudoVLUXEI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M4_M1)
  .value("PseudoVLUXEI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M4_M1_MASK)
  .value("PseudoVLUXEI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M4_M2)
  .value("PseudoVLUXEI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M4_M2_MASK)
  .value("PseudoVLUXEI64_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M4_M4)
  .value("PseudoVLUXEI64_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M4_M4_MASK)
  .value("PseudoVLUXEI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M4_MF2)
  .value("PseudoVLUXEI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M4_MF2_MASK)
  .value("PseudoVLUXEI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M8_M1)
  .value("PseudoVLUXEI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M8_M1_MASK)
  .value("PseudoVLUXEI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M8_M2)
  .value("PseudoVLUXEI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M8_M2_MASK)
  .value("PseudoVLUXEI64_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M8_M4)
  .value("PseudoVLUXEI64_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M8_M4_MASK)
  .value("PseudoVLUXEI64_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M8_M8)
  .value("PseudoVLUXEI64_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI64_V_M8_M8_MASK)
  .value("PseudoVLUXEI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M1_M1)
  .value("PseudoVLUXEI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M1_M1_MASK)
  .value("PseudoVLUXEI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M1_M2)
  .value("PseudoVLUXEI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M1_M2_MASK)
  .value("PseudoVLUXEI8_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M1_M4)
  .value("PseudoVLUXEI8_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M1_M4_MASK)
  .value("PseudoVLUXEI8_V_M1_M8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M1_M8)
  .value("PseudoVLUXEI8_V_M1_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M1_M8_MASK)
  .value("PseudoVLUXEI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M2_M2)
  .value("PseudoVLUXEI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M2_M2_MASK)
  .value("PseudoVLUXEI8_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M2_M4)
  .value("PseudoVLUXEI8_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M2_M4_MASK)
  .value("PseudoVLUXEI8_V_M2_M8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M2_M8)
  .value("PseudoVLUXEI8_V_M2_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M2_M8_MASK)
  .value("PseudoVLUXEI8_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M4_M4)
  .value("PseudoVLUXEI8_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M4_M4_MASK)
  .value("PseudoVLUXEI8_V_M4_M8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M4_M8)
  .value("PseudoVLUXEI8_V_M4_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M4_M8_MASK)
  .value("PseudoVLUXEI8_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M8_M8)
  .value("PseudoVLUXEI8_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_M8_M8_MASK)
  .value("PseudoVLUXEI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF2_M1)
  .value("PseudoVLUXEI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF2_M1_MASK)
  .value("PseudoVLUXEI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF2_M2)
  .value("PseudoVLUXEI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF2_M2_MASK)
  .value("PseudoVLUXEI8_V_MF2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF2_M4)
  .value("PseudoVLUXEI8_V_MF2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF2_M4_MASK)
  .value("PseudoVLUXEI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF2_MF2)
  .value("PseudoVLUXEI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF2_MF2_MASK)
  .value("PseudoVLUXEI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF4_M1)
  .value("PseudoVLUXEI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF4_M1_MASK)
  .value("PseudoVLUXEI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF4_M2)
  .value("PseudoVLUXEI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF4_M2_MASK)
  .value("PseudoVLUXEI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF4_MF2)
  .value("PseudoVLUXEI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF4_MF2_MASK)
  .value("PseudoVLUXEI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF4_MF4)
  .value("PseudoVLUXEI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF4_MF4_MASK)
  .value("PseudoVLUXEI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF8_M1)
  .value("PseudoVLUXEI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF8_M1_MASK)
  .value("PseudoVLUXEI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF8_MF2)
  .value("PseudoVLUXEI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF8_MF2_MASK)
  .value("PseudoVLUXEI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF8_MF4)
  .value("PseudoVLUXEI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF8_MF4_MASK)
  .value("PseudoVLUXEI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF8_MF8)
  .value("PseudoVLUXEI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXEI8_V_MF8_MF8_MASK)
  .value("PseudoVLUXSEG2EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M1_M1)
  .value("PseudoVLUXSEG2EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M1_M1_MASK)
  .value("PseudoVLUXSEG2EI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M1_M2)
  .value("PseudoVLUXSEG2EI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M1_M2_MASK)
  .value("PseudoVLUXSEG2EI16_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M1_M4)
  .value("PseudoVLUXSEG2EI16_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M1_M4_MASK)
  .value("PseudoVLUXSEG2EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M1_MF2)
  .value("PseudoVLUXSEG2EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG2EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M2_M1)
  .value("PseudoVLUXSEG2EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M2_M1_MASK)
  .value("PseudoVLUXSEG2EI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M2_M2)
  .value("PseudoVLUXSEG2EI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M2_M2_MASK)
  .value("PseudoVLUXSEG2EI16_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M2_M4)
  .value("PseudoVLUXSEG2EI16_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M2_M4_MASK)
  .value("PseudoVLUXSEG2EI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M4_M2)
  .value("PseudoVLUXSEG2EI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M4_M2_MASK)
  .value("PseudoVLUXSEG2EI16_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M4_M4)
  .value("PseudoVLUXSEG2EI16_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M4_M4_MASK)
  .value("PseudoVLUXSEG2EI16_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M8_M4)
  .value("PseudoVLUXSEG2EI16_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_M8_M4_MASK)
  .value("PseudoVLUXSEG2EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF2_M1)
  .value("PseudoVLUXSEG2EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG2EI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF2_M2)
  .value("PseudoVLUXSEG2EI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF2_M2_MASK)
  .value("PseudoVLUXSEG2EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF2_MF2)
  .value("PseudoVLUXSEG2EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG2EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF2_MF4)
  .value("PseudoVLUXSEG2EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG2EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF4_M1)
  .value("PseudoVLUXSEG2EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG2EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF4_MF2)
  .value("PseudoVLUXSEG2EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG2EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF4_MF4)
  .value("PseudoVLUXSEG2EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG2EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF4_MF8)
  .value("PseudoVLUXSEG2EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI16_V_MF4_MF8_MASK)
  .value("PseudoVLUXSEG2EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M1_M1)
  .value("PseudoVLUXSEG2EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M1_M1_MASK)
  .value("PseudoVLUXSEG2EI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M1_M2)
  .value("PseudoVLUXSEG2EI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M1_M2_MASK)
  .value("PseudoVLUXSEG2EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M1_MF2)
  .value("PseudoVLUXSEG2EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG2EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M1_MF4)
  .value("PseudoVLUXSEG2EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG2EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M2_M1)
  .value("PseudoVLUXSEG2EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M2_M1_MASK)
  .value("PseudoVLUXSEG2EI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M2_M2)
  .value("PseudoVLUXSEG2EI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M2_M2_MASK)
  .value("PseudoVLUXSEG2EI32_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M2_M4)
  .value("PseudoVLUXSEG2EI32_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M2_M4_MASK)
  .value("PseudoVLUXSEG2EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M2_MF2)
  .value("PseudoVLUXSEG2EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG2EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M4_M1)
  .value("PseudoVLUXSEG2EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M4_M1_MASK)
  .value("PseudoVLUXSEG2EI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M4_M2)
  .value("PseudoVLUXSEG2EI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M4_M2_MASK)
  .value("PseudoVLUXSEG2EI32_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M4_M4)
  .value("PseudoVLUXSEG2EI32_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M4_M4_MASK)
  .value("PseudoVLUXSEG2EI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M8_M2)
  .value("PseudoVLUXSEG2EI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M8_M2_MASK)
  .value("PseudoVLUXSEG2EI32_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M8_M4)
  .value("PseudoVLUXSEG2EI32_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_M8_M4_MASK)
  .value("PseudoVLUXSEG2EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_MF2_M1)
  .value("PseudoVLUXSEG2EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG2EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_MF2_MF2)
  .value("PseudoVLUXSEG2EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG2EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_MF2_MF4)
  .value("PseudoVLUXSEG2EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG2EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_MF2_MF8)
  .value("PseudoVLUXSEG2EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI32_V_MF2_MF8_MASK)
  .value("PseudoVLUXSEG2EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M1_M1)
  .value("PseudoVLUXSEG2EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M1_M1_MASK)
  .value("PseudoVLUXSEG2EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M1_MF2)
  .value("PseudoVLUXSEG2EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG2EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M1_MF4)
  .value("PseudoVLUXSEG2EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG2EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M1_MF8)
  .value("PseudoVLUXSEG2EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M1_MF8_MASK)
  .value("PseudoVLUXSEG2EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M2_M1)
  .value("PseudoVLUXSEG2EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M2_M1_MASK)
  .value("PseudoVLUXSEG2EI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M2_M2)
  .value("PseudoVLUXSEG2EI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M2_M2_MASK)
  .value("PseudoVLUXSEG2EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M2_MF2)
  .value("PseudoVLUXSEG2EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG2EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M2_MF4)
  .value("PseudoVLUXSEG2EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M2_MF4_MASK)
  .value("PseudoVLUXSEG2EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M4_M1)
  .value("PseudoVLUXSEG2EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M4_M1_MASK)
  .value("PseudoVLUXSEG2EI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M4_M2)
  .value("PseudoVLUXSEG2EI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M4_M2_MASK)
  .value("PseudoVLUXSEG2EI64_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M4_M4)
  .value("PseudoVLUXSEG2EI64_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M4_M4_MASK)
  .value("PseudoVLUXSEG2EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M4_MF2)
  .value("PseudoVLUXSEG2EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M4_MF2_MASK)
  .value("PseudoVLUXSEG2EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M8_M1)
  .value("PseudoVLUXSEG2EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M8_M1_MASK)
  .value("PseudoVLUXSEG2EI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M8_M2)
  .value("PseudoVLUXSEG2EI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M8_M2_MASK)
  .value("PseudoVLUXSEG2EI64_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M8_M4)
  .value("PseudoVLUXSEG2EI64_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI64_V_M8_M4_MASK)
  .value("PseudoVLUXSEG2EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M1_M1)
  .value("PseudoVLUXSEG2EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M1_M1_MASK)
  .value("PseudoVLUXSEG2EI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M1_M2)
  .value("PseudoVLUXSEG2EI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M1_M2_MASK)
  .value("PseudoVLUXSEG2EI8_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M1_M4)
  .value("PseudoVLUXSEG2EI8_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M1_M4_MASK)
  .value("PseudoVLUXSEG2EI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M2_M2)
  .value("PseudoVLUXSEG2EI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M2_M2_MASK)
  .value("PseudoVLUXSEG2EI8_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M2_M4)
  .value("PseudoVLUXSEG2EI8_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M2_M4_MASK)
  .value("PseudoVLUXSEG2EI8_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M4_M4)
  .value("PseudoVLUXSEG2EI8_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_M4_M4_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF2_M1)
  .value("PseudoVLUXSEG2EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF2_M2)
  .value("PseudoVLUXSEG2EI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF2_M2_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF2_M4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF2_M4)
  .value("PseudoVLUXSEG2EI8_V_MF2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF2_M4_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF2_MF2)
  .value("PseudoVLUXSEG2EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF4_M1)
  .value("PseudoVLUXSEG2EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF4_M2)
  .value("PseudoVLUXSEG2EI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF4_M2_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF4_MF2)
  .value("PseudoVLUXSEG2EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF4_MF4)
  .value("PseudoVLUXSEG2EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF8_M1)
  .value("PseudoVLUXSEG2EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF8_M1_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF8_MF2)
  .value("PseudoVLUXSEG2EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF8_MF2_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF8_MF4)
  .value("PseudoVLUXSEG2EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF8_MF4_MASK)
  .value("PseudoVLUXSEG2EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF8_MF8)
  .value("PseudoVLUXSEG2EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG2EI8_V_MF8_MF8_MASK)
  .value("PseudoVLUXSEG3EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M1_M1)
  .value("PseudoVLUXSEG3EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M1_M1_MASK)
  .value("PseudoVLUXSEG3EI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M1_M2)
  .value("PseudoVLUXSEG3EI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M1_M2_MASK)
  .value("PseudoVLUXSEG3EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M1_MF2)
  .value("PseudoVLUXSEG3EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG3EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M2_M1)
  .value("PseudoVLUXSEG3EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M2_M1_MASK)
  .value("PseudoVLUXSEG3EI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M2_M2)
  .value("PseudoVLUXSEG3EI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M2_M2_MASK)
  .value("PseudoVLUXSEG3EI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M4_M2)
  .value("PseudoVLUXSEG3EI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_M4_M2_MASK)
  .value("PseudoVLUXSEG3EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF2_M1)
  .value("PseudoVLUXSEG3EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG3EI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF2_M2)
  .value("PseudoVLUXSEG3EI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF2_M2_MASK)
  .value("PseudoVLUXSEG3EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF2_MF2)
  .value("PseudoVLUXSEG3EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG3EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF2_MF4)
  .value("PseudoVLUXSEG3EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG3EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF4_M1)
  .value("PseudoVLUXSEG3EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG3EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF4_MF2)
  .value("PseudoVLUXSEG3EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG3EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF4_MF4)
  .value("PseudoVLUXSEG3EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG3EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF4_MF8)
  .value("PseudoVLUXSEG3EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI16_V_MF4_MF8_MASK)
  .value("PseudoVLUXSEG3EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M1_M1)
  .value("PseudoVLUXSEG3EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M1_M1_MASK)
  .value("PseudoVLUXSEG3EI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M1_M2)
  .value("PseudoVLUXSEG3EI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M1_M2_MASK)
  .value("PseudoVLUXSEG3EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M1_MF2)
  .value("PseudoVLUXSEG3EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG3EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M1_MF4)
  .value("PseudoVLUXSEG3EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG3EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M2_M1)
  .value("PseudoVLUXSEG3EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M2_M1_MASK)
  .value("PseudoVLUXSEG3EI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M2_M2)
  .value("PseudoVLUXSEG3EI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M2_M2_MASK)
  .value("PseudoVLUXSEG3EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M2_MF2)
  .value("PseudoVLUXSEG3EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG3EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M4_M1)
  .value("PseudoVLUXSEG3EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M4_M1_MASK)
  .value("PseudoVLUXSEG3EI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M4_M2)
  .value("PseudoVLUXSEG3EI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M4_M2_MASK)
  .value("PseudoVLUXSEG3EI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M8_M2)
  .value("PseudoVLUXSEG3EI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_M8_M2_MASK)
  .value("PseudoVLUXSEG3EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_MF2_M1)
  .value("PseudoVLUXSEG3EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG3EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_MF2_MF2)
  .value("PseudoVLUXSEG3EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG3EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_MF2_MF4)
  .value("PseudoVLUXSEG3EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG3EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_MF2_MF8)
  .value("PseudoVLUXSEG3EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI32_V_MF2_MF8_MASK)
  .value("PseudoVLUXSEG3EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M1_M1)
  .value("PseudoVLUXSEG3EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M1_M1_MASK)
  .value("PseudoVLUXSEG3EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M1_MF2)
  .value("PseudoVLUXSEG3EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG3EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M1_MF4)
  .value("PseudoVLUXSEG3EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG3EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M1_MF8)
  .value("PseudoVLUXSEG3EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M1_MF8_MASK);
  opcodes.value("PseudoVLUXSEG3EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M2_M1)
  .value("PseudoVLUXSEG3EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M2_M1_MASK)
  .value("PseudoVLUXSEG3EI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M2_M2)
  .value("PseudoVLUXSEG3EI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M2_M2_MASK)
  .value("PseudoVLUXSEG3EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M2_MF2)
  .value("PseudoVLUXSEG3EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG3EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M2_MF4)
  .value("PseudoVLUXSEG3EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M2_MF4_MASK)
  .value("PseudoVLUXSEG3EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M4_M1)
  .value("PseudoVLUXSEG3EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M4_M1_MASK)
  .value("PseudoVLUXSEG3EI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M4_M2)
  .value("PseudoVLUXSEG3EI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M4_M2_MASK)
  .value("PseudoVLUXSEG3EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M4_MF2)
  .value("PseudoVLUXSEG3EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M4_MF2_MASK)
  .value("PseudoVLUXSEG3EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M8_M1)
  .value("PseudoVLUXSEG3EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M8_M1_MASK)
  .value("PseudoVLUXSEG3EI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M8_M2)
  .value("PseudoVLUXSEG3EI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI64_V_M8_M2_MASK)
  .value("PseudoVLUXSEG3EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_M1_M1)
  .value("PseudoVLUXSEG3EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_M1_M1_MASK)
  .value("PseudoVLUXSEG3EI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_M1_M2)
  .value("PseudoVLUXSEG3EI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_M1_M2_MASK)
  .value("PseudoVLUXSEG3EI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_M2_M2)
  .value("PseudoVLUXSEG3EI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_M2_M2_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF2_M1)
  .value("PseudoVLUXSEG3EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF2_M2)
  .value("PseudoVLUXSEG3EI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF2_M2_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF2_MF2)
  .value("PseudoVLUXSEG3EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF4_M1)
  .value("PseudoVLUXSEG3EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF4_M2)
  .value("PseudoVLUXSEG3EI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF4_M2_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF4_MF2)
  .value("PseudoVLUXSEG3EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF4_MF4)
  .value("PseudoVLUXSEG3EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF8_M1)
  .value("PseudoVLUXSEG3EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF8_M1_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF8_MF2)
  .value("PseudoVLUXSEG3EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF8_MF2_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF8_MF4)
  .value("PseudoVLUXSEG3EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF8_MF4_MASK)
  .value("PseudoVLUXSEG3EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF8_MF8)
  .value("PseudoVLUXSEG3EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG3EI8_V_MF8_MF8_MASK)
  .value("PseudoVLUXSEG4EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M1_M1)
  .value("PseudoVLUXSEG4EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M1_M1_MASK)
  .value("PseudoVLUXSEG4EI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M1_M2)
  .value("PseudoVLUXSEG4EI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M1_M2_MASK)
  .value("PseudoVLUXSEG4EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M1_MF2)
  .value("PseudoVLUXSEG4EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG4EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M2_M1)
  .value("PseudoVLUXSEG4EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M2_M1_MASK)
  .value("PseudoVLUXSEG4EI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M2_M2)
  .value("PseudoVLUXSEG4EI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M2_M2_MASK)
  .value("PseudoVLUXSEG4EI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M4_M2)
  .value("PseudoVLUXSEG4EI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_M4_M2_MASK)
  .value("PseudoVLUXSEG4EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF2_M1)
  .value("PseudoVLUXSEG4EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG4EI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF2_M2)
  .value("PseudoVLUXSEG4EI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF2_M2_MASK)
  .value("PseudoVLUXSEG4EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF2_MF2)
  .value("PseudoVLUXSEG4EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG4EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF2_MF4)
  .value("PseudoVLUXSEG4EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG4EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF4_M1)
  .value("PseudoVLUXSEG4EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG4EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF4_MF2)
  .value("PseudoVLUXSEG4EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG4EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF4_MF4)
  .value("PseudoVLUXSEG4EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG4EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF4_MF8)
  .value("PseudoVLUXSEG4EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI16_V_MF4_MF8_MASK)
  .value("PseudoVLUXSEG4EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M1_M1)
  .value("PseudoVLUXSEG4EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M1_M1_MASK)
  .value("PseudoVLUXSEG4EI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M1_M2)
  .value("PseudoVLUXSEG4EI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M1_M2_MASK)
  .value("PseudoVLUXSEG4EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M1_MF2)
  .value("PseudoVLUXSEG4EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG4EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M1_MF4)
  .value("PseudoVLUXSEG4EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG4EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M2_M1)
  .value("PseudoVLUXSEG4EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M2_M1_MASK)
  .value("PseudoVLUXSEG4EI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M2_M2)
  .value("PseudoVLUXSEG4EI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M2_M2_MASK)
  .value("PseudoVLUXSEG4EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M2_MF2)
  .value("PseudoVLUXSEG4EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG4EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M4_M1)
  .value("PseudoVLUXSEG4EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M4_M1_MASK)
  .value("PseudoVLUXSEG4EI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M4_M2)
  .value("PseudoVLUXSEG4EI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M4_M2_MASK)
  .value("PseudoVLUXSEG4EI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M8_M2)
  .value("PseudoVLUXSEG4EI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_M8_M2_MASK)
  .value("PseudoVLUXSEG4EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_MF2_M1)
  .value("PseudoVLUXSEG4EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG4EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_MF2_MF2)
  .value("PseudoVLUXSEG4EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG4EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_MF2_MF4)
  .value("PseudoVLUXSEG4EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG4EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_MF2_MF8)
  .value("PseudoVLUXSEG4EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI32_V_MF2_MF8_MASK)
  .value("PseudoVLUXSEG4EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M1_M1)
  .value("PseudoVLUXSEG4EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M1_M1_MASK)
  .value("PseudoVLUXSEG4EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M1_MF2)
  .value("PseudoVLUXSEG4EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG4EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M1_MF4)
  .value("PseudoVLUXSEG4EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG4EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M1_MF8)
  .value("PseudoVLUXSEG4EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M1_MF8_MASK)
  .value("PseudoVLUXSEG4EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M2_M1)
  .value("PseudoVLUXSEG4EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M2_M1_MASK)
  .value("PseudoVLUXSEG4EI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M2_M2)
  .value("PseudoVLUXSEG4EI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M2_M2_MASK)
  .value("PseudoVLUXSEG4EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M2_MF2)
  .value("PseudoVLUXSEG4EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG4EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M2_MF4)
  .value("PseudoVLUXSEG4EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M2_MF4_MASK)
  .value("PseudoVLUXSEG4EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M4_M1)
  .value("PseudoVLUXSEG4EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M4_M1_MASK)
  .value("PseudoVLUXSEG4EI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M4_M2)
  .value("PseudoVLUXSEG4EI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M4_M2_MASK)
  .value("PseudoVLUXSEG4EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M4_MF2)
  .value("PseudoVLUXSEG4EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M4_MF2_MASK)
  .value("PseudoVLUXSEG4EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M8_M1)
  .value("PseudoVLUXSEG4EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M8_M1_MASK)
  .value("PseudoVLUXSEG4EI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M8_M2)
  .value("PseudoVLUXSEG4EI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI64_V_M8_M2_MASK)
  .value("PseudoVLUXSEG4EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_M1_M1)
  .value("PseudoVLUXSEG4EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_M1_M1_MASK)
  .value("PseudoVLUXSEG4EI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_M1_M2)
  .value("PseudoVLUXSEG4EI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_M1_M2_MASK)
  .value("PseudoVLUXSEG4EI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_M2_M2)
  .value("PseudoVLUXSEG4EI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_M2_M2_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF2_M1)
  .value("PseudoVLUXSEG4EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF2_M2)
  .value("PseudoVLUXSEG4EI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF2_M2_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF2_MF2)
  .value("PseudoVLUXSEG4EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF4_M1)
  .value("PseudoVLUXSEG4EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF4_M2)
  .value("PseudoVLUXSEG4EI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF4_M2_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF4_MF2)
  .value("PseudoVLUXSEG4EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF4_MF4)
  .value("PseudoVLUXSEG4EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF8_M1)
  .value("PseudoVLUXSEG4EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF8_M1_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF8_MF2)
  .value("PseudoVLUXSEG4EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF8_MF2_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF8_MF4)
  .value("PseudoVLUXSEG4EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF8_MF4_MASK)
  .value("PseudoVLUXSEG4EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF8_MF8)
  .value("PseudoVLUXSEG4EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG4EI8_V_MF8_MF8_MASK)
  .value("PseudoVLUXSEG5EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_M1_M1)
  .value("PseudoVLUXSEG5EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_M1_M1_MASK)
  .value("PseudoVLUXSEG5EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_M1_MF2)
  .value("PseudoVLUXSEG5EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG5EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_M2_M1)
  .value("PseudoVLUXSEG5EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_M2_M1_MASK)
  .value("PseudoVLUXSEG5EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF2_M1)
  .value("PseudoVLUXSEG5EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG5EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF2_MF2)
  .value("PseudoVLUXSEG5EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG5EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF2_MF4)
  .value("PseudoVLUXSEG5EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG5EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF4_M1)
  .value("PseudoVLUXSEG5EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG5EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF4_MF2)
  .value("PseudoVLUXSEG5EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG5EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF4_MF4)
  .value("PseudoVLUXSEG5EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG5EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF4_MF8)
  .value("PseudoVLUXSEG5EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI16_V_MF4_MF8_MASK)
  .value("PseudoVLUXSEG5EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M1_M1)
  .value("PseudoVLUXSEG5EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M1_M1_MASK)
  .value("PseudoVLUXSEG5EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M1_MF2)
  .value("PseudoVLUXSEG5EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG5EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M1_MF4)
  .value("PseudoVLUXSEG5EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG5EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M2_M1)
  .value("PseudoVLUXSEG5EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M2_M1_MASK)
  .value("PseudoVLUXSEG5EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M2_MF2)
  .value("PseudoVLUXSEG5EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG5EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M4_M1)
  .value("PseudoVLUXSEG5EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_M4_M1_MASK)
  .value("PseudoVLUXSEG5EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_MF2_M1)
  .value("PseudoVLUXSEG5EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG5EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_MF2_MF2)
  .value("PseudoVLUXSEG5EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG5EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_MF2_MF4)
  .value("PseudoVLUXSEG5EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG5EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_MF2_MF8)
  .value("PseudoVLUXSEG5EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI32_V_MF2_MF8_MASK)
  .value("PseudoVLUXSEG5EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M1_M1)
  .value("PseudoVLUXSEG5EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M1_M1_MASK)
  .value("PseudoVLUXSEG5EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M1_MF2)
  .value("PseudoVLUXSEG5EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG5EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M1_MF4)
  .value("PseudoVLUXSEG5EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG5EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M1_MF8)
  .value("PseudoVLUXSEG5EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M1_MF8_MASK)
  .value("PseudoVLUXSEG5EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M2_M1)
  .value("PseudoVLUXSEG5EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M2_M1_MASK)
  .value("PseudoVLUXSEG5EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M2_MF2)
  .value("PseudoVLUXSEG5EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG5EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M2_MF4)
  .value("PseudoVLUXSEG5EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M2_MF4_MASK)
  .value("PseudoVLUXSEG5EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M4_M1)
  .value("PseudoVLUXSEG5EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M4_M1_MASK)
  .value("PseudoVLUXSEG5EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M4_MF2)
  .value("PseudoVLUXSEG5EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M4_MF2_MASK)
  .value("PseudoVLUXSEG5EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M8_M1)
  .value("PseudoVLUXSEG5EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI64_V_M8_M1_MASK)
  .value("PseudoVLUXSEG5EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_M1_M1)
  .value("PseudoVLUXSEG5EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_M1_M1_MASK)
  .value("PseudoVLUXSEG5EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF2_M1)
  .value("PseudoVLUXSEG5EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG5EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF2_MF2)
  .value("PseudoVLUXSEG5EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG5EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF4_M1)
  .value("PseudoVLUXSEG5EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG5EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF4_MF2)
  .value("PseudoVLUXSEG5EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG5EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF4_MF4)
  .value("PseudoVLUXSEG5EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG5EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF8_M1)
  .value("PseudoVLUXSEG5EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF8_M1_MASK)
  .value("PseudoVLUXSEG5EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF8_MF2)
  .value("PseudoVLUXSEG5EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF8_MF2_MASK)
  .value("PseudoVLUXSEG5EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF8_MF4)
  .value("PseudoVLUXSEG5EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF8_MF4_MASK)
  .value("PseudoVLUXSEG5EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF8_MF8)
  .value("PseudoVLUXSEG5EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG5EI8_V_MF8_MF8_MASK)
  .value("PseudoVLUXSEG6EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_M1_M1)
  .value("PseudoVLUXSEG6EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_M1_M1_MASK)
  .value("PseudoVLUXSEG6EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_M1_MF2)
  .value("PseudoVLUXSEG6EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG6EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_M2_M1)
  .value("PseudoVLUXSEG6EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_M2_M1_MASK)
  .value("PseudoVLUXSEG6EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF2_M1)
  .value("PseudoVLUXSEG6EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG6EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF2_MF2)
  .value("PseudoVLUXSEG6EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG6EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF2_MF4)
  .value("PseudoVLUXSEG6EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG6EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF4_M1)
  .value("PseudoVLUXSEG6EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG6EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF4_MF2)
  .value("PseudoVLUXSEG6EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG6EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF4_MF4)
  .value("PseudoVLUXSEG6EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG6EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF4_MF8)
  .value("PseudoVLUXSEG6EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI16_V_MF4_MF8_MASK)
  .value("PseudoVLUXSEG6EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M1_M1)
  .value("PseudoVLUXSEG6EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M1_M1_MASK)
  .value("PseudoVLUXSEG6EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M1_MF2)
  .value("PseudoVLUXSEG6EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG6EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M1_MF4)
  .value("PseudoVLUXSEG6EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG6EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M2_M1)
  .value("PseudoVLUXSEG6EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M2_M1_MASK)
  .value("PseudoVLUXSEG6EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M2_MF2)
  .value("PseudoVLUXSEG6EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG6EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M4_M1)
  .value("PseudoVLUXSEG6EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_M4_M1_MASK)
  .value("PseudoVLUXSEG6EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_MF2_M1)
  .value("PseudoVLUXSEG6EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG6EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_MF2_MF2)
  .value("PseudoVLUXSEG6EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG6EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_MF2_MF4)
  .value("PseudoVLUXSEG6EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG6EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_MF2_MF8)
  .value("PseudoVLUXSEG6EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI32_V_MF2_MF8_MASK)
  .value("PseudoVLUXSEG6EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M1_M1)
  .value("PseudoVLUXSEG6EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M1_M1_MASK)
  .value("PseudoVLUXSEG6EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M1_MF2)
  .value("PseudoVLUXSEG6EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG6EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M1_MF4)
  .value("PseudoVLUXSEG6EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG6EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M1_MF8)
  .value("PseudoVLUXSEG6EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M1_MF8_MASK)
  .value("PseudoVLUXSEG6EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M2_M1)
  .value("PseudoVLUXSEG6EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M2_M1_MASK)
  .value("PseudoVLUXSEG6EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M2_MF2)
  .value("PseudoVLUXSEG6EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG6EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M2_MF4)
  .value("PseudoVLUXSEG6EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M2_MF4_MASK)
  .value("PseudoVLUXSEG6EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M4_M1)
  .value("PseudoVLUXSEG6EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M4_M1_MASK)
  .value("PseudoVLUXSEG6EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M4_MF2)
  .value("PseudoVLUXSEG6EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M4_MF2_MASK)
  .value("PseudoVLUXSEG6EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M8_M1)
  .value("PseudoVLUXSEG6EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI64_V_M8_M1_MASK)
  .value("PseudoVLUXSEG6EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_M1_M1)
  .value("PseudoVLUXSEG6EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_M1_M1_MASK)
  .value("PseudoVLUXSEG6EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF2_M1)
  .value("PseudoVLUXSEG6EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF2_M1_MASK);
  opcodes.value("PseudoVLUXSEG6EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF2_MF2)
  .value("PseudoVLUXSEG6EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG6EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF4_M1)
  .value("PseudoVLUXSEG6EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG6EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF4_MF2)
  .value("PseudoVLUXSEG6EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG6EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF4_MF4)
  .value("PseudoVLUXSEG6EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG6EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF8_M1)
  .value("PseudoVLUXSEG6EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF8_M1_MASK)
  .value("PseudoVLUXSEG6EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF8_MF2)
  .value("PseudoVLUXSEG6EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF8_MF2_MASK)
  .value("PseudoVLUXSEG6EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF8_MF4)
  .value("PseudoVLUXSEG6EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF8_MF4_MASK)
  .value("PseudoVLUXSEG6EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF8_MF8)
  .value("PseudoVLUXSEG6EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG6EI8_V_MF8_MF8_MASK)
  .value("PseudoVLUXSEG7EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_M1_M1)
  .value("PseudoVLUXSEG7EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_M1_M1_MASK)
  .value("PseudoVLUXSEG7EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_M1_MF2)
  .value("PseudoVLUXSEG7EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG7EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_M2_M1)
  .value("PseudoVLUXSEG7EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_M2_M1_MASK)
  .value("PseudoVLUXSEG7EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF2_M1)
  .value("PseudoVLUXSEG7EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG7EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF2_MF2)
  .value("PseudoVLUXSEG7EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG7EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF2_MF4)
  .value("PseudoVLUXSEG7EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG7EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF4_M1)
  .value("PseudoVLUXSEG7EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG7EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF4_MF2)
  .value("PseudoVLUXSEG7EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG7EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF4_MF4)
  .value("PseudoVLUXSEG7EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG7EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF4_MF8)
  .value("PseudoVLUXSEG7EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI16_V_MF4_MF8_MASK)
  .value("PseudoVLUXSEG7EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M1_M1)
  .value("PseudoVLUXSEG7EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M1_M1_MASK)
  .value("PseudoVLUXSEG7EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M1_MF2)
  .value("PseudoVLUXSEG7EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG7EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M1_MF4)
  .value("PseudoVLUXSEG7EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG7EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M2_M1)
  .value("PseudoVLUXSEG7EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M2_M1_MASK)
  .value("PseudoVLUXSEG7EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M2_MF2)
  .value("PseudoVLUXSEG7EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG7EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M4_M1)
  .value("PseudoVLUXSEG7EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_M4_M1_MASK)
  .value("PseudoVLUXSEG7EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_MF2_M1)
  .value("PseudoVLUXSEG7EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG7EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_MF2_MF2)
  .value("PseudoVLUXSEG7EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG7EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_MF2_MF4)
  .value("PseudoVLUXSEG7EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG7EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_MF2_MF8)
  .value("PseudoVLUXSEG7EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI32_V_MF2_MF8_MASK)
  .value("PseudoVLUXSEG7EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M1_M1)
  .value("PseudoVLUXSEG7EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M1_M1_MASK)
  .value("PseudoVLUXSEG7EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M1_MF2)
  .value("PseudoVLUXSEG7EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG7EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M1_MF4)
  .value("PseudoVLUXSEG7EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG7EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M1_MF8)
  .value("PseudoVLUXSEG7EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M1_MF8_MASK)
  .value("PseudoVLUXSEG7EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M2_M1)
  .value("PseudoVLUXSEG7EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M2_M1_MASK)
  .value("PseudoVLUXSEG7EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M2_MF2)
  .value("PseudoVLUXSEG7EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG7EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M2_MF4)
  .value("PseudoVLUXSEG7EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M2_MF4_MASK)
  .value("PseudoVLUXSEG7EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M4_M1)
  .value("PseudoVLUXSEG7EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M4_M1_MASK)
  .value("PseudoVLUXSEG7EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M4_MF2)
  .value("PseudoVLUXSEG7EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M4_MF2_MASK)
  .value("PseudoVLUXSEG7EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M8_M1)
  .value("PseudoVLUXSEG7EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI64_V_M8_M1_MASK)
  .value("PseudoVLUXSEG7EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_M1_M1)
  .value("PseudoVLUXSEG7EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_M1_M1_MASK)
  .value("PseudoVLUXSEG7EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF2_M1)
  .value("PseudoVLUXSEG7EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG7EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF2_MF2)
  .value("PseudoVLUXSEG7EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG7EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF4_M1)
  .value("PseudoVLUXSEG7EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG7EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF4_MF2)
  .value("PseudoVLUXSEG7EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG7EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF4_MF4)
  .value("PseudoVLUXSEG7EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG7EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF8_M1)
  .value("PseudoVLUXSEG7EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF8_M1_MASK)
  .value("PseudoVLUXSEG7EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF8_MF2)
  .value("PseudoVLUXSEG7EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF8_MF2_MASK)
  .value("PseudoVLUXSEG7EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF8_MF4)
  .value("PseudoVLUXSEG7EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF8_MF4_MASK)
  .value("PseudoVLUXSEG7EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF8_MF8)
  .value("PseudoVLUXSEG7EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG7EI8_V_MF8_MF8_MASK)
  .value("PseudoVLUXSEG8EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_M1_M1)
  .value("PseudoVLUXSEG8EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_M1_M1_MASK)
  .value("PseudoVLUXSEG8EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_M1_MF2)
  .value("PseudoVLUXSEG8EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG8EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_M2_M1)
  .value("PseudoVLUXSEG8EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_M2_M1_MASK)
  .value("PseudoVLUXSEG8EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF2_M1)
  .value("PseudoVLUXSEG8EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG8EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF2_MF2)
  .value("PseudoVLUXSEG8EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG8EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF2_MF4)
  .value("PseudoVLUXSEG8EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG8EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF4_M1)
  .value("PseudoVLUXSEG8EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG8EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF4_MF2)
  .value("PseudoVLUXSEG8EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG8EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF4_MF4)
  .value("PseudoVLUXSEG8EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG8EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF4_MF8)
  .value("PseudoVLUXSEG8EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI16_V_MF4_MF8_MASK)
  .value("PseudoVLUXSEG8EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M1_M1)
  .value("PseudoVLUXSEG8EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M1_M1_MASK)
  .value("PseudoVLUXSEG8EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M1_MF2)
  .value("PseudoVLUXSEG8EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG8EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M1_MF4)
  .value("PseudoVLUXSEG8EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG8EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M2_M1)
  .value("PseudoVLUXSEG8EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M2_M1_MASK)
  .value("PseudoVLUXSEG8EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M2_MF2)
  .value("PseudoVLUXSEG8EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG8EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M4_M1)
  .value("PseudoVLUXSEG8EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_M4_M1_MASK)
  .value("PseudoVLUXSEG8EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_MF2_M1)
  .value("PseudoVLUXSEG8EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG8EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_MF2_MF2)
  .value("PseudoVLUXSEG8EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG8EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_MF2_MF4)
  .value("PseudoVLUXSEG8EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_MF2_MF4_MASK)
  .value("PseudoVLUXSEG8EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_MF2_MF8)
  .value("PseudoVLUXSEG8EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI32_V_MF2_MF8_MASK)
  .value("PseudoVLUXSEG8EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M1_M1)
  .value("PseudoVLUXSEG8EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M1_M1_MASK)
  .value("PseudoVLUXSEG8EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M1_MF2)
  .value("PseudoVLUXSEG8EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M1_MF2_MASK)
  .value("PseudoVLUXSEG8EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M1_MF4)
  .value("PseudoVLUXSEG8EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M1_MF4_MASK)
  .value("PseudoVLUXSEG8EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M1_MF8)
  .value("PseudoVLUXSEG8EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M1_MF8_MASK)
  .value("PseudoVLUXSEG8EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M2_M1)
  .value("PseudoVLUXSEG8EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M2_M1_MASK)
  .value("PseudoVLUXSEG8EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M2_MF2)
  .value("PseudoVLUXSEG8EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M2_MF2_MASK)
  .value("PseudoVLUXSEG8EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M2_MF4)
  .value("PseudoVLUXSEG8EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M2_MF4_MASK)
  .value("PseudoVLUXSEG8EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M4_M1)
  .value("PseudoVLUXSEG8EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M4_M1_MASK)
  .value("PseudoVLUXSEG8EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M4_MF2)
  .value("PseudoVLUXSEG8EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M4_MF2_MASK)
  .value("PseudoVLUXSEG8EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M8_M1)
  .value("PseudoVLUXSEG8EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI64_V_M8_M1_MASK)
  .value("PseudoVLUXSEG8EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_M1_M1)
  .value("PseudoVLUXSEG8EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_M1_M1_MASK)
  .value("PseudoVLUXSEG8EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF2_M1)
  .value("PseudoVLUXSEG8EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF2_M1_MASK)
  .value("PseudoVLUXSEG8EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF2_MF2)
  .value("PseudoVLUXSEG8EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF2_MF2_MASK)
  .value("PseudoVLUXSEG8EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF4_M1)
  .value("PseudoVLUXSEG8EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF4_M1_MASK)
  .value("PseudoVLUXSEG8EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF4_MF2)
  .value("PseudoVLUXSEG8EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF4_MF2_MASK)
  .value("PseudoVLUXSEG8EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF4_MF4)
  .value("PseudoVLUXSEG8EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF4_MF4_MASK)
  .value("PseudoVLUXSEG8EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF8_M1)
  .value("PseudoVLUXSEG8EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF8_M1_MASK)
  .value("PseudoVLUXSEG8EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF8_MF2)
  .value("PseudoVLUXSEG8EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF8_MF2_MASK)
  .value("PseudoVLUXSEG8EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF8_MF4)
  .value("PseudoVLUXSEG8EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF8_MF4_MASK)
  .value("PseudoVLUXSEG8EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF8_MF8)
  .value("PseudoVLUXSEG8EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVLUXSEG8EI8_V_MF8_MF8_MASK)
  .value("PseudoVMACC_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_M1)
  .value("PseudoVMACC_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_M1_MASK)
  .value("PseudoVMACC_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_M2)
  .value("PseudoVMACC_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_M2_MASK)
  .value("PseudoVMACC_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_M4)
  .value("PseudoVMACC_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_M4_MASK)
  .value("PseudoVMACC_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_M8)
  .value("PseudoVMACC_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_M8_MASK)
  .value("PseudoVMACC_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_MF2)
  .value("PseudoVMACC_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_MF2_MASK)
  .value("PseudoVMACC_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_MF4)
  .value("PseudoVMACC_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_MF4_MASK)
  .value("PseudoVMACC_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_MF8)
  .value("PseudoVMACC_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VV_MF8_MASK)
  .value("PseudoVMACC_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_M1)
  .value("PseudoVMACC_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_M1_MASK)
  .value("PseudoVMACC_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_M2)
  .value("PseudoVMACC_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_M2_MASK)
  .value("PseudoVMACC_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_M4)
  .value("PseudoVMACC_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_M4_MASK)
  .value("PseudoVMACC_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_M8)
  .value("PseudoVMACC_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_M8_MASK)
  .value("PseudoVMACC_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_MF2)
  .value("PseudoVMACC_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_MF2_MASK)
  .value("PseudoVMACC_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_MF4)
  .value("PseudoVMACC_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_MF4_MASK)
  .value("PseudoVMACC_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_MF8)
  .value("PseudoVMACC_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMACC_VX_MF8_MASK)
  .value("PseudoVMADC_VIM_M1", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VIM_M1)
  .value("PseudoVMADC_VIM_M2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VIM_M2)
  .value("PseudoVMADC_VIM_M4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VIM_M4)
  .value("PseudoVMADC_VIM_M8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VIM_M8)
  .value("PseudoVMADC_VIM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VIM_MF2)
  .value("PseudoVMADC_VIM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VIM_MF4)
  .value("PseudoVMADC_VIM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VIM_MF8)
  .value("PseudoVMADC_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VI_M1)
  .value("PseudoVMADC_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VI_M2)
  .value("PseudoVMADC_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VI_M4)
  .value("PseudoVMADC_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VI_M8)
  .value("PseudoVMADC_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VI_MF2)
  .value("PseudoVMADC_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VI_MF4)
  .value("PseudoVMADC_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VI_MF8)
  .value("PseudoVMADC_VVM_M1", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VVM_M1)
  .value("PseudoVMADC_VVM_M2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VVM_M2)
  .value("PseudoVMADC_VVM_M4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VVM_M4)
  .value("PseudoVMADC_VVM_M8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VVM_M8)
  .value("PseudoVMADC_VVM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VVM_MF2)
  .value("PseudoVMADC_VVM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VVM_MF4)
  .value("PseudoVMADC_VVM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VVM_MF8)
  .value("PseudoVMADC_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VV_M1)
  .value("PseudoVMADC_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VV_M2)
  .value("PseudoVMADC_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VV_M4)
  .value("PseudoVMADC_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VV_M8)
  .value("PseudoVMADC_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VV_MF2)
  .value("PseudoVMADC_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VV_MF4)
  .value("PseudoVMADC_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VV_MF8)
  .value("PseudoVMADC_VXM_M1", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VXM_M1)
  .value("PseudoVMADC_VXM_M2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VXM_M2)
  .value("PseudoVMADC_VXM_M4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VXM_M4)
  .value("PseudoVMADC_VXM_M8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VXM_M8)
  .value("PseudoVMADC_VXM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VXM_MF2)
  .value("PseudoVMADC_VXM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VXM_MF4)
  .value("PseudoVMADC_VXM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VXM_MF8)
  .value("PseudoVMADC_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VX_M1)
  .value("PseudoVMADC_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VX_M2)
  .value("PseudoVMADC_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VX_M4)
  .value("PseudoVMADC_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VX_M8)
  .value("PseudoVMADC_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VX_MF2)
  .value("PseudoVMADC_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VX_MF4)
  .value("PseudoVMADC_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMADC_VX_MF8)
  .value("PseudoVMADD_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_M1)
  .value("PseudoVMADD_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_M1_MASK)
  .value("PseudoVMADD_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_M2)
  .value("PseudoVMADD_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_M2_MASK)
  .value("PseudoVMADD_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_M4)
  .value("PseudoVMADD_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_M4_MASK)
  .value("PseudoVMADD_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_M8)
  .value("PseudoVMADD_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_M8_MASK)
  .value("PseudoVMADD_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_MF2)
  .value("PseudoVMADD_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_MF2_MASK)
  .value("PseudoVMADD_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_MF4)
  .value("PseudoVMADD_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_MF4_MASK)
  .value("PseudoVMADD_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_MF8)
  .value("PseudoVMADD_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VV_MF8_MASK)
  .value("PseudoVMADD_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_M1)
  .value("PseudoVMADD_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_M1_MASK)
  .value("PseudoVMADD_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_M2)
  .value("PseudoVMADD_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_M2_MASK)
  .value("PseudoVMADD_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_M4)
  .value("PseudoVMADD_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_M4_MASK)
  .value("PseudoVMADD_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_M8)
  .value("PseudoVMADD_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_M8_MASK)
  .value("PseudoVMADD_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_MF2)
  .value("PseudoVMADD_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_MF2_MASK)
  .value("PseudoVMADD_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_MF4)
  .value("PseudoVMADD_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_MF4_MASK)
  .value("PseudoVMADD_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_MF8)
  .value("PseudoVMADD_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMADD_VX_MF8_MASK)
  .value("PseudoVMANDN_MM_B1", LIEF::assembly::riscv::OPCODE::PseudoVMANDN_MM_B1)
  .value("PseudoVMANDN_MM_B16", LIEF::assembly::riscv::OPCODE::PseudoVMANDN_MM_B16)
  .value("PseudoVMANDN_MM_B2", LIEF::assembly::riscv::OPCODE::PseudoVMANDN_MM_B2)
  .value("PseudoVMANDN_MM_B32", LIEF::assembly::riscv::OPCODE::PseudoVMANDN_MM_B32)
  .value("PseudoVMANDN_MM_B4", LIEF::assembly::riscv::OPCODE::PseudoVMANDN_MM_B4)
  .value("PseudoVMANDN_MM_B64", LIEF::assembly::riscv::OPCODE::PseudoVMANDN_MM_B64)
  .value("PseudoVMANDN_MM_B8", LIEF::assembly::riscv::OPCODE::PseudoVMANDN_MM_B8)
  .value("PseudoVMAND_MM_B1", LIEF::assembly::riscv::OPCODE::PseudoVMAND_MM_B1)
  .value("PseudoVMAND_MM_B16", LIEF::assembly::riscv::OPCODE::PseudoVMAND_MM_B16)
  .value("PseudoVMAND_MM_B2", LIEF::assembly::riscv::OPCODE::PseudoVMAND_MM_B2)
  .value("PseudoVMAND_MM_B32", LIEF::assembly::riscv::OPCODE::PseudoVMAND_MM_B32)
  .value("PseudoVMAND_MM_B4", LIEF::assembly::riscv::OPCODE::PseudoVMAND_MM_B4)
  .value("PseudoVMAND_MM_B64", LIEF::assembly::riscv::OPCODE::PseudoVMAND_MM_B64)
  .value("PseudoVMAND_MM_B8", LIEF::assembly::riscv::OPCODE::PseudoVMAND_MM_B8)
  .value("PseudoVMAXU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_M1)
  .value("PseudoVMAXU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_M1_MASK)
  .value("PseudoVMAXU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_M2)
  .value("PseudoVMAXU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_M2_MASK)
  .value("PseudoVMAXU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_M4)
  .value("PseudoVMAXU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_M4_MASK)
  .value("PseudoVMAXU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_M8)
  .value("PseudoVMAXU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_M8_MASK)
  .value("PseudoVMAXU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_MF2)
  .value("PseudoVMAXU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_MF2_MASK)
  .value("PseudoVMAXU_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_MF4)
  .value("PseudoVMAXU_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_MF4_MASK);
  opcodes.value("PseudoVMAXU_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_MF8)
  .value("PseudoVMAXU_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VV_MF8_MASK)
  .value("PseudoVMAXU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_M1)
  .value("PseudoVMAXU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_M1_MASK)
  .value("PseudoVMAXU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_M2)
  .value("PseudoVMAXU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_M2_MASK)
  .value("PseudoVMAXU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_M4)
  .value("PseudoVMAXU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_M4_MASK)
  .value("PseudoVMAXU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_M8)
  .value("PseudoVMAXU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_M8_MASK)
  .value("PseudoVMAXU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_MF2)
  .value("PseudoVMAXU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_MF2_MASK)
  .value("PseudoVMAXU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_MF4)
  .value("PseudoVMAXU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_MF4_MASK)
  .value("PseudoVMAXU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_MF8)
  .value("PseudoVMAXU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAXU_VX_MF8_MASK)
  .value("PseudoVMAX_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_M1)
  .value("PseudoVMAX_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_M1_MASK)
  .value("PseudoVMAX_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_M2)
  .value("PseudoVMAX_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_M2_MASK)
  .value("PseudoVMAX_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_M4)
  .value("PseudoVMAX_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_M4_MASK)
  .value("PseudoVMAX_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_M8)
  .value("PseudoVMAX_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_M8_MASK)
  .value("PseudoVMAX_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_MF2)
  .value("PseudoVMAX_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_MF2_MASK)
  .value("PseudoVMAX_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_MF4)
  .value("PseudoVMAX_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_MF4_MASK)
  .value("PseudoVMAX_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_MF8)
  .value("PseudoVMAX_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VV_MF8_MASK)
  .value("PseudoVMAX_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_M1)
  .value("PseudoVMAX_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_M1_MASK)
  .value("PseudoVMAX_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_M2)
  .value("PseudoVMAX_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_M2_MASK)
  .value("PseudoVMAX_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_M4)
  .value("PseudoVMAX_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_M4_MASK)
  .value("PseudoVMAX_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_M8)
  .value("PseudoVMAX_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_M8_MASK)
  .value("PseudoVMAX_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_MF2)
  .value("PseudoVMAX_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_MF2_MASK)
  .value("PseudoVMAX_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_MF4)
  .value("PseudoVMAX_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_MF4_MASK)
  .value("PseudoVMAX_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_MF8)
  .value("PseudoVMAX_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMAX_VX_MF8_MASK)
  .value("PseudoVMCLR_M_B1", LIEF::assembly::riscv::OPCODE::PseudoVMCLR_M_B1)
  .value("PseudoVMCLR_M_B16", LIEF::assembly::riscv::OPCODE::PseudoVMCLR_M_B16)
  .value("PseudoVMCLR_M_B2", LIEF::assembly::riscv::OPCODE::PseudoVMCLR_M_B2)
  .value("PseudoVMCLR_M_B32", LIEF::assembly::riscv::OPCODE::PseudoVMCLR_M_B32)
  .value("PseudoVMCLR_M_B4", LIEF::assembly::riscv::OPCODE::PseudoVMCLR_M_B4)
  .value("PseudoVMCLR_M_B64", LIEF::assembly::riscv::OPCODE::PseudoVMCLR_M_B64)
  .value("PseudoVMCLR_M_B8", LIEF::assembly::riscv::OPCODE::PseudoVMCLR_M_B8)
  .value("PseudoVMERGE_VIM_M1", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VIM_M1)
  .value("PseudoVMERGE_VIM_M2", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VIM_M2)
  .value("PseudoVMERGE_VIM_M4", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VIM_M4)
  .value("PseudoVMERGE_VIM_M8", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VIM_M8)
  .value("PseudoVMERGE_VIM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VIM_MF2)
  .value("PseudoVMERGE_VIM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VIM_MF4)
  .value("PseudoVMERGE_VIM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VIM_MF8)
  .value("PseudoVMERGE_VVM_M1", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VVM_M1)
  .value("PseudoVMERGE_VVM_M2", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VVM_M2)
  .value("PseudoVMERGE_VVM_M4", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VVM_M4)
  .value("PseudoVMERGE_VVM_M8", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VVM_M8)
  .value("PseudoVMERGE_VVM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VVM_MF2)
  .value("PseudoVMERGE_VVM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VVM_MF4)
  .value("PseudoVMERGE_VVM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VVM_MF8)
  .value("PseudoVMERGE_VXM_M1", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VXM_M1)
  .value("PseudoVMERGE_VXM_M2", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VXM_M2)
  .value("PseudoVMERGE_VXM_M4", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VXM_M4)
  .value("PseudoVMERGE_VXM_M8", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VXM_M8)
  .value("PseudoVMERGE_VXM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VXM_MF2)
  .value("PseudoVMERGE_VXM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VXM_MF4)
  .value("PseudoVMERGE_VXM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMERGE_VXM_MF8)
  .value("PseudoVMFEQ_VFPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_M1)
  .value("PseudoVMFEQ_VFPR16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_M1_MASK)
  .value("PseudoVMFEQ_VFPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_M2)
  .value("PseudoVMFEQ_VFPR16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_M2_MASK)
  .value("PseudoVMFEQ_VFPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_M4)
  .value("PseudoVMFEQ_VFPR16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_M4_MASK)
  .value("PseudoVMFEQ_VFPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_M8)
  .value("PseudoVMFEQ_VFPR16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_M8_MASK)
  .value("PseudoVMFEQ_VFPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_MF2)
  .value("PseudoVMFEQ_VFPR16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_MF2_MASK)
  .value("PseudoVMFEQ_VFPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_MF4)
  .value("PseudoVMFEQ_VFPR16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR16_MF4_MASK)
  .value("PseudoVMFEQ_VFPR32_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR32_M1)
  .value("PseudoVMFEQ_VFPR32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR32_M1_MASK)
  .value("PseudoVMFEQ_VFPR32_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR32_M2)
  .value("PseudoVMFEQ_VFPR32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR32_M2_MASK)
  .value("PseudoVMFEQ_VFPR32_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR32_M4)
  .value("PseudoVMFEQ_VFPR32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR32_M4_MASK)
  .value("PseudoVMFEQ_VFPR32_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR32_M8)
  .value("PseudoVMFEQ_VFPR32_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR32_M8_MASK)
  .value("PseudoVMFEQ_VFPR32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR32_MF2)
  .value("PseudoVMFEQ_VFPR32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR32_MF2_MASK)
  .value("PseudoVMFEQ_VFPR64_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR64_M1)
  .value("PseudoVMFEQ_VFPR64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR64_M1_MASK)
  .value("PseudoVMFEQ_VFPR64_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR64_M2)
  .value("PseudoVMFEQ_VFPR64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR64_M2_MASK)
  .value("PseudoVMFEQ_VFPR64_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR64_M4)
  .value("PseudoVMFEQ_VFPR64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR64_M4_MASK)
  .value("PseudoVMFEQ_VFPR64_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR64_M8)
  .value("PseudoVMFEQ_VFPR64_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VFPR64_M8_MASK)
  .value("PseudoVMFEQ_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_M1)
  .value("PseudoVMFEQ_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_M1_MASK)
  .value("PseudoVMFEQ_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_M2)
  .value("PseudoVMFEQ_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_M2_MASK)
  .value("PseudoVMFEQ_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_M4)
  .value("PseudoVMFEQ_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_M4_MASK)
  .value("PseudoVMFEQ_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_M8)
  .value("PseudoVMFEQ_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_M8_MASK)
  .value("PseudoVMFEQ_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_MF2)
  .value("PseudoVMFEQ_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_MF2_MASK)
  .value("PseudoVMFEQ_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_MF4)
  .value("PseudoVMFEQ_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFEQ_VV_MF4_MASK)
  .value("PseudoVMFGE_VFPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_M1)
  .value("PseudoVMFGE_VFPR16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_M1_MASK)
  .value("PseudoVMFGE_VFPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_M2)
  .value("PseudoVMFGE_VFPR16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_M2_MASK)
  .value("PseudoVMFGE_VFPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_M4)
  .value("PseudoVMFGE_VFPR16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_M4_MASK)
  .value("PseudoVMFGE_VFPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_M8)
  .value("PseudoVMFGE_VFPR16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_M8_MASK)
  .value("PseudoVMFGE_VFPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_MF2)
  .value("PseudoVMFGE_VFPR16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_MF2_MASK)
  .value("PseudoVMFGE_VFPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_MF4)
  .value("PseudoVMFGE_VFPR16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR16_MF4_MASK)
  .value("PseudoVMFGE_VFPR32_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR32_M1)
  .value("PseudoVMFGE_VFPR32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR32_M1_MASK)
  .value("PseudoVMFGE_VFPR32_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR32_M2)
  .value("PseudoVMFGE_VFPR32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR32_M2_MASK)
  .value("PseudoVMFGE_VFPR32_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR32_M4)
  .value("PseudoVMFGE_VFPR32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR32_M4_MASK)
  .value("PseudoVMFGE_VFPR32_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR32_M8)
  .value("PseudoVMFGE_VFPR32_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR32_M8_MASK)
  .value("PseudoVMFGE_VFPR32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR32_MF2)
  .value("PseudoVMFGE_VFPR32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR32_MF2_MASK)
  .value("PseudoVMFGE_VFPR64_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR64_M1)
  .value("PseudoVMFGE_VFPR64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR64_M1_MASK)
  .value("PseudoVMFGE_VFPR64_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR64_M2)
  .value("PseudoVMFGE_VFPR64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR64_M2_MASK)
  .value("PseudoVMFGE_VFPR64_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR64_M4)
  .value("PseudoVMFGE_VFPR64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR64_M4_MASK)
  .value("PseudoVMFGE_VFPR64_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR64_M8)
  .value("PseudoVMFGE_VFPR64_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGE_VFPR64_M8_MASK)
  .value("PseudoVMFGT_VFPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_M1)
  .value("PseudoVMFGT_VFPR16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_M1_MASK)
  .value("PseudoVMFGT_VFPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_M2)
  .value("PseudoVMFGT_VFPR16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_M2_MASK)
  .value("PseudoVMFGT_VFPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_M4)
  .value("PseudoVMFGT_VFPR16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_M4_MASK)
  .value("PseudoVMFGT_VFPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_M8)
  .value("PseudoVMFGT_VFPR16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_M8_MASK)
  .value("PseudoVMFGT_VFPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_MF2)
  .value("PseudoVMFGT_VFPR16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_MF2_MASK)
  .value("PseudoVMFGT_VFPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_MF4)
  .value("PseudoVMFGT_VFPR16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR16_MF4_MASK)
  .value("PseudoVMFGT_VFPR32_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR32_M1)
  .value("PseudoVMFGT_VFPR32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR32_M1_MASK)
  .value("PseudoVMFGT_VFPR32_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR32_M2)
  .value("PseudoVMFGT_VFPR32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR32_M2_MASK)
  .value("PseudoVMFGT_VFPR32_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR32_M4)
  .value("PseudoVMFGT_VFPR32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR32_M4_MASK)
  .value("PseudoVMFGT_VFPR32_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR32_M8)
  .value("PseudoVMFGT_VFPR32_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR32_M8_MASK)
  .value("PseudoVMFGT_VFPR32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR32_MF2)
  .value("PseudoVMFGT_VFPR32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR32_MF2_MASK)
  .value("PseudoVMFGT_VFPR64_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR64_M1)
  .value("PseudoVMFGT_VFPR64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR64_M1_MASK)
  .value("PseudoVMFGT_VFPR64_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR64_M2)
  .value("PseudoVMFGT_VFPR64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR64_M2_MASK)
  .value("PseudoVMFGT_VFPR64_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR64_M4)
  .value("PseudoVMFGT_VFPR64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR64_M4_MASK)
  .value("PseudoVMFGT_VFPR64_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR64_M8)
  .value("PseudoVMFGT_VFPR64_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFGT_VFPR64_M8_MASK)
  .value("PseudoVMFLE_VFPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_M1)
  .value("PseudoVMFLE_VFPR16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_M1_MASK)
  .value("PseudoVMFLE_VFPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_M2)
  .value("PseudoVMFLE_VFPR16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_M2_MASK)
  .value("PseudoVMFLE_VFPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_M4)
  .value("PseudoVMFLE_VFPR16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_M4_MASK)
  .value("PseudoVMFLE_VFPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_M8)
  .value("PseudoVMFLE_VFPR16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_M8_MASK)
  .value("PseudoVMFLE_VFPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_MF2)
  .value("PseudoVMFLE_VFPR16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_MF2_MASK)
  .value("PseudoVMFLE_VFPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_MF4)
  .value("PseudoVMFLE_VFPR16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR16_MF4_MASK)
  .value("PseudoVMFLE_VFPR32_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR32_M1)
  .value("PseudoVMFLE_VFPR32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR32_M1_MASK)
  .value("PseudoVMFLE_VFPR32_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR32_M2)
  .value("PseudoVMFLE_VFPR32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR32_M2_MASK)
  .value("PseudoVMFLE_VFPR32_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR32_M4)
  .value("PseudoVMFLE_VFPR32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR32_M4_MASK)
  .value("PseudoVMFLE_VFPR32_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR32_M8)
  .value("PseudoVMFLE_VFPR32_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR32_M8_MASK)
  .value("PseudoVMFLE_VFPR32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR32_MF2)
  .value("PseudoVMFLE_VFPR32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR32_MF2_MASK)
  .value("PseudoVMFLE_VFPR64_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR64_M1)
  .value("PseudoVMFLE_VFPR64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR64_M1_MASK)
  .value("PseudoVMFLE_VFPR64_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR64_M2)
  .value("PseudoVMFLE_VFPR64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR64_M2_MASK)
  .value("PseudoVMFLE_VFPR64_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR64_M4)
  .value("PseudoVMFLE_VFPR64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR64_M4_MASK)
  .value("PseudoVMFLE_VFPR64_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR64_M8)
  .value("PseudoVMFLE_VFPR64_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VFPR64_M8_MASK)
  .value("PseudoVMFLE_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_M1)
  .value("PseudoVMFLE_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_M1_MASK)
  .value("PseudoVMFLE_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_M2)
  .value("PseudoVMFLE_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_M2_MASK)
  .value("PseudoVMFLE_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_M4)
  .value("PseudoVMFLE_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_M4_MASK)
  .value("PseudoVMFLE_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_M8)
  .value("PseudoVMFLE_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_M8_MASK)
  .value("PseudoVMFLE_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_MF2)
  .value("PseudoVMFLE_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_MF2_MASK)
  .value("PseudoVMFLE_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_MF4)
  .value("PseudoVMFLE_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLE_VV_MF4_MASK)
  .value("PseudoVMFLT_VFPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_M1)
  .value("PseudoVMFLT_VFPR16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_M1_MASK)
  .value("PseudoVMFLT_VFPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_M2)
  .value("PseudoVMFLT_VFPR16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_M2_MASK)
  .value("PseudoVMFLT_VFPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_M4)
  .value("PseudoVMFLT_VFPR16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_M4_MASK)
  .value("PseudoVMFLT_VFPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_M8)
  .value("PseudoVMFLT_VFPR16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_M8_MASK)
  .value("PseudoVMFLT_VFPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_MF2)
  .value("PseudoVMFLT_VFPR16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_MF2_MASK)
  .value("PseudoVMFLT_VFPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_MF4)
  .value("PseudoVMFLT_VFPR16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR16_MF4_MASK)
  .value("PseudoVMFLT_VFPR32_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR32_M1)
  .value("PseudoVMFLT_VFPR32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR32_M1_MASK)
  .value("PseudoVMFLT_VFPR32_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR32_M2)
  .value("PseudoVMFLT_VFPR32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR32_M2_MASK)
  .value("PseudoVMFLT_VFPR32_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR32_M4)
  .value("PseudoVMFLT_VFPR32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR32_M4_MASK)
  .value("PseudoVMFLT_VFPR32_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR32_M8)
  .value("PseudoVMFLT_VFPR32_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR32_M8_MASK)
  .value("PseudoVMFLT_VFPR32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR32_MF2)
  .value("PseudoVMFLT_VFPR32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR32_MF2_MASK)
  .value("PseudoVMFLT_VFPR64_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR64_M1)
  .value("PseudoVMFLT_VFPR64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR64_M1_MASK)
  .value("PseudoVMFLT_VFPR64_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR64_M2)
  .value("PseudoVMFLT_VFPR64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR64_M2_MASK)
  .value("PseudoVMFLT_VFPR64_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR64_M4)
  .value("PseudoVMFLT_VFPR64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR64_M4_MASK)
  .value("PseudoVMFLT_VFPR64_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR64_M8)
  .value("PseudoVMFLT_VFPR64_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VFPR64_M8_MASK)
  .value("PseudoVMFLT_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_M1)
  .value("PseudoVMFLT_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_M1_MASK)
  .value("PseudoVMFLT_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_M2)
  .value("PseudoVMFLT_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_M2_MASK)
  .value("PseudoVMFLT_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_M4)
  .value("PseudoVMFLT_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_M4_MASK)
  .value("PseudoVMFLT_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_M8)
  .value("PseudoVMFLT_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_M8_MASK)
  .value("PseudoVMFLT_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_MF2)
  .value("PseudoVMFLT_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_MF2_MASK)
  .value("PseudoVMFLT_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_MF4)
  .value("PseudoVMFLT_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFLT_VV_MF4_MASK)
  .value("PseudoVMFNE_VFPR16_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_M1)
  .value("PseudoVMFNE_VFPR16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_M1_MASK)
  .value("PseudoVMFNE_VFPR16_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_M2)
  .value("PseudoVMFNE_VFPR16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_M2_MASK)
  .value("PseudoVMFNE_VFPR16_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_M4)
  .value("PseudoVMFNE_VFPR16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_M4_MASK)
  .value("PseudoVMFNE_VFPR16_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_M8)
  .value("PseudoVMFNE_VFPR16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_M8_MASK)
  .value("PseudoVMFNE_VFPR16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_MF2)
  .value("PseudoVMFNE_VFPR16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_MF2_MASK)
  .value("PseudoVMFNE_VFPR16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_MF4)
  .value("PseudoVMFNE_VFPR16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR16_MF4_MASK)
  .value("PseudoVMFNE_VFPR32_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR32_M1)
  .value("PseudoVMFNE_VFPR32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR32_M1_MASK)
  .value("PseudoVMFNE_VFPR32_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR32_M2)
  .value("PseudoVMFNE_VFPR32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR32_M2_MASK)
  .value("PseudoVMFNE_VFPR32_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR32_M4)
  .value("PseudoVMFNE_VFPR32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR32_M4_MASK)
  .value("PseudoVMFNE_VFPR32_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR32_M8)
  .value("PseudoVMFNE_VFPR32_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR32_M8_MASK)
  .value("PseudoVMFNE_VFPR32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR32_MF2)
  .value("PseudoVMFNE_VFPR32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR32_MF2_MASK)
  .value("PseudoVMFNE_VFPR64_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR64_M1)
  .value("PseudoVMFNE_VFPR64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR64_M1_MASK)
  .value("PseudoVMFNE_VFPR64_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR64_M2)
  .value("PseudoVMFNE_VFPR64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR64_M2_MASK)
  .value("PseudoVMFNE_VFPR64_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR64_M4)
  .value("PseudoVMFNE_VFPR64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR64_M4_MASK)
  .value("PseudoVMFNE_VFPR64_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR64_M8)
  .value("PseudoVMFNE_VFPR64_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VFPR64_M8_MASK)
  .value("PseudoVMFNE_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_M1)
  .value("PseudoVMFNE_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_M1_MASK)
  .value("PseudoVMFNE_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_M2)
  .value("PseudoVMFNE_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_M2_MASK)
  .value("PseudoVMFNE_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_M4)
  .value("PseudoVMFNE_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_M4_MASK)
  .value("PseudoVMFNE_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_M8)
  .value("PseudoVMFNE_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_M8_MASK)
  .value("PseudoVMFNE_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_MF2)
  .value("PseudoVMFNE_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_MF2_MASK)
  .value("PseudoVMFNE_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_MF4)
  .value("PseudoVMFNE_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMFNE_VV_MF4_MASK);
  opcodes.value("PseudoVMINU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_M1)
  .value("PseudoVMINU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_M1_MASK)
  .value("PseudoVMINU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_M2)
  .value("PseudoVMINU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_M2_MASK)
  .value("PseudoVMINU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_M4)
  .value("PseudoVMINU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_M4_MASK)
  .value("PseudoVMINU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_M8)
  .value("PseudoVMINU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_M8_MASK)
  .value("PseudoVMINU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_MF2)
  .value("PseudoVMINU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_MF2_MASK)
  .value("PseudoVMINU_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_MF4)
  .value("PseudoVMINU_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_MF4_MASK)
  .value("PseudoVMINU_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_MF8)
  .value("PseudoVMINU_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VV_MF8_MASK)
  .value("PseudoVMINU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_M1)
  .value("PseudoVMINU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_M1_MASK)
  .value("PseudoVMINU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_M2)
  .value("PseudoVMINU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_M2_MASK)
  .value("PseudoVMINU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_M4)
  .value("PseudoVMINU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_M4_MASK)
  .value("PseudoVMINU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_M8)
  .value("PseudoVMINU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_M8_MASK)
  .value("PseudoVMINU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_MF2)
  .value("PseudoVMINU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_MF2_MASK)
  .value("PseudoVMINU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_MF4)
  .value("PseudoVMINU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_MF4_MASK)
  .value("PseudoVMINU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_MF8)
  .value("PseudoVMINU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMINU_VX_MF8_MASK)
  .value("PseudoVMIN_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_M1)
  .value("PseudoVMIN_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_M1_MASK)
  .value("PseudoVMIN_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_M2)
  .value("PseudoVMIN_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_M2_MASK)
  .value("PseudoVMIN_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_M4)
  .value("PseudoVMIN_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_M4_MASK)
  .value("PseudoVMIN_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_M8)
  .value("PseudoVMIN_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_M8_MASK)
  .value("PseudoVMIN_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_MF2)
  .value("PseudoVMIN_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_MF2_MASK)
  .value("PseudoVMIN_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_MF4)
  .value("PseudoVMIN_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_MF4_MASK)
  .value("PseudoVMIN_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_MF8)
  .value("PseudoVMIN_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VV_MF8_MASK)
  .value("PseudoVMIN_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_M1)
  .value("PseudoVMIN_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_M1_MASK)
  .value("PseudoVMIN_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_M2)
  .value("PseudoVMIN_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_M2_MASK)
  .value("PseudoVMIN_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_M4)
  .value("PseudoVMIN_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_M4_MASK)
  .value("PseudoVMIN_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_M8)
  .value("PseudoVMIN_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_M8_MASK)
  .value("PseudoVMIN_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_MF2)
  .value("PseudoVMIN_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_MF2_MASK)
  .value("PseudoVMIN_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_MF4)
  .value("PseudoVMIN_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_MF4_MASK)
  .value("PseudoVMIN_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_MF8)
  .value("PseudoVMIN_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMIN_VX_MF8_MASK)
  .value("PseudoVMNAND_MM_B1", LIEF::assembly::riscv::OPCODE::PseudoVMNAND_MM_B1)
  .value("PseudoVMNAND_MM_B16", LIEF::assembly::riscv::OPCODE::PseudoVMNAND_MM_B16)
  .value("PseudoVMNAND_MM_B2", LIEF::assembly::riscv::OPCODE::PseudoVMNAND_MM_B2)
  .value("PseudoVMNAND_MM_B32", LIEF::assembly::riscv::OPCODE::PseudoVMNAND_MM_B32)
  .value("PseudoVMNAND_MM_B4", LIEF::assembly::riscv::OPCODE::PseudoVMNAND_MM_B4)
  .value("PseudoVMNAND_MM_B64", LIEF::assembly::riscv::OPCODE::PseudoVMNAND_MM_B64)
  .value("PseudoVMNAND_MM_B8", LIEF::assembly::riscv::OPCODE::PseudoVMNAND_MM_B8)
  .value("PseudoVMNOR_MM_B1", LIEF::assembly::riscv::OPCODE::PseudoVMNOR_MM_B1)
  .value("PseudoVMNOR_MM_B16", LIEF::assembly::riscv::OPCODE::PseudoVMNOR_MM_B16)
  .value("PseudoVMNOR_MM_B2", LIEF::assembly::riscv::OPCODE::PseudoVMNOR_MM_B2)
  .value("PseudoVMNOR_MM_B32", LIEF::assembly::riscv::OPCODE::PseudoVMNOR_MM_B32)
  .value("PseudoVMNOR_MM_B4", LIEF::assembly::riscv::OPCODE::PseudoVMNOR_MM_B4)
  .value("PseudoVMNOR_MM_B64", LIEF::assembly::riscv::OPCODE::PseudoVMNOR_MM_B64)
  .value("PseudoVMNOR_MM_B8", LIEF::assembly::riscv::OPCODE::PseudoVMNOR_MM_B8)
  .value("PseudoVMORN_MM_B1", LIEF::assembly::riscv::OPCODE::PseudoVMORN_MM_B1)
  .value("PseudoVMORN_MM_B16", LIEF::assembly::riscv::OPCODE::PseudoVMORN_MM_B16)
  .value("PseudoVMORN_MM_B2", LIEF::assembly::riscv::OPCODE::PseudoVMORN_MM_B2)
  .value("PseudoVMORN_MM_B32", LIEF::assembly::riscv::OPCODE::PseudoVMORN_MM_B32)
  .value("PseudoVMORN_MM_B4", LIEF::assembly::riscv::OPCODE::PseudoVMORN_MM_B4)
  .value("PseudoVMORN_MM_B64", LIEF::assembly::riscv::OPCODE::PseudoVMORN_MM_B64)
  .value("PseudoVMORN_MM_B8", LIEF::assembly::riscv::OPCODE::PseudoVMORN_MM_B8)
  .value("PseudoVMOR_MM_B1", LIEF::assembly::riscv::OPCODE::PseudoVMOR_MM_B1)
  .value("PseudoVMOR_MM_B16", LIEF::assembly::riscv::OPCODE::PseudoVMOR_MM_B16)
  .value("PseudoVMOR_MM_B2", LIEF::assembly::riscv::OPCODE::PseudoVMOR_MM_B2)
  .value("PseudoVMOR_MM_B32", LIEF::assembly::riscv::OPCODE::PseudoVMOR_MM_B32)
  .value("PseudoVMOR_MM_B4", LIEF::assembly::riscv::OPCODE::PseudoVMOR_MM_B4)
  .value("PseudoVMOR_MM_B64", LIEF::assembly::riscv::OPCODE::PseudoVMOR_MM_B64)
  .value("PseudoVMOR_MM_B8", LIEF::assembly::riscv::OPCODE::PseudoVMOR_MM_B8)
  .value("PseudoVMSBC_VVM_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VVM_M1)
  .value("PseudoVMSBC_VVM_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VVM_M2)
  .value("PseudoVMSBC_VVM_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VVM_M4)
  .value("PseudoVMSBC_VVM_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VVM_M8)
  .value("PseudoVMSBC_VVM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VVM_MF2)
  .value("PseudoVMSBC_VVM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VVM_MF4)
  .value("PseudoVMSBC_VVM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VVM_MF8)
  .value("PseudoVMSBC_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VV_M1)
  .value("PseudoVMSBC_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VV_M2)
  .value("PseudoVMSBC_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VV_M4)
  .value("PseudoVMSBC_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VV_M8)
  .value("PseudoVMSBC_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VV_MF2)
  .value("PseudoVMSBC_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VV_MF4)
  .value("PseudoVMSBC_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VV_MF8)
  .value("PseudoVMSBC_VXM_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VXM_M1)
  .value("PseudoVMSBC_VXM_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VXM_M2)
  .value("PseudoVMSBC_VXM_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VXM_M4)
  .value("PseudoVMSBC_VXM_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VXM_M8)
  .value("PseudoVMSBC_VXM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VXM_MF2)
  .value("PseudoVMSBC_VXM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VXM_MF4)
  .value("PseudoVMSBC_VXM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VXM_MF8)
  .value("PseudoVMSBC_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VX_M1)
  .value("PseudoVMSBC_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VX_M2)
  .value("PseudoVMSBC_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VX_M4)
  .value("PseudoVMSBC_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VX_M8)
  .value("PseudoVMSBC_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VX_MF2)
  .value("PseudoVMSBC_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VX_MF4)
  .value("PseudoVMSBC_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSBC_VX_MF8)
  .value("PseudoVMSBF_M_B1", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B1)
  .value("PseudoVMSBF_M_B16", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B16)
  .value("PseudoVMSBF_M_B16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B16_MASK)
  .value("PseudoVMSBF_M_B1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B1_MASK)
  .value("PseudoVMSBF_M_B2", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B2)
  .value("PseudoVMSBF_M_B2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B2_MASK)
  .value("PseudoVMSBF_M_B32", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B32)
  .value("PseudoVMSBF_M_B32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B32_MASK)
  .value("PseudoVMSBF_M_B4", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B4)
  .value("PseudoVMSBF_M_B4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B4_MASK)
  .value("PseudoVMSBF_M_B64", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B64)
  .value("PseudoVMSBF_M_B64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B64_MASK)
  .value("PseudoVMSBF_M_B8", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B8)
  .value("PseudoVMSBF_M_B8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSBF_M_B8_MASK)
  .value("PseudoVMSEQ_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_M1)
  .value("PseudoVMSEQ_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_M1_MASK)
  .value("PseudoVMSEQ_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_M2)
  .value("PseudoVMSEQ_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_M2_MASK)
  .value("PseudoVMSEQ_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_M4)
  .value("PseudoVMSEQ_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_M4_MASK)
  .value("PseudoVMSEQ_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_M8)
  .value("PseudoVMSEQ_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_M8_MASK)
  .value("PseudoVMSEQ_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_MF2)
  .value("PseudoVMSEQ_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_MF2_MASK)
  .value("PseudoVMSEQ_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_MF4)
  .value("PseudoVMSEQ_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_MF4_MASK)
  .value("PseudoVMSEQ_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_MF8)
  .value("PseudoVMSEQ_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VI_MF8_MASK)
  .value("PseudoVMSEQ_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_M1)
  .value("PseudoVMSEQ_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_M1_MASK)
  .value("PseudoVMSEQ_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_M2)
  .value("PseudoVMSEQ_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_M2_MASK)
  .value("PseudoVMSEQ_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_M4)
  .value("PseudoVMSEQ_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_M4_MASK)
  .value("PseudoVMSEQ_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_M8)
  .value("PseudoVMSEQ_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_M8_MASK)
  .value("PseudoVMSEQ_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_MF2)
  .value("PseudoVMSEQ_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_MF2_MASK)
  .value("PseudoVMSEQ_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_MF4)
  .value("PseudoVMSEQ_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_MF4_MASK)
  .value("PseudoVMSEQ_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_MF8)
  .value("PseudoVMSEQ_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VV_MF8_MASK)
  .value("PseudoVMSEQ_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_M1)
  .value("PseudoVMSEQ_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_M1_MASK)
  .value("PseudoVMSEQ_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_M2)
  .value("PseudoVMSEQ_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_M2_MASK)
  .value("PseudoVMSEQ_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_M4)
  .value("PseudoVMSEQ_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_M4_MASK)
  .value("PseudoVMSEQ_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_M8)
  .value("PseudoVMSEQ_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_M8_MASK)
  .value("PseudoVMSEQ_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_MF2)
  .value("PseudoVMSEQ_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_MF2_MASK)
  .value("PseudoVMSEQ_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_MF4)
  .value("PseudoVMSEQ_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_MF4_MASK)
  .value("PseudoVMSEQ_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_MF8)
  .value("PseudoVMSEQ_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSEQ_VX_MF8_MASK)
  .value("PseudoVMSET_M_B1", LIEF::assembly::riscv::OPCODE::PseudoVMSET_M_B1)
  .value("PseudoVMSET_M_B16", LIEF::assembly::riscv::OPCODE::PseudoVMSET_M_B16)
  .value("PseudoVMSET_M_B2", LIEF::assembly::riscv::OPCODE::PseudoVMSET_M_B2)
  .value("PseudoVMSET_M_B32", LIEF::assembly::riscv::OPCODE::PseudoVMSET_M_B32)
  .value("PseudoVMSET_M_B4", LIEF::assembly::riscv::OPCODE::PseudoVMSET_M_B4)
  .value("PseudoVMSET_M_B64", LIEF::assembly::riscv::OPCODE::PseudoVMSET_M_B64)
  .value("PseudoVMSET_M_B8", LIEF::assembly::riscv::OPCODE::PseudoVMSET_M_B8)
  .value("PseudoVMSGEU_VI", LIEF::assembly::riscv::OPCODE::PseudoVMSGEU_VI)
  .value("PseudoVMSGEU_VX", LIEF::assembly::riscv::OPCODE::PseudoVMSGEU_VX)
  .value("PseudoVMSGEU_VX_M", LIEF::assembly::riscv::OPCODE::PseudoVMSGEU_VX_M)
  .value("PseudoVMSGEU_VX_M_T", LIEF::assembly::riscv::OPCODE::PseudoVMSGEU_VX_M_T)
  .value("PseudoVMSGE_VI", LIEF::assembly::riscv::OPCODE::PseudoVMSGE_VI)
  .value("PseudoVMSGE_VX", LIEF::assembly::riscv::OPCODE::PseudoVMSGE_VX)
  .value("PseudoVMSGE_VX_M", LIEF::assembly::riscv::OPCODE::PseudoVMSGE_VX_M)
  .value("PseudoVMSGE_VX_M_T", LIEF::assembly::riscv::OPCODE::PseudoVMSGE_VX_M_T)
  .value("PseudoVMSGTU_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_M1)
  .value("PseudoVMSGTU_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_M1_MASK)
  .value("PseudoVMSGTU_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_M2)
  .value("PseudoVMSGTU_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_M2_MASK)
  .value("PseudoVMSGTU_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_M4)
  .value("PseudoVMSGTU_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_M4_MASK)
  .value("PseudoVMSGTU_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_M8)
  .value("PseudoVMSGTU_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_M8_MASK)
  .value("PseudoVMSGTU_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_MF2)
  .value("PseudoVMSGTU_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_MF2_MASK)
  .value("PseudoVMSGTU_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_MF4)
  .value("PseudoVMSGTU_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_MF4_MASK)
  .value("PseudoVMSGTU_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_MF8)
  .value("PseudoVMSGTU_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VI_MF8_MASK)
  .value("PseudoVMSGTU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_M1)
  .value("PseudoVMSGTU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_M1_MASK)
  .value("PseudoVMSGTU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_M2)
  .value("PseudoVMSGTU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_M2_MASK)
  .value("PseudoVMSGTU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_M4)
  .value("PseudoVMSGTU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_M4_MASK)
  .value("PseudoVMSGTU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_M8)
  .value("PseudoVMSGTU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_M8_MASK)
  .value("PseudoVMSGTU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_MF2)
  .value("PseudoVMSGTU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_MF2_MASK)
  .value("PseudoVMSGTU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_MF4)
  .value("PseudoVMSGTU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_MF4_MASK)
  .value("PseudoVMSGTU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_MF8)
  .value("PseudoVMSGTU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGTU_VX_MF8_MASK)
  .value("PseudoVMSGT_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_M1)
  .value("PseudoVMSGT_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_M1_MASK)
  .value("PseudoVMSGT_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_M2)
  .value("PseudoVMSGT_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_M2_MASK)
  .value("PseudoVMSGT_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_M4)
  .value("PseudoVMSGT_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_M4_MASK)
  .value("PseudoVMSGT_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_M8)
  .value("PseudoVMSGT_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_M8_MASK)
  .value("PseudoVMSGT_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_MF2)
  .value("PseudoVMSGT_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_MF2_MASK)
  .value("PseudoVMSGT_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_MF4)
  .value("PseudoVMSGT_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_MF4_MASK)
  .value("PseudoVMSGT_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_MF8)
  .value("PseudoVMSGT_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VI_MF8_MASK)
  .value("PseudoVMSGT_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_M1)
  .value("PseudoVMSGT_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_M1_MASK)
  .value("PseudoVMSGT_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_M2)
  .value("PseudoVMSGT_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_M2_MASK)
  .value("PseudoVMSGT_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_M4)
  .value("PseudoVMSGT_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_M4_MASK)
  .value("PseudoVMSGT_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_M8)
  .value("PseudoVMSGT_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_M8_MASK)
  .value("PseudoVMSGT_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_MF2)
  .value("PseudoVMSGT_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_MF2_MASK)
  .value("PseudoVMSGT_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_MF4)
  .value("PseudoVMSGT_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_MF4_MASK)
  .value("PseudoVMSGT_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_MF8)
  .value("PseudoVMSGT_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSGT_VX_MF8_MASK)
  .value("PseudoVMSIF_M_B1", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B1)
  .value("PseudoVMSIF_M_B16", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B16)
  .value("PseudoVMSIF_M_B16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B16_MASK)
  .value("PseudoVMSIF_M_B1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B1_MASK)
  .value("PseudoVMSIF_M_B2", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B2)
  .value("PseudoVMSIF_M_B2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B2_MASK)
  .value("PseudoVMSIF_M_B32", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B32)
  .value("PseudoVMSIF_M_B32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B32_MASK)
  .value("PseudoVMSIF_M_B4", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B4)
  .value("PseudoVMSIF_M_B4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B4_MASK)
  .value("PseudoVMSIF_M_B64", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B64)
  .value("PseudoVMSIF_M_B64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B64_MASK)
  .value("PseudoVMSIF_M_B8", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B8)
  .value("PseudoVMSIF_M_B8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSIF_M_B8_MASK)
  .value("PseudoVMSLEU_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_M1)
  .value("PseudoVMSLEU_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_M1_MASK)
  .value("PseudoVMSLEU_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_M2)
  .value("PseudoVMSLEU_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_M2_MASK)
  .value("PseudoVMSLEU_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_M4)
  .value("PseudoVMSLEU_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_M4_MASK)
  .value("PseudoVMSLEU_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_M8)
  .value("PseudoVMSLEU_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_M8_MASK)
  .value("PseudoVMSLEU_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_MF2)
  .value("PseudoVMSLEU_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_MF2_MASK)
  .value("PseudoVMSLEU_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_MF4)
  .value("PseudoVMSLEU_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_MF4_MASK)
  .value("PseudoVMSLEU_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_MF8)
  .value("PseudoVMSLEU_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VI_MF8_MASK)
  .value("PseudoVMSLEU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_M1)
  .value("PseudoVMSLEU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_M1_MASK)
  .value("PseudoVMSLEU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_M2)
  .value("PseudoVMSLEU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_M2_MASK)
  .value("PseudoVMSLEU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_M4)
  .value("PseudoVMSLEU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_M4_MASK)
  .value("PseudoVMSLEU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_M8)
  .value("PseudoVMSLEU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_M8_MASK)
  .value("PseudoVMSLEU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_MF2)
  .value("PseudoVMSLEU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_MF2_MASK)
  .value("PseudoVMSLEU_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_MF4)
  .value("PseudoVMSLEU_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_MF4_MASK)
  .value("PseudoVMSLEU_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_MF8)
  .value("PseudoVMSLEU_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VV_MF8_MASK)
  .value("PseudoVMSLEU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_M1)
  .value("PseudoVMSLEU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_M1_MASK)
  .value("PseudoVMSLEU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_M2)
  .value("PseudoVMSLEU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_M2_MASK)
  .value("PseudoVMSLEU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_M4)
  .value("PseudoVMSLEU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_M4_MASK)
  .value("PseudoVMSLEU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_M8)
  .value("PseudoVMSLEU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_M8_MASK)
  .value("PseudoVMSLEU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_MF2)
  .value("PseudoVMSLEU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_MF2_MASK)
  .value("PseudoVMSLEU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_MF4)
  .value("PseudoVMSLEU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_MF4_MASK)
  .value("PseudoVMSLEU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_MF8)
  .value("PseudoVMSLEU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLEU_VX_MF8_MASK)
  .value("PseudoVMSLE_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_M1)
  .value("PseudoVMSLE_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_M1_MASK)
  .value("PseudoVMSLE_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_M2)
  .value("PseudoVMSLE_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_M2_MASK)
  .value("PseudoVMSLE_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_M4);
  opcodes.value("PseudoVMSLE_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_M4_MASK)
  .value("PseudoVMSLE_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_M8)
  .value("PseudoVMSLE_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_M8_MASK)
  .value("PseudoVMSLE_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_MF2)
  .value("PseudoVMSLE_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_MF2_MASK)
  .value("PseudoVMSLE_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_MF4)
  .value("PseudoVMSLE_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_MF4_MASK)
  .value("PseudoVMSLE_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_MF8)
  .value("PseudoVMSLE_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VI_MF8_MASK)
  .value("PseudoVMSLE_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_M1)
  .value("PseudoVMSLE_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_M1_MASK)
  .value("PseudoVMSLE_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_M2)
  .value("PseudoVMSLE_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_M2_MASK)
  .value("PseudoVMSLE_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_M4)
  .value("PseudoVMSLE_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_M4_MASK)
  .value("PseudoVMSLE_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_M8)
  .value("PseudoVMSLE_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_M8_MASK)
  .value("PseudoVMSLE_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_MF2)
  .value("PseudoVMSLE_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_MF2_MASK)
  .value("PseudoVMSLE_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_MF4)
  .value("PseudoVMSLE_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_MF4_MASK)
  .value("PseudoVMSLE_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_MF8)
  .value("PseudoVMSLE_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VV_MF8_MASK)
  .value("PseudoVMSLE_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_M1)
  .value("PseudoVMSLE_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_M1_MASK)
  .value("PseudoVMSLE_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_M2)
  .value("PseudoVMSLE_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_M2_MASK)
  .value("PseudoVMSLE_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_M4)
  .value("PseudoVMSLE_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_M4_MASK)
  .value("PseudoVMSLE_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_M8)
  .value("PseudoVMSLE_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_M8_MASK)
  .value("PseudoVMSLE_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_MF2)
  .value("PseudoVMSLE_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_MF2_MASK)
  .value("PseudoVMSLE_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_MF4)
  .value("PseudoVMSLE_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_MF4_MASK)
  .value("PseudoVMSLE_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_MF8)
  .value("PseudoVMSLE_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLE_VX_MF8_MASK)
  .value("PseudoVMSLTU_VI", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VI)
  .value("PseudoVMSLTU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_M1)
  .value("PseudoVMSLTU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_M1_MASK)
  .value("PseudoVMSLTU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_M2)
  .value("PseudoVMSLTU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_M2_MASK)
  .value("PseudoVMSLTU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_M4)
  .value("PseudoVMSLTU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_M4_MASK)
  .value("PseudoVMSLTU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_M8)
  .value("PseudoVMSLTU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_M8_MASK)
  .value("PseudoVMSLTU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_MF2)
  .value("PseudoVMSLTU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_MF2_MASK)
  .value("PseudoVMSLTU_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_MF4)
  .value("PseudoVMSLTU_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_MF4_MASK)
  .value("PseudoVMSLTU_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_MF8)
  .value("PseudoVMSLTU_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VV_MF8_MASK)
  .value("PseudoVMSLTU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_M1)
  .value("PseudoVMSLTU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_M1_MASK)
  .value("PseudoVMSLTU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_M2)
  .value("PseudoVMSLTU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_M2_MASK)
  .value("PseudoVMSLTU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_M4)
  .value("PseudoVMSLTU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_M4_MASK)
  .value("PseudoVMSLTU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_M8)
  .value("PseudoVMSLTU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_M8_MASK)
  .value("PseudoVMSLTU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_MF2)
  .value("PseudoVMSLTU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_MF2_MASK)
  .value("PseudoVMSLTU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_MF4)
  .value("PseudoVMSLTU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_MF4_MASK)
  .value("PseudoVMSLTU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_MF8)
  .value("PseudoVMSLTU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLTU_VX_MF8_MASK)
  .value("PseudoVMSLT_VI", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VI)
  .value("PseudoVMSLT_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_M1)
  .value("PseudoVMSLT_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_M1_MASK)
  .value("PseudoVMSLT_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_M2)
  .value("PseudoVMSLT_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_M2_MASK)
  .value("PseudoVMSLT_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_M4)
  .value("PseudoVMSLT_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_M4_MASK)
  .value("PseudoVMSLT_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_M8)
  .value("PseudoVMSLT_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_M8_MASK)
  .value("PseudoVMSLT_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_MF2)
  .value("PseudoVMSLT_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_MF2_MASK)
  .value("PseudoVMSLT_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_MF4)
  .value("PseudoVMSLT_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_MF4_MASK)
  .value("PseudoVMSLT_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_MF8)
  .value("PseudoVMSLT_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VV_MF8_MASK)
  .value("PseudoVMSLT_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_M1)
  .value("PseudoVMSLT_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_M1_MASK)
  .value("PseudoVMSLT_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_M2)
  .value("PseudoVMSLT_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_M2_MASK)
  .value("PseudoVMSLT_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_M4)
  .value("PseudoVMSLT_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_M4_MASK)
  .value("PseudoVMSLT_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_M8)
  .value("PseudoVMSLT_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_M8_MASK)
  .value("PseudoVMSLT_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_MF2)
  .value("PseudoVMSLT_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_MF2_MASK)
  .value("PseudoVMSLT_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_MF4)
  .value("PseudoVMSLT_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_MF4_MASK)
  .value("PseudoVMSLT_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_MF8)
  .value("PseudoVMSLT_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSLT_VX_MF8_MASK)
  .value("PseudoVMSNE_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_M1)
  .value("PseudoVMSNE_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_M1_MASK)
  .value("PseudoVMSNE_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_M2)
  .value("PseudoVMSNE_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_M2_MASK)
  .value("PseudoVMSNE_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_M4)
  .value("PseudoVMSNE_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_M4_MASK)
  .value("PseudoVMSNE_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_M8)
  .value("PseudoVMSNE_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_M8_MASK)
  .value("PseudoVMSNE_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_MF2)
  .value("PseudoVMSNE_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_MF2_MASK)
  .value("PseudoVMSNE_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_MF4)
  .value("PseudoVMSNE_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_MF4_MASK)
  .value("PseudoVMSNE_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_MF8)
  .value("PseudoVMSNE_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VI_MF8_MASK)
  .value("PseudoVMSNE_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_M1)
  .value("PseudoVMSNE_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_M1_MASK)
  .value("PseudoVMSNE_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_M2)
  .value("PseudoVMSNE_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_M2_MASK)
  .value("PseudoVMSNE_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_M4)
  .value("PseudoVMSNE_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_M4_MASK)
  .value("PseudoVMSNE_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_M8)
  .value("PseudoVMSNE_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_M8_MASK)
  .value("PseudoVMSNE_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_MF2)
  .value("PseudoVMSNE_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_MF2_MASK)
  .value("PseudoVMSNE_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_MF4)
  .value("PseudoVMSNE_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_MF4_MASK)
  .value("PseudoVMSNE_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_MF8)
  .value("PseudoVMSNE_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VV_MF8_MASK)
  .value("PseudoVMSNE_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_M1)
  .value("PseudoVMSNE_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_M1_MASK)
  .value("PseudoVMSNE_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_M2)
  .value("PseudoVMSNE_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_M2_MASK)
  .value("PseudoVMSNE_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_M4)
  .value("PseudoVMSNE_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_M4_MASK)
  .value("PseudoVMSNE_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_M8)
  .value("PseudoVMSNE_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_M8_MASK)
  .value("PseudoVMSNE_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_MF2)
  .value("PseudoVMSNE_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_MF2_MASK)
  .value("PseudoVMSNE_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_MF4)
  .value("PseudoVMSNE_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_MF4_MASK)
  .value("PseudoVMSNE_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_MF8)
  .value("PseudoVMSNE_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSNE_VX_MF8_MASK)
  .value("PseudoVMSOF_M_B1", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B1)
  .value("PseudoVMSOF_M_B16", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B16)
  .value("PseudoVMSOF_M_B16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B16_MASK)
  .value("PseudoVMSOF_M_B1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B1_MASK)
  .value("PseudoVMSOF_M_B2", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B2)
  .value("PseudoVMSOF_M_B2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B2_MASK)
  .value("PseudoVMSOF_M_B32", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B32)
  .value("PseudoVMSOF_M_B32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B32_MASK)
  .value("PseudoVMSOF_M_B4", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B4)
  .value("PseudoVMSOF_M_B4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B4_MASK)
  .value("PseudoVMSOF_M_B64", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B64)
  .value("PseudoVMSOF_M_B64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B64_MASK)
  .value("PseudoVMSOF_M_B8", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B8)
  .value("PseudoVMSOF_M_B8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMSOF_M_B8_MASK)
  .value("PseudoVMULHSU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_M1)
  .value("PseudoVMULHSU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_M1_MASK)
  .value("PseudoVMULHSU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_M2)
  .value("PseudoVMULHSU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_M2_MASK)
  .value("PseudoVMULHSU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_M4)
  .value("PseudoVMULHSU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_M4_MASK)
  .value("PseudoVMULHSU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_M8)
  .value("PseudoVMULHSU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_M8_MASK)
  .value("PseudoVMULHSU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_MF2)
  .value("PseudoVMULHSU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_MF2_MASK)
  .value("PseudoVMULHSU_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_MF4)
  .value("PseudoVMULHSU_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_MF4_MASK)
  .value("PseudoVMULHSU_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_MF8)
  .value("PseudoVMULHSU_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VV_MF8_MASK)
  .value("PseudoVMULHSU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_M1)
  .value("PseudoVMULHSU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_M1_MASK)
  .value("PseudoVMULHSU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_M2)
  .value("PseudoVMULHSU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_M2_MASK)
  .value("PseudoVMULHSU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_M4)
  .value("PseudoVMULHSU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_M4_MASK)
  .value("PseudoVMULHSU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_M8)
  .value("PseudoVMULHSU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_M8_MASK)
  .value("PseudoVMULHSU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_MF2)
  .value("PseudoVMULHSU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_MF2_MASK)
  .value("PseudoVMULHSU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_MF4)
  .value("PseudoVMULHSU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_MF4_MASK)
  .value("PseudoVMULHSU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_MF8)
  .value("PseudoVMULHSU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHSU_VX_MF8_MASK)
  .value("PseudoVMULHU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_M1)
  .value("PseudoVMULHU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_M1_MASK)
  .value("PseudoVMULHU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_M2)
  .value("PseudoVMULHU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_M2_MASK)
  .value("PseudoVMULHU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_M4)
  .value("PseudoVMULHU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_M4_MASK)
  .value("PseudoVMULHU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_M8)
  .value("PseudoVMULHU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_M8_MASK)
  .value("PseudoVMULHU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_MF2)
  .value("PseudoVMULHU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_MF2_MASK)
  .value("PseudoVMULHU_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_MF4)
  .value("PseudoVMULHU_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_MF4_MASK)
  .value("PseudoVMULHU_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_MF8)
  .value("PseudoVMULHU_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VV_MF8_MASK)
  .value("PseudoVMULHU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_M1)
  .value("PseudoVMULHU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_M1_MASK)
  .value("PseudoVMULHU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_M2)
  .value("PseudoVMULHU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_M2_MASK)
  .value("PseudoVMULHU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_M4)
  .value("PseudoVMULHU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_M4_MASK)
  .value("PseudoVMULHU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_M8)
  .value("PseudoVMULHU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_M8_MASK)
  .value("PseudoVMULHU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_MF2)
  .value("PseudoVMULHU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_MF2_MASK)
  .value("PseudoVMULHU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_MF4)
  .value("PseudoVMULHU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_MF4_MASK)
  .value("PseudoVMULHU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_MF8)
  .value("PseudoVMULHU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULHU_VX_MF8_MASK)
  .value("PseudoVMULH_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_M1)
  .value("PseudoVMULH_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_M1_MASK)
  .value("PseudoVMULH_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_M2)
  .value("PseudoVMULH_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_M2_MASK)
  .value("PseudoVMULH_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_M4)
  .value("PseudoVMULH_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_M4_MASK)
  .value("PseudoVMULH_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_M8)
  .value("PseudoVMULH_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_M8_MASK)
  .value("PseudoVMULH_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_MF2)
  .value("PseudoVMULH_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_MF2_MASK)
  .value("PseudoVMULH_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_MF4)
  .value("PseudoVMULH_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_MF4_MASK)
  .value("PseudoVMULH_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_MF8)
  .value("PseudoVMULH_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VV_MF8_MASK)
  .value("PseudoVMULH_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_M1)
  .value("PseudoVMULH_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_M1_MASK)
  .value("PseudoVMULH_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_M2)
  .value("PseudoVMULH_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_M2_MASK)
  .value("PseudoVMULH_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_M4)
  .value("PseudoVMULH_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_M4_MASK)
  .value("PseudoVMULH_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_M8)
  .value("PseudoVMULH_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_M8_MASK)
  .value("PseudoVMULH_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_MF2)
  .value("PseudoVMULH_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_MF2_MASK)
  .value("PseudoVMULH_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_MF4)
  .value("PseudoVMULH_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_MF4_MASK)
  .value("PseudoVMULH_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_MF8)
  .value("PseudoVMULH_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMULH_VX_MF8_MASK)
  .value("PseudoVMUL_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_M1)
  .value("PseudoVMUL_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_M1_MASK)
  .value("PseudoVMUL_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_M2)
  .value("PseudoVMUL_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_M2_MASK)
  .value("PseudoVMUL_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_M4)
  .value("PseudoVMUL_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_M4_MASK)
  .value("PseudoVMUL_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_M8)
  .value("PseudoVMUL_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_M8_MASK)
  .value("PseudoVMUL_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_MF2)
  .value("PseudoVMUL_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_MF2_MASK)
  .value("PseudoVMUL_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_MF4)
  .value("PseudoVMUL_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_MF4_MASK)
  .value("PseudoVMUL_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_MF8)
  .value("PseudoVMUL_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VV_MF8_MASK)
  .value("PseudoVMUL_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_M1)
  .value("PseudoVMUL_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_M1_MASK)
  .value("PseudoVMUL_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_M2)
  .value("PseudoVMUL_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_M2_MASK)
  .value("PseudoVMUL_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_M4)
  .value("PseudoVMUL_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_M4_MASK)
  .value("PseudoVMUL_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_M8)
  .value("PseudoVMUL_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_M8_MASK)
  .value("PseudoVMUL_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_MF2)
  .value("PseudoVMUL_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_MF2_MASK)
  .value("PseudoVMUL_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_MF4)
  .value("PseudoVMUL_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_MF4_MASK)
  .value("PseudoVMUL_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_MF8)
  .value("PseudoVMUL_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVMUL_VX_MF8_MASK)
  .value("PseudoVMV_S_X", LIEF::assembly::riscv::OPCODE::PseudoVMV_S_X)
  .value("PseudoVMV_V_I_M1", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_I_M1)
  .value("PseudoVMV_V_I_M2", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_I_M2)
  .value("PseudoVMV_V_I_M4", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_I_M4)
  .value("PseudoVMV_V_I_M8", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_I_M8)
  .value("PseudoVMV_V_I_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_I_MF2)
  .value("PseudoVMV_V_I_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_I_MF4)
  .value("PseudoVMV_V_I_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_I_MF8)
  .value("PseudoVMV_V_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_V_M1)
  .value("PseudoVMV_V_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_V_M2)
  .value("PseudoVMV_V_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_V_M4)
  .value("PseudoVMV_V_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_V_M8)
  .value("PseudoVMV_V_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_V_MF2)
  .value("PseudoVMV_V_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_V_MF4)
  .value("PseudoVMV_V_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_V_MF8)
  .value("PseudoVMV_V_X_M1", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_X_M1)
  .value("PseudoVMV_V_X_M2", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_X_M2)
  .value("PseudoVMV_V_X_M4", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_X_M4)
  .value("PseudoVMV_V_X_M8", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_X_M8)
  .value("PseudoVMV_V_X_MF2", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_X_MF2)
  .value("PseudoVMV_V_X_MF4", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_X_MF4)
  .value("PseudoVMV_V_X_MF8", LIEF::assembly::riscv::OPCODE::PseudoVMV_V_X_MF8)
  .value("PseudoVMV_X_S", LIEF::assembly::riscv::OPCODE::PseudoVMV_X_S)
  .value("PseudoVMXNOR_MM_B1", LIEF::assembly::riscv::OPCODE::PseudoVMXNOR_MM_B1)
  .value("PseudoVMXNOR_MM_B16", LIEF::assembly::riscv::OPCODE::PseudoVMXNOR_MM_B16)
  .value("PseudoVMXNOR_MM_B2", LIEF::assembly::riscv::OPCODE::PseudoVMXNOR_MM_B2)
  .value("PseudoVMXNOR_MM_B32", LIEF::assembly::riscv::OPCODE::PseudoVMXNOR_MM_B32)
  .value("PseudoVMXNOR_MM_B4", LIEF::assembly::riscv::OPCODE::PseudoVMXNOR_MM_B4)
  .value("PseudoVMXNOR_MM_B64", LIEF::assembly::riscv::OPCODE::PseudoVMXNOR_MM_B64)
  .value("PseudoVMXNOR_MM_B8", LIEF::assembly::riscv::OPCODE::PseudoVMXNOR_MM_B8)
  .value("PseudoVMXOR_MM_B1", LIEF::assembly::riscv::OPCODE::PseudoVMXOR_MM_B1)
  .value("PseudoVMXOR_MM_B16", LIEF::assembly::riscv::OPCODE::PseudoVMXOR_MM_B16)
  .value("PseudoVMXOR_MM_B2", LIEF::assembly::riscv::OPCODE::PseudoVMXOR_MM_B2)
  .value("PseudoVMXOR_MM_B32", LIEF::assembly::riscv::OPCODE::PseudoVMXOR_MM_B32)
  .value("PseudoVMXOR_MM_B4", LIEF::assembly::riscv::OPCODE::PseudoVMXOR_MM_B4)
  .value("PseudoVMXOR_MM_B64", LIEF::assembly::riscv::OPCODE::PseudoVMXOR_MM_B64)
  .value("PseudoVMXOR_MM_B8", LIEF::assembly::riscv::OPCODE::PseudoVMXOR_MM_B8);
  opcodes.value("PseudoVNCLIPU_WI_M1", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_M1)
  .value("PseudoVNCLIPU_WI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_M1_MASK)
  .value("PseudoVNCLIPU_WI_M2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_M2)
  .value("PseudoVNCLIPU_WI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_M2_MASK)
  .value("PseudoVNCLIPU_WI_M4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_M4)
  .value("PseudoVNCLIPU_WI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_M4_MASK)
  .value("PseudoVNCLIPU_WI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_MF2)
  .value("PseudoVNCLIPU_WI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_MF2_MASK)
  .value("PseudoVNCLIPU_WI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_MF4)
  .value("PseudoVNCLIPU_WI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_MF4_MASK)
  .value("PseudoVNCLIPU_WI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_MF8)
  .value("PseudoVNCLIPU_WI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WI_MF8_MASK)
  .value("PseudoVNCLIPU_WV_M1", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_M1)
  .value("PseudoVNCLIPU_WV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_M1_MASK)
  .value("PseudoVNCLIPU_WV_M2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_M2)
  .value("PseudoVNCLIPU_WV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_M2_MASK)
  .value("PseudoVNCLIPU_WV_M4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_M4)
  .value("PseudoVNCLIPU_WV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_M4_MASK)
  .value("PseudoVNCLIPU_WV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_MF2)
  .value("PseudoVNCLIPU_WV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_MF2_MASK)
  .value("PseudoVNCLIPU_WV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_MF4)
  .value("PseudoVNCLIPU_WV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_MF4_MASK)
  .value("PseudoVNCLIPU_WV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_MF8)
  .value("PseudoVNCLIPU_WV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WV_MF8_MASK)
  .value("PseudoVNCLIPU_WX_M1", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_M1)
  .value("PseudoVNCLIPU_WX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_M1_MASK)
  .value("PseudoVNCLIPU_WX_M2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_M2)
  .value("PseudoVNCLIPU_WX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_M2_MASK)
  .value("PseudoVNCLIPU_WX_M4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_M4)
  .value("PseudoVNCLIPU_WX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_M4_MASK)
  .value("PseudoVNCLIPU_WX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_MF2)
  .value("PseudoVNCLIPU_WX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_MF2_MASK)
  .value("PseudoVNCLIPU_WX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_MF4)
  .value("PseudoVNCLIPU_WX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_MF4_MASK)
  .value("PseudoVNCLIPU_WX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_MF8)
  .value("PseudoVNCLIPU_WX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIPU_WX_MF8_MASK)
  .value("PseudoVNCLIP_WI_M1", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_M1)
  .value("PseudoVNCLIP_WI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_M1_MASK)
  .value("PseudoVNCLIP_WI_M2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_M2)
  .value("PseudoVNCLIP_WI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_M2_MASK)
  .value("PseudoVNCLIP_WI_M4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_M4)
  .value("PseudoVNCLIP_WI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_M4_MASK)
  .value("PseudoVNCLIP_WI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_MF2)
  .value("PseudoVNCLIP_WI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_MF2_MASK)
  .value("PseudoVNCLIP_WI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_MF4)
  .value("PseudoVNCLIP_WI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_MF4_MASK)
  .value("PseudoVNCLIP_WI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_MF8)
  .value("PseudoVNCLIP_WI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WI_MF8_MASK)
  .value("PseudoVNCLIP_WV_M1", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_M1)
  .value("PseudoVNCLIP_WV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_M1_MASK)
  .value("PseudoVNCLIP_WV_M2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_M2)
  .value("PseudoVNCLIP_WV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_M2_MASK)
  .value("PseudoVNCLIP_WV_M4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_M4)
  .value("PseudoVNCLIP_WV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_M4_MASK)
  .value("PseudoVNCLIP_WV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_MF2)
  .value("PseudoVNCLIP_WV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_MF2_MASK)
  .value("PseudoVNCLIP_WV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_MF4)
  .value("PseudoVNCLIP_WV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_MF4_MASK)
  .value("PseudoVNCLIP_WV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_MF8)
  .value("PseudoVNCLIP_WV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WV_MF8_MASK)
  .value("PseudoVNCLIP_WX_M1", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_M1)
  .value("PseudoVNCLIP_WX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_M1_MASK)
  .value("PseudoVNCLIP_WX_M2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_M2)
  .value("PseudoVNCLIP_WX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_M2_MASK)
  .value("PseudoVNCLIP_WX_M4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_M4)
  .value("PseudoVNCLIP_WX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_M4_MASK)
  .value("PseudoVNCLIP_WX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_MF2)
  .value("PseudoVNCLIP_WX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_MF2_MASK)
  .value("PseudoVNCLIP_WX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_MF4)
  .value("PseudoVNCLIP_WX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_MF4_MASK)
  .value("PseudoVNCLIP_WX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_MF8)
  .value("PseudoVNCLIP_WX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNCLIP_WX_MF8_MASK)
  .value("PseudoVNMSAC_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_M1)
  .value("PseudoVNMSAC_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_M1_MASK)
  .value("PseudoVNMSAC_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_M2)
  .value("PseudoVNMSAC_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_M2_MASK)
  .value("PseudoVNMSAC_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_M4)
  .value("PseudoVNMSAC_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_M4_MASK)
  .value("PseudoVNMSAC_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_M8)
  .value("PseudoVNMSAC_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_M8_MASK)
  .value("PseudoVNMSAC_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_MF2)
  .value("PseudoVNMSAC_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_MF2_MASK)
  .value("PseudoVNMSAC_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_MF4)
  .value("PseudoVNMSAC_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_MF4_MASK)
  .value("PseudoVNMSAC_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_MF8)
  .value("PseudoVNMSAC_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VV_MF8_MASK)
  .value("PseudoVNMSAC_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_M1)
  .value("PseudoVNMSAC_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_M1_MASK)
  .value("PseudoVNMSAC_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_M2)
  .value("PseudoVNMSAC_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_M2_MASK)
  .value("PseudoVNMSAC_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_M4)
  .value("PseudoVNMSAC_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_M4_MASK)
  .value("PseudoVNMSAC_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_M8)
  .value("PseudoVNMSAC_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_M8_MASK)
  .value("PseudoVNMSAC_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_MF2)
  .value("PseudoVNMSAC_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_MF2_MASK)
  .value("PseudoVNMSAC_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_MF4)
  .value("PseudoVNMSAC_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_MF4_MASK)
  .value("PseudoVNMSAC_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_MF8)
  .value("PseudoVNMSAC_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSAC_VX_MF8_MASK)
  .value("PseudoVNMSUB_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_M1)
  .value("PseudoVNMSUB_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_M1_MASK)
  .value("PseudoVNMSUB_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_M2)
  .value("PseudoVNMSUB_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_M2_MASK)
  .value("PseudoVNMSUB_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_M4)
  .value("PseudoVNMSUB_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_M4_MASK)
  .value("PseudoVNMSUB_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_M8)
  .value("PseudoVNMSUB_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_M8_MASK)
  .value("PseudoVNMSUB_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_MF2)
  .value("PseudoVNMSUB_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_MF2_MASK)
  .value("PseudoVNMSUB_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_MF4)
  .value("PseudoVNMSUB_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_MF4_MASK)
  .value("PseudoVNMSUB_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_MF8)
  .value("PseudoVNMSUB_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VV_MF8_MASK)
  .value("PseudoVNMSUB_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_M1)
  .value("PseudoVNMSUB_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_M1_MASK)
  .value("PseudoVNMSUB_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_M2)
  .value("PseudoVNMSUB_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_M2_MASK)
  .value("PseudoVNMSUB_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_M4)
  .value("PseudoVNMSUB_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_M4_MASK)
  .value("PseudoVNMSUB_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_M8)
  .value("PseudoVNMSUB_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_M8_MASK)
  .value("PseudoVNMSUB_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_MF2)
  .value("PseudoVNMSUB_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_MF2_MASK)
  .value("PseudoVNMSUB_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_MF4)
  .value("PseudoVNMSUB_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_MF4_MASK)
  .value("PseudoVNMSUB_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_MF8)
  .value("PseudoVNMSUB_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNMSUB_VX_MF8_MASK)
  .value("PseudoVNSRA_WI_M1", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_M1)
  .value("PseudoVNSRA_WI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_M1_MASK)
  .value("PseudoVNSRA_WI_M2", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_M2)
  .value("PseudoVNSRA_WI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_M2_MASK)
  .value("PseudoVNSRA_WI_M4", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_M4)
  .value("PseudoVNSRA_WI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_M4_MASK)
  .value("PseudoVNSRA_WI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_MF2)
  .value("PseudoVNSRA_WI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_MF2_MASK)
  .value("PseudoVNSRA_WI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_MF4)
  .value("PseudoVNSRA_WI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_MF4_MASK)
  .value("PseudoVNSRA_WI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_MF8)
  .value("PseudoVNSRA_WI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WI_MF8_MASK)
  .value("PseudoVNSRA_WV_M1", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_M1)
  .value("PseudoVNSRA_WV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_M1_MASK)
  .value("PseudoVNSRA_WV_M2", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_M2)
  .value("PseudoVNSRA_WV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_M2_MASK)
  .value("PseudoVNSRA_WV_M4", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_M4)
  .value("PseudoVNSRA_WV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_M4_MASK)
  .value("PseudoVNSRA_WV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_MF2)
  .value("PseudoVNSRA_WV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_MF2_MASK)
  .value("PseudoVNSRA_WV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_MF4)
  .value("PseudoVNSRA_WV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_MF4_MASK)
  .value("PseudoVNSRA_WV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_MF8)
  .value("PseudoVNSRA_WV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WV_MF8_MASK)
  .value("PseudoVNSRA_WX_M1", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_M1)
  .value("PseudoVNSRA_WX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_M1_MASK)
  .value("PseudoVNSRA_WX_M2", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_M2)
  .value("PseudoVNSRA_WX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_M2_MASK)
  .value("PseudoVNSRA_WX_M4", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_M4)
  .value("PseudoVNSRA_WX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_M4_MASK)
  .value("PseudoVNSRA_WX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_MF2)
  .value("PseudoVNSRA_WX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_MF2_MASK)
  .value("PseudoVNSRA_WX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_MF4)
  .value("PseudoVNSRA_WX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_MF4_MASK)
  .value("PseudoVNSRA_WX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_MF8)
  .value("PseudoVNSRA_WX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRA_WX_MF8_MASK)
  .value("PseudoVNSRL_WI_M1", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_M1)
  .value("PseudoVNSRL_WI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_M1_MASK)
  .value("PseudoVNSRL_WI_M2", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_M2)
  .value("PseudoVNSRL_WI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_M2_MASK)
  .value("PseudoVNSRL_WI_M4", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_M4)
  .value("PseudoVNSRL_WI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_M4_MASK)
  .value("PseudoVNSRL_WI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_MF2)
  .value("PseudoVNSRL_WI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_MF2_MASK)
  .value("PseudoVNSRL_WI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_MF4)
  .value("PseudoVNSRL_WI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_MF4_MASK)
  .value("PseudoVNSRL_WI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_MF8)
  .value("PseudoVNSRL_WI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WI_MF8_MASK)
  .value("PseudoVNSRL_WV_M1", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_M1)
  .value("PseudoVNSRL_WV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_M1_MASK)
  .value("PseudoVNSRL_WV_M2", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_M2)
  .value("PseudoVNSRL_WV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_M2_MASK)
  .value("PseudoVNSRL_WV_M4", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_M4)
  .value("PseudoVNSRL_WV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_M4_MASK)
  .value("PseudoVNSRL_WV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_MF2)
  .value("PseudoVNSRL_WV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_MF2_MASK)
  .value("PseudoVNSRL_WV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_MF4)
  .value("PseudoVNSRL_WV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_MF4_MASK)
  .value("PseudoVNSRL_WV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_MF8)
  .value("PseudoVNSRL_WV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WV_MF8_MASK)
  .value("PseudoVNSRL_WX_M1", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_M1)
  .value("PseudoVNSRL_WX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_M1_MASK)
  .value("PseudoVNSRL_WX_M2", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_M2)
  .value("PseudoVNSRL_WX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_M2_MASK)
  .value("PseudoVNSRL_WX_M4", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_M4)
  .value("PseudoVNSRL_WX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_M4_MASK)
  .value("PseudoVNSRL_WX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_MF2)
  .value("PseudoVNSRL_WX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_MF2_MASK)
  .value("PseudoVNSRL_WX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_MF4)
  .value("PseudoVNSRL_WX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_MF4_MASK)
  .value("PseudoVNSRL_WX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_MF8)
  .value("PseudoVNSRL_WX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVNSRL_WX_MF8_MASK)
  .value("PseudoVOR_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_M1)
  .value("PseudoVOR_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_M1_MASK)
  .value("PseudoVOR_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_M2)
  .value("PseudoVOR_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_M2_MASK)
  .value("PseudoVOR_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_M4)
  .value("PseudoVOR_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_M4_MASK)
  .value("PseudoVOR_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_M8)
  .value("PseudoVOR_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_M8_MASK)
  .value("PseudoVOR_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_MF2)
  .value("PseudoVOR_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_MF2_MASK)
  .value("PseudoVOR_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_MF4)
  .value("PseudoVOR_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_MF4_MASK)
  .value("PseudoVOR_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_MF8)
  .value("PseudoVOR_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VI_MF8_MASK)
  .value("PseudoVOR_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_M1)
  .value("PseudoVOR_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_M1_MASK)
  .value("PseudoVOR_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_M2)
  .value("PseudoVOR_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_M2_MASK)
  .value("PseudoVOR_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_M4)
  .value("PseudoVOR_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_M4_MASK)
  .value("PseudoVOR_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_M8)
  .value("PseudoVOR_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_M8_MASK)
  .value("PseudoVOR_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_MF2)
  .value("PseudoVOR_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_MF2_MASK)
  .value("PseudoVOR_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_MF4)
  .value("PseudoVOR_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_MF4_MASK)
  .value("PseudoVOR_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_MF8)
  .value("PseudoVOR_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VV_MF8_MASK)
  .value("PseudoVOR_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_M1)
  .value("PseudoVOR_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_M1_MASK)
  .value("PseudoVOR_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_M2)
  .value("PseudoVOR_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_M2_MASK)
  .value("PseudoVOR_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_M4)
  .value("PseudoVOR_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_M4_MASK)
  .value("PseudoVOR_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_M8)
  .value("PseudoVOR_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_M8_MASK)
  .value("PseudoVOR_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_MF2)
  .value("PseudoVOR_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_MF2_MASK)
  .value("PseudoVOR_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_MF4)
  .value("PseudoVOR_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_MF4_MASK)
  .value("PseudoVOR_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_MF8)
  .value("PseudoVOR_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVOR_VX_MF8_MASK)
  .value("PseudoVQDOTSU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VV_M1)
  .value("PseudoVQDOTSU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VV_M1_MASK)
  .value("PseudoVQDOTSU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VV_M2)
  .value("PseudoVQDOTSU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VV_M2_MASK)
  .value("PseudoVQDOTSU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VV_M4)
  .value("PseudoVQDOTSU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VV_M4_MASK)
  .value("PseudoVQDOTSU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VV_M8)
  .value("PseudoVQDOTSU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VV_M8_MASK)
  .value("PseudoVQDOTSU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VV_MF2)
  .value("PseudoVQDOTSU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VV_MF2_MASK)
  .value("PseudoVQDOTSU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VX_M1)
  .value("PseudoVQDOTSU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VX_M1_MASK)
  .value("PseudoVQDOTSU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VX_M2)
  .value("PseudoVQDOTSU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VX_M2_MASK)
  .value("PseudoVQDOTSU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VX_M4)
  .value("PseudoVQDOTSU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VX_M4_MASK)
  .value("PseudoVQDOTSU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VX_M8)
  .value("PseudoVQDOTSU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VX_M8_MASK)
  .value("PseudoVQDOTSU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VX_MF2)
  .value("PseudoVQDOTSU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTSU_VX_MF2_MASK)
  .value("PseudoVQDOTU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VV_M1)
  .value("PseudoVQDOTU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VV_M1_MASK)
  .value("PseudoVQDOTU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VV_M2)
  .value("PseudoVQDOTU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VV_M2_MASK)
  .value("PseudoVQDOTU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VV_M4)
  .value("PseudoVQDOTU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VV_M4_MASK)
  .value("PseudoVQDOTU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VV_M8)
  .value("PseudoVQDOTU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VV_M8_MASK)
  .value("PseudoVQDOTU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VV_MF2)
  .value("PseudoVQDOTU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VV_MF2_MASK)
  .value("PseudoVQDOTU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VX_M1)
  .value("PseudoVQDOTU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VX_M1_MASK)
  .value("PseudoVQDOTU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VX_M2)
  .value("PseudoVQDOTU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VX_M2_MASK)
  .value("PseudoVQDOTU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VX_M4)
  .value("PseudoVQDOTU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VX_M4_MASK)
  .value("PseudoVQDOTU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VX_M8)
  .value("PseudoVQDOTU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VX_M8_MASK)
  .value("PseudoVQDOTU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VX_MF2)
  .value("PseudoVQDOTU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOTU_VX_MF2_MASK)
  .value("PseudoVQDOT_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VV_M1)
  .value("PseudoVQDOT_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VV_M1_MASK)
  .value("PseudoVQDOT_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VV_M2)
  .value("PseudoVQDOT_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VV_M2_MASK)
  .value("PseudoVQDOT_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VV_M4)
  .value("PseudoVQDOT_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VV_M4_MASK)
  .value("PseudoVQDOT_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VV_M8)
  .value("PseudoVQDOT_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VV_M8_MASK)
  .value("PseudoVQDOT_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VV_MF2)
  .value("PseudoVQDOT_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VV_MF2_MASK)
  .value("PseudoVQDOT_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VX_M1)
  .value("PseudoVQDOT_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VX_M1_MASK)
  .value("PseudoVQDOT_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VX_M2)
  .value("PseudoVQDOT_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VX_M2_MASK)
  .value("PseudoVQDOT_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VX_M4)
  .value("PseudoVQDOT_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VX_M4_MASK)
  .value("PseudoVQDOT_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VX_M8)
  .value("PseudoVQDOT_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VX_M8_MASK);
  opcodes.value("PseudoVQDOT_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VX_MF2)
  .value("PseudoVQDOT_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVQDOT_VX_MF2_MASK)
  .value("PseudoVREDAND_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M1_E16)
  .value("PseudoVREDAND_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M1_E16_MASK)
  .value("PseudoVREDAND_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M1_E32)
  .value("PseudoVREDAND_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M1_E32_MASK)
  .value("PseudoVREDAND_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M1_E64)
  .value("PseudoVREDAND_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M1_E64_MASK)
  .value("PseudoVREDAND_VS_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M1_E8)
  .value("PseudoVREDAND_VS_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M1_E8_MASK)
  .value("PseudoVREDAND_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M2_E16)
  .value("PseudoVREDAND_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M2_E16_MASK)
  .value("PseudoVREDAND_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M2_E32)
  .value("PseudoVREDAND_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M2_E32_MASK)
  .value("PseudoVREDAND_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M2_E64)
  .value("PseudoVREDAND_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M2_E64_MASK)
  .value("PseudoVREDAND_VS_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M2_E8)
  .value("PseudoVREDAND_VS_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M2_E8_MASK)
  .value("PseudoVREDAND_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M4_E16)
  .value("PseudoVREDAND_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M4_E16_MASK)
  .value("PseudoVREDAND_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M4_E32)
  .value("PseudoVREDAND_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M4_E32_MASK)
  .value("PseudoVREDAND_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M4_E64)
  .value("PseudoVREDAND_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M4_E64_MASK)
  .value("PseudoVREDAND_VS_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M4_E8)
  .value("PseudoVREDAND_VS_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M4_E8_MASK)
  .value("PseudoVREDAND_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M8_E16)
  .value("PseudoVREDAND_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M8_E16_MASK)
  .value("PseudoVREDAND_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M8_E32)
  .value("PseudoVREDAND_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M8_E32_MASK)
  .value("PseudoVREDAND_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M8_E64)
  .value("PseudoVREDAND_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M8_E64_MASK)
  .value("PseudoVREDAND_VS_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M8_E8)
  .value("PseudoVREDAND_VS_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_M8_E8_MASK)
  .value("PseudoVREDAND_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF2_E16)
  .value("PseudoVREDAND_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF2_E16_MASK)
  .value("PseudoVREDAND_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF2_E32)
  .value("PseudoVREDAND_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF2_E32_MASK)
  .value("PseudoVREDAND_VS_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF2_E8)
  .value("PseudoVREDAND_VS_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF2_E8_MASK)
  .value("PseudoVREDAND_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF4_E16)
  .value("PseudoVREDAND_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF4_E16_MASK)
  .value("PseudoVREDAND_VS_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF4_E8)
  .value("PseudoVREDAND_VS_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF4_E8_MASK)
  .value("PseudoVREDAND_VS_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF8_E8)
  .value("PseudoVREDAND_VS_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDAND_VS_MF8_E8_MASK)
  .value("PseudoVREDMAXU_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M1_E16)
  .value("PseudoVREDMAXU_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M1_E16_MASK)
  .value("PseudoVREDMAXU_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M1_E32)
  .value("PseudoVREDMAXU_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M1_E32_MASK)
  .value("PseudoVREDMAXU_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M1_E64)
  .value("PseudoVREDMAXU_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M1_E64_MASK)
  .value("PseudoVREDMAXU_VS_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M1_E8)
  .value("PseudoVREDMAXU_VS_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M1_E8_MASK)
  .value("PseudoVREDMAXU_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M2_E16)
  .value("PseudoVREDMAXU_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M2_E16_MASK)
  .value("PseudoVREDMAXU_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M2_E32)
  .value("PseudoVREDMAXU_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M2_E32_MASK)
  .value("PseudoVREDMAXU_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M2_E64)
  .value("PseudoVREDMAXU_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M2_E64_MASK)
  .value("PseudoVREDMAXU_VS_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M2_E8)
  .value("PseudoVREDMAXU_VS_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M2_E8_MASK)
  .value("PseudoVREDMAXU_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M4_E16)
  .value("PseudoVREDMAXU_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M4_E16_MASK)
  .value("PseudoVREDMAXU_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M4_E32)
  .value("PseudoVREDMAXU_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M4_E32_MASK)
  .value("PseudoVREDMAXU_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M4_E64)
  .value("PseudoVREDMAXU_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M4_E64_MASK)
  .value("PseudoVREDMAXU_VS_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M4_E8)
  .value("PseudoVREDMAXU_VS_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M4_E8_MASK)
  .value("PseudoVREDMAXU_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M8_E16)
  .value("PseudoVREDMAXU_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M8_E16_MASK)
  .value("PseudoVREDMAXU_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M8_E32)
  .value("PseudoVREDMAXU_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M8_E32_MASK)
  .value("PseudoVREDMAXU_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M8_E64)
  .value("PseudoVREDMAXU_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M8_E64_MASK)
  .value("PseudoVREDMAXU_VS_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M8_E8)
  .value("PseudoVREDMAXU_VS_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_M8_E8_MASK)
  .value("PseudoVREDMAXU_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF2_E16)
  .value("PseudoVREDMAXU_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF2_E16_MASK)
  .value("PseudoVREDMAXU_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF2_E32)
  .value("PseudoVREDMAXU_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF2_E32_MASK)
  .value("PseudoVREDMAXU_VS_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF2_E8)
  .value("PseudoVREDMAXU_VS_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF2_E8_MASK)
  .value("PseudoVREDMAXU_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF4_E16)
  .value("PseudoVREDMAXU_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF4_E16_MASK)
  .value("PseudoVREDMAXU_VS_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF4_E8)
  .value("PseudoVREDMAXU_VS_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF4_E8_MASK)
  .value("PseudoVREDMAXU_VS_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF8_E8)
  .value("PseudoVREDMAXU_VS_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAXU_VS_MF8_E8_MASK)
  .value("PseudoVREDMAX_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M1_E16)
  .value("PseudoVREDMAX_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M1_E16_MASK)
  .value("PseudoVREDMAX_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M1_E32)
  .value("PseudoVREDMAX_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M1_E32_MASK)
  .value("PseudoVREDMAX_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M1_E64)
  .value("PseudoVREDMAX_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M1_E64_MASK)
  .value("PseudoVREDMAX_VS_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M1_E8)
  .value("PseudoVREDMAX_VS_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M1_E8_MASK)
  .value("PseudoVREDMAX_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M2_E16)
  .value("PseudoVREDMAX_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M2_E16_MASK)
  .value("PseudoVREDMAX_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M2_E32)
  .value("PseudoVREDMAX_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M2_E32_MASK)
  .value("PseudoVREDMAX_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M2_E64)
  .value("PseudoVREDMAX_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M2_E64_MASK)
  .value("PseudoVREDMAX_VS_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M2_E8)
  .value("PseudoVREDMAX_VS_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M2_E8_MASK)
  .value("PseudoVREDMAX_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M4_E16)
  .value("PseudoVREDMAX_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M4_E16_MASK)
  .value("PseudoVREDMAX_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M4_E32)
  .value("PseudoVREDMAX_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M4_E32_MASK)
  .value("PseudoVREDMAX_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M4_E64)
  .value("PseudoVREDMAX_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M4_E64_MASK)
  .value("PseudoVREDMAX_VS_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M4_E8)
  .value("PseudoVREDMAX_VS_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M4_E8_MASK)
  .value("PseudoVREDMAX_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M8_E16)
  .value("PseudoVREDMAX_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M8_E16_MASK)
  .value("PseudoVREDMAX_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M8_E32)
  .value("PseudoVREDMAX_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M8_E32_MASK)
  .value("PseudoVREDMAX_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M8_E64)
  .value("PseudoVREDMAX_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M8_E64_MASK)
  .value("PseudoVREDMAX_VS_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M8_E8)
  .value("PseudoVREDMAX_VS_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_M8_E8_MASK)
  .value("PseudoVREDMAX_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF2_E16)
  .value("PseudoVREDMAX_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF2_E16_MASK)
  .value("PseudoVREDMAX_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF2_E32)
  .value("PseudoVREDMAX_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF2_E32_MASK)
  .value("PseudoVREDMAX_VS_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF2_E8)
  .value("PseudoVREDMAX_VS_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF2_E8_MASK)
  .value("PseudoVREDMAX_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF4_E16)
  .value("PseudoVREDMAX_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF4_E16_MASK)
  .value("PseudoVREDMAX_VS_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF4_E8)
  .value("PseudoVREDMAX_VS_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF4_E8_MASK)
  .value("PseudoVREDMAX_VS_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF8_E8)
  .value("PseudoVREDMAX_VS_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMAX_VS_MF8_E8_MASK)
  .value("PseudoVREDMINU_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M1_E16)
  .value("PseudoVREDMINU_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M1_E16_MASK)
  .value("PseudoVREDMINU_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M1_E32)
  .value("PseudoVREDMINU_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M1_E32_MASK)
  .value("PseudoVREDMINU_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M1_E64)
  .value("PseudoVREDMINU_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M1_E64_MASK)
  .value("PseudoVREDMINU_VS_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M1_E8)
  .value("PseudoVREDMINU_VS_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M1_E8_MASK)
  .value("PseudoVREDMINU_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M2_E16)
  .value("PseudoVREDMINU_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M2_E16_MASK)
  .value("PseudoVREDMINU_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M2_E32)
  .value("PseudoVREDMINU_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M2_E32_MASK)
  .value("PseudoVREDMINU_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M2_E64)
  .value("PseudoVREDMINU_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M2_E64_MASK)
  .value("PseudoVREDMINU_VS_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M2_E8)
  .value("PseudoVREDMINU_VS_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M2_E8_MASK)
  .value("PseudoVREDMINU_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M4_E16)
  .value("PseudoVREDMINU_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M4_E16_MASK)
  .value("PseudoVREDMINU_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M4_E32)
  .value("PseudoVREDMINU_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M4_E32_MASK)
  .value("PseudoVREDMINU_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M4_E64)
  .value("PseudoVREDMINU_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M4_E64_MASK)
  .value("PseudoVREDMINU_VS_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M4_E8)
  .value("PseudoVREDMINU_VS_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M4_E8_MASK)
  .value("PseudoVREDMINU_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M8_E16)
  .value("PseudoVREDMINU_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M8_E16_MASK)
  .value("PseudoVREDMINU_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M8_E32)
  .value("PseudoVREDMINU_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M8_E32_MASK)
  .value("PseudoVREDMINU_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M8_E64)
  .value("PseudoVREDMINU_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M8_E64_MASK)
  .value("PseudoVREDMINU_VS_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M8_E8)
  .value("PseudoVREDMINU_VS_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_M8_E8_MASK)
  .value("PseudoVREDMINU_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF2_E16)
  .value("PseudoVREDMINU_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF2_E16_MASK)
  .value("PseudoVREDMINU_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF2_E32)
  .value("PseudoVREDMINU_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF2_E32_MASK)
  .value("PseudoVREDMINU_VS_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF2_E8)
  .value("PseudoVREDMINU_VS_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF2_E8_MASK)
  .value("PseudoVREDMINU_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF4_E16)
  .value("PseudoVREDMINU_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF4_E16_MASK)
  .value("PseudoVREDMINU_VS_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF4_E8)
  .value("PseudoVREDMINU_VS_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF4_E8_MASK)
  .value("PseudoVREDMINU_VS_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF8_E8)
  .value("PseudoVREDMINU_VS_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMINU_VS_MF8_E8_MASK)
  .value("PseudoVREDMIN_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M1_E16)
  .value("PseudoVREDMIN_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M1_E16_MASK)
  .value("PseudoVREDMIN_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M1_E32)
  .value("PseudoVREDMIN_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M1_E32_MASK)
  .value("PseudoVREDMIN_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M1_E64)
  .value("PseudoVREDMIN_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M1_E64_MASK)
  .value("PseudoVREDMIN_VS_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M1_E8)
  .value("PseudoVREDMIN_VS_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M1_E8_MASK)
  .value("PseudoVREDMIN_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M2_E16)
  .value("PseudoVREDMIN_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M2_E16_MASK)
  .value("PseudoVREDMIN_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M2_E32)
  .value("PseudoVREDMIN_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M2_E32_MASK)
  .value("PseudoVREDMIN_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M2_E64)
  .value("PseudoVREDMIN_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M2_E64_MASK)
  .value("PseudoVREDMIN_VS_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M2_E8)
  .value("PseudoVREDMIN_VS_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M2_E8_MASK)
  .value("PseudoVREDMIN_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M4_E16)
  .value("PseudoVREDMIN_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M4_E16_MASK)
  .value("PseudoVREDMIN_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M4_E32)
  .value("PseudoVREDMIN_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M4_E32_MASK)
  .value("PseudoVREDMIN_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M4_E64)
  .value("PseudoVREDMIN_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M4_E64_MASK)
  .value("PseudoVREDMIN_VS_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M4_E8)
  .value("PseudoVREDMIN_VS_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M4_E8_MASK)
  .value("PseudoVREDMIN_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M8_E16)
  .value("PseudoVREDMIN_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M8_E16_MASK)
  .value("PseudoVREDMIN_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M8_E32)
  .value("PseudoVREDMIN_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M8_E32_MASK)
  .value("PseudoVREDMIN_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M8_E64)
  .value("PseudoVREDMIN_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M8_E64_MASK)
  .value("PseudoVREDMIN_VS_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M8_E8)
  .value("PseudoVREDMIN_VS_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_M8_E8_MASK)
  .value("PseudoVREDMIN_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF2_E16)
  .value("PseudoVREDMIN_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF2_E16_MASK)
  .value("PseudoVREDMIN_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF2_E32)
  .value("PseudoVREDMIN_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF2_E32_MASK)
  .value("PseudoVREDMIN_VS_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF2_E8)
  .value("PseudoVREDMIN_VS_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF2_E8_MASK)
  .value("PseudoVREDMIN_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF4_E16)
  .value("PseudoVREDMIN_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF4_E16_MASK)
  .value("PseudoVREDMIN_VS_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF4_E8)
  .value("PseudoVREDMIN_VS_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF4_E8_MASK)
  .value("PseudoVREDMIN_VS_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF8_E8)
  .value("PseudoVREDMIN_VS_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDMIN_VS_MF8_E8_MASK)
  .value("PseudoVREDOR_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M1_E16)
  .value("PseudoVREDOR_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M1_E16_MASK)
  .value("PseudoVREDOR_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M1_E32)
  .value("PseudoVREDOR_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M1_E32_MASK)
  .value("PseudoVREDOR_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M1_E64)
  .value("PseudoVREDOR_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M1_E64_MASK)
  .value("PseudoVREDOR_VS_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M1_E8)
  .value("PseudoVREDOR_VS_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M1_E8_MASK)
  .value("PseudoVREDOR_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M2_E16)
  .value("PseudoVREDOR_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M2_E16_MASK)
  .value("PseudoVREDOR_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M2_E32)
  .value("PseudoVREDOR_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M2_E32_MASK)
  .value("PseudoVREDOR_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M2_E64)
  .value("PseudoVREDOR_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M2_E64_MASK)
  .value("PseudoVREDOR_VS_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M2_E8)
  .value("PseudoVREDOR_VS_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M2_E8_MASK)
  .value("PseudoVREDOR_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M4_E16)
  .value("PseudoVREDOR_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M4_E16_MASK)
  .value("PseudoVREDOR_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M4_E32)
  .value("PseudoVREDOR_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M4_E32_MASK)
  .value("PseudoVREDOR_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M4_E64)
  .value("PseudoVREDOR_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M4_E64_MASK)
  .value("PseudoVREDOR_VS_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M4_E8)
  .value("PseudoVREDOR_VS_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M4_E8_MASK)
  .value("PseudoVREDOR_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M8_E16)
  .value("PseudoVREDOR_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M8_E16_MASK)
  .value("PseudoVREDOR_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M8_E32)
  .value("PseudoVREDOR_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M8_E32_MASK)
  .value("PseudoVREDOR_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M8_E64)
  .value("PseudoVREDOR_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M8_E64_MASK)
  .value("PseudoVREDOR_VS_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M8_E8)
  .value("PseudoVREDOR_VS_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_M8_E8_MASK)
  .value("PseudoVREDOR_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF2_E16)
  .value("PseudoVREDOR_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF2_E16_MASK)
  .value("PseudoVREDOR_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF2_E32)
  .value("PseudoVREDOR_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF2_E32_MASK)
  .value("PseudoVREDOR_VS_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF2_E8)
  .value("PseudoVREDOR_VS_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF2_E8_MASK)
  .value("PseudoVREDOR_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF4_E16)
  .value("PseudoVREDOR_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF4_E16_MASK)
  .value("PseudoVREDOR_VS_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF4_E8)
  .value("PseudoVREDOR_VS_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF4_E8_MASK)
  .value("PseudoVREDOR_VS_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF8_E8)
  .value("PseudoVREDOR_VS_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDOR_VS_MF8_E8_MASK)
  .value("PseudoVREDSUM_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M1_E16)
  .value("PseudoVREDSUM_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M1_E16_MASK)
  .value("PseudoVREDSUM_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M1_E32)
  .value("PseudoVREDSUM_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M1_E32_MASK)
  .value("PseudoVREDSUM_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M1_E64)
  .value("PseudoVREDSUM_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M1_E64_MASK)
  .value("PseudoVREDSUM_VS_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M1_E8)
  .value("PseudoVREDSUM_VS_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M1_E8_MASK)
  .value("PseudoVREDSUM_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M2_E16)
  .value("PseudoVREDSUM_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M2_E16_MASK)
  .value("PseudoVREDSUM_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M2_E32)
  .value("PseudoVREDSUM_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M2_E32_MASK)
  .value("PseudoVREDSUM_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M2_E64)
  .value("PseudoVREDSUM_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M2_E64_MASK)
  .value("PseudoVREDSUM_VS_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M2_E8)
  .value("PseudoVREDSUM_VS_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M2_E8_MASK)
  .value("PseudoVREDSUM_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M4_E16)
  .value("PseudoVREDSUM_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M4_E16_MASK)
  .value("PseudoVREDSUM_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M4_E32)
  .value("PseudoVREDSUM_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M4_E32_MASK)
  .value("PseudoVREDSUM_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M4_E64)
  .value("PseudoVREDSUM_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M4_E64_MASK)
  .value("PseudoVREDSUM_VS_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M4_E8)
  .value("PseudoVREDSUM_VS_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M4_E8_MASK)
  .value("PseudoVREDSUM_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M8_E16)
  .value("PseudoVREDSUM_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M8_E16_MASK)
  .value("PseudoVREDSUM_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M8_E32)
  .value("PseudoVREDSUM_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M8_E32_MASK)
  .value("PseudoVREDSUM_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M8_E64)
  .value("PseudoVREDSUM_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M8_E64_MASK)
  .value("PseudoVREDSUM_VS_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M8_E8)
  .value("PseudoVREDSUM_VS_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_M8_E8_MASK)
  .value("PseudoVREDSUM_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF2_E16)
  .value("PseudoVREDSUM_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF2_E16_MASK);
  opcodes.value("PseudoVREDSUM_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF2_E32)
  .value("PseudoVREDSUM_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF2_E32_MASK)
  .value("PseudoVREDSUM_VS_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF2_E8)
  .value("PseudoVREDSUM_VS_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF2_E8_MASK)
  .value("PseudoVREDSUM_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF4_E16)
  .value("PseudoVREDSUM_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF4_E16_MASK)
  .value("PseudoVREDSUM_VS_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF4_E8)
  .value("PseudoVREDSUM_VS_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF4_E8_MASK)
  .value("PseudoVREDSUM_VS_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF8_E8)
  .value("PseudoVREDSUM_VS_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDSUM_VS_MF8_E8_MASK)
  .value("PseudoVREDXOR_VS_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M1_E16)
  .value("PseudoVREDXOR_VS_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M1_E16_MASK)
  .value("PseudoVREDXOR_VS_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M1_E32)
  .value("PseudoVREDXOR_VS_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M1_E32_MASK)
  .value("PseudoVREDXOR_VS_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M1_E64)
  .value("PseudoVREDXOR_VS_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M1_E64_MASK)
  .value("PseudoVREDXOR_VS_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M1_E8)
  .value("PseudoVREDXOR_VS_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M1_E8_MASK)
  .value("PseudoVREDXOR_VS_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M2_E16)
  .value("PseudoVREDXOR_VS_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M2_E16_MASK)
  .value("PseudoVREDXOR_VS_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M2_E32)
  .value("PseudoVREDXOR_VS_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M2_E32_MASK)
  .value("PseudoVREDXOR_VS_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M2_E64)
  .value("PseudoVREDXOR_VS_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M2_E64_MASK)
  .value("PseudoVREDXOR_VS_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M2_E8)
  .value("PseudoVREDXOR_VS_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M2_E8_MASK)
  .value("PseudoVREDXOR_VS_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M4_E16)
  .value("PseudoVREDXOR_VS_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M4_E16_MASK)
  .value("PseudoVREDXOR_VS_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M4_E32)
  .value("PseudoVREDXOR_VS_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M4_E32_MASK)
  .value("PseudoVREDXOR_VS_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M4_E64)
  .value("PseudoVREDXOR_VS_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M4_E64_MASK)
  .value("PseudoVREDXOR_VS_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M4_E8)
  .value("PseudoVREDXOR_VS_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M4_E8_MASK)
  .value("PseudoVREDXOR_VS_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M8_E16)
  .value("PseudoVREDXOR_VS_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M8_E16_MASK)
  .value("PseudoVREDXOR_VS_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M8_E32)
  .value("PseudoVREDXOR_VS_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M8_E32_MASK)
  .value("PseudoVREDXOR_VS_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M8_E64)
  .value("PseudoVREDXOR_VS_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M8_E64_MASK)
  .value("PseudoVREDXOR_VS_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M8_E8)
  .value("PseudoVREDXOR_VS_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_M8_E8_MASK)
  .value("PseudoVREDXOR_VS_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF2_E16)
  .value("PseudoVREDXOR_VS_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF2_E16_MASK)
  .value("PseudoVREDXOR_VS_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF2_E32)
  .value("PseudoVREDXOR_VS_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF2_E32_MASK)
  .value("PseudoVREDXOR_VS_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF2_E8)
  .value("PseudoVREDXOR_VS_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF2_E8_MASK)
  .value("PseudoVREDXOR_VS_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF4_E16)
  .value("PseudoVREDXOR_VS_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF4_E16_MASK)
  .value("PseudoVREDXOR_VS_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF4_E8)
  .value("PseudoVREDXOR_VS_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF4_E8_MASK)
  .value("PseudoVREDXOR_VS_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF8_E8)
  .value("PseudoVREDXOR_VS_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREDXOR_VS_MF8_E8_MASK)
  .value("PseudoVRELOAD2_M1", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD2_M1)
  .value("PseudoVRELOAD2_M2", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD2_M2)
  .value("PseudoVRELOAD2_M4", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD2_M4)
  .value("PseudoVRELOAD2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD2_MF2)
  .value("PseudoVRELOAD2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD2_MF4)
  .value("PseudoVRELOAD2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD2_MF8)
  .value("PseudoVRELOAD3_M1", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD3_M1)
  .value("PseudoVRELOAD3_M2", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD3_M2)
  .value("PseudoVRELOAD3_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD3_MF2)
  .value("PseudoVRELOAD3_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD3_MF4)
  .value("PseudoVRELOAD3_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD3_MF8)
  .value("PseudoVRELOAD4_M1", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD4_M1)
  .value("PseudoVRELOAD4_M2", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD4_M2)
  .value("PseudoVRELOAD4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD4_MF2)
  .value("PseudoVRELOAD4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD4_MF4)
  .value("PseudoVRELOAD4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD4_MF8)
  .value("PseudoVRELOAD5_M1", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD5_M1)
  .value("PseudoVRELOAD5_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD5_MF2)
  .value("PseudoVRELOAD5_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD5_MF4)
  .value("PseudoVRELOAD5_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD5_MF8)
  .value("PseudoVRELOAD6_M1", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD6_M1)
  .value("PseudoVRELOAD6_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD6_MF2)
  .value("PseudoVRELOAD6_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD6_MF4)
  .value("PseudoVRELOAD6_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD6_MF8)
  .value("PseudoVRELOAD7_M1", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD7_M1)
  .value("PseudoVRELOAD7_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD7_MF2)
  .value("PseudoVRELOAD7_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD7_MF4)
  .value("PseudoVRELOAD7_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD7_MF8)
  .value("PseudoVRELOAD8_M1", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD8_M1)
  .value("PseudoVRELOAD8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD8_MF2)
  .value("PseudoVRELOAD8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD8_MF4)
  .value("PseudoVRELOAD8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRELOAD8_MF8)
  .value("PseudoVREMU_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M1_E16)
  .value("PseudoVREMU_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M1_E16_MASK)
  .value("PseudoVREMU_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M1_E32)
  .value("PseudoVREMU_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M1_E32_MASK)
  .value("PseudoVREMU_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M1_E64)
  .value("PseudoVREMU_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M1_E64_MASK)
  .value("PseudoVREMU_VV_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M1_E8)
  .value("PseudoVREMU_VV_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M1_E8_MASK)
  .value("PseudoVREMU_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M2_E16)
  .value("PseudoVREMU_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M2_E16_MASK)
  .value("PseudoVREMU_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M2_E32)
  .value("PseudoVREMU_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M2_E32_MASK)
  .value("PseudoVREMU_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M2_E64)
  .value("PseudoVREMU_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M2_E64_MASK)
  .value("PseudoVREMU_VV_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M2_E8)
  .value("PseudoVREMU_VV_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M2_E8_MASK)
  .value("PseudoVREMU_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M4_E16)
  .value("PseudoVREMU_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M4_E16_MASK)
  .value("PseudoVREMU_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M4_E32)
  .value("PseudoVREMU_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M4_E32_MASK)
  .value("PseudoVREMU_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M4_E64)
  .value("PseudoVREMU_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M4_E64_MASK)
  .value("PseudoVREMU_VV_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M4_E8)
  .value("PseudoVREMU_VV_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M4_E8_MASK)
  .value("PseudoVREMU_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M8_E16)
  .value("PseudoVREMU_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M8_E16_MASK)
  .value("PseudoVREMU_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M8_E32)
  .value("PseudoVREMU_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M8_E32_MASK)
  .value("PseudoVREMU_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M8_E64)
  .value("PseudoVREMU_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M8_E64_MASK)
  .value("PseudoVREMU_VV_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M8_E8)
  .value("PseudoVREMU_VV_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_M8_E8_MASK)
  .value("PseudoVREMU_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF2_E16)
  .value("PseudoVREMU_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF2_E16_MASK)
  .value("PseudoVREMU_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF2_E32)
  .value("PseudoVREMU_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF2_E32_MASK)
  .value("PseudoVREMU_VV_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF2_E8)
  .value("PseudoVREMU_VV_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF2_E8_MASK)
  .value("PseudoVREMU_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF4_E16)
  .value("PseudoVREMU_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF4_E16_MASK)
  .value("PseudoVREMU_VV_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF4_E8)
  .value("PseudoVREMU_VV_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF4_E8_MASK)
  .value("PseudoVREMU_VV_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF8_E8)
  .value("PseudoVREMU_VV_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VV_MF8_E8_MASK)
  .value("PseudoVREMU_VX_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M1_E16)
  .value("PseudoVREMU_VX_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M1_E16_MASK)
  .value("PseudoVREMU_VX_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M1_E32)
  .value("PseudoVREMU_VX_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M1_E32_MASK)
  .value("PseudoVREMU_VX_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M1_E64)
  .value("PseudoVREMU_VX_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M1_E64_MASK)
  .value("PseudoVREMU_VX_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M1_E8)
  .value("PseudoVREMU_VX_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M1_E8_MASK)
  .value("PseudoVREMU_VX_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M2_E16)
  .value("PseudoVREMU_VX_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M2_E16_MASK)
  .value("PseudoVREMU_VX_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M2_E32)
  .value("PseudoVREMU_VX_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M2_E32_MASK)
  .value("PseudoVREMU_VX_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M2_E64)
  .value("PseudoVREMU_VX_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M2_E64_MASK)
  .value("PseudoVREMU_VX_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M2_E8)
  .value("PseudoVREMU_VX_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M2_E8_MASK)
  .value("PseudoVREMU_VX_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M4_E16)
  .value("PseudoVREMU_VX_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M4_E16_MASK)
  .value("PseudoVREMU_VX_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M4_E32)
  .value("PseudoVREMU_VX_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M4_E32_MASK)
  .value("PseudoVREMU_VX_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M4_E64)
  .value("PseudoVREMU_VX_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M4_E64_MASK)
  .value("PseudoVREMU_VX_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M4_E8)
  .value("PseudoVREMU_VX_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M4_E8_MASK)
  .value("PseudoVREMU_VX_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M8_E16)
  .value("PseudoVREMU_VX_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M8_E16_MASK)
  .value("PseudoVREMU_VX_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M8_E32)
  .value("PseudoVREMU_VX_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M8_E32_MASK)
  .value("PseudoVREMU_VX_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M8_E64)
  .value("PseudoVREMU_VX_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M8_E64_MASK)
  .value("PseudoVREMU_VX_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M8_E8)
  .value("PseudoVREMU_VX_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_M8_E8_MASK)
  .value("PseudoVREMU_VX_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF2_E16)
  .value("PseudoVREMU_VX_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF2_E16_MASK)
  .value("PseudoVREMU_VX_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF2_E32)
  .value("PseudoVREMU_VX_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF2_E32_MASK)
  .value("PseudoVREMU_VX_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF2_E8)
  .value("PseudoVREMU_VX_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF2_E8_MASK)
  .value("PseudoVREMU_VX_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF4_E16)
  .value("PseudoVREMU_VX_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF4_E16_MASK)
  .value("PseudoVREMU_VX_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF4_E8)
  .value("PseudoVREMU_VX_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF4_E8_MASK)
  .value("PseudoVREMU_VX_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF8_E8)
  .value("PseudoVREMU_VX_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREMU_VX_MF8_E8_MASK)
  .value("PseudoVREM_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M1_E16)
  .value("PseudoVREM_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M1_E16_MASK)
  .value("PseudoVREM_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M1_E32)
  .value("PseudoVREM_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M1_E32_MASK)
  .value("PseudoVREM_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M1_E64)
  .value("PseudoVREM_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M1_E64_MASK)
  .value("PseudoVREM_VV_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M1_E8)
  .value("PseudoVREM_VV_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M1_E8_MASK)
  .value("PseudoVREM_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M2_E16)
  .value("PseudoVREM_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M2_E16_MASK)
  .value("PseudoVREM_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M2_E32)
  .value("PseudoVREM_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M2_E32_MASK)
  .value("PseudoVREM_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M2_E64)
  .value("PseudoVREM_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M2_E64_MASK)
  .value("PseudoVREM_VV_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M2_E8)
  .value("PseudoVREM_VV_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M2_E8_MASK)
  .value("PseudoVREM_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M4_E16)
  .value("PseudoVREM_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M4_E16_MASK)
  .value("PseudoVREM_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M4_E32)
  .value("PseudoVREM_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M4_E32_MASK)
  .value("PseudoVREM_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M4_E64)
  .value("PseudoVREM_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M4_E64_MASK)
  .value("PseudoVREM_VV_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M4_E8)
  .value("PseudoVREM_VV_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M4_E8_MASK)
  .value("PseudoVREM_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M8_E16)
  .value("PseudoVREM_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M8_E16_MASK)
  .value("PseudoVREM_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M8_E32)
  .value("PseudoVREM_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M8_E32_MASK)
  .value("PseudoVREM_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M8_E64)
  .value("PseudoVREM_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M8_E64_MASK)
  .value("PseudoVREM_VV_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M8_E8)
  .value("PseudoVREM_VV_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_M8_E8_MASK)
  .value("PseudoVREM_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF2_E16)
  .value("PseudoVREM_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF2_E16_MASK)
  .value("PseudoVREM_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF2_E32)
  .value("PseudoVREM_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF2_E32_MASK)
  .value("PseudoVREM_VV_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF2_E8)
  .value("PseudoVREM_VV_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF2_E8_MASK)
  .value("PseudoVREM_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF4_E16)
  .value("PseudoVREM_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF4_E16_MASK)
  .value("PseudoVREM_VV_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF4_E8)
  .value("PseudoVREM_VV_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF4_E8_MASK)
  .value("PseudoVREM_VV_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF8_E8)
  .value("PseudoVREM_VV_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VV_MF8_E8_MASK)
  .value("PseudoVREM_VX_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M1_E16)
  .value("PseudoVREM_VX_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M1_E16_MASK)
  .value("PseudoVREM_VX_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M1_E32)
  .value("PseudoVREM_VX_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M1_E32_MASK)
  .value("PseudoVREM_VX_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M1_E64)
  .value("PseudoVREM_VX_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M1_E64_MASK)
  .value("PseudoVREM_VX_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M1_E8)
  .value("PseudoVREM_VX_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M1_E8_MASK)
  .value("PseudoVREM_VX_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M2_E16)
  .value("PseudoVREM_VX_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M2_E16_MASK)
  .value("PseudoVREM_VX_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M2_E32)
  .value("PseudoVREM_VX_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M2_E32_MASK)
  .value("PseudoVREM_VX_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M2_E64)
  .value("PseudoVREM_VX_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M2_E64_MASK)
  .value("PseudoVREM_VX_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M2_E8)
  .value("PseudoVREM_VX_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M2_E8_MASK)
  .value("PseudoVREM_VX_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M4_E16)
  .value("PseudoVREM_VX_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M4_E16_MASK)
  .value("PseudoVREM_VX_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M4_E32)
  .value("PseudoVREM_VX_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M4_E32_MASK)
  .value("PseudoVREM_VX_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M4_E64)
  .value("PseudoVREM_VX_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M4_E64_MASK)
  .value("PseudoVREM_VX_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M4_E8)
  .value("PseudoVREM_VX_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M4_E8_MASK)
  .value("PseudoVREM_VX_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M8_E16)
  .value("PseudoVREM_VX_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M8_E16_MASK)
  .value("PseudoVREM_VX_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M8_E32)
  .value("PseudoVREM_VX_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M8_E32_MASK)
  .value("PseudoVREM_VX_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M8_E64)
  .value("PseudoVREM_VX_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M8_E64_MASK)
  .value("PseudoVREM_VX_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M8_E8)
  .value("PseudoVREM_VX_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_M8_E8_MASK)
  .value("PseudoVREM_VX_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF2_E16)
  .value("PseudoVREM_VX_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF2_E16_MASK)
  .value("PseudoVREM_VX_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF2_E32)
  .value("PseudoVREM_VX_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF2_E32_MASK)
  .value("PseudoVREM_VX_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF2_E8)
  .value("PseudoVREM_VX_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF2_E8_MASK)
  .value("PseudoVREM_VX_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF4_E16)
  .value("PseudoVREM_VX_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF4_E16_MASK)
  .value("PseudoVREM_VX_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF4_E8)
  .value("PseudoVREM_VX_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF4_E8_MASK)
  .value("PseudoVREM_VX_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF8_E8)
  .value("PseudoVREM_VX_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREM_VX_MF8_E8_MASK)
  .value("PseudoVREV8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_M1)
  .value("PseudoVREV8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_M1_MASK)
  .value("PseudoVREV8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_M2)
  .value("PseudoVREV8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_M2_MASK)
  .value("PseudoVREV8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_M4)
  .value("PseudoVREV8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_M4_MASK)
  .value("PseudoVREV8_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_M8)
  .value("PseudoVREV8_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_M8_MASK)
  .value("PseudoVREV8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_MF2)
  .value("PseudoVREV8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_MF2_MASK)
  .value("PseudoVREV8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_MF4)
  .value("PseudoVREV8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_MF4_MASK)
  .value("PseudoVREV8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_MF8)
  .value("PseudoVREV8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVREV8_V_MF8_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E16_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E16_M1)
  .value("PseudoVRGATHEREI16_VV_M1_E16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E16_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E16_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E16_M2)
  .value("PseudoVRGATHEREI16_VV_M1_E16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E16_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E16_MF2)
  .value("PseudoVRGATHEREI16_VV_M1_E16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E16_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E16_MF4)
  .value("PseudoVRGATHEREI16_VV_M1_E16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E16_MF4_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E32_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E32_M1)
  .value("PseudoVRGATHEREI16_VV_M1_E32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E32_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E32_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E32_M2)
  .value("PseudoVRGATHEREI16_VV_M1_E32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E32_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E32_MF2)
  .value("PseudoVRGATHEREI16_VV_M1_E32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E32_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E32_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E32_MF4)
  .value("PseudoVRGATHEREI16_VV_M1_E32_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E32_MF4_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E64_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E64_M1)
  .value("PseudoVRGATHEREI16_VV_M1_E64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E64_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E64_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E64_M2)
  .value("PseudoVRGATHEREI16_VV_M1_E64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E64_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E64_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E64_MF2)
  .value("PseudoVRGATHEREI16_VV_M1_E64_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E64_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E64_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E64_MF4)
  .value("PseudoVRGATHEREI16_VV_M1_E64_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E64_MF4_MASK);
  opcodes.value("PseudoVRGATHEREI16_VV_M1_E8_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E8_M1)
  .value("PseudoVRGATHEREI16_VV_M1_E8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E8_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E8_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E8_M2)
  .value("PseudoVRGATHEREI16_VV_M1_E8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E8_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E8_MF2)
  .value("PseudoVRGATHEREI16_VV_M1_E8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E8_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_M1_E8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E8_MF4)
  .value("PseudoVRGATHEREI16_VV_M1_E8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M1_E8_MF4_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E16_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E16_M1)
  .value("PseudoVRGATHEREI16_VV_M2_E16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E16_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E16_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E16_M2)
  .value("PseudoVRGATHEREI16_VV_M2_E16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E16_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E16_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E16_M4)
  .value("PseudoVRGATHEREI16_VV_M2_E16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E16_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E16_MF2)
  .value("PseudoVRGATHEREI16_VV_M2_E16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E16_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E32_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E32_M1)
  .value("PseudoVRGATHEREI16_VV_M2_E32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E32_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E32_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E32_M2)
  .value("PseudoVRGATHEREI16_VV_M2_E32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E32_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E32_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E32_M4)
  .value("PseudoVRGATHEREI16_VV_M2_E32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E32_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E32_MF2)
  .value("PseudoVRGATHEREI16_VV_M2_E32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E32_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E64_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E64_M1)
  .value("PseudoVRGATHEREI16_VV_M2_E64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E64_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E64_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E64_M2)
  .value("PseudoVRGATHEREI16_VV_M2_E64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E64_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E64_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E64_M4)
  .value("PseudoVRGATHEREI16_VV_M2_E64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E64_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E64_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E64_MF2)
  .value("PseudoVRGATHEREI16_VV_M2_E64_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E64_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E8_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E8_M1)
  .value("PseudoVRGATHEREI16_VV_M2_E8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E8_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E8_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E8_M2)
  .value("PseudoVRGATHEREI16_VV_M2_E8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E8_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E8_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E8_M4)
  .value("PseudoVRGATHEREI16_VV_M2_E8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E8_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M2_E8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E8_MF2)
  .value("PseudoVRGATHEREI16_VV_M2_E8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M2_E8_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E16_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E16_M1)
  .value("PseudoVRGATHEREI16_VV_M4_E16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E16_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E16_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E16_M2)
  .value("PseudoVRGATHEREI16_VV_M4_E16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E16_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E16_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E16_M4)
  .value("PseudoVRGATHEREI16_VV_M4_E16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E16_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E16_M8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E16_M8)
  .value("PseudoVRGATHEREI16_VV_M4_E16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E16_M8_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E32_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E32_M1)
  .value("PseudoVRGATHEREI16_VV_M4_E32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E32_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E32_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E32_M2)
  .value("PseudoVRGATHEREI16_VV_M4_E32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E32_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E32_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E32_M4)
  .value("PseudoVRGATHEREI16_VV_M4_E32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E32_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E32_M8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E32_M8)
  .value("PseudoVRGATHEREI16_VV_M4_E32_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E32_M8_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E64_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E64_M1)
  .value("PseudoVRGATHEREI16_VV_M4_E64_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E64_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E64_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E64_M2)
  .value("PseudoVRGATHEREI16_VV_M4_E64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E64_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E64_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E64_M4)
  .value("PseudoVRGATHEREI16_VV_M4_E64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E64_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E64_M8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E64_M8)
  .value("PseudoVRGATHEREI16_VV_M4_E64_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E64_M8_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E8_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E8_M1)
  .value("PseudoVRGATHEREI16_VV_M4_E8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E8_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E8_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E8_M2)
  .value("PseudoVRGATHEREI16_VV_M4_E8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E8_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E8_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E8_M4)
  .value("PseudoVRGATHEREI16_VV_M4_E8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E8_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M4_E8_M8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E8_M8)
  .value("PseudoVRGATHEREI16_VV_M4_E8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M4_E8_M8_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E16_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E16_M2)
  .value("PseudoVRGATHEREI16_VV_M8_E16_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E16_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E16_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E16_M4)
  .value("PseudoVRGATHEREI16_VV_M8_E16_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E16_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E16_M8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E16_M8)
  .value("PseudoVRGATHEREI16_VV_M8_E16_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E16_M8_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E32_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E32_M2)
  .value("PseudoVRGATHEREI16_VV_M8_E32_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E32_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E32_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E32_M4)
  .value("PseudoVRGATHEREI16_VV_M8_E32_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E32_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E32_M8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E32_M8)
  .value("PseudoVRGATHEREI16_VV_M8_E32_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E32_M8_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E64_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E64_M2)
  .value("PseudoVRGATHEREI16_VV_M8_E64_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E64_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E64_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E64_M4)
  .value("PseudoVRGATHEREI16_VV_M8_E64_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E64_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E64_M8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E64_M8)
  .value("PseudoVRGATHEREI16_VV_M8_E64_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E64_M8_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E8_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E8_M2)
  .value("PseudoVRGATHEREI16_VV_M8_E8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E8_M2_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E8_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E8_M4)
  .value("PseudoVRGATHEREI16_VV_M8_E8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E8_M4_MASK)
  .value("PseudoVRGATHEREI16_VV_M8_E8_M8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E8_M8)
  .value("PseudoVRGATHEREI16_VV_M8_E8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_M8_E8_M8_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E16_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E16_M1)
  .value("PseudoVRGATHEREI16_VV_MF2_E16_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E16_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E16_MF2)
  .value("PseudoVRGATHEREI16_VV_MF2_E16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E16_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E16_MF4)
  .value("PseudoVRGATHEREI16_VV_MF2_E16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E16_MF4_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E16_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E16_MF8)
  .value("PseudoVRGATHEREI16_VV_MF2_E16_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E16_MF8_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E32_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E32_M1)
  .value("PseudoVRGATHEREI16_VV_MF2_E32_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E32_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E32_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E32_MF2)
  .value("PseudoVRGATHEREI16_VV_MF2_E32_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E32_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E32_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E32_MF4)
  .value("PseudoVRGATHEREI16_VV_MF2_E32_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E32_MF4_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E32_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E32_MF8)
  .value("PseudoVRGATHEREI16_VV_MF2_E32_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E32_MF8_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E8_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E8_M1)
  .value("PseudoVRGATHEREI16_VV_MF2_E8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E8_M1_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E8_MF2)
  .value("PseudoVRGATHEREI16_VV_MF2_E8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E8_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E8_MF4)
  .value("PseudoVRGATHEREI16_VV_MF2_E8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E8_MF4_MASK)
  .value("PseudoVRGATHEREI16_VV_MF2_E8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E8_MF8)
  .value("PseudoVRGATHEREI16_VV_MF2_E8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF2_E8_MF8_MASK)
  .value("PseudoVRGATHEREI16_VV_MF4_E16_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E16_MF2)
  .value("PseudoVRGATHEREI16_VV_MF4_E16_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E16_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_MF4_E16_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E16_MF4)
  .value("PseudoVRGATHEREI16_VV_MF4_E16_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E16_MF4_MASK)
  .value("PseudoVRGATHEREI16_VV_MF4_E16_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E16_MF8)
  .value("PseudoVRGATHEREI16_VV_MF4_E16_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E16_MF8_MASK)
  .value("PseudoVRGATHEREI16_VV_MF4_E8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E8_MF2)
  .value("PseudoVRGATHEREI16_VV_MF4_E8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E8_MF2_MASK)
  .value("PseudoVRGATHEREI16_VV_MF4_E8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E8_MF4)
  .value("PseudoVRGATHEREI16_VV_MF4_E8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E8_MF4_MASK)
  .value("PseudoVRGATHEREI16_VV_MF4_E8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E8_MF8)
  .value("PseudoVRGATHEREI16_VV_MF4_E8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF4_E8_MF8_MASK)
  .value("PseudoVRGATHEREI16_VV_MF8_E8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF8_E8_MF4)
  .value("PseudoVRGATHEREI16_VV_MF8_E8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF8_E8_MF4_MASK)
  .value("PseudoVRGATHEREI16_VV_MF8_E8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF8_E8_MF8)
  .value("PseudoVRGATHEREI16_VV_MF8_E8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHEREI16_VV_MF8_E8_MF8_MASK)
  .value("PseudoVRGATHER_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_M1)
  .value("PseudoVRGATHER_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_M1_MASK)
  .value("PseudoVRGATHER_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_M2)
  .value("PseudoVRGATHER_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_M2_MASK)
  .value("PseudoVRGATHER_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_M4)
  .value("PseudoVRGATHER_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_M4_MASK)
  .value("PseudoVRGATHER_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_M8)
  .value("PseudoVRGATHER_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_M8_MASK)
  .value("PseudoVRGATHER_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_MF2)
  .value("PseudoVRGATHER_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_MF2_MASK)
  .value("PseudoVRGATHER_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_MF4)
  .value("PseudoVRGATHER_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_MF4_MASK)
  .value("PseudoVRGATHER_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_MF8)
  .value("PseudoVRGATHER_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VI_MF8_MASK)
  .value("PseudoVRGATHER_VV_M1_E16", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M1_E16)
  .value("PseudoVRGATHER_VV_M1_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M1_E16_MASK)
  .value("PseudoVRGATHER_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M1_E32)
  .value("PseudoVRGATHER_VV_M1_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M1_E32_MASK)
  .value("PseudoVRGATHER_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M1_E64)
  .value("PseudoVRGATHER_VV_M1_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M1_E64_MASK)
  .value("PseudoVRGATHER_VV_M1_E8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M1_E8)
  .value("PseudoVRGATHER_VV_M1_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M1_E8_MASK)
  .value("PseudoVRGATHER_VV_M2_E16", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M2_E16)
  .value("PseudoVRGATHER_VV_M2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M2_E16_MASK)
  .value("PseudoVRGATHER_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M2_E32)
  .value("PseudoVRGATHER_VV_M2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M2_E32_MASK)
  .value("PseudoVRGATHER_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M2_E64)
  .value("PseudoVRGATHER_VV_M2_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M2_E64_MASK)
  .value("PseudoVRGATHER_VV_M2_E8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M2_E8)
  .value("PseudoVRGATHER_VV_M2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M2_E8_MASK)
  .value("PseudoVRGATHER_VV_M4_E16", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M4_E16)
  .value("PseudoVRGATHER_VV_M4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M4_E16_MASK)
  .value("PseudoVRGATHER_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M4_E32)
  .value("PseudoVRGATHER_VV_M4_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M4_E32_MASK)
  .value("PseudoVRGATHER_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M4_E64)
  .value("PseudoVRGATHER_VV_M4_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M4_E64_MASK)
  .value("PseudoVRGATHER_VV_M4_E8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M4_E8)
  .value("PseudoVRGATHER_VV_M4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M4_E8_MASK)
  .value("PseudoVRGATHER_VV_M8_E16", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M8_E16)
  .value("PseudoVRGATHER_VV_M8_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M8_E16_MASK)
  .value("PseudoVRGATHER_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M8_E32)
  .value("PseudoVRGATHER_VV_M8_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M8_E32_MASK)
  .value("PseudoVRGATHER_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M8_E64)
  .value("PseudoVRGATHER_VV_M8_E64_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M8_E64_MASK)
  .value("PseudoVRGATHER_VV_M8_E8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M8_E8)
  .value("PseudoVRGATHER_VV_M8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_M8_E8_MASK)
  .value("PseudoVRGATHER_VV_MF2_E16", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF2_E16)
  .value("PseudoVRGATHER_VV_MF2_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF2_E16_MASK)
  .value("PseudoVRGATHER_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF2_E32)
  .value("PseudoVRGATHER_VV_MF2_E32_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF2_E32_MASK)
  .value("PseudoVRGATHER_VV_MF2_E8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF2_E8)
  .value("PseudoVRGATHER_VV_MF2_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF2_E8_MASK)
  .value("PseudoVRGATHER_VV_MF4_E16", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF4_E16)
  .value("PseudoVRGATHER_VV_MF4_E16_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF4_E16_MASK)
  .value("PseudoVRGATHER_VV_MF4_E8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF4_E8)
  .value("PseudoVRGATHER_VV_MF4_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF4_E8_MASK)
  .value("PseudoVRGATHER_VV_MF8_E8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF8_E8)
  .value("PseudoVRGATHER_VV_MF8_E8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VV_MF8_E8_MASK)
  .value("PseudoVRGATHER_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_M1)
  .value("PseudoVRGATHER_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_M1_MASK)
  .value("PseudoVRGATHER_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_M2)
  .value("PseudoVRGATHER_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_M2_MASK)
  .value("PseudoVRGATHER_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_M4)
  .value("PseudoVRGATHER_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_M4_MASK)
  .value("PseudoVRGATHER_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_M8)
  .value("PseudoVRGATHER_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_M8_MASK)
  .value("PseudoVRGATHER_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_MF2)
  .value("PseudoVRGATHER_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_MF2_MASK)
  .value("PseudoVRGATHER_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_MF4)
  .value("PseudoVRGATHER_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_MF4_MASK)
  .value("PseudoVRGATHER_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_MF8)
  .value("PseudoVRGATHER_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRGATHER_VX_MF8_MASK)
  .value("PseudoVROL_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_M1)
  .value("PseudoVROL_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_M1_MASK)
  .value("PseudoVROL_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_M2)
  .value("PseudoVROL_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_M2_MASK)
  .value("PseudoVROL_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_M4)
  .value("PseudoVROL_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_M4_MASK)
  .value("PseudoVROL_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_M8)
  .value("PseudoVROL_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_M8_MASK)
  .value("PseudoVROL_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_MF2)
  .value("PseudoVROL_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_MF2_MASK)
  .value("PseudoVROL_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_MF4)
  .value("PseudoVROL_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_MF4_MASK)
  .value("PseudoVROL_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_MF8)
  .value("PseudoVROL_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VV_MF8_MASK)
  .value("PseudoVROL_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_M1)
  .value("PseudoVROL_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_M1_MASK)
  .value("PseudoVROL_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_M2)
  .value("PseudoVROL_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_M2_MASK)
  .value("PseudoVROL_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_M4)
  .value("PseudoVROL_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_M4_MASK)
  .value("PseudoVROL_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_M8)
  .value("PseudoVROL_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_M8_MASK)
  .value("PseudoVROL_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_MF2)
  .value("PseudoVROL_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_MF2_MASK)
  .value("PseudoVROL_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_MF4)
  .value("PseudoVROL_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_MF4_MASK)
  .value("PseudoVROL_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_MF8)
  .value("PseudoVROL_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROL_VX_MF8_MASK)
  .value("PseudoVROR_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_M1)
  .value("PseudoVROR_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_M1_MASK)
  .value("PseudoVROR_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_M2)
  .value("PseudoVROR_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_M2_MASK)
  .value("PseudoVROR_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_M4)
  .value("PseudoVROR_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_M4_MASK)
  .value("PseudoVROR_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_M8)
  .value("PseudoVROR_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_M8_MASK)
  .value("PseudoVROR_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_MF2)
  .value("PseudoVROR_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_MF2_MASK)
  .value("PseudoVROR_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_MF4)
  .value("PseudoVROR_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_MF4_MASK)
  .value("PseudoVROR_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_MF8)
  .value("PseudoVROR_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VI_MF8_MASK)
  .value("PseudoVROR_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_M1)
  .value("PseudoVROR_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_M1_MASK)
  .value("PseudoVROR_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_M2)
  .value("PseudoVROR_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_M2_MASK)
  .value("PseudoVROR_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_M4)
  .value("PseudoVROR_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_M4_MASK)
  .value("PseudoVROR_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_M8)
  .value("PseudoVROR_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_M8_MASK)
  .value("PseudoVROR_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_MF2)
  .value("PseudoVROR_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_MF2_MASK)
  .value("PseudoVROR_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_MF4)
  .value("PseudoVROR_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_MF4_MASK)
  .value("PseudoVROR_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_MF8)
  .value("PseudoVROR_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VV_MF8_MASK)
  .value("PseudoVROR_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_M1)
  .value("PseudoVROR_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_M1_MASK)
  .value("PseudoVROR_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_M2)
  .value("PseudoVROR_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_M2_MASK)
  .value("PseudoVROR_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_M4)
  .value("PseudoVROR_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_M4_MASK)
  .value("PseudoVROR_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_M8)
  .value("PseudoVROR_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_M8_MASK)
  .value("PseudoVROR_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_MF2)
  .value("PseudoVROR_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_MF2_MASK)
  .value("PseudoVROR_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_MF4)
  .value("PseudoVROR_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_MF4_MASK)
  .value("PseudoVROR_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_MF8)
  .value("PseudoVROR_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVROR_VX_MF8_MASK)
  .value("PseudoVRSUB_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_M1)
  .value("PseudoVRSUB_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_M1_MASK)
  .value("PseudoVRSUB_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_M2)
  .value("PseudoVRSUB_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_M2_MASK)
  .value("PseudoVRSUB_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_M4)
  .value("PseudoVRSUB_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_M4_MASK)
  .value("PseudoVRSUB_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_M8)
  .value("PseudoVRSUB_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_M8_MASK)
  .value("PseudoVRSUB_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_MF2)
  .value("PseudoVRSUB_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_MF2_MASK)
  .value("PseudoVRSUB_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_MF4)
  .value("PseudoVRSUB_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_MF4_MASK)
  .value("PseudoVRSUB_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_MF8)
  .value("PseudoVRSUB_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VI_MF8_MASK)
  .value("PseudoVRSUB_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_M1)
  .value("PseudoVRSUB_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_M1_MASK)
  .value("PseudoVRSUB_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_M2)
  .value("PseudoVRSUB_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_M2_MASK)
  .value("PseudoVRSUB_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_M4)
  .value("PseudoVRSUB_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_M4_MASK)
  .value("PseudoVRSUB_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_M8)
  .value("PseudoVRSUB_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_M8_MASK);
  opcodes.value("PseudoVRSUB_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_MF2)
  .value("PseudoVRSUB_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_MF2_MASK)
  .value("PseudoVRSUB_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_MF4)
  .value("PseudoVRSUB_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_MF4_MASK)
  .value("PseudoVRSUB_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_MF8)
  .value("PseudoVRSUB_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVRSUB_VX_MF8_MASK)
  .value("PseudoVSADDU_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_M1)
  .value("PseudoVSADDU_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_M1_MASK)
  .value("PseudoVSADDU_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_M2)
  .value("PseudoVSADDU_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_M2_MASK)
  .value("PseudoVSADDU_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_M4)
  .value("PseudoVSADDU_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_M4_MASK)
  .value("PseudoVSADDU_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_M8)
  .value("PseudoVSADDU_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_M8_MASK)
  .value("PseudoVSADDU_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_MF2)
  .value("PseudoVSADDU_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_MF2_MASK)
  .value("PseudoVSADDU_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_MF4)
  .value("PseudoVSADDU_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_MF4_MASK)
  .value("PseudoVSADDU_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_MF8)
  .value("PseudoVSADDU_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VI_MF8_MASK)
  .value("PseudoVSADDU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_M1)
  .value("PseudoVSADDU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_M1_MASK)
  .value("PseudoVSADDU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_M2)
  .value("PseudoVSADDU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_M2_MASK)
  .value("PseudoVSADDU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_M4)
  .value("PseudoVSADDU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_M4_MASK)
  .value("PseudoVSADDU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_M8)
  .value("PseudoVSADDU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_M8_MASK)
  .value("PseudoVSADDU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_MF2)
  .value("PseudoVSADDU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_MF2_MASK)
  .value("PseudoVSADDU_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_MF4)
  .value("PseudoVSADDU_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_MF4_MASK)
  .value("PseudoVSADDU_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_MF8)
  .value("PseudoVSADDU_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VV_MF8_MASK)
  .value("PseudoVSADDU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_M1)
  .value("PseudoVSADDU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_M1_MASK)
  .value("PseudoVSADDU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_M2)
  .value("PseudoVSADDU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_M2_MASK)
  .value("PseudoVSADDU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_M4)
  .value("PseudoVSADDU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_M4_MASK)
  .value("PseudoVSADDU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_M8)
  .value("PseudoVSADDU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_M8_MASK)
  .value("PseudoVSADDU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_MF2)
  .value("PseudoVSADDU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_MF2_MASK)
  .value("PseudoVSADDU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_MF4)
  .value("PseudoVSADDU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_MF4_MASK)
  .value("PseudoVSADDU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_MF8)
  .value("PseudoVSADDU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADDU_VX_MF8_MASK)
  .value("PseudoVSADD_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_M1)
  .value("PseudoVSADD_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_M1_MASK)
  .value("PseudoVSADD_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_M2)
  .value("PseudoVSADD_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_M2_MASK)
  .value("PseudoVSADD_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_M4)
  .value("PseudoVSADD_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_M4_MASK)
  .value("PseudoVSADD_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_M8)
  .value("PseudoVSADD_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_M8_MASK)
  .value("PseudoVSADD_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_MF2)
  .value("PseudoVSADD_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_MF2_MASK)
  .value("PseudoVSADD_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_MF4)
  .value("PseudoVSADD_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_MF4_MASK)
  .value("PseudoVSADD_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_MF8)
  .value("PseudoVSADD_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VI_MF8_MASK)
  .value("PseudoVSADD_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_M1)
  .value("PseudoVSADD_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_M1_MASK)
  .value("PseudoVSADD_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_M2)
  .value("PseudoVSADD_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_M2_MASK)
  .value("PseudoVSADD_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_M4)
  .value("PseudoVSADD_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_M4_MASK)
  .value("PseudoVSADD_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_M8)
  .value("PseudoVSADD_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_M8_MASK)
  .value("PseudoVSADD_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_MF2)
  .value("PseudoVSADD_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_MF2_MASK)
  .value("PseudoVSADD_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_MF4)
  .value("PseudoVSADD_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_MF4_MASK)
  .value("PseudoVSADD_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_MF8)
  .value("PseudoVSADD_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VV_MF8_MASK)
  .value("PseudoVSADD_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_M1)
  .value("PseudoVSADD_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_M1_MASK)
  .value("PseudoVSADD_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_M2)
  .value("PseudoVSADD_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_M2_MASK)
  .value("PseudoVSADD_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_M4)
  .value("PseudoVSADD_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_M4_MASK)
  .value("PseudoVSADD_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_M8)
  .value("PseudoVSADD_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_M8_MASK)
  .value("PseudoVSADD_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_MF2)
  .value("PseudoVSADD_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_MF2_MASK)
  .value("PseudoVSADD_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_MF4)
  .value("PseudoVSADD_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_MF4_MASK)
  .value("PseudoVSADD_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_MF8)
  .value("PseudoVSADD_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSADD_VX_MF8_MASK)
  .value("PseudoVSBC_VVM_M1", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VVM_M1)
  .value("PseudoVSBC_VVM_M2", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VVM_M2)
  .value("PseudoVSBC_VVM_M4", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VVM_M4)
  .value("PseudoVSBC_VVM_M8", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VVM_M8)
  .value("PseudoVSBC_VVM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VVM_MF2)
  .value("PseudoVSBC_VVM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VVM_MF4)
  .value("PseudoVSBC_VVM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VVM_MF8)
  .value("PseudoVSBC_VXM_M1", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VXM_M1)
  .value("PseudoVSBC_VXM_M2", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VXM_M2)
  .value("PseudoVSBC_VXM_M4", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VXM_M4)
  .value("PseudoVSBC_VXM_M8", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VXM_M8)
  .value("PseudoVSBC_VXM_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VXM_MF2)
  .value("PseudoVSBC_VXM_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VXM_MF4)
  .value("PseudoVSBC_VXM_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSBC_VXM_MF8)
  .value("PseudoVSE16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_M1)
  .value("PseudoVSE16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_M1_MASK)
  .value("PseudoVSE16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_M2)
  .value("PseudoVSE16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_M2_MASK)
  .value("PseudoVSE16_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_M4)
  .value("PseudoVSE16_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_M4_MASK)
  .value("PseudoVSE16_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_M8)
  .value("PseudoVSE16_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_M8_MASK)
  .value("PseudoVSE16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_MF2)
  .value("PseudoVSE16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_MF2_MASK)
  .value("PseudoVSE16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_MF4)
  .value("PseudoVSE16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE16_V_MF4_MASK)
  .value("PseudoVSE32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSE32_V_M1)
  .value("PseudoVSE32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE32_V_M1_MASK)
  .value("PseudoVSE32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSE32_V_M2)
  .value("PseudoVSE32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE32_V_M2_MASK)
  .value("PseudoVSE32_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSE32_V_M4)
  .value("PseudoVSE32_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE32_V_M4_MASK)
  .value("PseudoVSE32_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVSE32_V_M8)
  .value("PseudoVSE32_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE32_V_M8_MASK)
  .value("PseudoVSE32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSE32_V_MF2)
  .value("PseudoVSE32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE32_V_MF2_MASK)
  .value("PseudoVSE64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSE64_V_M1)
  .value("PseudoVSE64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE64_V_M1_MASK)
  .value("PseudoVSE64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSE64_V_M2)
  .value("PseudoVSE64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE64_V_M2_MASK)
  .value("PseudoVSE64_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSE64_V_M4)
  .value("PseudoVSE64_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE64_V_M4_MASK)
  .value("PseudoVSE64_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVSE64_V_M8)
  .value("PseudoVSE64_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE64_V_M8_MASK)
  .value("PseudoVSE8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_M1)
  .value("PseudoVSE8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_M1_MASK)
  .value("PseudoVSE8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_M2)
  .value("PseudoVSE8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_M2_MASK)
  .value("PseudoVSE8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_M4)
  .value("PseudoVSE8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_M4_MASK)
  .value("PseudoVSE8_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_M8)
  .value("PseudoVSE8_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_M8_MASK)
  .value("PseudoVSE8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_MF2)
  .value("PseudoVSE8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_MF2_MASK)
  .value("PseudoVSE8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_MF4)
  .value("PseudoVSE8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_MF4_MASK)
  .value("PseudoVSE8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_MF8)
  .value("PseudoVSE8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSE8_V_MF8_MASK)
  .value("PseudoVSETIVLI", LIEF::assembly::riscv::OPCODE::PseudoVSETIVLI)
  .value("PseudoVSETVLI", LIEF::assembly::riscv::OPCODE::PseudoVSETVLI)
  .value("PseudoVSETVLIX0", LIEF::assembly::riscv::OPCODE::PseudoVSETVLIX0)
  .value("PseudoVSETVLIX0X0", LIEF::assembly::riscv::OPCODE::PseudoVSETVLIX0X0)
  .value("PseudoVSEXT_VF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_M1)
  .value("PseudoVSEXT_VF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_M1_MASK)
  .value("PseudoVSEXT_VF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_M2)
  .value("PseudoVSEXT_VF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_M2_MASK)
  .value("PseudoVSEXT_VF2_M4", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_M4)
  .value("PseudoVSEXT_VF2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_M4_MASK)
  .value("PseudoVSEXT_VF2_M8", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_M8)
  .value("PseudoVSEXT_VF2_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_M8_MASK)
  .value("PseudoVSEXT_VF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_MF2)
  .value("PseudoVSEXT_VF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_MF2_MASK)
  .value("PseudoVSEXT_VF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_MF4)
  .value("PseudoVSEXT_VF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF2_MF4_MASK)
  .value("PseudoVSEXT_VF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF4_M1)
  .value("PseudoVSEXT_VF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF4_M1_MASK)
  .value("PseudoVSEXT_VF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF4_M2)
  .value("PseudoVSEXT_VF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF4_M2_MASK)
  .value("PseudoVSEXT_VF4_M4", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF4_M4)
  .value("PseudoVSEXT_VF4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF4_M4_MASK)
  .value("PseudoVSEXT_VF4_M8", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF4_M8)
  .value("PseudoVSEXT_VF4_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF4_M8_MASK)
  .value("PseudoVSEXT_VF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF4_MF2)
  .value("PseudoVSEXT_VF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF4_MF2_MASK)
  .value("PseudoVSEXT_VF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF8_M1)
  .value("PseudoVSEXT_VF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF8_M1_MASK)
  .value("PseudoVSEXT_VF8_M2", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF8_M2)
  .value("PseudoVSEXT_VF8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF8_M2_MASK)
  .value("PseudoVSEXT_VF8_M4", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF8_M4)
  .value("PseudoVSEXT_VF8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF8_M4_MASK)
  .value("PseudoVSEXT_VF8_M8", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF8_M8)
  .value("PseudoVSEXT_VF8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSEXT_VF8_M8_MASK)
  .value("PseudoVSHA2CH_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSHA2CH_VV_M1)
  .value("PseudoVSHA2CH_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSHA2CH_VV_M2)
  .value("PseudoVSHA2CH_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSHA2CH_VV_M4)
  .value("PseudoVSHA2CH_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSHA2CH_VV_M8)
  .value("PseudoVSHA2CH_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSHA2CH_VV_MF2)
  .value("PseudoVSHA2CL_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSHA2CL_VV_M1)
  .value("PseudoVSHA2CL_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSHA2CL_VV_M2)
  .value("PseudoVSHA2CL_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSHA2CL_VV_M4)
  .value("PseudoVSHA2CL_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSHA2CL_VV_M8)
  .value("PseudoVSHA2CL_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSHA2CL_VV_MF2)
  .value("PseudoVSHA2MS_VV_M1_E32", LIEF::assembly::riscv::OPCODE::PseudoVSHA2MS_VV_M1_E32)
  .value("PseudoVSHA2MS_VV_M1_E64", LIEF::assembly::riscv::OPCODE::PseudoVSHA2MS_VV_M1_E64)
  .value("PseudoVSHA2MS_VV_M2_E32", LIEF::assembly::riscv::OPCODE::PseudoVSHA2MS_VV_M2_E32)
  .value("PseudoVSHA2MS_VV_M2_E64", LIEF::assembly::riscv::OPCODE::PseudoVSHA2MS_VV_M2_E64)
  .value("PseudoVSHA2MS_VV_M4_E32", LIEF::assembly::riscv::OPCODE::PseudoVSHA2MS_VV_M4_E32)
  .value("PseudoVSHA2MS_VV_M4_E64", LIEF::assembly::riscv::OPCODE::PseudoVSHA2MS_VV_M4_E64)
  .value("PseudoVSHA2MS_VV_M8_E32", LIEF::assembly::riscv::OPCODE::PseudoVSHA2MS_VV_M8_E32)
  .value("PseudoVSHA2MS_VV_M8_E64", LIEF::assembly::riscv::OPCODE::PseudoVSHA2MS_VV_M8_E64)
  .value("PseudoVSHA2MS_VV_MF2_E32", LIEF::assembly::riscv::OPCODE::PseudoVSHA2MS_VV_MF2_E32)
  .value("PseudoVSLIDE1DOWN_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_M1)
  .value("PseudoVSLIDE1DOWN_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_M1_MASK)
  .value("PseudoVSLIDE1DOWN_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_M2)
  .value("PseudoVSLIDE1DOWN_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_M2_MASK)
  .value("PseudoVSLIDE1DOWN_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_M4)
  .value("PseudoVSLIDE1DOWN_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_M4_MASK)
  .value("PseudoVSLIDE1DOWN_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_M8)
  .value("PseudoVSLIDE1DOWN_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_M8_MASK)
  .value("PseudoVSLIDE1DOWN_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_MF2)
  .value("PseudoVSLIDE1DOWN_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_MF2_MASK)
  .value("PseudoVSLIDE1DOWN_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_MF4)
  .value("PseudoVSLIDE1DOWN_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_MF4_MASK)
  .value("PseudoVSLIDE1DOWN_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_MF8)
  .value("PseudoVSLIDE1DOWN_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1DOWN_VX_MF8_MASK)
  .value("PseudoVSLIDE1UP_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_M1)
  .value("PseudoVSLIDE1UP_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_M1_MASK)
  .value("PseudoVSLIDE1UP_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_M2)
  .value("PseudoVSLIDE1UP_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_M2_MASK)
  .value("PseudoVSLIDE1UP_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_M4)
  .value("PseudoVSLIDE1UP_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_M4_MASK)
  .value("PseudoVSLIDE1UP_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_M8)
  .value("PseudoVSLIDE1UP_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_M8_MASK)
  .value("PseudoVSLIDE1UP_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_MF2)
  .value("PseudoVSLIDE1UP_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_MF2_MASK)
  .value("PseudoVSLIDE1UP_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_MF4)
  .value("PseudoVSLIDE1UP_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_MF4_MASK)
  .value("PseudoVSLIDE1UP_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_MF8)
  .value("PseudoVSLIDE1UP_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDE1UP_VX_MF8_MASK)
  .value("PseudoVSLIDEDOWN_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_M1)
  .value("PseudoVSLIDEDOWN_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_M1_MASK)
  .value("PseudoVSLIDEDOWN_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_M2)
  .value("PseudoVSLIDEDOWN_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_M2_MASK)
  .value("PseudoVSLIDEDOWN_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_M4)
  .value("PseudoVSLIDEDOWN_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_M4_MASK)
  .value("PseudoVSLIDEDOWN_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_M8)
  .value("PseudoVSLIDEDOWN_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_M8_MASK)
  .value("PseudoVSLIDEDOWN_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_MF2)
  .value("PseudoVSLIDEDOWN_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_MF2_MASK)
  .value("PseudoVSLIDEDOWN_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_MF4)
  .value("PseudoVSLIDEDOWN_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_MF4_MASK)
  .value("PseudoVSLIDEDOWN_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_MF8)
  .value("PseudoVSLIDEDOWN_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VI_MF8_MASK)
  .value("PseudoVSLIDEDOWN_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_M1)
  .value("PseudoVSLIDEDOWN_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_M1_MASK)
  .value("PseudoVSLIDEDOWN_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_M2)
  .value("PseudoVSLIDEDOWN_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_M2_MASK)
  .value("PseudoVSLIDEDOWN_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_M4)
  .value("PseudoVSLIDEDOWN_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_M4_MASK)
  .value("PseudoVSLIDEDOWN_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_M8)
  .value("PseudoVSLIDEDOWN_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_M8_MASK)
  .value("PseudoVSLIDEDOWN_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_MF2)
  .value("PseudoVSLIDEDOWN_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_MF2_MASK)
  .value("PseudoVSLIDEDOWN_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_MF4)
  .value("PseudoVSLIDEDOWN_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_MF4_MASK)
  .value("PseudoVSLIDEDOWN_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_MF8)
  .value("PseudoVSLIDEDOWN_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEDOWN_VX_MF8_MASK)
  .value("PseudoVSLIDEUP_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_M1)
  .value("PseudoVSLIDEUP_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_M1_MASK)
  .value("PseudoVSLIDEUP_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_M2)
  .value("PseudoVSLIDEUP_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_M2_MASK)
  .value("PseudoVSLIDEUP_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_M4)
  .value("PseudoVSLIDEUP_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_M4_MASK)
  .value("PseudoVSLIDEUP_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_M8)
  .value("PseudoVSLIDEUP_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_M8_MASK)
  .value("PseudoVSLIDEUP_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_MF2)
  .value("PseudoVSLIDEUP_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_MF2_MASK)
  .value("PseudoVSLIDEUP_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_MF4)
  .value("PseudoVSLIDEUP_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_MF4_MASK)
  .value("PseudoVSLIDEUP_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_MF8)
  .value("PseudoVSLIDEUP_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VI_MF8_MASK)
  .value("PseudoVSLIDEUP_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_M1)
  .value("PseudoVSLIDEUP_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_M1_MASK)
  .value("PseudoVSLIDEUP_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_M2)
  .value("PseudoVSLIDEUP_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_M2_MASK)
  .value("PseudoVSLIDEUP_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_M4)
  .value("PseudoVSLIDEUP_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_M4_MASK)
  .value("PseudoVSLIDEUP_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_M8)
  .value("PseudoVSLIDEUP_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_M8_MASK)
  .value("PseudoVSLIDEUP_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_MF2)
  .value("PseudoVSLIDEUP_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_MF2_MASK)
  .value("PseudoVSLIDEUP_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_MF4)
  .value("PseudoVSLIDEUP_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_MF4_MASK)
  .value("PseudoVSLIDEUP_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_MF8)
  .value("PseudoVSLIDEUP_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLIDEUP_VX_MF8_MASK)
  .value("PseudoVSLL_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_M1)
  .value("PseudoVSLL_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_M1_MASK)
  .value("PseudoVSLL_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_M2)
  .value("PseudoVSLL_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_M2_MASK)
  .value("PseudoVSLL_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_M4)
  .value("PseudoVSLL_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_M4_MASK)
  .value("PseudoVSLL_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_M8)
  .value("PseudoVSLL_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_M8_MASK)
  .value("PseudoVSLL_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_MF2)
  .value("PseudoVSLL_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_MF2_MASK)
  .value("PseudoVSLL_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_MF4)
  .value("PseudoVSLL_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_MF4_MASK)
  .value("PseudoVSLL_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_MF8)
  .value("PseudoVSLL_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VI_MF8_MASK)
  .value("PseudoVSLL_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_M1);
  opcodes.value("PseudoVSLL_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_M1_MASK)
  .value("PseudoVSLL_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_M2)
  .value("PseudoVSLL_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_M2_MASK)
  .value("PseudoVSLL_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_M4)
  .value("PseudoVSLL_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_M4_MASK)
  .value("PseudoVSLL_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_M8)
  .value("PseudoVSLL_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_M8_MASK)
  .value("PseudoVSLL_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_MF2)
  .value("PseudoVSLL_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_MF2_MASK)
  .value("PseudoVSLL_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_MF4)
  .value("PseudoVSLL_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_MF4_MASK)
  .value("PseudoVSLL_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_MF8)
  .value("PseudoVSLL_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VV_MF8_MASK)
  .value("PseudoVSLL_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_M1)
  .value("PseudoVSLL_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_M1_MASK)
  .value("PseudoVSLL_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_M2)
  .value("PseudoVSLL_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_M2_MASK)
  .value("PseudoVSLL_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_M4)
  .value("PseudoVSLL_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_M4_MASK)
  .value("PseudoVSLL_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_M8)
  .value("PseudoVSLL_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_M8_MASK)
  .value("PseudoVSLL_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_MF2)
  .value("PseudoVSLL_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_MF2_MASK)
  .value("PseudoVSLL_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_MF4)
  .value("PseudoVSLL_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_MF4_MASK)
  .value("PseudoVSLL_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_MF8)
  .value("PseudoVSLL_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSLL_VX_MF8_MASK)
  .value("PseudoVSM3C_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSM3C_VI_M1)
  .value("PseudoVSM3C_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSM3C_VI_M2)
  .value("PseudoVSM3C_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSM3C_VI_M4)
  .value("PseudoVSM3C_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSM3C_VI_M8)
  .value("PseudoVSM3C_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSM3C_VI_MF2)
  .value("PseudoVSM3ME_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSM3ME_VV_M1)
  .value("PseudoVSM3ME_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSM3ME_VV_M2)
  .value("PseudoVSM3ME_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSM3ME_VV_M4)
  .value("PseudoVSM3ME_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSM3ME_VV_M8)
  .value("PseudoVSM3ME_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSM3ME_VV_MF2)
  .value("PseudoVSM4K_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSM4K_VI_M1)
  .value("PseudoVSM4K_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSM4K_VI_M2)
  .value("PseudoVSM4K_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSM4K_VI_M4)
  .value("PseudoVSM4K_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSM4K_VI_M8)
  .value("PseudoVSM4K_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSM4K_VI_MF2)
  .value("PseudoVSM4R_VS_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M1_M1)
  .value("PseudoVSM4R_VS_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M1_MF2)
  .value("PseudoVSM4R_VS_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M1_MF4)
  .value("PseudoVSM4R_VS_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M1_MF8)
  .value("PseudoVSM4R_VS_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M2_M1)
  .value("PseudoVSM4R_VS_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M2_M2)
  .value("PseudoVSM4R_VS_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M2_MF2)
  .value("PseudoVSM4R_VS_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M2_MF4)
  .value("PseudoVSM4R_VS_M2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M2_MF8)
  .value("PseudoVSM4R_VS_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M4_M1)
  .value("PseudoVSM4R_VS_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M4_M2)
  .value("PseudoVSM4R_VS_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M4_M4)
  .value("PseudoVSM4R_VS_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M4_MF2)
  .value("PseudoVSM4R_VS_M4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M4_MF4)
  .value("PseudoVSM4R_VS_M4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M4_MF8)
  .value("PseudoVSM4R_VS_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M8_M1)
  .value("PseudoVSM4R_VS_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M8_M2)
  .value("PseudoVSM4R_VS_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M8_M4)
  .value("PseudoVSM4R_VS_M8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M8_MF2)
  .value("PseudoVSM4R_VS_M8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M8_MF4)
  .value("PseudoVSM4R_VS_M8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_M8_MF8)
  .value("PseudoVSM4R_VS_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_MF2_MF2)
  .value("PseudoVSM4R_VS_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_MF2_MF4)
  .value("PseudoVSM4R_VS_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VS_MF2_MF8)
  .value("PseudoVSM4R_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VV_M1)
  .value("PseudoVSM4R_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VV_M2)
  .value("PseudoVSM4R_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VV_M4)
  .value("PseudoVSM4R_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VV_M8)
  .value("PseudoVSM4R_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSM4R_VV_MF2)
  .value("PseudoVSMUL_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_M1)
  .value("PseudoVSMUL_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_M1_MASK)
  .value("PseudoVSMUL_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_M2)
  .value("PseudoVSMUL_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_M2_MASK)
  .value("PseudoVSMUL_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_M4)
  .value("PseudoVSMUL_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_M4_MASK)
  .value("PseudoVSMUL_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_M8)
  .value("PseudoVSMUL_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_M8_MASK)
  .value("PseudoVSMUL_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_MF2)
  .value("PseudoVSMUL_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_MF2_MASK)
  .value("PseudoVSMUL_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_MF4)
  .value("PseudoVSMUL_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_MF4_MASK)
  .value("PseudoVSMUL_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_MF8)
  .value("PseudoVSMUL_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VV_MF8_MASK)
  .value("PseudoVSMUL_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_M1)
  .value("PseudoVSMUL_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_M1_MASK)
  .value("PseudoVSMUL_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_M2)
  .value("PseudoVSMUL_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_M2_MASK)
  .value("PseudoVSMUL_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_M4)
  .value("PseudoVSMUL_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_M4_MASK)
  .value("PseudoVSMUL_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_M8)
  .value("PseudoVSMUL_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_M8_MASK)
  .value("PseudoVSMUL_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_MF2)
  .value("PseudoVSMUL_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_MF2_MASK)
  .value("PseudoVSMUL_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_MF4)
  .value("PseudoVSMUL_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_MF4_MASK)
  .value("PseudoVSMUL_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_MF8)
  .value("PseudoVSMUL_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSMUL_VX_MF8_MASK)
  .value("PseudoVSM_V_B1", LIEF::assembly::riscv::OPCODE::PseudoVSM_V_B1)
  .value("PseudoVSM_V_B16", LIEF::assembly::riscv::OPCODE::PseudoVSM_V_B16)
  .value("PseudoVSM_V_B2", LIEF::assembly::riscv::OPCODE::PseudoVSM_V_B2)
  .value("PseudoVSM_V_B32", LIEF::assembly::riscv::OPCODE::PseudoVSM_V_B32)
  .value("PseudoVSM_V_B4", LIEF::assembly::riscv::OPCODE::PseudoVSM_V_B4)
  .value("PseudoVSM_V_B64", LIEF::assembly::riscv::OPCODE::PseudoVSM_V_B64)
  .value("PseudoVSM_V_B8", LIEF::assembly::riscv::OPCODE::PseudoVSM_V_B8)
  .value("PseudoVSOXEI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M1_M1)
  .value("PseudoVSOXEI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M1_M1_MASK)
  .value("PseudoVSOXEI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M1_M2)
  .value("PseudoVSOXEI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M1_M2_MASK)
  .value("PseudoVSOXEI16_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M1_M4)
  .value("PseudoVSOXEI16_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M1_M4_MASK)
  .value("PseudoVSOXEI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M1_MF2)
  .value("PseudoVSOXEI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M1_MF2_MASK)
  .value("PseudoVSOXEI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M2_M1)
  .value("PseudoVSOXEI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M2_M1_MASK)
  .value("PseudoVSOXEI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M2_M2)
  .value("PseudoVSOXEI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M2_M2_MASK)
  .value("PseudoVSOXEI16_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M2_M4)
  .value("PseudoVSOXEI16_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M2_M4_MASK)
  .value("PseudoVSOXEI16_V_M2_M8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M2_M8)
  .value("PseudoVSOXEI16_V_M2_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M2_M8_MASK)
  .value("PseudoVSOXEI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M4_M2)
  .value("PseudoVSOXEI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M4_M2_MASK)
  .value("PseudoVSOXEI16_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M4_M4)
  .value("PseudoVSOXEI16_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M4_M4_MASK)
  .value("PseudoVSOXEI16_V_M4_M8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M4_M8)
  .value("PseudoVSOXEI16_V_M4_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M4_M8_MASK)
  .value("PseudoVSOXEI16_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M8_M4)
  .value("PseudoVSOXEI16_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M8_M4_MASK)
  .value("PseudoVSOXEI16_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M8_M8)
  .value("PseudoVSOXEI16_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_M8_M8_MASK)
  .value("PseudoVSOXEI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF2_M1)
  .value("PseudoVSOXEI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF2_M1_MASK)
  .value("PseudoVSOXEI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF2_M2)
  .value("PseudoVSOXEI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF2_M2_MASK)
  .value("PseudoVSOXEI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF2_MF2)
  .value("PseudoVSOXEI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF2_MF2_MASK)
  .value("PseudoVSOXEI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF2_MF4)
  .value("PseudoVSOXEI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF2_MF4_MASK)
  .value("PseudoVSOXEI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF4_M1)
  .value("PseudoVSOXEI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF4_M1_MASK)
  .value("PseudoVSOXEI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF4_MF2)
  .value("PseudoVSOXEI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF4_MF2_MASK)
  .value("PseudoVSOXEI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF4_MF4)
  .value("PseudoVSOXEI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF4_MF4_MASK)
  .value("PseudoVSOXEI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF4_MF8)
  .value("PseudoVSOXEI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI16_V_MF4_MF8_MASK)
  .value("PseudoVSOXEI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M1_M1)
  .value("PseudoVSOXEI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M1_M1_MASK)
  .value("PseudoVSOXEI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M1_M2)
  .value("PseudoVSOXEI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M1_M2_MASK)
  .value("PseudoVSOXEI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M1_MF2)
  .value("PseudoVSOXEI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M1_MF2_MASK)
  .value("PseudoVSOXEI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M1_MF4)
  .value("PseudoVSOXEI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M1_MF4_MASK)
  .value("PseudoVSOXEI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M2_M1)
  .value("PseudoVSOXEI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M2_M1_MASK)
  .value("PseudoVSOXEI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M2_M2)
  .value("PseudoVSOXEI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M2_M2_MASK)
  .value("PseudoVSOXEI32_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M2_M4)
  .value("PseudoVSOXEI32_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M2_M4_MASK)
  .value("PseudoVSOXEI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M2_MF2)
  .value("PseudoVSOXEI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M2_MF2_MASK)
  .value("PseudoVSOXEI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M4_M1)
  .value("PseudoVSOXEI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M4_M1_MASK)
  .value("PseudoVSOXEI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M4_M2)
  .value("PseudoVSOXEI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M4_M2_MASK)
  .value("PseudoVSOXEI32_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M4_M4)
  .value("PseudoVSOXEI32_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M4_M4_MASK)
  .value("PseudoVSOXEI32_V_M4_M8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M4_M8)
  .value("PseudoVSOXEI32_V_M4_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M4_M8_MASK)
  .value("PseudoVSOXEI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M8_M2)
  .value("PseudoVSOXEI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M8_M2_MASK)
  .value("PseudoVSOXEI32_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M8_M4)
  .value("PseudoVSOXEI32_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M8_M4_MASK)
  .value("PseudoVSOXEI32_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M8_M8)
  .value("PseudoVSOXEI32_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_M8_M8_MASK)
  .value("PseudoVSOXEI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_MF2_M1)
  .value("PseudoVSOXEI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_MF2_M1_MASK)
  .value("PseudoVSOXEI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_MF2_MF2)
  .value("PseudoVSOXEI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_MF2_MF2_MASK)
  .value("PseudoVSOXEI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_MF2_MF4)
  .value("PseudoVSOXEI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_MF2_MF4_MASK)
  .value("PseudoVSOXEI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_MF2_MF8)
  .value("PseudoVSOXEI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI32_V_MF2_MF8_MASK)
  .value("PseudoVSOXEI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M1_M1)
  .value("PseudoVSOXEI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M1_M1_MASK)
  .value("PseudoVSOXEI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M1_MF2)
  .value("PseudoVSOXEI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M1_MF2_MASK)
  .value("PseudoVSOXEI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M1_MF4)
  .value("PseudoVSOXEI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M1_MF4_MASK)
  .value("PseudoVSOXEI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M1_MF8)
  .value("PseudoVSOXEI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M1_MF8_MASK)
  .value("PseudoVSOXEI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M2_M1)
  .value("PseudoVSOXEI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M2_M1_MASK)
  .value("PseudoVSOXEI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M2_M2)
  .value("PseudoVSOXEI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M2_M2_MASK)
  .value("PseudoVSOXEI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M2_MF2)
  .value("PseudoVSOXEI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M2_MF2_MASK)
  .value("PseudoVSOXEI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M2_MF4)
  .value("PseudoVSOXEI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M2_MF4_MASK)
  .value("PseudoVSOXEI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M4_M1)
  .value("PseudoVSOXEI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M4_M1_MASK)
  .value("PseudoVSOXEI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M4_M2)
  .value("PseudoVSOXEI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M4_M2_MASK)
  .value("PseudoVSOXEI64_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M4_M4)
  .value("PseudoVSOXEI64_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M4_M4_MASK)
  .value("PseudoVSOXEI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M4_MF2)
  .value("PseudoVSOXEI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M4_MF2_MASK)
  .value("PseudoVSOXEI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M8_M1)
  .value("PseudoVSOXEI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M8_M1_MASK)
  .value("PseudoVSOXEI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M8_M2)
  .value("PseudoVSOXEI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M8_M2_MASK)
  .value("PseudoVSOXEI64_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M8_M4)
  .value("PseudoVSOXEI64_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M8_M4_MASK)
  .value("PseudoVSOXEI64_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M8_M8)
  .value("PseudoVSOXEI64_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI64_V_M8_M8_MASK)
  .value("PseudoVSOXEI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M1_M1)
  .value("PseudoVSOXEI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M1_M1_MASK)
  .value("PseudoVSOXEI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M1_M2)
  .value("PseudoVSOXEI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M1_M2_MASK)
  .value("PseudoVSOXEI8_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M1_M4)
  .value("PseudoVSOXEI8_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M1_M4_MASK)
  .value("PseudoVSOXEI8_V_M1_M8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M1_M8)
  .value("PseudoVSOXEI8_V_M1_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M1_M8_MASK)
  .value("PseudoVSOXEI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M2_M2)
  .value("PseudoVSOXEI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M2_M2_MASK)
  .value("PseudoVSOXEI8_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M2_M4)
  .value("PseudoVSOXEI8_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M2_M4_MASK)
  .value("PseudoVSOXEI8_V_M2_M8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M2_M8)
  .value("PseudoVSOXEI8_V_M2_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M2_M8_MASK)
  .value("PseudoVSOXEI8_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M4_M4)
  .value("PseudoVSOXEI8_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M4_M4_MASK)
  .value("PseudoVSOXEI8_V_M4_M8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M4_M8)
  .value("PseudoVSOXEI8_V_M4_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M4_M8_MASK)
  .value("PseudoVSOXEI8_V_M8_M8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M8_M8)
  .value("PseudoVSOXEI8_V_M8_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_M8_M8_MASK)
  .value("PseudoVSOXEI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF2_M1)
  .value("PseudoVSOXEI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF2_M1_MASK)
  .value("PseudoVSOXEI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF2_M2)
  .value("PseudoVSOXEI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF2_M2_MASK)
  .value("PseudoVSOXEI8_V_MF2_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF2_M4)
  .value("PseudoVSOXEI8_V_MF2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF2_M4_MASK)
  .value("PseudoVSOXEI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF2_MF2)
  .value("PseudoVSOXEI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF2_MF2_MASK)
  .value("PseudoVSOXEI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF4_M1)
  .value("PseudoVSOXEI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF4_M1_MASK)
  .value("PseudoVSOXEI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF4_M2)
  .value("PseudoVSOXEI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF4_M2_MASK)
  .value("PseudoVSOXEI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF4_MF2)
  .value("PseudoVSOXEI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF4_MF2_MASK)
  .value("PseudoVSOXEI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF4_MF4)
  .value("PseudoVSOXEI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF4_MF4_MASK)
  .value("PseudoVSOXEI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF8_M1)
  .value("PseudoVSOXEI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF8_M1_MASK)
  .value("PseudoVSOXEI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF8_MF2)
  .value("PseudoVSOXEI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF8_MF2_MASK)
  .value("PseudoVSOXEI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF8_MF4)
  .value("PseudoVSOXEI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF8_MF4_MASK)
  .value("PseudoVSOXEI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF8_MF8)
  .value("PseudoVSOXEI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXEI8_V_MF8_MF8_MASK)
  .value("PseudoVSOXSEG2EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M1_M1)
  .value("PseudoVSOXSEG2EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M1_M1_MASK)
  .value("PseudoVSOXSEG2EI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M1_M2)
  .value("PseudoVSOXSEG2EI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M1_M2_MASK)
  .value("PseudoVSOXSEG2EI16_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M1_M4)
  .value("PseudoVSOXSEG2EI16_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M1_M4_MASK)
  .value("PseudoVSOXSEG2EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M1_MF2)
  .value("PseudoVSOXSEG2EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG2EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M2_M1)
  .value("PseudoVSOXSEG2EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M2_M1_MASK)
  .value("PseudoVSOXSEG2EI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M2_M2)
  .value("PseudoVSOXSEG2EI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M2_M2_MASK)
  .value("PseudoVSOXSEG2EI16_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M2_M4)
  .value("PseudoVSOXSEG2EI16_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M2_M4_MASK)
  .value("PseudoVSOXSEG2EI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M4_M2)
  .value("PseudoVSOXSEG2EI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M4_M2_MASK)
  .value("PseudoVSOXSEG2EI16_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M4_M4)
  .value("PseudoVSOXSEG2EI16_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M4_M4_MASK)
  .value("PseudoVSOXSEG2EI16_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M8_M4)
  .value("PseudoVSOXSEG2EI16_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_M8_M4_MASK)
  .value("PseudoVSOXSEG2EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF2_M1)
  .value("PseudoVSOXSEG2EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG2EI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF2_M2)
  .value("PseudoVSOXSEG2EI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF2_M2_MASK)
  .value("PseudoVSOXSEG2EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF2_MF2)
  .value("PseudoVSOXSEG2EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG2EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF2_MF4)
  .value("PseudoVSOXSEG2EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG2EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF4_M1)
  .value("PseudoVSOXSEG2EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG2EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF4_MF2)
  .value("PseudoVSOXSEG2EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG2EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF4_MF4)
  .value("PseudoVSOXSEG2EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG2EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF4_MF8)
  .value("PseudoVSOXSEG2EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI16_V_MF4_MF8_MASK)
  .value("PseudoVSOXSEG2EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M1_M1)
  .value("PseudoVSOXSEG2EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M1_M1_MASK);
  opcodes.value("PseudoVSOXSEG2EI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M1_M2)
  .value("PseudoVSOXSEG2EI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M1_M2_MASK)
  .value("PseudoVSOXSEG2EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M1_MF2)
  .value("PseudoVSOXSEG2EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG2EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M1_MF4)
  .value("PseudoVSOXSEG2EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG2EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M2_M1)
  .value("PseudoVSOXSEG2EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M2_M1_MASK)
  .value("PseudoVSOXSEG2EI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M2_M2)
  .value("PseudoVSOXSEG2EI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M2_M2_MASK)
  .value("PseudoVSOXSEG2EI32_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M2_M4)
  .value("PseudoVSOXSEG2EI32_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M2_M4_MASK)
  .value("PseudoVSOXSEG2EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M2_MF2)
  .value("PseudoVSOXSEG2EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG2EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M4_M1)
  .value("PseudoVSOXSEG2EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M4_M1_MASK)
  .value("PseudoVSOXSEG2EI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M4_M2)
  .value("PseudoVSOXSEG2EI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M4_M2_MASK)
  .value("PseudoVSOXSEG2EI32_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M4_M4)
  .value("PseudoVSOXSEG2EI32_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M4_M4_MASK)
  .value("PseudoVSOXSEG2EI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M8_M2)
  .value("PseudoVSOXSEG2EI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M8_M2_MASK)
  .value("PseudoVSOXSEG2EI32_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M8_M4)
  .value("PseudoVSOXSEG2EI32_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_M8_M4_MASK)
  .value("PseudoVSOXSEG2EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_MF2_M1)
  .value("PseudoVSOXSEG2EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG2EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_MF2_MF2)
  .value("PseudoVSOXSEG2EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG2EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_MF2_MF4)
  .value("PseudoVSOXSEG2EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG2EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_MF2_MF8)
  .value("PseudoVSOXSEG2EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI32_V_MF2_MF8_MASK)
  .value("PseudoVSOXSEG2EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M1_M1)
  .value("PseudoVSOXSEG2EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M1_M1_MASK)
  .value("PseudoVSOXSEG2EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M1_MF2)
  .value("PseudoVSOXSEG2EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG2EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M1_MF4)
  .value("PseudoVSOXSEG2EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG2EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M1_MF8)
  .value("PseudoVSOXSEG2EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M1_MF8_MASK)
  .value("PseudoVSOXSEG2EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M2_M1)
  .value("PseudoVSOXSEG2EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M2_M1_MASK)
  .value("PseudoVSOXSEG2EI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M2_M2)
  .value("PseudoVSOXSEG2EI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M2_M2_MASK)
  .value("PseudoVSOXSEG2EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M2_MF2)
  .value("PseudoVSOXSEG2EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG2EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M2_MF4)
  .value("PseudoVSOXSEG2EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M2_MF4_MASK)
  .value("PseudoVSOXSEG2EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M4_M1)
  .value("PseudoVSOXSEG2EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M4_M1_MASK)
  .value("PseudoVSOXSEG2EI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M4_M2)
  .value("PseudoVSOXSEG2EI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M4_M2_MASK)
  .value("PseudoVSOXSEG2EI64_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M4_M4)
  .value("PseudoVSOXSEG2EI64_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M4_M4_MASK)
  .value("PseudoVSOXSEG2EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M4_MF2)
  .value("PseudoVSOXSEG2EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M4_MF2_MASK)
  .value("PseudoVSOXSEG2EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M8_M1)
  .value("PseudoVSOXSEG2EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M8_M1_MASK)
  .value("PseudoVSOXSEG2EI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M8_M2)
  .value("PseudoVSOXSEG2EI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M8_M2_MASK)
  .value("PseudoVSOXSEG2EI64_V_M8_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M8_M4)
  .value("PseudoVSOXSEG2EI64_V_M8_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI64_V_M8_M4_MASK)
  .value("PseudoVSOXSEG2EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M1_M1)
  .value("PseudoVSOXSEG2EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M1_M1_MASK)
  .value("PseudoVSOXSEG2EI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M1_M2)
  .value("PseudoVSOXSEG2EI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M1_M2_MASK)
  .value("PseudoVSOXSEG2EI8_V_M1_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M1_M4)
  .value("PseudoVSOXSEG2EI8_V_M1_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M1_M4_MASK)
  .value("PseudoVSOXSEG2EI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M2_M2)
  .value("PseudoVSOXSEG2EI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M2_M2_MASK)
  .value("PseudoVSOXSEG2EI8_V_M2_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M2_M4)
  .value("PseudoVSOXSEG2EI8_V_M2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M2_M4_MASK)
  .value("PseudoVSOXSEG2EI8_V_M4_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M4_M4)
  .value("PseudoVSOXSEG2EI8_V_M4_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_M4_M4_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF2_M1)
  .value("PseudoVSOXSEG2EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF2_M2)
  .value("PseudoVSOXSEG2EI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF2_M2_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF2_M4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF2_M4)
  .value("PseudoVSOXSEG2EI8_V_MF2_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF2_M4_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF2_MF2)
  .value("PseudoVSOXSEG2EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF4_M1)
  .value("PseudoVSOXSEG2EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF4_M2)
  .value("PseudoVSOXSEG2EI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF4_M2_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF4_MF2)
  .value("PseudoVSOXSEG2EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF4_MF4)
  .value("PseudoVSOXSEG2EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF8_M1)
  .value("PseudoVSOXSEG2EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF8_M1_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF8_MF2)
  .value("PseudoVSOXSEG2EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF8_MF2_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF8_MF4)
  .value("PseudoVSOXSEG2EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF8_MF4_MASK)
  .value("PseudoVSOXSEG2EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF8_MF8)
  .value("PseudoVSOXSEG2EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG2EI8_V_MF8_MF8_MASK)
  .value("PseudoVSOXSEG3EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M1_M1)
  .value("PseudoVSOXSEG3EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M1_M1_MASK)
  .value("PseudoVSOXSEG3EI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M1_M2)
  .value("PseudoVSOXSEG3EI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M1_M2_MASK)
  .value("PseudoVSOXSEG3EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M1_MF2)
  .value("PseudoVSOXSEG3EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG3EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M2_M1)
  .value("PseudoVSOXSEG3EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M2_M1_MASK)
  .value("PseudoVSOXSEG3EI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M2_M2)
  .value("PseudoVSOXSEG3EI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M2_M2_MASK)
  .value("PseudoVSOXSEG3EI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M4_M2)
  .value("PseudoVSOXSEG3EI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_M4_M2_MASK)
  .value("PseudoVSOXSEG3EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF2_M1)
  .value("PseudoVSOXSEG3EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG3EI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF2_M2)
  .value("PseudoVSOXSEG3EI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF2_M2_MASK)
  .value("PseudoVSOXSEG3EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF2_MF2)
  .value("PseudoVSOXSEG3EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG3EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF2_MF4)
  .value("PseudoVSOXSEG3EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG3EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF4_M1)
  .value("PseudoVSOXSEG3EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG3EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF4_MF2)
  .value("PseudoVSOXSEG3EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG3EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF4_MF4)
  .value("PseudoVSOXSEG3EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG3EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF4_MF8)
  .value("PseudoVSOXSEG3EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI16_V_MF4_MF8_MASK)
  .value("PseudoVSOXSEG3EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M1_M1)
  .value("PseudoVSOXSEG3EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M1_M1_MASK)
  .value("PseudoVSOXSEG3EI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M1_M2)
  .value("PseudoVSOXSEG3EI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M1_M2_MASK)
  .value("PseudoVSOXSEG3EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M1_MF2)
  .value("PseudoVSOXSEG3EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG3EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M1_MF4)
  .value("PseudoVSOXSEG3EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG3EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M2_M1)
  .value("PseudoVSOXSEG3EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M2_M1_MASK)
  .value("PseudoVSOXSEG3EI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M2_M2)
  .value("PseudoVSOXSEG3EI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M2_M2_MASK)
  .value("PseudoVSOXSEG3EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M2_MF2)
  .value("PseudoVSOXSEG3EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG3EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M4_M1)
  .value("PseudoVSOXSEG3EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M4_M1_MASK)
  .value("PseudoVSOXSEG3EI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M4_M2)
  .value("PseudoVSOXSEG3EI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M4_M2_MASK)
  .value("PseudoVSOXSEG3EI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M8_M2)
  .value("PseudoVSOXSEG3EI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_M8_M2_MASK)
  .value("PseudoVSOXSEG3EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_MF2_M1)
  .value("PseudoVSOXSEG3EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG3EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_MF2_MF2)
  .value("PseudoVSOXSEG3EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG3EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_MF2_MF4)
  .value("PseudoVSOXSEG3EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG3EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_MF2_MF8)
  .value("PseudoVSOXSEG3EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI32_V_MF2_MF8_MASK)
  .value("PseudoVSOXSEG3EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M1_M1)
  .value("PseudoVSOXSEG3EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M1_M1_MASK)
  .value("PseudoVSOXSEG3EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M1_MF2)
  .value("PseudoVSOXSEG3EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG3EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M1_MF4)
  .value("PseudoVSOXSEG3EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG3EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M1_MF8)
  .value("PseudoVSOXSEG3EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M1_MF8_MASK)
  .value("PseudoVSOXSEG3EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M2_M1)
  .value("PseudoVSOXSEG3EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M2_M1_MASK)
  .value("PseudoVSOXSEG3EI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M2_M2)
  .value("PseudoVSOXSEG3EI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M2_M2_MASK)
  .value("PseudoVSOXSEG3EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M2_MF2)
  .value("PseudoVSOXSEG3EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG3EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M2_MF4)
  .value("PseudoVSOXSEG3EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M2_MF4_MASK)
  .value("PseudoVSOXSEG3EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M4_M1)
  .value("PseudoVSOXSEG3EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M4_M1_MASK)
  .value("PseudoVSOXSEG3EI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M4_M2)
  .value("PseudoVSOXSEG3EI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M4_M2_MASK)
  .value("PseudoVSOXSEG3EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M4_MF2)
  .value("PseudoVSOXSEG3EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M4_MF2_MASK)
  .value("PseudoVSOXSEG3EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M8_M1)
  .value("PseudoVSOXSEG3EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M8_M1_MASK)
  .value("PseudoVSOXSEG3EI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M8_M2)
  .value("PseudoVSOXSEG3EI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI64_V_M8_M2_MASK)
  .value("PseudoVSOXSEG3EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_M1_M1)
  .value("PseudoVSOXSEG3EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_M1_M1_MASK)
  .value("PseudoVSOXSEG3EI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_M1_M2)
  .value("PseudoVSOXSEG3EI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_M1_M2_MASK)
  .value("PseudoVSOXSEG3EI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_M2_M2)
  .value("PseudoVSOXSEG3EI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_M2_M2_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF2_M1)
  .value("PseudoVSOXSEG3EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF2_M2)
  .value("PseudoVSOXSEG3EI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF2_M2_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF2_MF2)
  .value("PseudoVSOXSEG3EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF4_M1)
  .value("PseudoVSOXSEG3EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF4_M2)
  .value("PseudoVSOXSEG3EI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF4_M2_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF4_MF2)
  .value("PseudoVSOXSEG3EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF4_MF4)
  .value("PseudoVSOXSEG3EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF8_M1)
  .value("PseudoVSOXSEG3EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF8_M1_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF8_MF2)
  .value("PseudoVSOXSEG3EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF8_MF2_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF8_MF4)
  .value("PseudoVSOXSEG3EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF8_MF4_MASK)
  .value("PseudoVSOXSEG3EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF8_MF8)
  .value("PseudoVSOXSEG3EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG3EI8_V_MF8_MF8_MASK)
  .value("PseudoVSOXSEG4EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M1_M1)
  .value("PseudoVSOXSEG4EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M1_M1_MASK)
  .value("PseudoVSOXSEG4EI16_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M1_M2)
  .value("PseudoVSOXSEG4EI16_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M1_M2_MASK)
  .value("PseudoVSOXSEG4EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M1_MF2)
  .value("PseudoVSOXSEG4EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG4EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M2_M1)
  .value("PseudoVSOXSEG4EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M2_M1_MASK)
  .value("PseudoVSOXSEG4EI16_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M2_M2)
  .value("PseudoVSOXSEG4EI16_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M2_M2_MASK)
  .value("PseudoVSOXSEG4EI16_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M4_M2)
  .value("PseudoVSOXSEG4EI16_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_M4_M2_MASK)
  .value("PseudoVSOXSEG4EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF2_M1)
  .value("PseudoVSOXSEG4EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG4EI16_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF2_M2)
  .value("PseudoVSOXSEG4EI16_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF2_M2_MASK)
  .value("PseudoVSOXSEG4EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF2_MF2)
  .value("PseudoVSOXSEG4EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG4EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF2_MF4)
  .value("PseudoVSOXSEG4EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG4EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF4_M1)
  .value("PseudoVSOXSEG4EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG4EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF4_MF2)
  .value("PseudoVSOXSEG4EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG4EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF4_MF4)
  .value("PseudoVSOXSEG4EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG4EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF4_MF8)
  .value("PseudoVSOXSEG4EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI16_V_MF4_MF8_MASK)
  .value("PseudoVSOXSEG4EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M1_M1)
  .value("PseudoVSOXSEG4EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M1_M1_MASK)
  .value("PseudoVSOXSEG4EI32_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M1_M2)
  .value("PseudoVSOXSEG4EI32_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M1_M2_MASK)
  .value("PseudoVSOXSEG4EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M1_MF2)
  .value("PseudoVSOXSEG4EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG4EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M1_MF4)
  .value("PseudoVSOXSEG4EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG4EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M2_M1)
  .value("PseudoVSOXSEG4EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M2_M1_MASK)
  .value("PseudoVSOXSEG4EI32_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M2_M2)
  .value("PseudoVSOXSEG4EI32_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M2_M2_MASK)
  .value("PseudoVSOXSEG4EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M2_MF2)
  .value("PseudoVSOXSEG4EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG4EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M4_M1)
  .value("PseudoVSOXSEG4EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M4_M1_MASK)
  .value("PseudoVSOXSEG4EI32_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M4_M2)
  .value("PseudoVSOXSEG4EI32_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M4_M2_MASK)
  .value("PseudoVSOXSEG4EI32_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M8_M2)
  .value("PseudoVSOXSEG4EI32_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_M8_M2_MASK)
  .value("PseudoVSOXSEG4EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_MF2_M1)
  .value("PseudoVSOXSEG4EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG4EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_MF2_MF2)
  .value("PseudoVSOXSEG4EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG4EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_MF2_MF4)
  .value("PseudoVSOXSEG4EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG4EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_MF2_MF8)
  .value("PseudoVSOXSEG4EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI32_V_MF2_MF8_MASK)
  .value("PseudoVSOXSEG4EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M1_M1)
  .value("PseudoVSOXSEG4EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M1_M1_MASK)
  .value("PseudoVSOXSEG4EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M1_MF2)
  .value("PseudoVSOXSEG4EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG4EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M1_MF4)
  .value("PseudoVSOXSEG4EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG4EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M1_MF8)
  .value("PseudoVSOXSEG4EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M1_MF8_MASK)
  .value("PseudoVSOXSEG4EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M2_M1)
  .value("PseudoVSOXSEG4EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M2_M1_MASK)
  .value("PseudoVSOXSEG4EI64_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M2_M2)
  .value("PseudoVSOXSEG4EI64_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M2_M2_MASK)
  .value("PseudoVSOXSEG4EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M2_MF2)
  .value("PseudoVSOXSEG4EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG4EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M2_MF4)
  .value("PseudoVSOXSEG4EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M2_MF4_MASK)
  .value("PseudoVSOXSEG4EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M4_M1)
  .value("PseudoVSOXSEG4EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M4_M1_MASK)
  .value("PseudoVSOXSEG4EI64_V_M4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M4_M2)
  .value("PseudoVSOXSEG4EI64_V_M4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M4_M2_MASK)
  .value("PseudoVSOXSEG4EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M4_MF2)
  .value("PseudoVSOXSEG4EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M4_MF2_MASK)
  .value("PseudoVSOXSEG4EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M8_M1)
  .value("PseudoVSOXSEG4EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M8_M1_MASK)
  .value("PseudoVSOXSEG4EI64_V_M8_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M8_M2)
  .value("PseudoVSOXSEG4EI64_V_M8_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI64_V_M8_M2_MASK)
  .value("PseudoVSOXSEG4EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_M1_M1)
  .value("PseudoVSOXSEG4EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_M1_M1_MASK)
  .value("PseudoVSOXSEG4EI8_V_M1_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_M1_M2)
  .value("PseudoVSOXSEG4EI8_V_M1_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_M1_M2_MASK)
  .value("PseudoVSOXSEG4EI8_V_M2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_M2_M2)
  .value("PseudoVSOXSEG4EI8_V_M2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_M2_M2_MASK)
  .value("PseudoVSOXSEG4EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF2_M1)
  .value("PseudoVSOXSEG4EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG4EI8_V_MF2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF2_M2)
  .value("PseudoVSOXSEG4EI8_V_MF2_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF2_M2_MASK);
  opcodes.value("PseudoVSOXSEG4EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF2_MF2)
  .value("PseudoVSOXSEG4EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG4EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF4_M1)
  .value("PseudoVSOXSEG4EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG4EI8_V_MF4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF4_M2)
  .value("PseudoVSOXSEG4EI8_V_MF4_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF4_M2_MASK)
  .value("PseudoVSOXSEG4EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF4_MF2)
  .value("PseudoVSOXSEG4EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG4EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF4_MF4)
  .value("PseudoVSOXSEG4EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG4EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF8_M1)
  .value("PseudoVSOXSEG4EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF8_M1_MASK)
  .value("PseudoVSOXSEG4EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF8_MF2)
  .value("PseudoVSOXSEG4EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF8_MF2_MASK)
  .value("PseudoVSOXSEG4EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF8_MF4)
  .value("PseudoVSOXSEG4EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF8_MF4_MASK)
  .value("PseudoVSOXSEG4EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF8_MF8)
  .value("PseudoVSOXSEG4EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG4EI8_V_MF8_MF8_MASK)
  .value("PseudoVSOXSEG5EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_M1_M1)
  .value("PseudoVSOXSEG5EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_M1_M1_MASK)
  .value("PseudoVSOXSEG5EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_M1_MF2)
  .value("PseudoVSOXSEG5EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG5EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_M2_M1)
  .value("PseudoVSOXSEG5EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_M2_M1_MASK)
  .value("PseudoVSOXSEG5EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF2_M1)
  .value("PseudoVSOXSEG5EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG5EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF2_MF2)
  .value("PseudoVSOXSEG5EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG5EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF2_MF4)
  .value("PseudoVSOXSEG5EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG5EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF4_M1)
  .value("PseudoVSOXSEG5EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG5EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF4_MF2)
  .value("PseudoVSOXSEG5EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG5EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF4_MF4)
  .value("PseudoVSOXSEG5EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG5EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF4_MF8)
  .value("PseudoVSOXSEG5EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI16_V_MF4_MF8_MASK)
  .value("PseudoVSOXSEG5EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M1_M1)
  .value("PseudoVSOXSEG5EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M1_M1_MASK)
  .value("PseudoVSOXSEG5EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M1_MF2)
  .value("PseudoVSOXSEG5EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG5EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M1_MF4)
  .value("PseudoVSOXSEG5EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG5EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M2_M1)
  .value("PseudoVSOXSEG5EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M2_M1_MASK)
  .value("PseudoVSOXSEG5EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M2_MF2)
  .value("PseudoVSOXSEG5EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG5EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M4_M1)
  .value("PseudoVSOXSEG5EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_M4_M1_MASK)
  .value("PseudoVSOXSEG5EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_MF2_M1)
  .value("PseudoVSOXSEG5EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG5EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_MF2_MF2)
  .value("PseudoVSOXSEG5EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG5EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_MF2_MF4)
  .value("PseudoVSOXSEG5EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG5EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_MF2_MF8)
  .value("PseudoVSOXSEG5EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI32_V_MF2_MF8_MASK)
  .value("PseudoVSOXSEG5EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M1_M1)
  .value("PseudoVSOXSEG5EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M1_M1_MASK)
  .value("PseudoVSOXSEG5EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M1_MF2)
  .value("PseudoVSOXSEG5EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG5EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M1_MF4)
  .value("PseudoVSOXSEG5EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG5EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M1_MF8)
  .value("PseudoVSOXSEG5EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M1_MF8_MASK)
  .value("PseudoVSOXSEG5EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M2_M1)
  .value("PseudoVSOXSEG5EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M2_M1_MASK)
  .value("PseudoVSOXSEG5EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M2_MF2)
  .value("PseudoVSOXSEG5EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG5EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M2_MF4)
  .value("PseudoVSOXSEG5EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M2_MF4_MASK)
  .value("PseudoVSOXSEG5EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M4_M1)
  .value("PseudoVSOXSEG5EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M4_M1_MASK)
  .value("PseudoVSOXSEG5EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M4_MF2)
  .value("PseudoVSOXSEG5EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M4_MF2_MASK)
  .value("PseudoVSOXSEG5EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M8_M1)
  .value("PseudoVSOXSEG5EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI64_V_M8_M1_MASK)
  .value("PseudoVSOXSEG5EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_M1_M1)
  .value("PseudoVSOXSEG5EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_M1_M1_MASK)
  .value("PseudoVSOXSEG5EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF2_M1)
  .value("PseudoVSOXSEG5EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG5EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF2_MF2)
  .value("PseudoVSOXSEG5EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG5EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF4_M1)
  .value("PseudoVSOXSEG5EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG5EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF4_MF2)
  .value("PseudoVSOXSEG5EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG5EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF4_MF4)
  .value("PseudoVSOXSEG5EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG5EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF8_M1)
  .value("PseudoVSOXSEG5EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF8_M1_MASK)
  .value("PseudoVSOXSEG5EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF8_MF2)
  .value("PseudoVSOXSEG5EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF8_MF2_MASK)
  .value("PseudoVSOXSEG5EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF8_MF4)
  .value("PseudoVSOXSEG5EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF8_MF4_MASK)
  .value("PseudoVSOXSEG5EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF8_MF8)
  .value("PseudoVSOXSEG5EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG5EI8_V_MF8_MF8_MASK)
  .value("PseudoVSOXSEG6EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_M1_M1)
  .value("PseudoVSOXSEG6EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_M1_M1_MASK)
  .value("PseudoVSOXSEG6EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_M1_MF2)
  .value("PseudoVSOXSEG6EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG6EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_M2_M1)
  .value("PseudoVSOXSEG6EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_M2_M1_MASK)
  .value("PseudoVSOXSEG6EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF2_M1)
  .value("PseudoVSOXSEG6EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG6EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF2_MF2)
  .value("PseudoVSOXSEG6EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG6EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF2_MF4)
  .value("PseudoVSOXSEG6EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG6EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF4_M1)
  .value("PseudoVSOXSEG6EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG6EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF4_MF2)
  .value("PseudoVSOXSEG6EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG6EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF4_MF4)
  .value("PseudoVSOXSEG6EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG6EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF4_MF8)
  .value("PseudoVSOXSEG6EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI16_V_MF4_MF8_MASK)
  .value("PseudoVSOXSEG6EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M1_M1)
  .value("PseudoVSOXSEG6EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M1_M1_MASK)
  .value("PseudoVSOXSEG6EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M1_MF2)
  .value("PseudoVSOXSEG6EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG6EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M1_MF4)
  .value("PseudoVSOXSEG6EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG6EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M2_M1)
  .value("PseudoVSOXSEG6EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M2_M1_MASK)
  .value("PseudoVSOXSEG6EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M2_MF2)
  .value("PseudoVSOXSEG6EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG6EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M4_M1)
  .value("PseudoVSOXSEG6EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_M4_M1_MASK)
  .value("PseudoVSOXSEG6EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_MF2_M1)
  .value("PseudoVSOXSEG6EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG6EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_MF2_MF2)
  .value("PseudoVSOXSEG6EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG6EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_MF2_MF4)
  .value("PseudoVSOXSEG6EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG6EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_MF2_MF8)
  .value("PseudoVSOXSEG6EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI32_V_MF2_MF8_MASK)
  .value("PseudoVSOXSEG6EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M1_M1)
  .value("PseudoVSOXSEG6EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M1_M1_MASK)
  .value("PseudoVSOXSEG6EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M1_MF2)
  .value("PseudoVSOXSEG6EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG6EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M1_MF4)
  .value("PseudoVSOXSEG6EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG6EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M1_MF8)
  .value("PseudoVSOXSEG6EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M1_MF8_MASK)
  .value("PseudoVSOXSEG6EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M2_M1)
  .value("PseudoVSOXSEG6EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M2_M1_MASK)
  .value("PseudoVSOXSEG6EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M2_MF2)
  .value("PseudoVSOXSEG6EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG6EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M2_MF4)
  .value("PseudoVSOXSEG6EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M2_MF4_MASK)
  .value("PseudoVSOXSEG6EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M4_M1)
  .value("PseudoVSOXSEG6EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M4_M1_MASK)
  .value("PseudoVSOXSEG6EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M4_MF2)
  .value("PseudoVSOXSEG6EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M4_MF2_MASK)
  .value("PseudoVSOXSEG6EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M8_M1)
  .value("PseudoVSOXSEG6EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI64_V_M8_M1_MASK)
  .value("PseudoVSOXSEG6EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_M1_M1)
  .value("PseudoVSOXSEG6EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_M1_M1_MASK)
  .value("PseudoVSOXSEG6EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF2_M1)
  .value("PseudoVSOXSEG6EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG6EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF2_MF2)
  .value("PseudoVSOXSEG6EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG6EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF4_M1)
  .value("PseudoVSOXSEG6EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG6EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF4_MF2)
  .value("PseudoVSOXSEG6EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG6EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF4_MF4)
  .value("PseudoVSOXSEG6EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG6EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF8_M1)
  .value("PseudoVSOXSEG6EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF8_M1_MASK)
  .value("PseudoVSOXSEG6EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF8_MF2)
  .value("PseudoVSOXSEG6EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF8_MF2_MASK)
  .value("PseudoVSOXSEG6EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF8_MF4)
  .value("PseudoVSOXSEG6EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF8_MF4_MASK)
  .value("PseudoVSOXSEG6EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF8_MF8)
  .value("PseudoVSOXSEG6EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG6EI8_V_MF8_MF8_MASK)
  .value("PseudoVSOXSEG7EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_M1_M1)
  .value("PseudoVSOXSEG7EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_M1_M1_MASK)
  .value("PseudoVSOXSEG7EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_M1_MF2)
  .value("PseudoVSOXSEG7EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG7EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_M2_M1)
  .value("PseudoVSOXSEG7EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_M2_M1_MASK)
  .value("PseudoVSOXSEG7EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF2_M1)
  .value("PseudoVSOXSEG7EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG7EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF2_MF2)
  .value("PseudoVSOXSEG7EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG7EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF2_MF4)
  .value("PseudoVSOXSEG7EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG7EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF4_M1)
  .value("PseudoVSOXSEG7EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG7EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF4_MF2)
  .value("PseudoVSOXSEG7EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG7EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF4_MF4)
  .value("PseudoVSOXSEG7EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG7EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF4_MF8)
  .value("PseudoVSOXSEG7EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI16_V_MF4_MF8_MASK)
  .value("PseudoVSOXSEG7EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M1_M1)
  .value("PseudoVSOXSEG7EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M1_M1_MASK)
  .value("PseudoVSOXSEG7EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M1_MF2)
  .value("PseudoVSOXSEG7EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG7EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M1_MF4)
  .value("PseudoVSOXSEG7EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG7EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M2_M1)
  .value("PseudoVSOXSEG7EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M2_M1_MASK)
  .value("PseudoVSOXSEG7EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M2_MF2)
  .value("PseudoVSOXSEG7EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG7EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M4_M1)
  .value("PseudoVSOXSEG7EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_M4_M1_MASK)
  .value("PseudoVSOXSEG7EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_MF2_M1)
  .value("PseudoVSOXSEG7EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG7EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_MF2_MF2)
  .value("PseudoVSOXSEG7EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG7EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_MF2_MF4)
  .value("PseudoVSOXSEG7EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG7EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_MF2_MF8)
  .value("PseudoVSOXSEG7EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI32_V_MF2_MF8_MASK)
  .value("PseudoVSOXSEG7EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M1_M1)
  .value("PseudoVSOXSEG7EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M1_M1_MASK)
  .value("PseudoVSOXSEG7EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M1_MF2)
  .value("PseudoVSOXSEG7EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG7EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M1_MF4)
  .value("PseudoVSOXSEG7EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG7EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M1_MF8)
  .value("PseudoVSOXSEG7EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M1_MF8_MASK)
  .value("PseudoVSOXSEG7EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M2_M1)
  .value("PseudoVSOXSEG7EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M2_M1_MASK)
  .value("PseudoVSOXSEG7EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M2_MF2)
  .value("PseudoVSOXSEG7EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG7EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M2_MF4)
  .value("PseudoVSOXSEG7EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M2_MF4_MASK)
  .value("PseudoVSOXSEG7EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M4_M1)
  .value("PseudoVSOXSEG7EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M4_M1_MASK)
  .value("PseudoVSOXSEG7EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M4_MF2)
  .value("PseudoVSOXSEG7EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M4_MF2_MASK)
  .value("PseudoVSOXSEG7EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M8_M1)
  .value("PseudoVSOXSEG7EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI64_V_M8_M1_MASK)
  .value("PseudoVSOXSEG7EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_M1_M1)
  .value("PseudoVSOXSEG7EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_M1_M1_MASK)
  .value("PseudoVSOXSEG7EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF2_M1)
  .value("PseudoVSOXSEG7EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG7EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF2_MF2)
  .value("PseudoVSOXSEG7EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG7EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF4_M1)
  .value("PseudoVSOXSEG7EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG7EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF4_MF2)
  .value("PseudoVSOXSEG7EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG7EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF4_MF4)
  .value("PseudoVSOXSEG7EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG7EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF8_M1)
  .value("PseudoVSOXSEG7EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF8_M1_MASK)
  .value("PseudoVSOXSEG7EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF8_MF2)
  .value("PseudoVSOXSEG7EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF8_MF2_MASK)
  .value("PseudoVSOXSEG7EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF8_MF4)
  .value("PseudoVSOXSEG7EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF8_MF4_MASK)
  .value("PseudoVSOXSEG7EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF8_MF8)
  .value("PseudoVSOXSEG7EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG7EI8_V_MF8_MF8_MASK)
  .value("PseudoVSOXSEG8EI16_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_M1_M1)
  .value("PseudoVSOXSEG8EI16_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_M1_M1_MASK)
  .value("PseudoVSOXSEG8EI16_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_M1_MF2)
  .value("PseudoVSOXSEG8EI16_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG8EI16_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_M2_M1)
  .value("PseudoVSOXSEG8EI16_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_M2_M1_MASK)
  .value("PseudoVSOXSEG8EI16_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF2_M1)
  .value("PseudoVSOXSEG8EI16_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG8EI16_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF2_MF2)
  .value("PseudoVSOXSEG8EI16_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG8EI16_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF2_MF4)
  .value("PseudoVSOXSEG8EI16_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG8EI16_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF4_M1)
  .value("PseudoVSOXSEG8EI16_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG8EI16_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF4_MF2)
  .value("PseudoVSOXSEG8EI16_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG8EI16_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF4_MF4)
  .value("PseudoVSOXSEG8EI16_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG8EI16_V_MF4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF4_MF8)
  .value("PseudoVSOXSEG8EI16_V_MF4_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI16_V_MF4_MF8_MASK)
  .value("PseudoVSOXSEG8EI32_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M1_M1)
  .value("PseudoVSOXSEG8EI32_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M1_M1_MASK)
  .value("PseudoVSOXSEG8EI32_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M1_MF2)
  .value("PseudoVSOXSEG8EI32_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG8EI32_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M1_MF4)
  .value("PseudoVSOXSEG8EI32_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG8EI32_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M2_M1)
  .value("PseudoVSOXSEG8EI32_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M2_M1_MASK)
  .value("PseudoVSOXSEG8EI32_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M2_MF2)
  .value("PseudoVSOXSEG8EI32_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG8EI32_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M4_M1)
  .value("PseudoVSOXSEG8EI32_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_M4_M1_MASK)
  .value("PseudoVSOXSEG8EI32_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_MF2_M1)
  .value("PseudoVSOXSEG8EI32_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG8EI32_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_MF2_MF2)
  .value("PseudoVSOXSEG8EI32_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG8EI32_V_MF2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_MF2_MF4)
  .value("PseudoVSOXSEG8EI32_V_MF2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_MF2_MF4_MASK)
  .value("PseudoVSOXSEG8EI32_V_MF2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_MF2_MF8)
  .value("PseudoVSOXSEG8EI32_V_MF2_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI32_V_MF2_MF8_MASK)
  .value("PseudoVSOXSEG8EI64_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M1_M1)
  .value("PseudoVSOXSEG8EI64_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M1_M1_MASK);
  opcodes.value("PseudoVSOXSEG8EI64_V_M1_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M1_MF2)
  .value("PseudoVSOXSEG8EI64_V_M1_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M1_MF2_MASK)
  .value("PseudoVSOXSEG8EI64_V_M1_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M1_MF4)
  .value("PseudoVSOXSEG8EI64_V_M1_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M1_MF4_MASK)
  .value("PseudoVSOXSEG8EI64_V_M1_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M1_MF8)
  .value("PseudoVSOXSEG8EI64_V_M1_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M1_MF8_MASK)
  .value("PseudoVSOXSEG8EI64_V_M2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M2_M1)
  .value("PseudoVSOXSEG8EI64_V_M2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M2_M1_MASK)
  .value("PseudoVSOXSEG8EI64_V_M2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M2_MF2)
  .value("PseudoVSOXSEG8EI64_V_M2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M2_MF2_MASK)
  .value("PseudoVSOXSEG8EI64_V_M2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M2_MF4)
  .value("PseudoVSOXSEG8EI64_V_M2_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M2_MF4_MASK)
  .value("PseudoVSOXSEG8EI64_V_M4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M4_M1)
  .value("PseudoVSOXSEG8EI64_V_M4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M4_M1_MASK)
  .value("PseudoVSOXSEG8EI64_V_M4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M4_MF2)
  .value("PseudoVSOXSEG8EI64_V_M4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M4_MF2_MASK)
  .value("PseudoVSOXSEG8EI64_V_M8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M8_M1)
  .value("PseudoVSOXSEG8EI64_V_M8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI64_V_M8_M1_MASK)
  .value("PseudoVSOXSEG8EI8_V_M1_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_M1_M1)
  .value("PseudoVSOXSEG8EI8_V_M1_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_M1_M1_MASK)
  .value("PseudoVSOXSEG8EI8_V_MF2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF2_M1)
  .value("PseudoVSOXSEG8EI8_V_MF2_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF2_M1_MASK)
  .value("PseudoVSOXSEG8EI8_V_MF2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF2_MF2)
  .value("PseudoVSOXSEG8EI8_V_MF2_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF2_MF2_MASK)
  .value("PseudoVSOXSEG8EI8_V_MF4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF4_M1)
  .value("PseudoVSOXSEG8EI8_V_MF4_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF4_M1_MASK)
  .value("PseudoVSOXSEG8EI8_V_MF4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF4_MF2)
  .value("PseudoVSOXSEG8EI8_V_MF4_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF4_MF2_MASK)
  .value("PseudoVSOXSEG8EI8_V_MF4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF4_MF4)
  .value("PseudoVSOXSEG8EI8_V_MF4_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF4_MF4_MASK)
  .value("PseudoVSOXSEG8EI8_V_MF8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF8_M1)
  .value("PseudoVSOXSEG8EI8_V_MF8_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF8_M1_MASK)
  .value("PseudoVSOXSEG8EI8_V_MF8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF8_MF2)
  .value("PseudoVSOXSEG8EI8_V_MF8_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF8_MF2_MASK)
  .value("PseudoVSOXSEG8EI8_V_MF8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF8_MF4)
  .value("PseudoVSOXSEG8EI8_V_MF8_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF8_MF4_MASK)
  .value("PseudoVSOXSEG8EI8_V_MF8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF8_MF8)
  .value("PseudoVSOXSEG8EI8_V_MF8_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSOXSEG8EI8_V_MF8_MF8_MASK)
  .value("PseudoVSPILL2_M1", LIEF::assembly::riscv::OPCODE::PseudoVSPILL2_M1)
  .value("PseudoVSPILL2_M2", LIEF::assembly::riscv::OPCODE::PseudoVSPILL2_M2)
  .value("PseudoVSPILL2_M4", LIEF::assembly::riscv::OPCODE::PseudoVSPILL2_M4)
  .value("PseudoVSPILL2_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSPILL2_MF2)
  .value("PseudoVSPILL2_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSPILL2_MF4)
  .value("PseudoVSPILL2_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSPILL2_MF8)
  .value("PseudoVSPILL3_M1", LIEF::assembly::riscv::OPCODE::PseudoVSPILL3_M1)
  .value("PseudoVSPILL3_M2", LIEF::assembly::riscv::OPCODE::PseudoVSPILL3_M2)
  .value("PseudoVSPILL3_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSPILL3_MF2)
  .value("PseudoVSPILL3_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSPILL3_MF4)
  .value("PseudoVSPILL3_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSPILL3_MF8)
  .value("PseudoVSPILL4_M1", LIEF::assembly::riscv::OPCODE::PseudoVSPILL4_M1)
  .value("PseudoVSPILL4_M2", LIEF::assembly::riscv::OPCODE::PseudoVSPILL4_M2)
  .value("PseudoVSPILL4_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSPILL4_MF2)
  .value("PseudoVSPILL4_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSPILL4_MF4)
  .value("PseudoVSPILL4_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSPILL4_MF8)
  .value("PseudoVSPILL5_M1", LIEF::assembly::riscv::OPCODE::PseudoVSPILL5_M1)
  .value("PseudoVSPILL5_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSPILL5_MF2)
  .value("PseudoVSPILL5_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSPILL5_MF4)
  .value("PseudoVSPILL5_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSPILL5_MF8)
  .value("PseudoVSPILL6_M1", LIEF::assembly::riscv::OPCODE::PseudoVSPILL6_M1)
  .value("PseudoVSPILL6_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSPILL6_MF2)
  .value("PseudoVSPILL6_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSPILL6_MF4)
  .value("PseudoVSPILL6_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSPILL6_MF8)
  .value("PseudoVSPILL7_M1", LIEF::assembly::riscv::OPCODE::PseudoVSPILL7_M1)
  .value("PseudoVSPILL7_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSPILL7_MF2)
  .value("PseudoVSPILL7_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSPILL7_MF4)
  .value("PseudoVSPILL7_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSPILL7_MF8)
  .value("PseudoVSPILL8_M1", LIEF::assembly::riscv::OPCODE::PseudoVSPILL8_M1)
  .value("PseudoVSPILL8_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSPILL8_MF2)
  .value("PseudoVSPILL8_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSPILL8_MF4)
  .value("PseudoVSPILL8_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSPILL8_MF8)
  .value("PseudoVSRA_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_M1)
  .value("PseudoVSRA_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_M1_MASK)
  .value("PseudoVSRA_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_M2)
  .value("PseudoVSRA_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_M2_MASK)
  .value("PseudoVSRA_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_M4)
  .value("PseudoVSRA_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_M4_MASK)
  .value("PseudoVSRA_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_M8)
  .value("PseudoVSRA_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_M8_MASK)
  .value("PseudoVSRA_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_MF2)
  .value("PseudoVSRA_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_MF2_MASK)
  .value("PseudoVSRA_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_MF4)
  .value("PseudoVSRA_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_MF4_MASK)
  .value("PseudoVSRA_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_MF8)
  .value("PseudoVSRA_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VI_MF8_MASK)
  .value("PseudoVSRA_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_M1)
  .value("PseudoVSRA_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_M1_MASK)
  .value("PseudoVSRA_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_M2)
  .value("PseudoVSRA_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_M2_MASK)
  .value("PseudoVSRA_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_M4)
  .value("PseudoVSRA_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_M4_MASK)
  .value("PseudoVSRA_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_M8)
  .value("PseudoVSRA_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_M8_MASK)
  .value("PseudoVSRA_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_MF2)
  .value("PseudoVSRA_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_MF2_MASK)
  .value("PseudoVSRA_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_MF4)
  .value("PseudoVSRA_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_MF4_MASK)
  .value("PseudoVSRA_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_MF8)
  .value("PseudoVSRA_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VV_MF8_MASK)
  .value("PseudoVSRA_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_M1)
  .value("PseudoVSRA_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_M1_MASK)
  .value("PseudoVSRA_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_M2)
  .value("PseudoVSRA_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_M2_MASK)
  .value("PseudoVSRA_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_M4)
  .value("PseudoVSRA_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_M4_MASK)
  .value("PseudoVSRA_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_M8)
  .value("PseudoVSRA_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_M8_MASK)
  .value("PseudoVSRA_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_MF2)
  .value("PseudoVSRA_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_MF2_MASK)
  .value("PseudoVSRA_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_MF4)
  .value("PseudoVSRA_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_MF4_MASK)
  .value("PseudoVSRA_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_MF8)
  .value("PseudoVSRA_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRA_VX_MF8_MASK)
  .value("PseudoVSRL_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_M1)
  .value("PseudoVSRL_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_M1_MASK)
  .value("PseudoVSRL_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_M2)
  .value("PseudoVSRL_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_M2_MASK)
  .value("PseudoVSRL_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_M4)
  .value("PseudoVSRL_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_M4_MASK)
  .value("PseudoVSRL_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_M8)
  .value("PseudoVSRL_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_M8_MASK)
  .value("PseudoVSRL_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_MF2)
  .value("PseudoVSRL_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_MF2_MASK)
  .value("PseudoVSRL_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_MF4)
  .value("PseudoVSRL_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_MF4_MASK)
  .value("PseudoVSRL_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_MF8)
  .value("PseudoVSRL_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VI_MF8_MASK)
  .value("PseudoVSRL_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_M1)
  .value("PseudoVSRL_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_M1_MASK)
  .value("PseudoVSRL_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_M2)
  .value("PseudoVSRL_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_M2_MASK)
  .value("PseudoVSRL_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_M4)
  .value("PseudoVSRL_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_M4_MASK)
  .value("PseudoVSRL_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_M8)
  .value("PseudoVSRL_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_M8_MASK)
  .value("PseudoVSRL_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_MF2)
  .value("PseudoVSRL_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_MF2_MASK)
  .value("PseudoVSRL_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_MF4)
  .value("PseudoVSRL_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_MF4_MASK)
  .value("PseudoVSRL_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_MF8)
  .value("PseudoVSRL_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VV_MF8_MASK)
  .value("PseudoVSRL_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_M1)
  .value("PseudoVSRL_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_M1_MASK)
  .value("PseudoVSRL_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_M2)
  .value("PseudoVSRL_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_M2_MASK)
  .value("PseudoVSRL_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_M4)
  .value("PseudoVSRL_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_M4_MASK)
  .value("PseudoVSRL_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_M8)
  .value("PseudoVSRL_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_M8_MASK)
  .value("PseudoVSRL_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_MF2)
  .value("PseudoVSRL_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_MF2_MASK)
  .value("PseudoVSRL_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_MF4)
  .value("PseudoVSRL_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_MF4_MASK)
  .value("PseudoVSRL_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_MF8)
  .value("PseudoVSRL_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSRL_VX_MF8_MASK)
  .value("PseudoVSSE16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_M1)
  .value("PseudoVSSE16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_M1_MASK)
  .value("PseudoVSSE16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_M2)
  .value("PseudoVSSE16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_M2_MASK)
  .value("PseudoVSSE16_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_M4)
  .value("PseudoVSSE16_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_M4_MASK)
  .value("PseudoVSSE16_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_M8)
  .value("PseudoVSSE16_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_M8_MASK)
  .value("PseudoVSSE16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_MF2)
  .value("PseudoVSSE16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_MF2_MASK)
  .value("PseudoVSSE16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_MF4)
  .value("PseudoVSSE16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE16_V_MF4_MASK)
  .value("PseudoVSSE32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSE32_V_M1)
  .value("PseudoVSSE32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE32_V_M1_MASK)
  .value("PseudoVSSE32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSE32_V_M2)
  .value("PseudoVSSE32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE32_V_M2_MASK)
  .value("PseudoVSSE32_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSE32_V_M4)
  .value("PseudoVSSE32_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE32_V_M4_MASK)
  .value("PseudoVSSE32_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSE32_V_M8)
  .value("PseudoVSSE32_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE32_V_M8_MASK)
  .value("PseudoVSSE32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSE32_V_MF2)
  .value("PseudoVSSE32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE32_V_MF2_MASK)
  .value("PseudoVSSE64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSE64_V_M1)
  .value("PseudoVSSE64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE64_V_M1_MASK)
  .value("PseudoVSSE64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSE64_V_M2)
  .value("PseudoVSSE64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE64_V_M2_MASK)
  .value("PseudoVSSE64_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSE64_V_M4)
  .value("PseudoVSSE64_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE64_V_M4_MASK)
  .value("PseudoVSSE64_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSE64_V_M8)
  .value("PseudoVSSE64_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE64_V_M8_MASK)
  .value("PseudoVSSE8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_M1)
  .value("PseudoVSSE8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_M1_MASK)
  .value("PseudoVSSE8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_M2)
  .value("PseudoVSSE8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_M2_MASK)
  .value("PseudoVSSE8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_M4)
  .value("PseudoVSSE8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_M4_MASK)
  .value("PseudoVSSE8_V_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_M8)
  .value("PseudoVSSE8_V_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_M8_MASK)
  .value("PseudoVSSE8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_MF2)
  .value("PseudoVSSE8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_MF2_MASK)
  .value("PseudoVSSE8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_MF4)
  .value("PseudoVSSE8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_MF4_MASK)
  .value("PseudoVSSE8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_MF8)
  .value("PseudoVSSE8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSE8_V_MF8_MASK)
  .value("PseudoVSSEG2E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E16_V_M1)
  .value("PseudoVSSEG2E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E16_V_M1_MASK)
  .value("PseudoVSSEG2E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E16_V_M2)
  .value("PseudoVSSEG2E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E16_V_M2_MASK)
  .value("PseudoVSSEG2E16_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E16_V_M4)
  .value("PseudoVSSEG2E16_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E16_V_M4_MASK)
  .value("PseudoVSSEG2E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E16_V_MF2)
  .value("PseudoVSSEG2E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E16_V_MF2_MASK)
  .value("PseudoVSSEG2E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E16_V_MF4)
  .value("PseudoVSSEG2E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E16_V_MF4_MASK)
  .value("PseudoVSSEG2E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E32_V_M1)
  .value("PseudoVSSEG2E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E32_V_M1_MASK)
  .value("PseudoVSSEG2E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E32_V_M2)
  .value("PseudoVSSEG2E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E32_V_M2_MASK)
  .value("PseudoVSSEG2E32_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E32_V_M4)
  .value("PseudoVSSEG2E32_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E32_V_M4_MASK)
  .value("PseudoVSSEG2E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E32_V_MF2)
  .value("PseudoVSSEG2E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E32_V_MF2_MASK)
  .value("PseudoVSSEG2E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E64_V_M1)
  .value("PseudoVSSEG2E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E64_V_M1_MASK)
  .value("PseudoVSSEG2E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E64_V_M2)
  .value("PseudoVSSEG2E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E64_V_M2_MASK)
  .value("PseudoVSSEG2E64_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E64_V_M4)
  .value("PseudoVSSEG2E64_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E64_V_M4_MASK)
  .value("PseudoVSSEG2E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_M1)
  .value("PseudoVSSEG2E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_M1_MASK)
  .value("PseudoVSSEG2E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_M2)
  .value("PseudoVSSEG2E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_M2_MASK)
  .value("PseudoVSSEG2E8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_M4)
  .value("PseudoVSSEG2E8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_M4_MASK)
  .value("PseudoVSSEG2E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_MF2)
  .value("PseudoVSSEG2E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_MF2_MASK)
  .value("PseudoVSSEG2E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_MF4)
  .value("PseudoVSSEG2E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_MF4_MASK)
  .value("PseudoVSSEG2E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_MF8)
  .value("PseudoVSSEG2E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG2E8_V_MF8_MASK)
  .value("PseudoVSSEG3E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E16_V_M1)
  .value("PseudoVSSEG3E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E16_V_M1_MASK)
  .value("PseudoVSSEG3E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E16_V_M2)
  .value("PseudoVSSEG3E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E16_V_M2_MASK)
  .value("PseudoVSSEG3E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E16_V_MF2)
  .value("PseudoVSSEG3E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E16_V_MF2_MASK)
  .value("PseudoVSSEG3E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E16_V_MF4)
  .value("PseudoVSSEG3E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E16_V_MF4_MASK)
  .value("PseudoVSSEG3E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E32_V_M1)
  .value("PseudoVSSEG3E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E32_V_M1_MASK)
  .value("PseudoVSSEG3E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E32_V_M2)
  .value("PseudoVSSEG3E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E32_V_M2_MASK)
  .value("PseudoVSSEG3E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E32_V_MF2)
  .value("PseudoVSSEG3E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E32_V_MF2_MASK)
  .value("PseudoVSSEG3E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E64_V_M1)
  .value("PseudoVSSEG3E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E64_V_M1_MASK)
  .value("PseudoVSSEG3E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E64_V_M2)
  .value("PseudoVSSEG3E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E64_V_M2_MASK)
  .value("PseudoVSSEG3E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E8_V_M1)
  .value("PseudoVSSEG3E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E8_V_M1_MASK)
  .value("PseudoVSSEG3E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E8_V_M2)
  .value("PseudoVSSEG3E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E8_V_M2_MASK)
  .value("PseudoVSSEG3E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E8_V_MF2)
  .value("PseudoVSSEG3E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E8_V_MF2_MASK)
  .value("PseudoVSSEG3E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E8_V_MF4)
  .value("PseudoVSSEG3E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E8_V_MF4_MASK)
  .value("PseudoVSSEG3E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E8_V_MF8)
  .value("PseudoVSSEG3E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG3E8_V_MF8_MASK)
  .value("PseudoVSSEG4E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E16_V_M1)
  .value("PseudoVSSEG4E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E16_V_M1_MASK)
  .value("PseudoVSSEG4E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E16_V_M2)
  .value("PseudoVSSEG4E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E16_V_M2_MASK)
  .value("PseudoVSSEG4E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E16_V_MF2)
  .value("PseudoVSSEG4E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E16_V_MF2_MASK)
  .value("PseudoVSSEG4E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E16_V_MF4)
  .value("PseudoVSSEG4E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E16_V_MF4_MASK)
  .value("PseudoVSSEG4E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E32_V_M1)
  .value("PseudoVSSEG4E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E32_V_M1_MASK)
  .value("PseudoVSSEG4E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E32_V_M2)
  .value("PseudoVSSEG4E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E32_V_M2_MASK)
  .value("PseudoVSSEG4E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E32_V_MF2)
  .value("PseudoVSSEG4E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E32_V_MF2_MASK)
  .value("PseudoVSSEG4E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E64_V_M1)
  .value("PseudoVSSEG4E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E64_V_M1_MASK)
  .value("PseudoVSSEG4E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E64_V_M2)
  .value("PseudoVSSEG4E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E64_V_M2_MASK)
  .value("PseudoVSSEG4E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E8_V_M1)
  .value("PseudoVSSEG4E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E8_V_M1_MASK)
  .value("PseudoVSSEG4E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E8_V_M2)
  .value("PseudoVSSEG4E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E8_V_M2_MASK)
  .value("PseudoVSSEG4E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E8_V_MF2)
  .value("PseudoVSSEG4E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E8_V_MF2_MASK)
  .value("PseudoVSSEG4E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E8_V_MF4)
  .value("PseudoVSSEG4E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E8_V_MF4_MASK)
  .value("PseudoVSSEG4E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E8_V_MF8)
  .value("PseudoVSSEG4E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG4E8_V_MF8_MASK)
  .value("PseudoVSSEG5E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E16_V_M1)
  .value("PseudoVSSEG5E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E16_V_M1_MASK)
  .value("PseudoVSSEG5E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E16_V_MF2)
  .value("PseudoVSSEG5E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E16_V_MF2_MASK)
  .value("PseudoVSSEG5E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E16_V_MF4)
  .value("PseudoVSSEG5E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E16_V_MF4_MASK)
  .value("PseudoVSSEG5E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E32_V_M1)
  .value("PseudoVSSEG5E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E32_V_M1_MASK)
  .value("PseudoVSSEG5E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E32_V_MF2)
  .value("PseudoVSSEG5E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E32_V_MF2_MASK);
  opcodes.value("PseudoVSSEG5E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E64_V_M1)
  .value("PseudoVSSEG5E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E64_V_M1_MASK)
  .value("PseudoVSSEG5E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E8_V_M1)
  .value("PseudoVSSEG5E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E8_V_M1_MASK)
  .value("PseudoVSSEG5E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E8_V_MF2)
  .value("PseudoVSSEG5E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E8_V_MF2_MASK)
  .value("PseudoVSSEG5E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E8_V_MF4)
  .value("PseudoVSSEG5E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E8_V_MF4_MASK)
  .value("PseudoVSSEG5E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E8_V_MF8)
  .value("PseudoVSSEG5E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG5E8_V_MF8_MASK)
  .value("PseudoVSSEG6E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E16_V_M1)
  .value("PseudoVSSEG6E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E16_V_M1_MASK)
  .value("PseudoVSSEG6E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E16_V_MF2)
  .value("PseudoVSSEG6E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E16_V_MF2_MASK)
  .value("PseudoVSSEG6E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E16_V_MF4)
  .value("PseudoVSSEG6E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E16_V_MF4_MASK)
  .value("PseudoVSSEG6E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E32_V_M1)
  .value("PseudoVSSEG6E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E32_V_M1_MASK)
  .value("PseudoVSSEG6E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E32_V_MF2)
  .value("PseudoVSSEG6E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E32_V_MF2_MASK)
  .value("PseudoVSSEG6E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E64_V_M1)
  .value("PseudoVSSEG6E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E64_V_M1_MASK)
  .value("PseudoVSSEG6E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E8_V_M1)
  .value("PseudoVSSEG6E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E8_V_M1_MASK)
  .value("PseudoVSSEG6E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E8_V_MF2)
  .value("PseudoVSSEG6E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E8_V_MF2_MASK)
  .value("PseudoVSSEG6E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E8_V_MF4)
  .value("PseudoVSSEG6E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E8_V_MF4_MASK)
  .value("PseudoVSSEG6E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E8_V_MF8)
  .value("PseudoVSSEG6E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG6E8_V_MF8_MASK)
  .value("PseudoVSSEG7E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E16_V_M1)
  .value("PseudoVSSEG7E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E16_V_M1_MASK)
  .value("PseudoVSSEG7E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E16_V_MF2)
  .value("PseudoVSSEG7E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E16_V_MF2_MASK)
  .value("PseudoVSSEG7E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E16_V_MF4)
  .value("PseudoVSSEG7E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E16_V_MF4_MASK)
  .value("PseudoVSSEG7E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E32_V_M1)
  .value("PseudoVSSEG7E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E32_V_M1_MASK)
  .value("PseudoVSSEG7E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E32_V_MF2)
  .value("PseudoVSSEG7E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E32_V_MF2_MASK)
  .value("PseudoVSSEG7E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E64_V_M1)
  .value("PseudoVSSEG7E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E64_V_M1_MASK)
  .value("PseudoVSSEG7E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E8_V_M1)
  .value("PseudoVSSEG7E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E8_V_M1_MASK)
  .value("PseudoVSSEG7E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E8_V_MF2)
  .value("PseudoVSSEG7E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E8_V_MF2_MASK)
  .value("PseudoVSSEG7E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E8_V_MF4)
  .value("PseudoVSSEG7E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E8_V_MF4_MASK)
  .value("PseudoVSSEG7E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E8_V_MF8)
  .value("PseudoVSSEG7E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG7E8_V_MF8_MASK)
  .value("PseudoVSSEG8E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E16_V_M1)
  .value("PseudoVSSEG8E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E16_V_M1_MASK)
  .value("PseudoVSSEG8E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E16_V_MF2)
  .value("PseudoVSSEG8E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E16_V_MF2_MASK)
  .value("PseudoVSSEG8E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E16_V_MF4)
  .value("PseudoVSSEG8E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E16_V_MF4_MASK)
  .value("PseudoVSSEG8E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E32_V_M1)
  .value("PseudoVSSEG8E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E32_V_M1_MASK)
  .value("PseudoVSSEG8E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E32_V_MF2)
  .value("PseudoVSSEG8E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E32_V_MF2_MASK)
  .value("PseudoVSSEG8E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E64_V_M1)
  .value("PseudoVSSEG8E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E64_V_M1_MASK)
  .value("PseudoVSSEG8E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E8_V_M1)
  .value("PseudoVSSEG8E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E8_V_M1_MASK)
  .value("PseudoVSSEG8E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E8_V_MF2)
  .value("PseudoVSSEG8E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E8_V_MF2_MASK)
  .value("PseudoVSSEG8E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E8_V_MF4)
  .value("PseudoVSSEG8E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E8_V_MF4_MASK)
  .value("PseudoVSSEG8E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E8_V_MF8)
  .value("PseudoVSSEG8E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSEG8E8_V_MF8_MASK)
  .value("PseudoVSSRA_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_M1)
  .value("PseudoVSSRA_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_M1_MASK)
  .value("PseudoVSSRA_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_M2)
  .value("PseudoVSSRA_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_M2_MASK)
  .value("PseudoVSSRA_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_M4)
  .value("PseudoVSSRA_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_M4_MASK)
  .value("PseudoVSSRA_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_M8)
  .value("PseudoVSSRA_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_M8_MASK)
  .value("PseudoVSSRA_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_MF2)
  .value("PseudoVSSRA_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_MF2_MASK)
  .value("PseudoVSSRA_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_MF4)
  .value("PseudoVSSRA_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_MF4_MASK)
  .value("PseudoVSSRA_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_MF8)
  .value("PseudoVSSRA_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VI_MF8_MASK)
  .value("PseudoVSSRA_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_M1)
  .value("PseudoVSSRA_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_M1_MASK)
  .value("PseudoVSSRA_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_M2)
  .value("PseudoVSSRA_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_M2_MASK)
  .value("PseudoVSSRA_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_M4)
  .value("PseudoVSSRA_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_M4_MASK)
  .value("PseudoVSSRA_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_M8)
  .value("PseudoVSSRA_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_M8_MASK)
  .value("PseudoVSSRA_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_MF2)
  .value("PseudoVSSRA_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_MF2_MASK)
  .value("PseudoVSSRA_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_MF4)
  .value("PseudoVSSRA_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_MF4_MASK)
  .value("PseudoVSSRA_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_MF8)
  .value("PseudoVSSRA_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VV_MF8_MASK)
  .value("PseudoVSSRA_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_M1)
  .value("PseudoVSSRA_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_M1_MASK)
  .value("PseudoVSSRA_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_M2)
  .value("PseudoVSSRA_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_M2_MASK)
  .value("PseudoVSSRA_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_M4)
  .value("PseudoVSSRA_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_M4_MASK)
  .value("PseudoVSSRA_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_M8)
  .value("PseudoVSSRA_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_M8_MASK)
  .value("PseudoVSSRA_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_MF2)
  .value("PseudoVSSRA_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_MF2_MASK)
  .value("PseudoVSSRA_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_MF4)
  .value("PseudoVSSRA_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_MF4_MASK)
  .value("PseudoVSSRA_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_MF8)
  .value("PseudoVSSRA_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRA_VX_MF8_MASK)
  .value("PseudoVSSRL_VI_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_M1)
  .value("PseudoVSSRL_VI_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_M1_MASK)
  .value("PseudoVSSRL_VI_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_M2)
  .value("PseudoVSSRL_VI_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_M2_MASK)
  .value("PseudoVSSRL_VI_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_M4)
  .value("PseudoVSSRL_VI_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_M4_MASK)
  .value("PseudoVSSRL_VI_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_M8)
  .value("PseudoVSSRL_VI_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_M8_MASK)
  .value("PseudoVSSRL_VI_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_MF2)
  .value("PseudoVSSRL_VI_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_MF2_MASK)
  .value("PseudoVSSRL_VI_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_MF4)
  .value("PseudoVSSRL_VI_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_MF4_MASK)
  .value("PseudoVSSRL_VI_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_MF8)
  .value("PseudoVSSRL_VI_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VI_MF8_MASK)
  .value("PseudoVSSRL_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_M1)
  .value("PseudoVSSRL_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_M1_MASK)
  .value("PseudoVSSRL_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_M2)
  .value("PseudoVSSRL_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_M2_MASK)
  .value("PseudoVSSRL_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_M4)
  .value("PseudoVSSRL_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_M4_MASK)
  .value("PseudoVSSRL_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_M8)
  .value("PseudoVSSRL_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_M8_MASK)
  .value("PseudoVSSRL_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_MF2)
  .value("PseudoVSSRL_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_MF2_MASK)
  .value("PseudoVSSRL_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_MF4)
  .value("PseudoVSSRL_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_MF4_MASK)
  .value("PseudoVSSRL_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_MF8)
  .value("PseudoVSSRL_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VV_MF8_MASK)
  .value("PseudoVSSRL_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_M1)
  .value("PseudoVSSRL_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_M1_MASK)
  .value("PseudoVSSRL_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_M2)
  .value("PseudoVSSRL_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_M2_MASK)
  .value("PseudoVSSRL_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_M4)
  .value("PseudoVSSRL_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_M4_MASK)
  .value("PseudoVSSRL_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_M8)
  .value("PseudoVSSRL_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_M8_MASK)
  .value("PseudoVSSRL_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_MF2)
  .value("PseudoVSSRL_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_MF2_MASK)
  .value("PseudoVSSRL_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_MF4)
  .value("PseudoVSSRL_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_MF4_MASK)
  .value("PseudoVSSRL_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_MF8)
  .value("PseudoVSSRL_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSRL_VX_MF8_MASK)
  .value("PseudoVSSSEG2E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E16_V_M1)
  .value("PseudoVSSSEG2E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E16_V_M1_MASK)
  .value("PseudoVSSSEG2E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E16_V_M2)
  .value("PseudoVSSSEG2E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E16_V_M2_MASK)
  .value("PseudoVSSSEG2E16_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E16_V_M4)
  .value("PseudoVSSSEG2E16_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E16_V_M4_MASK)
  .value("PseudoVSSSEG2E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E16_V_MF2)
  .value("PseudoVSSSEG2E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E16_V_MF2_MASK)
  .value("PseudoVSSSEG2E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E16_V_MF4)
  .value("PseudoVSSSEG2E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E16_V_MF4_MASK)
  .value("PseudoVSSSEG2E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E32_V_M1)
  .value("PseudoVSSSEG2E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E32_V_M1_MASK)
  .value("PseudoVSSSEG2E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E32_V_M2)
  .value("PseudoVSSSEG2E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E32_V_M2_MASK)
  .value("PseudoVSSSEG2E32_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E32_V_M4)
  .value("PseudoVSSSEG2E32_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E32_V_M4_MASK)
  .value("PseudoVSSSEG2E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E32_V_MF2)
  .value("PseudoVSSSEG2E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E32_V_MF2_MASK)
  .value("PseudoVSSSEG2E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E64_V_M1)
  .value("PseudoVSSSEG2E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E64_V_M1_MASK)
  .value("PseudoVSSSEG2E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E64_V_M2)
  .value("PseudoVSSSEG2E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E64_V_M2_MASK)
  .value("PseudoVSSSEG2E64_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E64_V_M4)
  .value("PseudoVSSSEG2E64_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E64_V_M4_MASK)
  .value("PseudoVSSSEG2E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_M1)
  .value("PseudoVSSSEG2E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_M1_MASK)
  .value("PseudoVSSSEG2E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_M2)
  .value("PseudoVSSSEG2E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_M2_MASK)
  .value("PseudoVSSSEG2E8_V_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_M4)
  .value("PseudoVSSSEG2E8_V_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_M4_MASK)
  .value("PseudoVSSSEG2E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_MF2)
  .value("PseudoVSSSEG2E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_MF2_MASK)
  .value("PseudoVSSSEG2E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_MF4)
  .value("PseudoVSSSEG2E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_MF4_MASK)
  .value("PseudoVSSSEG2E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_MF8)
  .value("PseudoVSSSEG2E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG2E8_V_MF8_MASK)
  .value("PseudoVSSSEG3E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E16_V_M1)
  .value("PseudoVSSSEG3E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E16_V_M1_MASK)
  .value("PseudoVSSSEG3E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E16_V_M2)
  .value("PseudoVSSSEG3E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E16_V_M2_MASK)
  .value("PseudoVSSSEG3E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E16_V_MF2)
  .value("PseudoVSSSEG3E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E16_V_MF2_MASK)
  .value("PseudoVSSSEG3E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E16_V_MF4)
  .value("PseudoVSSSEG3E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E16_V_MF4_MASK)
  .value("PseudoVSSSEG3E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E32_V_M1)
  .value("PseudoVSSSEG3E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E32_V_M1_MASK)
  .value("PseudoVSSSEG3E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E32_V_M2)
  .value("PseudoVSSSEG3E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E32_V_M2_MASK)
  .value("PseudoVSSSEG3E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E32_V_MF2)
  .value("PseudoVSSSEG3E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E32_V_MF2_MASK)
  .value("PseudoVSSSEG3E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E64_V_M1)
  .value("PseudoVSSSEG3E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E64_V_M1_MASK)
  .value("PseudoVSSSEG3E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E64_V_M2)
  .value("PseudoVSSSEG3E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E64_V_M2_MASK)
  .value("PseudoVSSSEG3E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E8_V_M1)
  .value("PseudoVSSSEG3E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E8_V_M1_MASK)
  .value("PseudoVSSSEG3E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E8_V_M2)
  .value("PseudoVSSSEG3E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E8_V_M2_MASK)
  .value("PseudoVSSSEG3E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E8_V_MF2)
  .value("PseudoVSSSEG3E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E8_V_MF2_MASK)
  .value("PseudoVSSSEG3E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E8_V_MF4)
  .value("PseudoVSSSEG3E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E8_V_MF4_MASK)
  .value("PseudoVSSSEG3E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E8_V_MF8)
  .value("PseudoVSSSEG3E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG3E8_V_MF8_MASK)
  .value("PseudoVSSSEG4E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E16_V_M1)
  .value("PseudoVSSSEG4E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E16_V_M1_MASK)
  .value("PseudoVSSSEG4E16_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E16_V_M2)
  .value("PseudoVSSSEG4E16_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E16_V_M2_MASK)
  .value("PseudoVSSSEG4E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E16_V_MF2)
  .value("PseudoVSSSEG4E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E16_V_MF2_MASK)
  .value("PseudoVSSSEG4E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E16_V_MF4)
  .value("PseudoVSSSEG4E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E16_V_MF4_MASK)
  .value("PseudoVSSSEG4E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E32_V_M1)
  .value("PseudoVSSSEG4E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E32_V_M1_MASK)
  .value("PseudoVSSSEG4E32_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E32_V_M2)
  .value("PseudoVSSSEG4E32_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E32_V_M2_MASK)
  .value("PseudoVSSSEG4E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E32_V_MF2)
  .value("PseudoVSSSEG4E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E32_V_MF2_MASK)
  .value("PseudoVSSSEG4E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E64_V_M1)
  .value("PseudoVSSSEG4E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E64_V_M1_MASK)
  .value("PseudoVSSSEG4E64_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E64_V_M2)
  .value("PseudoVSSSEG4E64_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E64_V_M2_MASK)
  .value("PseudoVSSSEG4E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E8_V_M1)
  .value("PseudoVSSSEG4E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E8_V_M1_MASK)
  .value("PseudoVSSSEG4E8_V_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E8_V_M2)
  .value("PseudoVSSSEG4E8_V_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E8_V_M2_MASK)
  .value("PseudoVSSSEG4E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E8_V_MF2)
  .value("PseudoVSSSEG4E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E8_V_MF2_MASK)
  .value("PseudoVSSSEG4E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E8_V_MF4)
  .value("PseudoVSSSEG4E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E8_V_MF4_MASK)
  .value("PseudoVSSSEG4E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E8_V_MF8)
  .value("PseudoVSSSEG4E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG4E8_V_MF8_MASK)
  .value("PseudoVSSSEG5E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E16_V_M1)
  .value("PseudoVSSSEG5E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E16_V_M1_MASK)
  .value("PseudoVSSSEG5E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E16_V_MF2)
  .value("PseudoVSSSEG5E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E16_V_MF2_MASK)
  .value("PseudoVSSSEG5E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E16_V_MF4)
  .value("PseudoVSSSEG5E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E16_V_MF4_MASK)
  .value("PseudoVSSSEG5E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E32_V_M1)
  .value("PseudoVSSSEG5E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E32_V_M1_MASK)
  .value("PseudoVSSSEG5E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E32_V_MF2)
  .value("PseudoVSSSEG5E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E32_V_MF2_MASK)
  .value("PseudoVSSSEG5E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E64_V_M1)
  .value("PseudoVSSSEG5E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E64_V_M1_MASK)
  .value("PseudoVSSSEG5E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E8_V_M1)
  .value("PseudoVSSSEG5E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E8_V_M1_MASK)
  .value("PseudoVSSSEG5E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E8_V_MF2)
  .value("PseudoVSSSEG5E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E8_V_MF2_MASK)
  .value("PseudoVSSSEG5E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E8_V_MF4)
  .value("PseudoVSSSEG5E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E8_V_MF4_MASK)
  .value("PseudoVSSSEG5E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E8_V_MF8)
  .value("PseudoVSSSEG5E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG5E8_V_MF8_MASK)
  .value("PseudoVSSSEG6E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E16_V_M1)
  .value("PseudoVSSSEG6E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E16_V_M1_MASK)
  .value("PseudoVSSSEG6E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E16_V_MF2)
  .value("PseudoVSSSEG6E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E16_V_MF2_MASK)
  .value("PseudoVSSSEG6E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E16_V_MF4)
  .value("PseudoVSSSEG6E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E16_V_MF4_MASK)
  .value("PseudoVSSSEG6E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E32_V_M1)
  .value("PseudoVSSSEG6E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E32_V_M1_MASK)
  .value("PseudoVSSSEG6E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E32_V_MF2)
  .value("PseudoVSSSEG6E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E32_V_MF2_MASK)
  .value("PseudoVSSSEG6E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E64_V_M1)
  .value("PseudoVSSSEG6E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E64_V_M1_MASK)
  .value("PseudoVSSSEG6E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E8_V_M1)
  .value("PseudoVSSSEG6E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E8_V_M1_MASK)
  .value("PseudoVSSSEG6E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E8_V_MF2)
  .value("PseudoVSSSEG6E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E8_V_MF2_MASK)
  .value("PseudoVSSSEG6E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E8_V_MF4)
  .value("PseudoVSSSEG6E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E8_V_MF4_MASK)
  .value("PseudoVSSSEG6E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E8_V_MF8)
  .value("PseudoVSSSEG6E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG6E8_V_MF8_MASK)
  .value("PseudoVSSSEG7E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E16_V_M1)
  .value("PseudoVSSSEG7E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E16_V_M1_MASK)
  .value("PseudoVSSSEG7E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E16_V_MF2)
  .value("PseudoVSSSEG7E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E16_V_MF2_MASK)
  .value("PseudoVSSSEG7E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E16_V_MF4)
  .value("PseudoVSSSEG7E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E16_V_MF4_MASK)
  .value("PseudoVSSSEG7E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E32_V_M1)
  .value("PseudoVSSSEG7E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E32_V_M1_MASK)
  .value("PseudoVSSSEG7E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E32_V_MF2)
  .value("PseudoVSSSEG7E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E32_V_MF2_MASK)
  .value("PseudoVSSSEG7E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E64_V_M1)
  .value("PseudoVSSSEG7E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E64_V_M1_MASK)
  .value("PseudoVSSSEG7E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E8_V_M1)
  .value("PseudoVSSSEG7E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E8_V_M1_MASK);
  opcodes.value("PseudoVSSSEG7E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E8_V_MF2)
  .value("PseudoVSSSEG7E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E8_V_MF2_MASK)
  .value("PseudoVSSSEG7E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E8_V_MF4)
  .value("PseudoVSSSEG7E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E8_V_MF4_MASK)
  .value("PseudoVSSSEG7E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E8_V_MF8)
  .value("PseudoVSSSEG7E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG7E8_V_MF8_MASK)
  .value("PseudoVSSSEG8E16_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E16_V_M1)
  .value("PseudoVSSSEG8E16_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E16_V_M1_MASK)
  .value("PseudoVSSSEG8E16_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E16_V_MF2)
  .value("PseudoVSSSEG8E16_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E16_V_MF2_MASK)
  .value("PseudoVSSSEG8E16_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E16_V_MF4)
  .value("PseudoVSSSEG8E16_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E16_V_MF4_MASK)
  .value("PseudoVSSSEG8E32_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E32_V_M1)
  .value("PseudoVSSSEG8E32_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E32_V_M1_MASK)
  .value("PseudoVSSSEG8E32_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E32_V_MF2)
  .value("PseudoVSSSEG8E32_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E32_V_MF2_MASK)
  .value("PseudoVSSSEG8E64_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E64_V_M1)
  .value("PseudoVSSSEG8E64_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E64_V_M1_MASK)
  .value("PseudoVSSSEG8E8_V_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E8_V_M1)
  .value("PseudoVSSSEG8E8_V_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E8_V_M1_MASK)
  .value("PseudoVSSSEG8E8_V_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E8_V_MF2)
  .value("PseudoVSSSEG8E8_V_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E8_V_MF2_MASK)
  .value("PseudoVSSSEG8E8_V_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E8_V_MF4)
  .value("PseudoVSSSEG8E8_V_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E8_V_MF4_MASK)
  .value("PseudoVSSSEG8E8_V_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E8_V_MF8)
  .value("PseudoVSSSEG8E8_V_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSSEG8E8_V_MF8_MASK)
  .value("PseudoVSSUBU_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_M1)
  .value("PseudoVSSUBU_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_M1_MASK)
  .value("PseudoVSSUBU_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_M2)
  .value("PseudoVSSUBU_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_M2_MASK)
  .value("PseudoVSSUBU_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_M4)
  .value("PseudoVSSUBU_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_M4_MASK)
  .value("PseudoVSSUBU_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_M8)
  .value("PseudoVSSUBU_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_M8_MASK)
  .value("PseudoVSSUBU_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_MF2)
  .value("PseudoVSSUBU_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_MF2_MASK)
  .value("PseudoVSSUBU_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_MF4)
  .value("PseudoVSSUBU_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_MF4_MASK)
  .value("PseudoVSSUBU_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_MF8)
  .value("PseudoVSSUBU_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VV_MF8_MASK)
  .value("PseudoVSSUBU_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_M1)
  .value("PseudoVSSUBU_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_M1_MASK)
  .value("PseudoVSSUBU_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_M2)
  .value("PseudoVSSUBU_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_M2_MASK)
  .value("PseudoVSSUBU_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_M4)
  .value("PseudoVSSUBU_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_M4_MASK)
  .value("PseudoVSSUBU_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_M8)
  .value("PseudoVSSUBU_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_M8_MASK)
  .value("PseudoVSSUBU_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_MF2)
  .value("PseudoVSSUBU_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_MF2_MASK)
  .value("PseudoVSSUBU_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_MF4)
  .value("PseudoVSSUBU_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_MF4_MASK)
  .value("PseudoVSSUBU_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_MF8)
  .value("PseudoVSSUBU_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUBU_VX_MF8_MASK)
  .value("PseudoVSSUB_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_M1)
  .value("PseudoVSSUB_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_M1_MASK)
  .value("PseudoVSSUB_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_M2)
  .value("PseudoVSSUB_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_M2_MASK)
  .value("PseudoVSSUB_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_M4)
  .value("PseudoVSSUB_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_M4_MASK)
  .value("PseudoVSSUB_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_M8)
  .value("PseudoVSSUB_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_M8_MASK)
  .value("PseudoVSSUB_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_MF2)
  .value("PseudoVSSUB_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_MF2_MASK)
  .value("PseudoVSSUB_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_MF4)
  .value("PseudoVSSUB_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_MF4_MASK)
  .value("PseudoVSSUB_VV_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_MF8)
  .value("PseudoVSSUB_VV_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VV_MF8_MASK)
  .value("PseudoVSSUB_VX_M1", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_M1)
  .value("PseudoVSSUB_VX_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_M1_MASK)
  .value("PseudoVSSUB_VX_M2", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_M2)
  .value("PseudoVSSUB_VX_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_M2_MASK)
  .value("PseudoVSSUB_VX_M4", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_M4)
  .value("PseudoVSSUB_VX_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_M4_MASK)
  .value("PseudoVSSUB_VX_M8", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_M8)
  .value("PseudoVSSUB_VX_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_M8_MASK)
  .value("PseudoVSSUB_VX_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_MF2)
  .value("PseudoVSSUB_VX_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_MF2_MASK)
  .value("PseudoVSSUB_VX_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_MF4)
  .value("PseudoVSSUB_VX_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_MF4_MASK)
  .value("PseudoVSSUB_VX_MF8", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_MF8)
  .value("PseudoVSSUB_VX_MF8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSSUB_VX_MF8_MASK)
  .value("PseudoVSUB_VV_M1", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_M1)
  .value("PseudoVSUB_VV_M1_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_M1_MASK)
  .value("PseudoVSUB_VV_M2", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_M2)
  .value("PseudoVSUB_VV_M2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_M2_MASK)
  .value("PseudoVSUB_VV_M4", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_M4)
  .value("PseudoVSUB_VV_M4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_M4_MASK)
  .value("PseudoVSUB_VV_M8", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_M8)
  .value("PseudoVSUB_VV_M8_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_M8_MASK)
  .value("PseudoVSUB_VV_MF2", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_MF2)
  .value("PseudoVSUB_VV_MF2_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_MF2_MASK)
  .value("PseudoVSUB_VV_MF4", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_MF4)
  .value("PseudoVSUB_VV_MF4_MASK", LIEF::assembly::riscv::OPCODE::PseudoVSUB_VV_MF4_MASK)
  .value("PseudoVSUB_VV_MF8", LIEF::assembly::risc