import importlib
import subprocess
import sys
from types import ModuleType

import pytest
from typer.testing import CliRunner

runner = CliRunner()


@pytest.fixture(
    name="mod",
    params=[
        pytest.param("tutorial002_py310"),
        pytest.param("tutorial002_an_py310"),
    ],
)
def get_mod(request: pytest.FixtureRequest) -> ModuleType:
    module_name = f"docs_src.options.help.{request.param}"
    mod = importlib.import_module(module_name)
    return mod


def test_call(mod: ModuleType):
    result = runner.invoke(mod.app, ["World"])
    assert result.exit_code == 0
    assert "Hello World" in result.output


def test_formal(mod: ModuleType):
    result = runner.invoke(mod.app, ["World", "--formal"])
    assert result.exit_code == 0
    assert "Good day Ms. World" in result.output


def test_help(mod: ModuleType):
    result = runner.invoke(mod.app, ["--help"])
    assert result.exit_code == 0
    assert "--lastname" in result.output
    assert "Customization and Utils" in result.output
    assert "--formal" in result.output
    assert "--no-formal" in result.output
    assert "--debug" in result.output
    assert "--no-debug" in result.output


def test_script(mod: ModuleType):
    result = subprocess.run(
        [sys.executable, "-m", "coverage", "run", mod.__file__, "--help"],
        capture_output=True,
        encoding="utf-8",
    )
    assert "Usage" in result.stdout
