"""
A library of useful helper classes to the SAX classes, for the
convenience of application and driver writers.
"""

from _typeshed import SupportsWrite
from codecs import StreamReaderWriter, StreamWriter
from collections.abc import Mapping
from io import RawIOBase, TextIOBase
from typing import Literal, NoReturn
from xml.sax import _Source, handler, xmlreader

def escape(data: str, entities: Mapping[str, str] = {}) -> str:
    """Escape &, <, and > in a string of data.

    You can escape other strings of data by passing a dictionary as
    the optional entities parameter.  The keys and values must all be
    strings; each key will be replaced with its corresponding value.
    """

def unescape(data: str, entities: Mapping[str, str] = {}) -> str:
    """Unescape &amp;, &lt;, and &gt; in a string of data.

    You can unescape other strings of data by passing a dictionary as
    the optional entities parameter.  The keys and values must all be
    strings; each key will be replaced with its corresponding value.
    """

def quoteattr(data: str, entities: Mapping[str, str] = {}) -> str:
    """Escape and quote an attribute value.

    Escape &, <, and > in a string of data, then quote it for use as
    an attribute value.  The " character will be escaped as well, if
    necessary.

    You can escape other strings of data by passing a dictionary as
    the optional entities parameter.  The keys and values must all be
    strings; each key will be replaced with its corresponding value.
    """

class XMLGenerator(handler.ContentHandler):
    def __init__(
        self,
        out: TextIOBase | RawIOBase | StreamWriter | StreamReaderWriter | SupportsWrite[bytes] | None = None,
        encoding: str = "iso-8859-1",
        short_empty_elements: bool = False,
    ) -> None: ...
    def _qname(self, name: tuple[str | None, str]) -> str:
        """Builds a qualified name from a (ns_url, localname) pair"""

    def startDocument(self) -> None: ...
    def endDocument(self) -> None: ...
    def startPrefixMapping(self, prefix: str | None, uri: str) -> None: ...
    def endPrefixMapping(self, prefix: str | None) -> None: ...
    def startElement(self, name: str, attrs: xmlreader.AttributesImpl) -> None: ...
    def endElement(self, name: str) -> None: ...
    def startElementNS(self, name: tuple[str | None, str], qname: str | None, attrs: xmlreader.AttributesNSImpl) -> None: ...
    def endElementNS(self, name: tuple[str | None, str], qname: str | None) -> None: ...
    def characters(self, content: str) -> None: ...
    def ignorableWhitespace(self, content: str) -> None: ...
    def processingInstruction(self, target: str, data: str) -> None: ...

class XMLFilterBase(xmlreader.XMLReader):
    """This class is designed to sit between an XMLReader and the
    client application's event handlers.  By default, it does nothing
    but pass requests up to the reader and events on to the handlers
    unmodified, but subclasses can override specific methods to modify
    the event stream or the configuration requests as they pass
    through.
    """

    def __init__(self, parent: xmlreader.XMLReader | None = None) -> None: ...
    # ErrorHandler methods
    def error(self, exception: BaseException) -> NoReturn: ...
    def fatalError(self, exception: BaseException) -> NoReturn: ...
    def warning(self, exception: BaseException) -> None: ...
    # ContentHandler methods
    def setDocumentLocator(self, locator: xmlreader.Locator) -> None: ...
    def startDocument(self) -> None: ...
    def endDocument(self) -> None: ...
    def startPrefixMapping(self, prefix: str | None, uri: str) -> None: ...
    def endPrefixMapping(self, prefix: str | None) -> None: ...
    def startElement(self, name: str, attrs: xmlreader.AttributesImpl) -> None: ...
    def endElement(self, name: str) -> None: ...
    def startElementNS(self, name: tuple[str | None, str], qname: str | None, attrs: xmlreader.AttributesNSImpl) -> None: ...
    def endElementNS(self, name: tuple[str | None, str], qname: str | None) -> None: ...
    def characters(self, content: str) -> None: ...
    def ignorableWhitespace(self, chars: str) -> None: ...
    def processingInstruction(self, target: str, data: str) -> None: ...
    def skippedEntity(self, name: str) -> None: ...
    # DTDHandler methods
    def notationDecl(self, name: str, publicId: str | None, systemId: str) -> None: ...
    def unparsedEntityDecl(self, name: str, publicId: str | None, systemId: str, ndata: str) -> None: ...
    # EntityResolver methods
    def resolveEntity(self, publicId: str | None, systemId: str) -> str: ...
    # XMLReader methods
    def parse(self, source: xmlreader.InputSource | _Source) -> None: ...
    def setLocale(self, locale: str) -> None: ...
    def getFeature(self, name: str) -> Literal[1, 0] | bool: ...
    def setFeature(self, name: str, state: Literal[1, 0] | bool) -> None: ...
    def getProperty(self, name: str) -> object: ...
    def setProperty(self, name: str, value: object) -> None: ...
    # XMLFilter methods
    def getParent(self) -> xmlreader.XMLReader | None: ...
    def setParent(self, parent: xmlreader.XMLReader) -> None: ...

def prepare_input_source(source: xmlreader.InputSource | _Source, base: str = "") -> xmlreader.InputSource:
    """This function takes an InputSource and an optional base URL and
    returns a fully resolved InputSource object ready for reading.
    """
