How to update a third party library to a newer version
======================================================

Introduction
------------

wxWidgets includes several third party libraries, i.e. libraries which are
used by wxWidgets and distributed with it but which we don't maintain nor even
modify, inasmuch as possible, ourselves. These libraries are developed by
their maintainers and from time to time we need to replace the versions used
by wxWidgets with newer versions.


Submodules
----------

All third party libraries are managed using Git submodules. This includes
3rdparty/catch and expat, jpeg, png, tiff and zlib subdirectories of src.

As always with submodules, updating a library involves updating its sources in
the submodule, pushing this submodule out and then committing the changes in
the top-level repository.


Updating the submodule
----------------------

All submodules use `master` branch for the upstream master and `wx` for the
version used by wxWidgets. To update the latter, just merge the appropriate
commit from master into `wx`, e.g.

    $ cd src/expat
    $ git checkout wx
    $ git merge R_x_y_z # For the latest x.y.z release

After resolving any conflicts, commit the result.


Special instructions for specific libraries
-------------------------------------------

Some libraries, notably those for which we store the generated build files in
our submodules, require extra actions to be undertaken after merging with the
upstream:

## libexpat

Run `buildconf.sh` to update the generated files and commit the changes.

## jpeg

There is no upstream repository available with the latest version. So download
and commit the releases from https://www.ijg.org/files/.

## libpng

We use a special hack for libpng as we want to prefix all its symbols with
`wx_` but don't want to use its build system which makes this easily possible
(perhaps we should, but for now we don't). So, when upgrading libpng, you need
to perform an extra step after merging the new version (and before committing
your changes):

Create a temporary build directory and run libpng configure from it using
`--with-libpng-prefix=wx_` option. Then run `make pnglibconf.h pngprefix.h`
to create these files in the build directory. Next, search for the line
containing `PNG_ZLIB_VERNUM` in the `pnglibconf.h` and set it to 0 to disable
zlib version checks (this looks dangerous but seems to be unavoidable with the
current build system). And then, finally, copy these files to src/png
subdirectory of the wxWidgets source tree, overwriting the versions there.

Notice that config.h generated by libpng configure is not used, we build it
without `-DHAVE_CONFIG_H` as it works just fine without it on any ANSI C system
(i.e. anywhere by now).

## libtiff

The forked upstream shown in github is incorrect. It is based on the official
TIFF repository https://gitlab.com/libtiff/libtiff.
Run `autogen.sh` to update the generated files and commit the changes.

Update `tif_config.h` and `tifconf.h` with the updated entries from their `.in` files.
Update the version numbers in `tiffvers.h`.

## zlib

Check for the newly added public systems in `zlib.map` and update `zconf.h` to
include if necessary -- at least with zlib 1.2.12 release this file wasn't
updated at all in the upstream version, resulting in problems such as #22280.
If `zconf.h` is updated, you probably already had to resolve the conflicts in
it, as our file differs from the upstream version due to having the changes
from [Z_PREFIX PR](https://github.com/madler/zlib/pull/323) included in it.

## pcre2

The forked upstream shown in github is incorrect. It is based on the official
PCRE2 repository https://github.com/PCRE2Project/pcre2.
You might need to use `git merge --allow-unrelated-histories`.


Updating the main repository
----------------------------

If there are any changes to the source files used by the library, update the
corresponding `build/bakefiles/$lib.bkl` file (e.g. `expat.bkl` for Expat) and
rerun bakefile to regenerate most of the makefiles and project files. Currently
you will need to update `build/msw/wx_wx$lib.vcxproj{,.filters}` files
manually.
After updating the `bkl` file, run  `build/osx/makeprojects.py` to generate
the Xcode projects.

Commit these changes and the changes to the submodule itself, but don't push
them to GitHub yet.


Test and push
-------------

The updates need to be tested under MSW and under Unix using
`--disable-sys-libs` configure option.

If everything seems to work, push the updated branch out. Notice that you may
want to use the ssh GitHub repository URL instead of the default (because more
convenient for checking them out) HTTPS one:

    $ git push --set-upstream git@github.com:wxWidgets/libexpat.git wx


Finally, create a PR to let the CI builds to run and test changes too. If no
problems are found, merge the PR as usual.
