/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.CharsetBig5;
import testsuite.clusterj.model.CharsetLatin1;
import testsuite.clusterj.model.CharsetModel;
import testsuite.clusterj.model.CharsetSjis;
import testsuite.clusterj.model.CharsetUtf8;

public class CharsetTest
extends AbstractClusterJModelTest {
    protected List<CharsetModel> charsetTypes = new ArrayList<CharsetModel>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.setAutoCommit(connection, false);
    }

    public void testLatin1() {
        this.writeJDBCreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.LARGE);
        this.writeJDBCreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.LARGE);
        this.writeNDBreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.SMALL);
        this.writeNDBreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadJDBC("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.LARGE);
        this.writeNDBreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.SMALL);
        this.writeNDBreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadNDB("windows-1252", "charsetlatin1", CharsetLatin1.class, ColumnDescriptor.LARGE);
        this.failOnError();
    }

    public void testUtf8() {
        this.writeJDBCreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.LARGE);
        this.writeJDBCreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.LARGE);
        this.writeNDBreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.SMALL);
        this.writeNDBreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadJDBC("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.LARGE);
        this.writeNDBreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.SMALL);
        this.writeNDBreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadNDB("UTF-8", "charsetutf8", CharsetUtf8.class, ColumnDescriptor.LARGE);
        this.failOnError();
    }

    public void testSjis() {
        this.writeNDBreadJDBC("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.SMALL);
        this.writeNDBreadJDBC("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadJDBC("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.LARGE);
        this.writeNDBreadNDB("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.SMALL);
        this.writeNDBreadNDB("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadNDB("SJIS", "charsetsjis", CharsetSjis.class, ColumnDescriptor.LARGE);
        this.failOnError();
    }

    public void testBig5() {
        this.writeJDBCreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.LARGE);
        this.writeJDBCreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.SMALL);
        this.writeJDBCreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.MEDIUM);
        this.writeJDBCreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.LARGE);
        this.writeNDBreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.SMALL);
        this.writeNDBreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadJDBC("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.LARGE);
        this.writeNDBreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.SMALL);
        this.writeNDBreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.MEDIUM);
        this.writeNDBreadNDB("big5", "charsetbig5", CharsetBig5.class, ColumnDescriptor.LARGE);
        this.failOnError();
    }

    protected void writeJDBCreadJDBC(String string, String string2, Class<? extends CharsetModel> clazz, ColumnDescriptor columnDescriptor) {
        this.removeAll(clazz);
        List<String> list = null;
        List<String> list2 = this.generateStrings(columnDescriptor, string);
        List<CharsetModel> list3 = this.generateInstances(columnDescriptor, clazz, list2);
        this.writeToJDBC(columnDescriptor, string2, list3);
        list = this.readFromJDBC(columnDescriptor, string2);
        if (this.debug) {
            System.out.println("Returned results of size " + list.size());
        }
        this.verify("writeJDBCreadJDBC ", list2, list, columnDescriptor);
    }

    protected void writeJDBCreadNDB(String string, String string2, Class<? extends CharsetModel> clazz, ColumnDescriptor columnDescriptor) {
        this.removeAll(clazz);
        List<String> list = null;
        List<String> list2 = this.generateStrings(columnDescriptor, string);
        List<CharsetModel> list3 = this.generateInstances(columnDescriptor, clazz, list2);
        this.writeToJDBC(columnDescriptor, string2, list3);
        list = this.readFromNDB(columnDescriptor, clazz);
        if (this.debug) {
            System.out.println("Returned results of size " + list.size());
        }
        this.verify("writeJDBCreadNDB ", list2, list, columnDescriptor);
    }

    protected void writeNDBreadJDBC(String string, String string2, Class<? extends CharsetModel> clazz, ColumnDescriptor columnDescriptor) {
        this.removeAll(clazz);
        List<String> list = null;
        List<String> list2 = this.generateStrings(columnDescriptor, string);
        List<CharsetModel> list3 = this.generateInstances(columnDescriptor, clazz, list2);
        this.writeToNDB(columnDescriptor, list3);
        list = this.readFromJDBC(columnDescriptor, string2);
        if (this.debug) {
            System.out.println("Returned results of size " + list.size());
        }
        this.verify("writeNDBreadJDBC ", list2, list, columnDescriptor);
    }

    protected void writeNDBreadNDB(String string, String string2, Class<? extends CharsetModel> clazz, ColumnDescriptor columnDescriptor) {
        this.removeAll(clazz);
        List<String> list = null;
        List<String> list2 = this.generateStrings(columnDescriptor, string);
        List<CharsetModel> list3 = this.generateInstances(columnDescriptor, clazz, list2);
        this.writeToNDB(columnDescriptor, list3);
        list = this.readFromNDB(columnDescriptor, clazz);
        if (this.debug) {
            System.out.println("Returned results of size " + list.size());
        }
        this.verify("writeNDBreadNDB ", list2, list, columnDescriptor);
    }

    private void verify(String string, List<String> list, List<String> list2, ColumnDescriptor columnDescriptor) {
        int n = 10;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            String string3 = list2.get(i);
            if (string3 == null) {
                this.error(string + columnDescriptor.columnName + " actual column " + i + " was null.");
                continue;
            }
            int n2 = string2.length();
            int n3 = string3.length();
            this.errorIfNotEqual(string + "got failure on size of column data for column width " + columnDescriptor.columnWidth + " at row " + i, n2, n3);
            if (n2 != n3) continue;
            for (int j = 0; j < string2.length(); ++j) {
                if (--n <= 0) continue;
                this.errorIfNotEqual("Failure to match column data for column width " + columnDescriptor.columnWidth + " at row " + i + " column " + j, string2.codePointAt(j), string3.codePointAt(j));
            }
        }
    }

    protected List<String> generateStrings(ColumnDescriptor columnDescriptor, String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        Charset charset = Charset.forName(string);
        CharBuffer charBuffer = CharBuffer.allocate(65536);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        int n2 = 0;
        for (n = 0; n < 65536; ++n) {
            Character c = Character.valueOf((char)n);
            if (!charsetEncoder.canEncode(c.charValue())) continue;
            charBuffer.append(c.charValue());
            ++n2;
        }
        if (this.debug) {
            System.out.print(string + " has " + n2 + " encodable characters");
        }
        charBuffer.flip();
        n = columnDescriptor.getColumnWidth();
        boolean bl = false;
        byte[] byArray = new byte[n];
        while (!bl) {
            int n3 = charBuffer.position();
            charBuffer.mark();
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, false);
            int n4 = charBuffer.position();
            int n5 = n4 - n3;
            if (n5 == 0) {
                bl = true;
                continue;
            }
            char[] cArray = new char[n5];
            charBuffer.reset();
            charBuffer.get(cArray, 0, n5);
            String string2 = String.copyValueOf(cArray);
            arrayList.add(string2);
            if (!coderResult.isUnderflow()) continue;
            bl = true;
        }
        if (this.debug) {
            System.out.println(" in " + arrayList.size() + " row(s) of size " + columnDescriptor.columnWidth);
        }
        return arrayList;
    }

    protected List<CharsetModel> generateInstances(ColumnDescriptor columnDescriptor, Class<? extends CharsetModel> clazz, List<String> list) {
        ArrayList<CharsetModel> arrayList = new ArrayList<CharsetModel>();
        for (int i = 0; i < list.size(); ++i) {
            CharsetModel charsetModel = (CharsetModel)this.session.newInstance(clazz);
            charsetModel.setId(i);
            columnDescriptor.set(charsetModel, list.get(i));
            arrayList.add(charsetModel);
        }
        if (this.debug) {
            System.out.println("Created " + arrayList.size() + " instances of " + clazz.getName());
        }
        return arrayList;
    }

    protected void writeToJDBC(ColumnDescriptor columnDescriptor, String string, List<CharsetModel> list) {
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(string);
        stringBuffer.append(" (id, ");
        stringBuffer.append(columnDescriptor.getColumnName());
        stringBuffer.append(") VALUES (?, ?)");
        String string2 = stringBuffer.toString();
        if (this.debug) {
            System.out.println(string2);
        }
        PreparedStatement preparedStatement = null;
        int n = 0;
        String string3 = "";
        try {
            Properties properties = new Properties();
            properties.put("characterEncoding", "utf8");
            this.getConnection(properties);
            this.setAutoCommit(connection, false);
            preparedStatement = connection.prepareStatement(string2);
            if (this.debug) {
                System.out.println(preparedStatement.toString());
            }
            for (n = 0; n < list.size(); ++n) {
                CharsetModel charsetModel = list.get(n);
                preparedStatement.setInt(1, charsetModel.getId());
                string3 = columnDescriptor.get(charsetModel);
                preparedStatement.setString(2, string3);
                preparedStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to insert " + string + " at instance " + n + " errant string: " + CharsetTest.dump(string3), sQLException);
        }
    }

    protected void writeToNDB(ColumnDescriptor columnDescriptor, List<CharsetModel> list) {
        this.session.currentTransaction().begin();
        for (CharsetModel charsetModel : list) {
            this.session.makePersistent((Object)charsetModel);
        }
        this.session.currentTransaction().commit();
    }

    protected List<String> readFromNDB(ColumnDescriptor columnDescriptor, Class<? extends CharsetModel> clazz) {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.session.currentTransaction().begin();
        int n = 0;
        boolean bl = false;
        while (!bl) {
            CharsetModel charsetModel;
            if ((charsetModel = (CharsetModel)this.session.find(clazz, (Object)n++)) != null) {
                arrayList.add(columnDescriptor.get(charsetModel));
                continue;
            }
            bl = true;
        }
        this.session.currentTransaction().commit();
        return arrayList;
    }

    protected List<String> readFromJDBC(ColumnDescriptor columnDescriptor, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer("SELECT id, ");
        stringBuffer.append(columnDescriptor.getColumnName());
        stringBuffer.append(" FROM ");
        stringBuffer.append(string);
        stringBuffer.append(" ORDER BY ID");
        String string2 = stringBuffer.toString();
        if (this.debug) {
            System.out.println(string2);
        }
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(2);
                arrayList.add(string3);
                ++n;
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException("Failed to read " + string + " at instance " + n, sQLException);
        }
        return arrayList;
    }

    protected static enum ColumnDescriptor {
        SMALL(200, "smallcolumn", new InstanceHandler(){

            @Override
            public void set(CharsetModel charsetModel, String string) {
                charsetModel.setSmallColumn(string);
            }

            @Override
            public String get(CharsetModel charsetModel) {
                return charsetModel.getSmallColumn();
            }
        }),
        MEDIUM(500, "mediumcolumn", new InstanceHandler(){

            @Override
            public void set(CharsetModel charsetModel, String string) {
                charsetModel.setMediumColumn(string);
            }

            @Override
            public String get(CharsetModel charsetModel) {
                return charsetModel.getMediumColumn();
            }
        }),
        LARGE(10000, "largecolumn", new InstanceHandler(){

            @Override
            public void set(CharsetModel charsetModel, String string) {
                charsetModel.setLargeColumn(string);
            }

            @Override
            public String get(CharsetModel charsetModel) {
                return charsetModel.getLargeColumn();
            }
        });

        private int columnWidth;
        private String columnName;
        private InstanceHandler instanceHandler;

        public String getColumnName() {
            return this.columnName;
        }

        public String get(CharsetModel charsetModel) {
            return this.instanceHandler.get(charsetModel);
        }

        public void set(CharsetModel charsetModel, String string) {
            this.instanceHandler.set(charsetModel, string);
        }

        public int getColumnWidth() {
            return this.columnWidth;
        }

        private ColumnDescriptor(int n2, String string2, InstanceHandler instanceHandler) {
            this.columnWidth = n2;
            this.columnName = string2;
            this.instanceHandler = instanceHandler;
        }

        private static interface InstanceHandler {
            public void set(CharsetModel var1, String var2);

            public String get(CharsetModel var1);
        }
    }
}

