/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.ClusterConnection;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.DbImplForNdbRecord;
import com.mysql.clusterj.tie.NdbRecordImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.NdbRecordSmartValueHandlerFactoryImpl;
import com.mysql.ndbjtie.ndbapi.Ndb;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.Ndb_cluster_connection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClusterConnectionImpl
implements ClusterConnection {
    static final I18NHelper local = I18NHelper.getInstance(ClusterConnectionImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ClusterConnectionImpl.class);
    protected Ndb_cluster_connection clusterConnection;
    final String connectString;
    final int nodeId;
    final int connectTimeoutMgm;
    private Map<DbImpl, Object> dbs = new IdentityHashMap<DbImpl, Object>();
    DbImplForNdbRecord dbForNdbRecord;
    private ConcurrentMap<String, NdbRecordImpl> ndbRecordImplMap = new ConcurrentHashMap<String, NdbRecordImpl>();
    NdbDictionary.Dictionary dictionaryForNdbRecord = null;
    private long[] autoIncrement;
    private static final String USE_SMART_VALUE_HANDLER_NAME = "com.mysql.clusterj.UseSmartValueHandler";
    private static final boolean USE_SMART_VALUE_HANDLER = ClusterJHelper.getBooleanProperty("com.mysql.clusterj.UseSmartValueHandler", "true");

    public ClusterConnectionImpl(String string, int n, int n2) {
        this.connectString = string;
        this.nodeId = n;
        this.connectTimeoutMgm = n2;
        this.clusterConnection = Ndb_cluster_connection.create(string, n);
        ClusterConnectionImpl.handleError(this.clusterConnection, string, n);
        int n3 = this.clusterConnection.set_timeout(n2);
        ClusterConnectionImpl.handleError(n3, string, n, n2);
        logger.info(local.message("INFO_Create_Cluster_Connection", string, n, n2));
    }

    @Override
    public void connect(int n, int n2, boolean bl) {
        this.checkConnection();
        int n3 = this.clusterConnection.connect(n, n2, bl ? 1 : 0);
        ClusterConnectionImpl.handleError(n3, this.clusterConnection, this.connectString, this.nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Db createDb(String string, int n) {
        this.checkConnection();
        Ndb ndb = null;
        Object object = this;
        synchronized (object) {
            ndb = Ndb.create(this.clusterConnection, string, "def");
            ClusterConnectionImpl.handleError(ndb, this.clusterConnection, this.connectString, this.nodeId);
            if (this.dictionaryForNdbRecord == null) {
                Ndb ndb2 = Ndb.create(this.clusterConnection, string, "def");
                ClusterConnectionImpl.handleError(ndb2, this.clusterConnection, this.connectString, this.nodeId);
                this.dbForNdbRecord = new DbImplForNdbRecord(this, ndb2);
                this.dictionaryForNdbRecord = this.dbForNdbRecord.getNdbDictionary();
            }
        }
        object = new DbImpl(this, ndb, n);
        ((DbImpl)object).initializeAutoIncrement(this.autoIncrement);
        this.dbs.put((DbImpl)object, null);
        return object;
    }

    @Override
    public void waitUntilReady(int n, int n2) {
        this.checkConnection();
        int n3 = this.clusterConnection.wait_until_ready(n, n2);
        ClusterConnectionImpl.handleError(n3, this.clusterConnection, this.connectString, this.nodeId);
    }

    private void checkConnection() {
        if (this.clusterConnection == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Cluster_Connection_Must_Not_Be_Null"));
        }
    }

    protected static void handleError(int n, String string, int n2, int n3) {
        if (n != 0) {
            String string2 = local.message("ERR_Set_Timeout_Mgm", string, n2, n3, n);
            logger.error(string2);
            throw new ClusterJDatastoreException(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleError(int n, Ndb_cluster_connection ndb_cluster_connection, String string, int n2) {
        if (n >= 0) {
            return;
        }
        try {
            ClusterConnectionImpl.throwError(n, ndb_cluster_connection, string, n2);
        }
        finally {
            Ndb_cluster_connection.delete(ndb_cluster_connection);
        }
    }

    protected static void handleError(Object object, Ndb_cluster_connection ndb_cluster_connection, String string, int n) {
        if (object != null) {
            return;
        }
        ClusterConnectionImpl.throwError(null, ndb_cluster_connection, string, n);
    }

    protected static void handleError(Ndb_cluster_connection ndb_cluster_connection, String string, int n) {
        if (ndb_cluster_connection == null) {
            String string2 = local.message("ERR_Connect", (Object)string, (Object)n);
            logger.error(string2);
            throw new ClusterJDatastoreException(string2);
        }
    }

    protected static void throwError(Object object, Ndb_cluster_connection ndb_cluster_connection, String string, int n) {
        String string2 = ndb_cluster_connection.get_latest_error_msg();
        int n2 = ndb_cluster_connection.get_latest_error();
        String string3 = local.message("ERR_NdbError", object, n2, string2, string, n);
        throw new ClusterJDatastoreException(string3);
    }

    @Override
    public void close() {
        if (this.clusterConnection != null) {
            logger.info(local.message("INFO_Close_Cluster_Connection", (Object)this.connectString, (Object)this.nodeId));
            for (DbImpl object : this.dbs.keySet()) {
                object.closing();
            }
            this.dbForNdbRecord.closing();
            if (this.dbs.size() != 0) {
                IdentityHashMap<DbImpl, Object> identityHashMap = new IdentityHashMap<DbImpl, Object>(this.dbs);
                for (Db db : identityHashMap.keySet()) {
                    db.close();
                }
            }
            for (NdbRecordImpl ndbRecordImpl : this.ndbRecordImplMap.values()) {
                ndbRecordImpl.releaseNdbRecord();
            }
            if (this.dbForNdbRecord != null) {
                this.dbForNdbRecord.close();
                this.dbForNdbRecord = null;
            }
            this.ndbRecordImplMap.clear();
            Ndb_cluster_connection.delete(this.clusterConnection);
            this.clusterConnection = null;
        }
    }

    @Override
    public void close(Db db) {
        this.dbs.remove(db);
    }

    @Override
    public int dbCount() {
        int n = this.dictionaryForNdbRecord == null ? 0 : 1;
        return this.dbs.size() - n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NdbRecordImpl getCachedNdbRecordImpl(Table table) {
        NdbRecordImpl ndbRecordImpl;
        this.dbForNdbRecord.assertOpen("ClusterConnectionImpl.getCachedNdbRecordImpl for table");
        String string = table.getName();
        NdbRecordImpl ndbRecordImpl2 = (NdbRecordImpl)this.ndbRecordImplMap.get(string);
        if (ndbRecordImpl2 != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("NdbRecordImpl found for " + string);
            }
            return ndbRecordImpl2;
        }
        Object object = this.dictionaryForNdbRecord;
        synchronized (object) {
            ndbRecordImpl2 = (NdbRecordImpl)this.ndbRecordImplMap.get(string);
            if (ndbRecordImpl2 != null) {
                return ndbRecordImpl2;
            }
            ndbRecordImpl = new NdbRecordImpl(table, this.dictionaryForNdbRecord);
        }
        object = this.ndbRecordImplMap.putIfAbsent(string, ndbRecordImpl);
        if (object == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("NdbRecordImpl created for " + string);
            }
            return ndbRecordImpl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("NdbRecordImpl lost race for " + string);
        }
        ndbRecordImpl.releaseNdbRecord();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NdbRecordImpl getCachedNdbRecordImpl(Index index, Table table) {
        NdbRecordImpl ndbRecordImpl;
        this.dbForNdbRecord.assertOpen("ClusterConnectionImpl.getCachedNdbRecordImpl for index");
        String string = table.getName() + "+" + index.getInternalName();
        NdbRecordImpl ndbRecordImpl2 = (NdbRecordImpl)this.ndbRecordImplMap.get(string);
        if (ndbRecordImpl2 != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("NdbRecordImpl found for " + string);
            }
            return ndbRecordImpl2;
        }
        Object object = this.dictionaryForNdbRecord;
        synchronized (object) {
            ndbRecordImpl2 = (NdbRecordImpl)this.ndbRecordImplMap.get(string);
            if (ndbRecordImpl2 != null) {
                return ndbRecordImpl2;
            }
            ndbRecordImpl = new NdbRecordImpl(index, table, this.dictionaryForNdbRecord);
        }
        object = this.ndbRecordImplMap.putIfAbsent(string, ndbRecordImpl);
        if (object == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("NdbRecordImpl created for " + string);
            }
            return ndbRecordImpl;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("NdbRecordImpl lost race for " + string);
        }
        ndbRecordImpl.releaseNdbRecord();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadSchema(String string) {
        ConcurrentMap<String, NdbRecordImpl> concurrentMap = this.ndbRecordImplMap;
        synchronized (concurrentMap) {
            Iterator iterator = this.ndbRecordImplMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                if (!string2.startsWith(string)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing cached NdbRecord for " + string2);
                }
                NdbRecordImpl ndbRecordImpl = (NdbRecordImpl)entry.getValue();
                iterator.remove();
                if (ndbRecordImpl == null) continue;
                ndbRecordImpl.releaseNdbRecord();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Removing dictionary entry for cached table " + string);
            }
            this.dictionaryForNdbRecord.removeCachedTable(string);
        }
    }

    @Override
    public ValueHandlerFactory getSmartValueHandlerFactory() {
        NdbRecordSmartValueHandlerFactoryImpl ndbRecordSmartValueHandlerFactoryImpl = null;
        if (USE_SMART_VALUE_HANDLER) {
            ndbRecordSmartValueHandlerFactoryImpl = new NdbRecordSmartValueHandlerFactoryImpl();
        }
        return ndbRecordSmartValueHandlerFactoryImpl;
    }

    public NdbRecordOperationImpl newNdbRecordOperationImpl(DbImpl dbImpl, Table table) {
        return new NdbRecordOperationImpl(this, dbImpl, table);
    }

    @Override
    public void initializeAutoIncrement(long[] lArray) {
        this.autoIncrement = lArray;
    }
}

