/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.BlobImpl;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;

class NdbRecordBlobImpl
extends BlobImpl {
    static final I18NHelper local = I18NHelper.getInstance(NdbRecordBlobImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbRecordBlobImpl.class);
    private Column storeColumn;
    private byte[] data;
    private NdbRecordOperationImpl operation;

    public NdbRecordBlobImpl(NdbRecordOperationImpl ndbRecordOperationImpl, Column column) {
        this.storeColumn = column;
        this.operation = ndbRecordOperationImpl;
    }

    public NdbRecordBlobImpl(NdbRecordOperationImpl ndbRecordOperationImpl, NdbRecordBlobImpl ndbRecordBlobImpl) {
        this.operation = ndbRecordOperationImpl;
        this.storeColumn = ndbRecordBlobImpl.storeColumn;
        this.data = ndbRecordBlobImpl.data;
    }

    public void release() {
        if (logger.isDetailEnabled()) {
            logger.detail("NdbRecordBlobImpl.release");
        }
        this.data = null;
        this.operation = null;
    }

    public int getColumnId() {
        return this.storeColumn.getColumnId();
    }

    protected void setNdbBlob() {
        this.ndbBlob = this.operation.getNdbBlob(this.storeColumn);
    }

    public void setValue() {
        this.setValue(this.data);
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void setData(String string) {
        this.data = this.storeColumn.encode(string);
    }

    public byte[] getBytesData() {
        return this.data;
    }

    public String getStringData() {
        return this.storeColumn.decode(this.data);
    }

    public void readData() {
        int n = this.getLength().intValue();
        if (logger.isDetailEnabled()) {
            logger.detail("reading: " + n + " bytes.");
        }
        this.data = new byte[n];
        this.readData(this.data, n);
    }
}

