/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import java.util.Map;
import java.util.Optional;
import org.testng.DataProviderHolder;
import org.testng.IDataProviderMethod;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.internal.Parameters;
import org.testng.internal.TestResult;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.ParameterHolder;
import org.testng.util.Strings;
import org.testng.xml.XmlSuite;

class ParameterHandler {
    private final ITestObjectFactory objectFactory;
    private final IAnnotationFinder finder;
    private final DataProviderHolder holder;
    private int verbose;

    ParameterHandler(ITestObjectFactory objectFactory, IAnnotationFinder finder, DataProviderHolder holder, int verbose) {
        this.objectFactory = objectFactory;
        this.finder = finder;
        this.holder = holder;
        this.verbose = verbose;
    }

    ParameterBag createParameters(ITestNGMethod testMethod, Map<String, String> parameters, Map<String, String> allParameterNames, ITestContext testContext) {
        return this.createParameters(testMethod, parameters, allParameterNames, testContext, null);
    }

    ParameterBag createParameters(ITestNGMethod testMethod, Map<String, String> parameters, Map<String, String> allParameterNames, ITestContext testContext, Object fedInstance) {
        return this.handleParameters(testMethod, testMethod.getInstance(), allParameterNames, parameters, testContext, fedInstance);
    }

    private ParameterBag handleParameters(ITestNGMethod testMethod, Object instance, Map<String, String> allParameterNames, Map<String, String> parameters, ITestContext testContext, Object fedInstance) {
        XmlSuite suite = testContext.getCurrentXmlTest().getSuite();
        try {
            Parameters.MethodParameters methodParams = Parameters.MethodParameters.newInstance(parameters, testMethod, testContext);
            ParameterHolder paramHolder = Parameters.handleParameters(this.objectFactory, testMethod, allParameterNames, instance, methodParams, suite, this.finder, fedInstance, this.holder);
            return new ParameterBag(paramHolder);
        }
        catch (Throwable cause) {
            String msg;
            if (this.verbose >= 2 && Strings.isNotNullAndNotEmpty(msg = Utils.longStackTrace(cause.getCause() != null ? cause.getCause() : cause, true))) {
                Utils.error(msg);
            }
            TestResult result = TestResult.newTestResultWithCauseAs(testMethod, testContext, cause);
            boolean bubbleUpFailure = Optional.ofNullable(testMethod.getDataProviderMethod()).map(IDataProviderMethod::propagateFailureAsTestFailure).orElse(false);
            return new ParameterBag(result, bubbleUpFailure);
        }
    }

    static class ParameterBag {
        final ParameterHolder parameterHolder;
        final ITestResult errorResult;
        boolean bubbleUpFailures = false;

        ParameterBag(ParameterHolder parameterHolder) {
            this.parameterHolder = parameterHolder;
            this.errorResult = null;
        }

        ParameterBag(ITestResult errorResult, boolean bubbleUpFailures) {
            this.parameterHolder = null;
            this.errorResult = errorResult;
            this.bubbleUpFailures = bubbleUpFailures;
        }

        boolean hasErrors() {
            return this.errorResult != null;
        }

        boolean runInParallel() {
            return this.parameterHolder != null && this.parameterHolder.origin == ParameterHolder.ParameterOrigin.ORIGIN_DATA_PROVIDER && this.parameterHolder.dataProviderHolder.isParallel();
        }

        boolean isBubbleUpFailures() {
            return this.bubbleUpFailures;
        }
    }
}

