package calendlib;

##====================================================================================##
## J_[pCGICu v1.2
## Copyright2005 - NorenzPRO
## http://www.norenz.net/
##====================================================================================##

##====================================================================
##wN[Nǂ𔻒肷
##====================================================================
sub getbis {
##
##  : yyyy
##  2003NȂ2003Ƃ
##
##  gp
##  &calendlib'getbis(yyyy);
##
##  ߂l
##  [NȂ1,NȂ0Ԃ
##
	
	local($cl_bis) = @_;
	$cl_bis = int($cl_bis);
	
	local($x_bis) = 0;
	if (($cl_bis % 4 == 0) && (($cl_bis % 100 != 0) || ($cl_bis % 400 == 0))) {
		$x_bis = 1;
	}
	
	return ($x_bis);
	
}
##====================================================================
##wNjԂ
##OSI zellerɂZo
##====================================================================
sub getweek {
##
##  : yyyymmdd
##  2003N49Ȃ20030409Ƃ
##
##  gp
##  &calendlib'getweek(yyyymmdd);
##
##  ߂l
##  sun,mon,tue,wed,thu,fri,sat, error ̂ꂩ
##
	
	local($cl_week) = @_;
	
	local($cl_yr) = substr($cl_week,0,4);
	local($cl_mn) = substr($cl_week,4,2);
	local($cl_dy) = substr($cl_week,6,2);
	$cl_yr = int($cl_yr);
	$cl_mn = int($cl_mn);
	$cl_dy = int($cl_dy);
	
	if (($cl_mn==1)||($cl_mn==2)) {
		$cl_yr = $cl_yr - 1;
		$cl_mn = $cl_mn + 12;
	}
	
	#zeller
	local($x0_rslt) = int(
		$cl_yr
		+int($cl_yr/4)
		-int($cl_yr/100)
		+int($cl_yr/400)
		+int((13*$cl_mn+8)/5)
		+$cl_dy
	)%7;
	
	local($x1_rslt) = "";
	if ($x0_rslt == 0) { $x1_rslt = "sun"; }
	elsif ($x0_rslt == 1) { $x1_rslt = "mon"; }
	elsif ($x0_rslt == 2) { $x1_rslt = "tue"; }
	elsif ($x0_rslt == 3) { $x1_rslt = "wed"; }
	elsif ($x0_rslt == 4) { $x1_rslt = "thu"; }
	elsif ($x0_rslt == 5) { $x1_rslt = "fri"; }
	elsif ($x0_rslt == 6) { $x1_rslt = "sat"; }
	else { $x1_rslt = "error"; }
	
	return ($x1_rslt);
	
}
##====================================================================
##wN茎̓Ԃ
##====================================================================
sub getmday {
##
##  : yyyymm
##  2003N4Ȃ200304Ƃ
##
##  gp
##  &calendlib'getmday(yyyymm);
##
##  ߂l
##  ̌̓
	
	local($cl_mday) = @_;
	
	local($cl_yr) = substr($cl_mday,0,4);
	local($cl_mn) = substr($cl_mday,4,2);
	
	if (($cl_yr % 4 == 0) && (($cl_yr % 100 != 0) || ($cl_yr % 400 == 0))) {
		@cl_alg  = (31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
	} else {
		@cl_alg  = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
	}
	local($cl2_mn) = $cl_mn - 1;
	local($x_rslt) = $cl_alg[$cl2_mn];
	
	return ($x_rslt);
	
}
##====================================================================
##wNtԂ(L:1980`2099N)
##====================================================================
sub getspring {
##
##  : yyyy
##  2003NȂ2003Ƃ
##
##  gp
##  &calendlib'getspring(yyyy);
##
##  ߂l
##  t̓(LԔ͈͊O0Ԃ)
##
	
	local($cl_spring) = @_;
	$cl_spring = int($cl_spring);
	
	local($x_spring) = 0;
	$x_spring=int(20.8431+0.242194*($cl_spring-1980)-int(($cl_spring-1980)/4));
	
	if (($cl_spring < 1980) || ($cl_spring > 2099)) { $x_spring = 0; }
	
	return ($x_spring);
	
}
##====================================================================
##wNHԂ(L:1980`2099N)
##====================================================================
sub getautmn {
##
##  : yyyy
##  2003NȂ2003Ƃ
##
##  gp
##  &calendlib'getautmn(yyyy);
##
##  ߂l
##  H̓(LԔ͈͊O0Ԃ)
##
	
	local($cl_autmn) = @_;
	$cl_autmn = int($cl_autmn);
	
	local($x_autmn) = 0;
	$x_autmn=int(23.2488+0.242194*($cl_autmn-1980)-int(($cl_autmn-1980)/4));
	
	if (($cl_autmn < 1980) || ($cl_autmn > 2099)) { $x_autmn = 0; }
	
	return ($x_autmn);
	
}
##====================================================================
##wNO̓tԂ
##====================================================================
sub getyesterday {
##
##  : yyyymmdd
##  2003N49Ȃ20030409Ƃ
##
##  gp
##  &calendlib'getyesterday(yyyymmdd);
##
##  ߂l
##  20030408 ̑OlԂ
##
	
	local($cl_before) = @_;
	
	local($cl_byr) = substr($cl_before,0,4);
	local($cl_bmn) = substr($cl_before,4,2);
	local($cl_bdy) = substr($cl_before,6,2);
	$cl_byr = int($cl_byr);
	$cl_bmn = int($cl_bmn);
	$cl_bdy = int($cl_bdy);
	
	local($x_bbis) = 0;
	if (($cl_byr % 4 == 0) && (($cl_byr % 100 != 0) || ($cl_bis % 400 == 0))) {
		$x_bbis = 1;
	}
	
	local($yr_brslt) = "";
	local($mn_brslt) = "";
	local($dy_brslt) = "";
	
	if ($x_bbis==1) {
		if (($cl_bmn == 1)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr-1; $mn_brslt=12; $dy_brslt=31; }
		elsif (($cl_bmn == 2)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=1; $dy_brslt=31; }
		elsif (($cl_bmn == 3)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=2; $dy_brslt=29; }
		elsif (($cl_bmn == 4)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=3; $dy_brslt=31; }
		elsif (($cl_bmn == 5)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=4; $dy_brslt=30; }
		elsif (($cl_bmn == 6)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=5; $dy_brslt=31; }
		elsif (($cl_bmn == 7)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=6; $dy_brslt=30; }
		elsif (($cl_bmn == 8)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=7; $dy_brslt=31; }
		elsif (($cl_bmn == 9)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=8; $dy_brslt=31; }
		elsif (($cl_bmn == 10)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=9; $dy_brslt=30; }
		elsif (($cl_bmn == 11)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=10; $dy_brslt=31; }
		elsif (($cl_bmn == 12)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=11; $dy_brslt=30; }
		else { $yr_brslt=$cl_byr; $mn_brslt=$cl_bmn; $dy_brslt=$cl_bdy-1; }
	} else {
		if (($cl_bmn == 1)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr-1; $mn_brslt=12; $dy_brslt=31; }
		elsif (($cl_bmn == 2)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=1; $dy_brslt=31; }
		elsif (($cl_bmn == 3)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=2; $dy_brslt=28; }
		elsif (($cl_bmn == 4)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=3; $dy_brslt=31; }
		elsif (($cl_bmn == 5)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=4; $dy_brslt=30; }
		elsif (($cl_bmn == 6)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=5; $dy_brslt=31; }
		elsif (($cl_bmn == 7)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=6; $dy_brslt=30; }
		elsif (($cl_bmn == 8)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=7; $dy_brslt=31; }
		elsif (($cl_bmn == 9)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=8; $dy_brslt=31; }
		elsif (($cl_bmn == 10)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=9; $dy_brslt=30; }
		elsif (($cl_bmn == 11)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=10; $dy_brslt=31; }
		elsif (($cl_bmn == 12)&&($cl_bdy == 1)) { $yr_brslt=$cl_byr; $mn_brslt=11; $dy_brslt=30; }
		else { $yr_brslt=$cl_byr; $mn_brslt=$cl_bmn; $dy_brslt=$cl_bdy-1; }
	}
	
	$yr_brslt = sprintf("%04d",$yr_brslt);
	$mn_brslt = sprintf("%02d",$mn_brslt);
	$dy_brslt = sprintf("%02d",$dy_brslt);
	
	local($x1_brslt) = "$yr_brslt"."$mn_brslt"."$dy_brslt";
	return ($x1_brslt);
	
}
##====================================================================
##wN藂̓tԂ
##====================================================================
sub gettomorrow {
##
##  : yyyymmdd
##  2003N49Ȃ20030409Ƃ
##
##  gp
##  &calendlib'gettomorrow(yyyymmdd);
##
##  ߂l
##  20030410 ̗lԂ
##
	
	local($cl_after) = @_;
	
	local($cl_ayr) = substr($cl_after,0,4);
	local($cl_amn) = substr($cl_after,4,2);
	local($cl_ady) = substr($cl_after,6,2);
	$cl_ayr = int($cl_ayr);
	$cl_amn = int($cl_amn);
	$cl_ady = int($cl_ady);
	
	local($x_abis) = 0;
	if (($cl_ayr % 4 == 0) && (($cl_ayr % 100 != 0) || ($cl_bis % 400 == 0))) {
		$x_abis = 1;
	}
	
	local($yr_arslt) = "";
	local($mn_arslt) = "";
	local($dy_arslt) = "";
	
	if ($x_abis==1) {
		if (($cl_amn == 1)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=2; $dy_arslt=1; }
		elsif (($cl_amn == 2)&&($cl_ady == 29)) { $yr_arslt=$cl_ayr; $mn_arslt=3; $dy_arslt=1; }
		elsif (($cl_amn == 3)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=4; $dy_arslt=1; }
		elsif (($cl_amn == 4)&&($cl_ady == 30)) { $yr_arslt=$cl_ayr; $mn_arslt=5; $dy_arslt=1; }
		elsif (($cl_amn == 5)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=6; $dy_arslt=1; }
		elsif (($cl_amn == 6)&&($cl_ady == 30)) { $yr_arslt=$cl_ayr; $mn_arslt=7; $dy_arslt=1; }
		elsif (($cl_amn == 7)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=8; $dy_arslt=1; }
		elsif (($cl_amn == 8)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=9; $dy_arslt=1; }
		elsif (($cl_amn == 9)&&($cl_ady == 30)) { $yr_arslt=$cl_ayr; $mn_arslt=10; $dy_arslt=1; }
		elsif (($cl_amn == 10)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=11; $dy_arslt=1; }
		elsif (($cl_amn == 11)&&($cl_ady == 30)) { $yr_arslt=$cl_ayr; $mn_arslt=12; $dy_arslt=1; }
		elsif (($cl_amn == 12)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr+1; $mn_arslt=1; $dy_arslt=1; }
		else { $yr_arslt=$cl_ayr; $mn_arslt=$cl_amn; $dy_arslt=$cl_ady+1; }
	} else {
		if (($cl_amn == 1)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=2; $dy_arslt=1; }
		elsif (($cl_amn == 2)&&($cl_ady == 28)) { $yr_arslt=$cl_ayr; $mn_arslt=3; $dy_arslt=1; }
		elsif (($cl_amn == 3)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=4; $dy_arslt=1; }
		elsif (($cl_amn == 4)&&($cl_ady == 30)) { $yr_arslt=$cl_ayr; $mn_arslt=5; $dy_arslt=1; }
		elsif (($cl_amn == 5)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=6; $dy_arslt=1; }
		elsif (($cl_amn == 6)&&($cl_ady == 30)) { $yr_arslt=$cl_ayr; $mn_arslt=7; $dy_arslt=1; }
		elsif (($cl_amn == 7)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=8; $dy_arslt=1; }
		elsif (($cl_amn == 8)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=9; $dy_arslt=1; }
		elsif (($cl_amn == 9)&&($cl_ady == 30)) { $yr_arslt=$cl_ayr; $mn_arslt=10; $dy_arslt=1; }
		elsif (($cl_amn == 10)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr; $mn_arslt=11; $dy_arslt=1; }
		elsif (($cl_amn == 11)&&($cl_ady == 30)) { $yr_arslt=$cl_ayr; $mn_arslt=12; $dy_arslt=1; }
		elsif (($cl_amn == 12)&&($cl_ady == 31)) { $yr_arslt=$cl_ayr+1; $mn_arslt=1; $dy_arslt=1; }
		else { $yr_arslt=$cl_ayr; $mn_arslt=$cl_amn; $dy_arslt=$cl_ady+1; }
	}
	
	$yr_arslt = sprintf("%04d",$yr_arslt);
	$mn_arslt = sprintf("%02d",$mn_arslt);
	$dy_arslt = sprintf("%02d",$dy_arslt);
	
	local($x1_arslt) = "$yr_arslt"."$mn_arslt"."$dy_arslt";
	return ($x1_arslt);
	
}
##====================================================================
1;