/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.part.EditorPart;

public class EditorPane
extends PartPane {
    private EditorStack workbook;

    public EditorPane(IEditorReference ref, WorkbenchPage page, EditorStack workbook) {
        super(ref, page);
        this.workbook = workbook;
    }

    protected IWorkbenchPart createErrorPart(IWorkbenchPart oldPart) {
        IEditorPart oldEditorPart = (IEditorPart)oldPart;
        EditorSite oldEditorSite = (EditorSite)oldEditorPart.getEditorSite();
        class ErrorEditorPart
        extends EditorPart {
            private Text text;
            final /* synthetic */ EditorPane this$0;

            ErrorEditorPart(EditorPane editorPane) {
                this.this$0 = editorPane;
            }

            public void doSave(IProgressMonitor monitor) {
            }

            public void doSaveAs() {
            }

            public void init(IEditorSite site, IEditorInput input) {
                this.setSite(site);
                this.setInput(input);
            }

            public boolean isDirty() {
                return false;
            }

            public boolean isSaveAsAllowed() {
                return false;
            }

            public void createPartControl(Composite parent) {
                this.text = new Text(parent, 74);
                this.text.setForeground(JFaceColors.getErrorText((Display)this.text.getDisplay()));
                this.text.setBackground(this.text.getDisplay().getSystemColor(22));
                this.text.setText(WorkbenchMessages.getString("EditorPane.errorMessage"));
            }

            public void setFocus() {
                if (this.text != null) {
                    this.text.setFocus();
                }
            }

            protected void setPartName(String title) {
                super.setPartName(title);
            }

            protected void setTitleToolTip(String text) {
                super.setTitleToolTip(text);
            }
        }
        ErrorEditorPart newPart = new ErrorEditorPart(this);
        newPart.setPartName(oldPart.getTitle());
        newPart.setTitleToolTip(oldPart.getTitleToolTip());
        oldEditorSite.setPart(newPart);
        newPart.init(oldEditorSite, oldEditorPart.getEditorInput());
        return newPart;
    }

    protected void createTitleBar() {
    }

    public void doHide() {
        this.getPage().closeEditor(this.getEditorReference(), true);
    }

    public IEditorReference getEditorReference() {
        return (IEditorReference)this.getPartReference();
    }

    int getStyle() {
        return 0;
    }

    public EditorStack getWorkbook() {
        return this.workbook;
    }

    protected void requestActivation() {
        if (!this.workbook.isActiveWorkbook()) {
            this.workbook.getEditorArea().setActiveWorkbook(null, false);
        }
        super.requestActivation();
    }

    public void setWorkbook(EditorStack editorWorkbook) {
        this.workbook = editorWorkbook;
    }

    void shellActivated() {
    }

    void shellDeactivated() {
    }

    public void setFocus() {
        super.setFocus();
        this.workbook.becomeActiveWorkbook(true);
    }

    public void showFocus(boolean inFocus) {
        if (inFocus) {
            this.workbook.becomeActiveWorkbook(true);
        } else {
            this.workbook.setActive(this.workbook.isActiveWorkbook() ? 2 : 0);
        }
    }

    protected void addPinEditorItem(Menu parent) {
        boolean reuseEditor = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
        if (!reuseEditor) {
            return;
        }
        IWorkbenchPart part = this.getPartReference().getPart(false);
        if (part == null) {
            return;
        }
        final MenuItem item = new MenuItem(parent, 32);
        item.setText(WorkbenchMessages.getString("EditorPane.pinEditor"));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPart part = EditorPane.this.getPartReference().getPart(true);
                if (part == null) {
                    item.setSelection(false);
                    item.setEnabled(false);
                } else {
                    ((EditorSite)part.getSite()).setReuseEditor(!item.getSelection());
                }
            }
        });
        item.setEnabled(true);
        item.setSelection(!((EditorSite)part.getSite()).getReuseEditor());
    }

    public void updateTitles() {
    }

    public void testInvariants() {
        super.testInvariants();
        if (this.getContainer() != null) {
            Assert.isTrue((this.getContainer() == this.workbook ? 1 : 0) != 0);
        }
    }

    public String getName() {
        return null;
    }

    public Control getToolBar() {
        return null;
    }
}

