/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.ui.commands.IKeyConfiguration;
import org.eclipse.ui.commands.IKeyConfigurationListener;
import org.eclipse.ui.commands.KeyConfigurationEvent;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.internal.util.Util;

final class KeyConfiguration
implements IKeyConfiguration {
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL;
    private boolean active;
    private boolean defined;
    private String description;
    private transient int hashCode;
    private transient boolean hashCodeComputed;
    private String id;
    private List keyConfigurationListeners;
    private Set keyConfigurationsWithListeners;
    private String name;
    private String parentId;
    private transient String string;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.KeyConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        HASH_INITIAL = clazz.getName().hashCode();
    }

    KeyConfiguration(Set keyConfigurationsWithListeners, String id) {
        if (keyConfigurationsWithListeners == null || id == null) {
            throw new NullPointerException();
        }
        this.keyConfigurationsWithListeners = keyConfigurationsWithListeners;
        this.id = id;
    }

    public void addKeyConfigurationListener(IKeyConfigurationListener keyConfigurationListener) {
        if (keyConfigurationListener == null) {
            throw new NullPointerException();
        }
        if (this.keyConfigurationListeners == null) {
            this.keyConfigurationListeners = new ArrayList();
        }
        if (!this.keyConfigurationListeners.contains(keyConfigurationListener)) {
            this.keyConfigurationListeners.add(keyConfigurationListener);
        }
        this.keyConfigurationsWithListeners.add(this);
    }

    public int compareTo(Object object) {
        KeyConfiguration castedObject = (KeyConfiguration)object;
        int compareTo = Util.compare(this.active, castedObject.active);
        if (compareTo == 0 && (compareTo = Util.compare(this.defined, castedObject.defined)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.description), (Comparable)((Object)castedObject.description))) == 0 && (compareTo = Util.compare((Comparable)((Object)this.id), (Comparable)((Object)castedObject.id))) == 0 && (compareTo = Util.compare((Comparable)((Object)this.name), (Comparable)((Object)castedObject.name))) == 0) {
            compareTo = Util.compare((Comparable)((Object)this.parentId), (Comparable)((Object)castedObject.parentId));
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyConfiguration)) {
            return false;
        }
        KeyConfiguration castedObject = (KeyConfiguration)object;
        boolean equals = true;
        equals &= Util.equals(this.active, castedObject.active);
        equals &= Util.equals(this.defined, castedObject.defined);
        equals &= Util.equals(this.description, castedObject.description);
        equals &= Util.equals(this.id, castedObject.id);
        equals &= Util.equals(this.name, castedObject.name);
        return equals &= Util.equals(this.parentId, castedObject.parentId);
    }

    void fireKeyConfigurationChanged(KeyConfigurationEvent keyConfigurationEvent) {
        if (keyConfigurationEvent == null) {
            throw new NullPointerException();
        }
        if (this.keyConfigurationListeners != null) {
            int i = 0;
            while (i < this.keyConfigurationListeners.size()) {
                ((IKeyConfigurationListener)this.keyConfigurationListeners.get(i)).keyConfigurationChanged(keyConfigurationEvent);
                ++i;
            }
        }
    }

    public String getDescription() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException("Cannot get the description from an undefined key configuration.");
        }
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getName() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException("Cannot get name from an undefined key configuration.");
        }
        return this.name;
    }

    public String getParentId() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException("Cannot get the parent id from an undefined key configuration.");
        }
        return this.parentId;
    }

    public int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = HASH_INITIAL;
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.active);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.defined);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.description);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.id);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.name);
            this.hashCode = this.hashCode * 89 + Util.hashCode(this.parentId);
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public void removeKeyConfigurationListener(IKeyConfigurationListener keyConfigurationListener) {
        if (keyConfigurationListener == null) {
            throw new NullPointerException();
        }
        if (this.keyConfigurationListeners != null) {
            this.keyConfigurationListeners.remove(keyConfigurationListener);
        }
        if (this.keyConfigurationListeners.isEmpty()) {
            this.keyConfigurationsWithListeners.remove(this);
        }
    }

    boolean setActive(boolean active) {
        if (active != this.active) {
            this.active = active;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDefined(boolean defined) {
        if (defined != this.defined) {
            this.defined = defined;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setDescription(String description) {
        if (!Util.equals(description, this.description)) {
            this.description = description;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setName(String name) {
        if (!Util.equals(name, this.name)) {
            this.name = name;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    boolean setParentId(String parentId) {
        if (!Util.equals(parentId, this.parentId)) {
            this.parentId = parentId;
            this.hashCodeComputed = false;
            this.hashCode = 0;
            this.string = null;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(this.active);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.parentId);
            stringBuffer.append(']');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }
}

