/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.lucene.document.Field;

public final class Document
implements Serializable {
    List fields = new Vector();
    private float boost = 1.0f;

    public void setBoost(float boost) {
        this.boost = boost;
    }

    public float getBoost() {
        return this.boost;
    }

    public final void add(Field field) {
        this.fields.add(field);
    }

    public final void removeField(String name) {
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            Field field = (Field)it.next();
            if (!field.name().equals(name)) continue;
            it.remove();
            return;
        }
    }

    public final void removeFields(String name) {
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            Field field = (Field)it.next();
            if (!field.name().equals(name)) continue;
            it.remove();
        }
    }

    public final Field getField(String name) {
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = (Field)this.fields.get(i);
            if (!field.name().equals(name)) continue;
            return field;
        }
        return null;
    }

    public final String get(String name) {
        Field field = this.getField(name);
        if (field != null) {
            return field.stringValue();
        }
        return null;
    }

    public final Enumeration fields() {
        return ((Vector)this.fields).elements();
    }

    public final Field[] getFields(String name) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = (Field)this.fields.get(i);
            if (!field.name().equals(name)) continue;
            result.add(field);
        }
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new Field[result.size()]);
    }

    public final String[] getValues(String name) {
        Field[] namedFields = this.getFields(name);
        if (namedFields == null) {
            return null;
        }
        String[] values = new String[namedFields.length];
        for (int i = 0; i < namedFields.length; ++i) {
            values[i] = namedFields[i].stringValue();
        }
        return values;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Document<");
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = (Field)this.fields.get(i);
            buffer.append(field.toString());
            if (i == this.fields.size() - 1) continue;
            buffer.append(" ");
        }
        buffer.append(">");
        return buffer.toString();
    }
}

