/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.audiotools;

import java.io.File;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audio.AudioFormat;
import org.jpn.xucker.rcp.audiotools.formats.AC3Format;
import org.jpn.xucker.rcp.audiotools.formats.DefaultFormat;
import org.jpn.xucker.rcp.audiotools.formats.MP2Format;
import org.jpn.xucker.rcp.audiotools.formats.MP3Format;
import org.jpn.xucker.rcp.audiotools.formats.OggFormat;
import org.jpn.xucker.rcp.audiotools.formats.SWFFormat;
import org.jpn.xucker.rcp.audiotools.formats.ThreeGPFormat;
import org.jpn.xucker.rcp.audiotools.formats.WavFormat;
import org.osgi.framework.BundleContext;

public class AudioToolsPlugin
extends AbstractUIPlugin {
    private static AudioToolsPlugin plugin;
    private ResourceBundle resourceBundle;
    private AudioFormat[] audioFormats;
    public static String SNACKEXECUTER_DIR;
    AudioConverter[] audioConverters;

    static {
        SNACKEXECUTER_DIR = "snackexecuter_dir";
    }

    public AudioFormat[] getAudioFormats() {
        return this.audioFormats;
    }

    public void setAudioFormats(AudioFormat[] audioFormats) {
        this.audioFormats = audioFormats;
    }

    public File getSpectrogramDirectory() {
        File workbench = new File(Platform.getInstanceLocation().getURL().toString().substring(5));
        File dir = new File(workbench, "spectrogram");
        dir.mkdir();
        return dir;
    }

    private File toPluginDir(AbstractUIPlugin plugin) {
        return new File(Platform.getInstallLocation().getURL().getPath(), "plugins/" + plugin.getBundle().getSymbolicName() + "_" + plugin.getBundle().getHeaders().get("Bundle-Version"));
    }

    public AudioToolsPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.jpn.xucker.rcp.audiotools.AudiotoolsPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault("spectrogram.initialZoom", "1");
        this.getPreferenceStore().setDefault("spectrogram.jpeg_quality", 50);
        ArrayList<DefaultFormat> arrayList = new ArrayList<DefaultFormat>();
        arrayList.add(new AC3Format());
        arrayList.add(new MP2Format());
        arrayList.add(new MP3Format());
        arrayList.add(new SWFFormat());
        arrayList.add(new ThreeGPFormat());
        arrayList.add(new WavFormat());
        arrayList.add(new OggFormat());
        this.audioFormats = arrayList.toArray(new AudioFormat[arrayList.size()]);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static AudioToolsPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AudioToolsPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public AudioConverter[] getAudioConverters() {
        return this.audioConverters;
    }

    public void init() {
        try {
            this.audioConverters = this.searchAudioConverter();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private AudioConverter[] searchAudioConverter() throws CoreException {
        ArrayList<AudioConverter> dictionaries = new ArrayList<AudioConverter>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.jpn.xucker.rcp.audiotools.audiotool");
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if ("audioconverter".equals(elements[j].getName())) {
                    AudioConverter dictionary = (AudioConverter)elements[j].createExecutableExtension("class");
                    dictionaries.add(dictionary);
                }
                ++j;
            }
            ++i;
        }
        AudioConverter[] result = new AudioConverter[dictionaries.size()];
        dictionaries.toArray(result);
        return result;
    }
}

