/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.audio;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.sampled.convert.PCM2PCMConversionProvider;
import org.tritonus.sampled.convert.SampleRateConversionProvider;

public class AudioUtils {
    public static AudioInputStream convert(AudioFormat targetFormat, AudioInputStream input) {
        return AudioUtils.convert(input, targetFormat.getSampleRate(), targetFormat.getSampleSizeInBits(), targetFormat.getChannels(), targetFormat.isBigEndian());
    }

    public static AudioInputStream convert(AudioInputStream input, float sampleRate, int samplebit, int channel, boolean bigEndian) {
        AudioFormat targetFormat;
        AudioFormat sourceFormat;
        SampleRateConversionProvider provider = new SampleRateConversionProvider();
        PCM2PCMConversionProvider pcmConverter = new PCM2PCMConversionProvider();
        AudioFormat format = input.getFormat();
        AudioInputStream result = input;
        if (format.getChannels() != channel) {
            sourceFormat = result.getFormat();
            targetFormat = new AudioFormat(sourceFormat.getEncoding(), sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits(), channel, AudioUtils.calculateFrameSize(channel, sourceFormat.getSampleSizeInBits()), sourceFormat.getFrameRate(), sourceFormat.isBigEndian());
            result = pcmConverter.getAudioInputStream(targetFormat, result);
        }
        if (format.getSampleRate() != sampleRate) {
            sourceFormat = result.getFormat();
            targetFormat = new AudioFormat(sourceFormat.getEncoding(), sampleRate, sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getFrameSize(), sampleRate, sourceFormat.isBigEndian());
            result = provider.getAudioInputStream(targetFormat, result);
        }
        if (format.isBigEndian() != bigEndian || samplebit != format.getSampleSizeInBits()) {
            sourceFormat = result.getFormat();
            targetFormat = new AudioFormat(sourceFormat.getEncoding(), sourceFormat.getSampleRate(), samplebit, sourceFormat.getChannels(), AudioUtils.calculateFrameSize(sourceFormat.getChannels(), samplebit), sourceFormat.getFrameRate(), bigEndian);
            result = pcmConverter.getAudioInputStream(targetFormat, result);
        }
        return result;
    }

    private static int calculateFrameSize(int nChannels, int nSampleSizeInBits) {
        return (nSampleSizeInBits + 7) / 8 * nChannels;
    }
}

