/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.swt.series.wfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.ArrayUtils;
import org.jpn.xucker.commons.swt.series.ResultData;

public abstract class WrapperExecuter {
    protected File output;
    protected List fileList = new Vector();
    protected String commandPath = "";
    protected String[] allowExtension;
    protected String outputExtension;
    protected List resultVector = new Vector();
    protected boolean isDebug;
    protected boolean isPrint;
    protected boolean isShowOnly;
    protected Hashtable valueHash = new Hashtable();
    protected String[] resultLabel;

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public boolean isPrint() {
        return this.isPrint;
    }

    public void setPrint(boolean isPrint) {
        this.isPrint = isPrint;
    }

    public boolean isShowOnly() {
        return this.isShowOnly;
    }

    public void setShowOnly(boolean isShowOnly) {
        this.isShowOnly = isShowOnly;
    }

    public void setValue(String name, String value) {
        this.valueHash.put(name, value);
    }

    public void setValue(String name, int value) {
        this.valueHash.put(name, "" + value);
    }

    public String getValue(String name) {
        return (String)this.valueHash.get(name);
    }

    public String getCommandPath() {
        return this.commandPath;
    }

    public void setCommandPath(String commandPath) {
        this.commandPath = commandPath;
    }

    public void addFile(String path) {
        this.fileList.add(path);
    }

    public void execute() throws IOException {
        if (this.commandPath == null) {
            throw new IOException("command file not exsits :" + this.commandPath);
        }
        File f = new File(this.commandPath);
        if (!f.exists()) {
            throw new IOException("command file not exsits :" + this.commandPath);
        }
        String[] paths = this.fileList.toArray(new String[this.fileList.size()]);
        int i = 0;
        while (i < paths.length) {
            this.preExecute(new File(paths[i]));
            ++i;
        }
    }

    private void preExecute(File file) {
        if (this.output != null) {
            String rootFolder = this.toEndsWithFileSeparator(file.getParent());
            this.doExecute(rootFolder, this.output, file);
        } else {
            this.doExecute(null, null, file);
        }
    }

    private String toEndsWithFileSeparator(String parent) {
        if (!parent.endsWith(System.getProperty("file.separator"))) {
            return String.valueOf(parent) + System.getProperty("file.separator");
        }
        return parent;
    }

    protected void doExecute(String rootFolder, File outputDir, File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] list = file.list();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    File listFile = new File(file, list[i]);
                    if (listFile.isDirectory() || this.isTargetExtensionFile(listFile)) {
                        this.doExecute(rootFolder, outputDir, listFile);
                    }
                    ++i;
                }
            }
        } else {
            File outputFile = null;
            outputFile = outputDir != null ? this.toOutputFile(new File(outputDir, this.getRelativePath(file, rootFolder))) : this.toOutputFile(file);
            this.callCommand(file, outputFile);
            ResultData result = new ResultData();
            this.setResultValue(result, rootFolder, outputDir, file, outputFile);
            if (result.isValid()) {
                this.resultVector.add(result);
            }
        }
    }

    public ResultData[] getResultData() {
        return this.resultVector.toArray(new ResultData[this.resultVector.size()]);
    }

    protected abstract void setResultValue(ResultData var1, String var2, File var3, File var4, File var5);

    protected String getRelativePath(File file, String basePath) {
        if (!file.getAbsolutePath().startsWith(basePath)) {
            throw new RuntimeException("not start basePath");
        }
        if (!basePath.endsWith(System.getProperty("file.separator"))) {
            throw new RuntimeException("basepath not ends with file separator");
        }
        if (file.isDirectory()) {
            throw new RuntimeException("file is must file");
        }
        return file.getAbsolutePath().substring(basePath.length());
    }

    public File toOutputFile(File file) {
        if (this.outputExtension == null) {
            return file;
        }
        String extension = this.outputExtension;
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        File resultFile = null;
        int index = file.getName().lastIndexOf(".");
        if (index != -1) {
            resultFile = new File(file.getParent(), String.valueOf(file.getName().substring(0, index)) + extension);
        }
        return resultFile;
    }

    protected boolean isTargetExtensionFile(File tmp) {
        if (this.allowExtension == null) {
            return true;
        }
        int i = 0;
        while (i < this.allowExtension.length) {
            if (tmp.getName().toLowerCase().endsWith(this.allowExtension[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void callCommand(File inputFile, File outputFile) {
        Runtime runtime = Runtime.getRuntime();
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
        }
        String[] args = this.createArgs(inputFile, outputFile);
        try {
            if (this.isPrint) {
                this.printArgs(args);
            }
            if (!this.isShowOnly) {
                Process process = runtime.exec(args);
                if (this.isDebug) {
                    System.out.println("[log]");
                    System.out.println(WrapperExecuter.readAll(process.getInputStream()));
                }
                process.waitFor();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract String[] createArgs(File var1, File var2);

    public static String readAll(InputStream reader) {
        StringBuffer text = new StringBuffer();
        try {
            int c;
            while ((c = reader.read()) != -1) {
                text.append((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text.toString();
    }

    protected boolean isTrueValue(String key) {
        String value;
        return this.valueHash.get(key) != null && (value = (String)this.valueHash.get(key)).equals("true");
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public void setResultLabel(String[] labels) {
        this.resultLabel = (String[])ArrayUtils.clone((Object[])labels);
    }

    public String[] getAllowExtension() {
        return (String[])ArrayUtils.clone((Object[])this.allowExtension);
    }

    public void setAllowExtension(String[] allowExtension) {
        this.allowExtension = (String[])ArrayUtils.clone((Object[])allowExtension);
    }

    public String getOutputExtension() {
        return this.outputExtension;
    }

    public void setOutputExtension(String outputExtension) {
        this.outputExtension = outputExtension;
    }

    public String[] getResultLabel() {
        return (String[])ArrayUtils.clone((Object[])this.resultLabel);
    }

    protected void printArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            System.out.print(String.valueOf(args[i]) + " ");
            ++i;
        }
        System.out.println();
    }
}

