/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.ui;

import java.util.List;
import java.util.Vector;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jpn.xucker.rcp.ui.FileListImageStatusChangeListener;
import org.jpn.xucker.rcp.ui.FileListTable;
import org.jpn.xucker.rcp.ui.FileStatusChangeEvent;
import org.jpn.xucker.rcp.ui.FileStatusChangeListener;
import org.jpn.xucker.rcp.ui.ImageCanvas;

public class FileListImage
extends Canvas
implements FileStatusChangeListener {
    private List eventListener = new Vector();
    private DropTargetListener monitor = new DropMonitor();
    ImageCanvas imageCanvas;
    FileListTable fileListTable;
    StackLayout layout = new StackLayout();

    public synchronized void removeFileListImageStatusChangeListener(FileListImageStatusChangeListener listener) {
        this.eventListener.remove(listener);
    }

    public synchronized void addFileListImageStatusListener(FileListImageStatusChangeListener listener) {
        this.eventListener.add(listener);
    }

    public void fireImageMode() {
        FileListImage fileListImage = this;
        synchronized (fileListImage) {
            FileListImageStatusChangeListener[] listeners = this.eventListener.toArray(new FileListImageStatusChangeListener[this.eventListener.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].imageMode();
                ++i;
            }
        }
    }

    public void fireFileMode() {
        FileListImage fileListImage = this;
        synchronized (fileListImage) {
            FileListImageStatusChangeListener[] listeners = this.eventListener.toArray(new FileListImageStatusChangeListener[this.eventListener.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].fileMode();
                ++i;
            }
        }
    }

    public FileListTable getFileListTable() {
        return this.fileListTable;
    }

    public void setFileListTable(FileListTable fileListTable) {
        this.fileListTable = fileListTable;
    }

    public ImageCanvas getImageCanvas() {
        return this.imageCanvas;
    }

    public void setImageCanvas(ImageCanvas imageCanvas) {
        this.imageCanvas = imageCanvas;
    }

    public FileListImage(Composite arg0, int arg1) {
        super(arg0, arg1);
        this.setLayout((Layout)this.layout);
        this.fileListTable = new FileListTable((Composite)this, 0);
        this.fileListTable.addFileListChangeListener(this);
        this.imageCanvas = new ImageCanvas((Composite)this);
        this.imageMode();
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 3;
        DropTarget target2 = new DropTarget((Control)this.imageCanvas, operations);
        target2.setTransfer(types);
        target2.addDropListener((DropTargetListener)new DropMonitor());
    }

    public void setImage(Image img) {
        this.imageCanvas.setImage(img);
    }

    public void checkMode() {
        if (this.fileListTable.getFileCount() > 0) {
            this.fileMode();
        } else {
            this.imageMode();
        }
    }

    public void imageMode() {
        this.layout.topControl = this.imageCanvas;
        this.layout();
        this.fireImageMode();
    }

    public void fileMode() {
        this.layout.topControl = this.fileListTable.getTable();
        this.layout();
        this.fireFileMode();
    }

    public void removeList(FileStatusChangeEvent event) {
        this.checkMode();
    }

    public void addList(FileStatusChangeEvent event) {
    }

    public class DropMonitor
    extends DropTargetAdapter {
        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] files = (String[])event.data;
            int i = 0;
            while (i < files.length) {
                FileListImage.this.fileListTable.addDragAndDropFile(files[i]);
                ++i;
            }
            FileListImage.this.checkMode();
        }
    }
}

