/*
 * Created on 2005/04/30
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.spectrogram;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.draw2d.FileImageCache;
import org.jpn.xucker.rcp.draw2d.ScalableImageFigure;

import java.io.File;

/**
 * 
 *
 */
public class SpectrogramListFigure extends Figure implements SpectrogramDrawInfo{
public static Log log = LogFactory.getLog(SpectrogramListFigure.class);
private int samplerate=48000;
public static final int MAX_SAMPLERATE=48000;
private int baseHeight=512;
private boolean fit;
private double vzoom=1;
private double wzoom=1;


public SpectrogramListFigure(){
    FlowLayout layout=new FlowLayout(true);
    layout.setMajorSpacing(0);
    layout.setMinorSpacing(0);
    setLayoutManager(layout);
    setSize(1024,512);//TODO dummy
}

public int getBaseHeight() {
    return baseHeight;
}
public void setBaseHeight(int baseHeight) {
    this.baseHeight = baseHeight;
}
public boolean isFit() {
    return fit;
}
public void setFit(boolean fit) {
    this.fit = fit;
    //  TODO re fit all children?
}
public int getSampleRate() {
    return samplerate;

}
public void setSampleRate(int samplerate) {
    this.samplerate = samplerate;
    //  TODO re sample all children?
}

public double getVzoom() {
    return vzoom;
}
public void setVzoom(double vzoom) {
    this.vzoom = vzoom;
}
public double getWzoom() {
    return wzoom;
}
public void setWzoom(double wzoom) {
    this.wzoom = wzoom;
    IFigure[] figures=(IFigure[])getChildren().toArray(new IFigure[getChildren().size()]);
    for(int i=0;i<figures.length;i++){
        if(figures[i] instanceof ScalableImageFigure){
            ((ScalableImageFigure)figures[i]).setScale(wzoom,vzoom);
        }
    }
    revalidate();
}
public void setZoom(double w,double v){
    setVzoom(v);
    setWzoom(w);
   
    
    /*
    if(spectrogramImage!=null && !spectrogramImage.isDisposed()){
    setSize((int)(spectrogramImage.getBounds().width*wzoom),(int)(baseHeight*vzoom));
    }*/
    
    //TODO resize all children?
}

public void paintFigure(Graphics g){
    log.trace("paintFigure:"+getClientArea());
    
   // g.setBackgroundColor(ColorConstants.red);
    //g.fillRectangle(0,0,100,100);
    //Rectangle clientArea = getClientArea();
    
   // System.out.println(this.getClientArea());
 //   System.out.println(this.getSize());
    /*
    if(spectrogramImage!=null && !spectrogramImage.isDisposed()){
         
        if(fit){
            g.drawImage(spectrogramImage,0,0,spectrogramImage.getBounds().width,spectrogramImage.getBounds().height,clientArea.x,clientArea.y,this.getSize().width,this.getSize().height);
                
        }else{
            int drawHeight=(int)(samplerate*baseHeight*vzoom/MAX_SAMPLERATE);
           // System.out.println(drawHeight);
            g.drawImage(spectrogramImage,0,0,spectrogramImage.getBounds().width,spectrogramImage.getBounds().height,clientArea.x,clientArea.y+clientArea.height-drawHeight,this.getSize().width,drawHeight);
        }
        }
    */
    }
/**
 * @param imageWidth
 * @param compositeHeight
 * @param i
 * remove all children figure & resize figure.
 */
public void init(int imageWidth, int compositeHeight, int pixelSize,FileImageCache imageCache,File baseFolder) {
    this.removeAll();
    baseHeight=compositeHeight;
    int figureSize=pixelSize/imageWidth;
    log.trace("pixelSize = "+pixelSize+",imageWidth="+imageWidth);
    if(pixelSize%imageWidth>0){
        figureSize++;//???
    }
    log.trace("image-Figure-Size:"+figureSize);
    for(int i=0;i<figureSize;i++){
        SpectrogramFigure scalableImageFigure=new SpectrogramFigure(this,imageCache,new File(baseFolder,toLabel(i)+".gif").getAbsolutePath(),imageWidth,compositeHeight);
        scalableImageFigure.setScale(wzoom,vzoom);
        add(scalableImageFigure);
    }
    
    this.revalidate();
}

public String toLabel(int v){
    int k=5;
    String ret=""+v;
    while(ret.length()<k){
        ret="0"+ret;
    }
    return ret;
}

}
