package org.jpn.xucker.rcp.audiotools.spectrogram;

import org.eclipse.jface.preference.*;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;

import org.jpn.xucker.rcp.ui.SliderFieldEditor;

import org.eclipse.jface.preference.IPreferenceStore;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */


public class SpectrogramPage
	extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage {
	public static final String INITIAL_ZOOM = "spectrogram.initialZoom";
	public static final String JPEG_QUALITY = "spectrogram.jpeg_quality";
	

	public static final int defaultJpegQuality=50;
	public SpectrogramPage() {
		super(GRID);
		setPreferenceStore(AudioToolsPlugin.getDefault().getPreferenceStore());
		setDescription("Spectrogram Setting");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		
		
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */
	

    protected void createFieldEditors() {
    
        addField(new RadioGroupFieldEditor(
		        INITIAL_ZOOM,
				"initial_zoom", //$NON-NLS-1$
				4,
				new String[][] { {"1/16","0.0625"},{"1/8","0.125"},{"1/4","0.25"},{"1/2","0.5"},{"1","1"},{"2","2"},{"4","4"},{"8","8"}
			}, getFieldEditorParent()));
        
        
        FieldEditor editor=new SliderFieldEditor(
                JPEG_QUALITY,
    			"jpeg_quality(if you use high-quality,a file will be bigger than PNG)", //$NON-NLS-1$
    			
    		 getFieldEditorParent(),1,100,defaultJpegQuality);
        
        addField(editor);
        
    }
	
	public void init(IWorkbench workbench) {
	}
}