/*
 * Created on 2005/04/07
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.views;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audio.AudioFormat;
import org.jpn.xucker.rcp.audio.AudioSetting;
import org.jpn.xucker.rcp.audio.AudioUtils;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.jpn.xucker.rcp.audiotools.Messages;
import org.jpn.xucker.rcp.audiotools.ffmpeg.FFMpegPage;
import org.jpn.xucker.rcp.audiotools.formats.DefaultFormat;
import org.jpn.xucker.rcp.mediainfo.AudioInfo;
import org.jpn.xucker.rcp.mediainfo.Info;
import org.jpn.xucker.rcp.mediainfo.MediaInfoParser;
import org.jpn.xucker.rcp.mediainfo.MediaInfoRcpPlugin;



import org.jpn.xucker.rcp.ui.FileDirChoicer;
import org.jpn.xucker.rcp.ui.FileOverwriteControler;
import org.jpn.xucker.rcp.ui.FileStatusChangeEvent;
import org.jpn.xucker.rcp.ui.FileStatusChangeListener;

import java.io.File;
import java.io.IOException;

/**
 * 
 *
 */
public class SimpleConvertView  extends ViewPart {
public static Log log=LogFactory.getLog(SimpleConvertView.class);
public static String ID_VIEW=SimpleConvertView.class.getName();
private Button convertButton;
private CCombo toolSelect;
private FileDirChoicer input;
private FileDirChoicer output;
private CCombo sampleRateCombo;
private CCombo bitRateCombo;
private Label bitrateLabel;
private Button sameInput;

private AudioSetting inputSetting;

private AudioFormat exportFormat=null;

private List quickButtonList=new ArrayList();
/* (non-Javadoc)
 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
 */
public void createPartControl(Composite parent) {
    // TODO Auto-generated method stub
    ListCheck listCheck=new ListCheck();
    
    parent.setLayout(new GridLayout());
    Composite topComposite=new Composite(parent,SWT.NULL);
    topComposite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    topComposite.setLayout(new GridLayout(2,false));
    
    
    Composite buttonComposite=new Composite(topComposite,SWT.NULL);
    buttonComposite.setLayout(new GridLayout(1,false));
    GridData bt=new GridData();
    bt.verticalSpan=2;
    buttonComposite.setLayoutData(bt);
    
    
    
    convertButton = new Button(buttonComposite,SWT.NULL);
    convertButton.setText(Messages.getString("convert")); //$NON-NLS-1$
    convertButton.setEnabled(false);
    convertButton.addSelectionListener(new CheckConvert());
    GridData cb=new GridData(GridData.FILL_VERTICAL);
    cb.widthHint=100;
    cb.heightHint=100;
    convertButton.setLayoutData(cb);
    
    buttonComposite.setToolTipText(Messages.getString("if_cant_convert"));
    
    toolSelect = new CCombo(buttonComposite,SWT.READ_ONLY);
    toolSelect.setEnabled(false);
    GridData ts=new GridData(GridData.FILL_VERTICAL);
    ts.widthHint=100;
    toolSelect.setLayoutData(ts);
    
    Group g1=new Group(topComposite,SWT.NULL);
    g1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    g1.setText(Messages.getString("inputfile")); //$NON-NLS-1$
    g1.setLayout(new GridLayout());
    input = new FileDirChoicer(g1,SWT.NULL,FileDirChoicer.FILE,"",false); //$NON-NLS-1$
    input.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    input.addFileListChangeListener(listCheck);
    input.setBrowseButtonText(Messages.getString("inputfile_browse"));
    input.pack();
    Group g2=new Group(topComposite,SWT.NULL);
    
    /*
    Composite composite=new Composite(parent,SWT.NULL);
    composite.setLayout(new GridLayout(2,false));
    */
    
    g2.setText(Messages.getString("outputfile")); //$NON-NLS-1$
    g2.setLayout(new GridLayout());
    g2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    Composite quickButtonComposite=new Composite(g2,SWT.NULL);
    
    
    output = new FileDirChoicer(g2,SWT.NULL,FileDirChoicer.SAVE,null,true);
    output.addFileListChangeListener(listCheck);
    output.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    output.setBrowseButtonText(Messages.getString("outputfile_browse"));
    output.layout();
    
    quickButtonComposite.setLayout(new RowLayout());
    quickButtonComposite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
    
    Image quickImage=ImageDescriptor.createFromURL(AudioToolsPlugin.getDefault().find(new Path("icons/quick.png"))).createImage(); //$NON-NLS-1$
    Label quickLabel=new Label(quickButtonComposite,SWT.NULL);
    quickLabel.setImage(quickImage);
    
    QuickChange quickChange=new QuickChange();
    
    Button wavButton=new Button(quickButtonComposite,SWT.NULL);
    wavButton.setText("wav");
    wavButton.setEnabled(false);
    wavButton.addSelectionListener(quickChange);
    quickButtonList.add(wavButton);
    
    Button mp3Button=new Button(quickButtonComposite,SWT.NULL);
    mp3Button.setText("mp3");
    mp3Button.setEnabled(false);
    mp3Button.addSelectionListener(quickChange);
    quickButtonList.add(mp3Button);
    
    Button oggButton=new Button(quickButtonComposite,SWT.NULL);
    oggButton.setText("ogg");
    oggButton.setEnabled(false);
    oggButton.addSelectionListener(quickChange);
    quickButtonList.add(oggButton);
    
    Button mp2Button=new Button(quickButtonComposite,SWT.NULL);
    mp2Button.setText("mp2");
    mp2Button.setEnabled(false);
    mp2Button.addSelectionListener(quickChange);
    quickButtonList.add(mp2Button);
    
    Button threegpButton=new Button(quickButtonComposite,SWT.NULL);
    threegpButton.setText("3gp");
    threegpButton.setEnabled(false);
    threegpButton.addSelectionListener(quickChange);
    quickButtonList.add(threegpButton);
    
    Button swfButton=new Button(quickButtonComposite,SWT.NULL);
    swfButton.setText("swf");
    swfButton.setEnabled(false);
    swfButton.addSelectionListener(quickChange);    
    quickButtonList.add(swfButton);
    
    sameInput = new Button(parent,SWT.CHECK);
    sameInput.setSelection(true);
    sameInput.setText(Messages.getString("use_input_setting")); //$NON-NLS-1$
    sameInput.addSelectionListener(new SettingCheck());
    sameInput.setEnabled(false);
    
    
    //output..
    Composite setOutputComposite=new Composite(parent,SWT.NULL);
    setOutputComposite.setLayout(new GridLayout(2,true));
    
    //bitrate 
    bitrateComposite = new Composite(setOutputComposite,SWT.NULL);
    bitrateComposite.setLayout(new GridLayout(2,false));
    bitrateLabel = new Label(bitrateComposite,SWT.NULL);
    bitrateLabel.setText(Messages.getString("bitrate")); //$NON-NLS-1$
    bitRateCombo = new CCombo(bitrateComposite,SWT.READ_ONLY);
    
    
    //sample rate
    sampleRateComposite = new Composite(setOutputComposite,SWT.NULL);
    sampleRateComposite.setLayout(new GridLayout(2,false));
    sampleRateLabel = new Label(sampleRateComposite,SWT.NULL);
    sampleRateLabel.setText(Messages.getString("samplerate")); //$NON-NLS-1$
    sampleRateCombo = new CCombo(sampleRateComposite,SWT.READ_ONLY);
    
    //sample bit
    sampleBitComposite = new Composite(setOutputComposite,SWT.NULL);
    sampleBitComposite.setLayout(new GridLayout(2,false));
    samplebitLabel = new Label(sampleBitComposite,SWT.NULL);
    samplebitLabel.setText(Messages.getString("samplebit")); //$NON-NLS-1$
    sampleBitCombo = new CCombo(sampleBitComposite,SWT.READ_ONLY);

    
    //channel
    channelRateComposite = new Composite(setOutputComposite,SWT.NULL);
    channelRateComposite.setLayout(new GridLayout(3,false));
    channelLabel = new Label(channelRateComposite,SWT.NULL);
    channelLabel.setText(Messages.getString("channel")); //$NON-NLS-1$
    
    stereoButton = new Button(channelRateComposite,SWT.RADIO);
    stereoButton.setText(Messages.getString("stereo")); //$NON-NLS-1$
    monoButton = new Button(channelRateComposite,SWT.RADIO);
    monoButton.setText(Messages.getString("monoral")); //$NON-NLS-1$
    
    
    //default
    setBitrateAvailable(false);
    setSamplebitAvailable(false);
    setSampleRateAvailable(false);
    setChannelAvailable(false);
    
    //init default setting.
    initSetting();
    
    AudioToolsPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new PropertyCheck());
}


public class PropertyCheck implements IPropertyChangeListener{

    /* (non-Javadoc)
     * @see org.eclipse.jface.util.IPropertyChangeListener#propertyChange(org.eclipse.jface.util.PropertyChangeEvent)
     */
    public void propertyChange(PropertyChangeEvent event) {
        // TODO Auto-generated method stub
        log.trace("propertychange:"+event.getProperty()+","+event.getNewValue()+","+event.getOldValue());
        if(event.getProperty().equals(FFMpegPage.FFMPEG_PATH)){
            updateQuickButtons();
        }
    }
}
        
public class QuickChange implements  SelectionListener{

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetSelected(SelectionEvent e) {
        // TODO Auto-generated method stub
        Button bt=(Button)e.getSource();
        String extension=bt.getText();
        
        String path=output.getAbsoluteFilePath();
        if(path.equals("")){
            path=input.getAbsoluteFilePath();
        }
        
        changePath(path,extension);
    }

    /**
     * @param path
     */
    private void changePath(String path,String extension) {
        int last=path.lastIndexOf(".");
        if(last>=0){
        String newPath=path.substring(0,last)+"."+extension;
        output.inSetText(newPath);
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetDefaultSelected(SelectionEvent e) {
        // TODO Auto-generated method stub
        
    }
    
}
/**
 * 
 */
private void initSetting() {
    // TODO Auto-generated method stub
    if(exportFormat==null){
        exportFormat=new DefaultFormat();
    }
    
    if(exportFormat.getAvailableBitrate()!=null){
        bitRateCombo.removeAll();
        for(int i=0;i<exportFormat.getAvailableBitrate().length;i++){
            bitRateCombo.add(toBitrateLabel(exportFormat.getAvailableBitrate()[i]));
        }
       
        bitrateAvailable=true;
        bitRateCombo.select(bitRateCombo.getItemCount()-1);
    }else{
       bitrateAvailable=false;
    }
    
    if(exportFormat.getAvailableSamplebit()!=null){
        sampleBitCombo.removeAll();
        for(int i=0;i<exportFormat.getAvailableSamplebit().length;i++){
            sampleBitCombo.add(toSampleBitLabel(exportFormat.getAvailableSamplebit()[i]));
        }
        samplebitAvailable=true;
        sampleBitCombo.select(sampleBitCombo.getItemCount()-1);
    }else{
       samplebitAvailable=false;
    }
    
    if(exportFormat.getAvailableSampleRate()!=null){
        sampleRateCombo.removeAll();
        for(int i=0;i<exportFormat.getAvailableSampleRate().length;i++){
            sampleRateCombo.add(toSampleRateLabel(exportFormat.getAvailableSampleRate()[i]));
        }
        sampleRateAvailable=true;
        sampleRateCombo.select(sampleRateCombo.getItemCount()-1);
    }else{
       sampleRateAvailable=false;
    }
    
    if(exportFormat.getAvailableChannels()!=null){
        channelAvailable=true;
    }else{
        channelAvailable=false;
    }
}

/**
 * @param i
 * @return
 */
private String toSampleBitLabel(int i) {
    String label=""+i; //$NON-NLS-1$
    if(label.length()<2){
        label=" "+label; //$NON-NLS-1$
    }
    return label+" bit"; //$NON-NLS-1$
}

public void setBitrateAvailable(boolean bool){
    
    bitrateLabel.setEnabled(bool);
    bitRateCombo.setEnabled(bool);
    
}

public void setSamplebitAvailable(boolean bool){
   
        samplebitLabel.setEnabled(bool);
    sampleBitCombo.setEnabled(bool);
    
}

public void setSampleRateAvailable(boolean bool){
   
        sampleRateLabel.setEnabled(bool);
    sampleRateCombo.setEnabled(bool);
    
}
public void setChannelAvailable(boolean bool){
    channelLabel.setEnabled(bool);
    stereoButton.setEnabled(bool);
    monoButton.setEnabled(bool);
    
}


public void updateExportSetting(){
    if(sameInput.getSelection()){
        setBitrateAvailable(false);
        setSamplebitAvailable(false);
        setSampleRateAvailable(false);
        setChannelAvailable(false);   
    }else{
    setBitrateAvailable(bitrateAvailable);
    setSamplebitAvailable(samplebitAvailable);
    setSampleRateAvailable(sampleRateAvailable);
    setChannelAvailable(channelAvailable);
    }
   
}
public class SettingCheck implements SelectionListener{

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetSelected(SelectionEvent e) {
        if(sameInput.getSelection()){
            setBitrateAvailable(false);
            setSamplebitAvailable(false);
            setSampleRateAvailable(false);
            setChannelAvailable(false);
        }else{
           updateExportSetting();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetDefaultSelected(SelectionEvent e) {
        // TODO Auto-generated method stub
        
    }
    
}

private boolean bitrateAvailable=true;
private boolean samplebitAvailable=true;
private boolean sampleRateAvailable=true;
private boolean channelAvailable=true;
private Composite channelRateComposite;
private Composite sampleBitComposite;
private Composite sampleRateComposite;
private Composite bitrateComposite;
private Label samplebitLabel;
private CCombo sampleBitCombo;
private Label sampleRateLabel;
private Label channelLabel;
private Button stereoButton;
private Button monoButton;


public void updateQuickButtons(){
    if(input.getAbsoluteFilePath().length()>0){
    Button[] bts=(Button[])quickButtonList.toArray(new Button[quickButtonList.size()]);
    AudioConverter[] converters=AudioToolsPlugin.getDefault().getAudioConverters();
    String inputE = AudioUtils.getExtension(input.getAbsoluteFilePath()).toLowerCase();
    
    for (int i = 0; i < bts.length; i++) {
    boolean canconvert=false;
        String outputE=bts[i].getText();
        CONVERTER:for(int j=0;j<converters.length;j++){
            if(converters[j].canConvert(inputE,outputE)){
                canconvert=true;
                break CONVERTER;
            }
        }
        bts[i].setEnabled(canconvert);
    }
    }
}
public class ListCheck implements FileStatusChangeListener{

    private String inputExtension;
    private String outputExtension;

    /* (non-Javadoc)
     * @see org.jpn.xucker.rcp.ui.FileStatusChangeListener#removeList(org.jpn.xucker.rcp.ui.FileStatusChangeEvent)
     */
    public void removeList(FileStatusChangeEvent arg0) {
        itemChanged(arg0);
    }

    /* (non-Javadoc)
     * @see org.jpn.xucker.rcp.ui.FileStatusChangeListener#addList(org.jpn.xucker.rcp.ui.FileStatusChangeEvent)
     */
    
    private String prevOutputPath="";
    public void addList(FileStatusChangeEvent arg0) {
        itemChanged(arg0);
    }
    public void itemChanged(FileStatusChangeEvent arg0){
        
        if(arg0.item==output){
            File file=new File(output.getAbsoluteFilePath());
            if(file.exists()){
                FileOverwriteControler controler=new FileOverwriteControler(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),FileOverwriteControler.MODE_YES_NO_CANCEL);
                boolean result=controler.canOverwrite(file);
                //System.out.println(result);
                if(!result){
                    output.setFilePath(prevOutputPath);
                }
            }
            prevOutputPath=output.getAbsoluteFilePath();
        }
        
        // TODO Auto-generated method stub
        toolSelect.removeAll();
        inputExtension = AudioUtils.getExtension(input.getAbsoluteFilePath()).toLowerCase();
        outputExtension = AudioUtils.getExtension(output.getAbsoluteFilePath()).toLowerCase();
        
        if(outputExtension.length()>0){
            sameInput.setEnabled(true);
            exportFormat=findFormat(outputExtension);
            initSetting();
            updateExportSetting();
        }else{
            sameInput.setEnabled(false);
        }
        
        if(inputExtension.length()>0 && outputExtension.length()>0){
            AudioConverter[] converters=AudioToolsPlugin.getDefault().getAudioConverters();
            for(int i=0;i<converters.length;i++){
                if(converters[i].canConvert(inputExtension,outputExtension)){
                    toolSelect.add(converters[i].getName());
                }
            }
        }
        //System.out.println(inputExtension+","+outputExtension);
        if(toolSelect.getItemCount()>0 && !output.getAbsoluteFilePath().equals(input.getAbsoluteFilePath())){
            toolSelect.select(0);
            convertButton.setEnabled(true);
            toolSelect.setEnabled(true);
        }else{
            convertButton.setEnabled(false);
            toolSelect.setEnabled(false);
        }
        
        if(arg0.item==input){
            File file=new File(input.getAbsoluteFilePath());
            if(file.exists()){
            setUpInputSetting(input.getAbsoluteFilePath());
            input.getTextComposite().setBackground(new Color(null,255,255,255));
            input.getTextComposite().setToolTipText("");
            
            updateQuickButtons();
            
            
            
            }else{
                input.getTextComposite().setBackground(new Color(null,255,0,0));
                input.getTextComposite().setToolTipText("File Not Found");
            }
        }
        
        if(inputSetting!=null){
           setSettingValue();
        }
    }


    private void setSettingValue(){
        log.trace(inputSetting);
        setSettingChannel(inputSetting.getChannel());
        setSettingSampleRate(inputSetting.getSamplerate());
        setSettingSampleBit(inputSetting.getSamplebit());
        setSettingBitRate(inputSetting.getBitrate());
        
      //TODO should more better check. 
       if(toSampleRate()<32000){
            if(toBitrate()>160000){
                setSettingBitRate(160000);
            }
        }
    }

    /**
     * @param outputExtension2
     * @return
     */
    private AudioFormat findFormat(String outputExtension2) {
        
        AudioFormat[] formats=AudioToolsPlugin.getDefault().getAudioFormats();
        for(int i=0;i<formats.length;i++){
            String[] extensions=formats[i].getAvailableExtension();
            if(extensions!=null){
                for (int j = 0; j < extensions.length; j++) {
                    if(extensions[j].equals(outputExtension2)){
                        return formats[i];
                    }
                }
            }
        }
        
        return null;
    }

    /**
     * @param absoluteFilePath
     */
    private void setUpInputSetting(String absoluteFilePath) {
        // call media info.
        MediaInfoParser parser=MediaInfoRcpPlugin.getDefault().getParser();
        try {
            log.trace("mediainfo-parser:"+absoluteFilePath);
            Info infos[]=parser.parse(new File(absoluteFilePath));
            
            for(int i=0;i<infos.length;i++){
                log.trace("audio-info:"+i);
                if(infos[i] instanceof AudioInfo){
                    AudioInfo audioInfo=(AudioInfo)infos[i];
                    log.trace(audioInfo);
                    int bitrate=audioInfo.getBitrate();
                    int samplerate=audioInfo.getSamplingrate();
                    int samplebit=audioInfo.getSampleBit();//TODO must change samplebit.
                   
                    int channel=audioInfo.getChannels();
                    System.out.println("1");
                    log.trace(bitrate+","+samplerate+","+samplebit+","+channel);
                    inputSetting=new AudioSetting();
                    inputSetting.setChannel(channel);
                    inputSetting.setBitrate(bitrate);
                    inputSetting.setSamplebit(samplebit);
                    inputSetting.setSamplerate(samplerate);
                    log.trace(inputSetting);
                    
                    
                    break;
                }
            }
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        
        //set
        
    }

    /**
     * @param bitrate
     */
    private void setSettingBitRate(int bitrate) {
        if(outputExtension.equals(AudioConverter.WAV)){
            return;
        }
        
        
        int size=bitRateCombo.getItemCount();
        String label=toBitrateLabel(bitrate);
        int index=-1;
        for(int i=0;i<size;i++){
            if(label.equals(bitRateCombo.getItem(i))){
                index=i;
                break;
            }
        }
        
        if(index!=-1){
            bitRateCombo.select(index);
        }else{
            //TODO warrning.
        //warrning
            //bitRateCombo.add(label);
            //bitRateCombo.select(bitRateCombo.getItemCount()-1);//set last.
        }
        
        
    }

    /**
     * @param samplebit
     */
    private void setSettingSampleBit(int samplebit) {
      
        
        
        String label=toSampleBitLabel(samplebit);
        
        int index=-1;
        int size=sampleBitCombo.getItemCount();
        for(int i=0;i<size;i++){
            if(label.equals(sampleBitCombo.getItem(i))){
                index=i;
                break;
            }
        }
        
        if(index!=-1){
            sampleBitCombo.select(index);
        }else{
        //warrning
        
        }
    }

    /**
     * @param channel
     */
    private void setSettingChannel(int channel) {
        if(channel==1){
            monoButton.setSelection(true);
            stereoButton.setSelection(false);
        }else if(channel==2){
            stereoButton.setSelection(true);
            monoButton.setSelection(false);
        }
    }
    
    private String toSampleBitLabel(int bit){
        String label=""+"bit"; //$NON-NLS-1$ //$NON-NLS-2$
        if(label.length()<5){
            label=" "+label; //$NON-NLS-1$
        }
        return label;
    }
    
    private void setSettingSampleRate(int rate) {
        int size=sampleRateCombo.getItemCount();
        String label=toSampleRateLabel(rate);
        int index=-1;
        for(int i=0;i<size;i++){
            if(label.equals(sampleRateCombo.getItem(i))){
                index=i;
                break;
            }
        }
        
        if(index!=-1){
        sampleRateCombo.select(index);
        }else{
            //TODO warrning.or auto fix.
        //warrning
        //sampleRateCombo.add(label);
        //sampleRateCombo.select(sampleRateCombo.getItemCount()-1);//set last.
        }
    }
    
}

private String toBitrateLabel(int value){
    String label=""; //$NON-NLS-1$
    
    label=""+value; //$NON-NLS-1$
    label=label.substring(0,label.length()-3);
    while(label.length()<4){
        label=" "+label; //$NON-NLS-1$
    }
    
    label=label+" kbps"; //$NON-NLS-1$
    
    return label;
}

private String toSampleRateLabel(int value){
    String label=""; //$NON-NLS-1$
    
    label=""+value; //$NON-NLS-1$
    label=label.substring(0,label.length()-3)+"."+label.substring(label.length()-3); //$NON-NLS-1$
    if(label.length()<6){
        label=" "+label; //$NON-NLS-1$
    }
    label=label+" khz"; //$NON-NLS-1$
    
    return label;
}





public class CheckConvert implements SelectionListener{

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetSelected(SelectionEvent e) {
        // TODO Auto-generated method stub
        AudioConverter convert=null;
        AudioConverter[] converters=AudioToolsPlugin.getDefault().getAudioConverters();
        for(int i=0;i<converters.length;i++){
            if(converters[i].getName().equals(toolSelect.getItem(toolSelect.getSelectionIndex()))){
                //
                convert=converters[i];
                break;
            }
        }
        
        if(convert!=null){
            input.setEnabled(false);
            output.setEnabled(false);
            convertButton.setEnabled(false);
            toolSelect.setEnabled(false);
            
            Thread t=new ExecConvert(convert,input.getAbsoluteFilePath(),output.getAbsoluteFilePath());
            t.start();
            
          //Display.getCurrent().asyncExec();
        }
    }

    public class ExecConvert extends Thread{
        private String inputPath;
        private String outputPath;
        private AudioConverter converter;
        private AudioSetting setting;
        public ExecConvert(AudioConverter converter,String input,String output){
            inputPath=input;
            outputPath=output;
            this.converter=converter;
            setting=toSetting();
        }
        public void run(){
           
            
            
            try {
                converter.convert(new File(inputPath),new File(outputPath),setting,inputSetting);
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Enabled());
            
        }
    }
    
    public class Enabled extends Thread{
        public void run(){
            input.setEnabled(true);
            output.setEnabled(true);
            convertButton.setEnabled(true);
            toolSelect.setEnabled(true);
        }
    }
    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetDefaultSelected(SelectionEvent e) {
        // TODO Auto-generated method stub
        
    }
    
}


public int toSampleRate(){
    int result=0;
    String value=sampleRateCombo.getItem(sampleRateCombo.getSelectionIndex());
    if(value.endsWith("khz")){ //$NON-NLS-1$
        double dv=Double.parseDouble(removeWhiteSpace(value.substring(0,value.length()-3)));
       
        result=(int)(dv*1000);
    }
    return result;
}

public int toSampleBit(){
    int result=0;
    String value=sampleBitCombo.getItem(sampleBitCombo.getSelectionIndex());
    if(value.endsWith("bit")){ //$NON-NLS-1$
        
        result=Integer.parseInt(removeWhiteSpace(value.substring(0,value.length()-3)));
    }
    return result;
}

public int toBitrate(){
    int result=0;
    String value=bitRateCombo.getItem(bitRateCombo.getSelectionIndex());
    if(value.endsWith("kbps")){ //$NON-NLS-1$
        
        result=Integer.parseInt(removeWhiteSpace(value.substring(0,value.length()-4)))*1000;
    }
    return result;
}

public int toChannel(){
    int result=0;
    //channel;
    if(monoButton.getEnabled() && monoButton.getSelection()){
        result=1;
    }else if(stereoButton.getEnabled() && stereoButton.getSelection()){
        result=2;
    }
    return result;
}
public AudioSetting toSetting(){
    AudioSetting setting=null;
    if(!sameInput.getSelection()){
        setting=new AudioSetting();
        
        if(sampleRateCombo.getEnabled()){
            setting.setSamplerate(toSampleRate());
           
        }
        
        if(sampleBitCombo.getEnabled()){
            setting.setSamplebit((toSampleBit()));
        }
        
        if(bitRateCombo.getEnabled()){
            String value=bitRateCombo.getItem(bitRateCombo.getSelectionIndex());
            if(value.endsWith("kbps")){ //$NON-NLS-1$
                
                setting.setBitrate(toBitrate());
            }
        }
        
       setting.setChannel(toChannel());
    }
    return setting;
}

public String getInputType(){
    String result=null;
    
    return result;
}
public String removeWhiteSpace(String value){
    StringBuffer result=new StringBuffer();
    for (int i = 0; i < value.length(); i++) {
        if(!Character.isWhitespace(value.charAt(i))){
            result.append(value.charAt(i));
        }
    }
    return result.toString();
}


/* (non-Javadoc)
 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
 */
public void setFocus() {
    // TODO Auto-generated method stub
    
}

}
