/*
 * Created on 2004/12/08
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.snack;

import java.util.List;
import java.util.Vector;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;


public class ESPSParser extends AbstractParser{
    private String columnSeparator=",";
    public String getColumnSeparator() {
        return columnSeparator;
    }
    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }
    
    public Object parse(Reader reader) throws IOException{
        List result=new Vector();
        try {
            BufferedReader breader=new BufferedReader(reader);
            String line;
            while((line=breader.readLine())!=null){
                //System.out.println(line);
                String values[]=null;
                if(line.startsWith("(") && line.endsWith(")")){
                    //System.out.println("end");
                    values=line.substring(1,line.length()-1).split(",");
                }else{
                    values=line.split(columnSeparator);
                }
                
                    if(values!=null && values.length==4){
                        ESPS esps=new ESPS();
                        if(Double.parseDouble(values[1])==1.0){
                            esps.setVoicing(true);
                        }
                        esps.setPitch(Double.parseDouble(values[0]));
                        esps.setMeasurements(Double.parseDouble(values[2]));
                        esps.setCorrelation(Double.parseDouble(values[3]));
                        
                        result.add(esps);
                    }
                
            }
            breader.close();
        } catch (FileNotFoundException e) {
            throw e;
        } catch (IOException e) {
            throw e;
        }
       
        return result;
    }

}