/*
 * Created on 2005/04/07
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.ffmpeg;

import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

import java.util.ArrayList;
import java.util.List;

import org.jpn.xucker.rcp.audiotools.AudioConverter;
import org.jpn.xucker.rcp.audiotools.AudioSetting;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.jpn.xucker.rcp.audiotools.tools.ToolsUtil;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * 
 *
 */
public class FFMpegTools implements AudioConverter{

    public static IConsoleManager consoleManager;
    private MessageConsoleStream consoleStream;
    private MessageConsoleStream errorStream;
    private MessageConsoleStream progressStream;
    /* (non-Javadoc)
     * @see org.jpn.xucker.rcp.audiotools.AudioTool#canConvert(java.lang.String, java.lang.String)
     */
    public boolean canConvert(String input, String output) {
        String path=getFFMpegPath();
        //System.out.println("ffmpage-path:"+path);
        if(!new File(path).exists()){
            return false;
        }
        String[] canInput={AudioConverter.MP3,AudioConverter.WAV,AudioConverter.AC3,AudioConverter.MP2,AudioConverter.DTS};
        
        String[] canOutput={AudioConverter.MP3,AudioConverter.WAV,AudioConverter.AC3,AudioConverter.MP2,AudioConverter.FLV,AudioConverter.SWF,AudioConverter.THREEGP};
        // TODO Auto-generated method stub
        for(int j=0;j<canInput.length;j++){
        if(input.equals(canInput[j])){
            for (int i = 0; i < canOutput.length; i++) {
                if(output.equals(canOutput[i])){
                    return true;
                }
            }
           
        }
        }
        
        
        return false;
    }

    
    private String getFFMpegPath(){
        return AudioToolsPlugin.getDefault().getPluginPreferences().getString("ffmpegPath");
    }

    /* (non-Javadoc)
     * @see org.jpn.xucker.rcp.audiotools.AudioTool#convert(java.io.File, java.io.File)
     */
    
    public String[] toArgs(File input,File output,AudioSetting setting,AudioSetting inputSetting){
      List argList=new ArrayList();
      argList.add(getFFMpegPath());
      argList.add("-y");
      
      argList.add("-i");
      argList.add(input.getAbsolutePath());
      
      
      
          //System.out.println(""+setting.getBitrate()+","+setting.getSamplerate()+","+setting.getSamplebit()+","+setting.getChannel());
      String inputExtension=ToolsUtil.getExtension(input.getName());    
      String outputExtension=ToolsUtil.getExtension(output.getName());
          if(outputExtension.equals(AudioConverter.WAV)){
              if(setting!=null){
              if(setting.getSamplebit()==16){
                  argList.add("-acodec");
                  argList.add("pcm_s16le");
              }else if(setting.getSamplebit()==8){
                  argList.add("-acodec");
                  argList.add("pcm_u8");
              }
              
              if(setting.getChannel()>0){
                  argList.add("-ac");
                  argList.add(""+setting.getChannel());
              }
              
              if(setting.getSamplerate()>0){
                  argList.add("-ar");
                  argList.add(""+setting.getSamplerate());
              }
              }else{
                  argList.add("-acodec");
                  argList.add("pcm_s16le");
              }
          }else if(outputExtension.equals(AudioConverter.FLV) || outputExtension.equals(AudioConverter.SWF)){
              argList.add("-acodec");
              argList.add("mp3");
              
              if(setting!=null){
              if(setting.getChannel()>0){
                  argList.add("-ac");
                  argList.add(""+setting.getChannel());
              }
              
              if(setting.getSamplerate()>0){
                  argList.add("-ar");
                  argList.add(""+setting.getSamplerate());
              }
              
              if(setting.getBitrate()>0){
                  argList.add("-ab");
                  argList.add(""+setting.getBitrate()/1000);
              }
              }else{
                  System.out.println("ar:"+inputSetting.getSamplerate());
                  int ar;
                  if(inputSetting.getSamplerate()>=44100){
                      ar=44100;
                  }else if(inputSetting.getSamplerate()>=22050){
                      ar=22050;
                  }else{
                      ar=11025;
                  }
                  argList.add("-ar");
                  argList.add(""+ar);
                  
                  if(inputSetting.getBitrate()>0 && inputExtension.equals(AudioConverter.MP3)){
                      argList.add("-ab");
                      argList.add(""+inputSetting.getBitrate()/1000);
                  }
              }
          }else if(outputExtension.equals(AudioConverter.THREEGP)){
              
              argList.add("-ac");
              argList.add("1");
              
              argList.add("-ar");
              argList.add("8000");
              
              
              if(setting!=null){
              if(setting.getBitrate()>0){
                  argList.add("-ab");
                  argList.add(""+setting.getBitrate()/1000);
              }
              }
          }else if(outputExtension.equals(AudioConverter.MP2)){
              if(setting!=null){
                  if(setting.getChannel()>0){
                      argList.add("-ac");
                      argList.add(""+setting.getChannel());
                  }
                  
                  if(setting.getSamplerate()>0){
                      argList.add("-ar");
                      argList.add(""+setting.getSamplerate());
                  }
                  
                  if(setting.getBitrate()>0){
                      argList.add("-ab");
                      argList.add(""+setting.getBitrate()/1000);
                  }
                  }else{
                      argList.add("-ab");
                      argList.add(""+AudioToolsPlugin.getDefault().getPreferenceStore().getInt(FFMpegPage.MP2_DEFAULT_BITRATE));
                      int ar;
                      if(inputSetting.getSamplerate()>=48000){
                          ar=48000;
                      }else if(inputSetting.getSamplerate()>=44100){
                          ar=44100;
                      }else if(inputSetting.getSamplerate()>=32000){
                          ar=32000;
                      }else if(inputSetting.getSamplerate()>=22050){
                          ar=22050;
                      }else{
                          ar=16000;
                      }
                      argList.add("-ar");
                      argList.add(""+ar);
                  }
          }else if(outputExtension.equals(AudioConverter.AC3)){
              if(setting!=null){
                  if(setting.getChannel()>0){
                      argList.add("-ac");
                      argList.add(""+setting.getChannel());
                  }
                  
                  if(setting.getSamplerate()>0){
                      argList.add("-ar");
                      argList.add(""+setting.getSamplerate());
                  }
                  
                  if(setting.getBitrate()>0){
                      argList.add("-ab");
                      argList.add(""+setting.getBitrate()/1000);
                  }
                  }else{
                      argList.add("-ab");
                      argList.add(""+AudioToolsPlugin.getDefault().getPreferenceStore().getInt(FFMpegPage.AC3_DEFAULT_BITRATE));
                      //TODO if not sample rate.
                      int ar;
                      if(inputSetting.getSamplerate()>=48000){
                          ar=48000;
                      }else if(inputSetting.getSamplerate()>=44100){
                          ar=44100;
                      }else{
                          ar=32000;
                      }
                      argList.add("-ar");
                      argList.add(""+ar);
                  }
          }else if(outputExtension.equals(AudioConverter.MP3)){
              if(setting!=null){
                  if(setting.getChannel()>0){
                      argList.add("-ac");
                      argList.add(""+setting.getChannel());
                  }
                  
                  if(setting.getSamplerate()>0){
                      argList.add("-ar");
                      argList.add(""+setting.getSamplerate());
                  }
                  
                  if(setting.getBitrate()>0){
                      argList.add("-ab");
                      argList.add(""+setting.getBitrate()/1000);
                  }
                  }else{
                      argList.add("-ab");
                      argList.add(""+AudioToolsPlugin.getDefault().getPreferenceStore().getInt(FFMpegPage.MP3_DEFAULT_BITRATE));
                      
                  }
          }
              else{
          
              if(setting!=null){
              if(setting.getChannel()>0){
                  argList.add("-ac");
                  argList.add(""+setting.getChannel());
              }
              
              if(setting.getSamplerate()>0){
                  argList.add("-ar");
                  argList.add(""+setting.getSamplerate());
              }
              
              if(setting.getBitrate()>0){
                  argList.add("-ab");
                  argList.add(""+setting.getBitrate()/1000);
              }
              }
          }
      
      
      argList.add(output.getAbsolutePath());
      
      return (String[])argList.toArray(new String[argList.size()]);
    }
    
    public void convert(File input, File output,AudioSetting setting,AudioSetting inputSetting) throws IOException {
        if(consoleManager==null){
            consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            MessageConsole console = new MessageConsole(getName(), null);
            consoleManager.addConsoles(new IConsole[] {console});
            consoleStream = console.newMessageStream();
            errorStream = console.newMessageStream();
            progressStream = console.newMessageStream();
        }
        
        
        
        // TODO Auto-generated method stub
        Runtime runtime=Runtime.getRuntime();
        //String args[]=new String[]{getFFMpegPath(),"-y","-i",input.getAbsolutePath(),output.getAbsolutePath()};
        String args[]=toArgs(input,output,setting,inputSetting);
        
       
        //String args[]=new String[]{getFFMpegPath(),"-y","-i",input.getAbsolutePath(),output.getAbsolutePath()};
        
        //String args[]=new String[]{"C:\\Program Files\\MediaInfo_Cmd_Win32_0.4.0.0\\mediainfo",input.getAbsolutePath()};
        String command="";
        for (int i = 0; i < args.length; i++) {
            command+=toArg(args[i])+" ";
        }
        System.out.println(command);
       
       
       
       File pathFile=new File(getFFMpegPath());
       
       //Process process=runtime.exec(args);
        
        Process process=runtime.exec(args,null,pathFile.getParentFile());
        //Process process=runtime.exec("cmd.exe",null,pathFile.getParentFile());
        //Process process=runtime.exec("cmd.exe");
        
        int c;
        String line;
        InputStream in=null;
        
        
        
       
        
        
       /*
        InputStream in=process.getInputStream();
        while((c=in.read())!=-1){
            consoleStream.print(""+(char)c);
        }*/
        
        
        
        
        //consoleStream.println(command);
        /*
        PrintStream pout=new PrintStream(process.getOutputStream());
        //pout.println(""+toArg(getFFMpegPath())+" -formats");
      // pout.println("echo %path%");
      // pout.println("ffmpeg -formats");
       
        pout.println(command);
        
        pout.close();
        */
        
        /*
        BufferedReader reader=new BufferedReader(new InputStreamReader(process.getInputStream()));
        while((line=reader.readLine())!=null){
            consoleStream.println(""+line);
            if(line.equals(""+pathFile.getParentFile().getAbsolutePath()+">")){
                System.out.println("mutch");
                break;
            }
        }
        
        reader.close();
        */
        
        String errorLine;
        BufferedReader errorReader=new BufferedReader(new InputStreamReader(process.getErrorStream()));
        Color defaultColor=new Color(null,0,0,0);
        Color errorColor=new Color(null,255,0,0);
        errorStream.setColor(errorColor);
        consoleStream.setColor(defaultColor);
        progressStream.setColor(new Color(null,0,0,255));
        while((errorLine=errorReader.readLine())!=null){
            if(isError(errorLine)){
                errorStream.println(errorLine);
            }else if(isProgress(errorLine)){
                progressStream.println(errorLine);
            }else{
                consoleStream.println(errorLine);
            }
           
            
        }
        
        errorReader.close();
        
        
       
        /*
        try {
            process.waitFor();
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }*/
        
        
        
        
        
        /*
        in=process.getInputStream();
        while((c=in.read())!=-1){
            consoleStream.print(""+(char)c);
        }*/
        
        
      
        
        
        
    }
    public boolean isProgress(String line){
        return line.startsWith(("size="));
    }
    public boolean isError(String line){
        if(line.indexOf("is not allowed in mp2")!=-1){
            return true;
        }else if(line.indexOf(">Error")!=-1){
            return true;
        }else if(line.indexOf("11024 Hz")!=-1){
            return true;
        }else if(line.indexOf("22049 Hz")!=-1){
            return true;
        }else if(line.indexOf("44099 Hz")!=-1){
            return true;
        }
        
        
        return false;
    }

  
    public String toArg(String text){
        if(text.indexOf(" ")!=-1){
            return "\""+text+"\"";
        }else{
            return text;
        }
    }
    public String getName(){
        return "FFMpeg";
    }
}
