/*
 * Created on 2005/04/07
 * Author aki@www.xucker.jpn.org
 * License Apache2.0 or Common Public License
 */
package org.jpn.xucker.rcp.audiotools.spectrogram.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.commons.audio.AudioProgressListener;
import org.jpn.xucker.commons.audio.WaveFormUtils;
import org.jpn.xucker.commons.audio.WaveUtils;
import org.jpn.xucker.rcp.audio.AudioConverter;
import org.jpn.xucker.rcp.audio.AudioUtils;
import org.jpn.xucker.rcp.audiotools.AudioToolsPlugin;
import org.jpn.xucker.rcp.audiotools.QuickConverter;
import org.jpn.xucker.rcp.audiotools.spectrogram.SpectrogramListFigure;
import org.jpn.xucker.rcp.audiotools.spectrogram.SpectrogramPage;
import org.jpn.xucker.rcp.draw2d.ChainedFlowFigure;
import org.jpn.xucker.rcp.draw2d.FileImageCache;
import org.jpn.xucker.rcp.draw2d.WaveFormFigure;
import org.jpn.xucker.rcp.snack.Snack_rcpPlugin;
import org.jpn.xucker.rcp.ui.BufferedImagePainter;
import org.jpn.xucker.rcp.ui.DefaultZoom;
import org.jpn.xucker.rcp.ui.FigureMemoryComposite;
import org.jpn.xucker.rcp.ui.NumberLabelProvider;
import org.jpn.xucker.rcp.ui.ProgressMonitor;
import org.jpn.xucker.rcp.ui.SimpleGraphMemoryPainter;
import org.jpn.xucker.rcp.ui.Zoom;
import org.jpn.xucker.rcp.ui.ZoomChangeListener;
import org.jpn.xucker.snack.Formant;
import org.jpn.xucker.snack.FormantFigure;
import org.jpn.xucker.snack.FormantParser;
import org.jpn.xucker.snack.SmallFormant;
import org.jpn.xucker.snack.SnackExecuter;
import org.jpn.xucker.snack.SpectrogramListener;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

/**
 * 
 *  
 */
public class AudioGraphView extends ViewPart {
    public static Log log = LogFactory.getLog(AudioGraphView.class);

    public static String ID_VIEW = AudioGraphView.class.getName();

    private SnackExecuter snackExecuter;

    private FigureMemoryComposite figureMemoryComposite;

    //private SpectrogramPainter painter;

    //private ResizableImageFigure resizableImageFigure;
    private SpectrogramListFigure spectrogramImageFigure;

    private FormantFigure formantFigure = new FormantFigure();

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */

    int compositeHeight = 512;
    int imageWidth=100;
    
    
    int basePersecond=400;
    
    DefaultZoom defaultZoom=new DefaultZoom();

    double pixelMillisecond = 2.5;

    private KHZMemoryPainter khzMemoryPainter;

    private boolean spectrogram;

    private boolean formant = true;

    private int graphTop = 24;

    private int graphLeft = 46;

    
    private FileImageCache fileImageCache;
    
    private double persample;
    private int spectrogramLength;
    private ViewPart viewPart;
    
    
    private File spectrogramBase;
    
    private ChainedFlowFigure waveForm;
    
    
    int waveFormBase=32;//TODO check that.
    public boolean isFormant() {
        return formant;
    }

    public void setFormant(boolean formant) {
        log.trace("formant:" + formant);
        this.formant = formant;
        formantFigure.setVisible(formant);
    }

    public boolean isSpectrogram() {
        return spectrogram;
    }

    public void setSpectrogram(boolean spectrogram) {
        this.spectrogram = spectrogram;
    }

    public class ZoomChangeRepaint implements ZoomChangeListener{

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.ZoomChangeListener#zoomUp(org.jpn.xucker.rcp.ui.Zoom)
         */
        public void zoomUp(Zoom arg0) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.ZoomChangeListener#zoomDown(org.jpn.xucker.rcp.ui.Zoom)
         */
        public void zoomDown(Zoom arg0) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.ZoomChangeListener#zoomChange(org.jpn.xucker.rcp.ui.Zoom)
         */
        public void zoomChange(Zoom zoom) {
            // TODO Auto-generated method stub
            setHorizontalMemoryValue();
            spectrogramImageFigure.setZoom(zoom.getZoom(), 1);
            formantFigure.setWzoom(zoom.getZoom());
            
            if(waveForm!=null){
            waveForm.setScale(defaultZoom.getZoom()*4/waveFormBase,1);
            }
            
            updateDraw();
        }
        
    }
    public void createPartControl(Composite parent) {
        
        
        
        spectrogramBase=AudioToolsPlugin.getDefault().getSpectrogramDirectory();
        
        viewPart=this;
        
        fileImageCache=new FileImageCache();
        fileImageCache.setMaxSize(32);
        
        snackExecuter = new SnackExecuter(Snack_rcpPlugin.getDefault()
                .getSnackExecuterDirectory().getAbsolutePath());
        figureMemoryComposite = new FigureMemoryComposite(parent, SWT.NULL,
                graphTop, graphLeft);

       // painter = new SpectrogramPainter(parent.getDisplay());

        SimpleGraphMemoryPainter vpainter = figureMemoryComposite
                .getVerticalGraphPainter();

        vpainter.setPerMain((double) compositeHeight / 12);
        //System.out.println(vpainter.getPerMain());
        vpainter.setGraphPlus(true);

        khzMemoryPainter = new KHZMemoryPainter();
        khzMemoryPainter.setHeight(compositeHeight);
        khzMemoryPainter.setGraphPlus(false);
        khzMemoryPainter.setVerticalGraph(true);
        figureMemoryComposite.setMaxVerticalValue(compositeHeight);
        figureMemoryComposite.setMaxHorizontalValue(999999);//ok?
        figureMemoryComposite.setVerticalMemoryStart(compositeHeight - 1);//move
                                                                         // 1
                                                                         // pixel.TODO

       
        figureMemoryComposite.setVscrollLabelProvider(khzMemoryPainter);//TODO
                                                                       // not
                                                                       // support
                                                                       // zoom.
        figureMemoryComposite.getVerticalMemoryCanvas().setGraphMemoryPainter(
                khzMemoryPainter);
        //imageMemoryComposite.setMaxVerticalValue((int)(vpainter.getPerMain()*12));
        figureMemoryComposite.getHorizontalGraphPainter().setPerMain(80);//1000ms == 400pixe;
        
        setHorizontalMemoryValue();

        spectrogramImageFigure = new SpectrogramListFigure();
        
        //imageMemoryComposite.getContents().add(spectrogramImageFigure);//TODO temporaly remove.

        
        spectrogramImageFigure.setZoom(defaultZoom.getZoom(), 1);
        
        //spectrogramImageFigure.add(formantFigure);//TODO change layer.

        //imageMemoryComposite.getContents().setLayoutManager(new StackLayout());
        
        //imageMemoryComposite.getScalableLayeredPane().setLayoutManager(null);//cant' show scroll bar.
        
        figureMemoryComposite.getScalableLayeredPane().setLayoutManager(new StackLayout());//OK!
        figureMemoryComposite.getScalableLayeredPane().add(spectrogramImageFigure);//
        
        figureMemoryComposite.getScalableLayeredPane().add(formantFigure);
        
        waveForm=new ChainedFlowFigure();
        figureMemoryComposite.getScalableLayeredPane().add(waveForm);
        //System.out.println(imageMemoryComposite.getContents().getLayoutManager());
        //setAudio(new File("c:\\tmp\\aiueo.wav"));
        //setAudio(new File("c:\\tmp\\_theend.wav"));
        
        //setAudio(new File("c:\\tmp\\60.wav"));
        
        setFit(true);//TODO get from preference.
       
        
        // zoom action
        defaultZoom.setWrap(true);
        defaultZoom.addZoomChangeListener(new ZoomChangeRepaint());
        
        double zoom=Double.parseDouble(AudioToolsPlugin.getDefault().getPreferenceStore().getString(SpectrogramPage.INITIAL_ZOOM));
        int count=defaultZoom.countZooms();
        for(int i=0;i<count;i++){
            double zv=defaultZoom.getZoomValue(i);
            if(zv==zoom){
                log.trace("initial-zoom:"+zv);
                defaultZoom.setZoomIndex(i);
                break;
            }
        }
        
        
        //defaultZoom.setZoomIndex(5);//2.0;
        MouseZoom mouseListener=new MouseZoom();
        //imageMemoryComposite.getScalableLayeredPane().addMouseListener(mouseListener);
        figureMemoryComposite.getCanvas().addMouseListener(mouseListener);
        
        
        Transfer[] types = new Transfer[] {FileTransfer.getInstance()};
    	
    	int operations = DND.DROP_MOVE | DND.DROP_COPY ;
    	
    	
    		
    	
    	
    	
    	
    		DropTarget target2 = new DropTarget (figureMemoryComposite.getCanvas(), operations);
    		target2.setTransfer(types);
    	
    		target2.addDropListener(new DropMonitor());
       }
    
    public class DropMonitor extends DropTargetAdapter{
		public void dragEnter(DropTargetEvent event){
			//System.out.println("drag enter:"+event.data);
		}
		public void dragOver(DropTargetEvent event){
			//System.out.println("drag over:"+event.data);
			}
		public void drop(DropTargetEvent event){
			//System.out.println("drop:"+event.data);
			
			//System.out.println(event.data.getClass().getName());
			String files[]=(String[])event.data;
		
		
			for(int i=0;i<files.length;i++){
			    File file=new File(files[i]);
			    if(file.isFile()){
				setAudio(file);
				
				break;
			    }
			}
			
			}
	}
    
    public class MouseZoom implements MouseListener,org.eclipse.swt.events.MouseListener{

       

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mousePressed(org.eclipse.draw2d.MouseEvent)
         */
        public void mousePressed(org.eclipse.draw2d.MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseReleased(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseReleased(org.eclipse.draw2d.MouseEvent arg0) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.draw2d.MouseListener#mouseDoubleClicked(org.eclipse.draw2d.MouseEvent)
         */
        public void mouseDoubleClicked(org.eclipse.draw2d.MouseEvent arg0) {
            //System.out.println("zoom");
            defaultZoom.zoomUp();
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseListener#mouseDoubleClick(org.eclipse.swt.events.MouseEvent)
         */
        public void mouseDoubleClick(MouseEvent e) {
            //System.out.println("canvas:zoom");
            //System.out.println("key?"+e.stateMask);
            if((e.stateMask & SWT.SHIFT)>0){
                defaultZoom.zoomDown();
            }else{
                defaultZoom.zoomUp();
            }
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseListener#mouseDown(org.eclipse.swt.events.MouseEvent)
         */
        public void mouseDown(MouseEvent e) {
            // TODO Auto-generated method stub
            
        }

        /* (non-Javadoc)
         * @see org.eclipse.swt.events.MouseListener#mouseUp(org.eclipse.swt.events.MouseEvent)
         */
        public void mouseUp(MouseEvent e) {
            // TODO Auto-generated method stub
            
        }
        
    }
    public void setHorizontalMemoryValue(){
        figureMemoryComposite.setHscrollLabelProvider(new NumberLabelProvider(
                (int)(basePersecond/defaultZoom.getZoom()), 4 * 60 * 120));
    }
    

    

    public IProgressMonitor getProgressMonitor(){
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
IStatusLineManager lineManager = workbenchWindow.getStatusLineManager();
return lineManager.getProgressMonitor();
}
    
    
    
    public class ExportImage extends Thread implements org.jpn.xucker.rcp.ui.ProgressMonitor{
        private File file;
        private Shell shell;
        
        private IProgressMonitor monitor;
        int maxprogress;
        //int currentprogress;
        
        public ExportImage(Shell shell,File file){
            this.file=file;
            this.shell=shell;
            monitor=getProgressMonitor();
            maxprogress=(int)(compositeHeight/50*1.2);//TODO zoom?
            monitor.beginTask("Export Image:"+file.getAbsolutePath(),maxprogress);
        }
        
        public void run(){
        //disable action.
            
            String extention=AudioUtils.getExtension(file).toLowerCase();
            if(extention.equals("png")){
            doExportPngImage(shell,file);
            }else if(extention.equals("jpg")){
                doExportJpegImage(shell,file);    
            }else{
                shell.getDisplay().asyncExec(new ShowMessageBox(shell,"Can't Save Image","type:"+extention+" not supported."));
              
               // box.
            }
            shell.getDisplay().asyncExec(new MonitorDone());
        //enable action.
        }
        
        /*
        public void doExportJPEGImage(Shell shell,File file){

            //get spectrogram size
            //craete image (paint).
            //paint
            //convert png
           
            //TODO implements
            
            //System.out.println(shell+","+shell.getDisplay());
           
            log.trace("bound:"+spectrogramImageFigure.getBounds());
            
            Image bufferedImage = new Image(shell.getDisplay(),(int)(
                    spectrogramImageFigure.getBounds().width
                             + graphLeft), compositeHeight + graphTop);
            //drop left/top corner.
            GC g=new GC(bufferedImage);
            
            //g.setColor(java.awt.Color.white);
            //g.fillRect(0,0,graphLeft,graphTop);
            
            
            Image spectrogram = new Image(
                    shell.getDisplay(),
                            (int)(spectrogramImageFigure.getBounds().width ),
                    compositeHeight);
           
            SWTGraphics graphics = new SWTGraphics(new GC(spectrogram));
            
            spectrogramImageFigure.paint(graphics);//drawa at.
            if(isFormant()){
            formantFigure.paint(graphics);
            }
            
           BufferedImagePainter painter=new BufferedImagePainter();
           painter.setMonitor(this);
            
            g.drawImage(spectrogram,graphLeft, graphTop);
            //painter.drawAtBufferedImage(bufferedImage,spectrogram, graphLeft, graphTop);
            spectrogram.dispose();
            graphics.dispose();
            
            //
            Image verticalImage=new Image(
                    shell.getDisplay(),
                    graphLeft,
                    compositeHeight);
            GC verticalGC=new GC(verticalImage);
            imageMemoryComposite.getVerticalGraphPainter().draw(verticalGC, graphLeft-1,
                    compositeHeight,compositeHeight );
            //painter.drawAtBufferedImage(bufferedImage,verticalImage, 0, graphTop);
            g.drawImage(verticalImage, 0, graphTop);
            verticalImage.dispose();
            verticalGC.dispose();
            
            //
            Image horizontalImage=new Image(
                    shell
                            .getDisplay(),
                            (int)( spectrogramImageFigure.getBounds().width ),
                    graphTop);
            GC horizontalGC=new GC(horizontalImage);
            imageMemoryComposite.getHorizontalGraphPainter().draw(horizontalGC, 0,
                    graphTop-1,(int)(spectrogramImageFigure.getBounds().width ));
            
           // painter.drawAtBufferedImage(bufferedImage,horizontalImage, graphLeft, 0); 
            g.drawImage(horizontalImage, graphLeft, 0);
            horizontalImage.dispose();
            horizontalGC.dispose();
            
            
           
            
            try {
                ImageData data=bufferedImage.getImageData();
                ImageLoader loader=new ImageLoader();
                loader.data=new ImageData[]{data};
                loader.save(new FileOutputStream(file),SWT.IMAGE_JPEG);
                //ImageIO.write(bufferedImage,"png",file);
                
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            
            g.dispose();
            bufferedImage.dispose();
            
            System.gc();
          
          
            
            
        }*/
        
        public void doExportJpegImage(Shell shell,File file){
            
            //get spectrogram size
            //craete image (paint).
            //paint
            //convert png
           
            //TODO implements
            
            //System.out.println(shell+","+shell.getDisplay());
           
            log.trace("bound:"+spectrogramImageFigure.getBounds());
            
            
            int qualityValue=AudioToolsPlugin.getDefault().getPreferenceStore().getInt(SpectrogramPage.JPEG_QUALITY);
            float quality=((float)qualityValue)/100;
            
            log.trace("quality:"+quality);
            BufferedImage bufferedImage = new BufferedImage((int)(
                    spectrogramImageFigure.getBounds().width
                             + graphLeft), compositeHeight + graphTop,BufferedImage.TYPE_INT_RGB);//TYPE_INT_ARGB
           
            //drop left/top corner.
            Graphics g=bufferedImage.getGraphics();
            g.setColor(new Color(255,255,255));
            g.fillRect(0,0,graphLeft,graphTop);
            
            
            
            Image spectrogram = new Image(
                    shell.getDisplay(),
                            (int)(spectrogramImageFigure.getBounds().width ),
                    compositeHeight);
           
            SWTGraphics graphics = new SWTGraphics(new GC(spectrogram));
            
            spectrogramImageFigure.paint(graphics);//drawa at.
            if(isFormant()){
            formantFigure.paint(graphics);
            }
            
            //TODO check.
            waveForm.paint(graphics);
            
           BufferedImagePainter painter=new BufferedImagePainter();
           painter.setMonitor(this);
            
            
           painter.drawAtBufferedImage(bufferedImage,spectrogram, graphLeft, graphTop);
            spectrogram.dispose();
            graphics.dispose();
            
            //
            Image verticalImage=new Image(
                    shell.getDisplay(),
                    graphLeft,
                    compositeHeight);
            GC verticalGC=new GC(verticalImage);
            figureMemoryComposite.getVerticalGraphPainter().draw(verticalGC, graphLeft-1,
                    compositeHeight,compositeHeight );
            painter.drawAtBufferedImage(bufferedImage,verticalImage, 0, graphTop);
            verticalImage.dispose();
            verticalGC.dispose();
            
            //
            Image horizontalImage=new Image(
                    shell
                            .getDisplay(),
                            (int)( spectrogramImageFigure.getBounds().width ),
                    graphTop);
            GC horizontalGC=new GC(horizontalImage);
            figureMemoryComposite.getHorizontalGraphPainter().draw(horizontalGC, 0,
                    graphTop-1,(int)(spectrogramImageFigure.getBounds().width ));
            
            painter.drawAtBufferedImage(bufferedImage,horizontalImage, graphLeft, 0); 
            horizontalImage.dispose();
            horizontalGC.dispose();
            
            
           
            
            try {
                //ImageIO.write(bufferedImage,"jpg",file);
                
                Iterator writers = ImageIO.getImageWritersByFormatName("jpeg");
                
                ImageWriter writer= (ImageWriter)writers.next();;
               
                ImageOutputStream ios = ImageIO.createImageOutputStream(file);
                writer.setOutput(ios);
            
                ImageWriteParam param = writer.getDefaultWriteParam();
                param.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);
                param.setCompressionQuality(quality);
                writer.write(null,new IIOImage(bufferedImage,null,null),param);
                
                ios.close();//important
                
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            
            
            //bufferedImage=null;
           // System.gc();
          
          
            
            
            
        }
        public void doExportPngImage(Shell shell,File file){
            
            //get spectrogram size
            //craete image (paint).
            //paint
            //convert png
           
            //TODO implements
            
            //System.out.println(shell+","+shell.getDisplay());
           
            log.trace("bound:"+spectrogramImageFigure.getBounds());
            
            BufferedImage bufferedImage = new BufferedImage((int)(
                    spectrogramImageFigure.getBounds().width
                             + graphLeft), compositeHeight + graphTop,BufferedImage.TYPE_INT_ARGB);
            //drop left/top corner.
            Graphics g=bufferedImage.getGraphics();
            g.setColor(java.awt.Color.white);
            g.fillRect(0,0,graphLeft,graphTop);
            
            
            Image spectrogram = new Image(
                    shell.getDisplay(),
                            (int)(spectrogramImageFigure.getBounds().width ),
                    compositeHeight);
           
            SWTGraphics graphics = new SWTGraphics(new GC(spectrogram));
            
            spectrogramImageFigure.paint(graphics);//drawa at.
            if(isFormant()){
            formantFigure.paint(graphics);
            }
            //TODO check.
            waveForm.paint(graphics);
            
           BufferedImagePainter painter=new BufferedImagePainter();
           painter.setMonitor(this);
            
            
           painter.drawAtBufferedImage(bufferedImage,spectrogram, graphLeft, graphTop);
            spectrogram.dispose();
            graphics.dispose();
            
            //
            Image verticalImage=new Image(
                    shell.getDisplay(),
                    graphLeft,
                    compositeHeight);
            GC verticalGC=new GC(verticalImage);
            figureMemoryComposite.getVerticalGraphPainter().draw(verticalGC, graphLeft-1,
                    compositeHeight,compositeHeight );
            painter.drawAtBufferedImage(bufferedImage,verticalImage, 0, graphTop);
            verticalImage.dispose();
            verticalGC.dispose();
            
            //
            Image horizontalImage=new Image(
                    shell
                            .getDisplay(),
                            (int)( spectrogramImageFigure.getBounds().width ),
                    graphTop);
            GC horizontalGC=new GC(horizontalImage);
            figureMemoryComposite.getHorizontalGraphPainter().draw(horizontalGC, 0,
                    graphTop-1,(int)(spectrogramImageFigure.getBounds().width ));
            
            painter.drawAtBufferedImage(bufferedImage,horizontalImage, graphLeft, 0); 
            horizontalImage.dispose();
            horizontalGC.dispose();
            
            
           
            
            try {
                ImageIO.write(bufferedImage,"png",file);
                
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            
            
            bufferedImage=null;
            System.gc();
          
          
            
            
            
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.BufferedImagePainterMonitor#finished(int)
         */
        public void worked(int arg0) {
           // currentprogress++;
            shell.getDisplay().asyncExec(new MonitorWork());
        }
        public boolean isCanceled(){
            return monitor.isCanceled();
        }
        public class MonitorDone extends Thread{
            public void run(){
                monitor.done();
            }
        }
        public class MonitorWork extends Thread{
            public void run(){
                monitor.worked(1);
            }
        }
    }
    
   
    public class ShowMessageBox implements Runnable{
        private Shell shell;
        private String title;
        private String message;
        public ShowMessageBox(Shell shell,String title,String message){
            this.shell=shell;
            this.title=title;
            this.message=message;
        }
        public void run(){
            MessageBox box=new MessageBox(shell,SWT.NULL);
            box.setText(title);
            box.setMessage(message);
            box.open();
        }
    }
    
    public void exportImage(File file) {
        //System.out.println("exp:"+PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        ExportImage exp=new ExportImage(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
                ,file);
        exp.start();
    }
    

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.part.WorkbenchPart#setFocus()
     */
    public void setFocus() {
        figureMemoryComposite.getCanvas().setFocus();
    }

    private boolean fit = true;

    private int samplerate = 48000;//default


    public void setFit(boolean bool) {
        this.fit=bool;
        log.trace("fit:" + bool);
        formantFigure.setFit(bool);
        //spectrogramFigure.setFit(bool);
        spectrogramImageFigure.setFit(bool);
        if (bool) {
            khzMemoryPainter.setSamplerate(samplerate);//change memorysize.
        } else {
            khzMemoryPainter.setSamplerate(48000);//MAX samplerate.
        }
        //imageMemoryComposite.layout();
        updateDraw();
    }

    public void updateDraw(){
        if(!figureMemoryComposite.getShell().isDisposed()){
        figureMemoryComposite.getScalableLayeredPane().setScale(1.0);
        figureMemoryComposite.redraw(0, 0,
                figureMemoryComposite.getClientArea().width,
                figureMemoryComposite.getClientArea().height, true);
        
        log.trace("spectrogram:"+spectrogramImageFigure.getSize());
        log.trace("formant:"+formantFigure.getSize());
        }
        //imageMemoryComposite.layout(true);
    }

    public class SetAudioData extends Thread{
        SmallFormant[] formants;
 
        public SetAudioData(SmallFormant[] formants){
          
            this.formants=formants;
        }
        public void run(){
            setAudioData(formants);
        }
    }
    
    public void setAudioData(SmallFormant[] formants){
        /*
         * FormantParser parser=new FormantParser(); List
         * list=(List)parser.parse(new File("c:\\tmp\\f.txt")); Formant[]
         * formants=(Formant[])list.toArray(new
         * Formant[list.size()]);//test.
         */
       
        FileImageCache imageCache=new FileImageCache();
        
        
        spectrogramImageFigure.setSampleRate(samplerate);
        spectrogramImageFigure.init(imageWidth,compositeHeight,(int)(spectrogramLength/persample),imageCache,spectrogramBase);
        
        
        
        
        FormantParser.normalize(formants, 2);
        formantFigure.setFormants(formants);

        log.trace("formant-resize:");
        formantFigure.resize();
        formantFigure.setSampleRate(samplerate);
        //System.out.println("formants.lengt:"+formants.length);
        // System.out.println(spectrogram.toMillisecond()+","+Formant.toMillisecond(formants));

        int margin = (int) ((spectrogramLength - SmallFormant
                .toMillisecond(formants))
                / pixelMillisecond / 2);
        //System.out.println(margin);
        
        //formantFigure.setMarginX(margin);//TODO reset.

        setFit(fit);//set current fit. fix bug 5918.
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate(this);
       // this.setF
        updateDraw();
    }
    
   
    
    public class SplitMonitor implements AudioProgressListener{

        IProgressMonitor monitor;
        public SplitMonitor(IProgressMonitor monitor){
            this.monitor=monitor;
        }
        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.audio.AudioProgressListener#worked(int)
         */
        public void worked(int arg0) {
            // TODO Auto-generated method stub
            monitor.worked(1);
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.audio.AudioStopper#isStopped()
         */
        public boolean isStopped() {
            // TODO Auto-generated method stub
            return monitor.isCanceled();
        }

        /* (non-Javadoc)
         * @see org.jpn.xucker.commons.audio.AudioStopper#setStopped(boolean)
         */
        public void setStopped(boolean arg0) {
            // TODO Auto-generated method stub
            
        }
        
    }
    
    GifConvertMonitor gifConvertMonitor;//TODO move up.
    public class OpenSpectrogram implements IRunnableWithProgress,org.jpn.xucker.rcp.ui.ProgressMonitor{
       
        File waveFile;
        Shell shell;
        IProgressMonitor monitor;
        
        IProgressMonitor imageMonitor;
        
      
       
        
        File originalFile;
        public OpenSpectrogram(Shell shell,File waveFile,IProgressMonitor imageMonitor,File originalFile){
            this.waveFile=waveFile;
            this.shell=shell;
            this.imageMonitor=imageMonitor;
            this.originalFile=originalFile;
        }
        /* (non-Javadoc)
         * @see org.eclipse.jface.operation.IRunnableWithProgress#run(org.eclipse.core.runtime.IProgressMonitor)
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            int basicSplitDuration=60*1000;
            int lastSplitDuration;
            
            long audioLength=WaveUtils.countAudioMillisecond(waveFile);
            
            int splitSize=(int)audioLength/basicSplitDuration;
            if(audioLength%basicSplitDuration>0){
                splitSize++;
            }
            int works=splitSize*2;//split formant
            
            monitor.beginTask("Open File "+originalFile.getName(),works);//parse and paint.
            
            if(gifConvertMonitor!=null){
                gifConvertMonitor.setCanceled(true);
            }
            
            this.monitor=monitor;
            int permillisecond=(100 * 2);//0.020 millisecond
           int step=0;
            try {
                AudioInputStream input=AudioSystem.getAudioInputStream(waveFile);
                AudioFormat format=input.getFormat();
                samplerate=(int)format.getSampleRate();
                
//              samplerate = format.
                persample = (double)samplerate / permillisecond;
                
                spectrogramLength=(int)input.getFrameLength();
                step=(int)(spectrogramLength/persample);
                //step=(int)((input.getFrameLength()-compositeHeight*2)/persample);
                //step=(int)((input.getFrameLength())/persample);
                log.trace("framesize:"+input.getFrameLength()+",samplerate="+samplerate+",ms="+permillisecond+",spectrogramLength="+spectrogramLength);
                input.close();
               
                
            } catch (UnsupportedAudioFileException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            } catch (IOException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            
           
            List wavFormByteList=WaveFormUtils.toWavValue(0.02/(waveFormBase),waveFile,1024);
            shell.getDisplay().asyncExec(new SetWaveFormData(wavFormByteList));
            
            
            SplitMonitor spMonitor=new SplitMonitor(monitor);
            File[] splits=null;
            try {
                //thread?
                splits=WaveUtils.splitFile(waveFile,1000*60,compositeHeight,true,spMonitor);
            } catch (IOException e2) {
                // TODO Auto-generated catch block
                e2.printStackTrace();
            }
            
            if(splits==null || monitor.isCanceled()){ 
                log.trace("splits==null or cancelde");
                return;
            }
            
            
            int perFormant=10;
            
            lastSplitDuration=(int)(audioLength%basicSplitDuration);
            
           
            
            //spectrogramLength=(int)(persample*step);
            log.trace("spectrogramMillisecond:"+spectrogramLength);
            
            
            
            
            //System.out.println("step:"+step*2);
         //   int step=samplerate*audioDuration
            try {

               

                if (fit) {
                    khzMemoryPainter.setSamplerate(samplerate);//change memorysize.
                }

                /*
                Spectrogram spectrogram = snackExecuter.getSpectram(file
                        .getAbsolutePath(), samplerate, 512, persample, 0, 0,this);
                */
                
                
                
                //System.out.println("sp:"+spectrogram.getWidth());
                
                
                
                
                List formantList=new ArrayList();
                
                
                for(int j=0;j<splits.length;j++){
                    int splitDuration=basicSplitDuration;
                    if(j==splits.length-1){
                        splitDuration=lastSplitDuration;
                    }
                    log.trace("splitDuration:"+splitDuration+"ms");
                    monitor.subTask("parse formant "+(j+1)+"/"+splits.length);
                    if(monitor.isCanceled()){
                        //TODO final remove tmp files.
                        return;
                    }
                //System.out.println("base:"+baseSpectrogramImage.getBounds());
                
                //resizableImageFigure.setSize(baseSpectrogramImage.getBounds().width*2,baseSpectrogramImage.getBounds().height);

                long formantStart=System.currentTimeMillis();
                Formant[] formants = snackExecuter.getFormants(splits[j]
                        .getAbsolutePath(),compositeHeight,-compositeHeight);
                log.trace("formant-length:"+formants.length);
                log.trace("formant-parse-time:"+(System.currentTimeMillis()-formantStart));
                int collectSize=(int)(splitDuration/perFormant);
                log.trace("collect-size:"+collectSize);
                double fixper=(double)formants.length/collectSize;
                if(formants.length>0){
                 for(int i=0;i<collectSize;i++){
                    SmallFormant smallFormant=new SmallFormant(formants[Math.min((int)(i*fixper),collectSize-1)]);
                    formantList.add(smallFormant);
                }
                }
                 formants=null;
                 System.gc();//TODO really need?
                //Formant[] collectSize=new 
                
                monitor.worked(1);
                
                }
                
                
                
                //Image baseSpectrogramImage = painter.createImage(spectrogram);
                
                if(monitor.isCanceled()){
                    
                    return;
                }
                monitor.done();
                
                //reset waveForm
                /*
                if(waveForm!=null){
                    
                    shell.getDisplay().syncExec(new RemoveWaveForm());
                    
                }
                log.trace("tmp:"+tmpWaveForm);
                log.trace("waveForm:"+tmpWaveForm.getChildren().size());
                
                waveForm=tmpWaveForm;
                */
                /*
                shell.getDisplay().asyncExec(new SetWaveForm(waveForm));
                */
               
                //waveForm.setVisible(true);
                
                
                
                shell.getDisplay().asyncExec(new SetViewPartName(originalFile.getName(),originalFile.getAbsolutePath()));
               
                
               
                
//              //delete all 
                log.trace("imagedir:"+spectrogramBase.getAbsolutePath());
                String list[]=spectrogramBase.list();
                
                for(int i=0;i<list.length;i++){
                    new File(spectrogramBase,list[i]).delete();
                }
                
                /*
                SpectrogramGifConverter gifConverter=new SpectrogramGifConverter(samplerate,compositeHeight,persample);
                gifConverter.setImageWidth(imageWidth);
                gifConverter.setExportPath(imageBase.getAbsolutePath());
                
                gifConverter.setSpectrogramListener(new SpectrogramLoaded());
                */
                
                int maxSplitSize=step/100;//for progressmonitor file base.100 is image size.
                if(spectrogramLength%100>0){
                    maxSplitSize++;
                }
                
                log.trace("max-splitsize:"+maxSplitSize);
                
                //show import image.
                shell.getDisplay().asyncExec(new ProgressMonitorBegin(imageMonitor,"import spectrogram",maxSplitSize));
                
                
                
                
                gifConvertMonitor=new GifConvertMonitor(shell,imageMonitor,maxSplitSize,splits);
                
               
                ExportGif expGif=new ExportGif(splits,spectrogramBase.getAbsolutePath(),samplerate,compositeHeight,persample,gifConvertMonitor,new SpectrogramLoaded());
                Thread t=new Thread(expGif);
                t.start();
                
                //thread & convert start.
                //howtocreate tmp directory-plugin-dir?
                
                if(formantList.size()>0){
                log.trace("formant-size:"+formantList.size());
                shell.getDisplay().syncExec(new SetAudioData((SmallFormant[])formantList.toArray(new SmallFormant[formantList.size()])));
                }else{
                    log.debug("SetAudioData:something null");
                }
               // imageMemoryComposite.getScalableLayeredPane().setScale(1.0);//Dont'
                     
                if(monitor.isCanceled()){
                    gifConvertMonitor.setCanceled(true);
                    return;
                }
                
                // Use
                                                                            // pack();
                
                //delete.
                for(int j=0;j<splits.length;j++){
                splits[j].deleteOnExit();//TODO delete on exportGif.
                //log.trace("delete:"+result+":"+splits[j].getAbsolutePath());
                }
                //redraw only over only.i don't know how to avoid that.
                //imageMemoryComposite.getHorizontalMemoryCanvas().redraw(0,0,imageMemoryComposite.getHorizontalMemoryCanvas().getBounds().width,imageMemoryComposite.getHorizontalMemoryCanvas().getBounds().height,true);
                //imageMemoryComposite.layout();
                //imageMemoryComposite.update();
                //imageMemoryComposite.pack(true);

            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        
        
        public class SetWaveFormData implements Runnable{
            private List byteList;
            public SetWaveFormData(List byteList){
                this.byteList=byteList;
            }
            public void run(){
                int waveFormHeight=256;
                //
                
                waveForm.removeAll();
                for(int i=0;i<byteList.size();i++){
                    byte[] bt=(byte[])byteList.get(i);
                    log.trace("bt-length:"+bt.length);
                    WaveFormFigure waveFormFigure=new WaveFormFigure(bt,waveFormHeight);
                    waveFormFigure.setForegroundColor(ColorConstants.orange);
                    log.trace("waveFormFigure-size:"+waveFormFigure.getClientArea());
                    waveForm.add(waveFormFigure);
                }
                log.trace("default-zoom:"+defaultZoom.getZoom());
                waveForm.setScale(defaultZoom.getZoom()*4/waveFormBase,1);
                log.trace("waveForm-size:"+waveForm.getClientArea());
            }
        }
        /*
        public class SetWaveForm implements Runnable{
            private Figure figure;
            public SetWaveForm(Figure figure){
                this.figure=figure;
            }
            public void run(){
                figureMemoryComposite.getScalableLayeredPane().add(figure);
            }
        }
        
        public class RemoveWaveForm implements Runnable{
          
            public RemoveWaveForm(){
               
            }
            public void run(){
                figureMemoryComposite.getScalableLayeredPane().add(waveForm);
            }
        }*/

        
        public class GifChecker implements SpectrogramListener{

            /* (non-Javadoc)
             * @see org.jpn.xucker.snack.SpectrogramListener#imageSaved(java.lang.String)
             */
            public void imageSaved(String path) {
                log.trace("imageSaved:"+path);
                shell.getDisplay().asyncExec(new UpdateDraw());
            }
            
        }
        
        public class ExportGif implements Runnable{
            File files[];
            int height;
            int samplerate;
            double persample;
            ProgressMonitor monitor;
            SpectrogramListener listener;
            String imageDir;
            public ExportGif(File files[],String imageDir,int samplerate,int height,double persample,ProgressMonitor monitor,SpectrogramListener listener){
                this.files=files;
               this.height=height;
               this.samplerate=samplerate;
               this.persample=persample;
               this.monitor=monitor;
               this.listener=listener;
               this.imageDir=imageDir;
            }
            public void run(){
                try {
                    snackExecuter.createSpectrogramImage(files,imageDir,samplerate,height,persample,0,0,monitor,listener);
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                
            }
        }
        
        public class SpectrogramLoaded implements SpectrogramListener{

            /* (non-Javadoc)
             * @see org.jpn.xucker.snack.SpectrogramListener#imageSaved(java.lang.String)
             */
            public void imageSaved(String path) {
                // TODO Auto-generated method stub
                log.trace("imageSaved:"+path);
                shell.getDisplay().syncExec(new UpdateDraw());
                
            }
            
        }
        
        public class UpdateDraw implements Runnable{

            /* (non-Javadoc)
             * @see java.lang.Runnable#run()
             */
            public void run() {
                updateDraw();
            }
            
        }
        /* (non-Javadoc)
         * @see org.jpn.xucker.snack.ProgressMonitor#finished(int)
         */
        public void worked(int v) {
           // System.out.println("finished "+v);
            monitor.worked(v);
        }
        
        public boolean isCanceled(){
            return monitor.isCanceled();
        }
        
    }
    public void setAudio(File file) {

        File originalFile=file;
        
        File importFile=null;
        
        if(isWavFile(file)){
            importFile=file;
        }else{
            QuickConverter converter=new QuickConverter();
            if(converter.canConvert(file,AudioConverter.WAV)){
                try {
                    importFile=File.createTempFile("tmp",".wav");
                    log.trace("convert:"+importFile.getAbsolutePath());
                    converter.convert(file,importFile);
                    importFile.deleteOnExit();//delete file bug fix:5914
                } catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }
        
       
        //TODO change
        IWorkbench workbench = PlatformUI.getWorkbench();
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
        
       // lineManager.insertBefore(lineManager.get,status1);
        //lineManager.setMessage("tmp.ogg - [16bit 44.1khz Stereo] - 10:24:1024");
        
        
        
        //workbenchWindow.getStatusLineManager().setMessage("open");
        
        IProgressMonitor imageMonitor=workbenchWindow.getStatusLineManager().getProgressMonitor();
        
       
        if(importFile!=null){
        IRunnableWithProgress progress=new OpenSpectrogram(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),importFile,imageMonitor,originalFile);
        
        try {
            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, progress);
        
            
        } catch (InvocationTargetException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        }else{
            log.warn("not supported file "+file.getAbsolutePath());
        }
        
        //focus
        figureMemoryComposite.getCanvas().setFocus();
        //System.out.println("focus:"+imageMemoryComposite.getCanvas().isFocusControl());
    }
    

    /**
     * @param file
     * @return
     */
    private boolean isWavFile(File file) {
       return AudioUtils.getExtension(file).toLowerCase().equals("wav");
    }
        
    
    
    public  static class ProgressMonitorDone implements Runnable{
        IProgressMonitor monitor;
        public ProgressMonitorDone(IProgressMonitor monitor){
           this.monitor=monitor;
        }
        public void run(){
            monitor.done();   
        }
    }
    
    public  static class ProgressMonitorBegin implements Runnable{
        private IProgressMonitor monitor;
        private String label;
        private int step;
        public ProgressMonitorBegin(IProgressMonitor monitor,String label,int step){
            this.monitor=monitor;
            this.label=label;
            this.step=step;
        }
        public void run(){
            monitor.beginTask(label,step);   
        }
    }
    
    
    public static class ProgressMonitorProgress implements Runnable{
        private int value;
        private IProgressMonitor monitor;
        public ProgressMonitorProgress(IProgressMonitor monitor,int value){
            this.value=value;
            this.monitor=monitor;
        }
        public void run(){
        monitor.worked(value);   
        }
    }
    
    public void setViewPartName(String name,String description){
        this.setPartName(name);
        this.setTitleToolTip(description);
    }
    public  class SetViewPartName implements Runnable{
        private String title;
        private String description;
        private ViewPart part;
        public SetViewPartName(String title,String description){
            this.title=title;
            this.description=description;
        }
        public void run(){
            setViewPartName(title,description);
        }
    }
    
    public static class GifConvertMonitor implements ProgressMonitor{

        IProgressMonitor monitor;
        private boolean canceled;
        int currentSplitSize=0;
        int maxSplitSize;
        Shell shell;
        File files[];
        public GifConvertMonitor(Shell shell,IProgressMonitor monitor,int max,File[] files){
            this.monitor=monitor;
            this.maxSplitSize=max;
            this.shell=shell;
            this.files=files;
        }
        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.ProgressMonitor#worked(int)
         */
        public void worked(int arg0) {
            log.trace("gif-worked:"+arg0);
            currentSplitSize+=arg0;
            //imageMonitor.worked(arg0);
            shell.getDisplay().asyncExec(new ProgressMonitorProgress(monitor,arg0));
            
            if(currentSplitSize>=maxSplitSize){
                //finish parse.and delte files.
                for(int i=0;i<files.length;i++){
                    boolean result=files[i].delete();
                    log.trace("delete-tmp: "+result+" "+files[i].getAbsolutePath());
                }
                shell.getDisplay().asyncExec(new ProgressMonitorDone(monitor));
                
            }
        }
        

        


        /* (non-Javadoc)
         * @see org.jpn.xucker.rcp.ui.ProgressMonitor#isCanceled()
         */
        public boolean isCanceled() {
            
            return canceled;
        }
        
        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }
    }

    //BufferedImage is ARGB;
    /*
    public static void drawAtBufferedImage(BufferedImage bimg,Image image,int x,int y){
        ImageData data=image.getImageData();
        int at=0;
        for(int j=0;j<image.getBounds().height;j++){
            for(int i=0;i<image.getBounds().width;i++){
            
            int r=0xff & data.data[at+2];
            int g=0xff & data.data[at+1];
            
            
            
            int b=0xff & data.data[at];
           
            bimg.setRGB(i+x,j+y,0xFF<<24 | r<<16 | g<<8 | b<<0);
            at+=4;
        }
        
       
        }*/
        /*
        for(int i=0;i<image.getBounds().width;i++){
          
            for(int j=0;j<image.getBounds().height;j++){
                int r=0xff & data.data[4*(j*image.getBounds().width+i)+2];
                int g=0xff & data.data[4*(j*image.getBounds().width+i)+1];
                
                
                
                int b=0xff & data.data[4*(j*image.getBounds().width+i)];
               
                bimg.setRGB(i+x,j+y,0xFF<<24 | r<<16 | g<<8 | b<<0);
                
            }
        }*/
        
    }
    /*
    public static BufferedImage convertRGB(Image img){
        BufferedImage bimg=new BufferedImage(img.getBounds().width,img.getBounds().height,BufferedImage.TYPE_INT_BGR);
        ImageData data=img.getImageData();
        for(int i=0;i<img.getBounds().width;i++){
            for(int j=0;j<img.getBounds().height;j++){
                bimg.setRGB(i,j,data.getPixel(i,j));
            }
        }
       return bimg;
    }*/
    

