/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.presentations.ISelfUpdatingAction;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;

public final class SystemMenuNewEditor
extends Action
implements ISelfUpdatingAction {
    private IStackPresentationSite site;
    private IPresentablePart part;

    public SystemMenuNewEditor(IStackPresentationSite site) {
        this.site = site;
        this.setText(WorkbenchMessages.PartPane_newEditor);
    }

    public void dispose() {
        this.site = null;
    }

    public void run() {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        if (this.part != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            String editorId;
            IEditorPart editor;
            IEditorPart iEditorPart = editor = page == null ? null : page.getActiveEditor();
            if (editor != null && (editorId = editor.getSite().getId()) != null) {
                try {
                    if (editor instanceof IPersistableEditor) {
                        XMLMemento editorState = XMLMemento.createWriteRoot("editorState");
                        ((IPersistableEditor)((Object)editor)).saveState(editorState);
                        ((WorkbenchPage)page).openEditor(editor.getEditorInput(), editorId, true, 0, editorState);
                    } else {
                        page.openEditor(editor.getEditorInput(), editorId, true, 0);
                    }
                }
                catch (PartInitException e) {
                    DialogUtil.openError(page.getWorkbenchWindow().getShell(), WorkbenchMessages.Error, e.getMessage(), e);
                }
            }
        }
    }

    public void setTarget(IPresentablePart presentablePart) {
        this.part = presentablePart;
        this.setEnabled(presentablePart != null);
    }

    public void update() {
        this.setTarget(this.site.getSelectedPart());
    }

    public boolean shouldBeVisible() {
        return true;
    }
}

