/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.commons.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.akjrcp.commons.util.UtilMessages;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class FileNameUtils {
    public static final String LOCAL_NAME_DESKTOP = UtilMessages.getString("desktop");
    public static final String LOCAL_NAME_MY_DOCUMENTS = UtilMessages.getString("my_documents");
    public static final String LOCAL_NAME_MY_PICTURE = UtilMessages.getString("my_pictures");
    public static final String LOCAL_NAME_MUSIC = UtilMessages.getString("music");
    public static final String LOCAL_NAME_VIDEOS = UtilMessages.getString("videos");
    public static final String LOCAL_NAME_MY_MUSIC = UtilMessages.getString("my_music");
    public static final String LOCAL_NAME_MY_VIDEOS = UtilMessages.getString("my_videos");
    public static final String LOCAL_NAME_DOCUMENTS = UtilMessages.getString("documents");
    public static final String LOCAL_NAME_PICTURE = UtilMessages.getString("pictures");
    public static String OS_NAME = System.getProperty("os.name");
    public static final String WINDOWS_VISTA = "Windows Vista";

    public static boolean isZipFile(String name) {
        return name.toLowerCase().endsWith(".zip");
    }

    public static String getZipEntryFileName(String entryPath) {
        String zipEntrySeparator = "/";
        String[] values = entryPath.split(zipEntrySeparator);
        return values[values.length - 1];
    }

    public static String getZipEntryDirectoryName(String entryPath) {
        String zipEntrySeparator = "/";
        String[] values = entryPath.split(zipEntrySeparator);
        String path = "";
        int i = 0;
        while (i < values.length - 1) {
            path = String.valueOf(path) + values[i] + zipEntrySeparator;
            ++i;
        }
        return path;
    }

    public static String getExtension(String name) {
        String ext;
        if (name.lastIndexOf(".") == -1) {
            ext = "";
        } else {
            int index = name.lastIndexOf(".");
            ext = name.substring(index + 1, name.length());
        }
        return ext;
    }

    public static String getNotFoundFileName(File file) {
        String extension = FileNameUtils.getExtension(file.getName());
        File newFile = null;
        String baseName = null;
        if (file.getName().lastIndexOf(".") == -1) {
            baseName = file.getName();
        } else {
            int index = file.getName().lastIndexOf(".");
            baseName = file.getName().substring(0, index);
        }
        String bName = baseName;
        if (!extension.equals("")) {
            bName = String.valueOf(bName) + "." + extension;
        }
        newFile = new File(file.getParent(), bName);
        int index = 1;
        Pattern ratePattern = Pattern.compile("(^.*)\\((\\d+)\\)$");
        Matcher match = ratePattern.matcher(baseName);
        if (match.matches()) {
            baseName = match.group(1);
            index = Integer.parseInt(match.group(2));
        }
        while (newFile.exists()) {
            String specific = "(" + index + ")";
            String tmpName = String.valueOf(baseName) + specific;
            if (!extension.equals("")) {
                tmpName = String.valueOf(tmpName) + "." + extension;
            }
            newFile = new File(file.getParent(), tmpName);
            ++index;
        }
        return newFile.getAbsolutePath();
    }

    public static String getChangedExtensionName(File file, String extension) {
        return FileNameUtils.getChangedExtensionName(file, extension, false);
    }

    public static String getRemovedExtensionName(String name) {
        String baseName;
        if (name.lastIndexOf(".") == -1) {
            baseName = name;
        } else {
            int index = name.lastIndexOf(".");
            baseName = name.substring(0, index);
        }
        return baseName;
    }

    public static String getChangedExtensionName(String name, String extension) {
        String baseName;
        if (name.lastIndexOf(".") == -1) {
            baseName = name;
        } else {
            int index = name.lastIndexOf(".");
            baseName = name.substring(0, index);
        }
        return String.valueOf(baseName) + "." + extension;
    }

    public static String getChangedExtensionName(File file, String extension, boolean overwrite) {
        File newFile = null;
        String baseName = null;
        if (file.getName().lastIndexOf(".") == -1) {
            baseName = file.getName();
        } else {
            int index = file.getName().lastIndexOf(".");
            baseName = file.getName().substring(0, index);
        }
        String bName = baseName;
        if (!extension.equals("")) {
            bName = String.valueOf(bName) + "." + extension;
        }
        newFile = new File(file.getParent(), bName);
        int index = 1;
        if (!overwrite) {
            while (newFile.exists()) {
                String specific = "(" + index + ")";
                String tmpName = String.valueOf(baseName) + specific;
                if (!extension.equals("")) {
                    tmpName = String.valueOf(tmpName) + "." + extension;
                }
                newFile = new File(file.getParent(), tmpName);
                ++index;
            }
        }
        return newFile.getAbsolutePath();
    }

    public static boolean isSafeFileName(String name) {
        String shoudreplace = ":;,*?\"<>|?";
        int i = 0;
        while (i < shoudreplace.length()) {
            if (name.indexOf(shoudreplace.charAt(i)) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toSafeJPName(String path) {
        String shoudreplace = ":;,*?\"<>|?";
        String replace = "\uff1a\uff1b\u3001\uff0a\uff1f\uffe5\u201d\uff1c\uff1e\uff5c\uff1f";
        String ret = path;
        ret = StringUtils.replaceChars((String)ret, (String)shoudreplace, (String)replace);
        ret = StringUtils.replace((String)ret, (String)"\t", (String)" ");
        ret = StringUtils.replace((String)ret, (String)"\r", (String)" ");
        ret = StringUtils.replace((String)ret, (String)"\n", (String)" ");
        return ret;
    }

    public static boolean changeExtension(File file, String extension) {
        return file.renameTo(new File(FileNameUtils.getChangedExtensionName(file, extension)));
    }

    public static File makeBackupFile(File file, String addextension) {
        int count = 1;
        String baseName = FileNameUtils.getRemovedExtensionName(file.getName());
        String extension = FileNameUtils.getExtension(file.getName());
        File bkfile = new File(file.getParentFile(), String.valueOf(baseName) + "." + addextension + "(" + FileNameUtils.digited(count) + ")." + extension);
        while (bkfile.exists()) {
            bkfile = new File(file.getParentFile(), String.valueOf(baseName) + "." + addextension + "(" + FileNameUtils.digited(count) + ")." + extension);
            ++count;
        }
        return bkfile;
    }

    public static File makeBackupFileWithHeader(File file, String addextension) {
        int count = 1;
        String baseName = FileNameUtils.getRemovedExtensionName(file.getName());
        String extension = FileNameUtils.getExtension(file.getName());
        File bkfile = new File(file.getParentFile(), String.valueOf(baseName) + "." + addextension + "(" + FileNameUtils.digited(count) + ")." + extension);
        while (bkfile.exists()) {
            bkfile = new File(file.getParentFile(), "(" + FileNameUtils.digited(count) + ")" + addextension + baseName + "." + extension);
            ++count;
        }
        return bkfile;
    }

    public static String digited(int value) {
        int d = 4;
        String r = "" + value;
        while (r.length() < d) {
            r = "0" + r;
        }
        return r;
    }

    public static String digited(int value, int d) {
        String r = "" + value;
        while (r.length() < d) {
            r = "0" + r;
        }
        return r;
    }

    public static boolean isAsciiFileName(String path) {
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) > '\u00ff') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isWaveFile(String name) {
        return name.toLowerCase().endsWith(".wav") || name.toLowerCase().endsWith(".wave");
    }

    public static String shortenFileName(String fileName) {
        String ret = fileName;
        if (SystemUtils.IS_OS_WINDOWS_XP) {
            if (fileName.startsWith(FileNameUtils.getDesktopPath())) {
                ret = StringUtils.replaceOnce((String)fileName, (String)FileNameUtils.getDesktopPath(), (String)LOCAL_NAME_DESKTOP);
            } else if (fileName.startsWith(FileNameUtils.getMyPicturesPath())) {
                ret = StringUtils.replaceOnce((String)fileName, (String)FileNameUtils.getMyPicturesPath(), (String)LOCAL_NAME_MY_PICTURE);
            } else if (fileName.startsWith(FileNameUtils.getMyVideoPath())) {
                ret = StringUtils.replaceOnce((String)fileName, (String)FileNameUtils.getMyVideoPath(), (String)LOCAL_NAME_MY_VIDEOS);
            } else if (fileName.startsWith(FileNameUtils.getMyMusicPath())) {
                ret = StringUtils.replaceOnce((String)fileName, (String)FileNameUtils.getMyMusicPath(), (String)LOCAL_NAME_MY_MUSIC);
            } else if (fileName.startsWith(FileNameUtils.getMyDocumentsPath())) {
                ret = StringUtils.replaceOnce((String)fileName, (String)FileNameUtils.getMyDocumentsPath(), (String)LOCAL_NAME_MY_DOCUMENTS);
            }
        } else if (FileNameUtils.isVista()) {
            if (fileName.startsWith(FileNameUtils.getDesktopPath())) {
                ret = StringUtils.replaceOnce((String)fileName, (String)FileNameUtils.getDesktopPath(), (String)LOCAL_NAME_DESKTOP);
            } else if (fileName.startsWith(FileNameUtils.getMyPicturesPath())) {
                ret = StringUtils.replaceOnce((String)fileName, (String)FileNameUtils.getMyPicturesPath(), (String)LOCAL_NAME_PICTURE);
            } else if (fileName.startsWith(FileNameUtils.getMyVideoPath())) {
                ret = StringUtils.replaceOnce((String)fileName, (String)FileNameUtils.getMyVideoPath(), (String)LOCAL_NAME_VIDEOS);
            } else if (fileName.startsWith(FileNameUtils.getMyMusicPath())) {
                ret = StringUtils.replaceOnce((String)fileName, (String)FileNameUtils.getMyMusicPath(), (String)LOCAL_NAME_MUSIC);
            } else if (fileName.startsWith(FileNameUtils.getMyDocumentsPath())) {
                ret = StringUtils.replaceOnce((String)fileName, (String)FileNameUtils.getMyDocumentsPath(), (String)LOCAL_NAME_DOCUMENTS);
            }
        }
        return ret;
    }

    public static String getDesktopPath() {
        if (FileNameUtils.isVista()) {
            return String.valueOf(System.getProperty("user.home")) + "\\" + "Desktop";
        }
        return String.valueOf(System.getProperty("user.home")) + "\\" + LOCAL_NAME_DESKTOP;
    }

    public static boolean isVista() {
        if (OS_NAME == null) {
            OS_NAME = System.getProperty("os.name");
        }
        return OS_NAME.indexOf(WINDOWS_VISTA) != -1;
    }

    public static String getMyDocumentsPath() {
        if (FileNameUtils.isVista()) {
            return String.valueOf(System.getProperty("user.home")) + "\\Documents";
        }
        return String.valueOf(System.getProperty("user.home")) + "\\My Documents";
    }

    public static String getMyPicturesPath() {
        if (FileNameUtils.isVista()) {
            return String.valueOf(System.getProperty("user.home")) + "\\Pictures";
        }
        return String.valueOf(System.getProperty("user.home")) + "\\My Documents\\My Pictures";
    }

    public static String getMyMusicPath() {
        if (FileNameUtils.isVista()) {
            return String.valueOf(System.getProperty("user.home")) + "\\Music";
        }
        return String.valueOf(System.getProperty("user.home")) + "\\My Documents\\My Music";
    }

    public static String getMyVideoPath() {
        if (FileNameUtils.isVista()) {
            return String.valueOf(System.getProperty("user.home")) + "\\Videos";
        }
        return String.valueOf(System.getProperty("user.home")) + "\\My Documents\\My Videos";
    }
}

