/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.parser;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.draw.DecoratedShapePainter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFileInfomation;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.subtitle.srt.SRTList;
import jp.sourceforge.akjrcp.subtitle.srt.SRTObject;
import jp.sourceforge.akjrcp.subtitle.srt.SRTParser;
import jp.sourceforge.akjrcp.text_douga.AudioData;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.DougaSystem;
import jp.sourceforge.akjrcp.text_douga.EffectData;
import jp.sourceforge.akjrcp.text_douga.ItemData;
import jp.sourceforge.akjrcp.text_douga.Messages;
import jp.sourceforge.akjrcp.text_douga.VideoData;
import jp.sourceforge.akjrcp.text_douga.audio.FileAudioData;
import jp.sourceforge.akjrcp.text_douga.audio.ZeroAudioData;
import jp.sourceforge.akjrcp.text_douga.effect.FillColorEffect;
import jp.sourceforge.akjrcp.text_douga.effect.FillImageEffect;
import jp.sourceforge.akjrcp.text_douga.effect.FrameImageEffect;
import jp.sourceforge.akjrcp.text_douga.effect.VideoEffect;
import jp.sourceforge.akjrcp.text_douga.item.AbstractItem;
import jp.sourceforge.akjrcp.text_douga.item.ColorItem;
import jp.sourceforge.akjrcp.text_douga.item.DrawingItem;
import jp.sourceforge.akjrcp.text_douga.item.GifAnimeItem;
import jp.sourceforge.akjrcp.text_douga.item.ImageItem;
import jp.sourceforge.akjrcp.text_douga.item.KaraokeItem;
import jp.sourceforge.akjrcp.text_douga.item.MultiStyledText;
import jp.sourceforge.akjrcp.text_douga.item.TextItem;
import jp.sourceforge.akjrcp.text_douga.parser.ColorLine;
import jp.sourceforge.akjrcp.text_douga.parser.CommentLine;
import jp.sourceforge.akjrcp.text_douga.parser.DataLine;
import jp.sourceforge.akjrcp.text_douga.parser.EmptyLine;
import jp.sourceforge.akjrcp.text_douga.parser.FileLine;
import jp.sourceforge.akjrcp.text_douga.parser.ParserUtils;
import jp.sourceforge.akjrcp.text_douga.parser.PropertyLine;
import jp.sourceforge.akjrcp.text_douga.parser.PropertyUtils;
import jp.sourceforge.akjrcp.text_douga.parser.TextDougaProperties;
import jp.sourceforge.akjrcp.text_douga.parser.TextLine;
import jp.sourceforge.akjrcp.text_douga.parser.URLLine;
import jp.sourceforge.akjrcp.text_douga.video.ColorVideoData;
import jp.sourceforge.akjrcp.text_douga.video.CopyVideoData;
import jp.sourceforge.akjrcp.text_douga.video.EffectableVideoData;
import jp.sourceforge.akjrcp.text_douga.video.FileVideoData;
import jp.sourceforge.akjrcp.text_douga.video.ImageVideoData;
import jp.sourceforge.akjrcp.util.DownloadUtils;
import jp.sourceforge.akjrcp.util.URLDownloader;
import jp.sourceforge.akjrcp.util.YoutubeUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleParser {
    public static Log log = LogFactory.getLog(SimpleParser.class);
    private File downloadedDir;
    private String ffmpegPath;
    private String youtubeDLPath;
    private String pythonPath;
    PropertyLine propertyLine = null;
    private DougaSystem dougaSystem;
    private List<VideoData> videoList;
    private List<AudioData> audioList;
    private File inputDir;
    private float default_other_transparent = 1.0f;
    private float default_color_transparent = 0.85f;
    private double default_color_duration = 1.0;
    private double default_text_fadein = 0.0;
    private double default_text_fadeout = 0.05;
    private double default_image_fadein = 0.1;
    private double default_image_fadeout = 0.2;
    private List<ItemData> itemList;
    private List<EffectData> effectList;
    private boolean cancelling;
    private Rectangle[] avoidSubtitleStrategies;
    private double exportFPS;
    private String exportSize;
    private TextDougaProperties defaultProperties = new TextDougaProperties();
    private Map<String, PropertyLine> classPropertiesMap = new HashMap<String, PropertyLine>();
    private TextDougaProperties currentProperties = null;
    double currentTime = 0.0;
    private boolean redownload;
    private FFMpegFLVParser fileInfoParser;
    private URLDownloader downloader;
    private Map<String, FFMpegFileInfomation> fileInfoMap = new HashMap<String, FFMpegFileInfomation>();
    Pattern multiStyledTextPattern = Pattern.compile("(.*?)\\{\\{(.+?) (.+?) \\}\\}");

    public SimpleParser(String ffmpegPath) {
        this.ffmpegPath = ffmpegPath;
        this.initAvoidRect();
        try {
            this.currentProperties = (TextDougaProperties)this.defaultProperties.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    private void initAvoidRect() {
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>();
        int i = 1;
        while (i <= 64) {
            rects.add(new Rectangle(0, 0, 1 * i, 0));
            rects.add(new Rectangle(0, 0, 0, 1 * i));
            ++i;
        }
        i = -32;
        while (i < 32) {
            int j = -32;
            while (j < 32) {
                rects.add(new Rectangle(0, j, 0, i));
                rects.add(new Rectangle(0, j, i, 0));
                rects.add(new Rectangle(j, 0, i, 0));
                rects.add(new Rectangle(j, 0, 0, i));
                ++j;
            }
            ++i;
        }
        i = 64;
        while (i <= 128) {
            rects.add(new Rectangle(0, 0, 1 * i, 0));
            rects.add(new Rectangle(0, 0, 0, 1 * i));
            ++i;
        }
        this.avoidSubtitleStrategies = rects.toArray(new Rectangle[rects.size()]);
    }

    public SimpleParser(String ffmpegPath, File downloadedDir) {
        this(ffmpegPath);
        this.downloadedDir = downloadedDir;
    }

    public SimpleParser(String ffmpegPath, File downloadedDir, String pythonPath, String youtubeDLPath) {
        this(ffmpegPath, downloadedDir);
        this.pythonPath = pythonPath;
        this.youtubeDLPath = youtubeDLPath;
    }

    public void parseProperty() throws IOException {
        boolean consume = false;
        String pline = null;
        if (this.propertyLine != null) {
            pline = this.propertyLine.getLine();
        }
        if (PropertyUtils.isDefaultAction(pline)) {
            if (pline.indexOf("effect") != -1) {
                log.warn((Object)"now not support any effect properties");
            }
            this.setProperties(this.defaultProperties);
            try {
                this.currentProperties = (TextDougaProperties)this.defaultProperties.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return;
        }
        if (PropertyUtils.isRestoreDefaultAction(pline)) {
            this.defaultProperties = new TextDougaProperties();
        } else if (PropertyUtils.isSetClassAction(pline)) {
            try {
                TextDougaProperties newProperties = (TextDougaProperties)this.defaultProperties.clone();
                String name = this.getProperty("class");
                if (name == null) {
                    DougaSystem.dougaLogger.warn(Messages.getString("no_class_name_defined"));
                } else {
                    this.setProperties(newProperties);
                    this.classPropertiesMap.put(name, this.propertyLine);
                }
                return;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        } else if (PropertyUtils.isLoadClassAction(pline)) {
            String name = this.getProperty("class");
            if (name == null) {
                DougaSystem.dougaLogger.warn(Messages.getString("no_class_name_defined"));
                return;
            }
            PropertyLine newP = this.classPropertiesMap.get(name);
            if (newP == null) {
                DougaSystem.dougaLogger.warn(String.valueOf(Messages.getString("class_not_setted")) + ":" + name);
                return;
            }
            try {
                TextDougaProperties newProperties = (TextDougaProperties)this.defaultProperties.clone();
                PropertyLine original = this.propertyLine;
                this.propertyLine = newP;
                this.setProperties(newProperties);
                this.propertyLine = original;
                this.setProperties(newProperties);
                this.currentProperties = newProperties;
                return;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        String video = this.getProperty("video");
        double duration = PropertyUtils.getDoubleValue(this.getProperty("duration"), -1.0);
        log.info((Object)("video=" + video));
        EffectableVideoData videoData = null;
        if (video != null) {
            if (ParserUtils.isColorText(video)) {
                int color = ParserUtils.toColor(video);
                videoData = new ColorVideoData(color);
                videoData.setDuration(duration);
                this.videoList.add(videoData);
                consume = true;
                log.info((Object)videoData);
            } else if (ParserUtils.getFileType(video) == 5) {
                String path = ParserUtils.toFilePath(this.inputDir, video);
                if (!new File(path).exists()) {
                    throw new IOException(String.valueOf(path) + " not found");
                }
                log.info((Object)("bgfile:" + path));
                videoData = new ImageVideoData(path);
                videoData.setDuration(duration);
                this.videoList.add(videoData);
                consume = true;
                log.info((Object)"ImageData added");
            } else if ("copy".equals(video)) {
                videoData = new CopyVideoData();
                videoData.setDuration(duration);
                this.videoList.add(videoData);
                consume = true;
            } else {
                log.warn((Object)("unknown video:" + video));
            }
        }
        String audio = this.getProperty("audio");
        log.info((Object)("audio=" + audio));
        if (audio != null && audio.equals("silence")) {
            ZeroAudioData zero = new ZeroAudioData();
            zero.setDuration(duration);
            if (videoData != null) {
                videoData.setAudioData(zero);
            }
            this.audioList.add(zero);
            consume = true;
            log.info((Object)"silenseData added");
        }
        try {
            this.currentProperties = (TextDougaProperties)this.defaultProperties.clone();
            log.info((Object)"currentProperties copied");
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (this.getProperty("default_text_fadein") != null) {
            this.default_text_fadein = PropertyUtils.getDoubleValue(this.getProperty("default_text_fadein"), this.default_text_fadein);
        }
        if (this.getProperty("default_text_fadeout") != null) {
            this.default_text_fadeout = PropertyUtils.getDoubleValue(this.getProperty("default_text_fadeout"), this.default_text_fadeout);
        }
        if (this.getProperty("default_image_fadein") != null) {
            this.default_image_fadein = PropertyUtils.getDoubleValue(this.getProperty("default_image_fadein"), this.default_image_fadein);
        }
        if (this.getProperty("default_image_fadeout") != null) {
            this.default_image_fadeout = PropertyUtils.getDoubleValue(this.getProperty("default_image_fadeout"), this.default_image_fadeout);
        }
        if (this.getProperty("default_color_duration") != null) {
            this.default_color_duration = PropertyUtils.getDoubleValue(this.getProperty("default_color_duration"), this.default_color_duration);
        }
        if (this.getProperty("default_color_transparent") != null) {
            this.default_color_transparent = PropertyUtils.getFloatValue(this.getProperty("default_color_transparent"), this.default_color_transparent);
        }
        if (this.getProperty("export_fps") != null) {
            double exportFPS = PropertyUtils.getDoubleValue(this.getProperty("export_fps"), 0.0);
            this.updateExportFPS(exportFPS);
        }
        if (this.getProperty("export_size") != null) {
            String exportSize = PropertyUtils.getStringValue(this.getProperty("export_size"), null);
            this.updateExportSize(exportSize);
        }
        if (this.getProperty("progress") != null) {
            double extraProgress = PropertyUtils.getDoubleValue(this.getProperty("progress"), 0.0);
            this.currentTime += extraProgress;
        }
        if (ParserUtils.isDrawText(pline)) {
            this.addDrawingItem(this.currentProperties);
            consume = true;
        }
        if (consume) {
            this.consumeProperty();
        } else {
            this.setProperties(this.currentProperties);
        }
    }

    private void addDrawingItem(TextDougaProperties properties) {
        this.setProperties(properties);
        DrawingItem item = new DrawingItem();
        item.setFill(properties.isFill());
        item.setLineSize(properties.getDraw_size());
        item.setColor(properties.getDraw_color());
        if ("line".equals(properties.getDraw_type())) {
            item.setDrawType(2);
        } else if ("oval".equals(properties.getDraw_type())) {
            item.setDrawType(1);
        } else {
            item.setDrawType(0);
        }
        float transparent = this.currentProperties.parseTransparent(this.default_other_transparent);
        double start = this.currentProperties.parseStartTime(-1.0);
        double duration = this.currentProperties.parseDuration(this.getDefaultDuration());
        double fadein = this.currentProperties.parseFadeIn(0.0);
        double fadeout = this.currentProperties.parseFadeOut(0.0);
        boolean noprogress = this.currentProperties.isNoProgress();
        if (start >= 0.0) {
            log.info((Object)"text start>=0 && noprogress");
            item.setStartTime(start);
            noprogress = true;
        } else {
            item.setStartTime(this.currentTime);
        }
        item.setTransparent(transparent);
        item.setMoveX(this.currentProperties.getMove_x());
        item.setMoveY(this.currentProperties.getMove_y());
        item.setMoveWidth(this.currentProperties.getMove_width());
        item.setMoveHeight(this.currentProperties.getMove_height());
        item.setDuration(duration);
        item.setFadeInTime(fadein);
        item.setFadeOutTime(fadeout);
        ItemLocationAndAlign ia = new ItemLocationAndAlign(0, 0, 0, 0, 0, 2, 3, true);
        ia.loadProperty();
        ia.setUpItem(item);
        item.setAntialiase(this.currentProperties.isDraw_antialiase());
        this.itemList.add(item);
        if (!noprogress) {
            this.progressTime();
        }
    }

    private void setProperties(TextDougaProperties properties) {
        if (this.getProperty("line_fps") != null) {
            properties.setLine_fps(PropertyUtils.getDoubleValue(this.getProperty("line_fps"), properties.getLine_fps()));
        }
        if (this.getProperty("line_duration") != null) {
            properties.setLine_duration(PropertyUtils.getDoubleValue(this.getProperty("line_duration"), properties.getLine_duration()));
        }
        if (this.getProperty("font_name") != null) {
            properties.setFont_name(PropertyUtils.getStringValue(this.getProperty("font_name"), properties.getFont_name()));
        }
        if (this.getProperty("font_style") != null) {
            properties.setFont_style(PropertyUtils.getStringValue(this.getProperty("font_style"), properties.getFont_style()));
        }
        if (this.getProperty("font_size") != null) {
            properties.setFont_size(PropertyUtils.getIntValue(this.getProperty("font_size"), properties.getFont_size()));
        }
        if (this.getProperty("text_antialiase") != null) {
            properties.setText_antialiase(PropertyUtils.getBooleanValue(this.getProperty("text_antialiase"), properties.isText_antialiase()));
        }
        if (this.getProperty("text_draw_line") != null) {
            properties.setText_draw_line(PropertyUtils.getBooleanValue(this.getProperty("text_draw_line"), properties.isText_draw_line()));
        }
        if (this.getProperty("text_draw_border") != null) {
            properties.setText_draw_border(PropertyUtils.getBooleanValue(this.getProperty("text_draw_border"), properties.isText_draw_border()));
        }
        if (this.getProperty("text_draw_shadow") != null) {
            properties.setText_draw_shadow(PropertyUtils.getBooleanValue(this.getProperty("text_draw_shadow"), properties.isText_draw_shadow()));
        }
        if (this.getProperty("text_line_color") != null) {
            properties.setText_line_color(PropertyUtils.getColorValue(this.getProperty("text_line_color"), properties.getText_line_color()));
        }
        if (this.getProperty("text_border_color") != null) {
            properties.setText_border_color(PropertyUtils.getColorValue(this.getProperty("text_border_color"), properties.getText_border_color()));
        }
        if (this.getProperty("text_select_color") != null) {
            properties.setText_select_color(PropertyUtils.getColorValue(this.getProperty("text_select_color"), properties.getText_select_color()));
        }
        if (this.getProperty("text_shadow_color") != null) {
            properties.setText_shadow_color(PropertyUtils.getColorValue(this.getProperty("text_shadow_color"), properties.getText_shadow_color()));
        }
        if (this.getProperty("text_border_size") != null) {
            properties.setText_border_size(PropertyUtils.getIntValue(this.getProperty("text_border_size"), properties.getText_border_size()));
        }
        if (this.getProperty("text_shadow_x") != null) {
            properties.setText_shadow_x(PropertyUtils.getIntValue(this.getProperty("text_shadow_x"), properties.getText_shadow_x()));
        }
        if (this.getProperty("text_shadow_y") != null) {
            properties.setText_shadow_y(PropertyUtils.getIntValue(this.getProperty("text_shadow_y"), properties.getText_shadow_y()));
        }
        if (this.getProperty("overwrap_subtitle") != null) {
            properties.setOverwrap_subtitle(PropertyUtils.getBooleanValue(this.getProperty("overwrap_subtitle"), properties.isOverwrap_subtitle()));
        }
        if (this.getProperty("noprogress") != null) {
            properties.setNoProgress(PropertyUtils.getBooleanValue(this.getProperty("noprogress"), properties.isNoProgress()));
        }
        if (this.getProperty("fadein") != null) {
            properties.setFadein(PropertyUtils.getDoubleValue(this.getProperty("fadein"), properties.getFadein()));
        }
        if (this.getProperty("fadeout") != null) {
            properties.setFadeout(PropertyUtils.getDoubleValue(this.getProperty("fadeout"), properties.getFadeout()));
        }
        if (this.getProperty("transparent") != null) {
            properties.setTransparent(PropertyUtils.getPersentFloatValue(this.getProperty("transparent"), properties.getTransparent()));
        }
        if (this.getProperty("duration") != null) {
            properties.setDuration(PropertyUtils.getDoubleValue(this.getProperty("duration"), properties.getDuration()));
        }
        if (this.getProperty("start") != null) {
            properties.setStart(PropertyUtils.getDoubleValue(this.getProperty("start"), properties.getStart()));
        }
        if (this.getProperty("x") != null) {
            properties.setX(PropertyUtils.getIntValue(this.getProperty("x"), properties.getX()));
        }
        if (this.getProperty("y") != null) {
            properties.setY(PropertyUtils.getIntValue(this.getProperty("y"), properties.getY()));
        }
        if (this.getProperty("z") != null) {
            properties.setZ(PropertyUtils.getIntValue(this.getProperty("z"), properties.getZ()));
        }
        if (this.getProperty("loop") != null) {
            properties.setLoop(PropertyUtils.getIntValue(this.getProperty("loop"), properties.getLoop()));
        }
        if (this.getProperty("width") != null) {
            properties.setWidth(PropertyUtils.getIntValue(this.getProperty("width"), properties.getWidth()));
        }
        if (this.getProperty("height") != null) {
            properties.setHeight(PropertyUtils.getIntValue(this.getProperty("height"), properties.getHeight()));
        }
        if (this.getProperty("move_x") != null) {
            properties.setMove_x(PropertyUtils.getIntValue(this.getProperty("move_x"), properties.getMove_x()));
        }
        if (this.getProperty("move_y") != null) {
            properties.setMove_y(PropertyUtils.getIntValue(this.getProperty("move_y"), properties.getMove_y()));
        }
        if (this.getProperty("move_w") != null) {
            properties.setMove_width(PropertyUtils.getIntValue(this.getProperty("move_w"), properties.getMove_width()));
        }
        if (this.getProperty("move_h") != null) {
            properties.setMove_height(PropertyUtils.getIntValue(this.getProperty("move_h"), properties.getMove_height()));
        }
        if (this.getProperty("shear_x") != null) {
            properties.setShear_x(PropertyUtils.getDoubleValue(this.getProperty("shear_x"), properties.getShear_x()));
        }
        if (this.getProperty("shear_y") != null) {
            properties.setShear_y(PropertyUtils.getDoubleValue(this.getProperty("shear_y"), properties.getShear_y()));
        }
        if (this.getProperty("move_rotate") != null) {
            properties.setMove_rotate(PropertyUtils.getIntValue(this.getProperty("move_rotate"), properties.getMove_rotate()));
        }
        if (this.getProperty("rotate") != null) {
            properties.setRotate(PropertyUtils.getIntValue(this.getProperty("rotate"), properties.getRotate()));
        }
        if (this.getProperty("align") != null) {
            String avalue = PropertyUtils.getStringValue(this.getProperty("align"), "");
            int align = properties.getAlign();
            if (avalue.equals("center")) {
                align = 2;
            } else if (avalue.equals("left")) {
                align = 1;
            } else if (avalue.equals("right")) {
                align = 3;
            }
            properties.setAlign(align);
        }
        if (this.getProperty("valign") != null) {
            String vvalue = PropertyUtils.getStringValue(this.getProperty("valign"), "");
            int valign = properties.getValign();
            if (vvalue.equals("center")) {
                valign = 2;
            } else if (vvalue.equals("middle")) {
                valign = 2;
            } else if (vvalue.equals("top")) {
                valign = 1;
            } else if (vvalue.equals("bottom")) {
                valign = 3;
            }
            properties.setValign(valign);
        }
        if (this.getProperty("timing") != null) {
            properties.setTiming(PropertyUtils.getStringValue(this.getProperty("timing"), properties.getTiming()));
        }
        if (this.getProperty("text_type") != null) {
            properties.setText_type(PropertyUtils.getStringValue(this.getProperty("text_type"), properties.getText_type()));
        }
        if (this.getProperty("keepaspect") != null) {
            properties.setKeepAspect(PropertyUtils.getBooleanValue(this.getProperty("keepaspect"), properties.isKeepAspect()));
        }
        if (this.getProperty("fill") != null) {
            properties.setFill(PropertyUtils.getBooleanValue(this.getProperty("fill"), properties.isFill()));
        }
        if (this.getProperty("draw_type") != null) {
            properties.setDraw_type(PropertyUtils.getStringValue(this.getProperty("draw_type"), properties.getDraw_type()));
        }
        if (this.getProperty("draw_size") != null) {
            properties.setDraw_size(PropertyUtils.getIntValue(this.getProperty("draw_size"), properties.getDraw_size()));
        }
        if (this.getProperty("draw_color") != null) {
            properties.setDraw_color(PropertyUtils.getColorValue(this.getProperty("draw_color"), properties.getDraw_color()));
        }
        if (this.getProperty("draw_antialiase") != null) {
            properties.setDraw_antialiase(PropertyUtils.getBooleanValue(this.getProperty("draw_antialiase"), properties.isDraw_antialiase()));
        }
    }

    private void updateExportFPS(double fps) {
        this.dougaSystem.getVideoSystem().getDougaPreference().setFps(fps);
        this.dougaSystem.getAudioSystem().getDougaPreference().setFps(fps);
    }

    private void updateExportSize(String size) {
        if (size == null) {
            return;
        }
        int[] w_h = FFMpegUtils.sizeToWidthHeight((String)size);
        if (w_h != null) {
            this.dougaSystem.getVideoSystem().getDougaPreference().setWidth(w_h[0]);
            this.dougaSystem.getVideoSystem().getDougaPreference().setHeight(w_h[1]);
            this.dougaSystem.getAudioSystem().getDougaPreference().setWidth(w_h[0]);
            this.dougaSystem.getAudioSystem().getDougaPreference().setHeight(w_h[1]);
        }
    }

    public void progressTime() {
        this.currentTime += this.currentProperties.getLine_fps();
    }

    public DougaSystem parseTextDouga(File textd) throws IOException {
        String text = IOUtils.toString((Reader)new FileReader(textd));
        return this.parseTextDouga(text, textd.getParentFile());
    }

    public DougaSystem parseTextDouga(String text, File dir) throws IOException {
        return this.parseTextDouga(text, dir, null);
    }

    public DougaSystem parseTextDouga(String text, File dir, DougaPreference preference) throws IOException {
        ColorVideoData data;
        double lastTime;
        URLLine urlLine;
        this.inputDir = dir;
        this.dougaSystem = new DougaSystem();
        if (preference != null) {
            this.dougaSystem.getVideoSystem().setDougaPreference(preference);
            this.dougaSystem.getAudioSystem().setDougaPreference(preference);
        }
        this.dougaSystem.setFfmpegPath(this.ffmpegPath);
        this.videoList = new ArrayList<VideoData>();
        this.audioList = new ArrayList<AudioData>();
        this.itemList = new ArrayList<ItemData>();
        this.effectList = new ArrayList<EffectData>();
        DataLine[] dataLines = ParserUtils.parseDataLines(this.inputDir, text);
        int downloadItem = 0;
        int i = 0;
        while (i < dataLines.length) {
            if (dataLines[i] instanceof URLLine) {
                urlLine = (URLLine)dataLines[i];
                if (YoutubeUtils.isYoutubeVideoURL((String)urlLine.getLine())) {
                    urlLine.setAbsolutePath(this.downloadedDir + "\\youtube.com\\" + YoutubeUtils.toFLVFileName((URL)new URL(urlLine.getLine())));
                } else {
                    urlLine.setAbsolutePath(DownloadUtils.toDownloadFile((File)this.downloadedDir, (URL)new URL(urlLine.getLine())).getAbsolutePath());
                }
                ++downloadItem;
            }
            if (this.cancelling) {
                return null;
            }
            ++i;
        }
        i = 0;
        while (i < dataLines.length) {
            if (dataLines[i] instanceof URLLine) {
                urlLine = (URLLine)dataLines[i];
                File saveFile = new File(urlLine.getAbsolutePath());
                if (!saveFile.exists() || saveFile.length() <= 0L || this.redownload) {
                    if ((this.youtubeDLPath == null || this.youtubeDLPath.length() == 0 || !new File(this.youtubeDLPath).exists()) && YoutubeUtils.isYoutubeVideoURL((String)urlLine.getLine())) {
                        DougaSystem.dougaLogger.error(Messages.getString("textdouga.need_youtubedl"));
                        throw new IOException("youtube dl not found");
                    }
                    DougaSystem.dougaLogger.info(String.valueOf(Messages.getString("textdouga.start_download")) + ":" + urlLine.getLine());
                    this.downloader = new URLDownloader();
                    this.downloader.setPythonPath(this.pythonPath);
                    this.downloader.setYoutubeDLPath(this.youtubeDLPath);
                    saveFile.getParentFile().mkdirs();
                    this.downloader.download(new URL(urlLine.getLine()), saveFile);
                    DougaSystem.dougaLogger.info(String.valueOf(Messages.getString("textdouga.finish_download")) + ":" + saveFile.getName());
                    this.downloader = null;
                }
                if (this.cancelling) {
                    return null;
                }
            }
            ++i;
        }
        i = 0;
        while (i < dataLines.length) {
            log.info((Object)("item:" + dataLines[i]));
            ++i;
        }
        this.fileInfoParser = new FFMpegFLVParser(this.ffmpegPath);
        i = 0;
        while (i < dataLines.length) {
            if (dataLines[i] instanceof URLLine) {
                urlLine = (URLLine)dataLines[i];
                this.parseURLLine(urlLine);
                this.consumeProperty();
            } else if (dataLines[i] instanceof PropertyLine) {
                this.propertyLine = (PropertyLine)dataLines[i];
                this.parseProperty();
            } else if (dataLines[i] instanceof ColorLine) {
                this.parseColorLine((ColorLine)dataLines[i]);
                this.consumeProperty();
            } else if (dataLines[i] instanceof CommentLine) {
                log.info((Object)dataLines[i]);
            } else if (dataLines[i] instanceof EmptyLine) {
                this.progressTime();
                this.consumeProperty();
            } else if (dataLines[i] instanceof FileLine) {
                FileLine fileLine = (FileLine)dataLines[i];
                this.parseFileLine(fileLine);
                this.consumeProperty();
            } else if (dataLines[i] instanceof TextLine) {
                this.parseTextLine((TextLine)dataLines[i]);
                this.consumeProperty();
            }
            ++i;
        }
        double totalVideo = 0.0;
        double totalAudio = 0.0;
        for (VideoData data2 : this.videoList) {
            this.dougaSystem.getVideoSystem().addVideoData(data2);
            if (totalVideo == -1.0) continue;
            double v = data2.getTotalTime();
            if (v != -1.0) {
                totalVideo += v;
                continue;
            }
            totalVideo = -1.0;
        }
        for (AudioData data3 : this.audioList) {
            this.dougaSystem.getAudioSystem().addAudioData(data3);
            if (totalAudio == -1.0) continue;
            double v = data3.getTotalTime();
            if (v != -1.0) {
                totalAudio += v;
                continue;
            }
            totalAudio = -1.0;
        }
        Iterator<ItemData> iter3 = this.itemList.iterator();
        while (iter3.hasNext()) {
            this.dougaSystem.getVideoSystem().addItemData(iter3.next());
        }
        Iterator<EffectData> iter4 = this.effectList.iterator();
        while (iter4.hasNext()) {
            this.dougaSystem.getVideoSystem().addEffectData(iter4.next());
        }
        log.info((Object)("videoDatas:" + this.dougaSystem.getVideoSystem().getVideoDatas().length));
        VideoData[] videos = this.dougaSystem.getVideoSystem().getVideoDatas();
        int i2 = 0;
        while (i2 < videos.length) {
            System.out.println("(" + (i2 + 1) + ")" + videos[i2]);
            ++i2;
        }
        log.info((Object)("audioDatas:" + this.dougaSystem.getAudioSystem().getAudioDatas().length));
        AudioData[] audios = this.dougaSystem.getAudioSystem().getAudioDatas();
        int i3 = 0;
        while (i3 < audios.length) {
            System.out.println("(" + (i3 + 1) + ")" + audios[i3]);
            ++i3;
        }
        log.info((Object)("itemDatas:" + this.dougaSystem.getVideoSystem().getSortedItemDatas().length));
        ItemData[] items = this.dougaSystem.getVideoSystem().getSortedItemDatas();
        int i4 = 0;
        while (i4 < items.length) {
            System.out.println("(" + (i4 + 1) + ")" + items[i4]);
            ++i4;
        }
        log.info((Object)("videoLength:" + totalVideo));
        log.info((Object)("audioLength:" + totalAudio));
        if (totalVideo == 0.0 && totalAudio == 0.0 && (lastTime = this.getLastItemTime()) > 0.0) {
            data = new ColorVideoData(0);
            data.setDuration(-1.0);
            this.dougaSystem.getVideoSystem().addVideoData(data);
            totalVideo = -1.0;
        }
        if (totalVideo == -1.0 && totalAudio == -1.0) {
            lastTime = this.getLastItemTime();
            if (lastTime == 0.0) {
                throw new IOException("audio & video both play forever");
            }
            this.dougaSystem.getVideoSystem().setMaxTime(lastTime);
            this.dougaSystem.getAudioSystem().setMaxTime(lastTime);
        } else if (totalVideo == -1.0) {
            if (totalAudio == 0.0) {
                lastTime = this.getLastItemTime();
                if (lastTime == 0.0) {
                    throw new IOException("forever play video need audio");
                }
                this.dougaSystem.getVideoSystem().setMaxTime(lastTime);
            } else {
                this.dougaSystem.getVideoSystem().setMaxTime(totalAudio);
            }
        } else if (totalAudio == -1.0) {
            if (totalVideo == 0.0) {
                lastTime = this.getLastItemTime();
                if (lastTime == 0.0) {
                    throw new IOException("forever play audio need video");
                }
                data = new ColorVideoData(0);
                data.setDuration(lastTime);
                this.dougaSystem.getVideoSystem().addVideoData(data);
                this.dougaSystem.getAudioSystem().setMaxTime(lastTime);
            } else {
                this.dougaSystem.getAudioSystem().setMaxTime(totalVideo);
            }
        } else if (totalVideo == 0.0 && (lastTime = this.getLastItemTime()) > 0.0) {
            log.info((Object)"audio and item data:add video");
            data = new ColorVideoData(0);
            data.setDuration(totalAudio);
            this.dougaSystem.getVideoSystem().addVideoData(data);
            totalVideo = totalAudio;
        }
        log.info((Object)("totalAudio:=" + totalAudio + " totalVideo=" + totalVideo));
        Iterator<VideoData> tmpIter = this.videoList.iterator();
        double currentTime = 0.0;
        double fps = this.dougaSystem.getVideoSystem().getDougaPreference().getFps();
        while (tmpIter.hasNext()) {
            double v;
            VideoData data4 = tmpIter.next();
            EffectableVideoData effectable = null;
            if (data4 instanceof EffectableVideoData) {
                effectable = (EffectableVideoData)data4;
            }
            if (effectable != null && effectable.getStartEffect() != null) {
                int keyFrame = (int)(currentTime * fps + 1.0);
                effectable.getStartEffect().setKeyFrame(keyFrame);
                System.out.println("start:" + keyFrame);
            }
            if ((v = data4.getTotalTime()) != -1.0) {
                int frames = (int)(v * fps);
                System.out.println("v=" + v + ",fps=" + this.dougaSystem.getVideoSystem().getDougaPreference().getFps() + " = " + v * this.dougaSystem.getVideoSystem().getDougaPreference().getFps());
                System.out.println("frames=" + frames + "," + data4);
                currentTime += v;
                if (effectable == null || effectable.getEndEffect() == null) continue;
                int keyFrame = (int)(currentTime * fps + 1.0);
                effectable.getEndEffect().setKeyFrame(keyFrame);
                System.out.println("end:" + keyFrame);
                continue;
            }
            double duration = this.dougaSystem.getVideoSystem().getMaxTime() - currentTime;
            int keyFrame = (int)((double)((float)duration) * fps);
            if (effectable == null || effectable.getEndEffect() == null) break;
            effectable.getEndEffect().setKeyFrame(keyFrame);
            System.out.println("end:" + keyFrame);
            break;
        }
        log.info((Object)("effectDatas:" + this.dougaSystem.getVideoSystem().getEffectDatas().length));
        EffectData[] effects = this.dougaSystem.getVideoSystem().getEffectDatas();
        int i5 = 0;
        while (i5 < effects.length) {
            System.out.println("(" + (i5 + 1) + ")" + effects[i5]);
            ++i5;
        }
        if (totalVideo > 3600.0 || totalAudio > 3600.0) {
            throw new IOException("audio or video is too long ,now support under 30 minute for safety");
        }
        return this.dougaSystem;
    }

    private double getLastItemTime() {
        double last = 0.0;
        for (ItemData data : this.itemList) {
            last = Math.max(last, data.getLastTime());
        }
        return last;
    }

    private void parseColorLine(ColorLine line) {
        double start = this.currentProperties.parseStartTime(this.currentTime);
        double duration = this.currentProperties.parseDuration(this.getDefaultDuration());
        float transparent = this.currentProperties.parseTransparent(this.default_color_transparent);
        double fadein = this.currentProperties.parseFadeIn(0.2);
        double fadeout = this.currentProperties.parseFadeOut(0.2);
        ColorItem item = new ColorItem(line.getColor(), transparent);
        item.setStartTime(start);
        item.setDuration(duration);
        item.setFadeInTime(fadein);
        item.setFadeOutTime(fadeout);
        this.itemList.add(item);
        this.processProgressTime();
    }

    private void processProgressTime() {
        if (!this.currentProperties.isNoProgress() && this.currentProperties.getStart() < 0.0) {
            this.progressTime();
        }
    }

    public void parseURLLine(URLLine urlLine) throws IOException {
        String path = urlLine.getAbsolutePath();
        int type = ParserUtils.getFileType(urlLine.getAbsolutePath());
        if (type == 1) {
            this.parseVideoFile(new File(path));
        } else if (type == 2) {
            this.parseAudioFile(new File(path));
        } else if (type == 5) {
            this.parseImageFile(new File(path));
            this.processProgressTime();
        }
    }

    public void parseAudioFile(File file) {
        double start = this.currentProperties.getStart();
        double duration = this.currentProperties.getDuration();
        int loop = this.currentProperties.getLoop();
        FFMpegFileInfomation info = this.parseFileInfomation(file);
        FileAudioData adata = new FileAudioData(file.getAbsolutePath());
        adata.setStartTime(start);
        adata.setDuration(duration);
        adata.setLoop(loop);
        adata.setLogicalTime(FFMpegUtils.timeToDouble((String)info.getDuration()));
        this.audioList.add(adata);
    }

    private FFMpegFileInfomation parseFileInfomation(File file) {
        FFMpegFileInfomation info = this.fileInfoMap.get(file.getAbsolutePath());
        if (info == null) {
            info = this.fileInfoParser.parseFile(file);
            this.fileInfoMap.put(file.getAbsolutePath(), info);
        }
        return info;
    }

    public void parseVideoFile(File file) throws IOException {
        double start = this.currentProperties.getStart();
        double duration = this.currentProperties.getDuration();
        int loop = this.currentProperties.getLoop();
        boolean addVideo = true;
        boolean addAudio = true;
        String v = this.getProperty("novideo");
        String a = this.getProperty("noaudio");
        if (a != null) {
            addAudio = false;
        }
        if (v != null) {
            addVideo = false;
        }
        FFMpegFileInfomation info = this.parseFileInfomation(file);
        FileVideoData fdata = null;
        if (addVideo) {
            if (!info.isHaveVideo()) {
                System.out.println(this.fileInfoParser.getLogText());
                throw new IOException("no video wrong file:");
            }
            fdata = new FileVideoData(file.getAbsolutePath());
            fdata.setStartTime(start);
            fdata.setDuration(duration);
            fdata.setLoop(loop);
            this.videoList.add(fdata);
            fdata.setLogicalTime(FFMpegUtils.timeToDouble((String)info.getDuration()));
            this.parseVideoEffect(fdata);
        }
        if (addAudio) {
            if (info.isHaveAudio()) {
                FileAudioData adata = new FileAudioData(file.getAbsolutePath());
                adata.setStartTime(start);
                adata.setDuration(duration);
                adata.setLoop(loop);
                adata.setLogicalTime(FFMpegUtils.timeToDouble((String)info.getDuration()));
                this.audioList.add(adata);
                if (fdata != null) {
                    fdata.setAudioData(adata);
                }
            } else {
                log.warn((Object)("this video has no audio:" + file.getAbsolutePath()));
            }
        }
    }

    private void parseVideoEffect(FileVideoData fdata) {
        VideoEffect videoEffect;
        int effect = PropertyUtils.getIntValue(this.getProperty("effect"), 0);
        int start_effect = PropertyUtils.getIntValue(this.getProperty("start_effect"), 0);
        int end_effect = PropertyUtils.getIntValue(this.getProperty("end_effect"), 0);
        double effect_before = PropertyUtils.getDoubleValue(this.getProperty("effect_before"), 0.2);
        double effect_after = PropertyUtils.getDoubleValue(this.getProperty("effect_after"), 0.2);
        double effect_full = PropertyUtils.getDoubleValue(this.getProperty("effect_full"), 0.1);
        int color = PropertyUtils.getColorValue(this.getProperty("effect_color"), 0);
        File imageFile = PropertyUtils.getFileValue(this.getProperty("effect_image"), this.inputDir, null);
        BufferedImage image = null;
        if (imageFile != null) {
            try {
                ImageIO.read(imageFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (effect > 0) {
            videoEffect = null;
            switch (effect) {
                case 1: {
                    break;
                }
                case 2: {
                    videoEffect = new FillColorEffect(color);
                    break;
                }
                case 3: {
                    if (image == null) break;
                    videoEffect = new FillImageEffect(image);
                }
            }
            if (videoEffect != null) {
                videoEffect.setMode(-1);
                if (!(videoEffect instanceof FrameImageEffect)) {
                    videoEffect.setBeforeTime(effect_before);
                    videoEffect.setAfterTime(effect_after);
                    videoEffect.setFullEffectTime(effect_full);
                }
                this.effectList.add(videoEffect);
            }
        }
        if (start_effect > 0) {
            videoEffect = null;
            switch (start_effect) {
                case 1: {
                    videoEffect = new FrameImageEffect(false, effect_after);
                    break;
                }
                case 2: {
                    videoEffect = new FillColorEffect(color);
                    break;
                }
                case 3: {
                    if (image == null) break;
                    videoEffect = new FillImageEffect(image);
                }
            }
            if (videoEffect != null) {
                if (!(videoEffect instanceof FrameImageEffect)) {
                    videoEffect.setBeforeTime(effect_before);
                    videoEffect.setAfterTime(effect_after);
                    videoEffect.setFullEffectTime(effect_full);
                }
                fdata.setStartEffect(videoEffect);
                this.effectList.add(videoEffect);
            }
        }
        if (end_effect > 0) {
            videoEffect = null;
            switch (end_effect) {
                case 1: {
                    break;
                }
                case 2: {
                    videoEffect = new FillColorEffect(color);
                    break;
                }
                case 3: {
                    if (image == null) break;
                    videoEffect = new FillImageEffect(image);
                }
            }
            if (videoEffect != null) {
                if (!(videoEffect instanceof FrameImageEffect)) {
                    videoEffect.setBeforeTime(effect_before);
                    videoEffect.setAfterTime(effect_after);
                    videoEffect.setFullEffectTime(effect_full);
                }
                fdata.setEndEffect(videoEffect);
                this.effectList.add(videoEffect);
            }
        }
    }

    public void parserDirectoryFile(File dir) {
        int loop = this.currentProperties.getLoop();
        if (loop <= 0) {
            log.info((Object)("wrong loop:" + this.getProperty("loop")));
            loop = 1;
        }
        double start = this.currentProperties.parseStartTime(this.currentTime);
        double duration = this.currentProperties.parseDuration(1.0);
        double wait = PropertyUtils.getDoubleValue(this.getProperty("wait"), 0.1);
        double fadein = this.currentProperties.parseFadeIn(0.2);
        double fadeout = this.currentProperties.parseFadeOut(0.2);
        double transparent = this.currentProperties.parseTransparent(this.default_other_transparent);
        String[] list = dir.list();
        double time = start;
        int added = 0;
        if (list != null) {
            ItemLocationAndAlign ia = new ItemLocationAndAlign(0, 0, 0, 0, 0, 2, 2, true);
            ia.loadProperty();
            int i = 0;
            while (i < loop) {
                int j = 0;
                while (j < list.length) {
                    if (ParserUtils.getFileType(list[j]) == 5) {
                        ImageItem item = this.createImageItem(new File(dir, list[j]), 1);
                        ia.setUpItem(item);
                        item.setStartTime(time);
                        item.setDuration(duration);
                        item.setTransparent((float)transparent);
                        item.setFadeInTime(fadein);
                        item.setFadeOutTime(fadeout);
                        item.setMoveX(this.currentProperties.getMove_x());
                        item.setMoveY(this.currentProperties.getMove_y());
                        item.setMoveWidth(this.currentProperties.getMove_width());
                        item.setMoveHeight(this.currentProperties.getMove_height());
                        this.itemList.add(item);
                        ++added;
                        log.info((Object)("start=" + time + " duration=" + duration + " img=" + item.getInputPath()));
                        time += duration + wait;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            log.warn((Object)("list null:" + dir));
        }
        log.info((Object)("add dir images " + added + " as item overray=" + transparent));
    }

    public void parseFileLine(FileLine fileLine) throws IOException {
        int type = ParserUtils.getFileType(fileLine.getAbsolutePath());
        if (type == 1) {
            this.parseVideoFile(fileLine.getFile());
        } else if (type == 3) {
            this.parserDirectoryFile(fileLine.getFile());
        } else if (type == 2) {
            this.parseAudioFile(fileLine.getFile());
        } else if (type == 5) {
            this.parseImageFile(fileLine.getFile());
        } else if (type == 6) {
            this.parseSubtitleFile(fileLine.getFile());
        }
        this.consumeProperty();
    }

    private ImageItem createImageItem(File imageFile, int loop) {
        if (imageFile.getName().toLowerCase().endsWith(".gif")) {
            GifAnimeItem item = new GifAnimeItem();
            item.setLoop(loop);
            item.setInputPath(imageFile.getAbsolutePath());
            return item;
        }
        ImageItem item = new ImageItem();
        item.setInputPath(imageFile.getAbsolutePath());
        return item;
    }

    private double getDefaultDuration() {
        double default_d = this.defaultProperties.getLine_fps();
        if (this.defaultProperties.getLine_duration() > 0.0) {
            default_d = this.defaultProperties.getLine_duration();
        }
        return default_d;
    }

    private void parseSubtitleFile(File file) {
        double start_offset = this.currentProperties.getStart();
        String type = this.currentProperties.getText_type();
        ItemLocationAndAlign ia = new ItemLocationAndAlign(0, 0, 0, 0, 0, 2, 3, true);
        ia.loadProperty();
        double fadein = this.currentProperties.parseFadeIn(this.default_text_fadein);
        double fadeout = this.currentProperties.parseFadeOut(this.default_text_fadeout);
        float transparent = this.currentProperties.parseTransparent(this.default_other_transparent);
        SRTParser parser = new SRTParser();
        try {
            SRTList srtList = parser.parse((Reader)new FileReader(file));
            int i = 0;
            while (i < srtList.size()) {
                SRTObject srt = srtList.getSRTObjectAt(i);
                TextItem item = type.equals("karaoke") ? new KaraokeItem("") : new TextItem("");
                ia.setUpItem(item);
                item.setTransparent(transparent);
                if (srt.getText() != null) {
                    log.info((Object)("'" + srt.getText() + "'"));
                    item.setText(srt.getText());
                    double stime = (double)srt.getStartTime().getTime() / 1000.0 + start_offset;
                    double etime = (double)srt.getEndTime().getTime() / 1000.0 + start_offset;
                    item.setStartTime(stime);
                    item.setDuration(etime - stime);
                    ArrayList<TextItem> beforeText = new ArrayList<TextItem>();
                    int j = this.itemList.size() - 1;
                    while (j >= 0) {
                        TextItem tmp;
                        if (this.itemList.get(j) instanceof TextItem && AbstractItem.isOverwrapTime(item, tmp = (TextItem)this.itemList.get(j))) {
                            beforeText.add(tmp);
                        }
                        --j;
                    }
                    item.setFadeInTime(fadein);
                    item.setFadeOutTime(fadeout);
                    item.setMoveX(this.currentProperties.getMove_x());
                    item.setMoveY(this.currentProperties.getMove_y());
                    item.setMoveWidth(this.currentProperties.getMove_width());
                    item.setMoveHeight(this.currentProperties.getMove_height());
                    this.setUpTextDecoration(item);
                    if (!this.currentProperties.isOverwrap_subtitle()) {
                        this.resetRect(item, beforeText);
                    }
                    this.itemList.add(item);
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            DougaSystem.dougaLogger.error("srt:problem " + file.getAbsolutePath());
            return;
        }
    }

    private void resetRect(TextItem item, List<TextItem> textItems) {
        int expand = 6;
        int moved = 10;
        if (textItems.size() == 0) {
            return;
        }
        log.trace((Object)("same item:" + textItems.size()));
        BufferedImage tmpImage = new BufferedImage(1, 1, 1);
        Graphics2D g2 = (Graphics2D)tmpImage.getGraphics();
        item.initializeShape(g2, this.dougaSystem.getVideoSystem().getDougaPreference());
        Rectangle current = item.getDrawRect(this.dougaSystem.getVideoSystem().getDougaPreference(), tmpImage);
        System.out.println("current:" + current);
        Rectangle[] otherRects = new Rectangle[textItems.size()];
        int i = 0;
        while (i < otherRects.length) {
            TextItem text = textItems.get(i);
            text.initializeShape(g2, this.dougaSystem.getVideoSystem().getDougaPreference());
            otherRects[i] = text.getDrawRect(this.dougaSystem.getVideoSystem().getDougaPreference(), tmpImage);
            otherRects[i].x -= expand;
            otherRects[i].y -= expand;
            otherRects[i].width += expand * 2;
            otherRects[i].height += expand * 2;
            ++i;
        }
        boolean faild = false;
        boolean changed = false;
        boolean avoided = false;
        int strategy = 0;
        Rectangle checkRect = new Rectangle(current);
        while (!avoided) {
            avoided = true;
            if (!this.inScreen(checkRect)) {
                avoided = false;
            }
            if (avoided) {
                int i2 = 0;
                while (i2 < otherRects.length) {
                    if (checkRect.intersects(otherRects[i2])) {
                        avoided = false;
                        break;
                    }
                    ++i2;
                }
            }
            if (avoided) continue;
            log.trace((Object)("strategy:" + this.avoidSubtitleStrategies[strategy]));
            checkRect = new Rectangle(current);
            checkRect.x += moved * this.avoidSubtitleStrategies[strategy].x;
            checkRect.x -= moved * this.avoidSubtitleStrategies[strategy].y;
            checkRect.y += moved * this.avoidSubtitleStrategies[strategy].width;
            checkRect.y -= moved * this.avoidSubtitleStrategies[strategy].height;
            log.trace((Object)("new check:" + checkRect));
            changed = true;
            if (++strategy != this.avoidSubtitleStrategies.length) continue;
            log.warn((Object)"give uped avoid rect");
            faild = true;
            break;
        }
        if (changed && !faild) {
            log.trace((Object)("moved:" + checkRect));
            item.setAlign(0);
            item.setValign(0);
            item.setX(checkRect.x);
            item.setY(checkRect.y);
            item.setWidth(checkRect.width + expand * 2);
            item.setHeight(checkRect.height);
            item.clear();
        }
        tmpImage.getGraphics().dispose();
    }

    private boolean inScreen(Rectangle rect) {
        int w = this.dougaSystem.getVideoSystem().getDougaPreference().getWidth();
        int h = this.dougaSystem.getVideoSystem().getDougaPreference().getHeight();
        System.out.println(String.valueOf(w) + "x" + h);
        System.out.println(String.valueOf(rect.x + rect.width) + "x" + (rect.y + rect.height));
        if (rect.x < 0 || rect.y < 0) {
            return false;
        }
        return rect.x + rect.width <= w && rect.y + rect.height <= h;
    }

    private void parseImageFile(File file) {
        double start = this.currentProperties.parseStartTime(this.currentTime);
        double duration = this.currentProperties.parseDuration(this.getDefaultDuration());
        double fadein = this.currentProperties.parseFadeIn(this.default_image_fadein);
        double fadeout = this.currentProperties.parseFadeOut(this.default_image_fadeout);
        float transparent = this.currentProperties.parseTransparent(this.default_other_transparent);
        int loop = this.currentProperties.getLoop();
        if (loop < 1) {
            loop = 1;
        }
        ImageItem item = this.createImageItem(file, loop);
        item.setStartTime(start);
        item.setMoveX(this.currentProperties.getMove_x());
        item.setMoveY(this.currentProperties.getMove_y());
        item.setMoveWidth(this.currentProperties.getMove_width());
        item.setMoveHeight(this.currentProperties.getMove_height());
        int defaultValign = 0;
        int defaultAlign = 0;
        ItemLocationAndAlign ia = new ItemLocationAndAlign(0, 0, 0, 0, 0, defaultAlign, defaultValign, true);
        ia.loadProperty();
        ia.setUpItem(item);
        item.setDuration(duration);
        item.setTransparent(transparent);
        item.setFadeInTime(fadein);
        item.setFadeOutTime(fadeout);
        this.itemList.add(item);
        this.processProgressTime();
    }

    public void parseTextLine(TextLine textline) {
        float transparent = this.currentProperties.parseTransparent(this.default_other_transparent);
        double start = this.currentProperties.parseStartTime(-1.0);
        double duration = this.currentProperties.parseDuration(this.getDefaultDuration());
        double fadein = this.currentProperties.parseFadeIn(this.default_image_fadein);
        double fadeout = this.currentProperties.parseFadeOut(this.default_image_fadeout);
        boolean noprogress = this.currentProperties.isNoProgress();
        String type = this.currentProperties.getText_type();
        if (type.equals("normal")) {
            TextItem item = new TextItem(textline.getText());
            if (start >= 0.0) {
                log.info((Object)"text start>=0 && noprogress");
                item.setStartTime(start);
                noprogress = true;
            } else {
                item.setStartTime(this.currentTime);
            }
            item.setTransparent(transparent);
            item.setMoveX(this.currentProperties.getMove_x());
            item.setMoveY(this.currentProperties.getMove_y());
            item.setMoveWidth(this.currentProperties.getMove_width());
            item.setMoveHeight(this.currentProperties.getMove_height());
            item.setDuration(duration);
            item.setFadeInTime(fadein);
            item.setFadeOutTime(fadeout);
            item.setShearX(this.currentProperties.getShear_x());
            item.setShearY(this.currentProperties.getShear_y());
            item.setRotate(this.currentProperties.getRotate());
            item.setMoveRotate(this.currentProperties.getMove_rotate());
            ItemLocationAndAlign ia = new ItemLocationAndAlign(0, 0, 0, 0, 0, 2, 3, true);
            ia.loadProperty();
            ia.setUpItem(item);
            this.setUpTextDecoration(item);
            if (this.isMultiStyledText(textline.getText())) {
                this.parseMultiStyledText(item);
            } else {
                this.itemList.add(item);
            }
        } else if (type.equals("karaoke")) {
            log.trace((Object)("type:" + type));
            KaraokeItem item = new KaraokeItem(textline.getText());
            double[] timing = PropertyUtils.getTimingValue(this.currentProperties.getTiming(), null);
            item.setTiming(timing);
            if (start >= 0.0) {
                item.setStartTime(start);
                noprogress = true;
            } else {
                item.setStartTime(this.currentTime);
            }
            item.setTransparent(transparent);
            item.setMoveX(this.currentProperties.getMove_x());
            item.setMoveY(this.currentProperties.getMove_y());
            item.setMoveWidth(this.currentProperties.getMove_width());
            item.setMoveHeight(this.currentProperties.getMove_height());
            item.setDuration(duration);
            item.setFadeInTime(fadein);
            item.setFadeOutTime(fadeout);
            System.out.println(String.valueOf(this.currentProperties.getAlign()) + "," + this.currentProperties.getValign());
            ItemLocationAndAlign ia = new ItemLocationAndAlign(0, 0, 0, 0, 0, 2, 3, true);
            ia.loadProperty();
            ia.setUpItem(item);
            this.setUpTextDecoration(item);
            this.itemList.add(item);
        }
        if (!noprogress) {
            this.progressTime();
        }
    }

    private void parseMultiStyledText(TextItem item) {
        TextItem newItem;
        MultiStyledText mText = new MultiStyledText(item);
        Matcher matcher = this.multiStyledTextPattern.matcher(item.getText());
        String remain = null;
        while (matcher.find()) {
            log.info((Object)("muched:" + matcher.group(1) + "," + matcher.group(2) + "," + matcher.group(3)));
            if (matcher.group(1).length() > 0) {
                TextItem preItem = new TextItem(item, matcher.group(1));
                preItem.setAlign(0);
                preItem.setValign(0);
                mText.addTextItem(preItem);
                if (preItem.getText().equals("\\n")) {
                    System.out.println("muched");
                    preItem.setText(" \n");
                } else if (preItem.getText().equals("\\n\\n")) {
                    System.out.println("muched");
                    preItem.setText(" \n\n");
                }
            }
            newItem = new TextItem(item, matcher.group(3));
            this.setTextPropertyFromClass(newItem, matcher.group(2));
            newItem.setAlign(0);
            newItem.setValign(0);
            mText.addTextItem(newItem);
            remain = item.getText().substring(matcher.end());
        }
        if (remain == null) {
            log.warn((Object)("pattern much faild:" + item.getText()));
        } else if (remain.length() > 0) {
            newItem = new TextItem(item, remain);
            newItem.setAlign(0);
            newItem.setValign(0);
            mText.addTextItem(newItem);
        }
        this.itemList.add(mText);
    }

    private void setTextPropertyFromClass(TextItem item, String name) {
        PropertyLine newP = this.classPropertiesMap.get(name);
        if (newP == null) {
            DougaSystem.dougaLogger.warn(String.valueOf(Messages.getString("class_not_setted")) + ":" + name);
            return;
        }
        try {
            TextDougaProperties newProperties = (TextDougaProperties)this.currentProperties.clone();
            PropertyLine original = this.propertyLine;
            this.propertyLine = newP;
            this.setProperties(newProperties);
            this.propertyLine = original;
            TextDougaProperties originP = this.currentProperties;
            this.currentProperties = newProperties;
            this.setUpTextDecoration(item);
            this.currentProperties = originP;
            return;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return;
        }
    }

    private boolean isMultiStyledText(String text) {
        return text.indexOf("{{") != -1 && text.indexOf(" }}") != -1;
    }

    public void setUpTextDecoration(TextItem item) {
        int fontStyle = 0;
        if (this.currentProperties.getFont_style().equals("bold")) {
            fontStyle = 1;
        } else if (this.currentProperties.getFont_style().equals("italic")) {
            fontStyle = 2;
        } else if (this.currentProperties.getFont_style().equals("bold_italic")) {
            fontStyle = 3;
        }
        Font font = new Font(this.currentProperties.getFont_name(), fontStyle, this.currentProperties.getFont_size());
        item.setFont(font);
        DecoratedShapePainter decoration = item.getDecoratedShapePainter();
        decoration.setAntialiase(this.currentProperties.isText_antialiase());
        decoration.setAntialiaseShadow(this.currentProperties.isText_antialiase());
        decoration.setFillColor(this.currentProperties.getText_line_color());
        decoration.setLineColor(this.currentProperties.getText_border_color());
        decoration.setLineSize(this.currentProperties.getText_border_size() * 2);
        decoration.setShadowColor(this.currentProperties.getText_shadow_color());
        decoration.setShadowOffsetX(this.currentProperties.getText_shadow_x());
        decoration.setShadowOffsetY(this.currentProperties.getText_shadow_y());
        decoration.setSelectColor(this.currentProperties.getText_select_color());
        decoration.setFill(this.currentProperties.isText_draw_line());
        decoration.setLine(this.currentProperties.isText_draw_border());
        decoration.setShadow(this.currentProperties.isText_draw_shadow());
    }

    public void consumeProperty() {
        this.propertyLine = null;
        try {
            this.currentProperties = (TextDougaProperties)this.defaultProperties.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    public String getProperty(String key) {
        if (this.propertyLine == null) {
            return null;
        }
        return this.propertyLine.getValue(key);
    }

    public boolean isCancelling() {
        return this.cancelling;
    }

    public void setCancelling(boolean cancelling) {
        this.cancelling = cancelling;
        if (cancelling && this.downloader != null) {
            try {
                this.downloader.cancel();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class ItemLocationAndAlign {
        private int x;
        private int y;
        private int z;
        private int width;
        private int height;
        private int align;
        private int valign;
        private boolean keepAspect;

        public boolean isKeepAspect() {
            return this.keepAspect;
        }

        public void setKeepAspect(boolean keepAspect) {
            this.keepAspect = keepAspect;
        }

        public ItemLocationAndAlign(int x, int y, int z, int width, int height, int align, int valign, boolean keepAspect) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.width = width;
            this.height = height;
            this.align = align;
            this.valign = valign;
            this.keepAspect = keepAspect;
        }

        public void setUpItem(AbstractItem item) {
            item.setBounds(this.x, this.y, this.width, this.height);
            item.setZ(this.z);
            item.setKeepAspect(this.keepAspect);
            item.setAlign(this.align);
            item.setValign(this.valign);
        }

        public void loadProperty() {
            this.x = SimpleParser.this.currentProperties.getX();
            this.y = SimpleParser.this.currentProperties.getY();
            this.width = SimpleParser.this.currentProperties.getWidth();
            this.height = SimpleParser.this.currentProperties.getHeight();
            this.z = SimpleParser.this.currentProperties.getZ();
            this.keepAspect = SimpleParser.this.currentProperties.isKeepAspect();
            this.align = SimpleParser.this.currentProperties.parseAlign(this.align);
            this.valign = SimpleParser.this.currentProperties.parseValign(this.valign);
        }

        public int getAlign() {
            return this.align;
        }

        public void setAlign(int align) {
            this.align = align;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getValign() {
            return this.valign;
        }

        public void setValign(int valign) {
            this.valign = valign;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getZ() {
            return this.z;
        }

        public void setZ(int z) {
            this.z = z;
        }
    }
}

