/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.video;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.text_douga.AudioData;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.DougaSystem;
import jp.sourceforge.akjrcp.text_douga.VideoWriter;
import jp.sourceforge.akjrcp.text_douga.video.EffectableVideoData;
import jp.sourceforge.akjrcp.text_douga.video.VideoUtils;

public class FileVideoData
extends EffectableVideoData {
    private String inputPath;
    private double startTime;
    private double duration;
    private double loopPadTime;
    private int loop;
    private boolean canStopInLoop = true;
    private AudioData audioData;
    private int padColor;
    private double logicalTime;

    public String toString() {
        return "start=" + this.startTime + " duration=" + this.duration + " loop=" + this.loop + " canStopInLoop=" + this.canStopInLoop + " inputPath=" + this.inputPath;
    }

    public FileVideoData(String inputPath) {
        this.inputPath = inputPath;
    }

    public boolean isCanStopInLoop() {
        return this.canStopInLoop;
    }

    public void setCanStopInLoop(boolean canStopInLoop) {
        this.canStopInLoop = canStopInLoop;
    }

    public double getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(double duration) {
        this.duration = duration;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    public int getLoop() {
        return this.loop;
    }

    public void setLoop(int loop) {
        this.loop = loop;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    @Override
    public int writeData(File dir, DougaPreference preference, int startIndex, int maxframe) throws IOException {
        if (this.startEffect != null) {
            this.startEffect.setKeyFrame(startIndex);
        }
        int wf = this.getLoop() == 0 ? VideoUtils.copyVideo(preference.getFfmpegPath(), this.getInputPath(), this.getStartTime(), this.getDuration(), dir, startIndex, preference.getFps(), preference.getWidth(), preference.getHeight(), maxframe) : VideoUtils.loopVideo(preference.getFfmpegPath(), this.getInputPath(), this.getStartTime(), this.getDuration(), this.getLoop(), this.getLoopPadTime(), this.getPadColor(), this.isCanStopInLoop(), dir, startIndex, preference.getFps(), preference.getWidth(), preference.getHeight(), maxframe);
        if (this.audioData != null) {
            if (wf > 0) {
                this.audioData.setSynch(true);
                double sl = (double)wf / preference.getFps();
                DougaSystem.log.info((Object)("synchlength=" + sl + " wf=" + wf + " fps=" + preference.getFps()));
                this.audioData.setSynchLength(sl);
            } else {
                DougaSystem.log.info((Object)"do nothing video");
            }
        }
        return wf;
    }

    @Override
    public AudioData getAudioData() {
        return this.audioData;
    }

    @Override
    public void setAudioData(AudioData audioData) {
        this.audioData = audioData;
    }

    public double getLoopPadTime() {
        return this.loopPadTime;
    }

    public void setLoopPadTime(double loopPadTime) {
        this.loopPadTime = loopPadTime;
    }

    public int getPadColor() {
        return this.padColor;
    }

    public void setPadColor(int padColor) {
        this.padColor = padColor;
    }

    @Override
    public double getTotalTime() {
        double d;
        if (this.loop == -1) {
            return -1.0;
        }
        int lo = 1;
        if (this.loop > 1) {
            lo = this.loop;
        }
        if ((d = this.duration) == 0.0) {
            d = this.logicalTime;
            d -= this.startTime;
        }
        return d * (double)lo + (double)(lo - 1) * this.loopPadTime;
    }

    public double getLogicalTime() {
        return this.logicalTime;
    }

    public void setLogicalTime(double logicalTime) {
        this.logicalTime = logicalTime;
    }

    @Override
    public int writeData(VideoWriter writer, DougaPreference preference) throws IOException {
        int startIndex = writer.getWrited() + 1;
        if (this.startEffect != null) {
            this.startEffect.setKeyFrame(startIndex);
        }
        int wf = this.getLoop() == 0 ? VideoUtils.copyVideo(this, writer, preference.getFfmpegPath(), this.getInputPath(), this.getStartTime(), this.getDuration(), preference.getFps(), preference.getWidth(), preference.getHeight()) : VideoUtils.loopVideo(this, writer, preference.getFfmpegPath(), this.getInputPath(), this.getStartTime(), this.getDuration(), this.getLoop(), this.getLoopPadTime(), this.getPadColor(), this.isCanStopInLoop(), preference.getFps(), preference.getWidth(), preference.getHeight());
        if (this.audioData != null) {
            if (wf > 0) {
                this.audioData.setSynch(true);
                double sl = (double)wf / preference.getFps();
                DougaSystem.log.info((Object)(String.valueOf(sl) + ",wf=" + wf + "fps=" + preference.getFps()));
                this.audioData.setSynchLength(sl);
            } else {
                DougaSystem.log.info((Object)"do nothing video");
            }
        }
        if (wf > 0) {
            if (this.endEffect != null) {
                this.endEffect.setKeyFrame(startIndex + wf - 1);
            }
        } else if (this.startEffect != null) {
            this.startEffect.setKeyFrame(-9999);
        }
        return wf;
    }
}

