/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.video;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.text_douga.AudioData;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.SystemEnvironment;
import jp.sourceforge.akjrcp.text_douga.VideoWriter;
import jp.sourceforge.akjrcp.text_douga.video.EffectableVideoData;
import jp.sourceforge.akjrcp.text_douga.video.VideoUtils;

public class ImageVideoData
extends EffectableVideoData {
    private String inputPath;
    private double duration = 3.0;
    private AudioData audioData;
    private boolean fitSize = true;
    private int bgColor = 0;

    public String toString() {
        return "ImageVideoData:duration=" + this.duration + " inputPath=" + this.inputPath;
    }

    public ImageVideoData(String inputPath) {
        this.inputPath = inputPath;
    }

    public double getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(double duration) {
        this.duration = duration;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    @Override
    public int writeData(File dir, DougaPreference preference, int startIndex, int maxframe) throws IOException {
        int frames;
        BufferedImage frameImage;
        BufferedImage bgImage;
        int wf = 0;
        if (this.startEffect != null) {
            this.startEffect.setKeyFrame(startIndex);
        }
        if ((bgImage = SystemEnvironment.getSystemEnvironment().getImageCasher().loadImage(this.inputPath)) != null) {
            int dh;
            int dw;
            double ratioW = preference.getWidth() / bgImage.getWidth();
            double ratioH = preference.getHeight() / bgImage.getHeight();
            boolean useW = true;
            if (ratioW > ratioH) {
                useW = false;
            }
            if (useW) {
                dw = preference.getWidth();
                dh = (int)((double)preference.getHeight() * ratioW);
            } else {
                dw = (int)((double)preference.getWidth() * ratioH);
                dh = preference.getHeight();
            }
            int dx = (preference.getWidth() - dw) / 2;
            int dy = (preference.getHeight() - dh) / 2;
            frameImage = new BufferedImage(preference.getWidth(), preference.getHeight(), 1);
            Graphics2D g2 = (Graphics2D)frameImage.getGraphics();
            g2.setColor(new Color(this.bgColor));
            g2.fillRect(0, 0, preference.getWidth(), preference.getHeight());
            g2.drawImage(bgImage, dx, dy, dw, dh, 0, 0, bgImage.getWidth(), bgImage.getHeight(), null);
            frames = 0;
            if (this.duration == -1.0) {
                frames = maxframe;
            } else {
                frames = (int)(preference.getFps() * this.duration);
                if (maxframe != 0 && maxframe < frames) {
                    frames = maxframe;
                }
            }
        } else {
            throw new IOException("bgimage can't load:" + this.inputPath);
        }
        wf = VideoUtils.copyImage(frameImage, dir, startIndex, frames);
        if (this.audioData != null) {
            this.audioData.setSynchLength((double)wf / preference.getFps());
        }
        if (wf > 0) {
            if (this.endEffect != null) {
                this.endEffect.setKeyFrame(startIndex + wf - 1);
            }
        } else if (this.startEffect != null) {
            this.startEffect.setKeyFrame(-9999);
        }
        return wf;
    }

    @Override
    public AudioData getAudioData() {
        return this.audioData;
    }

    @Override
    public void setAudioData(AudioData audioData) {
        this.audioData = audioData;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public boolean isFitSize() {
        return this.fitSize;
    }

    public void setFitSize(boolean fitSize) {
        this.fitSize = fitSize;
    }

    @Override
    public double getTotalTime() {
        return this.duration;
    }

    @Override
    public int writeData(VideoWriter writer, DougaPreference preference) throws IOException {
        int frames;
        BufferedImage frameImage;
        int maxframe = Math.max(0, writer.getMaxFrame() - writer.getWrited());
        int startIndex = writer.getWrited() + 1;
        if (this.startEffect != null) {
            this.startEffect.setKeyFrame(startIndex);
        }
        int wf = 0;
        BufferedImage bgImage = SystemEnvironment.getSystemEnvironment().getImageCasher().loadImage(this.inputPath);
        if (bgImage != null) {
            int dh;
            int dw;
            double ratioW = (double)preference.getWidth() / (double)bgImage.getWidth();
            double ratioH = (double)preference.getHeight() / (double)bgImage.getHeight();
            boolean useW = true;
            if (ratioW > ratioH) {
                useW = false;
            }
            if (useW) {
                dw = preference.getWidth();
                dh = (int)((double)bgImage.getHeight() * ratioW);
            } else {
                dw = (int)((double)bgImage.getWidth() * ratioH);
                dh = preference.getHeight();
            }
            int dx = (preference.getWidth() - dw) / 2;
            int dy = (preference.getHeight() - dh) / 2;
            frameImage = new BufferedImage(preference.getWidth(), preference.getHeight(), 1);
            Graphics2D g2 = (Graphics2D)frameImage.getGraphics();
            g2.setColor(new Color(this.bgColor));
            g2.fillRect(0, 0, preference.getWidth(), preference.getHeight());
            g2.drawImage(bgImage, dx, dy, dw, dh, 0, 0, bgImage.getWidth(), bgImage.getHeight(), null);
            frames = 0;
            if (this.duration == -1.0) {
                frames = maxframe;
            } else {
                frames = (int)(preference.getFps() * this.duration);
                if (maxframe != 0 && maxframe < frames) {
                    frames = maxframe;
                }
            }
        } else {
            throw new IOException("bgimage can't load:" + this.inputPath);
        }
        wf = VideoUtils.copyImage(frameImage, this, writer, frames);
        if (this.audioData != null) {
            this.audioData.setSynchLength((double)wf / preference.getFps());
        }
        if (wf > 0) {
            if (this.endEffect != null) {
                this.endEffect.setKeyFrame(startIndex + wf - 1);
            }
        } else if (this.startEffect != null) {
            this.startEffect.setKeyFrame(-9999);
        }
        return wf;
    }
}

