/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.csseditor.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class CSSRule
implements IPredicateRule {
    private IToken propToken;
    private IToken valueToken;

    public CSSRule(IToken propToken, IToken valueToken) {
        this.propToken = propToken;
        this.valueToken = valueToken;
    }

    private boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        int i = 1;
        while (i < sequence.length) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c != sequence[i]) {
                scanner.unread();
                int j = i - 1;
                while (j > 0) {
                    scanner.unread();
                    --j;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private IToken getToken(ICharacterScanner scanner) {
        int c;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = scanner.read()) != -1) {
            if (c == 58) {
                return this.propToken;
            }
            if (c == 59) {
                return this.valueToken;
            }
            int i = 0;
            while (i < delimiters.length) {
                if (c == delimiters[i][0] && this.sequenceDetected(scanner, delimiters[i], true)) {
                    return null;
                }
                ++i;
            }
        }
        scanner.unread();
        return null;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.doEvaluate(scanner, resume);
    }

    private IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            IToken token = this.getToken(scanner);
            if (token != null) {
                return token;
            }
        } else {
            IToken token;
            int c = scanner.read();
            if (c != 32 && c != 9 && c != 13 && c != 10 && (token = this.getToken(scanner)) != null) {
                return token;
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public IToken getSuccessToken() {
        return null;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }
}

