/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.tasktag.HTMLTaskTagDetector;
import tk.eclipse.plugin.htmleditor.tasktag.ITaskTagDetector;
import tk.eclipse.plugin.htmleditor.tasktag.JavaScriptTaskTagDetector;
import tk.eclipse.plugin.htmleditor.tasktag.TaskTag;

public class HTMLProjectBuilder
extends IncrementalProjectBuilder {
    private List taskTagDetectors = new ArrayList();
    private TaskTag[] tags;

    public HTMLProjectBuilder() {
        this.taskTagDetectors.add(new HTMLTaskTagDetector());
        this.taskTagDetectors.add(new JavaScriptTaskTagDetector());
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta delta;
        List list = TaskTag.loadFromPreference(false);
        this.tags = list.toArray(new TaskTag[list.size()]);
        if (this.getProject() == null) {
            return null;
        }
        if (kind == 6) {
            this.processContainer((IContainer)this.getProject());
        }
        if ((delta = this.getDelta(this.getProject())) == null) {
            return null;
        }
        this.processDelta(delta);
        this.getProject().refreshLocal(2, monitor);
        return null;
    }

    private void processContainer(IContainer project) {
        try {
            IResource[] resources = project.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IContainer) {
                    this.processContainer((IContainer)resources[i]);
                } else if (resources[i] instanceof IFile) {
                    int j = 0;
                    while (j < this.taskTagDetectors.size()) {
                        ITaskTagDetector detector = (ITaskTagDetector)this.taskTagDetectors.get(j);
                        if (detector.isSupported((IFile)resources[i])) {
                            this.applyDetector(resources[i], detector);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private void processDelta(IResourceDelta delta) {
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            int kind = children[i].getFlags();
            if (kind != 131072) {
                IResource resource = children[i].getResource();
                if (resource != null && resource instanceof IFile && resource.exists()) {
                    int j = 0;
                    while (j < this.taskTagDetectors.size()) {
                        ITaskTagDetector detector = (ITaskTagDetector)this.taskTagDetectors.get(j);
                        if (detector.isSupported((IFile)resource)) {
                            this.applyDetector(resource, detector);
                            break;
                        }
                        ++j;
                    }
                }
                this.processDelta(children[i]);
            }
            ++i;
        }
    }

    private void applyDetector(final IResource resource, final ITaskTagDetector detector) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this, resource, detector){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IResource val$resource;
                        private final /* synthetic */ ITaskTagDetector val$detector;
                        {
                            this.this$1 = var1_1;
                            this.val$resource = iResource;
                            this.val$detector = iTaskTagDetector;
                        }

                        public void run(IProgressMonitor monitor) throws CoreException {
                            try {
                                this.val$resource.deleteMarkers("org.eclipse.core.resources.taskmarker", false, 0);
                                this.val$detector.detect((IFile)this.val$resource, HTMLProjectBuilder.access$0(1.access$0(this.this$1)));
                            }
                            catch (Exception ex) {
                                HTMLPlugin.logException(ex);
                            }
                        }
                    }, null);
                }
                catch (Exception ex) {
                    HTMLPlugin.logException(ex);
                }
            }

            static /* synthetic */ HTMLProjectBuilder access$0(1 var0) {
                return var0.HTMLProjectBuilder.this;
            }
        });
    }

    public static void doBuild(IProject project) {
        try {
            if (project.hasNature("tk.eclipse.plugin.htmleditor.HTMLProjectNature")) {
                project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                project.build(6, "tk.eclipse.plugin.htmleditor.HTMLProjectBuilder", new HashMap(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    static /* synthetic */ TaskTag[] access$0(HTMLProjectBuilder hTMLProjectBuilder) {
        return hTMLProjectBuilder.tags;
    }
}

