/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class HTMLProjectParams {
    private String root = "/";
    private boolean useDTD = true;
    private boolean validateXML = true;
    private boolean validateHTML = true;
    private boolean validateJSP = true;
    private boolean validateDTD = true;
    private boolean validateJS = true;
    private boolean removeMarkers = false;
    private boolean detectTaskTag = false;
    private String[] javaScripts = new String[0];
    private String[] javaScriptCompleters = new String[0];
    public static final String P_ROOT = "root";
    public static final String P_USE_DTD = "useDTD";
    public static final String P_VALIDATE_XML = "validateXML";
    public static final String P_VALIDATE_HTML = "validateHTML";
    public static final String P_VALIDATE_JSP = "validateJSP";
    public static final String P_VALIDATE_DTD = "validateDTD";
    public static final String P_VALIDATE_JS = "validateJS";
    public static final String P_REMOVE_MARKERS = "removeMarkers";
    public static final String P_JAVA_SCRIPTS = "javaScripts";
    public static final String P_JAVA_SCRIPT_COMPLETERS = "javaScriptCompleters";

    public HTMLProjectParams() {
    }

    public HTMLProjectParams(IProject project) throws Exception {
        this.load(project);
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String webAppRoot) {
        this.root = webAppRoot;
    }

    public void setUseDTD(boolean useDTD) {
        this.useDTD = useDTD;
    }

    public boolean getUseDTD() {
        return this.useDTD;
    }

    public void setValidateHTML(boolean validateHTML) {
        this.validateHTML = validateHTML;
    }

    public boolean getValidateHTML() {
        return this.validateHTML;
    }

    public void setValidateJSP(boolean validateJSP) {
        this.validateJSP = validateJSP;
    }

    public boolean getValidateJSP() {
        return this.validateJSP;
    }

    public void setValidateDTD(boolean validateDTD) {
        this.validateDTD = validateDTD;
    }

    public boolean getValidateDTD() {
        return this.validateDTD;
    }

    public void setValidateJavaScript(boolean validateJS) {
        this.validateJS = validateJS;
    }

    public boolean getValidateJavaScript() {
        return this.validateJS;
    }

    public void setValidateXML(boolean validateXML) {
        this.validateXML = validateXML;
    }

    public boolean getValidateXML() {
        return this.validateXML;
    }

    public void setRemoveMarkers(boolean removeMarkers) {
        this.removeMarkers = removeMarkers;
    }

    public boolean getRemoveMarkers() {
        return this.removeMarkers;
    }

    public void setDetectTaskTag(boolean detectTaskTag) {
        this.detectTaskTag = detectTaskTag;
    }

    public boolean getDetectTaskTag() {
        return this.detectTaskTag;
    }

    public void setJavaScripts(String[] javaScripts) {
        this.javaScripts = javaScripts;
    }

    public String[] getJavaScripts() {
        return this.javaScripts;
    }

    public void setJavaScriptCompleters(String[] javaScriptCompleters) {
        this.javaScriptCompleters = javaScriptCompleters;
    }

    public String[] getJavaScriptCompleters() {
        return this.javaScriptCompleters;
    }

    public void save(IProject project) throws Exception {
        IFile configFile = project.getFile(".amateras");
        Properties props = new Properties();
        props.put(P_ROOT, this.root);
        props.put(P_USE_DTD, String.valueOf(this.useDTD));
        props.put(P_VALIDATE_XML, String.valueOf(this.validateXML));
        props.put(P_VALIDATE_HTML, String.valueOf(this.validateHTML));
        props.put(P_VALIDATE_JSP, String.valueOf(this.validateJSP));
        props.put(P_VALIDATE_DTD, String.valueOf(this.validateDTD));
        props.put(P_VALIDATE_JS, String.valueOf(this.validateJS));
        props.put(P_REMOVE_MARKERS, String.valueOf(this.removeMarkers));
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.javaScripts.length) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(this.javaScripts[i]);
            ++i;
        }
        props.put(P_JAVA_SCRIPTS, sb.toString());
        sb.setLength(0);
        i = 0;
        while (i < this.javaScriptCompleters.length) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(this.javaScriptCompleters[i]);
            ++i;
        }
        props.put(P_JAVA_SCRIPT_COMPLETERS, sb.toString());
        File file = configFile.getLocation().makeAbsolute().toFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        props.store(new FileOutputStream(file), "EclipseHTMLEditor configuration file");
        if (this.detectTaskTag) {
            this.addNature(project);
        } else {
            this.removeNature(project);
        }
        project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
    }

    private void addNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals("tk.eclipse.plugin.htmleditor.HTMLProjectNature")) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "tk.eclipse.plugin.htmleditor.HTMLProjectNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    private void removeNature(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>();
        int i = 0;
        while (i < natures.length) {
            if (!natures[i].equals("tk.eclipse.plugin.htmleditor.HTMLProjectNature")) {
                newNatures.add(natures[i]);
            }
            ++i;
        }
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, null);
    }

    public void load(IProject project) throws Exception {
        IFile configFile = project.getFile(".amateras");
        String useDTD = null;
        String validateXML = null;
        String validateHTML = null;
        String validateJSP = null;
        String validateDTD = null;
        String validateJS = null;
        String removeMarkers = null;
        String javaScripts = "";
        String javaScriptCompleters = "";
        if (configFile.exists()) {
            File file = configFile.getLocation().makeAbsolute().toFile();
            Properties props = new Properties();
            props.load(new FileInputStream(file));
            this.root = props.getProperty(P_ROOT);
            useDTD = props.getProperty(P_USE_DTD);
            validateXML = props.getProperty(P_VALIDATE_XML);
            validateHTML = props.getProperty(P_VALIDATE_HTML);
            validateJSP = props.getProperty(P_VALIDATE_JSP);
            validateDTD = props.getProperty(P_VALIDATE_DTD);
            validateJS = props.getProperty(P_VALIDATE_JS);
            removeMarkers = props.getProperty(P_REMOVE_MARKERS);
            javaScripts = props.getProperty(P_JAVA_SCRIPTS);
            if (javaScripts == null) {
                javaScripts = "";
            }
            if ((javaScriptCompleters = props.getProperty(P_JAVA_SCRIPT_COMPLETERS)) == null) {
                javaScriptCompleters = "";
            }
        } else {
            this.root = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_ROOT));
            useDTD = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_USE_DTD));
            validateHTML = project.getPersistentProperty(new QualifiedName(HTMLPlugin.getDefault().getPluginId(), P_VALIDATE_HTML));
        }
        if (this.root == null) {
            this.root = "/";
        }
        this.useDTD = this.getBooleanValue(useDTD, true);
        this.validateXML = this.getBooleanValue(validateXML, true);
        this.validateHTML = this.getBooleanValue(validateHTML, true);
        this.validateJSP = this.getBooleanValue(validateJSP, true);
        this.validateDTD = this.getBooleanValue(validateDTD, true);
        this.validateJS = this.getBooleanValue(validateJS, true);
        this.removeMarkers = this.getBooleanValue(removeMarkers, false);
        this.detectTaskTag = project.hasNature("tk.eclipse.plugin.htmleditor.HTMLProjectNature");
        String[] dim = javaScripts.split("\n");
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < dim.length) {
            if (dim[i].trim().length() != 0) {
                list.add(dim[i]);
            }
            ++i;
        }
        this.javaScripts = list.toArray(new String[list.size()]);
        dim = javaScriptCompleters.split("\n");
        list = new ArrayList();
        i = 0;
        while (i < dim.length) {
            if (dim[i].trim().length() != 0) {
                list.add(dim[i]);
            }
            ++i;
        }
        this.javaScriptCompleters = list.toArray(new String[list.size()]);
    }

    private boolean getBooleanValue(String value, boolean defaultValue) {
        if (value != null) {
            if (value.equals("true")) {
                return true;
            }
            if (value.equals("false")) {
                return false;
            }
        }
        return defaultValue;
    }
}

