/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public abstract class AbstractCharacterPairMatcher
implements ICharacterPairMatcher {
    private int fAnchor;
    private boolean enable;
    private Map pairMap = new HashMap();
    private List startBlock = new ArrayList();
    private List endBlock = new ArrayList();
    private List quote = new ArrayList();
    private char delimiter = (char)61;

    public void setDelimiter(char c) {
        this.delimiter = c;
    }

    public void addQuoteCharacter(char c) {
        this.quote.add(String.valueOf(c));
    }

    protected String getSource(IDocument document) {
        return document.get();
    }

    public void addBlockCharacter(char start, char end) {
        this.pairMap.put(String.valueOf(start), String.valueOf(end));
        this.pairMap.put(String.valueOf(end), String.valueOf(start));
        this.startBlock.add(String.valueOf(start));
        this.endBlock.add(String.valueOf(end));
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void dispose() {
    }

    public void clear() {
    }

    public IRegion match(IDocument document, int offset) {
        if (offset < 0 || offset >= document.getLength() || !this.enable) {
            return null;
        }
        String text = this.getSource(document);
        try {
            int place;
            int eqoffset;
            int stoffset;
            int place2;
            char c;
            if (offset < document.getLength()) {
                String substr;
                c = text.charAt(offset);
                if (this.isEndBlock(c) && (place2 = this.getPrevPlace(text, c, offset - 1)) >= 0) {
                    this.fAnchor = 1;
                    return new Region(place2, 1);
                }
                if (this.isQuoteCharacter(c) && (stoffset = (substr = text.substring(0, offset)).lastIndexOf(c)) > (eqoffset = substr.lastIndexOf(this.delimiter)) && (place = substr.lastIndexOf(c, offset - 1)) >= 0) {
                    this.fAnchor = 1;
                    return new Region(place, 1);
                }
            }
            if (offset > 0) {
                String substr;
                c = text.charAt(offset - 1);
                if (this.isStartBlock(c) && (place2 = this.getNextPlace(text, c, offset + 1)) >= 0) {
                    this.fAnchor = 0;
                    return new Region(place2, 1);
                }
                if (this.isQuoteCharacter(c) && (stoffset = (substr = text.substring(0, offset - 1)).lastIndexOf(c)) < (eqoffset = substr.lastIndexOf(this.delimiter)) && (place = text.indexOf(c, offset)) >= 0) {
                    this.fAnchor = 0;
                    return new Region(place, 1);
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            this.setEnable(false);
        }
        this.fAnchor = -1;
        return null;
    }

    private int getPrevPlace(String source, char c, int offset) {
        char pair = this.getPairCharacter(c);
        int nest = 0;
        int i = offset;
        while (i >= 0) {
            char nc = source.charAt(i);
            if (nc == c) {
                ++nest;
            } else if (nc == pair) {
                if (nest == 0) {
                    return i;
                }
                --nest;
            }
            --i;
        }
        return -1;
    }

    private int getNextPlace(String source, char c, int offset) {
        char pair = this.getPairCharacter(c);
        int nest = 0;
        int i = offset;
        while (i < source.length()) {
            char nc = source.charAt(i);
            if (nc == c) {
                ++nest;
            } else if (nc == pair) {
                if (nest == 0) {
                    return i;
                }
                --nest;
            }
            ++i;
        }
        return -1;
    }

    private boolean isStartBlock(char c) {
        return this.startBlock.contains(String.valueOf(c));
    }

    private boolean isEndBlock(char c) {
        return this.endBlock.contains(String.valueOf(c));
    }

    private boolean isQuoteCharacter(char c) {
        return this.quote.contains(String.valueOf(c));
    }

    private char getPairCharacter(char c) {
        String pair = (String)this.pairMap.get(String.valueOf(c));
        if (pair == null) {
            return '\u0000';
        }
        return pair.charAt(0);
    }

    public int getAnchor() {
        return this.fAnchor;
    }
}

