/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import tk.eclipse.plugin.htmleditor.ColorProvider;
import tk.eclipse.plugin.htmleditor.HTMLHyperlinkDetector;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.InnerCSSAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.InnerJavaScriptAssistProcessor;
import tk.eclipse.plugin.htmleditor.editors.HTMLAnnotationHover;
import tk.eclipse.plugin.htmleditor.editors.HTMLAutoEditStrategy;
import tk.eclipse.plugin.htmleditor.editors.HTMLDoubleClickStrategy;
import tk.eclipse.plugin.htmleditor.editors.HTMLScanner;
import tk.eclipse.plugin.htmleditor.editors.HTMLTagScanner;
import tk.eclipse.plugin.htmleditor.editors.InnerCSSScanner;
import tk.eclipse.plugin.htmleditor.editors.InnerJavaScriptScanner;

public class HTMLConfiguration
extends SourceViewerConfiguration {
    private HTMLDoubleClickStrategy doubleClickStrategy;
    private HTMLScanner scanner;
    private HTMLTagScanner tagScanner;
    private RuleBasedScanner commentScanner;
    private RuleBasedScanner scriptScanner;
    private RuleBasedScanner doctypeScanner;
    private RuleBasedScanner directiveScanner;
    private RuleBasedScanner javaScriptScanner;
    private RuleBasedScanner cssScanner;
    private ColorProvider colorProvider;
    private IEditorPart editor;
    private ContentAssistant assistant;
    private HTMLAssistProcessor processor;
    private InnerJavaScriptAssistProcessor jsProcessor;
    private InnerCSSAssistProcessor cssProcessor;
    private HTMLAutoEditStrategy autoEditStrategy;
    private HTMLHyperlinkDetector hyperlinkDetector;

    public HTMLConfiguration(ColorProvider colorProvider) {
        this.colorProvider = colorProvider;
    }

    public void setEditorPart(IEditorPart editor) {
        this.editor = editor;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(this.editor);
    }

    protected HTMLAutoEditStrategy createAutoEditStrategy() {
        return new HTMLAutoEditStrategy();
    }

    protected HTMLHyperlinkDetector createHyperlinkDetector() {
        return new HTMLHyperlinkDetector();
    }

    public final HTMLHyperlinkDetector getHyperlinkDetector() {
        if (this.hyperlinkDetector == null) {
            this.hyperlinkDetector = this.createHyperlinkDetector();
        }
        return this.hyperlinkDetector;
    }

    public final HTMLAutoEditStrategy getAutoEditStrategy() {
        if (this.autoEditStrategy == null) {
            this.autoEditStrategy = this.createAutoEditStrategy();
        }
        return this.autoEditStrategy;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__html_comment", "__html_tag", "__html_script", "__html_doctype", "__html_directive", "__html_javascript", "__html_css"};
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        IHyperlinkDetector[] detectors = super.getHyperlinkDetectors(sourceViewer);
        IHyperlinkDetector[] result = new IHyperlinkDetector[detectors.length + 1];
        System.arraycopy(detectors, 0, result, 0, detectors.length);
        result[result.length - 1] = this.getHyperlinkDetector();
        return result;
    }

    public final IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{this.getAutoEditStrategy()};
    }

    public HTMLAssistProcessor getAssistProcessor() {
        if (this.processor == null) {
            this.processor = this.createAssistProcessor();
        }
        return this.processor;
    }

    protected HTMLAssistProcessor createAssistProcessor() {
        HTMLAssistProcessor processor = new HTMLAssistProcessor();
        return processor;
    }

    public InnerJavaScriptAssistProcessor getJavaScriptAssistProcessor() {
        if (this.jsProcessor == null) {
            this.jsProcessor = new InnerJavaScriptAssistProcessor(this.getAssistProcessor());
        }
        return this.jsProcessor;
    }

    public InnerCSSAssistProcessor getCSSAssistProcessor() {
        if (this.cssProcessor == null) {
            this.cssProcessor = new InnerCSSAssistProcessor(this.getAssistProcessor());
        }
        return this.cssProcessor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.assistant == null) {
            this.assistant = new ContentAssistant();
            this.assistant.setInformationControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent);
                }
            });
            this.assistant.setContextInformationPopupOrientation(20);
            this.assistant.enableAutoInsert(true);
            HTMLAssistProcessor processor = this.getAssistProcessor();
            this.assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
            this.assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__html_tag");
            InnerJavaScriptAssistProcessor jsProcessor = this.getJavaScriptAssistProcessor();
            this.assistant.setContentAssistProcessor((IContentAssistProcessor)jsProcessor, "__html_javascript");
            InnerCSSAssistProcessor cssProcessor = this.getCSSAssistProcessor();
            this.assistant.setContentAssistProcessor((IContentAssistProcessor)cssProcessor, "__html_css");
            this.assistant.install((ITextViewer)sourceViewer);
            IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
            this.assistant.enableAutoActivation(store.getBoolean("_pref_assist_auto"));
            this.assistant.setAutoActivationDelay(store.getInt("_pref_assist_times"));
            this.assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            processor.setAutoAssistChars(store.getString("_pref_assist_chars").toCharArray());
            processor.setAssistCloseTag(store.getBoolean("_pref_assist_close"));
        }
        return this.assistant;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new HTMLDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected HTMLScanner getHTMLScanner() {
        if (this.scanner == null) {
            this.scanner = new HTMLScanner(this.colorProvider);
            this.scanner.setDefaultReturnToken(this.colorProvider.getToken("__pref_color_foreground"));
        }
        return this.scanner;
    }

    protected HTMLTagScanner getTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new HTMLTagScanner(this.colorProvider);
            this.tagScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_tag"));
        }
        return this.tagScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        if (this.commentScanner == null) {
            this.commentScanner = new RuleBasedScanner();
            this.commentScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_comment"));
        }
        return this.commentScanner;
    }

    protected RuleBasedScanner getScriptScanner() {
        if (this.scriptScanner == null) {
            this.scriptScanner = new RuleBasedScanner();
            this.scriptScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_scriptlet"));
        }
        return this.scriptScanner;
    }

    protected RuleBasedScanner getDirectiveScanner() {
        if (this.directiveScanner == null) {
            this.directiveScanner = new RuleBasedScanner();
            this.directiveScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_scriptlet"));
        }
        return this.directiveScanner;
    }

    protected RuleBasedScanner getDoctypeScanner() {
        if (this.doctypeScanner == null) {
            this.doctypeScanner = new RuleBasedScanner();
            this.doctypeScanner.setDefaultReturnToken(this.colorProvider.getToken("_pref_color_doctype"));
        }
        return this.doctypeScanner;
    }

    protected RuleBasedScanner getJavaScriptScanner() {
        if (this.javaScriptScanner == null) {
            this.javaScriptScanner = new InnerJavaScriptScanner(this.colorProvider);
            this.javaScriptScanner.setDefaultReturnToken(this.colorProvider.getToken("__pref_color_foreground"));
        }
        return this.javaScriptScanner;
    }

    protected RuleBasedScanner getCSSScanner() {
        if (this.cssScanner == null) {
            this.cssScanner = new InnerCSSScanner(this.colorProvider);
            this.cssScanner.setDefaultReturnToken(this.colorProvider.getToken("__pref_color_foreground"));
        }
        return this.cssScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = null;
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_tag");
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getHTMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new HTMLTagDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getScriptScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_script");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_script");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getDoctypeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_doctype");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_doctype");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getDirectiveScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_directive");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_directive");
        dr = new JavaScriptDamagerRepairer((ITokenScanner)this.getJavaScriptScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_javascript");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_javascript");
        dr = new JavaScriptDamagerRepairer((ITokenScanner)this.getCSSScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_css");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_css");
        return reconciler;
    }

    protected ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    private class HTMLTagDamagerRepairer
    extends DefaultDamagerRepairer {
        public HTMLTagDamagerRepairer(ITokenScanner scanner) {
            super(scanner);
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
            if (!documentPartitioningChanged) {
                int end;
                int nextEnd;
                String source = this.fDocument.get();
                int start = source.substring(0, e.getOffset()).lastIndexOf(60);
                if (start == -1) {
                    start = 0;
                }
                if ((nextEnd = source.indexOf(62, (end = source.indexOf(62, e.getOffset())) + 1)) >= 0 && nextEnd > end) {
                    end = nextEnd;
                }
                int end2 = e.getOffset() + (e.getText() == null ? e.getLength() : e.getText().length());
                end = end == -1 ? source.length() : (end2 > end ? end2 : ++end);
                return new Region(start, end - start);
            }
            return partition;
        }
    }

    private class JavaScriptDamagerRepairer
    extends DefaultDamagerRepairer {
        public JavaScriptDamagerRepairer(ITokenScanner scanner) {
            super(scanner);
        }

        public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
            if (!documentPartitioningChanged) {
                String source = this.fDocument.get();
                int start = source.substring(0, e.getOffset()).lastIndexOf("/*");
                if (start == -1) {
                    start = 0;
                }
                int end = source.indexOf("*/", e.getOffset());
                int end2 = e.getOffset() + (e.getText() == null ? e.getLength() : e.getText().length());
                end = end == -1 ? source.length() : (end2 > end ? end2 : ++end);
                return new Region(start, end - start);
            }
            return partition;
        }
    }
}

