/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.MultiPageEditorPart;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditor;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditorPart;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;

public class MultiPageHTMLEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
HTMLEditorPart {
    private HTMLSourceEditor editor;
    private Browser browser;
    private HTMLEditor wrapper;

    public MultiPageHTMLEditor(HTMLEditor wrapper, HTMLSourceEditor editor) {
        this.wrapper = wrapper;
        this.editor = editor;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public HTMLSourceEditor getSourceEditor() {
        return this.editor;
    }

    private void createPage0() {
        try {
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, HTMLPlugin.getResourceString("MultiPageHTMLEditor.Source"));
            this.setPartName(this.getEditorInput().getName());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    private void createPage1() {
        if (this.isFileEditorInput()) {
            this.browser = new Browser(this.getContainer(), 0);
            int index = this.addPage((Control)this.browser);
            this.setPageText(index, HTMLPlugin.getResourceString("MultiPageHTMLEditor.Preview"));
        }
    }

    protected void createPages() {
        this.createPage0();
        this.createPage1();
    }

    public void dispose() {
        File tmpFile;
        if (this.isFileEditorInput() && (tmpFile = this.editor.getTempFile()).exists()) {
            tmpFile.delete();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(0).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        editor.doSaveAs();
        this.setInput(editor.getEditorInput());
        this.setPartName(this.getEditorInput().getName());
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
    }

    public boolean isFileEditorInput() {
        return this.editor.isFileEditorInput();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 1) {
            this.wrapper.updatePreview();
        }
    }

    public void setOffset(int offset) {
        this.setActivePage(0);
        this.editor.selectAndReveal(offset, 0);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IEditorInput input;
        if (event.getType() == 1 && (input = this.editor.getEditorInput()) instanceof IFileEditorInput) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IFile file = ((IFileEditorInput)input).getFile();
                    if (!file.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.closeEditor((IEditorPart)MultiPageHTMLEditor.this, false);
                    } else if (!MultiPageHTMLEditor.this.getPartName().equals(file.getName())) {
                        MultiPageHTMLEditor.this.setPartName(file.getName());
                    }
                }
            });
        }
    }

    public Object getAdapter(Class adapter) {
        return this.editor.getAdapter(adapter);
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.wrapper.firePropertyChange2(propertyId);
    }
}

