/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.gefutils;

import java.io.File;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.gefutils.IJarVisitor;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;

public class JarAcceptor {
    public static Object accept(IProject project, IJarVisitor visitor) {
        try {
            IContainer container = TLDInfo.getBaseDir(project);
            File basedir = container.getLocation().makeAbsolute().toFile();
            return JarAcceptor.accept(basedir, visitor);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return null;
        }
    }

    public static Object accept(File basedir, IJarVisitor visitor) {
        block7: {
            try {
                File lib = new File(basedir, "/WEB-INF/lib");
                if (!lib.exists() || !lib.isDirectory()) break block7;
                File[] files = lib.listFiles();
                try {
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].getName().endsWith(".jar")) {
                            JarFile jarFile = new JarFile(files[i]);
                            Enumeration<JarEntry> e = jarFile.entries();
                            while (e.hasMoreElements()) {
                                JarEntry entry = e.nextElement();
                                Object result = visitor.visit(jarFile, entry);
                                if (result == null) continue;
                                return result;
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    HTMLPlugin.logException(ex);
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        return null;
    }
}

