/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.views;

import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;

public class CSSPreviewView
extends ViewPart
implements IPartListener,
IDocumentListener {
    private ITextEditor currentEditor;
    private Browser browser;
    static /* synthetic */ Class class$0;

    private void editorChanged() {
        IWorkbenchPage page;
        if (this.currentEditor != null) {
            try {
                this.currentEditor.getDocumentProvider().getDocument((Object)this.currentEditor.getEditorInput()).removeDocumentListener((IDocumentListener)this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if ((page = this.getSite().getPage()) == null) {
            return;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return;
        }
        if (editor.getEditorInput().getName().endsWith(".css")) {
            if (editor instanceof ITextEditor) {
                this.currentEditor = (ITextEditor)editor;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.currentEditor = (ITextEditor)editor.getAdapter((Class)clazz);
            }
            if (this.currentEditor != null) {
                IDocument doc = this.currentEditor.getDocumentProvider().getDocument((Object)this.currentEditor.getEditorInput());
                doc.addDocumentListener((IDocumentListener)this);
                this.refreshPreview();
            }
        }
    }

    private void refreshPreview() {
        if (this.currentEditor != null) {
            String source = this.currentEditor.getDocumentProvider().getDocument((Object)this.currentEditor.getEditorInput()).get();
            String html = this.buildHTML(source);
            this.browser.setText(html);
        }
    }

    private String buildHTML(String source) {
        ArrayList<String> selectors = new ArrayList<String>();
        try {
            CSSOMParser parser = new CSSOMParser();
            InputSource is = new InputSource((Reader)new StringReader(source));
            CSSStyleSheet stylesheet = parser.parseStyleSheet(is);
            CSSRuleList list = stylesheet.getCssRules();
            int i = 0;
            while (i < list.getLength()) {
                CSSRule rule = list.item(i);
                if (rule instanceof CSSStyleRule) {
                    CSSStyleRule styleRule = (CSSStyleRule)rule;
                    String selector = styleRule.getSelectorText();
                    selectors.add(selector);
                }
                ++i;
            }
        }
        catch (IOException ex) {
            HTMLPlugin.logException(ex);
        }
        boolean table = false;
        HashSet<String> pseudo = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head><style type=\"text/css\">\n");
        sb.append(source);
        sb.append("</style></head><body>\n");
        int i = 0;
        while (i < selectors.size()) {
            String selector = (String)selectors.get(i);
            if (selector.indexOf(32) < 0 && selector.indexOf(62) < 0 && selector.indexOf(43) < 0 && selector.indexOf(91) < 0) {
                String[] dim;
                if (selector.indexOf(46) >= 0) {
                    dim = selector.split("\\.");
                    this.createElement(sb, selector, dim[0], dim[1], null);
                } else if (selector.indexOf(35) >= 0) {
                    dim = selector.split("#");
                    this.createElement(sb, selector, dim[0], null, dim[1]);
                } else if (selector.indexOf(":") >= 0) {
                    dim = selector.split(":");
                    if (!pseudo.contains(dim[0])) {
                        this.createElement(sb, dim[0], dim[0], null, null);
                        pseudo.add(dim[0]);
                    }
                } else if (!selector.equals("body")) {
                    if (selector.equalsIgnoreCase("table") || selector.equalsIgnoreCase("tr") || selector.equalsIgnoreCase("th") || selector.equalsIgnoreCase("td")) {
                        if (!table) {
                            sb.append("<table>\n");
                            sb.append("  <tr>\n");
                            sb.append("    <th>header</th>\n");
                            sb.append("    <th>header</th>\n");
                            sb.append("    <th>header</th>\n");
                            sb.append("  </tr>\n");
                            sb.append("  <tr>\n");
                            sb.append("    <td>1-1</td>\n");
                            sb.append("    <td>1-2</td>\n");
                            sb.append("    <td>1-3</td>\n");
                            sb.append("  </tr>\n");
                            sb.append("  <tr>\n");
                            sb.append("    <td>2-1</td>\n");
                            sb.append("    <td>2-2</td>\n");
                            sb.append("    <td>2-3</td>\n");
                            sb.append("  </tr>\n");
                            sb.append("</table>\n");
                            table = true;
                        }
                    } else {
                        this.createElement(sb, selector, selector, null, null);
                    }
                }
            }
            ++i;
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    private void createElement(StringBuffer sb, String selector, String elementName, String className, String idName) {
        if (elementName.equals("*")) {
            elementName = "div";
        }
        if (elementName.equalsIgnoreCase("a")) {
            sb.append("<a href=\"#\"");
            if (className != null) {
                sb.append(" class=\"").append(className).append("\"");
            }
            if (idName != null) {
                sb.append(" id=\"").append(idName).append("\"");
            }
            sb.append(">Link</a>\n");
        } else {
            sb.append("<").append(elementName);
            if (className != null) {
                sb.append(" class=\"").append(className).append("\"");
            }
            if (idName != null) {
                sb.append(" id=\"").append(idName).append("\"");
            }
            sb.append(">");
            if (elementName.equalsIgnoreCase("hr")) {
                return;
            }
            sb.append(selector);
            sb.append("</").append(elementName).append(">\n");
        }
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.setLayoutData((Object)new GridData(1808));
        IWorkbenchPage page = this.getSite().getPage();
        page.addPartListener((IPartListener)this);
        this.editorChanged();
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void partActivated(IWorkbenchPart part) {
        this.editorChanged();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.editorChanged();
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        this.editorChanged();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.refreshPreview();
    }
}

