/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.jface.preference.IPreferenceStore;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.gefutils.IJarVisitor;
import tk.eclipse.plugin.htmleditor.gefutils.JarAcceptor;
import tk.eclipse.plugin.jspeditor.editors.ITLDLocator;

public class TLDLoader {
    private static HashMap cache = new HashMap();
    static /* synthetic */ Class class$0;

    public static InputStream get(File basedir, String uri) throws Exception {
        if (cache.get(uri) == null) {
            InputStream in;
            Map innerTLD = HTMLPlugin.getInnerTLD();
            if (innerTLD.get(uri) != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("tk.eclipse.plugin.jspeditor.editors.TLDLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream in2 = clazz.getResourceAsStream((String)innerTLD.get(uri));
                byte[] bytes = HTMLUtil.readStream(in2);
                cache.put(uri, bytes);
                return new ByteArrayInputStream(bytes);
            }
            ITLDLocator[] locators = HTMLPlugin.getDefault().getTLDLocatorContributions();
            int i = 0;
            while (i < locators.length) {
                in = locators[i].locateTLD(uri);
                if (in != null) {
                    byte[] bytes = HTMLUtil.readStream(in);
                    cache.put(uri, bytes);
                    return new ByteArrayInputStream(bytes);
                }
                ++i;
            }
            Map pref = TLDLoader.getPreferenceTLD();
            if (pref.get(uri) != null) {
                in = new FileInputStream(new File((String)pref.get(uri)));
                byte[] bytes = HTMLUtil.readStream(in);
                cache.put(uri, bytes);
                return new ByteArrayInputStream(bytes);
            }
            byte[] bytes = TLDLoader.getTLDFromWebXML(basedir, uri);
            if (bytes != null) {
                cache.put(uri, bytes);
                return new ByteArrayInputStream(bytes);
            }
            if (uri.startsWith("http://") || uri.startsWith("https://")) {
                bytes = TLDLoader.getTLDFromJars(basedir, uri);
                if (bytes != null) {
                    cache.put(uri, bytes);
                    return new ByteArrayInputStream(bytes);
                }
                URL url = new URL(uri);
                InputStream in3 = url.openStream();
                cache.put(uri, HTMLUtil.readStream(in3));
            } else {
                File file = new File(basedir, uri);
                FileInputStream in4 = new FileInputStream(file);
                cache.put(uri, HTMLUtil.readStream(in4));
            }
        }
        byte[] bytes = (byte[])cache.get(uri);
        return new ByteArrayInputStream(bytes);
    }

    private static Map getPreferenceTLD() {
        HashMap<String, String> map = new HashMap<String, String>();
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        String[] uri = store.getString("__pref_tld_uri").split("\n");
        String[] path = store.getString("__pref_tld_path").split("\n");
        int i = 0;
        while (i < uri.length) {
            if (!uri[i].trim().equals("") && !path[i].trim().equals("")) {
                map.put(uri[i].trim(), path[i].trim());
            }
            ++i;
        }
        return map;
    }

    private static byte[] getTLDFromWebXML(File basedir, String uri) {
        File webXML = new File(basedir, "/WEB-INF/web.xml");
        if (webXML.exists() && webXML.isFile()) {
            try {
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse((InputStream)new FileInputStream(webXML));
                FuzzyXMLNode[] nodes = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/web-app/taglib|/web-app/jsp-config/taglib");
                int i = 0;
                while (i < nodes.length) {
                    FuzzyXMLElement element = (FuzzyXMLElement)nodes[i];
                    String taglibUri = HTMLUtil.getXPathValue(element, "/taglib-uri/child::text()");
                    String taglibLoc = HTMLUtil.getXPathValue(element, "/taglib-location/child::text()");
                    if (uri.equals(taglibUri)) {
                        if (taglibLoc != null && taglibLoc.endsWith(".tld")) {
                            File file = new File(basedir, taglibLoc);
                            return HTMLUtil.readStream(new FileInputStream(file));
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }
        return null;
    }

    private static byte[] getTLDFromJars(File basedir, final String uri) {
        return (byte[])JarAcceptor.accept(basedir, new IJarVisitor(){

            public Object visit(JarFile file, JarEntry entry) throws Exception {
                if (entry.getName().endsWith(".tld")) {
                    byte[] bytes = HTMLUtil.readStream(file.getInputStream(entry));
                    try {
                        FuzzyXMLDocument doc = new FuzzyXMLParser().parse((InputStream)new ByteArrayInputStream(bytes));
                        String nodeURI = HTMLUtil.getXPathValue(doc.getDocumentElement(), "/taglib/uri/child::text()");
                        if (nodeURI != null && uri.equals(nodeURI)) {
                            return bytes;
                        }
                    }
                    catch (Exception ex) {
                        HTMLPlugin.logException(ex);
                    }
                }
                return null;
            }
        });
    }
}

