/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

public class SearchXPathDialog
extends Dialog {
    private Text xpath;
    private Text result;
    private Button button;
    private XMLEditor editor;

    protected SearchXPathDialog(Shell parentShell, XMLEditor editor) {
        super(parentShell);
        this.editor = editor;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setDefaultButton(this.button);
        return control;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(HTMLPlugin.getResourceString("XMLEditor.XPathSearch"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("&XPath:");
        this.xpath = new Text(composite, 2048);
        this.xpath.setLayoutData((Object)new GridData(768));
        this.xpath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SearchXPathDialog.this.button.setEnabled(SearchXPathDialog.this.xpath.getText().length() > 0);
            }
        });
        this.button = new Button(composite, 8);
        this.button.setText(HTMLPlugin.getResourceString("Button.Search"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String query = SearchXPathDialog.this.xpath.getText();
                String xml = SearchXPathDialog.this.editor.getHTMLSource();
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(xml);
                try {
                    FuzzyXMLNode[] nodes = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)query);
                    StringBuffer sb = new StringBuffer();
                    sb.append("XPath: " + query + "\n");
                    sb.append("----\n");
                    int i = 0;
                    while (i < nodes.length) {
                        sb.append(String.valueOf(nodes[i].toXMLString()) + "\n");
                        ++i;
                    }
                    SearchXPathDialog.this.result.setText(sb.toString());
                }
                catch (Exception ex) {
                    SearchXPathDialog.this.result.setText(ex.toString());
                }
                SearchXPathDialog.this.xpath.setFocus();
            }
        });
        this.button.setEnabled(false);
        this.result = new Text(composite, 2818);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.result.setLayoutData((Object)gd);
        this.result.setEditable(false);
        this.result.setBackground(Display.getDefault().getSystemColor(1));
        return composite;
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }
}

