/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDParseException;
import com.wutka.dtd.DTDParser;
import com.wutka.dtd.DTDSequence;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.xmleditor.editors.ClassNameAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

public class XMLAssistProcessor
extends HTMLAssistProcessor {
    private List tagList = new ArrayList();
    private Map nsTagListMap = new HashMap();
    private XMLEditor editor;
    private IFileEditorInput input;
    private ClassNameAssistProcessor classNameAssistant = new ClassNameAssistProcessor();

    public void update(HTMLSourceEditor editor, String source) {
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            this.input = (IFileEditorInput)editor.getEditorInput();
        }
        if (editor instanceof XMLEditor) {
            this.editor = (XMLEditor)editor;
        }
    }

    public void updateDTDInfo(Reader in) {
        this.tagList.clear();
        try {
            DTDParser parser = new DTDParser(in);
            DTD dtd = parser.parse();
            Object[] obj = dtd.getItems();
            int i = 0;
            while (i < obj.length) {
                if (obj[i] instanceof DTDElement) {
                    DTDElement element = (DTDElement)obj[i];
                    String name = element.getName();
                    DTDItem item = element.getContent();
                    boolean hasBody = true;
                    if (item instanceof DTDEmpty) {
                        hasBody = false;
                    }
                    TagInfo tagInfo = new TagInfo(name, hasBody);
                    Iterator ite = element.attributes.keySet().iterator();
                    if (item instanceof DTDSequence) {
                        DTDSequence seq = (DTDSequence)item;
                        this.setChildTagName(tagInfo, seq.getItem());
                    } else {
                        boolean cfr_ignored_0 = item instanceof DTDMixed;
                    }
                    while (ite.hasNext()) {
                        String attrName = (String)ite.next();
                        DTDAttribute attr = element.getAttribute(attrName);
                        DTDDecl decl = attr.getDecl();
                        boolean required = false;
                        if (decl == DTDDecl.REQUIRED) {
                            required = true;
                        }
                        AttributeInfo attrInfo = new AttributeInfo(attrName, true, 0, required);
                        tagInfo.addAttributeInfo(attrInfo);
                        Object attrType = attr.getType();
                        if (attrType instanceof DTDEnumeration) {
                            DTDEnumeration dtdEnum = (DTDEnumeration)attrType;
                            String[] items = dtdEnum.getItems();
                            int j = 0;
                            while (j < items.length) {
                                attrInfo.addValue(items[j]);
                                ++j;
                            }
                            continue;
                        }
                        if (attrType.equals("ID")) {
                            attrInfo.setAttributeType(6);
                            continue;
                        }
                        if (attrType.equals("IDREF")) {
                            attrInfo.setAttributeType(7);
                            continue;
                        }
                        if (!attrType.equals("IDREFS")) continue;
                        attrInfo.setAttributeType(8);
                    }
                    this.tagList.add(tagInfo);
                }
                ++i;
            }
        }
        catch (DTDParseException parser) {
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public void updateXSDInfo(String uri, Reader in) {
        try {
            SchemaGrammar grammer = (SchemaGrammar)new XMLSchemaLoader().loadGrammar(new XMLInputSource(null, null, null, in, null));
            String targetNS = grammer.getTargetNamespace();
            this.nsTagListMap.put(targetNS, new ArrayList());
            List tagList = (List)this.nsTagListMap.get(targetNS);
            XSNamedMap map = grammer.getComponents((short)2);
            int i = 0;
            while (i < map.getLength()) {
                XSElementDeclaration element = (XSElementDeclaration)map.item(i);
                this.parseXSDElement(tagList, element);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseXSDElement(List tagList, XSElementDeclaration element) {
        TagInfo tagInfo = new TagInfo(element.getName(), true);
        if (tagList.contains(tagInfo)) {
            return;
        }
        tagList.add(tagInfo);
        XSTypeDefinition type = element.getTypeDefinition();
        if (type instanceof XSComplexTypeDefinition) {
            XSParticle particle = ((XSComplexTypeDefinition)type).getParticle();
            if (particle != null) {
                XSTerm term = particle.getTerm();
                if (term instanceof XSElementDeclaration) {
                    this.parseXSDElement(tagList, (XSElementDeclaration)term);
                    tagInfo.addChildTagName(((XSElementDeclaration)term).getName());
                }
                if (term instanceof XSModelGroup) {
                    this.parseXSModelGroup(tagInfo, tagList, (XSModelGroup)term);
                }
            }
            XSObjectList attrs = ((XSComplexTypeDefinition)type).getAttributeUses();
            int i = 0;
            while (i < attrs.getLength()) {
                XSAttributeUse attrUse = (XSAttributeUse)attrs.item(i);
                XSAttributeDeclaration attr = attrUse.getAttrDeclaration();
                AttributeInfo attrInfo = new AttributeInfo(attr.getName(), true, 0, attrUse.getRequired());
                tagInfo.addAttributeInfo(attrInfo);
                ++i;
            }
        }
    }

    private void parseXSModelGroup(TagInfo tagInfo, List tagList, XSModelGroup term) {
        XSObjectList list = term.getParticles();
        int i = 0;
        while (i < list.getLength()) {
            XSObject obj = list.item(i);
            if (obj instanceof XSParticle) {
                XSTerm term2 = ((XSParticle)obj).getTerm();
                if (term2 instanceof XSElementDeclaration) {
                    this.parseXSDElement(tagList, (XSElementDeclaration)term2);
                    tagInfo.addChildTagName(((XSElementDeclaration)term2).getName());
                }
                if (term2 instanceof XSModelGroup) {
                    this.parseXSModelGroup(tagInfo, tagList, (XSModelGroup)term2);
                }
            }
            ++i;
        }
    }

    private void setChildTagName(TagInfo tagInfo, DTDItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof DTDName) {
                DTDName dtdName = (DTDName)items[i];
                tagInfo.addChildTagName(dtdName.getValue());
            } else if (items[i] instanceof DTDChoice) {
                DTDChoice dtdChoise = (DTDChoice)items[i];
                this.setChildTagName(tagInfo, dtdChoise.getItem());
            }
            ++i;
        }
    }

    protected boolean supportTagRelation() {
        return true;
    }

    protected AssistInfo[] getAttributeValues(String tagName, String value, AttributeInfo info) {
        if (info.getAttributeType() == 7 || info.getAttributeType() == 8) {
            return super.getAttributeValues(tagName, value, info);
        }
        String[] values = info.getValues();
        if (values.length == 0) {
            return this.getClassAttributeValues(value, info.getAttributeName());
        }
        AssistInfo[] infos = new AssistInfo[values.length];
        int i = 0;
        while (i < infos.length) {
            infos[i] = new AssistInfo(values[i]);
            ++i;
        }
        return infos;
    }

    protected AssistInfo[] getClassAttributeValues(String value, String attrName) {
        if (this.input == null || this.editor == null || value.length() == 0) {
            return new AssistInfo[0];
        }
        String[] classNameAttributes = this.editor.getClassNameAttributes();
        int i = 0;
        while (i < classNameAttributes.length) {
            if (attrName.equals(classNameAttributes[i])) {
                return this.classNameAssistant.getClassAttributeValues(this.input.getFile(), value);
            }
            ++i;
        }
        return new AssistInfo[0];
    }

    protected List getTagList() {
        ArrayList<TagInfo> list = new ArrayList<TagInfo>();
        list.addAll(this.tagList);
        FuzzyXMLElement element = this.getOffsetElement();
        HashMap nsPrefixMap = new HashMap();
        this.getNamespace(nsPrefixMap, element);
        Iterator ite = this.nsTagListMap.keySet().iterator();
        while (ite.hasNext()) {
            String uri = (String)ite.next();
            String prefix = (String)nsPrefixMap.get(uri);
            if (prefix == null || prefix.equals("")) {
                list.addAll((List)this.nsTagListMap.get(uri));
                continue;
            }
            List nsTagList = (List)this.nsTagListMap.get(uri);
            int i = 0;
            while (i < nsTagList.size()) {
                TagInfo tagInfo = (TagInfo)nsTagList.get(i);
                list.add(this.createPrefixTagInfo(tagInfo, prefix));
                ++i;
            }
        }
        return list;
    }

    private TagInfo createPrefixTagInfo(TagInfo tagInfo, String prefix) {
        TagInfo newTagInfo = new TagInfo(String.valueOf(prefix) + ":" + tagInfo.getTagName(), tagInfo.hasBody());
        AttributeInfo[] attrInfos = tagInfo.getAttributeInfo();
        int i = 0;
        while (i < attrInfos.length) {
            AttributeInfo newAttrInfo = new AttributeInfo(String.valueOf(prefix) + ":" + attrInfos[i].getAttributeName(), true, 0, attrInfos[i].isRequired());
            newTagInfo.addAttributeInfo(newAttrInfo);
            ++i;
        }
        String[] children = tagInfo.getChildTagNames();
        int i2 = 0;
        while (i2 < children.length) {
            newTagInfo.addChildTagName(String.valueOf(prefix) + ":" + children[i2]);
            ++i2;
        }
        return newTagInfo;
    }

    private void getNamespace(Map map, FuzzyXMLElement element) {
        FuzzyXMLAttribute[] attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].getName().startsWith("xmlns")) {
                String name = attrs[i].getName();
                String prefix = "";
                if (name.indexOf(":") >= 0) {
                    prefix = name.substring(name.indexOf(":") + 1);
                }
                if (map.get(attrs[i].getValue()) == null) {
                    map.put(attrs[i].getValue(), prefix);
                }
            }
            ++i;
        }
        if (element.getParentNode() != null) {
            this.getNamespace(map, (FuzzyXMLElement)element.getParentNode());
        }
    }

    protected TagInfo getTagInfo(String name) {
        List tagList = this.getTagList();
        int i = 0;
        while (i < tagList.size()) {
            TagInfo info = (TagInfo)tagList.get(i);
            if (info.getTagName().equals(name)) {
                return info;
            }
            ++i;
        }
        return new XMLTagInfo(name);
    }

    private class XMLTagInfo
    extends TagInfo {
        public XMLTagInfo(String tagName) {
            super(tagName, true);
        }

        public AttributeInfo getAttributeInfo(String name) {
            AttributeInfo attrInfo = new AttributeInfo(name, true);
            return attrInfo;
        }
    }
}

