package net.sf.amateras.sastruts;

import java.util.ArrayList;
import java.util.List;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import net.sf.amateras.sastruts.bean.PropertyInfo;
import net.sf.amateras.sastruts.util.WorkbenchUtil;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.jspeditor.editors.IJSPELAssistProcessor;

/**
 * JSP ELでのアクションのフィールド補完機能を提供します。
 * 
 * @author Naoki Takezoe
 */
public class SAStrutsELAssistProcessor implements IJSPELAssistProcessor {

	public AssistInfo[] getCompletionProposals(FuzzyXMLElement element,
			String expression) {
		
		IEditorPart editor = WorkbenchUtil.getActiveEditor();
		IEditorInput input = editor.getEditorInput();
		if(!(input instanceof IFileEditorInput)){
			return null;
		}
		IFile jspFile = ((IFileEditorInput) input).getFile();
		
		FuzzyXMLElement form = SAStrutsUtil.getFormElement(element);
		String action = "";
		if(form != null){
			action = form.getAttributeValue("action");
		}
		
		List<AssistInfo> result = new ArrayList<AssistInfo>();
		IType type = SAStrutsUtil.getAction(jspFile, action);
		
		String[] dim = SAStrutsUtil.splitProperty(expression);
		PropertyInfo prop = SAStrutsUtil.evalProperty(dim, type);
		if(prop != null){
			for(PropertyInfo property: prop.getProperties()){
				result.add(SAStrutsUtil.createAssistInfo(property));
			}
		} else {
			for(PropertyInfo property: SAStrutsUtil.getDisplayProperties(type)){
				result.add(SAStrutsUtil.createAssistInfo(property));
			}
		}
		return result.toArray(new AssistInfo[result.size()]);
	}

}
