package net.sf.amateras.sastruts;

import java.util.ArrayList;
import java.util.List;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import net.sf.amateras.sastruts.bean.PropertyInfo;
import net.sf.amateras.sastruts.util.LogUtil;
import net.sf.amateras.sastruts.util.WorkbenchUtil;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.ui.ISharedImages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.ICustomTagAttributeAssist;
import tk.eclipse.plugin.htmleditor.JavaUtil;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;

/**
 * EclipseHTMLEditor用のカスタムタグ属性のアシスト機能を提供します。
 * 
 * @author Naoki Takezoe
 */
public class SAStrutsTagAttributeAssist implements ICustomTagAttributeAssist {

	public AssistInfo[] getAttributeValues(String tagName, String uri,
			String value, AttributeInfo attrInfo, FuzzyXMLElement element) {
		
		String attributeName = attrInfo.getAttributeName();
		
		IEditorPart editor = WorkbenchUtil.getActiveEditor();
		IEditorInput input = editor.getEditorInput();
		if(!(input instanceof IFileEditorInput)){
			return null;
		}
		IFile jspFile = ((IFileEditorInput) input).getFile();
		
		try {
			// s:formのaction属性
			if((tagName.equals("form") || tagName.equals("link")) && attributeName.equals("action")){
				List<AssistInfo> result = new ArrayList<AssistInfo>();
				String packageRoot = SAStrutsUtil.getRootPackageName(jspFile.getProject());
				if(packageRoot != null){
					IJavaProject project = JavaCore.create(jspFile.getProject());
					for(IPackageFragmentRoot root: project.getPackageFragmentRoots()){
						if(root instanceof JarPackageFragmentRoot){
							// JARファイルは除く
							continue;
						}
						for(IJavaElement fragment: root.getChildren()){
							if(fragment.getElementName().startsWith(packageRoot + ".action")){
								for(ICompilationUnit unit: ((IPackageFragment) fragment).getCompilationUnits()){
									if(unit.getElementName().endsWith("Action.java")){
										String actionPath = fragment.getElementName().substring(
												(packageRoot + ".action").length());
										actionPath = actionPath.replace('.', '/');
										actionPath = actionPath + "/" + unit.getElementName().substring(0, 1).toLowerCase()
											+ unit.getElementName().substring(1).replaceFirst("Action.java", "") + "/";
										
										result.add(createAssistInfo(actionPath, unit));
									}
								}
							}
						}
					}
				}
				return result.toArray(new AssistInfo[result.size()]);
			}
			
			// html:submitのaction属性
			// TODO スーパークラスのメソッドを取得する
			// TODO @Executeがついてるメソッドのみ抽出する
			if(tagName.equals("submit") && attributeName.equals("property")){
				List<AssistInfo> result = new ArrayList<AssistInfo>();
				IType type = SAStrutsUtil.getAction(jspFile, "");
				for(IMethod method: type.getMethods()){
					int flag = method.getFlags();
					if(Flags.isPublic(flag)){
						result.add(createAssistInfo(method));
					}
				}
				return result.toArray(new AssistInfo[result.size()]);
			}
			
			// name属性
			if(attributeName.equals("name") || attributeName.equals("collection")){
				FuzzyXMLElement form = SAStrutsUtil.getFormElement(element);
				String action = "";
				if(form != null){
					action = form.getAttributeValue("action");
				}
				
				List<AssistInfo> result = new ArrayList<AssistInfo>();
				IType type = SAStrutsUtil.getAction(jspFile, action);
				PropertyInfo[] properties = SAStrutsUtil.getDisplayProperties(type);
				for(PropertyInfo property: properties){
					result.add(SAStrutsUtil.createAssistInfo(property));
				}
				
				// 親タグで定義された変数を検索
				FuzzyXMLElement parent = (FuzzyXMLElement) element.getParentNode();
				while(parent != null){
					if(parent.getName().endsWith(":iterate")){
						// Strutsのlogic:iterateの場合
						String id = parent.getAttributeValue("id");
						String name = parent.getAttributeValue("name");
						
						appendNameProposals(result, properties, id, name);
						
//					} else if(parent.getName().endsWith(":forEach")){
//						// JSTLのc:forEachの場合
//						String id = parent.getAttributeValue("var");
//						String name = parent.getAttributeValue("items");
//						name = name.replaceAll("^\\$\\{|\\}$", "");
//						
//						appendNameProposals(result, fields, id, name);
					}
					parent = (FuzzyXMLElement) parent.getParentNode();
				}
				
				return result.toArray(new AssistInfo[result.size()]);
			}
			
			// その他のproperty属性
			if(attributeName.equals("property") || attributeName.equals("labelProperty")){
				FuzzyXMLElement form = SAStrutsUtil.getFormElement(element);
				String action = "";
				if(form != null){
					action = form.getAttributeValue("action");
				}
				
				IType type = SAStrutsUtil.getAction(jspFile, action);
				
				if(element.getAttributeValue("collection") != null){
					// collection属性が指定されている場合
					String name = element.getAttributeValue("collection");
					IType fieldType = getPropertyType(type, SAStrutsUtil.getDisplayProperties(type), name);
					if(fieldType != null){
						return getAssistInfos(value, fieldType);
					}
					
				} else if(element.getAttributeValue("name") == null){
					return getAssistInfos(value, type);
					
				} else {
					// name属性が指定されている場合
					IType fieldType = null;
					String name = element.getAttributeValue("name");
					
					for(PropertyInfo property: SAStrutsUtil.getDisplayProperties(type)){
						if(property.name.equals(name)){
							String clazz = JavaUtil.getFullQName(type, property.type);
							fieldType = property.parent.getJavaProject().findType(clazz);
							break;
						}
					}
					// 親タグで定義された変数を検索
					if(fieldType == null){
						FuzzyXMLElement parent = (FuzzyXMLElement) element.getParentNode();
						PropertyInfo[] properties = SAStrutsUtil.getDisplayProperties(type);
						while(parent != null){
							if(parent.getName().endsWith(":iterate")){
								// Strutsのlogic:iterateの場合
								String id = parent.getAttributeValue("id");
								if(id.equals(name)){
									String beanName = parent.getAttributeValue("name");
									
									fieldType = getPropertyType(type, properties, beanName);
								}
//							} else if(parent.getName().endsWith(":forEach")){
//								// JSTLのc:forEachの場合
//								String id = parent.getAttributeValue("var");
//								if(id.equals(name)){
//									String beanName = parent.getAttributeValue("items");
//									beanName = beanName.replaceAll("^\\$\\{|\\}$", "");
//									
//									fieldType = getFieldType(type, fields, beanName);
//								}
							}
							parent = (FuzzyXMLElement) parent.getParentNode();
						}
					}

					if(fieldType != null){
						return getAssistInfos(value, fieldType);
					}
				}
				
				//return result.toArray(new AssistInfo[result.size()]);
			}
		} catch(Exception ex){
			LogUtil.log(Activator.getDefault(), ex);
		}
		
		return null;
	}

	private AssistInfo[] getAssistInfos(String value, IType fieldType) {
		List<AssistInfo> result = new ArrayList<AssistInfo>();
		String[] dim = SAStrutsUtil.splitProperty(value);
		PropertyInfo prop = SAStrutsUtil.evalProperty(dim, fieldType);
		if(prop != null){
			for(PropertyInfo property: prop.getProperties()){
				result.add(SAStrutsUtil.createAssistInfo(property));
			}
		} else {
			for(PropertyInfo property: SAStrutsUtil.getDisplayProperties(fieldType)){
				result.add(SAStrutsUtil.createAssistInfo(property));
			}
		}
		return result.toArray(new AssistInfo[result.size()]);
	}

	private IType getPropertyType(IType type, PropertyInfo[] properties, String beanName) throws JavaModelException {
		for(PropertyInfo property: properties){
			if(beanName.equals(property.name)){
				String clazz = JavaUtil.getFullQName(type, SAStrutsUtil.getElementType(property.type));
				return type.getJavaProject().findType(clazz);
			}
		}
		return null;
	}

	private void appendNameProposals(List<AssistInfo> result, PropertyInfo[] properties,
			String id, String name) throws JavaModelException {
		for(PropertyInfo property: properties){
			if(name.equals(property.name)){
				String typeName = SAStrutsUtil.getElementType(property.type);
				
				result.add(new AssistInfo(id, id + " - " + typeName, 
						JavaUI.getSharedImages().getImage(ISharedImages.IMG_FIELD_PUBLIC)));
				break;
			}
		}
	}
	
	/**
	 * アクションの補完情報を作成します。
	 */
	private static AssistInfo createAssistInfo(String actionPath, ICompilationUnit unit){
		try {
			IType type = unit.getAllTypes()[0];
			AssistInfo assistInfo = new AssistInfo(
					actionPath,
					actionPath + " - " + type.getFullyQualifiedName(),
					JavaUI.getSharedImages().getImage(ISharedImages.IMG_OBJS_CLASS),
					HTMLUtil.extractJavadoc(type, null));
			
			return assistInfo;
		} catch(Exception ex){
			LogUtil.log(Activator.getDefault(), ex);
		}
		return null;
	}
	
	/**
	 * メソッドの補完情報を作成します。
	 */
	private static AssistInfo createAssistInfo(IMethod method){
		try {
			AssistInfo assistInfo = new AssistInfo(
					method.getElementName(),
					method.getElementName() + " - " + method.getDeclaringType().getElementName(),
					JavaUI.getSharedImages().getImage(ISharedImages.IMG_OBJS_PUBLIC),
					HTMLUtil.extractJavadoc(method, null));
			
			return assistInfo;
		} catch(Exception ex){
			LogUtil.log(Activator.getDefault(), ex);
		}
		return null;
	}

}
