package net.sf.amateras.sastruts.bean;

import net.sf.amateras.sastruts.SAStrutsUtil;
import net.sf.amateras.sastruts.util.StringUtil;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;

import tk.eclipse.plugin.htmleditor.JavaUtil;

/**
 * JSPからさん章可能なプロパティをあらわすオブジェクトです。
 * 
 * @author Naoki Takezoe
 */
public class PropertyInfo {
	
	/**
	 * このプロパティが定義されているクラス
	 */
	public IType parent;
	
	/**
	 * プロパティ名
	 */
	public String name;
	
	/**
	 * プロパティの型名
	 */
	public String type;
	
	/**
	 * プレフィックス
	 */
	public String prefix;
	
	/**
	 * プロパティに対応するJava要素（IFieldもしくはIMethod）
	 */
	public IMember element;
	
	public PropertyInfo(IType parent, String name, String type, IMember element){
		this.parent = parent;
		this.name = name;
		this.type = type;
		this.element = element;
	}
	
	public String getNameWithPrefix(){
		if(StringUtil.isEmpty(prefix)){
			return name;
		}
		return prefix + "." + name;
	}
	
	/**
	 * ネストしたプロパティを取得します。
	 * 
	 * @return ネストしたプロパティ
	 */
	public PropertyInfo[] getProperties(){
		try {
			String clazz = JavaUtil.getFullQName(parent, type);
			IType propertyType = parent.getJavaProject().findType(clazz);
			PropertyInfo[] properties = SAStrutsUtil.getDisplayProperties(propertyType);
			for(PropertyInfo property: properties){
				if(StringUtil.isEmpty(prefix)){
					property.prefix = name;
				} else {
					property.prefix = prefix + "." + name;
				}
			}
			return properties;
			
		} catch(Exception ex){
		}
		return new PropertyInfo[0];
	}
	
}
