require "phi"  ; include Phi
require "rdb"  ; include RDB

module Phi
  class Strings
    def as_hash=(hash)
      self.text = hash.collect{|arr| arr.join('=') }.join("\n")
      return hash
    end
    def as_hash  # [ "key1=val1" , "key2=val2" , ... ]
      ret = {}
      self.each{|s| ret[$1] = $2 if /^(.*)=(.*)$/ =~ s }
      return ret
    end
    alias to_hash as_hash
 end
end

DEFAULT_PARAMS_FOR_INTERBASE = {
  "DriverName"    => "Interbase",
  "BlobSize"      => "-1",
  "CommitRetain"  => "False",
  "Database"      => "database.gdb",
  "ErrorResourceFile" => "",
  "LocaleCode"    => "0000",
  "Password"      =>"",
  "RoleName"      =>"RoleName",
  "ServerCharSet" => "",
  "SQLDialect"    =>"1",
  "Interbase TransIsolation" => "ReadCommited",
  "User_Name"     => "",
  "WaitOnLocks"   => "True",
}

  ## from .. c:/program files/common files/borland shared/dbexpress/dbxdrivers.ini

def interbase_connection
  connection = SQLConnection.new
  connection.driver_name = "InterBase"
  connection.vendor_lib="GDS32.DLL"
  connection.library_name="dbexpint.dll"
  connection.get_driver_func="getSQLDriverINTERBASE"
  connection.params.as_hash = DEFAULT_PARAMS_FOR_INTERBASE
  return connection
end

hash = DEFAULT_PARAMS_FOR_INTERBASE.dup
hash["Database"] = "C:\\Program Files\\Common Files\\Borland Shared\\Data\\employee.gdb"
hash["Password"]  = "masterkey"
hash["User_Name"] = "sysdba"

connection = interbase_connection
connection.connection_name = "IBLocal_xx"
connection.login_prompt = false
connection.params.as_hash = hash

query = SQLClientDataSet.new
query.db_connection = connection
query.command_type = CT_QUERY
query.command_text = "select * from country"
query.open
query.display
query.save_to_file( "c:/1.xml", DF_XML )

raise
