require 'phi'

# [Delphi:77890]
# http://leed.issp.u-tokyo.ac.jp/~takeuchi/delphi/tree/077/077890.html#here

module Phi

  # FROM Messages.pas:
  WM_USER             = 0x0400

  # FROM C:/PROGRA~1/Borland/Delphi6/Source/Rtl/Win/CommCtrl.pas[HINST_COMMCTRL]

  TBN_FIRST                = 0-700  ##     { toolbar }
  TBN_LAST                 = 0-720

  TB_SAVERESTOREA          = WM_USER + 26
  TB_ADDSTRINGA            = WM_USER + 28
  TB_GETBUTTONTEXTA        = WM_USER + 45
  TBN_GETBUTTONINFOA       = TBN_FIRST-0
  TB_SAVERESTOREW          = WM_USER + 76
  TB_ADDSTRINGW            = WM_USER + 77
  TB_GETBUTTONTEXTW        = WM_USER + 75
  TBN_GETBUTTONINFOW       = TBN_FIRST-20
  TB_SAVERESTORE          = TB_SAVERESTOREA
  TB_ADDSTRING            = TB_ADDSTRINGA
  TB_GETBUTTONTEXT        = TB_GETBUTTONTEXTA
  TBN_GETBUTTONINFO       = TBN_GETBUTTONINFOA
  TB_CUSTOMIZE            = WM_USER + 27
  TB_GETITEMRECT          = WM_USER + 29
  TB_BUTTONSTRUCTSIZE     = WM_USER + 30
  TB_SETBUTTONSIZE        = WM_USER + 31
  TB_SETBITMAPSIZE        = WM_USER + 32
  TB_AUTOSIZE             = WM_USER + 33
  TB_GETTOOLTIPS          = WM_USER + 35
  TB_SETTOOLTIPS          = WM_USER + 36
  TB_SETPARENT            = WM_USER + 37
  TB_SETROWS              = WM_USER + 39
  TB_GETROWS              = WM_USER + 40
  TB_SETCMDID             = WM_USER + 42
  TB_CHANGEBITMAP         = WM_USER + 43
  TB_GETBITMAP            = WM_USER + 44
  TB_REPLACEBITMAP        = WM_USER + 46
  TB_SETINDENT            = WM_USER + 47
  TB_SETIMAGELIST         = WM_USER + 48
  TB_GETIMAGELIST         = WM_USER + 49
  TB_LOADIMAGES           = WM_USER + 50
  TB_GETRECT              = WM_USER + 51  ##{ wParam is the Cmd instead of index }
  TB_SETHOTIMAGELIST      = WM_USER + 52
  TB_GETHOTIMAGELIST      = WM_USER + 53
  TB_SETDISABLEDIMAGELIST = WM_USER + 54
  TB_GETDISABLEDIMAGELIST = WM_USER + 55
  TB_SETSTYLE             = WM_USER + 56
  TB_GETSTYLE             = WM_USER + 57
  TB_GETBUTTONSIZE        = WM_USER + 58
  TB_SETBUTTONWIDTH       = WM_USER + 59
  TB_SETMAXTEXTROWS       = WM_USER + 60
  TB_GETTEXTROWS          = WM_USER + 61
  TB_GETOBJECT            = WM_USER + 62  ##// wParam == IID, lParam void **ppv
  TB_GETHOTITEM           = WM_USER + 71
  TB_SETHOTITEM           = WM_USER + 72  ##// wParam == iHotItem
  TB_SETANCHORHIGHLIGHT   = WM_USER + 73  ##// wParam == TRUE/FALSE
  TB_GETANCHORHIGHLIGHT   = WM_USER + 74
  TB_MAPACCELERATORA      = WM_USER + 78  ##// wParam == ch, lParam int * pidBtn

  IDB_STD_SMALL_COLOR     = 0
  IDB_STD_LARGE_COLOR     = 1
  IDB_VIEW_SMALL_COLOR    = 4
  IDB_VIEW_LARGE_COLOR    = 5
  IDB_HIST_SMALL_COLOR    = 8
  IDB_HIST_LARGE_COLOR    = 9

  HINST_COMMCTRL = -1  ##  HINST_COMMCTRL = THandle(-1)

end

form = Phi::Form.new
tool_bar  = Phi::ToolBar.new form
tool_bar.images = Phi::ImageList.new
tool_bar.images.clear
tool_bar.images.masked = true

tool_bar.perform( Phi::TB_LOADIMAGES, Phi::IDB_STD_SMALL_COLOR,  Phi::HINST_COMMCTRL )
tool_bar.perform( Phi::TB_LOADIMAGES, Phi::IDB_HIST_SMALL_COLOR, Phi::HINST_COMMCTRL )
tool_bar.perform( Phi::TB_LOADIMAGES, Phi::IDB_VIEW_SMALL_COLOR, Phi::HINST_COMMCTRL )

list_view = Phi::ListView.new form
list_view.view_style = Phi::VS_SMALL_ICON
list_view.align = Phi::AL_CLIENT
list_view.small_images = tool_bar.images
list_view.large_images = tool_bar.images

tool_bar.images.count.times{|i|
    item = list_view.items.add
    item.image_index = i
    item.caption = i.to_s
}
form.show
Phi.mainloop
