=begin Pi
1. module Opname
Zq̋L\LƖO\L𑊌݂ɕϊB
\bhɂΉB
1.1. 萔
: PATTERN_OP : String
  ZqɃ}b`p^[
: PATTERN_METHOD : String
  \bhɃ}b`p^[
: RE_OP : Regexp
  ZqɃ}b`鐳K\
: RE_METHOD : Regexp
  \bhɃ}b`鐳K\
  %c:'self' + op% `ɂΉB
: NAME2OP : Hash
  Zq̖O\LL[ƂL\LlƂnbV
: OP2NAME : Hash
  %c:== NAME2OP.invert%
1.1. ֐
: op2name(op) : String
  Zq̋L\L疼O\L߂B
  %c:[]%  %c:/\[.*?\]/% Ƃĕ]B
: name2op(name) : String
  Zq̖O\LL\L߂B
: method_len(s) : Fixnum
  ̐擪烁\bhoA̒ԂB
: method_str(s) : String
  ̐擪烁\bhoB
1.1. 
1.1.1. %c:'self' + op% `
rbdoc Ř`łāAȂB
  Ⴆ
    %c:: self[n]%
    %c:: self===%
  
    %c:: [n]%
    %c:: ===%
  ƏׂłB
1.1. oO
* %c:op2name%
  %c:'self'% n܂郁\bh %c:'self'% ̂ĂĂ܂B
=end

module Opname
  PATTERN_OP = '\[.*?\]=?|[<=>\+\-\*\/%&|~^@\?!/]*'
  PATTERN_METHOD = '[\w\d]+[?!=]?|' << "(self)?(#{PATTERN_OP})"
  
  RE_OP = Regexp.compile('^' << PATTERN_OP)
  RE_METHOD = Regexp.compile('^' << PATTERN_METHOD)
  
  NAME2OP = Hash[*%w[
	aset	[]=
	aref	[]
	cmp	<=>
	le	<=
	shl	<<
	lt	<
	ge	>=
	shr	>>
	gt	>
	eqq	===
	eq	==
	match	=~
	assign	=
	uplus	+@
	plus	+
	uminus	-@
	minus	-
	pow	**
	times	*
	div	/
	mod	%
	and	&
	or	|
	not	~
	xor	^
  ]]
  OP2NAME = NAME2OP.invert
  
  module_function
  
  def op2name(op)
    case op
    when /^self/
      op2name($')
    when /^[\w\d]+([?!=]?)/
      cap = $&
      if $1.empty?
        op
      else
        op.chop <<
        case $1
        when '?'; '_p'
        when '!'; '_bang'
        when '='; '_asgn'
        end
      end
    when /^\[.*?\](=?)/
      '_' << if $1 == '=' then 'aset' else 'aref' end
    else
      name = OP2NAME[op] || ''
      '_' << name
    end
  end
  
  def name2op(name)
    case name
    when /^_/
      NAME2OP[name[1..-1]]
    when /_(\w+)$/
      $` +
      case $1
      when 'p'; '?'
      when 'bang'; '!'
      when 'asgn'; '='
      else $1
      end
    else
      name
    end
  end
  
  def method_len(s)
    if s.nil?
      return 0
    end
    len = 0
    case s[len]
    when ?[
      len = s.index(']')+1
      len+= 1 if s[len] == ?=
    when ?<
      len+= 1
      case s[len]
      when ?=
        len+= 1
        case s[len]
        when ?>; len+= 1
        end
      when ?<; len+= 1
      end
    when ?>
      len+= 1
      case s[len]
      when ?=, ?>; len+= 1
      end
    when ?=
      len+= 1
      case s[len]
      when ?=
        len+= 1
        case s[len]
        when ?=; len+= 1
        end
      when ?~; len+= 1
      end
    when ?+
      len+= 1
      case s[len]
      when ?@; len+= 1
      end
    when ?*
      len+= 1
      case s[len]
      when ?*; len+= 1
      end
    when ?-
      len+= 1
      case s[len]
      when ?@; len+= 1
      end
    when ?/, ?%, ?&, ?|, ?~, ?^; len+= 1
    else
      case s
      when /^self/
        len = method_len($') + 4
      when /^[\w\d]+[?!=]?/
        len = $&.length
      end
    end
    len
  end
  
  def method_str(s)
    s[0...method_len(s)]
  end
  
end

if $0 == __FILE__
  while line = gets
    line.scan(/(\S+?)?#(\S+)?/){|c,m|
      str = Opname.method_str(m)
      name = Opname.op2name(str)
      op = Opname.name2op(name)
      p [str, name, op]
    }
  end
end
