#!/usr/bin/env ruby

module PiIndex

  INDEX = 'index.pirf'

  def load(filename = INDEX)
    File.open(filename, 'r') do |f|
      return Marshal.load(f)
    end
  end

  module_function :load

  class SearchError < StandardError
  end

  class Index

    def initialize(table)
      @table = table
    end


    # mark̓_~[(refeɍ킹邽)
    def search(class_name, method_name, mark)
      if @table[class_name].nil? or @table[class_name][method_name].nil?
	raise SearchError, "no such method or class: #{class_name} #{method_name}"
      else
	@table[class_name][method_name]
      end
    end
    
    def table
      @table
    end

  end

end

